#!/usr/local/bin/perl
#
# $Id: firstlogin.pl,v 1.1 2004/05/26 20:26:32 visick Exp $
#
# firstlogin.pl - Shell for new users
#
# Copyright (C) 2002 Steven Barrus
# Copyright (C) 2002 Dana Dahlstrom
# Copyright (C) 2002 Robert Ricci
# Copyright (C) 2002 Spencer Visick
#
# See the AUTHORS file for contact info
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


# This is a big hack to get around nscd caching the shell
# uncomment if you have problems
#$user = (getpwuid($>))[0];
#$shell = (split ' ', `/usr/local/bin/ldapsearch -LLL -h ldap -b $config{userbase} "(uid=$user)" | /usr/local/bin/grep '^loginShell:'`)[1];
#exec $shell "-$shell" unless ($shell eq '/usr/bin/firstlogin');

use Term::ReadLine;
require 'usertools.ph';

$default_shell = "/bin/tcsh";

&complexity_lecture;
&change_password;
&secrecy_lecture;
&change_shell;
exec $default_shell "-$default_shell";


sub change_password {

  print "Current ";

  # Connect to the LDAP server
  $conn = ldap_connect() || exit(1);

  my $search = "(uid=" . $user . ")";
  
  $mesg = $conn->search(base => $config{userbase}, filter => $search);
  $entry = $mesg->entry() or 
      die "ERROR: Unable to find LDAP entry - please contact the operators\n";

  $mesg = $entry->replace('userpassword' => get_new_pass());

  $mesg = $entry->update($conn);
  die "An error occured while saving your new password! Please contact\n",
      "the operators. The error was: ", $mesg->error if $mesg->code;
}

sub change_shell {
  $entry->replace('loginshell' => $default_shell);

  $mesg = $entry->update($conn);
  die "An error occured while changing your shell! Please contact\n",
      "the operators. The error was: ", $mesg->error if $mesg->code;
}

sub complexity_lecture {

print <<END;

			Welcome to the CADE Lab!

Since this account is being logged in for the first time, we require
that the password be changed.

Choosing a good password is important: there are freely available
programs on the Internet that try to guess user passwords and do an
extremely efficient job. We know because we've run them.

If someone can guess your password, they can access your e-mail, your
files and other data, and even attempt to break into other accounts and
other systems using your account. This can have far-reaching and very
serious consequences. We ask that you use the following guidelines for
choosing a strong password.

END
print "Press Return to continue..."; <>;

print <<END;

Do Choose

  * Something you can remember with at least six characters.
  * A combination of upper and lowercase letters, numbers, and symbols.
  * An abrrevietaion of a saying. For example, "L!isn!" ("Live! It's
    Saturday Night").
  * Something obscure. For instance you might deliberately misspell a
    term or use an odd character in an otherwise familiar term, such as
    "phnybon" instead of "funnybone".
  * Two short words, combined with a special character or number, like
    "egg7Flew".

Don't Choose

  * Anything based on your name, even if you reverse it or add numbers.
  * Anything based on your username.
  * Anything based on the name of a relative, friend, pet, etc.
  * Your phone or office number, address, birthday, anniversary,
    license-plate number, social security number, or any
    password with just numbers.
  * Names or words from popular culture, e.g., spock, sleepy, gandalf.

END
print "Press Return to continue..."; <>;

print <<END;

The command to change your password is "passwd"; you can run it at any
time, but this time we'll run it for you. You'll need to type your
current password first before you can set a new one---this way if you
forget to log out, someone else can't change it for you.

END
}

sub secrecy_lecture {

print <<END;

Now that you've chosen a (hopefully) secure password, don't tell it to
anyone else, even someone you trust. Doing so is a violation of the
university's usage agreement, and it puts your account at risk.

If you must write down your password to help memorize it, make sure to
guard it closely and destroy it when you're done. If you forget it,
you can always come in with photo ID and we'll change it for you.

You will now be returned to your regularly scheduled programming.
Thanks for using the CADE! 

END
print "Press Return to continue..."; <>;
}
