#!/usr/bin/perl
# vdrip.pl - Perl version - Utility to generate script files to rip
# MPEG2 videos (ts or ps) with mencoder(mplayer) in standard .avi files
# mpeg4/divx format.
# Tested with mplayer/mencoder v.1.0rc1 / v1.0rc2 / SVN version
# (GNU/Linux Ubuntu 7.10 - 8.04 - 8.10/XFCE - 9.04 - 9.10 -
# Ulite/Ubuntu 8.04/LXDE and Debian 5.0.2/Gnome ...)
# On Debian, mencoder does not install with a single "apt-get install":
# you must use Debian multimedia repository and delete the default installed
# Debian mplayer package) - see web page: http://debian-multimedia.org/
#########################################################################
# VDRIP, vdrip.pl - Video ripping of mpeg2 files in mpeg4 .avi files	#
#	Copyright © 2008,2009 Pikwix					#
# This program is free software: you can redistribute it and/or modify	#
# it under the terms of the GNU General Public License as published by	#
# the Free Software Foundation, either version 3 of the License, or	#
# (at your option) any later version.					#
#									#
# This program is distributed in the hope that it will be useful,	#
# but WITHOUT ANY WARRANTY; without even the implied warranty of	#
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the		#
# GNU General Public License for more details.				#
#									#
# You should have received a copy of the GNU General Public License"	#
# along with this program.  If not, see <http://www.gnu.org/licenses/>  #
#									#
# To contact the author of the vdrip.pl project, send a mail to:	#
#	vdrip.pl@gmail.com						#
#									#
# Type `perl vdrip.pl -license' or see the text at the end of this file.#
# Also it can be found in file "COPYING"				#
#									#
# Version and Copyright stamps:	c9a839dc93c71cb5785d9d0ae68a7a98        #
#########################################################################
#
### History of main releases (see more details in: Documentation/RELEASE.txt file) :
# 20091218 pkx:	Second beta release: vdrip.pl19s-20091218 (any pre-20 versions are beta,see $ver)
# 20090817 pkx:	First offical beta release: vdrip.pl19j-20090817 (any pre-20 version are beta,see $ver)
# 20090809 pkx: Extraction of all program changes text from this source(history -> file RELEASE.TXT)
# 20090801 pkx: # 20090802 pkx: simplification phase3: suppress many options/useless code
#		implemented profiles 2,3,4,8 and commands 'ab' 'vb' (audio and video bitrate)
# 20090609 pkx: implemented Black&White movie flag reducing bitrate for sound<1970 at 64kbps(option -bw)
# 20090527 pkx: suppress directory requirements: /mnt/xxx and so, but $HOME/vdripdir $HOME/vdripdone
#		are directories optionally used to store script and ripped files (xxx.sh)
# 20090315 pkx: Licensing text added/changed
# 20090213 pkx: change help text
# 20090201 pkx: simplification phase2(argument) longfilename with spaces support(phase1)
# 20081228 pkx: simplification phase1, many useless commands depreciated: as ac sp sf xi kx - or changed: pv
# 20081102 pkx: tvaddrip-0000.txt is integrated within this file,see explanation and lines at the end.
#
### PREREQUISITES FOR RUNNING
# GNU/Linux
# mandatory: MPlayer,MEncoder,Perl
# optional(may interact with): mediainfo (see: http://mediainfo.sourceforge.net)
#
### ARCHITECTURE History (decisions,simplifications)
# everything by default should be automatic
# no config file /etc/vdrip.conf or ~/.vdrip.conf when first time program is run, nor from a template inserted inside it
# no config file implementation vdrip.cfg or /etc/vdrip.cfg -> this utility must be as simple as possible and user friendly
# no special procedure to install,configurate,and tune
# Minimum requirements only (MPlayer,MEncoder,Perl). Prevent other requirements in the future.
#
### TODO!! TODO!!
#    1. Urgent! I need somebody to work with me about the translations of this
#	program and to review the english text in the README-en.txt file
#    2. localisation of this utility (via xsrctrad.pl or better tool (?getext?)
#	for all messages,documentation,README files to FR,ES,DE,IT,NL,PT,...
#    3. Implement the optimal videobitrate ($optvbitrate,$flvbitrate)
#    4. TEST: xpert command 'ri1' and 'ri2': direct rip of a file,the script is executed at end
#    5. TEST: pagination with $nbligmax=$ENV{'LINES'};
#
### RESOURCES
# Web sites:
# - public web page : http://www.nongnu.org/vdrip/
# - project web page: https://savannah.nongnu.org/projects/vdrip/
# - download vdrip software: http://download.savannah.nongnu.org/releases/vdrip/
# - vdrip-users subscribe to the list: http://lists.nongnu.org/mailman/listinfo/vdrip-users
# Add an abbreviated command in your user .bashrc file to always run it for a better quality
#  and in expert,trace and manual modes (very verbose):
# alias vdrip='perl /path/vdrip.pl -tr -x -m -ab -fm '
#
### WARNING - Avertissements
# BEFORE future implementation:
# - Can we use autoaspect in stead of computing the aspect ratio and preventing to cut video definition?
#   the suggested mplayer/mencoder 'autoaspect' function (is a mencoder option) is:
#   lavcopts=vcodec=mpeg4:autoaspect=1
#   but it is not interoperable with other video players and multimedia boxes.
#
# $tr=0; $flxpert=0; # before publishing
# md5sum and sign tarball to generate at each version to nongnu.savannah.org
# Not standard flags: $flripexec=-1;
#
###########
use strict;
#
my($ver,$verp,$vdrname,$verperl);
$ver="vdrip.pl19s-20091218"; $verp="vdrip.pl"; $verperl="perl vdrip.pl"; $vdrname = "vdrip";
#Variables files,argument
my($dir,@dirp,$fic,$fich,$fichext,$ficglob,@ficlist,$rfi,$rxi);
my($fichsimple,$fichavifile,$fichpath,$fichnopath,$fichnopathext,$fichcurrdir);
my(@vd); # data array containing all general mpeg2 parameters scanned by processheader()
# 1:file size, #2:vid, 	# 3:aud, #4:aspect, #5:VOcfg, (MPEG)12:header aspect(720x576),
#13:code-aspect(2), 	#14:nominal audio rate	    #15:aspect ajust for playing(768x576)
#16,17:computed aspect recommended width and height of file to vdrip
#18:FPS,	#19:nominal video rate
# - Other param.updated when a crop function is run:
# 6:total.nbr.cropdetect, #7=nbr.cropdetect.for #8#9,
# 8:orig.autocrop(cmd=c_),#9:nbr.occ.for vd8, 10,11:memo vd8+9
my($ficroot,$fichscript,$fichvdrip);	# filenames for script generations
my($fichlist,$scriptpass);		# variables for scriptlist processing
my($reperror);				# last reported error/warning (user attention)
my($flauto,$flnocrop,$flripexec);	# flag automatic mode, nocrop option(no movie picture scanning and image cutting),exec rip at end
my($tr,$flxpert);			# trace and advanced mode for experienced users,added 20081101
my($flbw,$flnd,$flprofile);		# force flag black&white movie,no-desinterlace,low-or-fast-clip-motion(clip-video)
my($optabitrate,$optvbitrate);		# force optimal audio/video bitrate (alias 'ab' and 'vb')
my($rateaudio,$ratevideo);		# default/configured rates for the final script.sh
my($fsec,$asiz,$vsiz,$msiz,$avvbr);	# EXPERIMENTAL,file sec,audio/video size,movie theoric sec,average video bitrate
my($goodarg,$noarg,$lgarg,$numarg1,$numarg2);
my($ret,$ii,$MAXvd,$rep);
my($rch,$rac,$rag,$rmp); # return stats: procheader,auto ct,auto ge,manual processcmd
# cmd used to process file
my($dvdnum,$dvdlng,$dvddir,$fictmp);
my($cmdmpl,$cmdmplvo,$cmdmplvohdr,$cmdmen,$cmdlng2,$cmdlng3,$envlng,$cmdkil,$cmdps);
my($cmdman);		# manual command entered by user intervention
# standard crop timer parameter for black band detection
my(@croptimestart,@croptimebig,@croptimesmall,$croptimesmallvalue);
my($currcrop,$currtime,$currduration); # current param to set crop parameter, or playfile,or test file
my($currtimedetect,$currtimeshortdetect);
my(@vdcall);		# list of all cropdetects values for a cropdetect session,vdcall[0]=first cropdetect value
my($MAXtcr,@tcrh,@tcrw,@tcrm); # crop table for height and wide
my($ficsizo,$ficsizm,$mysleep,$prog0,@proclist); # octets/Mib

$tr=0;			# must 0 in the final release, 1=trace/debug mode; 2=experimental DON'T USE!!
$flxpert=0;		# must 0 in the final release
$goodarg=1;		# !NOT-USED! no options strict coherence checks for now
$flauto=1;		# Default mode automatic:generate immediately a script file without user interaction
$flnocrop=0;		# option -nocrop: no picture cutting (black bands are included in final mpeg4 file)
$flripexec=-1;		# to execute automatically the ripping at end(-1:no; 0:sample test; 1:one pass; 2:two passes)
$flbw=0;		# flag black and white movie,to force rip in B&W mode (mencoder gray)
$flnd=0;		# flag no-desinterlace,by default mencoder desinterlace the frames
$flprofile=3;		# default profile, other are:compact,normal,low-fast-motion,clipvideo: 1 2 3 4 and 8 
			# (3=default=normal profile) - 0:no profile,so either: audio/video bitrate has been forced
$rateaudio=128; $ratevideo=860; # default profile values (3=default=normal profile)
$optabitrate=0; $optvbitrate=0; # force optimal audio/video bitrate (alias 'ab' and 'vb', option -ab:xxxx  or -vb:xxxx)
$MAXvd=19;		# size of vd[] array (internal technical MPEG2 data),i=max.indice
$MAXtcr=20;		# size of crop data array (idem)
$dvdnum=1; 		# NOT USED for now,all processing for dvd not yet done
$dvdlng=128;		# NOT USED - idem -
$dvddir="/dev/dvd";	# NOT USED - idem -
$fictmp="_vdripmpl.tmp";#tempo file
$ficroot="$ENV{'HOME'}/vdripdir/"; # script file name,default root name
$fichvdrip="$0";	# script data(fix program sequence to merge),now myself because integrated into this source
$fichlist="$ENV{'HOME'}/vdriplist.sh"; # filename of the list of scripts to execute,to synchro with the script content
$scriptpass=2;		# scriptlist file will force a 2-pass encoding
$reperror="";		# last reporting error in command mode
$cmdmpl=`which mplayer` ; chomp($cmdmpl); # mplayer/mencoder command path
$cmdmplvo=" -msglevel all=5 ";	# mplayer parameter: MUST be -msglevel all=5,don't use default "-vo x11||null" (like before 20091114)
$cmdmplvohdr=" -vo null -ao null -frames 1 -endpos 0:0:1";	# mplayer parameter for processing mpeg2 header
$cmdmen=`which mencoder`; chomp($cmdmen);
$envlng="";		# default environment language,is superseded by system default language (ex:fr)
$cmdlng2="";		# default parameter language ISO - idem - ex:"-alang fr"
$cmdlng3="";		# 3 letters language ISO codes in mplayer/mencoder - idem - ex:"-alang fra"
$cmdkil=`which kill`; chomp($cmdkil);
$cmdps=`which ps`   ; chomp($cmdps);
$cmdman="q";
$mysleep=6;		# time to wait during a crop detection sequence

$prog0 = basenameext($0); # this programme
@croptimestart=qw(00:00:00);		# time cursor in cropdetect at beginning,big:for movie,small:for videoclip
@croptimebig  =qw(4:00 5:00 6:00);	# modif.20081107 (old was: 2:00 4:00 6:00) '2:00' was too close from beginning
@croptimesmall=qw(0:20 0:40 1:00);	# if filesize <600Mo (fix.20080309-v09c)
$croptimesmallvalue=600000000;		# 600 Mb file limit to start using @croptimebig parameters,modif.20090809
$currcrop=""; @vdcall=();		# current cropdetect value,null if none took place;list of all cropdetections
$currtimedetect="00:12:00";		# should be 12 for a long movie to make sure cropping inside the file(bug in mplayer/codec)
$currtimeshortdetect="00:01:00";	# and 00:01:00 for a videoclip
$currtime=$currtimedetect;		# default value for movie
$currduration="00:00:30";		# only for a sample vdrip test
@tcrh=(); @tcrw=(); @tcrm=();		# fill in crop table for height and wide in 8 and 16 multiples for size/ratio ajustements
for ($ii=0; $ii<= $MAXtcr; $ii++) {	# MAXctr=20
  $tcrh[$ii] = 576-($ii*16);		# for crop $ii*8 in height 0 for 0:560, 1 for 8:544 etc..
  $tcrw[$ii] = 720-($ii*16);
  $tcrm[$ii] = 544-($ii*16);
}
print "\n[$vdrname]\n";

## BEGIN Option argument processing
#print "nbarg=$#ARGV #arg0/1/2=$ARGV[0]#\t$ARGV[1]#\t$ARGV[2]#\n"; # return 0 if one argument!
$noarg=0; $numarg1=-1;
foreach (@ARGV) {
  # print "argv:$_\n"; } # $_ contains one element
  $lgarg=length($_);
  if (substr($_ , 0 , 1) eq '-') { # is argument option ('-' and '--' ARE equal by argmatch)
     if ($lgarg==1) { $lgarg++; $_ = "-h"; }	# '--' here is useless! and processed in equivalence
     if (argmatch($_,"-trace"		, $lgarg))	{ $tr        = 1; }
     if (argmatch($_,"-manual"		, $lgarg))	{ $flauto    = 0; }
    #if (argmatch($_,"-automatic"	, $lgarg))	{ $flauto    = 1; } # implicite
     if (argmatch($_,"-nocrop"		, $lgarg))	{ $flnocrop  = 1; }
     if (argmatch($_,"-rip0"		, $lgarg))	{ $flripexec = 0; } # rip a sample test at end
     if (argmatch($_,"-rip1"		, $lgarg))	{ $flripexec = 1; } # rip at end,supplying nomber of passes (1 or 2)
     if (argmatch($_,"-rip2"		, $lgarg))	{ $flripexec = 2; }
     if (argmatch($_,"-xpert"		, $lgarg))	{ $flxpert   = 1; }
     if (argmatch($_,"-bwhite"		, $lgarg))	{ $flbw      = 1; } # will force "grey" and audiobitrate=64
     if (argmatch($_,"-blackwhite"	, $lgarg))	{ $flbw      = 1; }
     if (argmatch($_,"-ndesinterlace"	, $lgarg))	{ $flnd      = 1; }
    #if (argmatch($_,"-compact"		, $lgarg))	{ $flprofile = 1; } # reserved future: NOT USED::!!
     if (argmatch($_,"-lmotion"		, $lgarg))	{ $flprofile = 2; } # profiles: set special bitrates for video/audio
     if (argmatch($_,"-lowmotion"	, $lgarg))	{ $flprofile = 2; }
     if (argmatch($_,"-pnormal"		, $lgarg))	{ $flprofile = 3; }
     if (argmatch($_,"-fmotion"		, $lgarg))	{ $flprofile = 4; }
     if (argmatch($_,"-fastmotion"	, $lgarg))	{ $flprofile = 4; }
     if (argmatch($_,"-clipvideo"	, $lgarg))	{ $flprofile = 8; }
     if (argmatch($_,"-abitrate"	, $lgarg))	{ $optabitrate= 1;} # set optimum audio bitrate
     if (argmatch($_,"-vbitrate"	, $lgarg))	{ $optvbitrate= 1;} # set optimum video bitrate ::!!TODO!!::
     if (argmatch($_,"-h"		, $lgarg))	{ printhelphdr(0); exit(0); } # old:printhelp(3); 
     if (argmatch($_,"-helpfull"	, $lgarg))	{ printhelphdr(1); printhelp(1); printsyntax(0); exit(0); }
     if (argmatch($_,"-syntax"		, $lgarg))	{ printsyntax(0) ; exit(0); }
     if (argmatch($_,"-version"		, $lgarg))	{ print "$vdrname version is: $ver\n"; exit(0); }
     #if (argmatch($_,"-lic"		, $lgarg))	{ printlicense(0); exit(0); }
     if (argmatch($_,"-license"		, $lgarg))	{ printlicense(1); exit(0); }
  }
  else { # is a filename or something like that
     if ($numarg1 >= 0)	{
	print "Error! Only supply ONE filename,please\n";
	print "Suggestion: it seems you have entered more than one filename\n";
	print "May be you forgot to enclose the full name between double-quote.\n";
	exit(-1);
     } else {
	$numarg1 = $noarg; # this is the 1st filename in arg list
     }
  }
  $noarg++;
}
# argument checks and coherences(simple way)
#if (! $goodarg) { print "Bad argument - please use $verperl -syntax to get the syntax help\n"; exit(1); } # NOT-USED!
if ($tr) { print "arg.options = tr:'$tr' xpert:'$flxpert' auto:'$flauto' bw:'$flbw' nd:'$flnd' flmo:'$flprofile'\n"; }
if ($tr) { print "arg.modified= tr:'$tr' xpert:'$flxpert' auto:'$flauto' bw:'$flbw' nd:'$flnd' flmo:'$flprofile'\n"; }

$dir = $ARGV[$numarg1]; $dir=~s/\\/\//g; @dirp = split(/\//,$dir); $dir = dirbase($dir); $fic = $dirp[$#dirp]; # or $fic =~ s#.*/##;
if ($tr) { print "dir='$dir' $fic='$fic'  dirp='@dirp' \n";
  print "prog0='$prog0'  \$0='$0'\n";
}
# mplayer mencoder environment checks
if ((! -x "$cmdmpl") || (! -x "$cmdmen")) {
  if ($tr) { print "mpl=$cmdmpl# menc=$cmdmen#\n"; }
  print "Error: either mplayer or mencoder utility has not been found or is not executable.\n";
  print "Plese check that following package has been installed:";
  if (!(-x "$cmdmpl")) { print " mplayer"; }
  if (!(-x "$cmdmen")) { print " mencoder"; }
  print "\nTo install a missing package use the command: sudo apt-get install mplayer mencoder\n\n";
  exit(-1);
}

# argument checks and directory pathnames
if ($numarg1 < 0) { 
  print "Error: You have not supplied a valid filename on the command line !\n";
  print "Please give only ONE filename on the command line (must be a MPEG2 file)\n\n";
  printsyntax(0);
  exit(-1);
}
$dir=chompsp("$dir",0);
if ($tr) { print "TR.dir arg='$dir'\n"; }

# Full pathname needed to make script independant of env
if ($dir eq '.'){ $dir=`pwd`; }
$dir=chompsp("$dir",0);
print "Current working directory: '$dir'\n";

$fich=chompsp("$dir/$fic",0);  # file list in input, to sort
if ($tr) { print "TR.file selection:'$fich'\n"; }
if (-d "$fich") {
  print "\n";
  print "Error! the given filename is a directory. Please supply only a MPEG2 video filename\n";
  print "(incorrect file type found)\n";
  print "Don't know how to process directories: '$fich'. Sorry!\n\n";
  exit(-1);
}

if ((-e "$fich") || (-r "$fich")) {
    # @ficlist= split(/\s+/ ,$fich);
    # $fich=$ficlist[0];
    if ($tr) { print "TR.found file: '$fich'\n"; }
    if (($fich !~ /\.mpg$/i)&&($fich !~ /\.mpeg$/i)&&($fich !~ /\.m2t$/i)&&($fich !~ /\.vob$/i)) {
	print "\n";
	print "Error! movie is NOT a file among one of these types: .m2t .mpg .mpeg .vob\n";
	print "(incorrect extension found)\n";
	print "Don't know how to process: '$fich'. Sorry!\n\n";
	exit(-1);
    }
} else { # not exist so try wildcards
  if ($tr) { print "TR.file try select.m2t,mpg,vob\n"; }
  if (($fich !~ /\.mpg$/i)&&($fich !~ /\.m2t$/i)&&($fich !~ /\.vob$/i)) {
    $ficglob = "$dir/*$fic*.mpg";
    } else {
    $ficglob = "$dir/*$fic*";
  }
  if ($tr) { print "TR.file select.now ficglob:'$ficglob'\n"; }
  @ficlist = glob($ficglob);
  if ($tr) { print "TR.file select.ficglob found:'@ficlist'\n"; }
  if ($#ficlist < 0) {
    $ficglob = "$dir/*$fic*";
    @ficlist = glob($ficglob);
  }
  if ($tr) { print "TR.ficlist='@ficlist' (nb=$#ficlist)\n"; }
  if ($#ficlist >= 0) {
    if ($tr) {
	print "TR.matched $#ficlist+1 files: with wildcard '$ficglob' .\n";
	print "TR.This wilcard selected: '@ficlist'\n";
    }
    $fich=$ficlist[0];
    if ($#ficlist > 0) {
	print "\n";
	print "Error: Enter a correct filename (MPEG2 TS or PS format) on the command line\n";
	print "Suggestion: Only ONE filename must be given on the command line\n";
	print "   Example: $verperl  my-movie-to-vdrip.m2t\n";
	exit(-1);
    }
  } else {
    print "\n";
    print "Error: No file found even while parsing with argument:'$ficglob'\n";
    print "Suggestions: Please review the command line argument.\n";
    print "Have you entered a correct filename? Are you in the right directory?\n";
    print "Do you want to use '$fic' ? I cannot find it in the current directory!\n\n";
    exit(-1);
  }
}
if ($tr) { print "TR.dir  after arg='$dir'\n"; }
if ($tr) { print "TR.fich after arg='$fich'\n"; }

# Process first functions,get data about this file
$rfi=rindex($fich, '/'); if ($rfi<0) { $rfi=-1; }
$rxi=rindex($fich, '.');
if ($rxi<0) {
  print "\n";
  print "Error! movie is NOT a file among one of these types: .m2t .mpg .mpeg .vob\n";
  print "(no extension found)\n";
  print "Cannot process argument: '$fich' - Suggestions :\n";
  print "Have you entered a correct filename? Are you in the right directory?\n";
  print "Have you entered only one filename, without space or special character in its name?\n\n";
  exit (-1);
} else {
  $fichext=substr($fich,-(length($fich)-$rxi-1)); # extension,filetype
}

print "$vdrname has started in mode :";
if ($flauto)     { print " Automatic"; } else { print " Manual"; }
if ($flnocrop)   { print " No-Crop";   }
if ($flxpert)    { print " Xpert";     }
if ($flprofile)  { print " Profile:0$flprofile"; }
print "\n";

# setting up the -alang parameter for mplayer/mencoder
($envlng,$cmdlng2,$cmdlng3)=getmplayerlng();
print "Default system  language : $ENV{'LANG'}\n";
print "Default mplayer language : '$envlng'  - Argument to use:'$cmdlng3'\n";
print "alternate language option: '$cmdlng2'\n";

if ($tr) { print "TR.fichext='$fichext' rxi='$rxi'\n"; }
print "Filetype '$fichext' detected\n";
print "Default TimeCursor set to: $currtime  (format HH:MM:SS)\n";

if ((! -d "$ficroot") || (! -w "$ficroot")) {
  $ficroot="$ENV{'HOME'}/"; # script file name,default root name
}
print "Default script directory : $ficroot\n";

$fichcurrdir=`pwd`; chomp($fichcurrdir);
$fichnopath = substr($fich,$rfi+1);	# name without pathname (used inside the script)
$fichpath  = "$fichcurrdir/$fichnopath";# name with pathname forced (not used for now)
$fichsimple = $fichnopath;		# without directory name
$rxi=rindex($fichnopath, '.');
$fichnopathext = substr($fichnopath,0,$rxi); # without directory name,nor extension
$fichnopathext = chnamesimplify($fichnopathext);
$fichsimple = $fichnopathext;
$fichscript = "$ficroot$fichsimple.sh"; # script file has '.sh' added
$fichavifile= $fichnopathext;		# final filename will have '.avi' added
if ($tr) {
  print "FICHNAMES= currdir:'$fichcurrdir'  fichpath:'$fichpath'\n";
  print "\t nopath:'$fichnopath'  nopathext:'$fichnopathext'\n";
  print "\t simple:'$fichsimple'  fichext:'$fichext'\n";
  print "\t script:'$fichscript'\n";
  print "\t avifil:'$fichavifile'\n";
}

# check filename given exist and can be processed
if (filenotexist("$fich")) {
  print "Error! Cannot Openfile for Read: '$fich' $!";
  exit(-1);
}
$ficsizo=(-s "$fich");
$ficsizm= $ficsizo/1024/1024;
printf"Video size has %lu octets (%.3f MiB)\n",$ficsizo,$ficsizm; # in MiB

# Erase previous tmp file
if (-e "$fictmp") { 
  unlink "$fictmp";
  if ($tr) { print "TR.previous tempfile has been erased: $fictmp\n"; }
}

if (index("$fich", ' ') >= 0) {
  print "\nWarning: filename contains spaces in its name: processing may fail (not recommended)\n";
}
#
## Video Processing MPEG2 HEADERS
#
@vd=();	# virtual video description array
$rch=processheader(0, "$fich", "$fictmp");
if ($rch) {
  print "\nToo many errors while analyzing file header, cannot continue! (rch=$rch)\n";
  print "\nProgram terminated abnormally.\n";
  reportproblem();
  if (-e "$fictmp") {
    unlink "$fictmp";
    if ($tr) { print "TR.tempfile has been erased: $fictmp\n"; }
  }
  exit(-1);
}
print "MPEG2 file header information has been loaded.\n";
# update vd16 et vd17: width,height recommended size for mencoder
getaspcalc("ac"); # automatically compute video aspect
print "\n";
print "User Script will be: '$fichscript'\n";
# quality of encoding,all options/arguments
setratefromprofile();	# init.variable for audio/video bitrates

# EXPERIMENTAL : need a reliable way to get the nb.of frames/duration in seconds of a movie MPEG2
#		 to implement the optimal videobitrate ($optvbitrate)
if ($tr == 2) {	# experimental !!DO NOT USE!! only for enhancements
  # nb of sec(menc),audio and video sizes(computed),movie-duration-in-title,average video bitrate(computed)
  ($fsec,$asiz,$vsiz,$msiz,$avvbr)=getmplayerlength(1,$vd[14],"$fich"); # 1:display infos,audio bitrate,filename
}

#
## Video Processing: AUTO or MANUAL MODE
#
# VDRIP automatic mode: chains automatically the commands,so NO USER INTERACTION
if ($flauto) {
  $rac=0;
  if ($flnocrop == 0) {
    $rac=processcommand("ct");	# crop it automatically (no user interaction)
  }
  printmenu($tr); print "\n";
  printcroptable($flxpert);
  if ($flnocrop == 0) {
    $rag=processcommand("ge");
  } else {
    $rag=processcommand("gn");
  }
  # implicit "quit"
  if ($flxpert) { print "Automatic mode status= rch:'$rch'  ct:'$rac'  ge:'$rag'\n"; }
  if (($rac==0) && ($rag==0)) {
    print "Program terminated normally.\n";
  } else {
    print "Program has encountered an error - returned status= rch:'$rch'  ct:'$rac'  ge:'$rag'\n";
    reportproblem();
  }
} else {
  ## VDRIP manual mode: commands are entered manually by user (at least these ones):
  # ct : cropdetect (1st time or again)
  # ge : save and generate a script shell program that will use mencoder to vdrip the mpeg2 file (m2t, vob or mpg)
  #      if one crop detection has occurred,script will be generated with crop parameters found during cropping sequence
  #      if one crop detection never took place,script will be generated without crop parameters, so the movie keep its size
  # gn : same one than before,without crop detection (the script is generated without crop parameters)
  # qu : to quit/exit program immediately
  do {
    printmenu($tr);
    print ">>> Enter command ('h' for help or 'q' to Quit)? ";
    $cmdman = getlig(1);
    $reperror="";	# reset last warning message in menu
    print "\n";
    $rmp=processcommand($cmdman);
    if ($flxpert && $rmp) { print "Manual mode status= rmp:$rmp\n";  }
    print "\n";
  } while ( ($cmdman !~ /^q\b/i) && ($cmdman !~ /^qui/i) && ($cmdman !~ /^ri/i) );
  # if command 'quit' or after a manual 'ri' (direct rip)
}
#
## End Video Processing and parameter configuration
#
if (-e "$fictmp") { unlink "$fictmp"; }
if ($flripexec >= 0) { 
  print "Executing script file for ripping video : $fichscript\n";
  execscript("ri$flripexec",$fichscript); # $flripexec is for number of passes (command "rin")
}

# End of programm
print "End [$verp].\n";
exit(0);

###
sub reportproblem {
  my($codelg) = @_;
  print "Please re-run the same command with trace option '-tr' and report\n";
  print "  the full problem with the explanation to: $verp\@gmail.com . It will help!\n\n";
}
###
sub argmatch {	# test if arguement 1 and 2 matches till $maxcar characters(if 0:till length of $ar1)
  my($ar1, $ar2, $maxcar) = @_;	# argument1 should be the shortest(the one entered by the user)

  if ($maxcar == 0) {
    $maxcar = length($ar1);
  }
  if ($ar1 =~ /^--/) { $maxcar--; $ar1 =~ s/^-//; }
  if (substr($ar1,0,$maxcar) eq substr($ar2,0,$maxcar)) {
    return(1);
  } else {
    return(0);
  }
}
###
sub clearscreen {
  my($codelg) = @_;
  system("clear");
}
###
sub processcommand {	# each manual(user interaction) command entered by user
  my($cmdman) = @_;
  my($rcpr);	# return stat from genficscript,ficmodmenc,processfile
  my($msgkill);

  $rcpr=0;
  $msgkill="Enter a command 'k' to stop (kill) the MPlayer Window";

  if (! $cmdman) {
    if ($flxpert) {
      printcroptable($flxpert);
    }
    else {
      print "Please Enter a command, or 'h' for help\n";
      print "You may enter 'x' to enter the 'Xpert mode' or 'tr' for the trace/debug mode for advanced users.\n";
    }
  }
  elsif ($cmdman =~ /^x/i) {
    if ($flxpert) {
	$flxpert=0;
	print "Xpert flag is now set to OFF for standard mode (flxpert=$flxpert)\n";
    } else {
	$flxpert=1;
	print "Xpert flag is now set to ON This is the advanced mode for experienced users (flxpert=$flxpert)\n";
    }
  }
  elsif ($cmdman =~ /^tr/i) {
    if ($tr) {
	$tr=0;
	print "Debugging (trace) flag is now set to OFF\n";
    } else {
	$tr=1;
	print "Debugging (trace) flag is now set to ON - Re-enter 'tr' to switch it off\n";
	print "!! Warning !! it is now a very VERBOSE mode !!\n";
    }
  }
  elsif ($cmdman =~ /^bw/i) {	# black&white movie flag on/off
    if ($flbw) {
	#$flprofile=$flbw;	# reset blackwhite mode to previous profile
	$flbw=0;
	print "BW flag is now set to OFF - reset to previous profile (flpr=$flprofile)\n";
    } else {
	#$flbw=$flprofile;	# store old profile if further user want to cancel the B&W mode
	$flprofile=0;		# reset null profile number
	$flbw=1;
	print "BW flag is now set to ON with audio bitrate to 64Kbps - Optimizations for Black&White movies (flbw=$flbw)\n";
	setaudiobitrate("ab64");
    }
    #setratefromprofile();	# don't reset a/v bitrates
  }
  elsif ($cmdman =~ /^nd/i) {	# no-desinterlace flag on/off
    if ($flnd) {
	$flnd=0;
	print "Frames will be desinterlaced, this is the normal mode (DESINTERLACE is ON)\n";
    } else {
	$flnd=1;
	print "Frames won't be desinterlaced, NO-DESINTERLACE flag is now set to ON (DESINTERLACE is OFF)\n";
    }
  }
  elsif ($cmdman =~ /^lm/i) {	# Low-motion encoding flag on/off
    if ($flprofile==2) {
	$flprofile=3;
	print "LOW MOTION flag is now reset - selected NORMAL profile (flpr=$flprofile)\n";
    } else {
	$flprofile=2;
	print "LOW MOTION flag is now set to ON  (flpr=$flprofile)\n";
    }
    setratefromprofile();
  }
  elsif ($cmdman =~ /^fm/i) {	# Fast-motion encoding flag on/off
    if ($flprofile==4) {
	$flprofile=3;
	print "FAST MOTION flag is now reset - selected NORMAL profile (flpr=$flprofile)\n";
    } else {
	$flprofile=4;
	print "FAST MOTION flag is now set to ON  (flpr=$flprofile)\n";
    }
    setratefromprofile();
  }
  elsif ($cmdman =~ /^cl/i) {	# ClipVideo high bitrate enoding and best sound, flag on/off
    if ($flprofile==8) {
	$flprofile=3;
	print "CLIP VIDEO flag is now reset - selected NORMAL profile (flpr=$flprofile)\n";
    } else {
	$flprofile=8;
	print "CLIP VIDEO flag is now set to ON  (flpr=$flprofile)\n";
    }
    setratefromprofile();
  }
  elsif ($cmdman =~ /^k/i) { # kill/stop the current mplayer player
    killplay($cmdman);
  }
  elsif ($cmdman =~ /^c$/i) {	# clearscreen
    clearscreen();
  }
  elsif ($cmdman =~ /^cs/i) {	# crop from starting point
    $rcpr=processfile(0, $cmdman, $fich);
    if ($flxpert) { print "status: processfile(0,$cmdman) rcpr:$rcpr\n";  }
  }
  elsif ($cmdman =~ /^ct/i) {	# crop from cursor point (crop at cursor)
    $rcpr=processfile(1, $cmdman, $fich);
    if ($flxpert) { print "status: processfile(1,$cmdman) rcpr:$rcpr\n";  }
  }
  elsif ($cmdman =~ /^cr/i) {	# crop from 3 different points in the file
    $rcpr=processfile(2, $cmdman, $fich);
    if ($flxpert) { print "status: processfile(2,$cmdman) rcpr:$rcpr\n";  }
  }
  elsif ($cmdman =~ /^ps/i) {
    $reperror="$msgkill";
    print "$reperror\n";
    playstartfile($cmdman, $fich);
  }
  elsif ($cmdman =~ /^pp/i) {
    $reperror="$msgkill";
    print "$reperror\n";
    playstartfile($cmdman, $fich);
  }
  elsif ($cmdman =~ /^pv/i) { # play video in verbose mode,nocrop (with time/crop param given)
    $reperror="$msgkill";
    print "$reperror\n";
    playcropfilec($cmdman, $fich); #old: playcropfilev()
  }
  elsif ($cmdman =~ /^pc/i) { # play crop (from time cursor) : with crop parameters
    $reperror="$msgkill";
    print "$reperror\n";
    playcropfilec($cmdman, $fich);
  }
  elsif ($cmdman =~ /^pn/i) { # idem but : without crop parameters
    $reperror="$msgkill";
    print "$reperror\n";
    playcropfilec($cmdman, $fich);
  }
  elsif ($cmdman =~ /^sa/i) { # set aspect : modify the current aspect ratio for the script generation,
    setaspect($cmdman, $fich); # and update: vd16..17
  }
  elsif ($cmdman =~ /^g[e|n]/i) {
    $rcpr=genficscript($cmdman, $fich); # generate the vdriping script with theses parameters
    if ($rcpr == 0) {
	ficmodmenc($cmdman, $fich); # ret code $rcpr is not an error
    }
  }
  elsif ($cmdman =~ /^ri/i) { # launch a sample ripping sequence (after ge) $flripexec
    $flripexec=-1; # reset the command-line flag,in case of
    execscript($cmdman, $fichscript); # $cmdman should normally supply 0,1 or 2(nb.of passes)
  }
  elsif ($cmdman =~ /^sc/i) {	# set crop parameters manually
    setcrop($cmdman, $fich);
  }
  elsif ($cmdman =~ /^sv/i) {	# set crop parameters from the array @vdcall[]
    setcropv($cmdman, $fich);
  }
  elsif ($cmdman =~ /^sh/i) {	# set/modify height
    setcroph($cmdman, $fich);
  }
  elsif ($cmdman =~ /^sw/i) {	# set/modify width
    setcropw($cmdman, $fich);
  }
  elsif ($cmdman =~ /^st/i) {	# set time parameter cursor
    settime($cmdman, $fich);
  }
  elsif ($cmdman =~ /^sd/i) {	# set duration parameter (only for a vdrip-test)
    setduration($cmdman, $fich);
  }
  elsif ($cmdman =~ /^ab/i) {	# set audio bitrate (force:no-checks)
    setaudiobitrate($cmdman, $cmdman);
  }
  elsif ($cmdman =~ /^vb/i) {	# set video bitrate (force:no-checks)
    setvideobitrate($cmdman, $cmdman);
  }
  elsif ($cmdman =~ /^ta/i) {	# display tables of ratio,and last cropdetections values done
    printcroptable($flxpert);
  }
  elsif (($cmdman =~ /^h/i)||($cmdman =~ /^\?/)) {
    if ($flxpert) { printhelpxpert($flxpert); printsyntax(0); printcroptable($flxpert); }
    else { printhelphdr(1); printhelp(0); printsyntax(0); printcroptable($flxpert); }
  }
  else {
    $reperror= "!!! ERROR ! Bad Command '$cmdman' does not exist - Enter 'h' to get Help"; print "$reperror\n";
  }
  return($rcpr);

} # processcommand

###
sub printmenu {
  my($codelg) = @_;	# if not 0 ($tr is ON) print long form,i.e with array content and tables
  my(@tt);		# printmenu to synchronize with genficscript!
  my($avireso);		# final avifile resolution, ex:704x400

  if ($codelg) {
	if ($vd[8]) {  # display full parameters if a crop occurred once before
	  print "fti=$currtime ; ftd=$currduration ; \# ftd is duration only used for a sample mencoding sequence\n";
 	  print "\# timc='$currtime' currcrop='$currcrop' asp='$vd[16]:$vd[17]' Ocrop='$vd[8]' mpgasp=$vd[4]($vd[13]) $vd[12] vo=$vd[15] au=$vd[14]\n";
	  print "ficr=$currcrop ; fics=$vd[16]:$vd[17] ; ficsx=$vd[16]x$vd[17] ; fichscript='$fichscript'\n";
	  print "fila=$fichavifile\n";
	}
	printcroptable($codelg);
  }
  if (($vd[16]) && ($vd[17])) { $avireso = sprintf("%1.2f", $vd[16] / $vd[17] ); }
  print "$vdrname - Video : $fich	- [cmd='$cmdman']\n";
  print "Action values : Time Cursor ='$currtime' - TestDuration='$currduration'    - CropDetection=";
  if ($currcrop) { print "Computed\n"; } else { print "NotComputed\n"; }
  print "  MPEG2  Data :   Mpeg Ratio='$vd[4]($vd[13])' MpegResol='$vd[12]'($vd[15]) - Nominal A/V kbps='$vd[14]/$vd[19]' fps=$vd[18]\n";
  print "  Final Video : AvifileRatio='$avireso'    AviAspect='$vd[16]:$vd[17]'  CropSet='$currcrop'  Ocrop='$vd[8]'\n";
  print "  Misc.Option : Bitrate Audio/Video kpbs='$rateaudio/$ratevideo'  FLAGS NO-Desintl='$flnd'  Bl&White='$flbw'\n";
  print "  A/V Profile : Number='0$flprofile' - Values A/V='$rateaudio/$ratevideo'\n";
  print "  User Script : $fichscript\n";
  if ($reperror) {
    print "LstWarnMESSAGE: $reperror\n";
  }
}

###
sub printvdarray {	# display the vd[] array in compact form
  my($ii,$iin);

  $ii=1;
  print "VD array= vd:$ii=$vd[$ii]\n";
  for ($ii=2; $ii<= 3; $ii++) {
    if ($vd[$ii]) { print "vd:$ii=$vd[$ii]\n"; }
  }
  for ($ii=4; $ii<= 5; $ii++) {
    if ($vd[$ii]) { print "vd:$ii=$vd[$ii]\t"; }
  }
  print "\n";
  for ($ii=6; $ii<= 7; $ii+=2) {
    $iin=$ii;
    if ($vd[$ii])   { print "vd:$ii=$vd[$ii]\t";   }
    $iin++;
    if ($vd[$iin]) { print "vd:$iin=$vd[$iin]\n"; }
  }
  for ($ii=8; $ii<= $MAXvd; $ii+=4) {
    $iin=$ii;
    if ($vd[$ii])   { print "vd:$ii=$vd[$ii]\t";   }
    $iin++;
    if ($vd[$iin]) { print "vd:$iin=$vd[$iin]\t"; }
    $iin++;
    if ($vd[$iin]) { print "vd:$iin=$vd[$iin]\t"; }
    $iin++;
    if ($vd[$iin]) { print "vd:$iin=$vd[$iin]\n"; }
  }
}

###
sub printcroptable {
  my($codelg) = @_;	# if not 0 print long form,i.e with array content and tables
  my($ii);

  if ($codelg) {
	print "Flags = xpert:$flxpert - trace:$tr - dvdnum/lng:$dvdnum/$dvdlng - mplayer options:$cmdlng3 $cmdmplvo";
	print "\n";
  }

  if ($tr) {
    printvdarray();
  }
  if ($#vdcall >= 0) {
    print "Last cropdetections[vdcall]: ";
    for ($ii=0; $ii<=$#vdcall; $ii++) {
      if ($vdcall[$ii]) { print "$ii=$vdcall[$ii] "; }
    }
    print "\n";
    #print "last is(i:$#vdcall):$vdcall[$#vdcall]\n";
  }

  if ($codelg) {
    print "HorizW} 720 704 688 672 656 640 624 608 592 576 560 544 528 512 496 480 464 448 432 416 400 384 368 352 336 320 304 288\n";
    print "Horizw} 544 528 512 496 480 464 448 432 416 400 384 368 352 336 320 304 288 272 256 240 224 208 192 176 160 144 128 112\n";
    print " Table}   0   8  16  24  32  40  48  56  64  72  80  88  96 104 112 120 128 136 142 150 158 166 174 182 190 198 206 214\n";
    print "VertiH} 576 560 544 528 512 496 480 464 448 432 416 400 384 368 352 336 320 304 288 272 256 240 224 208 192 176 160 144\n";
  }
}

###
sub printsyntax {
  my($codelg) = @_;	# code not used

  #print "\n";
  print "Syntax: $verperl [ Options ] Uniq-Filename.[m2t|mpg|mpeg|vod]\n\n";
  print "Only one filename should be given as a parameter on command line\n";
  print "In normal operations,a standard user should never use these options.\n";

  print "-help,helpfull\t: display this help and exit\n";
  print "-syntax\t\t: brief help showing the supported syntax of $verp\n";
  print "-version\t: output version information and exit\n";
  print "-license\t: display licensing information and exit\n";
  print "-auto\t\t: automatic mode : no user interaction (default mode)\n";
  print "-manual\t\t: manual mode, mode in which the user should enter commands manually\n";
  print "-nocrop\t\t: automatic mode but without picture crop function\n";
  print "-rip0 -rip1 -rip2: rip the movie just after the shell script file has been created\n";
  print "\t\t  -rip1 for one pass, -rip2 for 2 passes, -rip0 for a sample test.\n";
  print "-verbose\t: more information displayed when in manual mode\n";
  print "-h\t\t: brief help of this utility\n";
  print "-help\t\t: full help of this utility\n";
  print "-xpert\t\t: advanced  mode for experienced users\n";
  print "-trace\t\t: debugging mode for experienced users and debuggers\n";
  print "\t\t  is a very verbose mode\n";
  print "Each option must be separate from each other. Most can be abbreviated in 2 letters.\n";
  print "\n";
}
###
sub printhelphdr {	# help header, should not be used alone,must be used with printhelp or printsyntax
  my($codelg) = @_;	# 1:clear screen before
  my($r,$lig,$nolig);

  if ($codelg) { system("clear"); }

  print "Program: $verp for GNU/Linux - Perl version - HELP file\n";
  print "
VDRIP is a stand-alone encoding utility used to convert MPEG2 format
Videos (TS or PS). It compacts them efficiently and produce high quality
mpeg4 .avi files (XviD,DivX).

The videos in MPEG2 format have usually an extension .mpg  .mpeg  .m2t
or  .vob  and you get them when you record TV or Satellite programs with
a DVB adaptor installed in your computer.
Internally, this utility uses the well known MPLAYER and MENCODER
softwares (see web site http://www.mplayerhq.com).
$verp is a free software running on GNU/Linux and released under the
GPL License. It is supplied as an 'all in one' file.

There is no GUI (Graphical User Interface). Everything is done in a
Terminal or Console window : it is an easy way to produce mpeg4
multimedia files.
\n";

}
###
sub printhelp {
  my($codelg) = @_;	# codelg used by getlig()
  my($r,$lig,$nolig,$nbligmax);

  $nbligmax=$ENV{'LINES'};
  if ($nbligmax < 5) { $nbligmax=24 } ; # pagination
  if ($tr) { print "pagination is:$nbligmax lines\n"; }
  print "Enter option '-help' to get full help\n";
  print "  or '-syntax'  for main syntax options\n";
  print "  or '-license' to read the license terms and conditions.\n";
  # print "  Notice you can enter command 'h' in manual mode to get the help.\n";
  print "\n";

  $lig="a"; $nolig=$nbligmax-1;	# must page the first time it is called
  while ("$lig") {
     $lig = <DATA>;
     if (substr("$lig",0,7) eq "LICENSE") {
	return ;
     } else {
	$nolig++;
	if ($nolig % $nbligmax == 0) {
	  print "-- More --"; 
	  if (getlig($codelg) eq 'q') { return; }
	}
	print "$lig";
     }
  }
}
###
sub printhelpxpert {	# Help in xpert+manual modes (AND ONLY if both flags are ON)
  my($codelg) = @_;	# 1(if flagexpert):full xpert mode help in manual mode only
  my($r,$fl,$fic,$lig);	# format is based on std help file,text is inside this source
  my($mark,$nolig,$nbligmax);	# codelg used by getlig()

  $mark='#-'.'x';
  $nbligmax=$ENV{'LINES'};
  if ($nbligmax < 5) { $nbligmax=24 } ; # pagination
  if ($tr) { print "pagination is:$nbligmax lines\n"; }
  $nolig=0;
  if ($codelg) {	# if 0 silently discarded
    $fl=0;
    $fic="$fichvdrip"; chomp($fic);
    $r=open(FTS, "$fic");
    if ($r) { # openfile-rw ok?
      while ($lig=<FTS>) {
        if (index($lig,"$mark")>=0) { $fl++; } 
        if ($fl) {
	  if (index($lig,"$mark")>=0) {
	    $nolig++;
	    if ($nolig % $nbligmax == 0) {
	      print "-- More --"; 
	      if (getlig($codelg) eq 'q') { return; }
	    }
	    print substr("$lig",3); # only print the expert help text
	  }
	}
      }
      return(0);
    }
    # else every other condition
    print "ERROR! Cannot access to full expert help text (internal error)\n";
    print "Should not occur,text file is: '$fic': $!\n\n";
    return(1);
  }
}
###
sub printlicense {	# 0:short license in command line argument ; 1: full license text
  my($codelg) = @_;	# $codelg used
  my($r,$fl,$fic,$lig);

print "This software 'VDRIP' also named '$verp' is a stand-alone
encoding utility used to convert MPEG2 format Videos (TS or PS).
It compacts them efficiently and produce high quality mpeg4 .avi
files (XviD,DivX).

VDRIP is released under the GNU General Public License (GPL).
	http://www.gnu.org/licenses/gpl.txt

	Copyright © 2008,2009 Pikwix

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

French text - Texte en français :
    Ce programme est distribué sous les termes de la Licence Publique
    Générale GNU.
    http://www.gnu.org/licenses/gpl.txt

    Ce programme est libre, vous pouvez le redistribuer et/ou le modifier
    selon les termes de la Licence Publique Générale GNU publiée par la
    Free Software Foundation (version 2 ou bien toute autre version
    ultérieure choisie par vous).

Ce programme est distribué car potentiellement utile, mais SANS AUCUNE
GARANTIE, ni explicite ni implicite, y compris les garanties de
commercialisation ou d'adaptation dans un but spécifique.
Reportez-vous à la Licence Publique Générale GNU pour plus de détails.

Vous devez avoir reçu une copie de la Licence Publique Générale GNU en
même temps que ce programme ; si ce n'est pas le cas, voyez à
l'adresse <http://www.gnu.org/licenses/> ou encore écrivez à la Free
Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
MA 02111-1307, États-Unis - USA
\n";

  if ($codelg) {
    $fl=0;
    #$fic=`which $vdrname.pl`; chomp($fic);
    $fic="$fichvdrip"; chomp($fic);
    $r=open(FTS, "$fic");
    if ($r) { # openfile-rw ok?
      while ($lig=<FTS>) {
        if (index($lig,'LICENSE for VDRIP'.':')>=0) { $fl++; } 
        if ($fl) { print "$lig"; } # only print from this text
      }
      return(0);
    }
    # else every other condition
    print "ERROR! Cannot access to full license text - internal error!\n";
    print "Should not occur,text file is: '$fic': $!\n";
    exit(-1);
  }
}
###
sub filenotexist {	# test if file exists (open-close)
  my($fich) = @_;	# pathname
  my($rcgen);

  $rcgen=0; # code return of this function= 0:noerr, 1:err
  if(open(FTE, "$fich")) { close(FTE); }
  else	{ $rcgen=1; }

  return($rcgen);
}
###
sub execscript {		# execute the given script file, immediately. Must supply a command "rin"
  my($miarg, $fichscr) = @_;	# where 'n' is the code nb of passes(0 1 or 2), script pathname
  my($mifrom,$rc0,$codepass);
  my($cmde1); # error code returned by system()

  $mifrom=substr($miarg,2); $mifrom=chompsp($mifrom,0);
  $codepass=$mifrom;
  if (($codepass ne "0") && ($codepass ne "1") && ($codepass ne "2")) {
    print "Parameter number of passes not supplied or incorrect - Forced to 1 ('$codepass').\n";
    $codepass="1";
  }
  $cmde1 = "$fichscr $codepass";
  if ($tr) { print "TR.exec.system:$cmde1#\n"; }
  $rc0=system("$cmde1");
  if ($tr) { print "TR.exec.result:$cmde1#\n"; }
  if ($tr) { print "TR.result execscript rc0=$rc0 (ok if 0|256,bad if -1)\n"; }
}
###
sub processheader {	# analyzing file header,first processing
  my($codefrom, $fich, $fictmp) = @_;	# getvddata code(always 0), pathname, temp file
  my($rcgen,$rc0,$rc00,$ii);
  my($cmde1); # error code returned by system()

  $rcgen=0; $rc0=-1; $rc00=-1;
  $cmde1 = "$cmdmpl -v $cmdlng3 $cmdmplvo $cmdmplvohdr \"$fich\" 2\>/dev/null \>\> $fictmp";
  if ($tr) { print "TR.processheader.exec.system:$cmde1#\n"; }
  $rc0=system("$cmde1"); if ($tr) { print "TR.result rc0=$rc0 (ok if 0|256,bad if -1)\n"; }

  # Read tempfile and display complete results
  if  (($rc0==0)||($rc0==256)) { $rc00=getvddata($codefrom,"$fictmp"); }
  if ((($rc0==0)||($rc0==256))&&($rc00==0)) {  # noerror,data may be displayed
    if ($tr) { print "VD array(processheader)= (retcodes:rc0=$rc0, rc00=$rc00)\n"; }
    # code 0:noerr; -1:errfile; -2:nocropdetectfound; -3:incoherenceinallcropdetect;
    # -4:parameter missing in tempfile like vd1..vd5;
    for ($ii=0; $ii<= $MAXvd; $ii++) {
      if ($vd[$ii]) {
	if ($tr) { print "Initial vd:$ii=$vd[$ii]\n"; }
      }
    }
  } # if $rc0 $rc00..
  else {  # error,report that data is wrong
    $rcgen=1;
    print "\nError: in processheader ret:$rc0 $rc00 (look in getvddata,data in this array may be wrong:)\n";
    for ($ii=0; $ii<=$MAXvd; $ii++) {
      if ($vd[$ii]) {
	print "\tvd$ii=$vd[$ii]";
      }
    }
    print "\nErrcode= -1:errfile; -2:nocropdetectfound; -3:incoherenceinallcropdetect;\n";
    print " -4: one is missing in indices vd1..vd5 (size,video,audio,aspect,VOcfg is null)\n";
  }
  return($rcgen);
}
###
sub processfile {	# cropdetect standard file (mpeg) to proceed and reporting
  my($codefrom, $miarg, $fich) = @_;	# pathname
  my($mifrom,$r);
  my($cmde1); # error code returned by system()
  my($misleep,$rf,$rc1,$rck); #return code div,killplay
  my(@looptim,$noloop,$nolooplast,$rcgen);

  $rcgen=0; # returned code by this function= 0:noerr, 1:err, +4:err.killplay, +2:err.getvddata, +10:err.mplayer
  @looptim=();
  $misleep=$mysleep;

  $mifrom=chompsp(substr($miarg,2)); $mifrom=chompsp($mifrom,0); $r=index($mifrom, ':');
  if ($codefrom == 0) {
    $misleep=20; 	# if crop at starting (cs)
    if (! $mifrom){ @looptim=(@croptimestart); }
    else {
	if ($r >= 0) { # $mifrom contient ':'
	  $looptim[0]="$mifrom"; # usage as is
	} else {
	  $looptim[0]="00:$mifrom:00"; # usage in time: nbr.minutes
	}
    }
  }
  elsif ($codefrom == 1) { # if crop at begin point $currtime
    $misleep=10; 	# if crop at time given (ct) and set time if there is a time indication
    if (! $mifrom){ $looptim[0]=$currtime; }
    else {
	if ($r >= 0) { # $mifrom contains ':'
	  $looptim[0]="$mifrom"; # usage as is
	  $currtime = "$mifrom";
	} else {
	  $looptim[0]="00:$mifrom:00"; # usage in time: nbr.minutes
	  $currtime = "00:$mifrom:00";
	}
    }
  }
  elsif ($codefrom == 2)  { # crop at 3 different points in the file
    @looptim=(@croptimebig);
  } # $codefrom=2 (not at currtime)

  print "Please wait...\n";
  print "Analyzing video for file: $fich";
  if ($tr) {
    print "\n";
    print "  Subfunction = cod:$codefrom miarg:$miarg mifrom=$mifrom r=$r # looptim0=$looptim[0]";
  }
  print "\n";

  if ($tr) { print "processfile($codefrom) to proceed: '$fich'\n"; }

  # play this file nnn times in verbose mode -v and generate a tmp file with all data inside it to parse
  # erase previous tmp file
  if (-e "$fictmp") { unlink "$fictmp"; }

  # field minutes:seconds in option -ss
  if ($ficsizo <  $croptimesmallvalue ) {
    @looptim=(@croptimesmall); # if size < 600 Mb small file,like a clip
    $currtime=$currtimeshortdetect;	# value for small video file (00:01:00)
    print "Detected file has small size ($ficsizo octets), using crop parameters for small files:@looptim\n";
    print "  and time Cursor parameter (currtime) set to: $currtime\n";
  }

RESTART:
  foreach $noloop (@looptim) {
    $nolooplast=$noloop;
    $rcgen=0; # reset error in noloop sequence,modif.20090809
    if ($tr) { print "TR.trying -ss $noloop (currtime=$currtime)...\n"; }
    $cmde1 = "$cmdmpl -v $cmdlng3 $cmdmplvo -vf cropdetect -ss $noloop \"$fich\" 2\>/dev/null \>\> $fictmp \&";
    if ($tr) { print "TR.exec.system:$cmde1#\n"; }
    $rc1=system($cmde1);
    if (($rc1==0)||($rc1==256)) {
      sleep($misleep); # no error   
    }
    else {
	$rcgen+=10; # +10 for each error in mplayer
	print "$cmdmpl: returned error '$rc1' (in param.loop=$noloop)\n";
    }
    if ($tr) { print "TR.result rc1=$rc1 (ok if 0|256,bad if -1)\n"; }

    $rck=killplay("km");
    if ($rck) {
      print "Warning: mplayer window cannot be stopped (Procid '@proclist' cannot be killplay)\n";
      print "  rck=$rck rcgen=$rcgen (this report will be fixed)\n\n";
      @vd=();		# $rcgen+=4;
      # return(-4);	# modif.20090809
      # standard sequence if $noloop is 12mn and the movie is probably very small
      if (($currtime eq $currtimedetect) && ($noloop eq $currtimedetect)) {	$noloop="00:06:00" ; redo; }
      if (($currtime eq "00:12:00") && ($noloop eq "00:06:00"     )) {	$noloop="00:01:00" ; redo; }
      if (($currtime eq "00:12:00") && ($noloop eq "00:01:00"     )) {	$noloop="00:00:00" ; redo; }
      if (($currtime eq "00:12:00") && ($noloop eq "00:00:00"     )) {	$rcgen+=4; return(-4); }
      # sequence small file if $noloop is 00:00:20 and the movie is probably smaller! goto at start
      if (($currtime eq $currtimeshortdetect) && (@looptim eq @croptimesmall)) { @looptim=@croptimestart ; goto RESTART; }
    }
  } # foreach $loop
  if ($currtime eq "00:12:00") { $currtime=$nolooplast; } # if cropdetect could not take place at standard currtime
  # if cropdetect could not take place with parameter $currtimeshortdetect
  if (($currtime eq $currtimeshortdetect) && (@looptim eq @croptimestart)) { $currtime=$nolooplast; } 

# Read and display complete results
  @vd=();
  $ret = getvddata(1,$fictmp);

  # code 0:noerr; -1:errfile; -2:nocropdetectfound; -3:incoherenceinallcropdetect;
  # -4:parameter missing in tempfile; -5:error previous to getvddata
  if ($ret) { print "WARNING: getvddata(1) ret=$ret (!0 if error)\n\n"; $rcgen=2; return($rcgen); }
  else      { $currcrop = $vd[8]; @vdcall = (@vdcall, $currcrop); }

  # update vd16 et vd17: width,height recommended size for mencoder
  getaspcalc("ac"); # automatic video aspect computing

  if ($ret == 0) {
    if ($tr) {
      printvdarray();
    }
  } # if $ret

  # end this file
  print "\n";
  return($rcgen);

} # processfile

###
sub getaspcalc {	# Compute aspect according to crop and mpeg aspect and ratio, and store to vd[16..17]
  my($miarg) = @_;	# can be called by processfile() and all crop functions,and ac,as
  my(@mpgasp,@ccr);	# split value to compute final aspect
  my($ratiocrop,$rationocrop,$ratiompg,$stdhei,$ratiohei); # to compute final aspect after crop
  my($prophei1,$hei1,$prophei2,$hei2,$aju2,$ajub2,$prophei3,$hei3,$aju3,$ajub3);
  my($tra,$ajcoeff,$aspfinal);

  $tra=0; # debug local function 'getaspcalc'
  if ($vd[8]) {  # compute and update full parameters only if a crop occurred once before
    # computed recommended width and height of file for the mencode sequence
    @mpgasp = split(/x/,chgetword($vd[2],2)); # mpeg aspect,ex "720x576", ratio is vd[4] ex:1.78
    @ccr = split(/:/, $currcrop); # values rendered by crop detect
    # so compute value when crop and no crop took place
    $ratiocrop = nodecnb($ccr[0]/$ccr[1],4);
    $rationocrop = nodecnb($mpgasp[0]/$mpgasp[1],4);
    $ratiompg = $vd[4];
    if ($tra) { print "ratiompg=$ratiompg - ratiocrop($ccr[0]:$ccr[1])=$ratiocrop - rationocrop($mpgasp[0]:$mpgasp[1])=$rationocrop\n"; }
    # compute std height in case no crop would have been done:
    $stdhei  = nodecnb($ccr[1] * $ccr[0] / $mpgasp[0],4); # so 576*(688/720) for original image of 720x576
    $ratiohei= nodecnb($ccr[0] / $stdhei,4) ;
    if ($tra) { print "stdhei=$stdhei ($ccr[1]\*$ccr[0]:$mpgasp[0]), ratiohei($ccr[0]:$stdhei)=$ratiohei\n"; }

    #SOLUTION1: a stdhei apply anamorphism coeff. (ex: 1.25->1.78) !!NOT ok!!
    $prophei1 = nodecnb($stdhei * $ratiocrop / $vd[4],4); $hei1 = nodec($prophei1);
    if ($tra) { print "SOL1: prophei1=$prophei1 ($stdhei\*$ratiocrop:$vd[4])\n"; }

    #SOLUTION2: a height apply anamorphism coeff. (ex: 1.25->1.78)
    $prophei2 = nodecnb($ccr[1] * $ratiocrop / $vd[4],4); $hei2 = nodec($prophei2);
    if ($tra) { print "SOL2: prophei2=$prophei2 ($ccr[1]\*$ratiocrop:$vd[4])\n"; }

    #SOLUTION3: a crop height apply anamorphism coeff. mpg->nocrop (ex: 1.33->1.25)
    $prophei3 = nodecnb($ccr[1] * $rationocrop / $vd[4],4); $hei3 = nodec($prophei3);
    if ($tra) { print "SOL3: prophei3=$prophei3 ($ccr[1]\*$rationocrop:$vd[4])\n"; }

    # compute nearest multiple-16 value
    $ajcoeff = 14;  # "14" is my ajust coeff to get a taller picture than too thick
    if (($ccr[0]/$hei3) < 1.5) { $ajcoeff = 6; }
    $aju2   = nodec(($hei2 + $ajcoeff)/16) * 16;
    $aju3   = nodec(($hei3 + $ajcoeff)/16) * 16;
    $ajub2  = $aju2 ; if ($aju2 > $ccr[1]) { $ajub2 = $ccr[1]; }
    $ajub3  = $aju3 ; if ($aju3 > $ccr[1]) { $ajub3 = $ccr[1]; }
    if ($tra) {
      print "propose prophei2=$prophei2 -> $hei2 - 16aju2:$aju2 , ajubig2:$ajub2 (ac:$ajcoeff)\n";
      print "propose prophei3=$prophei3 -> $hei3 - 16aju3:$aju3 , ajubig3:$ajub3 (ac:$ajcoeff)\n";
    }
    if ($miarg eq "ac") {
      $vd[16] = $ccr[0]; $vd[17] = $ajub3;
      print "Video Aspect is now set to: $vd[16]:$vd[17]";
    } else {
      print "Video Aspect is left unchanged: $vd[16]:$vd[17]";
    }
    $aspfinal=nodecnb($vd[16] / $vd[17],4); print " (aspect ratio = $aspfinal)\n";
  }
  else { # no crop data available,so compute without cropping parameters (only from MPEG data)
    $ratiompg = $vd[4];
    @mpgasp = split(/x/,chgetword($vd[2],2)); # mpeg aspect,ex "720x576", ratio is vd[4] ex:1.78
    @ccr = split(/x/, $vd[15]); # mpeg resolution
    if (($mpgasp[1]==0)||($ccr[1]==0)||($vd[4]==0)) { 
      print "ERROR! Bad MPEG data found (mpgreso:'$vd[15]' mpgasp:'$mpgasp[0]x$mpgasp[1]' mpgratio:'$vd[4]')\n";
      print " Internal error in getaspcalc() cannot compute aspect ratio (will be fixed!)\n";
      reportproblem();
      return();
    }
    $rationocrop = nodecnb($mpgasp[0] / $mpgasp[1],4);
    if ($tra) { print "ratiompg=$ratiompg - rationocrop=$rationocrop  mpgasp=$mpgasp[0]:$mpgasp[1]\n"; }
    $ratiohei =$ccr[0] / $ccr[1] * $vd[4] ;
    $vd[16] = $mpgasp[0] ;			# width idem than mpeg aspect
    ###OLD no!!! $hei3   = nodec($mpgasp[1] / $ratiohei) ;	# height transformation
    $hei3   = nodec($mpgasp[0] / $vd[4]) ;	# height transformation

    # compute nearest multiple-16 value
    $ajcoeff = 14;  # "14" is my ajust coeff to get a taller picture than a little thicker
    if (($vd[16]/$hei3) < 1.5) { $ajcoeff = 6; }
    $aju3   = nodec(($hei3 + $ajcoeff)/16) * 16;
    #$ajub3  = $aju3 ; if ($aju3 > $ccr[1]) { $ajub3 = $ccr[1]; }
    $vd[17] = $aju3;
    if ($tra) { print " ratiohei=$ratiohei - hei3=$hei3 - aspfin=$aspfinal=$vd[16]x$vd[17]\n"; }
    $aspfinal=nodecnb($vd[16] / $vd[17],4); print " (aspect ratio = $aspfinal)\n";
  }
}

###
sub ficmodmenc { # update vdriplist.sh file, should only be called after genficscript if no error occurred
  my($miarg, $fich) = @_; # miarg=ge - video pathname
  my($rc1,$cmde1,$rc2,$cmde2); #return code div,open file fichscript+test,chmod
  my($rcgen);
  my($rf,$fich2); # $fich without pathname

  $rf=rindex($fich, '/'); if ($rf<0) { $rf=-1; }
  $fich2 = substr($fich,$rf+1);	# name without pathname, or null if no path specification

  $rcgen=0; # code return of this function: 1:err, 0:noerr (not fatal)
  if ( ! -w "$fichlist") { # file-is-rw ok?
    if($flxpert) {
 	print "WARNING: file '$fichlist' is not writable, not updated : $!\n";
	print "Cannot modify the scripts list file (pending files to rip) until error fixed\n";
	print "File not added to scripts list files for: '$fich2'\n";
    }
    $rcgen=1;
  } else {
	$rc1=0; $rc2=0;
	# file list updated by a perl script
	print "File added to scripts list files for: '$fich2'\n";
	if ($tr) { print "TR.adding this script file to the list:$fichlist\n"; }
	$cmde1 = "sed -i -e 's:\^\#$fich:$fichscript $scriptpass \#$fich:' $fichlist";	# filename with pathname
	$cmde2 = "sed -i -e 's:\^\#$fich2:$fichscript $scriptpass \#$fich2:' $fichlist";	# filename w/o pathname
	if ($tr) { print "TR.exec.system:$cmde1#\n"; }
	if ($tr) { print "TR.exec.system:$cmde2#\n"; }
	$rc1=system($cmde1); if ($tr) { print "result rc1=$rc1 (ok if 0,bad if -1)\n"; }
	if ("$fich2") { $rc2=system($cmde2); if ($tr) { print "result rc2=$rc2 (ok if 0,bad if -1)\n"; } }
	if (($rc1==0)||($rc1==256)||($rc2==0)||($rc2==256)) {
	  print "Scripts list file updated: $fichlist\n";
	  print "Script name added: '$fichscript $scriptpass'\n";
	} else {
	  print "WARNING! Scripts list file cannot be updated: $fichlist (code err rc1=$rc1)\n";
	  $rcgen=1;
	}
  }
  return($rcgen);
}

###
sub chnamesimplify {    # From a filename (no ext,no path) get rid of special car.at end and in it
  my($fich) = @_;       # short name

  $fic = $fich;
  $fic =~ tr/A-Za-z0-9\-\.,_//cd;       # no special char in name,except -.,_
  $fic =~ s/[\-\.,_]*$//g;              # no punct at end
  $fic =~ s/--/-/g;
  return($fic);
}

###
sub playcropfilevNOTUSED { # alias pv : play this video in verbose mode,nocrop, from a minute or a -ss parameter
  my($miarg, $fich) = @_;	# pathname  ## NOT USED: Integrated into playcropfilec() ###
  my($r,$mifrom,$noloop,$cmde1,$rc1);

  $mifrom=chompsp(substr($miarg,2),0); $mifrom=chompsp($mifrom,0);
  $r=index($mifrom, ':');
  if (! $mifrom) {
    if ($currtime) { $noloop = $currtime; }
    else {	     $noloop = "00:00:00"; }
  }
  else {
    if ($r < 0) {    $noloop = "00:$mifrom:00"; }
    else {	     $noloop = "$mifrom"; }
  }

  if ($tr) { print "TR.trying playfile -ss $noloop ...\n"; }
  $cmde1 = "$cmdmpl $cmdlng3 $cmdmplvo -ss $noloop \"$fich\" 2\>/dev/null \&";
  if ($tr) { print "TR.exec.system:$cmde1#\n"; }
  $rc1=system($cmde1); if ($tr) { print "TR.result rc1=$rc1 (ok if 0|256,bad if -1)\n"; }
  return(0);
}

###
sub playcropfilec { # alias pc and pn, play a file with crop/without crop (nocrop), from current point
  my($miarg, $fich) = @_; # pathname, from minute or a -ss parameter
  my($r,$mifrom,$func,$noloop,$cmde1,$rc1,$flquiet);

  $mifrom=chompsp(substr($miarg,2)); $mifrom=chompsp($mifrom,0); $func=substr($miarg,0,2);
  $r=index($mifrom, ':');
  if (! $mifrom) {
    if ($currtime) { $noloop = $currtime;  }	# from this time
    else {	     $noloop = "00:00:00"; }	# from start of file
  }
  else {
    if ($r < 0) {	$noloop = "00:$mifrom:00";	} # nb of minutes
    else 	{	$noloop = "$mifrom";		} # a time format 0:0:0
  }

  if ($tr) { print "TR.trying playfile noloop= -ss $noloop mifrom=$mifrom\n"; }
  if (! $currcrop) { $currcrop = $vd[8];
  print "Warning! Crop parameter is now set to original crop vd8: $currcrop (vd8 is the original crop value)\n"; }
  if ($func eq "pv") {  # verbose without crop parameter
    $cmde1 = "$cmdmpl $cmdlng3 $cmdmplvo -ss $noloop \"$fich\" 2\>/dev/null \&";
  }
  if ($func eq "pc") {  # with crop parameter
    $cmde1 = "$cmdmpl -quiet $cmdlng3 $cmdmplvo -vf crop=$currcrop -ss $noloop \"$fich\" 2\>/dev/null 1\>/dev/null \&";
  }
  if ($func eq "pn") {  # without crop parameter
    $cmde1 = "$cmdmpl -quiet $cmdlng3 $cmdmplvo -ss $noloop \"$fich\" 2\>/dev/null 1\>/dev/null \&";
  }
  if ($tr) { print "TR.exec.system:$cmde1#\n"; }
  $rc1=system($cmde1);  if ($tr) { print "TR.result rc1=$rc1 (ok if 0|256,bad if -1)\n"; }
  return(0);
}

###
sub playstartfile { # alias ps/pp playfile normally at starting point (ps:no crop parameter)
  my($miarg, $fich) = @_;	# pathname, from minute or a -ss parameter
  my($r,$mifrom,$func,$noloop,$cmde1,$rc1);

  $mifrom=chompsp(substr($miarg,2)); $mifrom=chompsp($mifrom,0); $func=substr($miarg,0,2);
  $r=index($mifrom, ':');
  if ($r < 0) {	$noloop = "00:$mifrom:00"; }
  else {	$noloop = "$mifrom"; }

  if (! $currcrop) { $currcrop = $vd[8];
  print "TR: Warning! Crop parameter is now set to Ocrop vd8: $currcrop (vd8 is the original crop value)\n"; }
  if ($tr) { print "TR.trying playfile -ss $noloop ...\n"; }
  if ($func eq 'pp') {  # with/without crop parameter
	 $cmde1 = "$cmdmpl -quiet $cmdlng3 $cmdmplvo -vf crop=$currcrop -ss $noloop \"$fich\" 2\>/dev/null 1\>/dev/null \&";
  }
  else { $cmde1 = "$cmdmpl -quiet $cmdlng3 $cmdmplvo -ss $noloop \"$fich\" 2\>/dev/null 1\>/dev/null \&";
  }
  if ($tr) { print "TR.exec.system:$cmde1#\n"; }
  $rc1=system($cmde1); if ($tr) { print "TR.result rc1=$rc1 (ok if 0|256,bad if -1)\n"; }

  return(0);
}

###
sub setratefromprofile {	# Initialise rates variables from current profile selected,when a change occurs
  if ($flprofile == 2) { setvideobitrate("vb780"); }
  if ($flprofile == 3) { setvideobitrate("vb860"); }
  if ($flprofile == 4) { setvideobitrate("vb920"); }
  if ($flprofile == 8) { setaudiobitrate("ab$vd[14]"); setvideobitrate("vb2048"); } # optimum audio/video rates
  if ($optabitrate   ) { setaudiobitrate("ab$vd[14]"); # optimal audio bitrate
    $flprofile = 0;
  }
  if ($optvbitrate   ) { setvideobitrate("vb$vd[19]"); # optimal video bitrate::!!::TODO::!!::
    $flprofile = 0;
  }
  print "Bitrates audio and video set to: $rateaudio / $ratevideo\n";
  return(0);
}

###
sub setaudiobitrate { # alias ab
  my($miarg, $rate) = @_;	# audiobitrate: 64..480
  my($r,$mifrom,$mirate,$noloop,$cmde1,$rc1,$audiostd);

  $audiostd=":32:40:48:56:64:80:96:112:128:144:160:192:224:256:320:"; # mpeg2 adds :8:16:24: useless here
  $mifrom=chompsp(substr($miarg,2)); ; $mifrom=chompsp($mifrom,0); 
  #$mirate=chompsp($rate,0); # null value
  $mirate = "$mifrom";
  if ($mirate eq "") {
    $mirate=$vd[14]; # optimal value
  }
  if ($mirate>$vd[14]) {
    print "ERROR: the audio bitrate cannot not greater than the MPEG2 nominal value:$vd[14]\n";
    $reperror = "Current audio bitrate unchanged: $rateaudio";
    print "$reperror\n";
    return(1);
  }
  if ((($mirate<64) || ($mirate>480)) || (index($audiostd,":$mirate:")<0)) {
    print "ERROR: the audio bitrate value should be one of these:\n";
    $audiostd =~ s/:/ /g;
    print "  $audiostd\n";
    print "	  Enter a command like 'ab192' to set it to 192 kbps\n";
    $reperror = "Current audio bitrate unchanged: $rateaudio";
    print "$reperror\n";
    return(1);
  } else {
    $rateaudio=$mirate;
  }
  print "Current audio bitrate set to: $rateaudio\n";
  return(0);
}

###
sub setvideobitrate { # alias vb
  my($miarg, $rate) = @_;	# videobitrate: 480..4096
  my($r,$mifrom,$mirate,$noloop,$cmde1,$rc1);

  $mifrom=chompsp(substr($miarg,2)); ; $mifrom=chompsp($mifrom,0);
  #$mirate=chompsp($rate,0); # null value
  $mirate = "$mifrom";
  if ($mirate eq "") {
    $mirate="0"; # error in value
  }
  if (($mirate<480) || ($mirate>4096)) {
    print "ERROR: the video bitrate value should be between 480 to 4096\n";
    print "	  Enter a command like 'vd920' to set it to 920 kbps\n";
    $reperror = "Current video bitrate unchanged: $ratevideo";
    print "$reperror\n";
    return(1);
  } else {
    $ratevideo=$mirate;
  }
  print "Current video bitrate set to: $ratevideo\n";
  if ($mirate>2048) {
    print "Notice that video bitrates greater than 2048 kbps are not recommended\n";
    print "for portable devices.\n";
  }
  return(0);
}

###
sub settime { # alias st
  my($miarg, $fich) = @_;	# pathname, from minute or a parameter with ":"
  my($r,$mifrom,$noloop,$cmde1,$rc1);

  $mifrom=chompsp(substr($miarg,2)); $mifrom=chompsp($mifrom,0);
  $r=index($mifrom, ':');
  if ($r < 0) {	$currtime = "00:$mifrom:00"; }
  else {	$currtime = "$mifrom"; }
  print "Current time parameter set to: $currtime\n";

  return(0);
}

###
sub setduration { # alias sd
  my($miarg, $fich) = @_;	# pathname, from second or a parameter with ":"
  my($r,$mifrom,$noloop,$cmde1,$rc1);

  $mifrom=chompsp(substr($miarg,2)); $mifrom=chompsp($mifrom,0);
  $r=index($mifrom, ':');
  if ($r < 0) {	$currduration = "00:00:$mifrom"; }
  else {	$currduration = "$mifrom"; }
  print "Current duration parameter set to: $currduration\n";
  print "(for avdanced users only: used when mencoding a fast short sequence)\n";

  return(0);
}

###
sub setcrop { # alias sc
  my($miarg, $fich) = @_;	# pathname
  my($r,$mifrom,$rc1);

  $mifrom=substr($miarg,2); $mifrom=chompsp($mifrom,0);
  if (! $mifrom) {
    $currcrop = $vd[8]; @vdcall = (@vdcall, $currcrop);
    print "Crop parameter is now set to: $currcrop (as Original cropdetect value)\n"; }
  else {
    $r=index($mifrom, ':'); # could make a better coherence test of the parameter
    if ($r < 0) { 
	$reperror = "ERROR: a setcrop parameter should be given in a format nnn:nnn:nnn:nnn";
	print "$reperror\n";
        return(0);
    }
    else {
	$currcrop = "$mifrom"; @vdcall = (@vdcall, $currcrop);
	print "Crop parameter has been set to: $currcrop\n"; }
  }
  getaspcalc("ac"); # automatically aspect computing
  return(0);
}

###
sub setcropv { # alias sv: reset crop param from the one stored in @vdcall[nn] providing nn as the indice
  my($miarg, $fich) = @_;
  my($r,$mifrom,$rc1);

  $mifrom=substr($miarg,2); $mifrom=chompsp($mifrom,0);
  #if (($mifrom != 8) && ($mifrom != 10)){ $mifrom = 8; }
  if (($mifrom < 0) || ($mifrom > $#vdcall)) {
    $reperror = "Crop parameter unchanged (bad argument: '$mifrom')";
    print "$reperror\n";
    print "  Enter a value after ':' than is egal or between 0 and $#vdcall\n";
    print "  The value should be one in the in the list vdcall[] (and displayed by command 'ta')\n";
    return(0);
  }
  $currcrop = $vd[$mifrom]; @vdcall = (@vdcall, $currcrop);
  print "Crop parameter has been reset to: $currcrop\n";
  getaspcalc("ac"); # automatically aspect computing
  return(0);
}

###
sub setaspect { # alias sa
  my($miarg, $fich) = @_;	# pathname
  my($r,$mifrom,$rc1,@ccr,$oldv16,$oldv17,$aju);

  $oldv16=$vd[16]; $oldv17=$vd[17]; # save old parameter,in case incorrect given values
  $aju=0;
  $mifrom=substr($miarg,2); $mifrom=chompsp($mifrom,0);
  if (! $mifrom) { # set aspect as current crop values
    @ccr = split(/:/, $currcrop); # values rendered by crop detect
    print "Warning! You mean that aspect ratio be set at same value as current crop value: $currcrop.\n";
    print "OK, let's try..\n";
  }
  else {
    $r=index($mifrom, ':');
    if ($r < 0) { # only one value for height has been given
      $ccr[1]=$mifrom;
    }
    else {
      @ccr = split(/:/, $mifrom); # two values entered with a ':'
    }
  }
  # check values are 16-multiples
  if (($ccr[0] % 16) || ($ccr[1] % 16)) { # value mod 16 : not ok?
    # automatically fix to 16-multiples
    if ($ccr[0] % 16) { $ccr[0]=nodec($ccr[0] / 16) * 16; print "Warning:  width ajusted to 16-multiple: $ccr[0]\n"; $aju=1; }
    if ($ccr[1] % 16) { $ccr[1]=nodec($ccr[1] / 16) * 16; print "Warning: height ajusted to 16-multiple: $ccr[1]\n"; $aju=1; }
  }
  # now store new aspect ratio values
  $vd[16] = $ccr[0];
  $vd[17] = $ccr[1];
  print "Aspect ratio set at: $vd[16]:$vd[17] "; if ($aju) { print "(ajusted!)"; }
  print "\n";
  # should have same behaviour as getaspcalc();
  return(0);
}

###
sub setcroph { # alias sh... : shp,shm (set crop modify height)
  my($miarg, $fich) = @_;	# pathname
  my($r,$mifrom,$rc1,@tt,$func,$fact,$ind1,$par1,$par2);

  $mifrom=substr($miarg,2); $mifrom=chompsp($mifrom,0); $func=substr($miarg,2,1); $fact=substr($miarg,3,1);
  if (! $fact) { $fact=1; }
  $r=index($mifrom, ':');
  if ($tr) { print "TR! mifrom=$mifrom,func=$func,fact=$fact,r=$r,miarg=$miarg\n"; }
  @tt=split(/:/, $currcrop);
  if (($func eq '+') || ($func eq 'p')) {
    $ind1=getindtcrh($tt[1]);
    if ($ind1 < 0) { print "ERROR: Parameter error for $mifrom,func=$func,tt1=$tt[1],ind1=$ind1\n"; return(-1); }
    $par1=$tcrh[$ind1+$fact]; $par2=$tt[3]+(8*$fact);
    $tt[1]=$par1; $tt[3]=$par2;
    $mifrom=$tt[0].':'.$tt[1].':'.$tt[2].':'.$tt[3];
  }
  if (($func eq '-') || ($func eq 'm')) {
    $ind1=getindtcrh($tt[1]);
    if ($ind1 < 0) { print "ERROR: Parameter error for $mifrom,func=$func,tt1=$tt[1],ind1=$ind1\n"; return(-1); }
    $par1=$tcrh[$ind1-$fact]; $par2=$tt[3]-(8*$fact);
    if ($par1 < 0) { $par1=0; }
    if ($par2 < 0) { $par2=0; }
    $tt[1]=$par1; $tt[3]=$par2;
    $mifrom=$tt[0].':'.$tt[1].':'.$tt[2].':'.$tt[3];
  }
  $currcrop = "$mifrom"; @vdcall = (@vdcall, $currcrop);
  print "Crop parameter is now set to: $currcrop (factor=$fact)\n";
  getaspcalc("ac");
  return(0);
}

###
sub setcropw { # alias sw... : swp,swm (set crop modify width)
  my($miarg, $fich) = @_;	# pathname
  my($r,$mifrom,$rc1,@tt,$func,$fact,$ind1,$par1,$par2);

  $mifrom=substr($miarg,2); $mifrom=chompsp($mifrom,0); $func=substr($miarg,2,1); $fact=substr($miarg,3,1);
  if (! $fact) { $fact=1; }
  $r=index($mifrom, ':');
  if ($tr) { print "TR! mifrom=$mifrom,func=$func,fact=$fact,r=$r,miarg=$miarg\n"; }
  @tt=split(/:/, $currcrop);
  if (($func eq '+') || ($func eq 'p')) {
    $ind1=getindtcrw($tt[0]);
    if ($ind1 < 0) { print "ERROR: Parameter error for $mifrom,func=$func,tt1=$tt[0],ind1=$ind1\n"; return(-1); }
    $par1=$tcrw[$ind1+$fact]; $par2=$tt[2]+(8*$fact);
    $tt[0]=$par1; $tt[2]=$par2;
    $mifrom=$tt[0].':'.$tt[1].':'.$tt[2].':'.$tt[3];
  }
  if (($func eq '-') || ($func eq 'm')) {
    $ind1=getindtcrw($tt[0]);
    if ($ind1 < 0) { print "ERROR: Parameter error for $mifrom,func=$func,tt1=$tt[0],ind1=$ind1\n"; return(-1); }
    $par1=$tcrw[$ind1-$fact]; $par2=$tt[2]-(8*$fact);
    if ($par1 < 0) { $par1=0; }
    if ($par2 < 0) { $par2=0; }
    $tt[0]=$par1; $tt[2]=$par2;
    $mifrom=$tt[0].':'.$tt[1].':'.$tt[2].':'.$tt[3];
  }
  $currcrop = "$mifrom"; @vdcall = (@vdcall, $currcrop);
  print "Crop parameter is now set to: $currcrop (factor=$fact)\n";
  getaspcalc("ac");
  return(0);
}

###
sub getindtcrh { # return indice of value in the @tcrh array
  my($mval) = @_;
  my($i,$retind);

  $i=0; $retind=-1;
  for ($i=0; $i<= $MAXtcr; $i++) {
    if ($mval == $tcrh[$i]) { $retind = $i; last; }
  }
  return($retind);
}

###
sub getindtcrw { # return indice of value in the @tcrw array
  my($mval) = @_;
  my($i,$retind);

  $i=0; $retind=-1;
  for ($i=0; $i<= $MAXtcr; $i++) {
    if ($mval == $tcrw[$i]) { $retind = $i; last; }
  }
  return($retind);
}
###
sub getmplayerlength {		# return the mplayer movie duration in seconds(use mencoder)
my($codmsg,$abr,$fic) = @_;	# 1:display message,avr:nominal audio-bitrate en kbs,filename
my($mensec,$asize,$vsize);	# nbr.sec returned by mencoder,may be very slow(read the entire file)
my($fsizeb,$fsize,$tmatch,$ttime);# filesize in MiB,supposed movie duration length(according to title)
my($avvbrate,$thhmmss,$mhhmmss);# average bitrate computed,hhmmss for time returned by title and mencoder

  $fsizeb=(-s "$fic"); # filesize in octets
  $fsize =($fsizeb)/(1024**2); $fsize =~ s/\.[0-9]*//; # filesize in MiB (int)
  $ttime=""; $tmatch = $fic =~ /(\d{1,2})(h)(\d{2})/; # format MUST be nhnn in the title,ex: 1h45 for 1 hour and 45 minutes
  if ($tmatch) { $ttime = "$&"; $ttime=datetimhtosec($ttime);
    if ($codmsg) { $thhmmss=datesectohms($ttime);
      print "File  Size in MiB = $fsize (ttiming=$ttime sec - $thhmmss)\n";
    }
  }
  if ($codmsg) { print "Determining file timing,please wait... [may be very very long]\n"; }
  $mensec=`$cmdmen \"$fic\" -ovc copy -nosound -ovc copy -nosound -o /dev/null -quiet 2>&1 | awk '/^Video stream:/{print \$10+\$10/\$12}'`; chomp($mensec);
  if ($codmsg) { $mhhmmss=datesectohms($mensec);
    print "Movie duration sec= $mensec time= $mhhmmss (abr=$abr)\n";
  }
  $asize=$abr * $mensec / 8.0 / 1024.0 ; $asize =~ s/\.[0-9]*//; # soundtrack audiosize in MB (int)
  if ($codmsg) { print "Audio Size in MiB = $asize\n"; }
  $vsize=$fsize - $asize;
  if ($codmsg) { print "Video Size in MiB = $vsize\n"; }
  $avvbrate=$vsize * 1024.0 * 1024.0 * 8.0 / 1000.0 / $mensec; $avvbrate =~ s/\.[0-9]*//; # in Kbps
  if ($codmsg) { print "Video averag.brate= $avvbrate Kbps\n"; }

  # nb of sec(menc),audio and video sizes(computed),movie-duration-in-title,average video bitrate(computed)
  return($mensec,$asize,$vsize,$ttime,$avvbrate);

}
###
sub getmplayerlng { # return the mplayer -alang option 2 and 3 letters language code
my($rx,$rx2,$rx3);  # system-env-lng,2letters,3letters language code

  $rx=substr("$ENV{'LANG'}",0,2); # system env language
  $rx2="-alang $rx"; # 2 letter3 mplayer alang option
  $rx3="";	# compute the 3 letters alone
     if ($rx eq "ar") { $rx3  = "ara"; }
  elsif ($rx eq "en") { $rx3  = "eng" ;}
  elsif ($rx eq "da") { $rx3  = "dan"; }
  elsif ($rx eq "de") { $rx3  = "deu"; } # can also be "ger"
  elsif ($rx eq "eo") { $rx3  = "epo"; }
  elsif ($rx eq "es") { $rx3  = "spa"; }
  elsif ($rx eq "el") { $rx3  = "gre"; } # can also be "ell" (greek)
  elsif ($rx eq "fi") { $rx3  = "fin"; }
  elsif ($rx eq "fr") { $rx3  = "fra"; }
  elsif ($rx eq "he") { $rx3  = "heb"; }
  elsif ($rx eq "it") { $rx3  = "ita"; }
  elsif ($rx eq "la") { $rx3  = "lat"; }
  elsif ($rx eq "nl") { $rx3  = "dut"; } # can also be "nld"
  elsif ($rx eq "no") { $rx3  = "nor"; }
  elsif ($rx eq "pl") { $rx3  = "pol"; }
  elsif ($rx eq "pt") { $rx3  = "por"; }
  elsif ($rx eq "ru") { $rx3  = "rus"; }
  elsif ($rx eq "sv") { $rx3  = "swe"; }
  elsif ($rx eq "tr") { $rx3  = "tur"; }
  # we can add others here
  else		      { $rx3  = "";    }

  # 3 letters mplayer alang option
  if ($rx3) { $rx3="-alang $rx3"; } # else should be empty ""
  return($rx,$rx2,$rx3);
}
###
sub getvddata { # fill in array @v[] with data found in file $fil,return <0 if error,0 if ok.
  my($codini, $fil) = @_ ;  # code initial (0:if called from processheader), pathname
  my($vdret,$lig,$nolig,$ch,$chasp); # ret code, tempo var, current numlig, tempo
  my($rr,$r1,$r2,$cr,$cle,$nocle,$clematch,$clevalue);
  my($rv1,$rv2); # extraction of VO Config output aspect to $vd[15]
  my(%vdc); # cropdetect data values, main encountered stored in $vd[?]
  my(@asp,@acr);
  my($oldvd8,$cw1,$cw2,$cw3,$cw4,$ch1,$ch2,$ch3,$ch4,$acr3old);	# check var for width/height and old picture w/h centering
  my($pixmedian,$pixrest,$pixpictsmaller,$pixpictsize);		# var.compute NEW H.CENTERING

  $vdret=0; $nolig=0; $nocle=0;

  if (! open(FTE, "$fil")) { $vdret = -1; }
  else {

    while ( $_ = <FTE>) {
      chomp($_);
      $nolig++;
      if ($_ ne "") {
	  #print "TR: line $nolig:$_ \n";# print substr($_,0,17); print "#\n";
	# here begin SWITCH: simulated
	  if    (substr($_,0,20) eq '[file] File size is ') { $vd[1]=chgetword($_, 4); }
	  elsif (substr($_,0, 6) eq 'VIDEO:') { $vd[2] = $_; $vd[2] =~ s/\(|\)//g ; }
	  elsif (substr($_,0, 6) eq 'AUDIO:') { $vd[3] = $_; $vd[3] =~ s/\(|\)|,//g ; }
	  elsif (substr($_,0,12) eq 'Movie-Aspect') { $vd[4]=noafterdel(chgetword($_, 2),':'); }
	  elsif (substr($_,0, 9) eq 'VO Config') { $vd[5] = $_; $vd[5] =~ s/\(|\)//g ; }
	  elsif (index($_,'[CROP] Crop area:') >= 0 ) {
		$r1=index($_,'crop=',17); $r2=index($_,')',$r1+5); # print "TR::r1,r2=$r1,$r2\n";
		if (($r1>=0) && ($r2>$r1)) {
		  #store it in %vdc substr car.$r1 to $r2
		  $cr=substr($_,$r1+5,$r2-$r1-5); $nocle++;
		  if ($vdc{$cr} == 0) { # fill in array crop values: -vf crop=
		    $vdc{$cr} = 1;   # print "cr=$cr# set to 1\n";
		  } else {
		    $vdc{$cr} += 1;  # print "cr=$cr# incremented:$vdc{$cr}\n";
		  }
		}
	  }
	  else    { $rr=1; # print "TR::switch:default\n";
	  } # default switch:
	  #print "TR::switch:any\n";
      } # end if $_ switch:

    } # while $_
    close(FTE);
    $vd[12]=chgetword($vd[2],2); # video mpeg resolution (ex: 544x576)
    $vd[13]=chgetword($vd[2],4); # video code asp (ex: 3)
    $vd[14]=nodec(chgetword($vd[3],6)); # audio rate no decimal
    $vd[15]="";
    $rv1=index($vd[5],'>',0); $rv2=index($vd[5],',',0); #ex: VO Config 720x576->1024x576,flags=0,'MPlayer',0x4D504553
    if (($rv1>=0)&&($rv2>$rv1)) {	#		     012345678901234567890123456789
      $vd[15]=substr($vd[5],$rv1+1,$rv2-$rv1-1); # mpeg2 resolution,ex: 1024x576
    }
    $vd[18]=chgetword($vd[2],5); $vd[18] =~ s/\.0{1,3}$//; # video fps ex:25.000 -> 25
    $vd[19]=chgetword($vd[2],7); $vd[19] =~ s/\.0{1,3}$//; # video mpeg2 bitrate ex:3068.0 -> 3068
    $vd[6]= $nocle;
    if ($tr) { print "Original total nr of cropdetect lines=$vd[6]\n"; }

    # test coherence in results after this temp file has been generated:
    if ( ($vd[1] eq "") || ($vd[2] eq "") || ($vd[3] eq "") || ($vd[4] eq "") || ($vd[5] eq "") ) {
	return(-4); # either one parameter is missing
    }
    # end of processing if just get file initial caracteristics
    if ($codini == 0) {
      if ($tr) { print "Initial data got in vd(0..6)\n"; } # exit if called from processheader()
      return($vdret);
    }
    if ($nocle==0) { return(-2); } # nocrop detect found
    # search in cropdetect array,best match occurrence and most coherent
    while(1) {
      $clematch="";$clevalue=0;$nocle=0;
      foreach $cle (sort keys(%vdc)) {
        #print "cle=$cle,val=$vdc{$cle}\n";
        $nocle += $vdc{$cle};
        if ($vdc{$cle} > $clevalue) { $clevalue = $vdc{$cle} ; $clematch=$cle ; }
      }
      if ($tr) { print "CROP: nbcle=$nocle, biggest match: $clematch with occurrence:$clevalue\n"; }
      #store in #7 #8 #9 first biggest values
      if ($vd[7]==0) { $vd[7]= $nocle; $vd[8]= $clematch; $vd[9]= $clevalue; }
      #memo.this current occurrence
      $vd[10]= $clematch; $vd[11]= $clevalue; # memo biggest occurrence
      # detection no key left in %vdc,if so retest biggest first occurrence if /16
      if ($nocle==0) {
	@acr = split(/:/, $vd[8]);
	if (($acr[0] % 16 == 0) && ($acr[1] % 16 == 0)) { # value mod 16 : ok?
	  $vd[10]= $vd[8]; $vd[11]= $vd[9]; # if so, force to use those anyway.
	  last; # old: return(0); enhanc.20090306
	} else {
	  return(-3);
	}
      }
      # determinate optimal aspect:  $vd[2]-> @asp (array aspect: larg,height)
      # to compare with: $vd[10]-> @acr (array cropdetected: larg,height,crop.larg,crop.height)
      $chasp=chgetword($vd[2],2);  #2nd field
      @asp = split(/x/,$chasp);
      @acr = split(/:/, $vd[10]);
      # test coherence: asp0 must = acr0 + 2xacr2  AND  asp1 must = acr1 + 2xacr3
      if  ( ($asp[0]) == ($acr[0] + 2*$acr[2]) &&
	    ($asp[1]) == ($acr[1] + 2*$acr[3]) ) {
		if ($tr) { print "Found values for: $chasp=>$vd[10]\n" ; }
		last; # ok # old: return(0); enhanc.20090306
      } else {
        # suppress theses values in cropdetect array,and re-process it
        $vdc{$clematch} = 0;
      }
    } # while1

    # note that vd16,vd17 (width,height) recommended aspect radio for mencoder is done by getaspcalc.
    # In some case the crop data should be corrected to address 2 kinds of issues:
    # the picture has some successive black and white horizontal segments at top of the screen,
    # or a bad situated logo stands between picture and black bands, so  I try to fix that!
    @asp=() ; @acr=(); $cr=""; # re-use variables
    $cw1=0; $cw2=0; $ch1=0; $ch2=0; 
    @acr = split(/:/, $vd[8]); # ex:496:560:24:0 (crop detect values in vd8 !)
    $oldvd8=$vd[8];
    @asp = split(/x/, $vd[12]); # ex:544x576 or 720x576 (original mpeg resolution)
    if ($tr) { print "TR.CENTER.old.val: vd8='$vd[8]'  vd10='$vd[10]'  vd12asp='$vd[12]'\n"; }

    # check width OLD-METHOD(quick):  544-496 ~= 24 x 2 (at -4/+4); ifnot 24 -> (544-496)/2
    $cw1 = $asp[0] - $acr[0]; $cw2 = $cw1 - ($acr[2]*2) ;
    if (($cw2 < -4) || ($cw2 > 4)) {
      $cr="WIDTH" ; $acr[2] = int($cw1 / 2);
    }

    # check width OLD-METHOD(quick):  576-560 ~=  0 x 2 (at -4/+4); ifnot  0 -> (576-560)/2
    # FUTURE METHOD TODO::!!::!!:: check height2: ch1::  576-512 ~=  64;  ch2:: 64-62*2=-60; (at -4/+4); ifnot  0 -> (576-560)/2
    #ex.old.si: asp=720x576 et acr=688:512:18:62, ch1=576-512=64, ch2=64-(62*2)=-60, oui donc acr3=64/2=32
    $ch1 = $asp[1] - $acr[1]; $ch2 = $ch1 - ($acr[3]*2) ;
    if (($ch2 < -4) || ($ch2 > 4)) {	# Here I detect picture should be centered(height)
      $cr.=" HEIGHT" ; $acr3old = int($ch1 / 2);
      if ($tr) { print "TR.HCENTERing:  ch1:$ch1 ch2:$ch2 acr3:$acr[3] acr3old:$acr3old -> acr:@acr\n"; }
      # Now new method ex.if: asp=720x576 with case1 acr=688:512:18:62  *OR*  case2 acr=688:512:18:2
      $pixmedian=int(($asp[1]-$acr[1])/2); # (576-512)/2=32; # if >,the picture shifted down # if <,the picture shifted up
      # recenter if delta lag > -2/+2 from median value
      if (($acr[3] < $pixmedian-2) || ($acr[3] > $pixmedian+2)) { # do it
	if ($acr[3] > ($pixmedian+2)) { # decay to shift picture up
	  #       =576-512-62=2					=62-2=60			  =512-60=452
	  $pixrest=$asp[1] - $acr[1] - $acr[3];	 $pixpictsmaller=$acr[3] - $pixrest;  $pixpictsize=$acr[1] - $pixpictsmaller;
	} else { # decay to shift picture down
	  #	  =576-512-2=62					=62-2=60			  =512-60=452 
	  $pixrest=$asp[1] - $acr[1] - $acr[3];	 $pixpictsmaller=$pixrest - $acr[3];  $pixpictsize=$acr[1] - $pixpictsmaller;
	  $acr[3]=$pixpictsmaller+$acr[3]; # shift down the picture (2->62)
	}
	# -> 688:452:18:62 *OR* 688:452:18:2
        $acr[1]=multiplenearest($pixpictsize,16); # -> 688:448:18:62 ou 688:448:18:2
      }
    }

    if ($tr) { print "TR.CENTER: cw1:$cw1  cw2:$cw2  ch1:$ch1  ch2:$ch2  acr2=$acr[2] acr3=$acr3old \n"; }
    if ($tr) { print "TR.WCENTER.NEW: median:$pixmedian rest:$pixrest  smaller:$pixpictsmaller  psize=$pixpictsize\n"; }

    # If image centering occurred, signal-it
    if ($cr) {
	$cr=chompsp($cr, 0);
	$reperror = "Cropdetect processed image centering ($cr)";
	$vd[8]="$acr[0]:$acr[1]:$acr[2]:$acr[3]"; # debugging: comment this line, if want always NO centering
	print "Crop parameter has been set to: $vd[8] (image centering)\n"; # from $oldvd8
	@vdcall = (@vdcall, $oldvd8);
	if ($tr) { print "TR.CENTER.new.val: vd8='$vd[8]'  vd10='$vd[10]'  vd12asp='$vd[12]'\n"; }
    }

  } # if !open
  return($vdret);
} #

###
sub killplay { # alias k : kill the mplayer
  my($miarg) = @_;	# function
  my($rc2,$rc3,$nokill,$cmdmpl2);
# my($mifrom); $mifrom=substr($miarg,2); $mifrom=chompsp($mifrom,0);

  $cmdmpl2=$cmdmpl;
  @proclist=getproclist($cmdmpl2);
  if ($tr) { print "TR.killplay($miarg): proclist=@proclist# "; print "(nolast=$#proclist)\n"; }

  if ($#proclist< 0) {
    print "Warning: killplay cannot stop the video window, probably no video is running\n";
    print "Internal status= miarg:'$miarg' ($cmdmpl2)\n"; return(1); # warning only
  }

  $nokill=0; # watchdog loop-max
  while ($#proclist >= 0) {
    $nokill++;
    if ($nokill >= 7) { sleep(1); }  # it is slow, so give time to kill proc
    if ($nokill > 3) {
      $rc3 = kill 'KILL', @proclist ; if ($tr) { print "killplay($miarg): result rc3 killKILL=$rc3\n"; }
    } else {
      $rc2 = kill 'QUIT', @proclist ; if ($tr) { print "killplay($miarg): result rc2 killQUIT=$rc2\n"; }
    }
    @proclist=getproclist($cmdmpl2);
    if ($nokill > 10) {
	if ($tr) { print "TR.killplay($miarg): Procid @proclist cannot be killed! ($cmdmpl2)\n"; }
	print "Warning: killplay cannot stop the video playback window, probably already stopped (no problem!)\n";
	return (1);
    }
  }
  if ($tr) { print "TR.killplay($miarg): procid killed ok ($cmdmpl2)\n"; }
  return(0);
}

###
sub multiplenearest {	# make number the nearest multiple of nbm
  my($nbr,$nbm) = @_ ;	# number, and the multiple (does NOT round it)
  my($r,$nbrint,$ee,@mult,@delta,$m);
  my($smallestind,$smallestval);

  $nbrint=int($nbr / $nbm);
  if ($tr) { print "TR.multiplenearest($nbr,$nbm),nbrint=$nbrint\n"; }
  $m=0; $smallestind=-1; $smallestval=999999;
  for ($ee=$nbrint-1; $ee<=$nbrint+1; $ee++) {
    $mult[$m]=$ee * $nbm;			# multiple of $nbm
    $delta[$m]=abs(($ee * $nbm) - $nbr);	# delta from $nbr
    if ($delta[$m] < $smallestval){
	$smallestind=$m; $smallestval=$delta[$m];
    }
    if ($tr) { print "m:$m, ee:$ee, ind:$smallestind, val:$smallestval, multm:$mult[$m] deltm=$delta[$m]\n"; }
    $m++;
  }
  if ($tr) { print "TR.multiplenearest$nbm ret:$mult[$smallestind]\n"; }
  return($mult[$smallestind]);
}  

###
sub nodec { #	no decimal, suppress decimal and following car.in a float
  my($nbr) = @_ ;		# does NOT round it
  my($r,$nbrint);

  $nbrint=$nbr;
  $r=index($nbr,'.',0);
  if ($r>=0) { $nbrint=substr($nbr,0,$r); }
  return($nbrint);
}
###
sub nodecnb { #	no more nb decimal, delete decimal and following char.in a float
  my($nbr,$nbdec) = @_ ;	# does NOT round it
  my($r,$nbrint);

  $nbrint=$nbr;
  $r=index($nbr,'.',0);
  if ($r>=0) { $nbrint=substr($nbr,0,$r+$nbdec+1); }
  return($nbrint);
}
###
sub noafterdel {	# in string nothing after the char delimitor given in arg
  my($ch, $del) = @_ ;	# string and delimitor, everything from-and-after '$del' is deleted
  my($r,$res);

  $res=$ch;
  $r=index($ch,$del,0);
  if ($r>=0) { $res=substr($ch,0,$r); }
  return($res);
}
###
sub getproclist {  # get a list of process-id for a program given as a parameter
  my($uti) = @_ ;  # name of the program to search for proc-id
  my($procids);	   # return a list of proc-ids with space separated
  my(@prid);

  if ($tr) { print "getproclist: uti='$uti' cmdps='$cmdps'  prog0='$prog0'\n"; }
  $procids=`$cmdps -ef | grep "$uti" | grep -v grep | grep -v '$cmdps' | grep -v '$prog0' | awk '{ print \$2}' | awk '{ printf " %s", \$1 }'`;
  $procids = chompsp($procids, 0);
  @prid = split(/\s+/ ,$procids);
  if ($tr) { print "procids=$procids#prid=@prid#\n"; }
  return(@prid);

}
###
sub dirbase {
  my($pn) = @_ ;  # pathname, returns path/,name,.extension
  my ($r,$pa);
  $pa=".";
  $r=rindex($pn,'/');
  if ($r>=0) { $pa = substr($pn,0,$r); }
  #print "r=$r\n"; #debug
  return($pa);
}
###
sub basenameext {
  my($pn) = @_ ;  # pathname, returns basename.extension
  my ($r,$pa);
 
  $r=rindex($pn,'/');
  if ($r<0) { $pa=$pn; }
  else { $pa = substr($pn,$r+1); }
  #print "r=$r\n"; #debug
  return($pa);
}
###
sub mydatetime { # returns DateTime in format log,format=20040416.HHMMSS
  my($timc,$dat); # modif HHMMSS no seconds in this one
  my($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$idst);

  $timc=time();
  ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$idst)=localtime($timc);
  $dat=sprintf("%04d%02d%02d.%02d%02d%02d",
        $year+1900,$mon+1,$mday,$hour,$min,$sec);
  if ($tr) { print "Now is date-time=$dat (timc=$timc)\n"; }
  return($dat);
}
###
sub datetimhtosec {	# Give time number,return number of second. Format: hour like: "3h30" for 3 hours and a half,
  my($hour) = @_;	# 210mn for time in number of minutes, and hhmm a real time in 24hour clock
  my($rh,$rm,$nbh,$nbm,$nbs ); # index, number of hours and mn

  $nbs=0; $nbh=0; $nbm=0;
  $hour =~ tr/A-Z/a-z/;   # to lowercase
  $rh = index($hour,'h'); $rm = index($hour,'mn');
  if ($rh >= 0) { # case duration in hour,h,minutes
    if ($rh > 0) { $nbh = substr($hour,0,$rh) ; } # hour given
    $nbm = substr($hour,$rh+1);
  }
  elsif ($rm >= 0) {
    if ($rm > 0) { $nbm = substr($hour,0,$rm) ; } # nbr.of minutes
    # else 0 minutes!
  }
  else { # hour,minutes of end: hhmm
    $nbm = 240 ;# NOT IMPLEMENTED::!!
  }
  $nbs = ($nbh * 3600) + ($nbm * 60); # result in number of seconds
  return($nbs)

} # datetimhtosec
###
sub datesectohms { # [v2] return a duration in seconds to a format hh:mn:ss
  my($ff) = @_ ; 
  my($hh,$mm,$ss, $ch);

  if ($ff <= 0.0) {
    return("");
  } else {
    $hh = nodec($ff/3600.0);	$ff -= $hh*3600.0;
    $mm = nodec($ff/60.0);	$ff -= $mm*60.0;
    $ss = nodec($ff);		$ff -= $ss;
    $ch=sprintf "%02d:%02d:%02d", $hh,$mm,$ss ;
  }
  # $ff contains the rest (in millionnieme seconds),ex: 0.440000 sec;
  $ff=nodecnb($ff,3);
  #$ch .= substr($ff,1); # suppress if dont want decimals
  return($ch);

}
###
sub chgetword { # in a string,get word number: -1 for last, 0 for first, 1 for 2nd word...
  my($ch, $noword) = @_ ;
  my(@array,$numlast);

  @array = split(/\s+/ , $ch);
  $numlast= $#array;

  #print "ch=$ch#\nnumdem,numlast:$noword , $numlast\n";

  if (($noword < -1) || ($noword > $numlast)) { return (""); }
  else {
    if ($noword == -1) { $noword = $numlast; }
    return($array[$noword]);
  }
} # end:chgetword
###
sub chompsp {		# chomp and also for spaces+TAB+CR+LF at begin/end of string
  my($a , $f) = @_ ;	# string, flag -1 | 0 | +1   at begin,any,end

  # print "chomp of:$a#\n";
  if ($f <= 0) {
    while ( $a =~ s/^\s// ) {}
  }
  if ($f >= 0) {
    while ( $a =~ s/\s$// ) {}
  }

  # print "chomp est:$a#\n";
  return($a);
}
###
sub getlig {		# Enter an answer, q=quit directly, line may be null(no space,CR)
  my($flquit) = @_;	# if flag=1 exit if 'quit' entered, flag=0 return "q"(more),specific for VDRIP

  $rep = <STDIN>; chomp($rep); $rep=chompsp($rep,0);
  if ( ($rep =~ /^q\b/i) || ($rep =~ /^qui/i) ) {
    if ($flquit) {
      if (-e "$fictmp") { unlink "$fictmp"; }
      print "Quit. ( $0 )\n";
      exit(0);
    } else {
      return("q");
    }
    #$rep="";
  }
  return($rep);
}
###
sub genficscript { # write script file : generate a script for ripping
  my($miarg, $fich) = @_;
  my($mifrom,$r,$func,$fact);
  my($rc1,$rfs,$rch,$cmde1); #return code div,open file fichscript+test,chmod
  my($vidrate,$audrate,$floldsnd,$fldes,$avireso);
  my($rcgen,$datc);

  $rcgen=0; # code return of this function: 1:err, 0:noerr
  $mifrom=chompsp(substr($miarg,2),0); $mifrom=chompsp($mifrom,0); 
  $func=substr($miarg,2,1); $fact=substr($miarg,3,1); # func=subfunction if needed
  if ($tr) { print "miarg=$miarg , mifrom=$mifrom , func=$func# fact=$fact#\n"; }
  $r=index($mifrom, ':');
  $datc=mydatetime();
  if ($vd[1]) { # if there are mpeg information data available
    # script can be generated
    $rfs=open(FTS,  ">".$fichscript);
    if (! $rfs) { # openfile-rw ok?
 	$reperror = "ERROR! Cannot write file '$fichscript'\n";
	print "$reperror\n";
	print "       while opening in 'mode write': $! (er='$rfs')\n";
	print "Please supply access and write permissions to be able to write this file\n";
	print "Suggestion: Fix the error, and redo the same processing.\n";
	$rcgen=1;
    } else {
	# Script generation Begin PART.1(variable part)
	print FTS "\#!/bin/bash\n";
	print FTS "\#generated by $vdrname version:$ver  dated:$datc\n";
	# script header: with a comment like in printmenu!
	if (($vd[16]) && ($vd[17])) { $avireso = sprintf("%1.2f", $vd[16] / $vd[17] ); }
	print FTS "\#$vdrname - Video : $fic\n";
	print FTS "\#Action values : Time Cursor ='$currtime' - TestDuration='$currduration' - CropDetection=";
	if ($currcrop) { print FTS "Computed\n"; } else { print FTS "NotComputed\n"; }
	print FTS "\#  MPEG2  Data :   Mpeg Ratio='$vd[4]($vd[13])' MpegResol='$vd[12]'($vd[15]) - Nominal A/V kbps='$vd[14]/$vd[19]' fps=$vd[18]\n";
	print FTS "\#  Final Video : AvifileRatio='$avireso'    AviAspect='$vd[16]:$vd[17]'  CropSet ='$currcrop'  Ocrop='$vd[8]'\n";
	print FTS "\#  Misc Option : Bitrate Audio/Video kpbs='$rateaudio/$ratevideo'  FLAGS NO-Desintl='$flnd'  Bl&White='$flbw'\n";
	print FTS "\#  A/V Profile : Number='0$flprofile' - Values A/V='$rateaudio/$ratevideo'\n";
	# script generation: body
	print FTS "function timer()\n";
	print FTS "{\n";
	print FTS "  if [[ \$\# -eq 0 ]]; then echo \$(date '+\%s')\n";
	print FTS "  else\n";
	print FTS "    local  stime=\$1 ; etime=\$(date '+\%s')\n";
	print FTS "    if [[ -z \"\$stime\" ]]; then stime=\$etime; fi\n";
	print FTS "    dt=\$((etime - stime)); ds=\$((dt \% 60)); dm=\$(((dt / 60) \% 60)); dh=\$((dt / 3600))\n";
	print FTS "    printf '\%d:\%02d:\%02d' \$dh \$dm \$ds\n";
	print FTS "  fi\n";
	print FTS "}\n";
	print FTS "if [ \"\$1\" = \"-tr\" ]; then tr=1; shift; fi\n";
	print FTS "arg0=\$0 ; arg1=\$1\n";
	print FTS "echo \"File to rip: $fich\"\n";
	print FTS "fti=\"$currtime\" ; ftd=\"$currduration\" ; \# starting point and duration for sample encoding\n";
	print FTS "fid=\"\$HOME/vdripdir\"\t\# destination dir of mencoded file\n";
	print FTS "fic=\"$fich\"\t\# file to mencode\n";
	print FTS "xcmdsh=\`which xcmd.sh\`\n";
	print FTS "xfind=\`which find\`\n";
	print FTS "if [ ! -e \"\$fid\" ]; then fid=\"\$HOME\"; cd ; fi\t\# alternate destination dir\n"; 
	print FTS "#if [ ! -e \"\$fic\" ] \&\& [ -x \"\$xcmdsh\" ]; then\n"; # Specific pkx use xcmd.sh
	print FTS "if [ ! -e \"\$fic\" ] \&\& [ -x \"\$xfind\" ]; then\n";
	print FTS "  echo \"File not here: '\$fic'\"\n";
	print FTS "  fib=\"\${fic\#\#*/}\"\n";
	print FTS "  echo \"find is searching '\$fib' in another directory, please wait...\"\n";
	print FTS "  LANG=C;fic=\`\$xfind / -name \"\$fib\" -exec echo '{}' \\; -exec sh -c \"kill \\\$(ps -ef|grep find|grep \"\$fib\"|awk '{ print \\\$2 }')\" \\; 2>/dev/null \| grep -v \"Terminated\"\`\n";
	print FTS "  if [ ! -e \"\$fic\" ]; then echo \"find did not found it - Sorry! cannot continue.\"; exit 1; fi\n"; 
	print FTS "  echo \"find has found file: '\$fic'\"\n";
	print FTS "fi\n";
	print FTS 'ficpa=`dirname "$fic"`'; print FTS "\n";

	if (($currcrop) && ($miarg eq "ge")) {  # modif.20090306(currcrop) and fix 20090802(mifrom)
	  print FTS "ficr=\"crop=$currcrop,\" \# crop parameter if set\n";
	} else {
	  print FTS "ficr=\"\" \# no crop parameter\n";
	}
	print FTS "fics=$vd[16]:$vd[17] ; ficsx=$vd[16]x$vd[17] ; \# mpeg asp=$vd[4]\n";
	# audio-delay float (often -1.0 to -0.7 cause sound is late)
	print FTS "fiad=0\t\# audio-delay for video/audio synchr,should not occur,except bad mpeg TS\n";
	#print FTS "\#faid=129\t\# audio language sound track for dvd only,often 129=fr\n"; # not used in DVB-T
	print FTS "fila=\"$fichavifile\" ;\n";
	print FTS "filng=\"$cmdlng3\" ;\n";
	print FTS "fidu=\"\"\n";
	print FTS "fibv=$ratevideo\t\# video bitrate,normal:860 to 920\n";
	print FTS "fiba=$rateaudio\t\# audio bitrate\n";
	if ($flbw) {  print FTS "fibw=\":gray\"\t\t\# if black\&white video \":gray\" or \"\",may change fiba=64\n"; }
	else	   {  print FTS "fibw=\"\"\t\t\# if black\&white video \":gray\" or \"\",may change fiba=64\n"; }
	if ($flnd) { 
	  print FTS "fide=\"\"\t\# if desinterlace \"pp=fd,\" or \"\"\n";
	} else {
	  print FTS "fide=\"pp=fd,\"\t\# if desinterlace \"pp=fd,\" or \"\"\n";
	}
	close(FTS);
	$rch=chmod (0700, $fichscript); #print "chmod ret=$rch\n";
	# Script generation cont. PART.2(fixed part,included inside this program)
	if ($tr) { print "TR.appending data to script file from:$fichvdrip (from itself)\n"; }
	$cmde1 = "cat $fichvdrip \| grep -e \^\#-\# \| sed -e 's:\^\#-\#::' \>\> $fichscript"; # modif.20081102
	if ($tr) { print "TR.exec.system:$cmde1#\n"; }
	$rc1=system($cmde1); if ($tr) { print "result rc1=$rc1 (ok if 0,bad if -1)\n"; }
	if (($rc1==0)||($rc1==256)) {
	  $reperror = "User script created: $fichscript"; print "$reperror\n";
	  print "Execute this script in an another Terminal console windows to rip the video.\n";
	  if ($flxpert) {
	    print "You may specify a parameter 0 , 1 or 2 depending on the job you want:\n";
	    print "2 : for a TWO passes conversion  (for best results but slower)\n";
	    print "1 : for a ONE pass conversion    (run faster, by default)\n";
	    print "0 : for a 30 seconds sample test (to make checks before the long job)\n\n";
	  }
	} else {
	  $reperror = "ERROR: Unable to generate a fully functional script file";
	  print "$reperror\n";
	  print "Cannot merge lines with the file just created: $fichscript (code err rc1=$rc1)\n";
	  print "Unable to write 2nd part of the script file [append-with-cat]\n";
	  $rcgen=1;
	}
    }
    $rfs=0;
  }
  else {
    $reperror = "ERROR! Cannot generate script file with 'ge' or 'gn' commands.";
    print "$reperror\n";
    print "Cause: There is no stats/parameters set to generate a shell script file.\n";
    if ($tr) { print "\t(array vd is empty or undefined)\n"; }
    print "Before to generate the script file, $verp need to analyze the file successfully\n";
    print "Suggestions: Please enter a crop command like: ct (Crop at Time-cursor) or cr (CRop 3 sampling)\n";
    print "  The error is probably due that $verp is not be able to read the MPEG2 header data\n";
    print "  (file corrupt?) or fix the previous reported error.\n";
    $rcgen=1;
  }
  #
  # warning: the 2nd segment of this script is always the same and is stored as comments inside this program source
  # Note parameters used for video:
  # mplayer/mencoder recommendations in doc and man for video: lavcopts=mbd=2:trell=yes:v4mv=yes
  # experts recommendations for audio mp3: use best bitrate as possible(192k),joint stereo,
  #   vbr is not recommended because may lead to unsynch audio/video tracks.
  return($rcgen);
}

###
### DON'T DELETE LINES STARTING WITH "#-" : They are not comments !!! They ARE needed !!!
### It is the remaining partial script segment of the funtion genficscript()
###
# This file is the the part of the script that is copied at end of each vdrip script file
#-#vdraddver="vdripgen0000.txt-v30n-20091201"
#-#scriptdir="$HOME/vdripdir"   ; if [ ! -d "$scriptdir" ];  then scriptdir="$HOME";  fi
#-#scriptdone="$HOME/vdripdone" ; if [ ! -d "$scriptdone" ]; then scriptdone="$HOME"; fi
#-#vdriplist="$HOME/vdriplist.sh"
#-#mencmd=`which mencoder`
#-#medicmd=`which mediainfo`
#-#if [ ! -x "$mencmd" ] ; then
#-#  echo "The command used to process the file does not exist or is not executable '$mencmd'"
#-#  echo "Please, install mencoder and mplayer first (sudo apt-get install mplayer mencoder)"; exit 1
#-#  echo "Sorry! Exiting."; exit 1
#-#fi
#-#if [ ! -r "$vdriplist" ] ; then
#-#  vdriplist="vdriplist.sh"
#-#fi
#-#if [ ! -r "$vdriplist" ] ; then
#-#  echo "The scripts list file does not exist or is not readable '$vdriplist'"
#-#  echo "so the list of pending files to $vdrname will not be updated (warning)."
#-#fi
#-#basenam0="${arg0##*/}"
#-#filext=".`echo $basenam0 | awk -F "." '{print $NF}'`"
#-#dirnam0="`dirname $arg0`"
#-#filnoext="${basenam0%$filext}"
#-#menctok="$scriptdir/$basenam0" # scriptfilename with pathname
#-#menctoknp="$basenam0"	  # scriptfilename wo/pathname
#-#vmenc=menc`$mencmd $cmdmplvo -v 2>/dev/null | head -n 1 | awk '{print $2}'  | awk -F ":" '{print $NF}' | sed -e 's/[~:.]//g' | sed -e 's/SVN\-r/SVNr/'`
#-#if [ $tr ]; then
#-#  echo "vdraddver =$vdraddver" # variables are for debugging
#-#  echo "mencodervn=$vmenc"
#-#  echo "argument0 =$arg0#"
#-#  echo "argument1 =$arg1#"
#-#  echo "filefic   =$fic#"
#-#  echo "filepath  =$ficpa#"
#-#  echo "menctok   =$menctok#"
#-#  echo "menctoknp =$menctoknp#"
#-#  echo "scriptdir =$scriptdir#"
#-#  echo "scriptdone=$scriptdone#"
#-#  echo "mencmd    =$mencmd#"
#-#  echo "vdriplist =$vdriplist#"
#-#  echo "basenam0  =$basenam0#"
#-#  echo "dirnam0   =$dirnam0#"
#-#  echo "filnoext  =$filnoext#"
#-#  echo "filext    =$filext#"
#-#  echo "filng     =$filng#"
#-#fi
#-#frames=""
#-#if [ -x "$medicmd" ]; then frames=`$medicmd -f "$fic" | grep 'Frame count' | awk '{ print $4 }'`; fi
#-#if [ -n "$frames" ]; then frames="- $frames frames"; fi
#-#if [ -z "$arg1" ]; then arg1=1; fi
#-#if [ -z "$arg1" ] || [ "$arg1" -lt 0 ] || [ "$arg1" -gt 2 ] ; then
#-#  echo "Argument error! Enter a correct argument please, specify either : 0 , 1 or 2"
#-#  echo "You entered '$arg1' which has no signification for me - Not supported. Exiting."
#-#  exit 1
#-#fi
#-#if [ ! -r "$fic" ] ; then
#-#  echo "The file to process does not exist or is not readable '$fic'. Exiting."
#-#  exit 1
#-#fi
#-#dat0="`date +%Y%m%d.%H%M%S`" ; dat1="" ; dat2="" ;
#-#tim0=$(timer)
#-#echo "II"
#-#if [ "$arg1" -eq 0 ]; then
#-#  ripfile=$fid/$fila-mp4-$fiba""k-$ficsx-$fibv""k-hq0test.avi
#-#  echo "II	$fila"
#-#  echo "II	file: $fic"
#-#  echo "II	FAST ENCODING TEST [from:$fti duration:$ftd]"
#-#  echo "II	avifile: $ripfile"
#-#  echo "II"
#-#  cat "$fic" | \
#-#  nice -+15 $mencmd $filng -ffourcc DX50 -ss $fti -endpos $ftd -audio-delay $fiad \
#-#	-oac mp3lame -lameopts cbr:br=$fiba:mode=1:aq=2 -ovc lavc -lavcopts \
#-#	vcodec=mpeg4:keyint=75:mbd=1:turbo$fibw:vbitrate=$fibv: \
#-#	-vf ${fide}${ficr}scale=$fics -o $ripfile -
#-#  res0=$?
#-#  echo "II"
#-#  echo "II END ENCODING TEST [from:$fti duration:$ftd]  $fic (res0=$res0)"
#-#  if [ "$res0" -ne 0 ]; then echo "An error occurred in $mencmd (res0='$res0')"; exit 1
#-#  fi
#-#fi
#-#if [ "$arg1" -eq 1 ]; then
#-#  ripfile=$fid/$fila-mp4-$fiba""k-$ficsx-$fibv""k-p1hq1-$vmenc.avi
#-#  echo "II $fila"
#-#  echo "II	file: $fic"
#-#  echo "II	ONE PASS CONVERSION = START - date:$dat0 $frames"
#-#  echo "II	avifile: $ripfile"
#-#  echo "II"
#-#  cat "$fic" | \
#-#  nice -+19 $mencmd $filng -ffourcc DX50 -audio-delay $fiad \
#-#	-oac mp3lame -lameopts cbr:br=$fiba:mode=1:aq=0 -ovc lavc -lavcopts \
#-#	vcodec=mpeg4:keyint=75:mbd=2:trell:v4mv:turbo$fibw:vbitrate=$fibv: \
#-#	-vf ${fide}${ficr}scale=$fics -o $ripfile -
#-#  res1=$?
#-#  dat2="`date +%Y%m%d.%H%M%S`"
#-#  echo "II $fila"
#-#  echo "II	file: $fic"
#-#  echo "II	ONE PASS CONVERSION = END  - date:$dat0 .. $dat2"
#-#  echo "II"
#-#  if [ "$res1" -ne 0 ]; then echo "An error occurred in $mencmd (res1=$res1)"; exit 1
#-#  fi
#-#fi
#-#if [ "$arg1" -eq 2 ]; then
#-#  ripfile=$fid/$fila-mp4-$fiba""k-$ficsx-$fibv""k-p2hq1-$vmenc.avi
#-#  passlog=divx2pass-$$.log
#-#  echo "II $fila"
#-#  echo "II	file: $fic"
#-#  echo "II	TWO PASSES CONVERSION = PASS1 START - date:$dat0  $frames"
#-#  echo "II	avifile: $ripfile"
#-#  echo "II"
#-#  cat "$fic" | \
#-#  nice -+19 $mencmd $filng -passlogfile $passlog -ffourcc DX50 -audio-delay $fiad \
#-#	-oac mp3lame -lameopts cbr:br=$fiba:mode=1:aq=0 -ovc lavc -lavcopts \
#-#	vcodec=mpeg4:keyint=75:mbd=2:trell:v4mv:turbo$fibw:vbitrate=$fibv:vpass=1: \
#-#	-vf ${fide}${ficr}scale=$fics -o $ripfile -
#-#  res1=$?
#-#  dat1="`date +%Y%m%d.%H%M%S`"
#-#  if [ "$res1" -ne 0 ]; then echo "An error occurred in $mencmd (res1=$res1)"; exit 1
#-#  fi
#-#  echo "II $fila"
#-#  echo "II	file: $fic"
#-#  echo "II	TWO PASSES CONVERSION = PASS2 - date:$dat0 .. $dat1"
#-#  echo "II	avifile: $ripfile"
#-#  echo "II"
#-#  cat "$fic" | \
#-#  nice -+19 $mencmd $filng -passlogfile $passlog -ffourcc DX50 -audio-delay $fiad \
#-#	-oac mp3lame -lameopts cbr:br=$fiba:mode=1:aq=0 -ovc lavc -lavcopts \
#-#	vcodec=mpeg4:keyint=75:mbd=2:trell:v4mv:turbo$fibw:vbitrate=$fibv:vpass=2: \
#-#	-vf ${fide}${ficr}scale=$fics -o $ripfile -
#-#  res2=$?
#-#  dat2="`date +%Y%m%d.%H%M%S`"
#-#  echo "II $fila"
#-#  echo "II	file: $fic"
#-#  echo "II	TWO PASSES CONVERSION = END - date:$dat0 .. $dat1 .. $dat2"
#-#  echo "II"
#-#  if [ "$res1" -ne 0 ] || [ "$res2" -ne 0 ]; then
#-#    echo "An error occurred in $mencmd (res1=$res1 res2=$res2)"; exit 1
#-#  fi
#-#  if [ -f "$passlog" ]; then rm -f "$passlog" ; fi
#-#fi
#-#tim2=$(timer $tim0)
#-#echo "II	Elapsed time: $tim2  $frames"
#-#echo "II"
# Update files: jobs list (actually in /home/?/vdriplist.sh), archive script file
#-#if [ "$arg1" -ne 0 ]; then
#-#  if [ -w "$vdriplist" ]; then
#-#    echo "Updating file: $vdriplist  - changed line is:"
#-#    sed -i -e "s:^$menctok:##$menctok:" "$vdriplist"
#-#    grep "$menctok" "$vdriplist"
#-#  fi
#-#fi
#-#if [ -r "$menctok" ] && [ -d "$scriptdone" ] && [ -w "$scriptdone" ] ; then
#-#  echo "Copying script: '$menctok' to '$scriptdone/.'"
#-#  cp -a "$menctok" "$scriptdone/$menctoknp"
#rename is inhibited,because we may want to execute it again: mv "$menctok" "$scriptdone/$menctoknp"
#-#fi
#-# echo "Ripped file is: $ripfile"
#-#echo "Done."
#-#exit 0
#if delay between sound/video: -audio-delay <float> (negative if sound is late from the video)
#example if you need an ajustment of 7/10th second: mencoder -audio-delay -0.7
#Other changes to make for DVD support: lameopts vol9  and -aid xxx
###

###
### DON'T DELETE LINES STARTING WITH "#-" : They are not comments !!! They ARE needed !!!
### It is the help text in expert-mode (flxpert)
###
#-x First, read the standard help section in normal user mode.
#-x This is a additional help file for advanced users. Notice that I am drafting it.
#-x Please signal any errors or incorrect information, and problems you may have encountered.
#-x vdrip.pl produces very high quality mpeg4 file since it uses the HQ codec 'lavc',
#-x integrated inMENCODER and belonging to the ffmpeg family of codecs.
#-x The 'cropping' function help to get the best results in accordance to the shortest
#-x  final size of the file: all the processings done by $vdrname are greatly optimized.
#-x 
#-x Follow this example, it is very easy...\n
#-x First you select a file to convert, then process it with the 'ct' or 'cr' command for 'cropping'.
#-x After crop parameters has been correctly detected,you can have the video rendering with the
#-x command 'pc'(Play Crop). To stop Video playing, enter 'k' to kill the playing window (kill)
#-x The mouse pointer should be on the mplayer window or the terminal console that launched it.
#-x If the picture cutting is ok and suite you you will have to generate the final script file:
#-x Then enter command 'ge' to generate the final script file. The name of the script is displayed.
#-x If for some reason parameters do not suite you, adjust them accordingly to your needs and test
#-x   them immediately until your Video playback and rendering seem good.
### OLD pager was:  -- More --"; if (getlig($codelg) eq 'q') { return; }
#-x To summarise, let's take an example: you want to convert the video 'myholidays.m2t'
#-x   (that is in your current directory) to a divx/mpeg4 file. Follow this short procedure:
#-x   First enter the command in a gnome-terminal or kconsole window:
#-x   vdrip.pl -x -m myholidays.m2t
#-x This command enter the advanced mode (-xpert option) in non automatic mode (-manual)
#-x   At the prompt, enter command 'ct' and wait several seconds (10) till the video
#-x   stops playing and that the menu reappears.
#-x   Enter command 'ge' (generate), the script is created, the filename is displayed (User Script).
#-x   for instance: /home/myname/myholidays.sh
#-x   Quit the $vdrname utility : enter 'q'
#-x   Notice it is exactly what does the automatic mode: it is chaining these 3 commands.
#-x   To vdrip the video, enter the script command as it is shown:
#-x   /home/myname/myholidays.sh 1\<ENTER\>   (replace default '1' by '2' for a 2 passes encoding)
#-x   You can replace default '1' by '0' for a 30 seconds quick test with low quality parameters.
#-x   After some hours, the final video file is ready for use
#-x   Play it with your preferred movie player (Totem, Xine, VLC, MPlayer)
#-x   You now can retouch it (cut the ads etc...) with your favorite utilities.
#-x 
#-x   Another example if you don't want to use the crop detection feature:
#-x   vdrip.pl -x -m myholidays.m2t
#-x   At the prompt, enter command 'gn' (generate script but without cropdetect parameters).
#-x   the script is created, and the largest size of the picture will be ripped.
#-x   To vdrip the video, enter the script command as shown before:
#-x   /home/myname/myholidays.sh 1\<ENTER\>
#-x 
#-x Detailed available commands to crop, adjust and play a video sample within $vdrname:
#-x You probably won't have to use them!
#-x A command begins by a letter (main function) then another letter for sub-command
#-x Explanations for the first letter commands:
#-x c : Mark a 'crop' command
#-x p : Mark to 'play' a sample video with mplayer
#-x s : Mark a 'set' command, to set/adjust a parameter value for the final video
#-x k : Mark a 'kill' command, to stop playing a sample video file with mplayer
#-x g : Mark a 'generate' command, to create the script file (which is used to vdrip the video)
#-x q : to quit this $vdrname utility.
#-x Detailed available commands to crop, adjust and play a Video within $vdrname follow..
#-x Explanations for the second letter commands:
#-x c : Current point, or Current crop
#-x n : No crop
#-x s : Starting point
#-x c : Current point
#-x t : Time value
#-x d : Duration value
#-x a : Aspect (video aspect)
#-x 
#-x ct: cropdetect from time cursor (recommended), detection will occur at time cursor: $currtime - see 'st')
#-x cr: cropdetect automatically (recommended),at 3 differents places in the file,
#-x     scan parameters for big file:@croptimebig - for small file:@croptimesmall (in minutes)
#-x     this command is preferable if the 'ct' does not display a section inside the movie itself
#-x cs: cropdetect from starting point of the file (scan parameter is: @croptimestart). Not recommended.
#-x pc: play Video with mplayer from current time cursor with crop parameter value previously set by 'st'
#-x pn: play Video with mplayer from current point without crop parameter value previously set by 'st'
#-x k : stop current video viewing with mplayer (kill the mplayer window play back)
#-x c : clear screen
#-x st: set new time cursor value. Used to crop/play a file at a point. Give a format hhh:mmm:sss,
#-x            if no ':' a minute is assumed (default:6 minutes)
#-x sd: set new time duration of a mencoder operation (for advanced testing). Give a format hhh:mmm:sss,
#-x            if no ':' a second is assumed (default:30 seconds = 00:00:30)
#-x *Note: After a command, a selection can be added as a minute or a -ss parameter like 00:00:00
### print "pp: play Video with mplayer from starting point with crop parameter, time argument can be given for -ss
### print "ps: normally play Video with mplayer from starting point (no crop,no time cursor), time argument can be given for -ss
### print "pv: play Video with mplayer in verbose mode,nocrop; a time argument can be given for -ss
#-x 
#-x Following are the picture size and aspect radio adjustments commands:
#-x sc: set the crop parameter value to vd(8) or force it giving a value in format width:height:xxx:yyy
### sv: set the crop parameter from the value stored in array vdcall[],supply an indice number (display it with command 'ta')
#-x sa: set the aspect parameter with a value in format width:height
### print "sf: fix the crop detect in adjustment the height and width values accordingly # useless it is automatic now!
#-x shpn,shmn: set/change the crop parameter value : h for height, p and m : plus or minus the shift value.
#-x 		  'n' number of shifts (in 16 multiple) to crop the top and bottom of the picture
#-x swpn,swmn: set/change the crop parameter value : w for wide, p and m : plus or minus the value.
#-x 		  'n' number of shifts (in 8 multiple) to crop the left and right hand side of the picture
#-x ta: display vd[] array and crop tables (aspect ratios and last cropdetection values done)
#-x Following are the generate script and the direct ripping commands:
#-x ge: generate the final shell script file with the current crop parameters in: $fichscript
#-x gn: generate the final shell script file without crop parameters: $fichscript
### rin: rip a file launching the script file that has been previously generated: $fichscript
###	 where 'n' is 0 for a quick test, 1 for an one-pass encoding, 2 for a 2-passes encoding
#-x
#-x After ripping a mpeg2 file you can make some additional works on your movies:
#-x You can cut advertisements or the begin or end with you own usual utilities
#-x like: Avidemux, Virtualdub or Nandub.
#-x Extract the sound track, I use Avidemux because it is easy and powerful as shown in this example:
#-x /usr/bin/avidemux mpeg2-file-sound-to-extract.mpg --nogui --save-raw-audio extracted-file.mp3 --quit
#-x This command extracts the sound track as it is and creates a mp3 file, ready to listen.
__END__
vdrip.pl hosted on SAVANNAH.ORG (dated:2009-08-24) - English Text format

VDRIP description
=================
VDRIP is a stand-alone encoding utility used to convert MPEG2 format
Videos (TS or PS). It compacts them efficiently and produce high quality
mpeg4 .avi files (XviD,DivX).

The videos in MPEG2 format have usually an extension .mpg  .mpeg  .m2t
or .vob and you get them when you record TV or Satellite programs with
a DVB adapter installed in your computer.
Internally, this utility uses the well known MPlayer and MEncoder
softwares (see web site http://www.mplayerhq.hu).
vdrip.pl is a free software running on GNU/Linux and released under the
GPL License. It is supplied as an 'all-in-one' file.

There is no GUI (Graphical User Interface). Everything is done in a
Terminal or Console window : it is an easy way to produce mpeg4
multimedia files.

Introduction
============
VDRIP is a stand-alone encoding utility used to convert MPEG2 format
videos (TS Transport Stream or PS Program Stream).
The purpose is to get more compact and standard multimedia files than the
mpeg2 format. Movies can be stored in your personal video library and 
they can be used by almost any multimedia boxes or mpeg4 capable devices.

The chosen final format is mpeg4 with the .avi containers.
It is the most widely used in many kinds of platforms.

The files produced by VDRIP are of very high quality.

vdrip need a GNU/linux distribution with MPlayer and MEncoder correctly
installed and fully functional. The Perl package is also a requirement.
Most of distributions already supplies theses requirements.

Since there is no GUI (Graphical User Interface), everything is done in
a Terminal or Console window : it is very simple! You have to enter a
command that generates a script file, then, you only have to execute it
(now the 2 steps can be done in one command).

VDRIP creates a script file for each MPEG2 movie that you want to rip.
Since the ripping process need a heavy load system, it is a convenient
way to execute each script at a time that your computer is not in used
for your more important activities.
After the conversion, the final movie will have a standard format : the
AVI file container MPEG4 format (which is XviD/DivX compatible).

All the jobs is done for You ! No need to learn, configure, install and
review many graphical windows with parameters or configuration steps:
everything is already in it!

Basic guidelines
================
Here are the stages which you will have to follow :

1- open a Terminal or Console window with your favorite GNU/Linux
   distribution, so that you can launch vdrip.pl
2- generate a bash script file : enter the command vdrip.pl with the
   name of the mpeg2 file that you want to convert
   (like: perl vdrip.pl my-movie-to-convert.m2t)
3- after this step vdrip.pl give you the name of the generated script to
   use for the next step (for instance: my-movie-to-convert.sh).
4- you execute this script file in a Terminal window (it is an ordinary
   bash shell file) whenever you want. It's the ripping process.
5- After a while you get the mpeg4 movie file, the filename is displayed
   when the rip ends.

That's all! By default, all the files are in the current directory.

The rip process may takes one to four hours (more or less, depending on
the video length and the power of your computer).
On one of my old systems, it takes 3 hours to convert a 1:45 hour movie
in one-pass mode.
After the ripping step, you get the movie with a filename with a .avi
extension ready for use!
The quality is very high since VDRIP uses the HQ codec 'lavc', supplied
by MEncoder.
  (see: http://www.mplayerhq.hu/DOCS/HTML/en/encoding-guide.html)

What's more ? You would probably want to cut advertisements, credits at
the beginning or end of the movie. Do it with your favorite utility.
The format is standard, so most of them can be used. I usually make this
job with Avidemux.

About the MPEG2 format
======================
Theses files are mostly created on a computer when you record the
programs with a digital TV card installed in it.
Also, the device can be a USB pen which integrates a digital TV tuner.
For instance: your computer has a DVB-T adapter to receive the Digital
TV programs or a DVB-S adapter to receive the Digital Satellite TV
programs.
When you record programs that way, the resulting file usually has the
well known MPEG2 format. vdrip.pl is designed to process them to get a
more convenient and compact format to store them on your PC disks.

Remember the mpeg2 format produce very large file, about 2 Gb per hour.
vdrip.pl usually reduces this size to a quarter (approximately):
- 1 Gb per two hours of movie in high quality profile (fast motion at
  920kbs bit rate) - or a little smaller -:
- 700 Mb for a 1:35 hour movie at the standard quality profile (860 kbs
  which is the default bit rate).

Thanks to the MPlayer and MEncoder team and all the persons of the
FFmpeg lavc project! (see: "More information" chapter).

Keep in mind that the quality of the conversion is very high, anyway.
The words "high" "standard" "profile" here are only used in the vdrip.pl
terminology, when we want to compare technical results in a more human
way. I should say: "very good result" or "very very very good result" !

VDRIP Highlights
================
- automatic crop detection (this feature can be disabled)
- one or two passes rip encoding
- produces mpeg4-asp format avifiles for better interoperability
- preserves the MPEG2 ratio when rescaling
- desinterlaces the frames (may be disabled)
- 2 steps encoding for further use when computer is idle
- encoding runs at minimum CPU and I/O priority
- high quality encoding, the utility selects the HQ codec 'lavc' from
  the libavcodec library
- can process either TS or PS mpeg2 stream formats
- mpeg4 avifiles are compatible with most video editing products
- simple to use to produce results in a very little time
- uses the MPlayer and MEncoder softwares to generate reliable videos.

What vdrip.pl DOES
==================
First, it runs in a console or Terminal windows on GNU/Linux. You will
have to execute the vdrip.pl file with the Perl command.

VDRIP generates a bash script file automatically. The standard parameters
have been designed to get high quality mpeg4 encoding, keeping the final
video size compact.

A movie of 1:30 to 2:00 hours is reduced to less than 1 Gbytes, without
taking too much time to process.

All the processing chain is done by VDRIP, they are greatly optimized.

VDRIP is based on the explanations and the recommendations found in the
MEncoder documentation, chapter MPEG4/DivX
  (see: Chapter 13. Encoding with MEncoder)

Since it relies on MEncoder, the video and sound tracks always should
be synchronized even for .m2t movies (MPEG2-TS).
This is not always the case for other converter tools.

Let's look at some VDRIP technical details, by default:

- vdrip.pl uses its 'cropping' function (crop detection). It means that
  it removes (crops) the black bands over and below the movie image
  (and also for the left and right borders if they exist).
  It is very important to do cropping : the quality you gain worth it
  greatly. You make sure to get the best results for a shorter size of
  the final file.
- It preserves the Aspect Ratio. You might have seen movies where humans
  have egg heads. vdrip.pl preserves the MPEG2 ratio when it rescales,
  while using the largest picture size.
- It desinterlaces the video (MPEG is originally designed for TV device)
- The rip process is done in an ONE-Pass conversion. If you need a
  better image quality use the 2-Passes mode (see further).

Prerequisites
=============
- GNU/linux distribution
- Perl language
- MPlayer and MEncoder

VDRIP runs on GNU/Linux, with a standard Perl package installed. Any
modern GNU/Linux distribution might include it.
No specific Perl module is necessary.

MPlayer and MEncoder are packages requirements.
If they are not installed,in a superuser console, enter the command:
# apt-get install mplayer mencoder

(may change according to your specifi distribution).
You may downloaded them from http://www.mplayerhq.hu/

VDRIP has been developed and intensively tested on the GNU/Linux
distributions Ubuntu since 8.04 with many multimedia files.

Before to use it you should test if you can play back the video that
you want to vdrip. It is an essential step to make sure that MPlayer
is perfectly functional.
If you cannot see the picture or if the sound is not here, you SHOULD
SOLVE THE PROBLEM BEFORE to use vdrip.pl because it will not work!
Search the web, the solutions are here.
Take a look at the end of the documentation "FREQUENTLY ASK QUESTIONS".

Getting Started - Quick Start
=============================
- Please read the prerequisites chapter to check if your computer can
  run VDRIP. Normally there is no reason why VDRIP won't run on your
  computer with a modern GNU/Linux distribution : it might include the
  standard software packages like Perl, MPlayer and MEncoder.

  If MPlayer is running correctly when playing back a movie, and if
  MEncoder and Perl are also installed on your computer.. Let's start!

- Open a Terminal or console window, as an ordinary user. Go in the
  directly where the mpeg2 file is.
- Enter the vdrip.pl command like :

  perl vdrip.pl /home/myname/myholidays.m2t <ENTER>

  where "myholidays.m2t" is an example of a MPEG2 file (no space,no
  special char).
  vdrip.pl is the perl utility filename ending by .pl
  and we assume that everything is in the current directory.

- You will see a playback of one part of the file. Keep it playing!
  Wait until video playback stops (it is the crop detection sequence).
  You should see a section of the movie itself, because vdrip.pl will
  use the parameters detected by this analyze sequence. If not, the
  video format or aspect may be wrong!

- Very soon, after about 10 seconds, VDRIP gives you the filename of
  the script that it has generated: it is the same filename than the
  MPEG2 file, but with a ".sh" extension.

- To vdrip the video, enter the script command as it is. For example:
  /home/myname/myholidays.sh <ENTER>

- That's all. After a couple of hours, you will get a file whose
  filename counterpart begins by "myholidays" and finishes by ".avi".
  It is your mpeg4/DivX movie ready for use.

- Play it with your preferred movie player (MPlayer, Totem, Xine, VLC,
  XFmedia). 

- Now, you can retouch it (cut the advertising etc...) with your
  favorite software.

Notice: Do you want an all-in-one sequence ? Ok! but please check that
  the movie is correctly viewed during the crop detection sequence:

  perl vdrip.pl /home/myname/myholidays.m2t -rip1 <ENTER>

Differences with other similar softwares
========================================
VDRIP is a command line product : there is no GUI (graphic interface).
VDRIP may replace some other graphical products with great and many
advantages.
It is faster to start with it, you spend less time to get successful
results. You don't have to review many configuration windows or tabs.
If you are looking for a compact and easy command line utility to rip
your mpeg2 videos, it worth to try.

The author wanted to make everything very easy and powerful for an end
user, keeping in the idea that the movies could be read on the most
widely used devices.

The main goals were to make sure :
  . the user won't have to spend time to learn it
  . keeping everything user friendly and efficient

Since the product need not to be installed, configured, you won't loose
your time to make many tries until you get the expected results, because
  . the standard parameters and environment are already configured
  . no technical aspects to study before to start
  . no many complex graphical windows, tabs or menus to review and
	dialog boxes to click.

Just read the Getting Started Section how to generate a script file and
execute it, that's all! To start with it, I would recommend: do simple
and do everything as it is explained in the "GETTING STARTED" chapter
before testing any advanced options.

The future of VDRIP, will it be enhanced ?
===================
- The utility is ready to release many other functions to make it a 
  complete product (some of them are already implemented). 
  It depends on You ; please take some of your time to make a report
  and say what you think about it, ask for the functions you need.

- The script file supports the 2-Passes sequence, give "2" as parameter:
  /home/myname/myholidays.sh 2 <ENTER>  (will do a 2 passes encoding)

- The script file supports a quick test mode, give "0" as parameter:
  /home/myname/myholidays.sh 0 <ENTER>  (to make a ~30 seconds encoding)

- An advanced mode for experienced users is available. It is called 
  expert mode and is enabled given the -xpert option on the command line
  (abbreviated -x). Expert mode allows:
  . to use profiles for audio and video, their implementations has begun.
  . the adjustment of parameters to get even more different results
  . a powerfull debugging mode.
  Most users may not need it, but they exist.

- Remember: today VDRIP does all the complex processing for you:
  the actual released version *IS* fully functional.
  I am using it to record Satellite programs, documentaries, and
  musical shows on my computer when I am not at home.

VDRIP Limitations:
=================
In the actual release of vdrip.pl, you should consider:

- A video that you rip will be done with "optimal" parameters.
  Chosen parameters are quite good for general use:
  video at 860 Kbps, sound track mp3 at 128 Kbps max quality, with a
  one-pass encoding sequence by default.
  Frames are desinterlaced.
  It is a good quality for most movies and documentaries.

- The naming convention used by vdrip for .avi file is special:
  the final .avi filenames may be very long. It has been designed to
  embed inside the name many technical data in compact form.
  Also the other purposes were to make possible many ripping samples
  with more than one resulting file.
  Rename the file if it does not please you.
  Report an enhancement to get rid of it if it is really annoying.

- It is not designed to backup DVDs (There are so many other tools),
  same for mpeg1 or other multimedia files.

- Case of one file containing two movies with different aspects
  (i.e. one is 720x576 pixels, the other is 544x576 pixels)
  You cannot use directly vdrip.pl. First you must :
  . convert your video file in format MPEG2-PS (only if it is in 
    MPEG2-TS), you can use the projectx/mplex suite to do so.
  . Once you get the MPEG2-PS file, use Avidemux utility to cut it in
    two pieces. Don't use Avidemux to cut MPEG2-TS movies directly
    because the audio and video tracks may be desynchronized.

   When 2 movies have different technical characteristics they must be
   extracted and stored in two separate files.

- Case of a movie with subtitles inside the black bands below the movie
  image :
  As you know, vdrip.pl has an optimized crop detection function : it
  detects the black bands and cut them.
  Unfortunately, in this case, the subtitles will be deleted!
  Solution: Since version [18f] vdrip.pl has an option to deactivate
  the crop detection: -nocrop  . Use it as a command line argument :

  perl vdrip.pl /home/myname/myholidays.m2t -nocrop <ENTER>

  When you use the "-nocrop" feature you won't see any movie playback
  on the screen. It is normal since the cropdetect feature is disabled.
  In manual mode use command 'gn' (generate-file with nocrop).

- Case of movie recorded on a channel that supplies two sound tracks
  (for example : Arte may broadcast their programs in French and German
  simultaneously - Euronews in 6 languages).
  A MPEG2 file may contain 2 or more audio sound tracks.
  Since the default sound track has no meaning (it may be any language
  and the their numbering is totally conventional), vdrip.pl
  automatically set the language code in MPlayer and MEncoder for you.
  VDRIP computes the parameter language from the one it has found in
  the system global variables. You have nothing to do.

RECOMMENDED TOOLS:
=================
Avidemux : graphical utility to edit video files (cut the Ads, or 
  sequences). Please don't edit MPEG2-TS files directly because it has
  not been designed for them.

Projectx and mplex: to convert MPEG2-TS to MPEG2-PS video files
  it is a requirement if you want to cut MPEG2 movies before to rip
  them with VDRIP. You can use an other tool that fully support the
  MPEG2-TS format.

Mediainfo: display technical and tag information of most video and
  audio files (very useful, I have given some help to this project).

Kaffeine : scheduled records of Digital TV and Satellite programs
  if you have a supported DVB-T or DVB-S card in your computer. It can
  be used to search programs multiplex and to play back them with EPG
  information (program forecasts).

MORE INFORMATION
================
There is much more information about conversion of MPEG2 files to MPEG4
on many web sites.
Besides the already mentioned documentation and quick start procedures,
this is the most interesting:

Web resources references: 
http://www.mplayerhq.hu : main mplayer/mencoder web site
http://www.mplayerhq.hu/DOCS/HTML/en/encoding-guide.html :
  MEncoder site, more specifically for encoding in mpeg4
MPEG-2 : http://en.wikipedia.org/wiki/MPEG-2
MPEG-4 : http://en.wikipedia.org/wiki/MPEG-4
FFMPEG : http://en.wikipedia.org/wiki/FFmpeg
Lavc : http://en.wikipedia.org/wiki/Libavcodec

FREQUENTLY ASK QUESTIONS: (to continue)
========================
SCRIPT FILE:
1- can I modify the bash script to change the video bit rate ?
   Answer: yes! and you can modify in the same way :
   . the audio bit rate
     or to use -ab option on the vdrip.pl command line (audio bit rate)
   . the "black-and-white" flag (if movie is in B&W,results are better)
     or to use -bw option on the vdrip.pl command line (black&white)
   . the language code for Satellite program audio track if satellite
	programs comes with a different one.

2- the sound track language is not correct, how can I fix it?
   Answer: you can configure it in MPlayer configuration file, for
   instance add a line "alang=fr" in /etc/mplayer/mplayer.conf to 
   select the French language soundtrack by default.

MPLAYER PLAYBACK:
3- The video window did not appear on the screen while MPlayer playback.
   Solution: Need to create a file in /home/myname/.mplayer/config and
   put a line "vo=x11" (without double-quotes).
   Or, change video parameter in the menu: mplayer>preferences>Video
   select "x11" (as the available driver). Restart MPlayer.

4- Cannot hear the sound of videos while launching MPlayer for playback.
   Solution: Need to configure in the menu: mplayer>preferences>Audio
   select "alsa" (as the available driver). Restart mplayer.

#End

LICENSE for VDRIP:
=================
                            Preamble

  The GNU General Public License is a free, copyleft license for
software and other kinds of works.

  The licenses for most software and other practical works are designed
to take away your freedom to share and change the works.  By contrast,
the GNU General Public License is intended to guarantee your freedom to
share and change all versions of a program--to make sure it remains free
software for all its users.  We, the Free Software Foundation, use the
GNU General Public License for most of our software; it applies also to
any other work released this way by its authors.  You can apply it to
your programs, too.

  When we speak of free software, we are referring to freedom, not
price.  Our General Public Licenses are designed to make sure that you
have the freedom to distribute copies of free software (and charge for
them if you wish), that you receive source code or can get it if you
want it, that you can change the software or use pieces of it in new
free programs, and that you know you can do these things.

  To protect your rights, we need to prevent others from denying you
these rights or asking you to surrender the rights.  Therefore, you have
certain responsibilities if you distribute copies of the software, or if
you modify it: responsibilities to respect the freedom of others.

  For example, if you distribute copies of such a program, whether
gratis or for a fee, you must pass on to the recipients the same
freedoms that you received.  You must make sure that they, too, receive
or can get the source code.  And you must show them these terms so they
know their rights.

  Developers that use the GNU GPL protect your rights with two steps:
(1) assert copyright on the software, and (2) offer you this License
giving you legal permission to copy, distribute and/or modify it.

  For the developers' and authors' protection, the GPL clearly explains
that there is no warranty for this free software.  For both users' and
authors' sake, the GPL requires that modified versions be marked as
changed, so that their problems will not be attributed erroneously to
authors of previous versions.

  Some devices are designed to deny users access to install or run
modified versions of the software inside them, although the manufacturer
can do so.  This is fundamentally incompatible with the aim of
protecting users' freedom to change the software.  The systematic
pattern of such abuse occurs in the area of products for individuals to
use, which is precisely where it is most unacceptable.  Therefore, we
have designed this version of the GPL to prohibit the practice for those
products.  If such problems arise substantially in other domains, we
stand ready to extend this provision to those domains in future versions
of the GPL, as needed to protect the freedom of users.

  Finally, every program is threatened constantly by software patents.
States should not allow patents to restrict development and use of
software on general-purpose computers, but in those that do, we wish to
avoid the special danger that patents applied to a free program could
make it effectively proprietary.  To prevent this, the GPL assures that
patents cannot be used to render the program non-free.

  The precise terms and conditions for copying, distribution and
modification follow.

                       TERMS AND CONDITIONS

  0. Definitions.

  "This License" refers to version 3 of the GNU General Public License.

  "Copyright" also means copyright-like laws that apply to other kinds of
works, such as semiconductor masks.

  "The Program" refers to any copyrightable work licensed under this
License.  Each licensee is addressed as "you".  "Licensees" and
"recipients" may be individuals or organizations.

  To "modify" a work means to copy from or adapt all or part of the work
in a fashion requiring copyright permission, other than the making of an
exact copy.  The resulting work is called a "modified version" of the
earlier work or a work "based on" the earlier work.

  A "covered work" means either the unmodified Program or a work based
on the Program.

  To "propagate" a work means to do anything with it that, without
permission, would make you directly or secondarily liable for
infringement under applicable copyright law, except executing it on a
computer or modifying a private copy.  Propagation includes copying,
distribution (with or without modification), making available to the
public, and in some countries other activities as well.

  To "convey" a work means any kind of propagation that enables other
parties to make or receive copies.  Mere interaction with a user through
a computer network, with no transfer of a copy, is not conveying.

  An interactive user interface displays "Appropriate Legal Notices"
to the extent that it includes a convenient and prominently visible
feature that (1) displays an appropriate copyright notice, and (2)
tells the user that there is no warranty for the work (except to the
extent that warranties are provided), that licensees may convey the
work under this License, and how to view a copy of this License.  If
the interface presents a list of user commands or options, such as a
menu, a prominent item in the list meets this criterion.

  1. Source Code.

  The "source code" for a work means the preferred form of the work
for making modifications to it.  "Object code" means any non-source
form of a work.

  A "Standard Interface" means an interface that either is an official
standard defined by a recognized standards body, or, in the case of
interfaces specified for a particular programming language, one that
is widely used among developers working in that language.

  The "System Libraries" of an executable work include anything, other
than the work as a whole, that (a) is included in the normal form of
packaging a Major Component, but which is not part of that Major
Component, and (b) serves only to enable use of the work with that
Major Component, or to implement a Standard Interface for which an
implementation is available to the public in source code form.  A
"Major Component", in this context, means a major essential component
(kernel, window system, and so on) of the specific operating system
(if any) on which the executable work runs, or a compiler used to
produce the work, or an object code interpreter used to run it.

  The "Corresponding Source" for a work in object code form means all
the source code needed to generate, install, and (for an executable
work) run the object code and to modify the work, including scripts to
control those activities.  However, it does not include the work's
System Libraries, or general-purpose tools or generally available free
programs which are used unmodified in performing those activities but
which are not part of the work.  For example, Corresponding Source
includes interface definition files associated with source files for
the work, and the source code for shared libraries and dynamically
linked subprograms that the work is specifically designed to require,
such as by intimate data communication or control flow between those
subprograms and other parts of the work.

  The Corresponding Source need not include anything that users
can regenerate automatically from other parts of the Corresponding
Source.

  The Corresponding Source for a work in source code form is that
same work.

  2. Basic Permissions.

  All rights granted under this License are granted for the term of
copyright on the Program, and are irrevocable provided the stated
conditions are met.  This License explicitly affirms your unlimited
permission to run the unmodified Program.  The output from running a
covered work is covered by this License only if the output, given its
content, constitutes a covered work.  This License acknowledges your
rights of fair use or other equivalent, as provided by copyright law.

  You may make, run and propagate covered works that you do not
convey, without conditions so long as your license otherwise remains
in force.  You may convey covered works to others for the sole purpose
of having them make modifications exclusively for you, or provide you
with facilities for running those works, provided that you comply with
the terms of this License in conveying all material for which you do
not control copyright.  Those thus making or running the covered works
for you must do so exclusively on your behalf, under your direction
and control, on terms that prohibit them from making any copies of
your copyrighted material outside their relationship with you.

  Conveying under any other circumstances is permitted solely under
the conditions stated below.  Sublicensing is not allowed; section 10
makes it unnecessary.

  3. Protecting Users' Legal Rights From Anti-Circumvention Law.

  No covered work shall be deemed part of an effective technological
measure under any applicable law fulfilling obligations under article
11 of the WIPO copyright treaty adopted on 20 December 1996, or
similar laws prohibiting or restricting circumvention of such
measures.

  When you convey a covered work, you waive any legal power to forbid
circumvention of technological measures to the extent such circumvention
is effected by exercising rights under this License with respect to
the covered work, and you disclaim any intention to limit operation or
modification of the work as a means of enforcing, against the work's
users, your or third parties' legal rights to forbid circumvention of
technological measures.

  4. Conveying Verbatim Copies.

  You may convey verbatim copies of the Program's source code as you
receive it, in any medium, provided that you conspicuously and
appropriately publish on each copy an appropriate copyright notice;
keep intact all notices stating that this License and any
non-permissive terms added in accord with section 7 apply to the code;
keep intact all notices of the absence of any warranty; and give all
recipients a copy of this License along with the Program.

  You may charge any price or no price for each copy that you convey,
and you may offer support or warranty protection for a fee.

  5. Conveying Modified Source Versions.

  You may convey a work based on the Program, or the modifications to
produce it from the Program, in the form of source code under the
terms of section 4, provided that you also meet all of these conditions:

    a) The work must carry prominent notices stating that you modified
    it, and giving a relevant date.

    b) The work must carry prominent notices stating that it is
    released under this License and any conditions added under section
    7.  This requirement modifies the requirement in section 4 to
    "keep intact all notices".

    c) You must license the entire work, as a whole, under this
    License to anyone who comes into possession of a copy.  This
    License will therefore apply, along with any applicable section 7
    additional terms, to the whole of the work, and all its parts,
    regardless of how they are packaged.  This License gives no
    permission to license the work in any other way, but it does not
    invalidate such permission if you have separately received it.

    d) If the work has interactive user interfaces, each must display
    Appropriate Legal Notices; however, if the Program has interactive
    interfaces that do not display Appropriate Legal Notices, your
    work need not make them do so.

  A compilation of a covered work with other separate and independent
works, which are not by their nature extensions of the covered work,
and which are not combined with it such as to form a larger program,
in or on a volume of a storage or distribution medium, is called an
"aggregate" if the compilation and its resulting copyright are not
used to limit the access or legal rights of the compilation's users
beyond what the individual works permit.  Inclusion of a covered work
in an aggregate does not cause this License to apply to the other
parts of the aggregate.

  6. Conveying Non-Source Forms.

  You may convey a covered work in object code form under the terms
of sections 4 and 5, provided that you also convey the
machine-readable Corresponding Source under the terms of this License,
in one of these ways:

    a) Convey the object code in, or embodied in, a physical product
    (including a physical distribution medium), accompanied by the
    Corresponding Source fixed on a durable physical medium
    customarily used for software interchange.

    b) Convey the object code in, or embodied in, a physical product
    (including a physical distribution medium), accompanied by a
    written offer, valid for at least three years and valid for as
    long as you offer spare parts or customer support for that product
    model, to give anyone who possesses the object code either (1) a
    copy of the Corresponding Source for all the software in the
    product that is covered by this License, on a durable physical
    medium customarily used for software interchange, for a price no
    more than your reasonable cost of physically performing this
    conveying of source, or (2) access to copy the
    Corresponding Source from a network server at no charge.

    c) Convey individual copies of the object code with a copy of the
    written offer to provide the Corresponding Source.  This
    alternative is allowed only occasionally and noncommercially, and
    only if you received the object code with such an offer, in accord
    with subsection 6b.

    d) Convey the object code by offering access from a designated
    place (gratis or for a charge), and offer equivalent access to the
    Corresponding Source in the same way through the same place at no
    further charge.  You need not require recipients to copy the
    Corresponding Source along with the object code.  If the place to
    copy the object code is a network server, the Corresponding Source
    may be on a different server (operated by you or a third party)
    that supports equivalent copying facilities, provided you maintain
    clear directions next to the object code saying where to find the
    Corresponding Source.  Regardless of what server hosts the
    Corresponding Source, you remain obligated to ensure that it is
    available for as long as needed to satisfy these requirements.

    e) Convey the object code using peer-to-peer transmission, provided
    you inform other peers where the object code and Corresponding
    Source of the work are being offered to the general public at no
    charge under subsection 6d.

  A separable portion of the object code, whose source code is excluded
from the Corresponding Source as a System Library, need not be
included in conveying the object code work.

  A "User Product" is either (1) a "consumer product", which means any
tangible personal property which is normally used for personal, family,
or household purposes, or (2) anything designed or sold for incorporation
into a dwelling.  In determining whether a product is a consumer product,
doubtful cases shall be resolved in favor of coverage.  For a particular
product received by a particular user, "normally used" refers to a
typical or common use of that class of product, regardless of the status
of the particular user or of the way in which the particular user
actually uses, or expects or is expected to use, the product.  A product
is a consumer product regardless of whether the product has substantial
commercial, industrial or non-consumer uses, unless such uses represent
the only significant mode of use of the product.

  "Installation Information" for a User Product means any methods,
procedures, authorization keys, or other information required to install
and execute modified versions of a covered work in that User Product from
a modified version of its Corresponding Source.  The information must
suffice to ensure that the continued functioning of the modified object
code is in no case prevented or interfered with solely because
modification has been made.

  If you convey an object code work under this section in, or with, or
specifically for use in, a User Product, and the conveying occurs as
part of a transaction in which the right of possession and use of the
User Product is transferred to the recipient in perpetuity or for a
fixed term (regardless of how the transaction is characterized), the
Corresponding Source conveyed under this section must be accompanied
by the Installation Information.  But this requirement does not apply
if neither you nor any third party retains the ability to install
modified object code on the User Product (for example, the work has
been installed in ROM).

  The requirement to provide Installation Information does not include a
requirement to continue to provide support service, warranty, or updates
for a work that has been modified or installed by the recipient, or for
the User Product in which it has been modified or installed.  Access to a
network may be denied when the modification itself materially and
adversely affects the operation of the network or violates the rules and
protocols for communication across the network.

  Corresponding Source conveyed, and Installation Information provided,
in accord with this section must be in a format that is publicly
documented (and with an implementation available to the public in
source code form), and must require no special password or key for
unpacking, reading or copying.

  7. Additional Terms.

  "Additional permissions" are terms that supplement the terms of this
License by making exceptions from one or more of its conditions.
Additional permissions that are applicable to the entire Program shall
be treated as though they were included in this License, to the extent
that they are valid under applicable law.  If additional permissions
apply only to part of the Program, that part may be used separately
under those permissions, but the entire Program remains governed by
this License without regard to the additional permissions.

  When you convey a copy of a covered work, you may at your option
remove any additional permissions from that copy, or from any part of
it.  (Additional permissions may be written to require their own
removal in certain cases when you modify the work.)  You may place
additional permissions on material, added by you to a covered work,
for which you have or can give appropriate copyright permission.

  Notwithstanding any other provision of this License, for material you
add to a covered work, you may (if authorized by the copyright holders of
that material) supplement the terms of this License with terms:

    a) Disclaiming warranty or limiting liability differently from the
    terms of sections 15 and 16 of this License; or

    b) Requiring preservation of specified reasonable legal notices or
    author attributions in that material or in the Appropriate Legal
    Notices displayed by works containing it; or

    c) Prohibiting misrepresentation of the origin of that material, or
    requiring that modified versions of such material be marked in
    reasonable ways as different from the original version; or

    d) Limiting the use for publicity purposes of names of licensors or
    authors of the material; or

    e) Declining to grant rights under trademark law for use of some
    trade names, trademarks, or service marks; or

    f) Requiring indemnification of licensors and authors of that
    material by anyone who conveys the material (or modified versions of
    it) with contractual assumptions of liability to the recipient, for
    any liability that these contractual assumptions directly impose on
    those licensors and authors.

  All other non-permissive additional terms are considered "further
restrictions" within the meaning of section 10.  If the Program as you
received it, or any part of it, contains a notice stating that it is
governed by this License along with a term that is a further
restriction, you may remove that term.  If a license document contains
a further restriction but permits relicensing or conveying under this
License, you may add to a covered work material governed by the terms
of that license document, provided that the further restriction does
not survive such relicensing or conveying.

  If you add terms to a covered work in accord with this section, you
must place, in the relevant source files, a statement of the
additional terms that apply to those files, or a notice indicating
where to find the applicable terms.

  Additional terms, permissive or non-permissive, may be stated in the
form of a separately written license, or stated as exceptions;
the above requirements apply either way.

  8. Termination.

  You may not propagate or modify a covered work except as expressly
provided under this License.  Any attempt otherwise to propagate or
modify it is void, and will automatically terminate your rights under
this License (including any patent licenses granted under the third
paragraph of section 11).

  However, if you cease all violation of this License, then your
license from a particular copyright holder is reinstated (a)
provisionally, unless and until the copyright holder explicitly and
finally terminates your license, and (b) permanently, if the copyright
holder fails to notify you of the violation by some reasonable means
prior to 60 days after the cessation.

  Moreover, your license from a particular copyright holder is
reinstated permanently if the copyright holder notifies you of the
violation by some reasonable means, this is the first time you have
received notice of violation of this License (for any work) from that
copyright holder, and you cure the violation prior to 30 days after
your receipt of the notice.

  Termination of your rights under this section does not terminate the
licenses of parties who have received copies or rights from you under
this License.  If your rights have been terminated and not permanently
reinstated, you do not qualify to receive new licenses for the same
material under section 10.

  9. Acceptance Not Required for Having Copies.

  You are not required to accept this License in order to receive or
run a copy of the Program.  Ancillary propagation of a covered work
occurring solely as a consequence of using peer-to-peer transmission
to receive a copy likewise does not require acceptance.  However,
nothing other than this License grants you permission to propagate or
modify any covered work.  These actions infringe copyright if you do
not accept this License.  Therefore, by modifying or propagating a
covered work, you indicate your acceptance of this License to do so.

  10. Automatic Licensing of Downstream Recipients.

  Each time you convey a covered work, the recipient automatically
receives a license from the original licensors, to run, modify and
propagate that work, subject to this License.  You are not responsible
for enforcing compliance by third parties with this License.

  An "entity transaction" is a transaction transferring control of an
organization, or substantially all assets of one, or subdividing an
organization, or merging organizations.  If propagation of a covered
work results from an entity transaction, each party to that
transaction who receives a copy of the work also receives whatever
licenses to the work the party's predecessor in interest had or could
give under the previous paragraph, plus a right to possession of the
Corresponding Source of the work from the predecessor in interest, if
the predecessor has it or can get it with reasonable efforts.

  You may not impose any further restrictions on the exercise of the
rights granted or affirmed under this License.  For example, you may
not impose a license fee, royalty, or other charge for exercise of
rights granted under this License, and you may not initiate litigation
(including a cross-claim or counterclaim in a lawsuit) alleging that
any patent claim is infringed by making, using, selling, offering for
sale, or importing the Program or any portion of it.

  11. Patents.

  A "contributor" is a copyright holder who authorizes use under this
License of the Program or a work on which the Program is based.  The
work thus licensed is called the contributor's "contributor version".

  A contributor's "essential patent claims" are all patent claims
owned or controlled by the contributor, whether already acquired or
hereafter acquired, that would be infringed by some manner, permitted
by this License, of making, using, or selling its contributor version,
but do not include claims that would be infringed only as a
consequence of further modification of the contributor version.  For
purposes of this definition, "control" includes the right to grant
patent sublicenses in a manner consistent with the requirements of
this License.

  Each contributor grants you a non-exclusive, worldwide, royalty-free
patent license under the contributor's essential patent claims, to
make, use, sell, offer for sale, import and otherwise run, modify and
propagate the contents of its contributor version.

  In the following three paragraphs, a "patent license" is any express
agreement or commitment, however denominated, not to enforce a patent
(such as an express permission to practice a patent or covenant not to
sue for patent infringement).  To "grant" such a patent license to a
party means to make such an agreement or commitment not to enforce a
patent against the party.

  If you convey a covered work, knowingly relying on a patent license,
and the Corresponding Source of the work is not available for anyone
to copy, free of charge and under the terms of this License, through a
publicly available network server or other readily accessible means,
then you must either (1) cause the Corresponding Source to be so
available, or (2) arrange to deprive yourself of the benefit of the
patent license for this particular work, or (3) arrange, in a manner
consistent with the requirements of this License, to extend the patent
license to downstream recipients.  "Knowingly relying" means you have
actual knowledge that, but for the patent license, your conveying the
covered work in a country, or your recipient's use of the covered work
in a country, would infringe one or more identifiable patents in that
country that you have reason to believe are valid.

  If, pursuant to or in connection with a single transaction or
arrangement, you convey, or propagate by procuring conveyance of, a
covered work, and grant a patent license to some of the parties
receiving the covered work authorizing them to use, propagate, modify
or convey a specific copy of the covered work, then the patent license
you grant is automatically extended to all recipients of the covered
work and works based on it.

  A patent license is "discriminatory" if it does not include within
the scope of its coverage, prohibits the exercise of, or is
conditioned on the non-exercise of one or more of the rights that are
specifically granted under this License.  You may not convey a covered
work if you are a party to an arrangement with a third party that is
in the business of distributing software, under which you make payment
to the third party based on the extent of your activity of conveying
the work, and under which the third party grants, to any of the
parties who would receive the covered work from you, a discriminatory
patent license (a) in connection with copies of the covered work
conveyed by you (or copies made from those copies), or (b) primarily
for and in connection with specific products or compilations that
contain the covered work, unless you entered into that arrangement,
or that patent license was granted, prior to 28 March 2007.

  Nothing in this License shall be construed as excluding or limiting
any implied license or other defenses to infringement that may
otherwise be available to you under applicable patent law.

  12. No Surrender of Others' Freedom.

  If conditions are imposed on you (whether by court order, agreement or
otherwise) that contradict the conditions of this License, they do not
excuse you from the conditions of this License.  If you cannot convey a
covered work so as to satisfy simultaneously your obligations under this
License and any other pertinent obligations, then as a consequence you may
not convey it at all.  For example, if you agree to terms that obligate you
to collect a royalty for further conveying from those to whom you convey
the Program, the only way you could satisfy both those terms and this
License would be to refrain entirely from conveying the Program.

  13. Use with the GNU Affero General Public License.

  Notwithstanding any other provision of this License, you have
permission to link or combine any covered work with a work licensed
under version 3 of the GNU Affero General Public License into a single
combined work, and to convey the resulting work.  The terms of this
License will continue to apply to the part which is the covered work,
but the special requirements of the GNU Affero General Public License,
section 13, concerning interaction through a network will apply to the
combination as such.

  14. Revised Versions of this License.

  The Free Software Foundation may publish revised and/or new versions of
the GNU General Public License from time to time.  Such new versions will
be similar in spirit to the present version, but may differ in detail to
address new problems or concerns.

  Each version is given a distinguishing version number.  If the
Program specifies that a certain numbered version of the GNU General
Public License "or any later version" applies to it, you have the
option of following the terms and conditions either of that numbered
version or of any later version published by the Free Software
Foundation.  If the Program does not specify a version number of the
GNU General Public License, you may choose any version ever published
by the Free Software Foundation.

  If the Program specifies that a proxy can decide which future
versions of the GNU General Public License can be used, that proxy's
public statement of acceptance of a version permanently authorizes you
to choose that version for the Program.

  Later license versions may give you additional or different
permissions.  However, no additional obligations are imposed on any
author or copyright holder as a result of your choosing to follow a
later version.

  15. Disclaimer of Warranty.

  THERE IS NO WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY
APPLICABLE LAW.  EXCEPT WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT
HOLDERS AND/OR OTHER PARTIES PROVIDE THE PROGRAM "AS IS" WITHOUT WARRANTY
OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO,
THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
PURPOSE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THE PROGRAM
IS WITH YOU.  SHOULD THE PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF
ALL NECESSARY SERVICING, REPAIR OR CORRECTION.

  16. Limitation of Liability.

  IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING
WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MODIFIES AND/OR CONVEYS
THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES, INCLUDING ANY
GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE
USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED TO LOSS OF
DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY YOU OR THIRD
PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER PROGRAMS),
EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE POSSIBILITY OF
SUCH DAMAGES.

  17. Interpretation of Sections 15 and 16.

  If the disclaimer of warranty and limitation of liability provided
above cannot be given local legal effect according to their terms,
reviewing courts shall apply local law that most closely approximates
an absolute waiver of all civil liability in connection with the
Program, unless a warranty or assumption of liability accompanies a
copy of the Program in return for a fee.

                     END OF TERMS AND CONDITIONS

// END
 
