#! /bin/sh
# check script for Vgrid - Virtual grid program for radiology
# Copyright (C) 2020, 2021 Sonia Diaz Pacheco.
#
# This script is free software: you have unlimited permission
# to copy, distribute, and modify it.

LC_ALL=C
export LC_ALL
objdir=`pwd`
testdir=`cd "$1" ; pwd`
VGRID="${objdir}"/vgrid
framework_failure() { echo "failure in testing framework" ; exit 1 ; }

if [ ! -f "${VGRID}" ] || [ ! -x "${VGRID}" ] ; then
	echo "${VGRID}: cannot execute"
	exit 1
fi

[ -e "${VGRID}" ] 2> /dev/null ||
	{
	echo "$0: a POSIX shell is required to run the tests"
	echo "Try bash -c \"$0 $1 $2\""
	exit 1
	}

if [ -d tmp ] ; then rm -rf tmp ; fi
mkdir tmp
cd "${objdir}"/tmp || framework_failure

cat "${testdir}"/test.png > in.png || framework_failure
fail=0
test_failed() { fail=1 ; printf " $1" ; [ -z "$2" ] || printf "($2)" ; }

printf "testing vgrid-%s..." "$2"

"${VGRID}" -q < "${testdir}"/check.sh > /dev/null
[ $? = 2 ] || test_failed $LINENO
# these are for code coverage
"${VGRID}" -- nx_file 2> /dev/null
[ $? = 1 ] || test_failed $LINENO
"${VGRID}" "" < /dev/null 2> /dev/null
[ $? = 1 ] || test_failed $LINENO
"${VGRID}" --help > /dev/null || test_failed $LINENO
"${VGRID}" -V > /dev/null || test_failed $LINENO
"${VGRID}" --bad_option 2> /dev/null
[ $? = 1 ] || test_failed $LINENO
"${VGRID}" --output= 2> /dev/null
[ $? = 1 ] || test_failed $LINENO
"${VGRID}" --output 2> /dev/null
[ $? = 1 ] || test_failed $LINENO
"${VGRID}" --raw-copy=foo 2> /dev/null
[ $? = 1 ] || test_failed $LINENO

"${VGRID}" -C in.png || test_failed $LINENO
"${VGRID}" -C -c in_vg.png > /dev/null || test_failed $LINENO
rm -f in_vg.png || framework_failure
"${VGRID}" -C -c in.png > in_vg.png || test_failed $LINENO
"${VGRID}" -C -c in_vg.png > /dev/null || test_failed $LINENO
rm -f in_vg.png || framework_failure

"${VGRID}" -C -m 5 -s _median in.png || test_failed $LINENO
cmp in.png in_median.png > /dev/null && test_failed $LINENO
rm -f in_median.png || framework_failure

"${VGRID}" in.png || test_failed $LINENO
"${VGRID}" -C -c in_vg.png > /dev/null || test_failed $LINENO

"${VGRID}" --self-test -q in.png || test_failed $LINENO

"${VGRID}" -p in.png in.png > /dev/null || test_failed $LINENO
"${VGRID}" -p in.png in_vg.png > /dev/null
[ $? = 1 ] || test_failed $LINENO
rm -f in_vg.png || framework_failure

cp in.png foo.raw
"${VGRID}" --raw-copy=32,32,8,1 foo.raw || test_failed $LINENO
[ ! -e foo_vg.raw ] || test_failed $LINENO
[ ! -e foo_vg.png ] || test_failed $LINENO
[ ! -e foo.raw.png ] || test_failed $LINENO
"${VGRID}" --info foo.png > /dev/null || test_failed $LINENO
rm -f foo.raw foo.png || framework_failure

echo
if [ ${fail} = 0 ] ; then
	echo "tests completed successfully."
	cd "${objdir}" && rm -r tmp
else
	echo "tests failed."
fi
exit ${fail}
