# -*- coding: utf-8 -*-
# Copyright (C) 2010  Michał Masłowski  <mtjm@mtjm.eu>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.


"""Tube8.com plugin for GetMediumURL."""


from getmediumurl.htmlplugin import HTMLPlugin


__all__ = ("Tube8",)


class Tube8(HTMLPlugin):

    """Plugin for Tube8.com."""

    url_format = "http://www.tube8.com/%s/"
    website_name = "Tube8.com"

    @property
    def title(self):
        """Video title."""
        return self.get_content_substring(
            '<h1 class="main-title main-sprite-img">',
            '</h1>')

    @property
    def thumbnail(self):
        """Video thumnail URL."""
        return self.get_content_substring("flashvars.image_url = '",
                                          "';")

    def get_file_url(self, high_quality=False):
        """Get video URL."""
        return self.get_content_substring("flashvars.video_url = '",
                                          "';")
