# -*- coding: utf-8 -*-
# Copyright (C) 2010  Michał Masłowski  <mtjm@mtjm.eu>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.


"""xHamster plugin for GetMediumURL."""


from getmediumurl.htmlplugin import HTMLPlugin


__all__ = ("XHamster",)


class XHamster(HTMLPlugin):

    """Plugin for xHamster."""

    url_format = "http://xhamster.com/movies/%s.html"
    website_name = "xHamster"

    @property
    def thumbnail(self):
        """Video thumnail URL."""
        return self.get_content_substring("'image':'",
                                          ".jpg")

    def get_file_url(self, high_quality=False):
        """Get video URL."""
        return "http://xhamster.com/flv2/" \
            + self.get_content_substring("'file': '", "',")
