#!/bin/sh

echo 
echo "<---- Common dependencies ---->"
if which python >/dev/null; then
	vernum1=`python	 -c 'import sys ; print(sys.version_info[0])'`
	vernum2=`python -c 'import sys ; print(sys.version_info[1])'`

	#if version is 3.0 or later
	if [ $vernum1 -eq 3 ]; then
		echo -n "WARNING: WatchVideo doesn't work with Python 3.x versions. "
		echo "Please use Python 2.x series (preferably 2.6)"
	else
		echo "Python (required) - OK"
	fi

	#if version 2.5, check for simplejson
	if [ $vernum1 -eq 2 ] && [ $vernum2 -eq 5 ] && [ ! -d "/usr/share/pyshared/simplejson" ]; then
			echo "Since you have Python 2.5 you need simplejson."
			echo "simplejson - Missing!"	
	fi

else
	echo "Python (required) - Missing!"
fi

if [ -d "/usr/share/pyshared/lxml" ]; then
	echo "lxml (required) - OK"
else
	echo "lxml (required) - Missing!"
fi

echo
echo "<---- GUI only  ---->"

if [ -d "/usr/share/pyshared/PyQt4" ]; then
	echo "PyQt4 (required) - OK"
else
	echo "PyQt4 (required) - Missing!"
fi

if which ffmpeg >/dev/null; then
	echo "FFmpeg (optional) - OK"
else
	echo "FFmpeg (optional)- Missing!"
fi

if which ffmpeg2theora >/dev/null; then
	echo "FFmpeg2theora (optional) - OK"
else
	echo "FFmpeg2theora (optional) - Missing!"
fi

if [ -d "/usr/share/pyshared/gtk-2.0/pynotify" ]; then
	echo "pynotify (optional) - OK"
else
	echo "pynotify (optional) - Missing!"
fi

echo
echo "<----- Install dependencies ----->"

if [ -d "/usr/share/pyshared/setuptools" ]; then
	echo "setuptools (required) - OK"
else
	echo "setuptools (required) - Missing!"
fi

echo


	
