# -*- coding: utf-8 -*-
# Copyright (C) 2010  Michał Masłowski  <mtjm@mtjm.eu>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.


"""
Functions for caching values returned by other functions.
"""


def cachedproperty(getter):
    """Decorator for read-only properties with cached values."""
    name = getter.__name__
    attrib = "_cache__" + name

    def cached_getter(self):
        """Wrapper for property's getter."""
        try:
            return getattr(self, attrib)
        except AttributeError:
            value = getter(self)
            setattr(self, attrib, value)
            return value
    setattr(cached_getter, "__doc__", getter.__doc__)

    return property(cached_getter, doc=getter.__doc__)
