# -*- coding: utf-8 -*-
# Copyright (C) 2010  Michał Masłowski  <mtjm@mtjm.eu>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.


"""NothingToxic plugin for GetMediumURL."""


from getmediumurl.htmlplugin import HTMLPlugin


__all__ = ("NothingToxic",)


class NothingToxic(HTMLPlugin):

    """Plugin for NothingToxic."""

    url_format = "http://www.nothingtoxic.com/media/%s"

    @property
    def title(self):
        """Video title."""
        return self.get_content_substring("s2.addVariable(\"title\",'", "');")

    def get_file_url(self, high_quality=False):
        """Get video URL."""
        return self.get_content_substring("var flv_media_url = \"", "\";")
