/*

    Copyright (C) 2002  John Darrington 

    This program is free software; you can redistibute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "symbol.h"
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <assert.h>

const static char RCSID[]="$Id: symbol.c,v 1.5 2002/04/23 06:29:00 john Exp $";



static const size_t CHUNKSIZE=100;
static int initialised=0;
static char **table=0;
static int next=0;

void
sym_init()
{
  initialised=1;
  table = (char **) calloc(CHUNKSIZE,sizeof (char **));
  if ( ! table ) {
    perror("Cannot calloc");
    exit(1);
  }
}
 

int
sym_insert(const char *name)
{
  assert(initialised);

  assert(next < CHUNKSIZE);
 
  table[next] = (char *) calloc(strlen(name),sizeof(char*));
  if ( ! table[next] ) {
    perror("Cannot calloc");
    exit(1);
  }
  strcpy(table[next],name);

  return next++;
}

char *
sym_retreive(int index)
{
  assert(initialised);
  return table[index];
}
