/*

    Copyright (C) 2002  John Darrington 

    This program is free software; you can redistibute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
const static char RCSID[]="$Id: zone.c,v 1.5 2002/04/07 03:30:02 john Exp $";


#include "zone.h"


#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>

# define BUFSIZE 120

/* Return the location of the zoneinfo directory, or 0 if not found */
const char *
find_zoneinfo()
{
  const static char *candidates[] = {
    "/usr/share", "/usr/share/lib",
    "/usr/local/share", "/usr/local/share/lib",
    DATADIR,
    0
  };

  int i=0;
  int found=0;

  while(candidates[i] ) {
    char *dname=0;

    struct stat statbuf;


    dname = (char *) calloc(strlen(candidates[i])+
			    strlen("/zoneinfo")+1, sizeof(char)); 
    if (!dname) {
      perror("Cannot calloc");
      exit(1);
    }
    strcpy(dname,candidates[i]);
    strcat(dname,"/zoneinfo");

    if ( ( 0 == stat(dname,&statbuf) ) && S_ISDIR(statbuf.st_mode) ) {
      found=1;
    }

    free(dname);
    dname=0;

    if (found) 
      break;
    ++i;
  }
  
  return candidates[i];
}



/* Return the zone, as found by debian style systems */

char *
gz_debian(const char *zoneinfo)
{

  struct stat tzf;
  char *buf=0;
  int c;
  char *ss=0;
  static char result[BUFSIZE];

  const char file[]="/etc/localtime";

  /* TODO: put this in a loop in case there are nested links */
  if ( ( 0 != lstat(file,&tzf) ) ||  !S_ISLNK(tzf.st_mode) ) {
    return 0;
  }

  buf = (char *) calloc(tzf.st_size+1, sizeof(char));

  if (-1 == (c = readlink(file,buf,tzf.st_size) ) ) {
    perror("Cannot read symbolic link");
    exit (1);
  }

  buf[c]='\0';

  ss = buf + strlen(zoneinfo) + strlen("/zoneinfo") + 1;

  strcpy(result,ss);

  free(buf);
  buf=0;

  return result ; 
}


char *
gz_wdenv()
{
  return getenv("WDZONE");
}


/* Use the TZ environment variable as the political zone.
Use this only as last resort. Since it could be set to strange 
values.
*/
char *
gz_env()
{
  return getenv("TZ");
}

char *
gz_solaris()
{



  static char s[BUFSIZE];
  const char file[] ="/etc/TIMEZONE";
  FILE *fp;
  fp = fopen(file,"r");
  if ( !fp) 
    return 0;

  while (!feof(fp)) { 
    fgets(s,BUFSIZE, fp);
    if ( strstr(s,"TZ=")) {
      char *w=0;
      memmove(s, s+strlen("TZ="),BUFSIZE-strlen("TZ="));
      w=(char *)strpbrk(s,"\n\t ");
      if (w) 
	*w='\0';
      break;
    }

  } 
    
  fclose(fp);
  return s;
}

char *
getzone()
{
  char *z=0;
  
  const char *zoneinfo = find_zoneinfo();

  if ( !z)   z = gz_wdenv() ;
  if ( !z)   z = gz_debian(zoneinfo) ;
  if ( !z)   z = gz_solaris() ;
  if ( !z)   z = gz_env() ;
  
  return z;
}
