# Make sure that the program accepts only valid dates and
# rejects the others
# $Id: t0001a.sh,v 1.5 2002/06/07 03:34:46 john Exp $


fail ()
{
    echo "Test Failed ($activity)"
    exit 1
}

pass ()
{
	exit 0
}


activity="Good date 18"
./build/bin/wday 20010131
if [ $? -ne 0 ] ; then fail ; fi

activity="Bad Month"
./build/bin/wday 20010021  # Bad month
if [ $? -eq 0 ] ; then fail ; fi

activity="Bag Day"
./build/bin/wday 20010132  # Bad day
if [ $? -eq 0 ] ; then fail ; fi

activity="Wrong Format 30"
./build/bin/wday 11112  # Wrong format
if [ $? -eq 0 ] ; then fail ; fi

activity="Wrong Format 34"
./build/bin/wday d00112  # Wrong format
if [ $? -eq 0 ] ; then fail ; fi

activity="Bad year"
./build/bin/wday 00000112  # Bad year
if [ $? -eq 0 ] ; then fail ; fi

activity="Bad Day non leap year 42"
./build/bin/wday 20010229  # Bad Day ( not leap year)
if [ $? -eq 0 ] ; then fail ; fi

activity="OK leap year"
./build/bin/wday 20000229  # OK (leap year)
if [ $? -ne 0 ] ; then fail ; fi

activity="Bad Day non leap year 50"
./build/bin/wday 19000229  # Bad Day ( not leap year)
if [ $? -eq 0 ] ; then fail ; fi

activity="Bad month 54"
./build/bin/wday 20011321  # Bad month
if [ $? -eq 0 ] ; then fail ; fi

pass
