# Test that the -l flag works

fail ()
{
    cd /
    rm -rf $TEMPDIR
    exit 1
}


pass ()
{
    cd /
    rm -rf $TEMPDIR
    exit 0
}

TEMPDIR=/tmp/$$
mkdir $TEMPDIR

# print out a list of holiday dates

./build/bin/wday --list -f '%Y%m%d' 2031 | awk -F':' '{print $2}' > $TEMPDIR/dates
if [ $? -ne 0 ] ; then fail ; fi

test -s $TEMPDIR/dates
if [ $? -ne 0 ] ; then fail ; fi

# Make sure that these dates are all in fact holidays
for i in `cat $TEMPDIR/dates` ; do 
    ./build/bin/wday $i | grep 'not' 
    test $? -ne 0
    if [ $? -ne 0 ] ; then fail ; fi
done

pass
