# Test that empty  or non-existant spec files display an appropriate message

fail ()
{
    cd /
    rm -rf $TEMPDIR
    exit 1
}


pass ()
{
    cd /
    rm -rf $TEMPDIR
    exit 0
}

unset LANG
unset LANGUAGE
unset LC_MESSAGES
unset LC_TIME

TEMPDIR=/tmp/$$
mkdir $TEMPDIR
if [ $? -ne 0 ] ; then fail ; fi


# try it for empty files
cp /dev/null $TEMPDIR/mordor
if [ $? -ne 0 ] ; then fail ; fi

./build/bin/wday -z mordor -d $TEMPDIR 2> $TEMPDIR/file
test $? -ne 0
if [ $? -ne 0 ] ; then fail ; fi

grep 'Sorry' $TEMPDIR/file > /dev/null
if [ $? -ne 0 ] ; then fail ; fi


# Now try it for non existant files
rm -f $TEMPDIR/mordor
if [ $? -ne 0 ] ; then fail ; fi

./build/bin/wday -z mordor -d $TEMPDIR 2> $TEMPDIR/file
test $? -ne 0
if [ $? -ne 0 ] ; then fail ; fi

grep 'Sorry' $TEMPDIR/file > /dev/null
if [ $? -ne 0 ] ; then fail ; fi


pass
