#!/bin/sh
# Copyright 2003, John Darrington
# Test that the year field of the calendar event works

fail ()
{
    cd /
    rm -rf $TEMPDIR
    exit 1
}


pass ()
{
    cd /
    rm -rf $TEMPDIR
    exit 0
}

TEMPDIR=/tmp/$$
mkdir $TEMPDIR
if [ $? -ne 0 ] ; then fail ; fi

# Check the behaviour with no year

cat > $TEMPDIR/TEST <<EOF
h "Donald Knuth's Birthday" 10 1 
EOF
if [ $? -ne 0 ] ; then fail ; fi

./build/bin/wday -q -d $TEMPDIR -z TEST 20050110
if [ $? -ne 0 ] ; then fail ; fi


# And now check the behaviour with a year specified
cat > $TEMPDIR/TEST <<EOF
h "Another's Birthday" 10 1 1973
EOF
if [ $? -ne 0 ] ; then fail ; fi

./build/bin/wday -q -d $TEMPDIR -z TEST 19730110
if [ $? -ne 0 ] ; then fail ; fi

./build/bin/wday -q -d $TEMPDIR -z TEST 20050110
test $? -ne 0
if [ $? -ne 0 ] ; then fail ; fi



pass
