#!/bin/sh
#
# Test that wildcards in calendar events work

fail ()
{
    cd /
    rm -rf $TEMPDIR
    exit 1
}


pass ()
{
    cd /
    rm -rf $TEMPDIR
    exit 0
}

unset LANG
unset LANGUAGE
unset LC_TIME
unset LC_MESSAGES

TEMPDIR=/tmp/$$
mkdir $TEMPDIR
if [ $? -ne 0 ] ; then fail ; fi


cat > $TEMPDIR/foobar  <<EOF

h "any day in 2001"   * * 2001
EOF
if [ $? -ne 0 ] ; then fail ; fi


./build/bin/wday -d $TEMPDIR -q -z foobar 20010302
if [ $? -ne 0 ] ; then fail ; fi

./build/bin/wday -d $TEMPDIR -q -z foobar 20010401
if [ $? -ne 0 ] ; then fail ; fi


./build/bin/wday -d $TEMPDIR -q -z foobar 20000401
test $? -ne 0
if [ $? -ne 0 ] ; then fail ; fi



pass
