#!/bin/sh
#
# Test that the NOT constraint works

fail ()
{
    cd /
    rm -rf $TEMPDIR
    exit 1
}


pass ()
{
    cd /
    rm -rf $TEMPDIR
    exit 0
}

unset LANG
unset LANGUAGE
unset LC_TIME
unset LC_MESSAGES

TEMPDIR=/tmp/$$
mkdir $TEMPDIR
if [ $? -ne 0 ] ; then fail ; fi


cat > $TEMPDIR/foobar <<EOF
- "2001"  * * 2001 
- "March"  * 3

h "any day in 2001, except during March" ( >!=< "March" "2001" )
EOF
if [ $? -ne 0 ] ; then fail ; fi

./build/bin/wday -d $TEMPDIR -q -z foobar 20010202
if [ $? -ne 0 ] ; then fail ; fi


./build/bin/wday -d $TEMPDIR -q -z foobar 20010302
test $? -ne 0 
if [ $? -ne 0 ] ; then fail ; fi


./build/bin/wday -d $TEMPDIR -q -z foobar 20020202
test $? -ne 0 
if [ $? -ne 0 ] ; then fail ; fi

./build/bin/wday -d $TEMPDIR -q -z foobar 20020302
test $? -ne 0 
if [ $? -ne 0 ] ; then fail ; fi


pass
