#!/bin/sh
#
# Test that anonymous events in compound events work OK

fail ()
{
    cd /
    rm -rf $TEMPDIR
    exit 1
}


pass ()
{
    cd /
    rm -rf $TEMPDIR
    exit 0
}

unset LANG
unset LANGUAGE
unset LC_TIME
unset LC_MESSAGES

TEMPDIR=/tmp/$$
mkdir $TEMPDIR
if [ $? -ne 0 ] ; then fail ; fi


cat > $TEMPDIR/somewhere <<EOF
- "Monday"  MON
h "1st Monday on or after Jan 2"   ( 
    >1+=< 
    "Monday"  
    ( 2 1 ) 
)
EOF
if [ $? -ne 0 ] ; then fail ; fi

./build/bin/wday -q -d $TEMPDIR -z somewhere 20020107
if [ $? -ne 0 ] ; then fail ; fi 


pass
