#!/bin/sh
#
# Test that >n-=< only matches one date

fail ()
{
    cd /
    rm -rf $TEMPDIR
    exit 1
}


pass ()
{
    cd /
    rm -rf $TEMPDIR
    exit 0
}

unset LANG
unset LANGUAGE
unset LC_TIME
unset LC_MESSAGES

TEMPDIR=/tmp/$$
mkdir $TEMPDIR
if [ $? -ne 0 ] ; then fail ; fi

cat > $TEMPDIR/somewhere <<EOF
h "1. Adventssonntag"  ( >4-=<  (SUN) ( 24 12 ) ) 

EOF
if [ $? -ne 0 ] ; then fail ; fi


./build/bin/wday  -q  -d $TEMPDIR -z somewhere  20061203
if [ $? -ne 0 ] ; then fail ; fi 

./build/bin/wday  -q -d $TEMPDIR -z somewhere  20061224
test $? -ne 0
if [ $? -ne 0 ] ; then fail ; fi 




pass
