#!/bin/sh
#
# Test that there are no objects in the source directory

fail ()
{
    cd /
    rm -rf $TEMPDIR
    exit 1
}


pass ()
{
    cd /
    rm -rf $TEMPDIR
    exit 0
}

unset LANG
unset LANGUAGE
unset LC_TIME
unset LC_MESSAGES

TEMPDIR=/tmp/$$
mkdir $TEMPDIR
if [ $? -ne 0 ] ; then fail ; fi


# Temporarily allow symbolic links . . . (HACK)
#ls src/*.o 
find src -not -type l  -name '*\.o' > $TEMPDIR/objs
test ! -s $TEMPDIR/objs
if [ $? -ne 0 ] ; then fail ; fi

find src -not -type l  -name wday > $TEMPDIR/exec
test ! -s $TEMPDIR/exec
if [ $? -ne 0 ] ; then fail ; fi



pass
