#!/bin/sh
# Copyright 2003, John Darrington
# Test that the -L ( --list-zones= ) option works

fail ()
{
    cd /
    rm -rf $TEMPDIR
    exit 1
}


pass ()
{
    cd /
    rm -rf $TEMPDIR
    exit 0
}

unset LANG
unset LANGUAGE
unset LC_TIME
unset LC_MESSAGES

TEMPDIR=/tmp/$$
mkdir $TEMPDIR
if [ $? -ne 0 ] ; then fail ; fi


(cd build/share/wdinfo ; find  Australia \! -name '*,D' -size 1b | sed -e 's/^\.\///' > $TEMPDIR/zones )
if [ $? -ne 0 ] ; then fail ; fi


build/bin/wday -LAustralia  > $TEMPDIR/file
if [ $? -ne 0 ] ; then fail ; fi


diff $TEMPDIR/file $TEMPDIR/zones
if [ $? -ne 0 ] ; then fail ; fi

build/bin/wday --list-zones=Australia > $TEMPDIR/file
if [ $? -ne 0 ] ; then fail ; fi


diff $TEMPDIR/file $TEMPDIR/zones
if [ $? -ne 0 ] ; then fail ; fi

build/bin/wday -L  > $TEMPDIR/file
if [ $? -ne 0 ] ; then fail ; fi

(cd build/share/wdinfo ; find  . \! -name '*,D'  \! -type d -size +1c | sed -e 's/^\.\///' > $TEMPDIR/zones )
if [ $? -ne 0 ] ; then fail ; fi


diff $TEMPDIR/file $TEMPDIR/zones
if [ $? -ne 0 ] ; then fail ; fi

pass


