//////////////////////////////////////////////////////////////////////////////////
//                                                                              //
//  This file is part of Web Documentation Typesetter (WDT).                    //
//                                                                              //
//  WDT is free software; you  can redistribute it and/or  modify it under the  //
//  terms of the GNU General  Public License as published by the Free Software  //
//  Foundation; either version 2 of the License, or (at your option) any later  //
//  version.                                                                    //
//                                                                              //
//  WDT is distributed in the  hope that it  will be useful,  but WITHOUT  ANY  //
//  WARRANTY; without  even the implied warranty of MERCHANTABILITY or FITNESS  //
//  FOR A  PARTICULAR  PURPOSE.  See the GNU  General Public  License for more  //
//  details.                                                                    //
//                                                                              //
//  You should have received a copy of the GNU General Public License along     //
//  with WDT; if not, write to the Free Software Foundation, Inc.,              //
//  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA                    //
//                                                                              //
//  For more information, see COPYING file                                      //
//                                                                              //
//  Copyright (C) 2005 Stanislav Yaglo                                          //
//                                                                              //
//  Author: Stanislav Yaglo <stas@plg.lrn.ru>                                   //
//                                                                              //
//////////////////////////////////////////////////////////////////////////////////

// document.cpp
//  .     .

#ifndef DOCUMENT_H
#define DOCUMENT_H

#include <vector>
#include <string>
#include <ctime>

#include "units.h"

class Document
{
public:
	Document();
	~Document();

	strvec source;			//   

	std::string	title;		//  
	std::string charset;	//  

	std::vector<std::string> authors;		// 
	std::vector<std::string> authorsHref;
	std::vector<std::string> translators;	// 
	std::vector<std::string> contributors;	//  

	std::string original;	//   
	std::string	version;	//  
	time_t		date;		//  
	
	std::string HTML;		//   HTML
	


	// 
	std::vector<std::string>	unitPart;
	std::vector<std::string>	unitChap;
	std::vector<std::string>	unitSect;
	std::vector<std::string>	unitSubSect;
	std::vector<std::string>	unitHead;
	std::vector<std::string>	unitSubHead;

	std::vector<std::string>	unitP;
	std::vector<Image>			unitImg;
	std::vector<Code>			unitCode;

	
	std::vector<int>	modelID;	//  
	std::vector<int>	modelT;
	
	std::vector<int>	tocID;		// 
	std::vector<int>	tocT;



	/// 
	void makeTOC();	//  
};

#endif	// DOCUMENT_H

// vim:sw=4 ts=4

