//////////////////////////////////////////////////////////////////////////////////
//                                                                              //
//  This file is part of Web Documentation Typesetter (WDT).                    //
//                                                                              //
//  WDT is free software; you  can redistribute it and/or  modify it under the  //
//  terms of the GNU General  Public License as published by the Free Software  //
//  Foundation; either version 2 of the License, or (at your option) any later  //
//  version.                                                                    //
//                                                                              //
//  WDT is distributed in the  hope that it  will be useful,  but WITHOUT  ANY  //
//  WARRANTY; without  even the implied warranty of MERCHANTABILITY or FITNESS  //
//  FOR A  PARTICULAR  PURPOSE.  See the GNU  General Public  License for more  //
//  details.                                                                    //
//                                                                              //
//  You should have received a copy of the GNU General Public License along     //
//  with WDT; if not, write to the Free Software Foundation, Inc.,              //
//  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA                    //
//                                                                              //
//  For more information, see COPYING file                                      //
//                                                                              //
//  Copyright (C) 2005 Stanislav Yaglo                                          //
//                                                                              //
//  Author: Stanislav Yaglo <stas@plg.lrn.ru>                                   //
//                                                                              //
//////////////////////////////////////////////////////////////////////////////////

#include <iostream>
#include <string>

#include "parser.h"
#include "units.h"

std::string refmtCode(std::string &line);

Parser::Parser(Document *docum)
{
	doc = docum;
}

Parser::~Parser()
{
}

void Parser::parseDoc()
{
	doc->charset = "iso-8859-1";
	scan();
}

void Parser::scan()
{
	std::string line;

	for (int i = 0; i < doc->source.size()-1; i++)
	{
		line = doc->source[i];

		if (!isEmpty(line)){

		if (line[0] == '.'){
			char c;
			int curpos = 1;
			std::string tagName;

			do {
				c = line[curpos++];
			} while (c == '\t' || c == ' ');

			for (int j = curpos-1; j < line.size(); j++) {
				c = line[j];
				if (isalpha(c))
					tagName += c;
				else {
					curpos = j;
					break;
				}
			}

			int prevpos = curpos;
			std::string linearg = "";
			
			do
				c = line[curpos++];
			while (c == '\t' || c == ' ' || c == ':');

			if (curpos-1 == prevpos){
				line = '.' + tagName;
			} else {
				line.erase(0, curpos-1);
				linearg = line;
			}
			
			if (isBlock(tagName)){
				std::string text = "";
				std::string endTag = ".e" + tagName;
				while (doc->source[++i] != endTag) {
					text.append("\n");
					text.append(doc->source[i]);
					doc->source[i]="";
				}

				Code tmp; 
				tmp.lang = linearg;
				tmp.text = text;
				doc->unitCode.push_back(tmp);
				doc->modelT.push_back(T_CODE);
				doc->modelID.push_back(doc->unitCode.size());
			} else if (tagName == "title")
				titleTag(linearg);
			else if (tagName == "author")
				authorTag(linearg);
			else if (tagName == "sect")
				sectTag(linearg);
			else if (tagName == "chap")
				chapTag(linearg);
			else if (tagName == "charset")
				charsetTag(linearg);
		} else paraFound(i);
		
		} // if(!isEmpty(line))
	}
}

void Parser::titleTag(std::string line)
{
	doc->title = strip(line);
}

void Parser::authorTag(std::string line)
{
	std::vector<std::string> arg = splitString(line, '|');

	doc->authors.push_back(strip(arg[0]));
	if (arg.size() > 1)
		doc->authorsHref.push_back(strip(arg[1]));
	else
		doc->authorsHref.push_back("#NO EMAIL#");
}
	
void Parser::sectTag(std::string line)
{
	doc->unitSect.push_back(strip(line));
	doc->modelT.push_back(T_SECT);
	doc->modelID.push_back(doc->unitSect.size());
}

void Parser::chapTag(std::string line)
{
	doc->unitSect.push_back(strip(line));
	doc->modelT.push_back(T_SECT);
	doc->modelID.push_back(doc->unitSect.size());
}

int Parser::paraFound(int &iter)
{
	std::string text = "";
	std::string line;
	
	while(iter < doc->source.size() && !isEmpty((line = doc->source[iter])))
	{
		text.append(line);
		text.append("\n");
		iter++;
	}

	doc->unitP.push_back(text);
	doc->modelT.push_back(T_P);
	doc->modelID.push_back(doc->unitP.size());
	
	return iter;
}

void Parser::charsetTag(std::string line)
{
	doc->charset = line;
}

bool Parser::isBlock(std::string tag)
{
	if (tag == "src" || tag == "html" || tag == "pre" ||
			tag == "note" || tag == "tip" || tag == "warning")
		return true;
	return false;
}


std::string refmtCode(std::string &line)
{
	std::string newline = "";
	
	for (int i = 0; i < line.size(); i++)
	{
		if (line[i] == '<') 
			newline.append("&lt;");
		else if (line[i] == '>') 
			newline.append("&gt;");
		else 
			newline.append(line,i,1);
	}

	return newline;
}

// vim:sw=4 ts=4

