//////////////////////////////////////////////////////////////////////////////////
//                                                                              //
//  This file is part of Web Documentation Typesetter (WDT).                    //
//                                                                              //
//  WDT is free software; you  can redistribute it and/or  modify it under the  //
//  terms of the GNU General  Public License as published by the Free Software  //
//  Foundation; either version 2 of the License, or (at your option) any later  //
//  version.                                                                    //
//                                                                              //
//  WDT is distributed in the  hope that it  will be useful,  but WITHOUT  ANY  //
//  WARRANTY; without  even the implied warranty of MERCHANTABILITY or FITNESS  //
//  FOR A  PARTICULAR  PURPOSE.  See the GNU  General Public  License for more  //
//  details.                                                                    //
//                                                                              //
//  You should have received a copy of the GNU General Public License along     //
//  with WDT; if not, write to the Free Software Foundation, Inc.,              //
//  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA                    //
//                                                                              //
//  For more information, see COPYING file                                      //
//                                                                              //
//  Copyright (C) 2005 Stanislav Yaglo                                          //
//                                                                              //
//  Author: Stanislav Yaglo <stas@plg.lrn.ru>                                   //
//                                                                              //
//////////////////////////////////////////////////////////////////////////////////

#include <iostream>
#include <string>

#include "generator.h"
#include "units.h"

void Generator::generateHTML(Document *doc)
{
	using namespace std;
	cout	<< "<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"\n"
			<< "  \"http://www.w3.org/TR/html4/loose.dtd\">\n"
			<< "<html>\n"
			<<	"  <head>\n"
			<< "    <title>" << doc->title << "</title>\n"
			<< "    <meta http-equiv=\"Content-Type\" content=\"text/html; charset=koi8-r\">\n"
			<< "    <link href=\"style.css\" rel=\"stylesheet\" type=\"text/css\">\n"
			<< "  </head>\n"
			<< "<body>\n"
			<< "<h1>" << doc->title << "</h1>\n";
	
	for (int i = 0; i < doc->authors.size(); i++)
	{
		cout << "<center><b>Author: <i>";
		if (doc->authorsHref[i] != "#NO EMAIL#")
			cout << "<a href=\"" << doc->authorsHref[i] << "\">" << doc->authors[i] << "</a>";
		else
			cout << doc->authors[i];
		cout << "</i></b></center>\n";
	}
	
	doc->makeTOC();

	cout << "<p><b>Contents:</b></p>\n";
	cout << "<ul>\n";
	for (int i = 0; i < doc->tocID.size(); i++)
	{
		cout << "  <li><b><a href=\"#id" << doc->tocID[i] << "\">" << doc->unitSect[i] << "</a></b></li>" << endl;
	}
	cout << "</ul>\n";

	int j = 1;
	for (int i = 0; i < doc->modelID.size(); i++)
	{
		switch(doc->modelT[i])
		{
			//case T_CHAP:
			//	cout << "<h1>" << "<a name=\"id" << j++ << "\"></a>" << doc->unitChap[doc->modelID[i]-1] << "</h1>\n";
			//	break;

			case T_SECT:
				cout << "<h2>" << "<a name=\"id" << j++ << "\"></a>" << doc->unitSect[doc->modelID[i]-1] << "</h2>\n";
				break;
				
			case T_P:
				{
					std::string para = reformatPara(doc->unitP[doc->modelID[i]-1]);
					cout << "<p>" << para << "</p>\n";
				}
				break;

			case T_CODE:
				{
					Code tmp = doc->unitCode[doc->modelID[i]-1];
					cout << "<pre>" << tmp.text << "</pre>\n";
				}
				break;
			
			default:
				cout << "  <br>\n";
				break;
		}
	}
	
	cout << "<hr>\n";
	cout << "<center><span style=\"font-size: 90%;\">Generated by <a href=\"http://savannah.nongnu.org/projects/wdt/\">Web Documentation Typesetter</a> version 0.1 by <a href=\"mailto:stas.-AT-.plg.lrn.ru\">Stanislav Yaglo</a>.</span></center>\n";
	
	cout << "</body>\n</html>\n";
}

std::string Generator::reformatPara(std::string text)
{
	std::string newtext = "";
	bool bold = false;
	bool italic = false;
	
	for (int i = 0; i < text.size(); i++)
	{
		if (text[i] == '<') {
			newtext.append("&lt;");
			i++;
		} else if (text[i] == '>') {
			newtext.append("&gt;");
			i++;
		}
		
		if (text[i] == '*' && text[i+1] == '|') {
			newtext.append("<strong>");
			i++;
		} else if (text[i] == '|' && text[i+1] == '*') {
			newtext.append("</strong>");
			i++;
		} else if (text[i] == '/' && text[i+1] == '|') {
			newtext.append("<em>");
			i++;
		} else if (text[i] == '|' && text[i+1] == '/') {
			newtext.append("</em>");
			i++;
		}
				
			/*&& text[i-1] != '\\'){
			if (!bold) {
				newtext.append("<strong>");
				bold = true;
			} else {
				newtext.append("</strong>");
				bold = false;
			}
		} else if (text[i] == '*' && text[i-1] == '\\'){
			newtext.append("*");
			i++;*/
		else 
			newtext.append(text,i,1);
	}

	return newtext;
}

// vim:sw=4 ts=4

