//////////////////////////////////////////////////////////////////////////////////
//                                                                              //
//  This file is part of Web Documentation Typesetter (WDT).                    //
//                                                                              //
//  WDT is free software; you  can redistribute it and/or  modify it under the  //
//  terms of the GNU General  Public License as published by the Free Software  //
//  Foundation; either version 2 of the License, or (at your option) any later  //
//  version.                                                                    //
//                                                                              //
//  WDT is distributed in the  hope that it  will be useful,  but WITHOUT  ANY  //
//  WARRANTY; without  even the implied warranty of MERCHANTABILITY or FITNESS  //
//  FOR A  PARTICULAR  PURPOSE.  See the GNU  General Public  License for more  //
//  details.                                                                    //
//                                                                              //
//  You should have received a copy of the GNU General Public License along     //
//  with WDT; if not, write to the Free Software Foundation, Inc.,              //
//  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA                    //
//                                                                              //
//  For more information, see COPYING file                                      //
//                                                                              //
//  Copyright (C) 2005 Stanislav Yaglo                                          //
//                                                                              //
//  Author: Stanislav Yaglo <stas@plg.lrn.ru>                                   //
//                                                                              //
//////////////////////////////////////////////////////////////////////////////////

#include <string>
#include <vector>

//          
std::string strip(std::string line)
{
	int c = line.find_first_not_of(" \t");
	if (c != std::string::npos)
		line.erase(0, c);

	c = line.size()-1;

	while (line[c] == ' ' || line[c] == '\t')
		c--;

	line.erase(c+1);
	
	return line;
}

std::string stripNL(std::string text)
{
	int pos = 0;
	
	while((pos = text.find('\n')) != std::string::npos)
	{
		text.replace(pos, 1, " ");
	}

	return text;
}

std::vector<std::string> splitString(const std::string& s, unsigned char delim){
	std::string::size_type pos=s.find(delim), oldPos=0;
	std::vector <std::string> results;

	if (pos ==std::string::npos) {
		if (!s.empty())results.push_back(s);
		return results;
	}

	do {
		if (oldPos-pos) results.push_back (s.substr(oldPos, pos-oldPos));
		oldPos=pos+1;
		pos=s.find(delim, pos+1);
	} while (pos!=std::string::npos);
	results.push_back (s.substr(oldPos));

	return results;
}

bool isEmpty(std::string text)
{
	int pos = text.find_first_not_of(" \t");
	if (!(pos == std::string::npos))
		if (text[pos] == '%' && text[pos+1] == '%')
			return true;
		else
			return false;
	return true;
}
