//////////////////////////////////////////////////////////////////////////////////
//                                                                              //
//  This file is part of Web Documentation Typesetter (WDT).                    //
//                                                                              //
//  WDT is free software; you  can redistribute it and/or  modify it under the  //
//  terms of the GNU General  Public License as published by the Free Software  //
//  Foundation; either version 2 of the License, or (at your option) any later  //
//  version.                                                                    //
//                                                                              //
//  WDT is distributed in the  hope that it  will be useful,  but WITHOUT  ANY  //
//  WARRANTY; without  even the implied warranty of MERCHANTABILITY or FITNESS  //
//  FOR A  PARTICULAR  PURPOSE.  See the GNU  General Public  License for more  //
//  details.                                                                    //
//                                                                              //
//  You should have received a copy of the GNU General Public License along     //
//  with WDT; if not, write to the Free Software Foundation, Inc.,              //
//  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA                    //
//                                                                              //
//  For more information, see COPYING file                                      //
//                                                                              //
//  Copyright (C) 2005 Stanislav Yaglo                                          //
//                                                                              //
//  Author: Stanislav Yaglo <stas@plg.lrn.ru>                                   //
//                                                                              //
//////////////////////////////////////////////////////////////////////////////////

#include <vector>
#include <string>

#ifndef UNITS_H
#define UNITS_H

enum types
{
	T_PART, T_SECT, T_SUBSECT, T_HEAD, T_SUBHEAD,
	T_P, T_IMG, T_CODE
};

enum aligns
{
	A_CENTER, A_LEFT, A_RIGHT, A_FLEFT, A_FRIGHT
};

class Image
{
public:
	int	width;
	int	height;
	int	align;
	std::string	url;
};

class Code
{
public:
	std::string	lang;
	std::string text;
};

typedef std::vector<std::string> strvec;

std::string strip(std::string line);
std::vector<std::string> splitString(const std::string& s, unsigned char delim);
std::string stripNL(std::string text);
bool isEmpty(std::string text);

#endif // UNITS_H

// vim:sw=4 ts=4

