#!/usr/bin/env python

""" Wikiup utiility functions.
"""

copyright = """
Copyright (C) 2003 Jaime Villate <villate@gnu.org>
 """
license = """
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
"""

import os

def removeFile(fileName):
    """Quietly remove a file.
       taken from pywiki 0.4.2, Copyright (C) 1998  Tim Voght
    """
    try:
        os.remove(fileName)
    except:
        pass
    return

def devNull():
    """Return the appropriate file name for an infinite sink file.
        taken from pywiki 0.4.2, Copyright (C) 1998  Tim Voght
    """
    if os.name == 'nt':
        return 'nul'
    return '/dev/null'

def quotate(fileName):
    """taken from pywiki 0.4.2, Copyright (C) 1998  Tim Voght """
    if os.name == 'nt':
        return '\"' + fileName + '\"'
    return fileName

def MD5sum(str):
    """Generates an MD5 checksum for a string (a 32-digit hexadecimal number).
       It does for a string the same thing that the GNU/Linux command md5sum
       does for a file's content. It uses the md5 module, which implements
       the algorithm in RFC 1321.
    """
    import md5
    from string import hexdigits
    md5sum = ''
    for char in md5.new(str).digest():
	asciival = ord(char)
	md5sum += hexdigits[(asciival >> 4) & 0xF] + hexdigits[asciival & 0xF]
    return md5sum

def MD5sumCheck(str,md5sum):
    """Checks the MD5 checksum for a string.
       It retuns 1 if the given md5sum string (a 32-digit hexadecimal number)
       matches the MD5 check sum of the string, and zero otherwise.
    """
    return (md5sum == MD5sum(str))

def Config(section,*options):
    """Reads options from a configuration file
       Given the name of a section, followed by a list of options, the
       value of the options in the configuration file is returned. A
       blank string is returned for each unknown option.
    """
    from ConfigParser import ConfigParser
    conf = ConfigParser()
    conf.read('wikiup.conf')
    unknown = 0
    values = ()
    if not conf.has_section(section): unknown = 1
    for option in options:
	if unknown:
	   values += '',
	else:
	   if conf.has_option(section,option):
	      values += conf.get(section,option),
	   else:
	      values += '',
    if len(values) == 1:
        return values[0]
    else:
        return values

def PrintPage(title, text, template, username='', cookie=''):
    """Creates an HTML page with header, from a template
       The template is an HTML file which can should contain a string
       %(text)s in the place where the text of the page should go.
       The variables %(title)s and %(username)s can also appear in the HTML
       template, and their values will be substituted.
    """
    html = open(template)
    page = html.read() % locals()
    html.close()
    print "Content-type: text/html"
    if cookie: print cookie
    print '\n' + page
    return

def GetUsername(hash):
    """Finds the username, given the login hash"""
    username = ''
    login = open(Config('account','login_file'))
    for line in login.read().splitlines():
       field = line.split(':')
       if field[1] == hash:
	  username = field[0]
	  break
    login.close()
    return username

def UserInfo(username,*fields):
    """Reads information from a file with users information
       Given a username and a list of fields, a list is returned with the
       value of those fields for the given user. If a field or the username
       do not exist, blank values are returned.
    """
    userfields = {'password':1, 'user':2, 'group':3, 'name':4}
    userinfo = ['','','','','']
    users_file = open(Config('account','passw_file'))
    for line in users_file.read().splitlines():
	field = line.split(':')
	if field[0] == username:
	   userinfo = field
	   break
    users_file.close()
    result = ()
    for field in fields:
	result += userinfo[userfields.get(field,1)],
    if len(result) == 1:
        return result[0]
    else:
        return result

def MakeCookie(path='',expires='',**fields):
    """Creates Cookies
       For each variable=value pair given, a Cookie is created. Two optional
       fields "path" and "expires" can be included in the Cookies.
    """
    import Cookie
    cookie = Cookie.SmartCookie()
    for key, value in fields.items():
	cookie[key] = value
	if path: cookie[key]['path'] = path
	if expires: cookie[key]['expires'] = expires
    return cookie.output()

def ReadCookie(name):
    """Reads the value of a Cookie
       The name of the Cookie to be read is passed as input argument.
    """
    import Cookie
    cookie = Cookie.SmartCookie(os.environ.get('HTTP_COOKIE',''))
    try:
	value = cookie[name].value
    except:
        value = ''
    return value

