<?php
/* vim: set sw=4 ts=4 noet foldmarker=@{,@} foldmethod=marker: */

# WARNING: This file is publically viewable on the web. Do not put private data here.

#######################################################################
# InitialiseSettings.php contains the specific configuration settings
# for each wiki in the WMF cluster.
#
# * Settings prefixed with 'wg' are standard MediaWiki configuration
#   variables.
# * Settings prefixed with 'wmg' are custom parameters handled by
#   CommonSettings.php.
#######################################################################

# Here are some umlauted vowels: öäü
# Here is a deck of cards: ♠♣♥♦
# If you do not see these characters, do not edit this file.

# Globals set in CommonSettings.php for use in settings values
global $wmfUdp2logDest, $wmfDatacenter, $wmfRealm, $wmfConfigDir, $wgConf;

$wgConf->settings = array(

# ############### Basic settings ###############

// For live conversion of old revisions:
'wgLegacyEncoding' => array(
	'default' => false,

	'enwiki' => 'windows-1252',
	'dawiki' => 'windows-1252',
	'svwiki' => 'windows-1252',
	'nlwiki' => 'windows-1252',

	'dawiktionary' => 'windows-1252',
	'svwiktionary' => 'windows-1252',
),

'wgCapitalLinks' => array(
	'default' => true,
	'jbowiki' => false,
	'wiktionary' => false,
),

'wmgEnableLandingCheck' => array(
	'default' => false,
	'donatewiki' => true,
	'testwiki' => true,
	'foundationwiki' => true,
),

'wmgEnableFundraiserLandingPage' => array(
	'default' => false,
	'testwiki' => true,
	'donatewiki' => true,
),

'wgCompressRevisions' => array(
	'default' => true,
),

'wgDisableCounters' => array(
	'default' => true,
),

'wgInterwikiMagic' => array(
	'default' => true,
	'metawiki' => false,
	'wikimedia' => false,
),

# wgLanguageCode @{
'wgLanguageCode' => array(
	'default' => '$lang',

	# Non-ISO language codes
	'crhwiki' => 'crh-latn',
	'nowiki' => 'nb',
	'simplewiki' => 'en',
	'simplewiktionary' => 'en',

	# Wikis at the wrong domain
	# FIXME: rename these wikis (bug 19986)
	'alswiki' => 'gsw',
	'alswiktionary' => 'gsw',
	'alswikibooks' => 'gsw',
	'alswikiquote' => 'gsw',
	'bat_smgwiki' => 'sgs',
	'be_x_oldwiki' => 'be-tarask',
	'fiu_vrowiki' => 'vro',
	'roa_rupwiki' => 'rup',
	'roa_rupwiktionary' => 'rup',
	'zh_classicalwiki' => 'lzh',
	'zh_min_nanwiki' => 'nan',
	'zh_min_nanwiktionary' => 'nan',
	'zh_min_nanwikibooks' => 'nan',
	'zh_min_nanwikiquote' => 'nan',
	'zh_yuewiki' => 'yue',

	# Chapter wikis (xxwikimedia)
	'arwikimedia' => 'es',
	'bdwikimedia' => 'bn',
	'bewikimedia' => 'en',
	'brwikimedia' => 'pt-br',
	'cawikimedia' => 'en-ca',
	'cowikimedia' => 'es',
	'dkwikimedia' => 'da',
	'ilwikimedia' => 'he',
	'mkwikimedia' => 'mk',
	'mxwikimedia' => 'es',
	'noboard_chapterswikimedia' => 'no',
	'nycwikimedia' => 'en',
	'nzwikimedia' => 'en',
	'pa_uswikimedia' => 'en',
	'rswikimedia' => 'sr',
	'sewikimedia' => 'sv',
	'uawikimedia' => 'uk',
	'ukwikimedia' => 'en-gb',
	'vewikimedia' => 'es',

	# Special wikis
	'special' => 'en', # default - overridden below by some wikis
	'advisorywiki' => 'en',
	'arbcom_dewiki' => 'de',
	'arbcom_enwiki' => 'en',
	'arbcom_fiwiki' => 'fi',
	'arbcom_nlwiki' => 'nl',
	'auditcomwiki' => 'en',
	'betawikiversity' => 'en',
	'chairwiki' => 'en',
	'chapcomwiki' => 'en',
	'checkuserwiki' => 'en',
	'collabwiki' => 'en',
	'donatewiki' => 'en',
	'execwiki' => 'en',
	'fdcwiki' => 'en',
	'grantswiki' => 'en',
	'iegcomwiki' => 'en',
	'incubatorwiki' => 'en', # mixed
	'legalteamwiki' => 'en',
	'officewiki' => 'en',
	'ombudsmenwiki' => 'en',
	'otrs_wikiwiki' => 'en',
	'qualitywiki' => 'en',
	'searchcomwiki' => 'en',
	'stewardwiki' => 'en',
	'strategywiki' => 'en',
	'tenwiki' => 'en',
	'transitionteamwiki' => 'en',
	'usabilitywiki' => 'en',
	'wikimania' => 'en',
	'wikimaniateamwiki' => 'en',
	'zerowiki' => 'en',
),
# @} end of wgLanguageCode

'wgLocalInterwikis' => array(
	'default' => array( '$lang' ),

	# Chinese projects seem to have some extras
	'+zhwiki' => array( 'zh-cn', 'zh-tw' ),
	'+zhwikibooks' => array( 'zh-cn', 'zh-tw' ),
	'+zhwikinews' => array( 'zh-cn', 'zh-tw' ),
	'+zhwikiquote' => array( 'zh-cn', 'zh-tw' ),
	'+zhwikisource' => array( 'zh-cn', 'zh-tw' ),
	'+zhwikivoyage' => array( 'zh-cn', 'zh-tw' ),
	'+zhwiktionary' => array( 'zh-cn', 'zh-tw' ),

	# Danish and Norwegian aliases (bug 4591)
	'+dawiki' => array( 'dk' ),
	'+dawikibooks' => array( 'dk' ),
	'+dawikiquote' => array( 'dk' ),
	'+dawikisource' => array( 'dk' ),
	'+dawiktionary' => array( 'dk' ),
	'+nowiki' => array( 'nb' ),
	'+nowikibooks' => array( 'nb' ),
	'+nowikinews' => array( 'nb' ),
	'+nowikiquote' => array( 'nb' ),
	'+nowikisource' => array( 'nb' ),
	'+nowiktionary' => array( 'nb' ),

	# Other individual wikis with additional local prefixes
	'+enwiki' => array( 'w' ),
	'+enwikibooks' => array( 'b' ),
	'+enwikinews' => array( 'n' ),
	'+enwikiquote' => array( 'q' ),
	'+enwikisource' => array( 's' ),
	'+enwikiversity' => array( 'v' ),
	'+enwikivoyage' => array( 'voy' ),
	'+enwiktionary' => array( 'wikt' ),

	# Chapter sites...
	'+wikimedia' => array( 'wm$lang' ),
	# ...with some stupid exceptions (still-open chapter wikis that have been
	# superseded by a non-WMF-hosted chapter site)
	'arwikimedia' => array( '$lang' ),
	'ilwikimedia' => array( '$lang' ),

	# Special wikis with local prefixes that don't match the DB name
	# (use + where the portion of the DB name before 'wiki' is also a valid
	# local interwiki)
	'betawikiversity' => array( 'betawikiversity' ),
	'+commonswiki' => array( 'c' ),
	'+foundationwiki' => array( 'wmf', 'wikimedia' ),
	'mediawikiwiki' => array( 'mw', 'mediawikiwiki' ),
	'+metawiki' => array( 'm', 'metawikipedia' ),
	'+outreachwiki' => array( 'outreachwiki' ),
	'sourceswiki' => array( 'mul', 'oldwikisource' ),
	'+wikidatawiki' => array( 'd' ),
	'wikimania2013wiki' => array( 'wm2013' ),
	'wikimania2014wiki' => array( 'wm2014' ),
	'wikimania2015wiki' => array( 'wm2015' ),
),

# wgLocaltimezone @{
'wgLocaltimezone' => array(
	'alswiki' => 'Europe/Berlin',
	'arbcom_dewiki' => 'Europe/Berlin',
	'arbcom_fiwiki' => 'Europe/Helsinki',
	'arbcom_nlwiki' => 'Europe/Berlin',
	'alswiktionary' => 'Europe/Berlin',
	'aswikisource' => 'Asia/Kolkata', // bug 43129
	'barwiki' => 'Europe/Berlin',
	'bat_smgwiki' => 'Europe/Vilnius',
	'be_x_oldwiki' => 'Europe/Minsk',
	'bewiki' => 'Europe/Minsk',
	'bewikisource' => 'Europe/Minsk',
	'bjnwiki' => 'Asia/Bangkok',
	'brwikisource' => 'Europe/Paris',
	'bswiki' => 'Europe/Berlin',
	'cawiki' => 'Europe/Berlin',
	'cawiktionary' => 'Europe/Berlin',
	'cawikibooks' => 'Europe/Berlin',
	'cawikiquote' => 'Europe/Berlin',
	'cawikisource' => 'Europe/Berlin',
	'cawikinews' => 'Europe/Berlin',
	'csbwiki' => 'Europe/Warsaw',
	'csbwiktionary' => 'Europe/Warsaw',
	'dawiki' => 'Europe/Berlin',
	'dawikibooks' => 'Europe/Berlin',
	'dewiki' => 'Europe/Berlin',
	'dewikinews' => 'Europe/Berlin',
	'dewiktionary' => 'Europe/Berlin',
	'dewikibooks' => 'Europe/Berlin',
	'dewikiquote' => 'Europe/Berlin',
	'dewikisource' => 'Europe/Berlin',
	'dewikivoyage' => 'Europe/Berlin', // bug 41992
	'dewikiversity' => 'Europe/Berlin',
	'dsbwiki' => 'Europe/Berlin',
	'dvwiki' => 'Indian/Maldives', // bug 46351
	'dvwiktionary' => 'Indian/Maldives', // bug 46351
	'elwikinews' => 'Europe/Athens',
	'elwikivoyage' => 'Europe/Athens',
	'eowikisource' => 'UTC',
	'etwiki' => 'Europe/Tallinn',
	'etwikibooks' => 'Europe/Tallinn',
	'etwikimedia' => 'Europe/Tallinn',
	'etwikiquote' => 'Europe/Tallinn',
	'etwikisource' => 'Europe/Tallinn',
	'etwiktionary' => 'Europe/Tallinn',
	'fawikinews' => 'Asia/Tehran',
	'fiwiki' => 'Europe/Helsinki',
	'fiwikimedia' => 'Europe/Helsinki',
	'frrwiki' => 'Europe/Berlin',
	'frwiki' => 'Europe/Paris',
	'frwikibooks' => 'Europe/Paris',
	'frwikiquote' => 'Europe/Paris',
	'fywiki' => 'Europe/Berlin',
	'gagwiki' => 'Europe/Istanbul',
	'guwiki' => 'Asia/Kolkata',
	'guwikisource' => 'Asia/Kolkata',
	'hewiki' => 'Asia/Tel_Aviv',
	'hewikibooks' => 'Asia/Tel_Aviv',
	'hewikiquote' => 'Asia/Tel_Aviv',
	'hewikisource' => 'Asia/Tel_Aviv',
	'hewikivoyage' => 'Asia/Tel_Aviv',
	'hewiktionary' => 'Asia/Tel_Aviv',
	'hewikinews' => 'Asia/Tel_Aviv',
	'ilwikimedia' => 'Asia/Tel_Aviv',
	'itwikivoyage' => 'Europe/Rome', // bug 41992
	'hrwiki' => 'Europe/Berlin',
	'hrwikibooks' => 'Europe/Zagreb',
	'hrwikiquote' => 'Europe/Berlin',
	'hrwikisource' => 'Europe/Zagreb',
	'hrwiktionary' => 'Europe/Berlin',
	'hsbwiki' => 'Europe/Berlin',
	'huwiki' => 'Europe/Berlin',
	'huwikibooks' => 'Europe/Berlin',
	'huwikinews' => 'Europe/Berlin',
	'huwikiquote' => 'Europe/Berlin',
	'huwikisource' => 'Europe/Berlin',
	'huwiktionary' => 'Europe/Berlin',
	'itwiki' => 'Europe/Berlin',
	'itwikinews' => 'Europe/Berlin',
	'itwikiversity' => 'Europe/Berlin',
	'itwikiquote' => 'Europe/Berlin',
	'itwikibooks' => 'Europe/Berlin',
	'itwikisource' => 'Europe/Berlin',
	'itwiktionary' => 'Europe/Berlin',
	'kbdwiki' => 'Europe/Moscow',
	'kkwiki' => 'Asia/Almaty',
	'kkwiktionary' => 'Asia/Almaty',
	'kkwikibooks' => 'Asia/Almaty',
	'kkwikiquote' => 'Asia/Almaty',
	'koiwiki' => 'Asia/Yekaterinburg',
	'kowiki' => 'Asia/Seoul',
	'kowikibooks' => 'Asia/Seoul', // bug 49639
	'kowikinews' => 'Asia/Seoul',
	'kowikiquote' => 'Asia/Seoul',
	'kowikisource' => 'Asia/Seoul',
	'kowikiversity' => 'Asia/Seoul',
	'kowiktionary' => 'Asia/Seoul',
	'kshwiki' => 'Europe/Berlin',
	'lezwiki' => 'Europe/Moscow',
	'liwiki' => 'Europe/Berlin',
	'ltgwiki' => 'Europe/Riga',
	'ltwiki' => 'Europe/Vilnius',
	'lmowiki' => 'Europe/Rome',
	'lvwiki' => 'Europe/Riga', // bug 43592
	'mkwiki' => 'Europe/Berlin',
	'mkwikibooks' => 'Europe/Berlin',
	'mkwikimedia' => 'Europe/Berlin',
	'mkwikisource' => 'Europe/Berlin',
	'mkwiktionary' => 'Europe/Berlin',
	'minwiki' => 'Asia/Jakarta',
	'mrjwiki' => 'Europe/Moscow',
	'mrwiki' => 'Asia/Kolkata',
	'mrwikisource' => 'Asia/Kolkata',
	'ndswiki' => 'Europe/Berlin',
	'ndswiktionary' => 'Europe/Berlin',
	'ndswikibooks' => 'Europe/Berlin',
	'ndswikiquote' => 'Europe/Berlin',
	'nds_nlwiki' => 'Europe/Berlin',
	'nlwiki' => 'Europe/Berlin',
	'nlwikimedia' => 'Europe/Berlin',
	'nlwikibooks' => 'Europe/Berlin',
	'nlwikiquote' => 'Europe/Berlin',
	'nlwikisource' => 'Europe/Berlin',
	'nlwikivoyage' => 'Europe/Amsterdam', // bug 41992
	'nlwiktionary' => 'Europe/Berlin',
	'nnwiki' => 'Europe/Berlin',
	'nnwikiquote' => 'Europe/Berlin',
	'nnwiktionary' => 'Europe/Berlin',
	'nowikimedia' => 'Europe/Berlin',
	'nowiki' => 'Europe/Berlin',
	'nowikibooks' => 'Europe/Berlin',
	'nowikiquote' => 'Europe/Berlin',
	'nowiktionary' => 'Europe/Berlin',
	'nowikinews' => 'Europe/Berlin',
	'nowikisource' => 'Europe/Berlin',
	'nsowiki' => 'Africa/Johannesburg',
	'pdcwiki' => 'America/New_York',
	'pflwiki' => 'Europe/Berlin',
	'plwiki' => 'Europe/Warsaw',
	'plwikisource' => 'Europe/Warsaw',
	'plwiktionary' => 'Europe/Warsaw',
	'plwikiquote' => 'Europe/Warsaw',
	'plwikibooks' => 'Europe/Warsaw',
	'plwikinews' => 'Europe/Warsaw',
	'plwikimedia' => 'Europe/Warsaw',
	'plwikivoyage' => 'Europe/Warsaw',
	'pnbwiki' => 'Asia/Karachi',
	'pnbwiktionary' => 'Asia/Karachi',
	'rmwiki' => 'Europe/Berlin',
	'rowiki' => 'Europe/Chisinau',
	'rowikisource' => 'Europe/Chisinau',
	'rowikivoyage' => 'Europe/Bucharest',
	'ruwikivoyage' => 'Europe/Moscow', // bug 41992
	'ruewiki' => 'Europe/Berlin',
	'sawikiquote' => 'Asia/Kolkata',
	'sahwikisource' => 'Asia/Yakutsk',
	'scwiki' => 'Europe/Berlin',
	'scnwiki' => 'Europe/Berlin',
	'sewikimedia' => 'Europe/Berlin',
	'shwiki' => 'Europe/Berlin',
	'slwiki' => 'Europe/Berlin',
	'slwikiquote' => 'Europe/Berlin',
	'slwikiversity' => 'Europe/Ljubljana',
	'sqwiki' => 'Europe/Berlin',
	'sqwikinews' => 'Europe/Berlin',
	'srwiki' => 'Europe/Berlin',
	'srwikibooks' => 'Europe/Berlin',
	'srwikiquote' => 'Europe/Berlin',
	'srwiktionary' => 'Europe/Berlin',
	'srwikisource' => 'Europe/Berlin',
	'svwiki' => 'Europe/Berlin',
	'svwiktionary' => 'Europe/Berlin',
	'svwikiquote' => 'Europe/Berlin',
	'svwikibooks' => 'Europe/Berlin',
	'svwikisource' => 'Europe/Berlin',
	'svwikinews' => 'Europe/Berlin',
	'svwikiversity' => 'Europe/Berlin',
	'svwikivoyage' => 'Europe/Stockholm', // bug 41992
	'szlwiki' => 'Europe/Warsaw',
	'thwiki' => 'Asia/Bangkok',
	'thwikibooks' => 'Asia/Bangkok',
	'thwikisource' => 'Asia/Bangkok',
	'thwiktionary' => 'Asia/Bangkok',
	'thwikiquote' => 'Asia/Bangkok',
	'trwikimedia' => 'Europe/Istanbul',
	'tyvwiki' => 'Asia/Krasnoyarsk',
	'ukwikivoyage' => 'Europe/Kiev',
	'vecwiki' => 'Europe/Berlin',
	'vecwikisource' => 'Europe/Berlin',
	'vecwiktionary' => 'Europe/Brussels',
	'vepwiki' => 'Europe/Moscow',
	'viwikivoyage' => 'Asia/Ho_Chi_Minh',
	'xmfwiki' => 'Asia/Tbilisi',
	'zhwikivoyage' => 'Asia/Shanghai', // bug 59077
),
# @} end of wgLocaltimezone

# wgLogo @{
// $stdlogo gives the path to the local copy of Wiki.png on the relevant wiki,
// e.g. for simplewiktionary: '//upload.wikimedia.org/wiktionary/simple/b/bc/Wiki.png'
'wgLogo' => array(
	// Projects
	'default' => '//upload.wikimedia.org/wikipedia/commons/d/d6/Wikipedia-logo-v2-en.png',
	'wikibooks' => '//upload.wikimedia.org/wikipedia/commons/4/49/Wikibooks-logo-en-noslogan.png',
	'wikidata' => '//upload.wikimedia.org/wikipedia/commons/e/e4/Wikidata-logo-en-135px.png',
	'wikinews' => '$stdlogo',
	'wikiquote' => '//upload.wikimedia.org/wikiquote/en/b/bc/Wiki.png',
	'wikisource' => '//upload.wikimedia.org/wikipedia/sources/b/bc/Wiki.png',
	'wikiversity' => '$stdlogo',
	'wiktionary' => '//upload.wikimedia.org/wikipedia/commons/thumb/e/ec/Wiktionary-logo.svg/135px-Wiktionary-logo.svg.png',
	'wikivoyage' => '//upload.wikimedia.org/wikipedia/commons/2/2e/Wikivoyage-Logo-v3-small-en.png', // bug 53653

	// NOTE: This list is ordered by *project family* for ease of maintenance.
	// The order is: Wikipedia, Wiktionary, Wikiquote, Wikibooks, Wikinews, Wikisource,
	// Wikiversity, Wikivoyage, chapter wikis, and finally special wikis

	// Wikipedia
	'abwiki' => '//upload.wikimedia.org/wikipedia/commons/5/5a/Wikipedia-logo-v2-ab.png', // bug 46589
	'acewiki' => '$stdlogo',
	'afwiki' => '//upload.wikimedia.org/wikipedia/commons/d/d8/Wikipedia-logo-v2-af.png',
	'akwiki' => '//upload.wikimedia.org/wikipedia/commons/9/9e/Wikipedia-logo-v2-ak.png', // bug 46589
	'alswiki' => '//upload.wikimedia.org/wikipedia/commons/2/26/Wikipedia-logo-v2-als.png',
	'amwiki' => '//upload.wikimedia.org/wikipedia/commons/9/98/Wikipedia-logo-v2-am.png', // bug 40285
	'anwiki' => '$stdlogo',
	'angwiki' => '//upload.wikimedia.org/wikipedia/commons/a/a0/Wikipedia-logo-v2-ang.png', // bug 49125
	'arwiki' => '//upload.wikimedia.org/wikipedia/commons/1/1e/Wikipedia-logo-v2-ar.png',
	'arcwiki' => '$stdlogo',
	'arzwiki' => '//upload.wikimedia.org/wikipedia/commons/3/3b/Wikipedia-logo-v2-arz.png',
	'aswiki' => '$stdlogo',
	'astwiki' => '//upload.wikimedia.org/wikipedia/commons/f/fd/Wikipedia-logo-v2-ast.png', // bug 40285
	'avwiki' => '//upload.wikimedia.org/wikipedia/commons/4/49/Wikipedia-logo-v2-av.png', // bug 46589
	'aywiki' => '$stdlogo',
	'azwiki' => '//upload.wikimedia.org/wikipedia/commons/f/fa/Wikipedia-logo-v2-az.png', // bug 48397
	'bawiki' => '$stdlogo',
	'barwiki' => '//upload.wikimedia.org/wikipedia/commons/d/dc/Wikipedia-logo-v2-bar.png', // bug 40285
	'bat_smgwiki' => '//upload.wikimedia.org/wikipedia/commons/6/67/Wikipedia-logo-v2-bat-smg.png', // bug 46589
	'bclwiki' => '//upload.wikimedia.org/wikipedia/commons/4/4b/Wikipedia-logo-v2-bcl.png',
	'bewiki' => '$stdlogo',
	'be_x_oldwiki' => '//upload.wikimedia.org/wikipedia/commons/0/08/Wikipedia-logo-v2-be-x-old.png',
	'bgwiki' => '//upload.wikimedia.org/wikipedia/commons/c/cf/Wikipedia-logo-v2-bg.png',
	'bhwiki' => '//upload.wikimedia.org/wikipedia/commons/9/9c/Wikipedia-logo-v2-bh.png', // bug 48397
	'biwiki' => '//upload.wikimedia.org/wikipedia/commons/8/84/Wikipedia-logo-v2-bi.png', // bug 49125
	'bjnwiki' => '//upload.wikimedia.org/wikipedia/commons/5/5a/Wikipedia-logo-v2-bjn.png', // bug 46564
	'bmwiki' => '//upload.wikimedia.org/wikipedia/commons/2/27/Wikipedia-logo-v2-bm.png', // bug 40285
	'bnwiki' => '//upload.wikimedia.org/wikipedia/commons/6/6f/Wikipedia-logo-v2-bn.png',
	'bowiki' => '//upload.wikimedia.org/wikipedia/commons/4/41/Wikipedia-logo-v2-bo.png', // bug 48397
	'bpywiki' => '//upload.wikimedia.org/wikipedia/commons/d/dd/Wikipedia-logo-v2-bpy.png', // bug 40285
	'brwiki' => '//upload.wikimedia.org/wikipedia/commons/1/15/Wikipedia-logo-v2-br.png',
	'bswiki' => '//upload.wikimedia.org/wikipedia/commons/d/dd/Wikipedia-logo-v2-bs.png',
	'bugwiki' => '//upload.wikimedia.org/wikipedia/commons/5/59/Wikipedia-logo-v2-bug.png',
	'bxrwiki' => '$stdlogo',
	'cawiki' => '//upload.wikimedia.org/wikipedia/commons/3/34/Wikipedia-logo-v2-ca.png',
	'cbk_zamwiki' => '//upload.wikimedia.org/wikipedia/commons/1/1d/Wikipedia-logo-v2-cbk-zam.png', // bug 44974
	'cdowiki' => '//upload.wikimedia.org/wikipedia/commons/0/08/Wikipedia-logo-v2-cdo.png', // bug 40285
	'cebwiki' => '//upload.wikimedia.org/wikipedia/commons/5/56/Wikipedia-logo-v2-ceb.png', // bug 40285
	'cewiki' => '$stdlogo',
	'chwiki' => '//upload.wikimedia.org/wikipedia/commons/b/bc/Wikipedia-logo-v2-ch.png', // bug 40285
	'chrwiki' => '//upload.wikimedia.org/wikipedia/commons/9/98/Wikipedia-logo-chr.png', // bug 37327
	'chywiki' => '//upload.wikimedia.org/wikipedia/commons/8/8d/Wikipedia-logo-v2-chy.png', // bug 46589
	'ckbwiki' => '$stdlogo',
	'cowiki' => '//upload.wikimedia.org/wikipedia/commons/6/6f/Wikipedia-logo-v2-co.png', // bug 40285
	'crhwiki' => '$stdlogo',
	'csbwiki' => '//upload.wikimedia.org/wikipedia/commons/7/71/Wikipedia-logo-v2-csb.png', // bug 40285
	'cswiki' => '$stdlogo',
	'cuwiki' => '$stdlogo',
	'cvwiki' => '$stdlogo',
	'cywiki' => '//upload.wikimedia.org/wikipedia/commons/1/13/Wikipedia-logo-v2-cy.png',
	'dawiki' => '//upload.wikimedia.org/wikipedia/commons/3/3e/Wikipedia-logo-v2-da.png',
	'dewiki' => '//upload.wikimedia.org/wikipedia/commons/e/ec/Wikipedia-logo-v2-de.png',
	'diqwiki' => '//upload.wikimedia.org/wikipedia/commons/e/e1/Wikipedia-logo-v2-diq.png',
	'dsbwiki' => '//upload.wikimedia.org/wikipedia/commons/6/6b/Wikipedia-logo-v2-dsb.png',
	'dvwiki' => '//upload.wikimedia.org/wikipedia/commons/9/9c/Wikipedia-logo-v2-dv.png', // bug 40285
	'dzwiki' => '//upload.wikimedia.org/wikipedia/commons/9/9d/Wikipedia-logo-v2-dz.png', // bug 48397
	'eewiki' => '//upload.wikimedia.org/wikipedia/commons/c/ce/Wikipedia-logo-v2-ee.png', // bug 48397
	'elwiki' => '//upload.wikimedia.org/wikipedia/commons/d/df/Wikipedia-logo-v2-el.png',
	'enwiki' => '$stdlogo',
	'eowiki' => '$stdlogo',
	'eswiki' => '//upload.wikimedia.org/wikipedia/commons/8/8c/Wikipedia-logo-v2-es.png',
	'etwiki' => '//upload.wikimedia.org/wikipedia/commons/4/41/Wikipedia-logo-v2-et.png',
	'euwiki' => '//upload.wikimedia.org/wikipedia/commons/0/01/Wikipedia-logo-v2-eu.png',
	'extwiki' => '//upload.wikimedia.org/wikipedia/commons/e/e2/Wikipedia-logo-v2-ext.png', // bug 46589
	'fawiki' => '$stdlogo',
	'ffwiki' => '$stdlogo',
	'fiwiki' => '//upload.wikimedia.org/wikipedia/commons/7/7f/Wikipedia-logo-v2-fi.png',
	'fiu_vrowiki' => '//upload.wikimedia.org/wikipedia/commons/0/0f/Wikipedia-logo-v2-fiu-vro.png', // bug 46589
	'fowiki' => '//upload.wikimedia.org/wikipedia/commons/7/77/Wikipedia-logo-v2-fo.png', // bug 40285
	'frwiki' => '//upload.wikimedia.org/wikipedia/commons/5/5a/Wikipedia-logo-v2-fr.png',
	'frpwiki' => '//upload.wikimedia.org/wikipedia/commons/a/ab/Wikipedia-logo-v2-frp.png',
	'frrwiki' => '$stdlogo',
	'furwiki' => '//upload.wikimedia.org/wikipedia/commons/0/09/Wikipedia-logo-v2-fur.png', // bug 46589
	'fywiki' => '//upload.wikimedia.org/wikipedia/commons/d/da/Wikipedia-logo-v2-fy.png', // bug 40285
	'gawiki' => '$stdlogo',
	'gagwiki' => '//upload.wikimedia.org/wikipedia/commons/4/4e/Wikipedia-logo-v2-gag.png',
	'ganwiki' => '//upload.wikimedia.org/wikipedia/commons/8/80/Wikipedia-logo-v2-gan.png', // bug 44974
	'gdwiki' => '$stdlogo',
	'glwiki' => '//upload.wikimedia.org/wikipedia/gl/b/bc/Wiki.png',
	'glkwiki' => '//upload.wikimedia.org/wikipedia/commons/6/6a/Wikipedia-logo-v2-glk.png', // bug 48397
	'gnwiki' => '//upload.wikimedia.org/wikipedia/commons/6/6d/Wikipedia-logo-v2-gn.png', // bug 49125
	'gotwiki' => '$stdlogo',
	'guwiki' => '$stdlogo',
	'gvwiki' => '//upload.wikimedia.org/wikipedia/commons/c/ca/Wikipedia-logo-v2-gv.png', // bug 46589
	'hawiki' => '//upload.wikimedia.org/wikipedia/commons/e/e3/Wikipedia-logo-v2-ha.png', // bug 46589
	'hakwiki' => '//upload.wikimedia.org/wikipedia/commons/4/43/Wikipedia-logo-v2-hak.png', // bug 46589
	'hawwiki' => '//upload.wikimedia.org/wikipedia/commons/d/d4/Wikipedia-logo-v2-haw.png', // bug 40285
	'hewiki' => '//upload.wikimedia.org/wikipedia/he/b/bc/Wiki.png',
	'hiwiki' => '$stdlogo',
	'hifwiki' => '$stdlogo', // bug 27361
	'hrwiki' => '$stdlogo',
	'hsbwiki' => '//upload.wikimedia.org/wikipedia/commons/e/e7/Wikipedia-logo-v2-hsb.png',
	'htwiki' => '//upload.wikimedia.org/wikipedia/commons/4/49/Wikipedia-logo-v2-ht.png', // bug 40285
	'huwiki' => '//upload.wikimedia.org/wikipedia/commons/d/d7/Wikipedia-logo-v2-hu.png',
	'hywiki' => '$stdlogo',
	'iawiki' => '//upload.wikimedia.org/wikipedia/commons/6/68/Wikipedia-logo-v2-ia.png',
	'idwiki' => '//upload.wikimedia.org/wikipedia/id/f/f3/Wikipedia-logo-v2-id.png',
	'iewiki' => '//upload.wikimedia.org/wikipedia/commons/d/d8/Wikipedia-logo-v2-ie.png', // bug 49125
	'igwiki' => '//upload.wikimedia.org/wikipedia/commons/2/2a/Wikipedia-logo-v2-ig.png', // bug 46589
	'ikwiki' => '//upload.wikimedia.org/wikipedia/commons/e/ef/Wikipedia-logo-v2-ik.png', // bug 46589
	'ilowiki' => '//upload.wikimedia.org/wikipedia/commons/5/57/Wikipedia-logo-v2-ilo.png', // bug 40285
	'iowiki' => '//upload.wikimedia.org/wikipedia/commons/9/95/Wikipedia-logo-v2-io.png', // bug 46589
	'iswiki' => '//upload.wikimedia.org/wikipedia/commons/c/c4/Wikipedia-logo-v2-is.png', // bug 40285
	'itwiki' => '//upload.wikimedia.org/wikipedia/commons/c/c5/Wikipedia-logo-v2-it.png',
	'iuwiki' => '//upload.wikimedia.org/wikipedia/commons/e/e4/Wikipedia-logo-v2-iu.png', // bug 40285
	'jawiki' => '//upload.wikimedia.org/wikipedia/commons/a/ad/Wikipedia-logo-v2-ja.png',
	'jbowiki' => '//upload.wikimedia.org/wikipedia/commons/e/ec/Wikipedia-logo-v2-jbo.png', // bug 46589
	'jvwiki' => '//upload.wikimedia.org/wikipedia/commons/c/cc/Wikipedia-logo-v2-jv.png', // bug 40285
	'kaawiki' => '//upload.wikimedia.org/wikipedia/commons/8/8a/Wikipedia-logo-v2-kaa.png', // bug 46589
	'kabwiki' => '//upload.wikimedia.org/wikipedia/commons/f/f7/Wikipedia-logo-v2-kab.png', // bug 44974
	'kawiki' => '//upload.wikimedia.org/wikipedia/commons/5/52/Wikipedia-logo-v2-ka.png',
	'kbdwiki' => '//upload.wikimedia.org/wikipedia/commons/b/b0/Wikipedia-logo-v2-kbd.png',
	'kiwiki' => '//upload.wikimedia.org/wikipedia/commons/1/1a/Wikipedia-logo-v2-ki.png', // bug 48397
	'kkwiki' => '$stdlogo',
	'klwiki' => '$stdlogo',
	'kmwiki' => '$stdlogo',
	'knwiki' => '//upload.wikimedia.org/wikipedia/commons/b/bf/Wikipedia-logo-v2-kn.png', // bug 46589, bug 27657
	'kowiki' => '$stdlogo',
	'koiwiki' => '//upload.wikimedia.org/wikipedia/commons/b/b4/Wikipedia-logo-v2-koi.png',
	'krcwiki' => '$stdlogo',
	'kswiki' => '$stdlogo',
	'kshwiki' => '//upload.wikimedia.org/wikipedia/commons/7/75/Wikipedia-logo-v2-ksh.png',
	'kuwiki' => '//upload.wikimedia.org/wikipedia/commons/e/e3/Wikipedia-logo-v2-ku.png',
	'kvwiki' => '//upload.wikimedia.org/wikipedia/commons/a/ae/Wikipedia-logo-v2-kv.png', // bug 40285
	'kwwiki' => '$stdlogo',
	'kywiki' => '//upload.wikimedia.org/wikipedia/commons/3/3c/Wikipedia-logo-v2-ky.png', // bug 46589
	'lawiki' => '$stdlogo',
	'labswiki' => "https://wikitech.wikimedia.org/w/images/thumb/6/60/Wikimedia_labs_logo.svg/120px-Wikimedia_labs_logo.svg.png",
	'ladwiki' => '$stdlogo',
	'lbwiki' => '//upload.wikimedia.org/wikipedia/commons/9/9f/Wikipedia-logo-v2-lb.png',
	'lbewiki' => '//upload.wikimedia.org/wikipedia/commons/9/95/Wikipedia-logo-v2-lbe.png', // bug 40285
	'lezwiki' => '//upload.wikimedia.org/wikipedia/commons/3/3d/Wikipedia-logo-v2-lez.png',
	'lgwiki' => '//upload.wikimedia.org/wikipedia/commons/e/ea/Wikipedia-logo-v2-lg.png', // bug 44974
	'lijwiki' => '//upload.wikimedia.org/wikipedia/commons/0/0a/Wikipedia-logo-v2-lij.png', // bug 49125
	'liwiki' => '$stdlogo',
	'lmowiki' => '//upload.wikimedia.org/wikipedia/commons/f/ff/Wikipedia-logo-v2-lmo.png', // bug 40285
	'lnwiki' => '//upload.wikimedia.org/wikipedia/commons/a/aa/Wikipedia-logo-v2-ln.png', // bug 46589
	'lowiki' => '//upload.wikimedia.org/wikipedia/commons/f/fe/Wikipedia-logo-v2-lo.png', // bug 48397
	'ltwiki' => '//upload.wikimedia.org/wikipedia/commons/1/1c/Wikipedia-logo-v2-lt.png', // bug 46589
	'ltgwiki' => '//upload.wikimedia.org/wikipedia/commons/7/77/Wikipedia-logo-v2-ltg.png',
	'lvwiki' => '$stdlogo',
	'map_bmswiki' => '$stdlogo',
	'mdfwiki' => '//upload.wikimedia.org/wikipedia/commons/b/b2/Wikipedia-logo-v2-mdf.png', // bug 46589
	'mgwiki' => '//upload.wikimedia.org/wikipedia/commons/d/d6/Wikipedia-logo-v2-mg.png', // bug 46589
	'mhrwiki' => '//upload.wikimedia.org/wikipedia/commons/f/ff/Wikipedia-logo-v2-mhr.png', // bug 46589
	'miwiki' => '//upload.wikimedia.org/wikipedia/commons/b/b6/Wikipedia-logo-v2-mi.png', // bug 40285
	'minwiki' => '//upload.wikimedia.org/wikipedia/id/f/f3/Wikipedia-logo-v2-id.png', // bug 48397
	'mkwiki' => '//upload.wikimedia.org/wikipedia/commons/a/a6/Wikipedia-logo-v2-mk.png',
	'mlwiki' => '//upload.wikimedia.org/wikipedia/commons/e/e2/Wikipedia-logo-v2-ml.png',
	'mnwiki' => '//upload.wikimedia.org/wikipedia/commons/b/bb/Wikipedia-logo-v2-mn.png', // bug 46589
	'mrwiki' => '$stdlogo',
	'mrjwiki' => '//upload.wikimedia.org/wikipedia/commons/b/b6/Wikipedia-logo-v2-mrj.png',
	'mswiki' => '//upload.wikimedia.org/wikipedia/commons/e/ee/Wikipedia-logo-v2-ms.png',
	'mtwiki' => '//upload.wikimedia.org/wikipedia/commons/9/9b/Wikipedia-logo-v2-mt.png',
	'mwlwiki' => '//upload.wikimedia.org/wikipedia/commons/1/10/Wikipedia-logo-v2-mwl.png', // bug 40285
	'mywiki' => '$stdlogo',
	'myvwiki' => '//upload.wikimedia.org/wikipedia/commons/e/ef/Wikipedia-logo-v2-myv.png', // bug 48397
	'mznwiki' => '$stdlogo',
	'nawiki' => '//upload.wikimedia.org/wikipedia/commons/4/46/Wikipedia-logo-v2-na.png', // bug 40285
	'nahwiki' => '$stdlogo',
	'napwiki' => '//upload.wikimedia.org/wikipedia/commons/c/cb/Wikipedia-logo-v2-nap.png', // bug 40285
	'ndswiki' => '//upload.wikimedia.org/wikipedia/commons/c/cf/Wikipedia-logo-v2-nds.png', // bug 49125
	'nds_nlwiki' => '$stdlogo',
	'newiki' => '$stdlogo',
	'newwiki' => '//upload.wikimedia.org/wikipedia/commons/1/18/Wikipedia-logo-v2-new.png', // bug 40285
	'nlwiki' => '//upload.wikimedia.org/wikipedia/commons/a/ae/Wikipedia-logo-v2-nl.png',
	'nnwiki' => '//upload.wikimedia.org/wikipedia/commons/4/41/Wikipedia-logo-v2-nn.png',
	'nowiki' => '$stdlogo',
	'novwiki' => '//upload.wikimedia.org/wikipedia/commons/a/ab/Wikipedia-logo-v2-nov.png', // bug 44974
	'nrmwiki' => '//upload.wikimedia.org/wikipedia/commons/6/6c/Wikipedia-logo-v2-nrm.png', // bug 49125
	'nsowiki' => '//upload.wikimedia.org/wikipedia/commons/0/00/Wikipedia-logo-v2-tn.png',
	'nvwiki' => '//upload.wikimedia.org/wikipedia/commons/3/3e/Wikipedia-logo-v2-nv.png', // bug 40285
	'ocwiki' => '//upload.wikimedia.org/wikipedia/commons/7/74/Wikipedia-logo-v2-oc.png',
	'omwiki' => '//upload.wikimedia.org/wikipedia/commons/3/37/Wikipedia-logo-v2-om.png', // bug 44974
	'orwiki' => '//upload.wikimedia.org/wikipedia/commons/thumb/9/98/Wikipedia-logo-v2-or.svg/132px-Wikipedia-logo-v2-or.svg.png', // bug 27704
	'oswiki' => '$stdlogo',
	'papwiki' => '//upload.wikimedia.org/wikipedia/commons/9/9b/Wikipedia-logo-v2-pap.png', // bug 49125
	'pawiki' => '$stdlogo',
	'pagwiki' => '//upload.wikimedia.org/wikipedia/commons/f/ff/Wikipedia-logo-v2-pag.png', // bug 44974
	'pamwiki' => '//upload.wikimedia.org/wikipedia/commons/7/7d/Wikipedia-logo-v2-pam.png', // bug 40285
	'pcdwiki' => '$stdlogo',
	'pdcwiki' => '//upload.wikimedia.org/wikipedia/commons/5/55/Wikipedia-logo-v2-pdc.png',
	'pflwiki' => '//upload.wikimedia.org/wikipedia/commons/5/50/Wikipedia-logo-v2-pfl.png',
	'pihwiki' => '//upload.wikimedia.org/wikipedia/commons/7/72/Wikipedia-logo-v2-pih.png', // bug 40285
	'piwiki' => '//upload.wikimedia.org/wikipedia/commons/9/91/Wikipedia-logo-v2-pi.png',
	'plwiki' => '//upload.wikimedia.org/wikipedia/commons/a/ad/Wikipedia-logo-v2-pl.png',
	'pmswiki' => '//upload.wikimedia.org/wikipedia/commons/b/b8/Wikipedia-logo-v2-pms.png',
	'pnbwiki' => '//upload.wikimedia.org/wikipedia/commons/9/9d/Wikipedia-logo-v2-pnb.png', // bug 48397
	'pntwiki' => '//upload.wikimedia.org/wikipedia/commons/f/f3/Wikipedia-logo-v2-pnt.png', // bug 49125
	'pswiki' => '//upload.wikimedia.org/wikipedia/commons/8/84/Wikipedia-logo-v2-ps.png', // bug 48397
	'ptwiki' => '//upload.wikimedia.org/wikipedia/commons/c/c3/Wikipedia-logo-v2-pt.png',
	'quwiki' => '$stdlogo',
	'rmwiki' => '//upload.wikimedia.org/wikipedia/commons/e/e2/Wikipedia-logo-v2-rm.png', // bug 46589
	'rmywiki' => '//upload.wikimedia.org/wikipedia/commons/6/63/Wikipedia-logo-v2-rmy.png', // bug 46589
	'roa_rupwiki' => '//upload.wikimedia.org/wikipedia/commons/d/d9/Wikipedia-logo-v2-roa-rup.png', // bug 40285
	'roa_tarawiki' => '//upload.wikimedia.org/wikipedia/commons/3/3b/Wikipedia-logo-v2-roa-tara.png',
	'rowiki' => '$stdlogo',
	'ruwiki' => '//upload.wikimedia.org/wikipedia/commons/f/f6/Wikipedia-logo-v2-ru.png',
	'ru_sibwiki' => '$stdlogo',
	'ruewiki' => '//upload.wikimedia.org/wikipedia/commons/e/e0/Wikipedia-logo-v2-rue.png',
	'sahwiki' => '//upload.wikimedia.org/wikipedia/commons/d/d0/Wikipedia-logo-v2-sah.png',
	'sawiki' => '//upload.wikimedia.org/wikipedia/commons/6/63/Wikipedia-logo-v2-sa.png', // bug 48397
	'scwiki' => '$stdlogo',
	'scnwiki' => '//upload.wikimedia.org/wikipedia/commons/7/77/Wikipedia-logo-v2-scn.png', // bug 40285
	'scowiki' => '//upload.wikimedia.org/wikipedia/commons/6/60/Wikipedia-logo-v2-sco.png', // bug 49125
	'sdwiki' => '//upload.wikimedia.org/wikipedia/commons/7/7c/Wikipedia-logo-v2-sd.png', // bug 48397
	'sewiki' => '//upload.wikimedia.org/wikipedia/commons/thumb/1/1a/Wikipedia-logo-v2-se-example-4.svg/135px-Wikipedia-logo-v2-se-example-4.svg.png',
	'sgwiki' => '//upload.wikimedia.org/wikipedia/commons/0/0b/Wikipedia-logo-v2-sg.png', // bug 49125
	'shwiki' => '//upload.wikimedia.org/wikipedia/commons/9/92/Wikipedia-logo-v2-sh.png', // bug 49125
	'siwiki' => '$stdlogo',
	'simplewiki' => '$stdlogo',
	'skwiki' => '//upload.wikimedia.org/wikipedia/commons/c/cb/Wikipedia-logo-v2-sk.png',
	'slwiki' => '//upload.wikimedia.org/wikipedia/commons/d/dc/Wikipedia-logo-v2-sl.png',
	'smwiki' => '//upload.wikimedia.org/wikipedia/commons/e/e1/Wikipedia-logo-v2-sm.png', // bug 49125
	'snwiki' => '//upload.wikimedia.org/wikipedia/commons/a/a9/Wikipedia-logo-v2-sn.png', // bug 46589
	'sowiki' => '//upload.wikimedia.org/wikipedia/commons/b/bb/Wikipedia-logo-v2-so.png', // bug 40285
	'sqwiki' => '//upload.wikimedia.org/wikipedia/commons/7/76/Wikipedia-logo-v2-sq.png',
	'srwiki' => '$stdlogo',
	'srnwiki' => '//upload.wikimedia.org/wikipedia/commons/c/cf/Wikipedia-logo-v2-srn.png', // bug 44974
	'stwiki' => '//upload.wikimedia.org/wikipedia/commons/8/85/Wikipedia-logo-v2-st.png', // bug 46589
	'sswiki' => '//upload.wikimedia.org/wikipedia/commons/4/4b/Wikipedia-logo-v2-ss.png', // bug 44974
	'stqwiki' => '//upload.wikimedia.org/wikipedia/commons/8/8f/Wikipedia-logo-v2-stq.png', // bug 40285
	'suwiki' => '//upload.wikimedia.org/wikipedia/commons/2/21/Wikipedia-logo-v2-su.png', // bug 40285
	'svwiki' => '//upload.wikimedia.org/wikipedia/commons/d/d9/Wikipedia-logo-v2-sv.png',
	'swwiki' => '$stdlogo',
	'szlwiki' => '//upload.wikimedia.org/wikipedia/szl/b/bc/Wiki.png',
	'tawiki' => '//upload.wikimedia.org/wikipedia/commons/thumb/8/80/Wikipedia-logo-v2-ta.svg/135px-Wikipedia-logo-v2-ta.svg.png', // bug 27826
	'tewiki' => '//upload.wikimedia.org/wikipedia/commons/f/f2/Wikipedia-logo-v2-te.png',
	'tetwiki' => '//upload.wikimedia.org/wikipedia/commons/3/3b/Wikipedia-logo-v2-tet.png', // bug 46589
	'tgwiki' => '//upload.wikimedia.org/wikipedia/commons/8/87/Wikipedia-logo-v2-tg.png', // bug 46589
	'thwiki' => '//upload.wikimedia.org/wikipedia/commons/3/3b/Wikipedia-logo-v2-th.png',
	'tkwiki' => '//upload.wikimedia.org/wikipedia/commons/4/49/Wikipedia-logo-v2-tk.png', // bug 46589
	'tlwiki' => '//upload.wikimedia.org/wikipedia/commons/6/69/Wikipedia-logo-v2-tl.png',
	'tnwiki' => '//upload.wikimedia.org/wikipedia/commons/0/00/Wikipedia-logo-v2-tn.png', // bug 40285
	'towiki' => '//upload.wikimedia.org/wikipedia/commons/1/1d/Wikipedia-logo-v2-to.png', // bug 49125
	'tpiwiki' => '//upload.wikimedia.org/wikipedia/commons/3/37/Wikipedia-logo-v2-tpi.png', // bug 27240
	'trwiki' => '//upload.wikimedia.org/wikipedia/commons/6/66/Wikipedia-logo-v2-tr.png',
	'tswiki' => '//upload.wikimedia.org/wikipedia/commons/9/98/Wikipedia-logo-v2-ts.png', // bug 49125
	'ttwiki' => '$stdlogo',
	'twwiki' => '//upload.wikimedia.org/wikipedia/commons/9/9e/Wikipedia-logo-v2-ak.png', // bug 48397
	'tywiki' => '//upload.wikimedia.org/wikipedia/commons/b/b4/Wikipedia-logo-v2-ty.png', // bug 46589
	'tyvwiki' => '//upload.wikimedia.org/wikipedia/commons/6/6c/Wikipedia-logo-v2-tyv.png', // bug 49328
	'udmwiki' => '//upload.wikimedia.org/wikipedia/commons/c/ce/Wikipedia-logo-v2-udm.png', // bug 46589
	'ugwiki' => '//upload.wikimedia.org/wikipedia/commons/7/7f/Wikipedia-logo-v2-ug.png', // bug 48397
	'ukwiki' => '//upload.wikimedia.org/wikipedia/commons/a/a6/Wikipedia-logo-v2-uk.png',
	'urwiki' => '//upload.wikimedia.org/wikipedia/commons/3/3d/Wikipedia-logo-v2-ur.png', // bug 46589
	'uzwiki' => '//upload.wikimedia.org/wikipedia/commons/0/04/Wikipedia-logo-v2-uz.png', // bug 37699
	'vecwiki' => '$stdlogo',
	'vepwiki' => '//upload.wikimedia.org/wikipedia/commons/f/f7/Wikipedia-logo-v2-vep.png',
	'viwiki' => '//upload.wikimedia.org/wikipedia/commons/0/01/Wikipedia-logo-v2-vi.png',
	'vlswiki' => '//upload.wikimedia.org/wikipedia/commons/2/25/Wikipedia-logo-v2-vls.png', // bug 40285
	'vowiki' => '//upload.wikimedia.org/wikipedia/commons/4/44/Wikipedia-logo-v2-vo.png', // bug 49125
	'wawiki' => '//upload.wikimedia.org/wikipedia/commons/e/e6/Wikipedia-logo-v2-wa.png', // bug 40285
	'warwiki' => '//upload.wikimedia.org/wikipedia/commons/8/81/Wikipedia-logo-v2-war.png', // bug 40285
	'wowiki' => '//upload.wikimedia.org/wikipedia/commons/4/41/Wikipedia-logo-v2-wo.png', // bug 40285
	'wuuwiki' => '//upload.wikimedia.org/wikipedia/commons/9/92/Wikipedia-logo-v2-wuu.png', // bug 44974
	'xalwiki' => '//upload.wikimedia.org/wikipedia/commons/b/b6/Wikipedia-logo-v2-xal.png', // bug 44974
	'xmfwiki' => '//upload.wikimedia.org/wikipedia/commons/thumb/a/a0/Wikipedia-logo-v2-xmf.svg/135px-Wikipedia-logo-v2-xmf.svg.png',
	'yiwiki' => '$stdlogo',
	'yowiki' => '//upload.wikimedia.org/wikipedia/commons/a/a7/Wikipedia-logo-v2-yo.png',
	'zawiki' => '//upload.wikimedia.org/wikipedia/commons/2/2c/Wikipedia-logo-v2-za.png', // bug 48397
	'zeawiki' => '//upload.wikimedia.org/wikipedia/commons/0/0f/Wikipedia-logo-v2-zea.png', // bug 49125
	'zhwiki' => '$stdlogo',
	'zh_classicalwiki' => '//upload.wikimedia.org/wikipedia/commons/e/ea/Wikipedia-logo-v2-zh-classical.png', // bug 44974
	'zh_min_nanwiki' => '$stdlogo',
	'zh_yuewiki' => '//upload.wikimedia.org/wikipedia/commons/8/89/Wikipedia-logo-v2-zh-yue.png',

	// Wiktionary
	'afwiktionary' => '$stdlogo',
	'amwiktionary' => '//upload.wikimedia.org/wikipedia/commons/thumb/0/01/Wiktionary-logo-am.svg/128px-Wiktionary-logo-am.svg.png', // Bug 43240
	'anwiktionary' => '$stdlogo',
	'angwiktionary' => '$stdlogo',
	'arwiktionary' => '//upload.wikimedia.org/wikipedia/commons/thumb/b/be/WiktionaryAr.svg/128px-WiktionaryAr.svg.png',
	'astwiktionary' => '$stdlogo',
	'azwiktionary' => '//upload.wikimedia.org/wikipedia/commons/thumb/1/15/Wiktionary-logo-az.svg/128px-Wiktionary-logo-az.svg.png', // Bug 43240
	'bewiktionary' => '//upload.wikimedia.org/wikipedia/commons/thumb/0/0c/Wiktionary-logo-be.svg/128px-Wiktionary-logo-be.svg.png', // Bug 43240
	'bgwiktionary' => '$stdlogo',
	'bnwiktionary' => '//upload.wikimedia.org/wikipedia/commons/thumb/a/a9/Wiktionary-logo-bn.svg/128px-Wiktionary-logo-bn.svg.png', // Bug 43240
	'brwiktionary' => '$stdlogo',
	'bswiktionary' => '//upload.wikimedia.org/wikipedia/commons/thumb/b/b9/Wiktionary-logo-bs.svg/128px-Wiktionary-logo-bs.svg.png', // Bug 43240
	'cawiktionary' => '$stdlogo',
	'cowiktionary' => '//upload.wikimedia.org/wikipedia/commons/thumb/d/d1/Wiktionary-logo-co.svg/128px-Wiktionary-logo-co.svg.png', // Bug 43240
	'cswiktionary' => '$stdlogo',
	'csbwiktionary' => '//upload.wikimedia.org/wikipedia/commons/thumb/3/37/Wiktionary-logo-csb.svg/128px-Wiktionary-logo-csb.svg.png', // Bug 43240
	'cywiktionary' => '$stdlogo',
	'dawiktionary' => '//upload.wikimedia.org/wikipedia/commons/thumb/6/69/Wiktionary-logo-da.svg/128px-Wiktionary-logo-da.svg.png', // Bug 43240
	'dewiktionary' => '$stdlogo',
	'diqwiktionary' => '//upload.wikimedia.org/wikipedia/commons/thumb/8/82/Wiktionary-logo-diq.svg/128px-Wiktionary-logo-diq.svg.png', // Bug 43240
	'elwiktionary' => '$stdlogo',
	'enwiktionary' => '$stdlogo',
	'eowiktionary' => '//upload.wikimedia.org/wikipedia/commons/thumb/0/01/Wiktionary-logo-eo.svg/128px-Wiktionary-logo-eo.svg.png', // Bug 43240
	'eswiktionary' => '//upload.wikimedia.org/wikipedia/commons/thumb/c/c3/WiktionaryEs.svg/128px-WiktionaryEs.svg.png',
	'etwiktionary' => '//upload.wikimedia.org/wikipedia/commons/thumb/c/cd/Wiktionary-logo-et.svg/128px-Wiktionary-logo-et.svg.png', // Bug 43240
	'euwiktionary' => '$stdlogo',
	'fawiktionary' => '$stdlogo',
	'fiwiktionary' => '//upload.wikimedia.org/wikipedia/commons/thumb/9/97/Wiktionary-logo-fi.svg/128px-Wiktionary-logo-fi.svg.png', // Bug 43240
	'fowiktionary' => '//upload.wikimedia.org/wikipedia/commons/thumb/3/3b/Wiktionary-logo-fo.svg/128px-Wiktionary-logo-fo.svg.png', // Bug 43240
	'frwiktionary' => '$stdlogo',
	'fywiktionary' => '//upload.wikimedia.org/wikipedia/commons/thumb/c/ca/Wiktionary-logo-fy.svg/128px-Wiktionary-logo-fy.svg.png', // Bug 43240
	'gawiktionary' => '$stdlogo',
	'gdwiktionary' => '//upload.wikimedia.org/wikipedia/commons/thumb/5/5a/Wiktionary-logo-gd.svg/128px-Wiktionary-logo-gd.svg.png', // Bug 43240
	'glwiktionary' => '$stdlogo',
	'guwiktionary' => '//upload.wikimedia.org/wikipedia/commons/thumb/9/9d/Wiktionary-logo-gu.svg/128px-Wiktionary-logo-gu.svg.png', // Bug 43240
	'gvwiktionary' => '//upload.wikimedia.org/wikipedia/commons/thumb/b/bb/Wiktionary-logo-gv.svg/128px-Wiktionary-logo-gv.svg.png', // Bug 43240
	'hewiktionary' => '$stdlogo',
	'hiwiktionary' => '//upload.wikimedia.org/wikipedia/commons/thumb/5/58/Wiktionary-logo-hi.svg/128px-Wiktionary-logo-hi.svg.png', // Bug 43240
	'hsbwiktionary' => '//upload.wikimedia.org/wikipedia/commons/thumb/3/30/Wiktionary-logo-hsb.svg/128px-Wiktionary-logo-hsb.svg.png', // Bug 43240
	'huwiktionary' => '$stdlogo',
	'hywiktionary' => '//upload.wikimedia.org/wikipedia/commons/thumb/d/d4/Wiktionary-logo-hy.svg/128px-Wiktionary-logo-hy.svg.png', // Bug 43240
	'iawiktionary' => '//upload.wikimedia.org/wikipedia/commons/thumb/5/5f/Wiktionary-logo-ia.svg/128px-Wiktionary-logo-ia.svg.png', // Bug 43240
	'idwiktionary' => '$stdlogo',
	'iewiktionary' => '//upload.wikimedia.org/wikipedia/commons/thumb/2/20/Wiktionary-logo-ie.svg/128px-Wiktionary-logo-ie.svg.png', // Bug 43240
	'ikwiktionary' => '//upload.wikimedia.org/wikipedia/commons/thumb/6/6c/Wiktionary-logo-ik.svg/128px-Wiktionary-logo-ik.svg.png', // Bug 43240
	'iowiktionary' => '$stdlogo',
	'iswiktionary' => '$stdlogo',
	'itwiktionary' => '$stdlogo',
	'jbowiktionary' => '//upload.wikimedia.org/wikipedia/commons/thumb/f/f5/Wiktionary-logo-jbo.svg/128px-Wiktionary-logo-jbo.svg.png', // Bug 43240
	'jvwiktionary' => '//upload.wikimedia.org/wikipedia/commons/thumb/c/c1/Wiktionary-logo-jv.svg/128px-Wiktionary-logo-jv.svg.png', // Bug 43240
	'kawiktionary' => '//upload.wikimedia.org/wikipedia/commons/thumb/7/7e/Wiktionary-logo-ka_copy.png/135px-Wiktionary-logo-ka_copy.png',
	'kkwiktionary' => '//upload.wikimedia.org/wiktionary/kk/b/bc/Wiki.png',
	'kmwiktionary' => '$stdlogo',
	'knwiktionary' => '//upload.wikimedia.org/wikipedia/commons/thumb/7/71/Wiktionary-logo-kn.svg/135px-Wiktionary-logo-kn.svg.png', // bug 29380
	'kowiktionary' => '$stdlogo',
	'kuwiktionary' => '$stdlogo',
	'kwwiktionary' => '//upload.wikimedia.org/wikipedia/commons/thumb/9/9e/Wiktionary-logo-kw.svg/128px-Wiktionary-logo-kw.svg.png', // Bug 43240
	'kywiktionary' => '//upload.wikimedia.org/wikipedia/commons/thumb/6/64/Wiktionary-logo-ky.svg/128px-Wiktionary-logo-ky.svg.png', // Bug 43240
	'lawiktionary' => '$stdlogo',
	'lbwiktionary' => '//upload.wikimedia.org/wikipedia/commons/thumb/f/fe/Wiktionary-logo-lb.png/135px-Wiktionary-logo-lb.png',
	'liwiktionary' => '//upload.wikimedia.org/wikipedia/commons/thumb/2/25/Wiktionary-logo-li.svg/128px-Wiktionary-logo-li.svg.png', // Bug 43240
	'ltwiktionary' => '$stdlogo',
	'lvwiktionary' => '//upload.wikimedia.org/wikipedia/commons/thumb/4/45/Wiktionary-logo-lv.svg/128px-Wiktionary-logo-lv.svg.png', // Bug 43240
	'mgwiktionary' => '$stdlogo',
	'miwiktionary' => '//upload.wikimedia.org/wikipedia/commons/thumb/8/88/Wiktionary-logo-mi.svg/128px-Wiktionary-logo-mi.svg.png', // Bug 43240
	'mlwiktionary' => '//upload.wikimedia.org/wikipedia/commons/thumb/a/a9/Wiktionary-logo-ml.svg/128px-Wiktionary-logo-ml.svg.png', // bug 41785
	'mnwiktionary' => '//upload.wikimedia.org/wikipedia/commons/thumb/3/3d/Wiktionary-logo-mn.svg/128px-Wiktionary-logo-mn.svg.png', // Bug 43240
	'mrwiktionary' => '//upload.wikimedia.org/wikipedia/commons/thumb/a/ac/Wiktionary-logo-mr.svg/128px-Wiktionary-logo-mr.svg.png', // Bug 43240
	'mswiktionary' => '//upload.wikimedia.org/wikipedia/commons/thumb/a/ab/Wiktionary-logo-ms.svg/128px-Wiktionary-logo-ms.svg.png', // Bug 43240
	'mtwiktionary' => '//upload.wikimedia.org/wikipedia/commons/thumb/1/1c/Wiktionary-logo-mt.svg/128px-Wiktionary-logo-mt.svg.png', // Bug 43240
	'mywiktionary' => '//upload.wikimedia.org/wikipedia/commons/thumb/9/96/Wiktionary-logo-my.svg/128px-Wiktionary-logo-my.svg.png', // Bug 43240
	'ndswiktionary' => '//upload.wikimedia.org/wikipedia/commons/thumb/6/65/WiktionaryNds.svg/128px-WiktionaryNds.svg.png',
	'newiktionary' => '//upload.wikimedia.org/wikipedia/commons/thumb/0/02/Wiktionary-logo-ne.svg/128px-Wiktionary-logo-ne.svg.png', // Bug 43240
	'nlwiktionary' => '//upload.wikimedia.org/wiktionary/nl/2/26/WiktNL1.png',
	'nnwiktionary' => '//upload.wikimedia.org/wikipedia/commons/thumb/5/51/Wiktionary-logo-nn.svg/128px-Wiktionary-logo-nn.svg.png', // Bug 43240
	'nowiktionary' => '$stdlogo',
	'ocwiktionary' => '//upload.wikimedia.org/wikipedia/commons/thumb/0/0d/Wiktionary-logo-oc.svg/128px-Wiktionary-logo-oc.svg.png', // bug 52019
	'orwiktionary' => '//upload.wikimedia.org/wikipedia/commons/thumb/1/14/Wiktionary-logo-or.svg/128px-Wiktionary-logo-or.svg.png',
	'pawiktionary' => '//upload.wikimedia.org/wikipedia/commons/thumb/9/98/Wiktionary-logo-pa.svg/128px-Wiktionary-logo-pa.svg.png', // Bug 43240
	'plwiktionary' => '$stdlogo',
	'pnbwiktionary' => '//upload.wikimedia.org/wikipedia/commons/thumb/e/ec/Wiktionary-logo.svg/128px-Wiktionary-logo.svg.png',
	'pswiktionary' => '//upload.wikimedia.org/wikipedia/commons/thumb/5/5a/Wiktionary-logo-ps.svg/128px-Wiktionary-logo-ps.svg.png', // Bug 43240
	'ptwiktionary' => '//upload.wikimedia.org/wikipedia/commons/thumb/c/cc/WiktionaryPt.svg/128px-WiktionaryPt.svg.png', // bug 53685
	'quwiktionary' => '$stdlogo',
	'roa_rupwiktionary' => '//upload.wikimedia.org/wikipedia/commons/thumb/5/5e/Wiktionary-logo-roa-rup.svg/128px-Wiktionary-logo-roa-rup.svg.png', // Bug 43240
	'rowiktionary' => '$stdlogo',
	'ruwiktionary' => '$stdlogo',
	'sawiktionary' => '//upload.wikimedia.org/wikipedia/commons/thumb/8/8a/Wiktionary-logo-sa.svg/128px-Wiktionary-logo-sa.svg.png', // Bug 43240
	'scnwiktionary' => '//upload.wikimedia.org/wikipedia/commons/thumb/8/86/Wiktionary-logo-scn.svg/128px-Wiktionary-logo-scn.svg.png', // Bug 43240
	'sdwiktionary' => '//upload.wikimedia.org/wikipedia/commons/thumb/c/c8/Wiktionary-logo-sd.svg/128px-Wiktionary-logo-sd.svg.png', // Bug 43240
	'sgwiktionary' => '//upload.wikimedia.org/wiktionary/sg/b/bc/Wiki.png',
	'shwiktionary' => '$stdlogo',
	'simplewiktionary' => '$stdlogo',
	'siwiktionary' => '//upload.wikimedia.org/wikipedia/commons/f/ff/WiktionarySi.png',
	'skwiktionary' => '//upload.wikimedia.org/wikipedia/commons/thumb/c/c7/Wiktionary-logo-sk.svg/128px-Wiktionary-logo-sk.svg.png', // Bug 43240
	'slwiktionary' => '//upload.wikimedia.org/wikipedia/commons/thumb/a/a7/Wiktionary-logo-sl.svg/128px-Wiktionary-logo-sl.svg.png', // Bug 43240
	'sqwiktionary' => '$stdlogo',
	'srwiktionary' => '$stdlogo',
	'suwiktionary' => '//upload.wikimedia.org/wikipedia/commons/thumb/f/f0/Wiktionary-logo-su.svg/128px-Wiktionary-logo-su.svg.png', // Bug 43240
	'svwiktionary' => '//upload.wikimedia.org/wiktionary/sv/b/bc/Wiki.png',
	'swwiktionary' => '//upload.wikimedia.org/wikipedia/commons/thumb/6/60/Wiktionary-logo-sw.svg/128px-Wiktionary-logo-sw.svg.png', // Bug 43240
	'tawiktionary' => '$stdlogo',
	'tewiktionary' => '//upload.wikimedia.org/wikipedia/commons/thumb/a/a7/Wiktionary-logo-te.svg/128px-Wiktionary-logo-te.svg.png', // Bug 43240
	'thwiktionary' => '//upload.wikimedia.org/wikipedia/commons/8/84/Wiktionary-logo-th.png',
	'tkwiktionary' => '//upload.wikimedia.org/wikipedia/commons/thumb/c/c5/Wiktionary-logo-tk.svg/128px-Wiktionary-logo-tk.svg.png', // Bug 43240
	'trwiktionary' => '$stdlogo',
	'ttwiktionary' => '//upload.wikimedia.org/wikipedia/commons/thumb/6/65/Wiktionary-logo-tt.svg/128px-Wiktionary-logo-tt.svg.png', // Bug 43240
	'ugwiktionary' => '//upload.wikimedia.org/wikipedia/commons/thumb/d/d3/Wiktionary-logo-ug.svg/128px-Wiktionary-logo-ug.svg.png', // Bug 43240
	'ukwiktionary' => '$stdlogo',
	'urwiktionary' => '//upload.wikimedia.org/wikipedia/commons/thumb/f/f4/Wiktionary-logo-ur.svg/128px-Wiktionary-logo-ur.svg.png', // Bug 43240
	'uzwiktionary' => '//upload.wikimedia.org/wikipedia/commons/thumb/b/bc/Wiktionary-logo-uz.svg/128px-Wiktionary-logo-uz.svg.png', // Bug 43240
	'viwiktionary' => '//upload.wikimedia.org/wikipedia/commons/thumb/7/74/Wiktionary-logo-vi.svg/128px-Wiktionary-logo-vi.svg.png', // Bug 43240
	'vowiktionary' => '$stdlogo',
	'wawiktionary' => '//upload.wikimedia.org/wikipedia/commons/thumb/4/4c/Wiktionary-logo-wa.svg/128px-Wiktionary-logo-wa.svg.png', // Bug 43240
	'wowiktionary' => '$stdlogo',
	'yiwiktionary' => '$stdlogo',
	'zh_min_nanwiktionary' => '//upload.wikimedia.org/wikipedia/commons/thumb/2/2e/Wiktionary-logo-zh-min-nan.svg/128px-Wiktionary-logo-zh-min-nan.svg.png', // Bug 43240
	'zhwiktionary' => '$stdlogo',

	// Wikiquote
	'angwikiquote' => '$stdlogo',
	'arwikiquote' => '$stdlogo',
	'azwikiquote' => '$stdlogo',
	'bgwikiquote' => '$stdlogo',
	'bswikiquote' => '$stdlogo',
	'cawikiquote' => '$stdlogo',
	'cswikiquote' => '//upload.wikimedia.org/wikiquote/cs/b/bc/Wiki.png',
	'dewikiquote' => '//upload.wikimedia.org/wikipedia/commons/1/1a/Wikiquote-logo-en.png',
	'elwikiquote' => '$stdlogo',
	'eowikiquote' => '//upload.wikimedia.org/wikiquote/eo/b/bc/Wiki.png', // bug 43879
	'etwikiquote' => '//upload.wikimedia.org/wikiquote/et/b/bc/Wiki.png',
	'fawikiquote' => '$stdlogo',
	'hewikiquote' => '$stdlogo',
	'hrwikiquote' => '$stdlogo',
	'huwikiquote' => '$stdlogo',
	'hywikiquote' => '//upload.wikimedia.org/wikipedia/commons/thumb/d/d1/Wikiquote-logo-hy.svg/150px-Wikiquote-logo-hy.svg.png',
	'iswikiquote' => '$stdlogo',
	'kawikiquote' => '$stdlogo',
	'kowikiquote' => '//upload.wikimedia.org/wikiquote/ko/b/bc/Wiki.png', // bug 27548
	'kuwikiquote' => '$stdlogo',
	'mlwikiquote' => '//upload.wikimedia.org/wikipedia/commons/thumb/a/a7/Wikiquote-logo-ml.svg/135px-Wikiquote-logo-ml.svg.png', // bug 42771
	'nlwikiquote' => '$stdlogo',
	'nnwikiquote' => '//upload.wikimedia.org/wikiquote/nn/b/bc/Wiki.png', // bug 27555
	'plwikiquote' => '$stdlogo',
	'rowikiquote' => '$stdlogo',
	'ruwikiquote' => '$stdlogo',
	'sawikiquote' => '//upload.wikimedia.org/wikipedia/commons/thumb/e/e3/Sanskrit_Wikiquote_logo.svg/135px-Sanskrit_Wikiquote_logo.svg.png', // bug 43812
	'skwikiquote' => '$stdlogo',
	'slwikiquote' => '$stdlogo',
	'sqwikiquote' => '$stdlogo',
	'srwikiquote' => '$stdlogo',
	'tawikiquote' => '//upload.wikimedia.org/wikipedia/commons/thumb/4/44/Tamilwikiquote.png/135px-Tamilwikiquote.png', // bug 55864
	'thwikiquote' => '//upload.wikimedia.org/wikipedia/commons/7/7c/Wikiquote-logo-th.png',
	'trwikiquote' => '$stdlogo',
	'ukwikiquote' => '//upload.wikimedia.org/wikipedia/commons/9/95/Wikiquote-logo-uk.png',
	'viwikiquote' => '$stdlogo',
	'zhwikiquote' => '$stdlogo',

	// Wikibooks
	'angwikibooks' => '$stdlogo',
	'arwikibooks' => '$stdlogo',
	'azwikibooks' => '//upload.wikimedia.org/wikipedia/commons/thumb/6/6f/Wikibooks-logo-az.svg/125px-Wikibooks-logo-az.svg.png', // bug 52019
	'bgwikibooks' => '$stdlogo',
	'bnwikibooks' => '//upload.wikimedia.org/wikipedia/commons/7/70/Wikibooks-logo-bn.png',
	'cawikibooks' => '$stdlogo',
	'cswikibooks' => '$stdlogo',
	'cywikibooks' => '//upload.wikimedia.org/wikipedia/commons/thumb/6/68/Wikibooks-logo-cy.svg/135px-Wikibooks-logo-cy.svg.png', // bug 52019
	'dewikibooks' => '//upload.wikimedia.org/wikibooks/de/b/bc/Wiki.png',
	'elwikibooks' => '$stdlogo',
	'enwikibooks' => '//upload.wikimedia.org/wikibooks/en/b/bc/Wiki.png',
	'eowikibooks' => '//upload.wikimedia.org/wikipedia/commons/thumb/a/a8/Wikibooks-logo-eo.svg/135px-Wikibooks-logo-eo.svg.png', // bug 52019
	'eswikibooks' => '//upload.wikimedia.org/wikipedia/commons/0/05/Wikibooks-logo-es.png',
	'etwikibooks' => '//upload.wikimedia.org/wikipedia/commons/thumb/6/6e/Wikibooks-logo-et.svg/120px-Wikibooks-logo-et.svg.png', // bug 52019
	'euwikibooks' => '//upload.wikimedia.org/wikipedia/commons/thumb/c/c4/Wikibooks-logo-eu-noslogan.svg/135px-Wikibooks-logo-eu-noslogan.svg.png', // bug 52019
	'fawikibooks' => '$stdlogo',
	'fiwikibooks' => '$stdlogo',
	'fywikibooks' => '$stdlogo',
	'hewikibooks' => '$stdlogo',
	'hrwikibooks' => '$stdlogo',
	'huwikibooks' => '$stdlogo',
	'idwikibooks' => '//upload.wikimedia.org/wikibooks/id/3/34/Wikibooks-logo-id.png',
	'iewikibooks' => '//upload.wikimedia.org/wikipedia/commons/thumb/b/b6/Wikibooks-logo-ie.svg/135px-Wikibooks-logo-ie.svg.png', // bug 52019
	'iswikibooks' => '$stdlogo',
	'itwikibooks' => '$stdlogo',
	'kawikibooks' => '$stdlogo',
	'kowikibooks' => '//upload.wikimedia.org/wikipedia/commons/a/a0/Wikibooks-logo-ko.png', // bug 56760
	'ltwikibooks' => '//upload.wikimedia.org/wikibooks/lt/2/20/Wikibooks-logo-lt.png',
	'mkwikibooks' => '//upload.wikimedia.org/wikipedia/commons/thumb/3/3b/Wikibooks-logo-mk.svg/135px-Wikibooks-logo-mk.svg.png', // bug 52019
	'mlwikibooks' => '//upload.wikimedia.org/wikipedia/commons/thumb/e/eb/Wikibooks-logo-ml.svg/135px-Wikibooks-logo-ml.svg.png', // bug 43111
	'mswikibooks' => '$stdlogo',
	'nowikibooks' => '$stdlogo',
	'ocwikibooks' => '//upload.wikimedia.org/wikipedia/commons/thumb/8/85/Wikibooks-logo-oc.svg/135px-Wikibooks-logo-oc.svg.png', // bug 52019
	'ptwikibooks' => '$stdlogo',
	'rowikibooks' => '$stdlogo',
	'ruwikibooks' => '$stdlogo',
	'siwikibooks' => '//upload.wikimedia.org/wikipedia/commons/1/1c/Wikibooks-logo-si.png',
	'skwikibooks' => '$stdlogo',
	'slwikibooks' => '//upload.wikimedia.org/wikipedia/commons/thumb/7/7f/Wikibooks-logo-sl.svg/120px-Wikibooks-logo-sl.svg.png', // bug 52019
	'sqwikibooks' => '$stdlogo',
	'srwikibooks' => '$stdlogo',
	'tawikibooks' => '//upload.wikimedia.org/wikipedia/commons/thumb/4/47/Tamil-wiki-books.png/135px-Tamil-wiki-books.png', // bug 31862
	'thwikibooks' => '//upload.wikimedia.org/wikipedia/commons/9/9b/Wikibooks-logo-th.png',
	'trwikibooks' => '$stdlogo',
	'ttwikibooks' => '$stdlogo',
	'ukwikibooks' => '$stdlogo',
	'viwikibooks' => '$stdlogo', // bug 37661
	'zhwikibooks' => '$stdlogo',

	// Wikinews
	'bswikinews' => '//upload.wikimedia.org/wikipedia/commons/b/b1/Bs_wikinews_logo.png',
	'cawikinews' => '//upload.wikimedia.org/wikipedia/commons/a/a4/Wikinews-logo-ca-small.png',
	'elwikinews' => '//upload.wikimedia.org/wikipedia/commons/0/0e/WikiNews-Logo-el.png',
	'eowikinews' => '//upload.wikimedia.org/wikipedia/commons/7/76/Wikinews-logo-eo.png',
	'eswikinews' => '//upload.wikimedia.org/wikipedia/commons/e/ed/Wikinews-logo-es-peq.png',
	'fawikinews' => '//upload.wikimedia.org/wikipedia/commons/3/36/Fawikinews.png',
	'huwikinews' => '//upload.wikimedia.org/wikipedia/commons/6/6d/Wikinews-logo-hu-135px.png',
	'kowikinews' => '//upload.wikimedia.org/wikipedia/commons/3/37/Wikinews-logo-ko-135px.png',
	'ptwikinews' => '//upload.wikimedia.org/wikipedia/commons/f/fa/Imagem-Wiki.png',
	'rowikinews' => '//upload.wikimedia.org/wikipedia/commons/1/12/Wikinews-logo-ro.png',
	'sdwikinews' => '//upload.wikimedia.org/wikipedia/commons/4/48/Sd_wikinews_logo.png',
	'sqwikinews' => '//upload.wikimedia.org/wikipedia/commons/thumb/a/a9/Wikinews-logo-sq.svg/135px-Wikinews-logo-sq.svg.png', // bug 28114
	'srwikinews' => '//upload.wikimedia.org/wikipedia/commons/e/e4/Wikinews-logo-sr22.png', // temp for event 2009-08-07, later replaced
	'tawikinews' => '//upload.wikimedia.org/wikipedia/commons/c/cf/WikiNews-Logo-ta.png',
	'thwikinews' => '//upload.wikimedia.org/wikipedia/commons/a/a1/Wikinews-logo-th-135px.png',

	// Wikisource
	'sourceswiki' => '$stdlogo',
	'arwikisource' => '$stdlogo',
	'aswikisource' => '//upload.wikimedia.org/wikipedia/commons/thumb/b/b1/Wikisource-logo-as-3.svg/135px-Wikisource-logo-as-3.svg.png', // bug 43129
	'azwikisource' => '//upload.wikimedia.org/wikipedia/commons/thumb/7/7d/Wikisource-logo-az.svg/123px-Wikisource-logo-az.svg.png', // bug 52019
	'bewikisource' => '//upload.wikimedia.org/wikipedia/commons/thumb/b/b1/Wiksource-logo-be.png/135px-Wiksource-logo-be.png',
	'bgwikisource' => '//upload.wikimedia.org/wikipedia/commons/thumb/6/6f/Wikisource-logo-bg.svg/123px-Wikisource-logo-bg.svg.png', // bug 52019
	'bnwikisource' => '$stdlogo',
	'brwikisource' => '//upload.wikimedia.org/wikipedia/commons/9/97/Wikisource-logo-br.png',
	'bswikisource' => '//upload.wikimedia.org/wikipedia/commons/thumb/1/17/Wikisource-logo-bs.svg/123px-Wikisource-logo-bs.svg.png', // bug 52019
	'cawikisource' => '$stdlogo',
	'cswikisource' => '$stdlogo',
	'cywikisource' => '//upload.wikimedia.org/wikipedia/commons/a/aa/Wikisource-logo-cy.png', // bug 56807
	'dewikisource' => '$stdlogo',
	'elwikisource' => '$stdlogo',
	'eowikisource' => '//upload.wikimedia.org/wikipedia/commons/5/54/Wikisource-logo-eo-small.png',
	'etwikisource' => '$stdlogo',
	'fawikisource' => '//upload.wikimedia.org/wikipedia/commons/1/11/Wikisource_fa.png',
	'fiwikisource' => '//upload.wikimedia.org/wikipedia/commons/thumb/d/db/Wikisource-logo-fi.svg/123px-Wikisource-logo-fi.svg.png', // bug 52019
	'frwikisource' => '$stdlogo',
	'guwikisource' => '//upload.wikimedia.org/wikipedia/commons/c/ca/Wikisource-gu-Rekha-large.png',
	'hewikisource' => '$stdlogo',
	'htwikisource' => '//upload.wikimedia.org/wikipedia/commons/thumb/a/af/Wikisource-logo-ht.svg/123px-Wikisource-logo-ht.svg.png', // bug 52019
	'huwikisource' => '//upload.wikimedia.org/wikipedia/commons/thumb/1/18/Wikisource-logo-hu.svg/123px-Wikisource-logo-hu.svg.png', // bug 52019
	'hywikisource' => '//upload.wikimedia.org/wikipedia/commons/thumb/8/80/Wikisource-logo-hy.svg/150px-Wikisource-logo-hy.svg.png', // bug 52019
	'iswikisource' => '//upload.wikimedia.org/wikipedia/commons/thumb/0/0e/Wikisource-logo-is.svg/123px-Wikisource-logo-is.svg.png', // bug 52019
	'kowikisource' => '//upload.wikimedia.org/wikisource/ko/b/bc/Wiki.png', // bug 38543
	'lawikisource' => '//upload.wikimedia.org/wikipedia/commons/thumb/0/0b/Wikisource-logo-la.svg/123px-Wikisource-logo-la.svg.png', // bug 52019
	'liwikisource' => '//upload.wikimedia.org/wikipedia/commons/thumb/4/4c/Wikisource-logo-li.svg/123px-Wikisource-logo-li.svg.png', // bug 52019
	'ltwikisource' => '//upload.wikimedia.org/wikipedia/commons/thumb/e/ec/Wikisource-logo-lt.svg/123px-Wikisource-logo-lt.svg.png', // bug 52019
	'mkwikisource' => '//upload.wikimedia.org/wikipedia/commons/thumb/0/01/Wikisource-logo-mk.svg/123px-Wikisource-logo-mk.svg.png', // bug 52019
	'mlwikisource' => '$stdlogo',
	'plwikisource' => '$stdlogo',
	'ruwikisource' => '$stdlogo',
	'sawikisource' => '//upload.wikimedia.org/wikipedia/commons/thumb/c/c3/Wikisource-logo-sa.svg/135px-Wikisource-logo-sa.svg.png',
	'sahwikisource' => '//upload.wikimedia.org/wikipedia/commons/3/3d/Wikisource-logo-sah.png',
	'skwikisource' => '$stdlogo',
	'slwikisource' => '//upload.wikimedia.org/wikipedia/commons/thumb/9/99/Wikisource-logo-sl.svg/123px-Wikisource-logo-sl.svg.png', // bug 52019
	'srwikisource' => '//upload.wikimedia.org/wikipedia/commons/thumb/c/c9/Wikisource-logo-sr.svg/123px-Wikisource-logo-sr.svg.png', // bug 52019
	'tawikisource' => '//upload.wikimedia.org/wikipedia/commons/thumb/8/80/Wikisource-logo-ta-new.svg/121px-Wikisource-logo-ta-new.svg.png',
	'tewikisource' => '//upload.wikimedia.org/wikipedia/commons/thumb/a/af/Wikisource-logo-te.svg/135px-Wikisource-logo-te.svg.png', // bug 44796
	'thwikisource' => '//upload.wikimedia.org/wikipedia/commons/thumb/6/6e/Wikisource-logo-th.svg/123px-Wikisource-logo-th.svg.png', // bug 52019
	'trwikisource' => '//upload.wikimedia.org/wikipedia/commons/thumb/a/a3/Wikisource-logo-tr.svg/123px-Wikisource-logo-tr.svg.png', // bug 52019
	'ukwikisource' => '//upload.wikimedia.org/wikipedia/commons/thumb/b/b2/Wikisource-logo-uk-v2.svg/123px-Wikisource-logo-uk-v2.svg.png', // bug 54491
	'vecwikisource' => '//upload.wikimedia.org/wikipedia/sources/b/bc/Wiki.png',
	'viwikisource' => '$stdlogo',
	'yiwikisource' => '$stdlogo',
	'zhwikisource' => '//upload.wikimedia.org/wikipedia/commons/4/4b/Wikisource-logo-zh.png',
	'zh_min_nanwikisource' => '//upload.wikimedia.org/wikisource/zh-min-nan/b/bc/Wiki.png',

	// Wikiversity
	'arwikiversity' => '//upload.wikimedia.org/wikipedia/commons/5/5c/Wikiversity-logo-ar-small.png',
	'cswikiversity' => '//upload.wikimedia.org/wikipedia/commons/thumb/0/04/Wikiversity-logo-cs.svg/135px-Wikiversity-logo-cs.svg.png', // bug 52019
	'kowikiversity' => '//upload.wikimedia.org/wikipedia/commons/thumb/b/b2/Wikiversity-logo-ko.svg/135px-Wikiversity-logo-ko.svg.png',
	'ruwikiversity' => '//upload.wikimedia.org/wikiversity/ru/b/bc/Wiki.png',
	'slwikiversity' => '//upload.wikimedia.org/wikipedia/commons/4/4f/Sl-wikiversity-org.png',

	// Wikivoyage
	'elwikivoyage' => '//upload.wikimedia.org/wikipedia/commons/f/fa/Wikivoyage-Logo-v3-small-el.png',
	'fawikivoyage' => '//upload.wikimedia.org/wikipedia/commons/thumb/0/0c/Wikivoyage-Logo-v3-fa.svg/153px-Wikivoyage-Logo-v3-fa.svg.png', // bug 71382
	'hewikivoyage' => '//upload.wikimedia.org/wikipedia/commons/thumb/c/c0/Wikivoyage-Logo-v3-he.png/153px-Wikivoyage-Logo-v3-he.png',
	'plwikivoyage' => '//upload.wikimedia.org/wikipedia/commons/f/f2/Wikivoyage-Logo-v3-small-pl.png',
	'zhwikivoyage' => '//upload.wikimedia.org/wikipedia/commons/3/3c/Wikivoyage-Logo-v3-zh-hans.png', // bug 59077

	// Chapter wikis
	'arwikimedia' => '//upload.wikimedia.org/wikipedia/commons/thumb/b/ba/Wikimedia_Argentina_logo.svg/135px-Wikimedia_Argentina_logo.svg.png',
	'bdwikimedia' => '//upload.wikimedia.org/wikipedia/commons/3/3d/Wikimedia_Bangladesh_site_logo.png',
	'bewikimedia' => '//upload.wikimedia.org/wikipedia/commons/thumb/4/40/Wikimedia_Belgium_logo.png/135px-Wikimedia_Belgium_logo.png',
	'cawikimedia' => '//upload.wikimedia.org/wikipedia/commons/thumb/6/6c/Wikimediacanada-logo.png/135px-Wikimediacanada-logo.png',
	'cowikimedia' => '//upload.wikimedia.org/wikipedia/commons/6/6b/Wikimedia-Colombia-logo.png',
	'dkwikimedia' => '//upload.wikimedia.org/wikimedia/dk/b/bc/Wiki.png',
	'etwikimedia' => '$stdlogo',
	'fiwikimedia' => '$stdlogo',
	'ilwikimedia' => '$stdlogo',
	'mkwikimedia' => '//upload.wikimedia.org/wikipedia/meta/3/38/Wikimedia_Macedonia_logo_small_mk.png',
	'mxwikimedia' => '//upload.wikimedia.org/wikipedia/commons/thumb/f/fa/Wikimedia_Mexico.svg/135px-Wikimedia_Mexico.svg.png',
	'nlwikimedia' => '$stdlogo',
	'nowikimedia' => '$stdlogo',
	'noboard_chapterswikimedia' => '$stdlogo',
	'nycwikimedia' => '//upload.wikimedia.org/wikipedia/commons/thumb/7/70/Wikimedia_New_York_City_logo.svg/135px-Wikimedia_New_York_City_logo.svg.png',
	'nzwikimedia' => '$stdlogo',
	'pa_uswikimedia' => '//upload.wikimedia.org/wikimedia/pa-us/b/bc/Wiki.png',
	'plwikimedia' => '$stdlogo',
	'rswikimedia' => '$stdlogo',
	'ruwikimedia' => '$stdlogo',
	'sewikimedia' => '$stdlogo',
	'trwikimedia' => '$stdlogo',
	'uawikimedia' => '//upload.wikimedia.org/wikipedia/commons/thumb/7/7b/Wikimedia-UA-logo.svg/135px-Wikimedia-UA-logo.svg.png',
	'ukwikimedia' => '$stdlogo',
	'vewikimedia' => 'https://upload.wikimedia.org/wikipedia/commons/thumb/a/ab/Wikimedia_Venezuela_logo.svg/135px-Wikimedia_Venezuela_logo.svg.png',

	// Special wikis
	'advisorywiki' => '//upload.wikimedia.org/wikipedia/meta/7/7d/Wikimediaboard-logo135px.png',
	'arbcom_dewiki' => '$stdlogo',
	'arbcom_nlwiki' => '//upload.wikimedia.org/wikipedia/commons/9/9b/Arbcom_nl_logo.png',
	'boardwiki' => '//upload.wikimedia.org/wikipedia/meta/7/7d/Wikimediaboard-logo135px.png',
	'brwikimedia' => '$stdlogo',
	'chairwiki' => '//upload.wikimedia.org/wikipedia/meta/7/7d/Wikimediaboard-logo135px.png',
	'chapcomwiki' => '//upload.wikimedia.org/wikipedia/meta/1/1d/Wikimediachapcom-logo135px.png',
	'checkuserwiki' => '//upload.wikimedia.org/wikipedia/commons/1/10/Wikimedia_CheckUser_wiki_logo.png', // bug 28785
	'collabwiki' => '//upload.wikimedia.org/wikipedia/meta/5/5d/Collab.png',
	'commonswiki' => '//upload.wikimedia.org/wikipedia/commons/7/79/Wiki-commons.png',
	'donatewiki' => '//upload.wikimedia.org/wikipedia/foundation/9/9a/Wikimediafoundation-logo.png',
	'execwiki' => '//upload.wikimedia.org/wikipedia/meta/d/d6/Wikimedia-execwiki-logo.png',
	'fdcwiki' => '//upload.wikimedia.org/wikipedia/commons/a/a2/Wikimedia_FDC_logo_full.png', // bug 48379
	'foundationwiki' => '//upload.wikimedia.org/wikipedia/foundation/9/9a/Wikimediafoundation-logo.png',
	'iegcomwiki' => '//upload.wikimedia.org/wikipedia/commons/5/5e/Wikimedia_IEG_committee_logo.png', // bug 48379
	'incubatorwiki' => '$stdlogo',
	'internalwiki' => '//upload.wikimedia.org/wikipedia/meta/a/a2/Wikimediainernal-logo135px.png',
	'legalteamwiki' => '//upload.wikimedia.org/wikipedia/commons/thumb/4/4c/Rory_sketch_-_sword_and_shield.png/135px-Rory_sketch_-_sword_and_shield.png',
	'loginwiki' => '//upload.wikimedia.org/wikipedia/commons/e/ed/Wikimedia_logo-scaled-down.png', // bug 48236
	'mediawikiwiki' => '$stdlogo',
	'metawiki' => '$stdlogo',
	'nostalgiawiki' => '//upload.wikimedia.org/wikipedia/meta/3/32/Wiki_orig_logo.png',
	'officewiki' => '//upload.wikimedia.org/wikipedia/meta/e/ed/WikimediaOFFICE-logo135px.png',
	'ombudsmenwiki' => '//upload.wikimedia.org/wikipedia/commons/3/3a/Wikimedia_Ombudsmen_logo.png', // bug 48379
	'otrs_wikiwiki' => '//upload.wikimedia.org/wikipedia/commons/7/7c/Wiki-otrs.png',
	'outreachwiki' => '//upload.wikimedia.org/wikipedia/commons/9/9f/Wikimedia_Outreach.png',
	'qualitywiki' => '$stdlogo',
	'searchcomwiki' => '//upload.wikimedia.org/wikipedia/meta/a/a2/Wikimediainernal-logo135px.png',
	'spcomwiki' => '//upload.wikimedia.org/wikipedia/meta/9/93/Wikimediaspcom-logo135px.png',
	'specieswiki' => '//upload.wikimedia.org/wikipedia/commons/b/b2/Wikispecies-logo-en.png',
	'stewardwiki' => '//upload.wikimedia.org/wikipedia/commons/9/96/Steward_wiki_logo_3.png', // bug 37700
	'strategywiki' => '$stdlogo',
	'tenwiki' => '$stdlogo',
	'testwiki' => '$stdlogo',
	'testwikidatawiki' => '//upload.wikimedia.org/wikipedia/commons/thumb/4/43/Wikidata-logo-en-black.svg/135px-Wikidata-logo-en-black.svg.png',
	'transitionteamwiki' => '//upload.wikimedia.org/wikipedia/commons/1/17/Wikimedia_EDTT_logo_full.png', // bug 48379
	'usabilitywiki' => '//upload.wikimedia.org/wikipedia/commons/1/1e/Wikimedia_Usability_Initiative_Logo.png',
	'votewiki' => '//upload.wikimedia.org/wikipedia/foundation/9/9a/Wikimediafoundation-logo.png',
	'wg_enwiki' => '//upload.wikimedia.org/wikipedia/commons/thumb/7/75/Wikimedia_Community_Logo.svg/120px-Wikimedia_Community_Logo.svg.png',
	'wikimania2005wiki' => '//upload.wikimedia.org/wikipedia/commons/thumb/d/de/Wikimania_2005_logo.svg/135px-Wikimania_2005_logo.svg.png', // bug 48382
	'wikimania2006wiki' => '//upload.wikimedia.org/wikipedia/commons/thumb/2/2b/Wikimania_2006_logo.svg/135px-Wikimania_2006_logo.svg.png', // bug 48382
	'wikimania2007wiki' => '//upload.wikimedia.org/wikipedia/commons/thumb/5/5a/Wikimania_2007_logo.svg/135px-Wikimania_2007_logo.svg.png', // bug 48382
	'wikimania2008wiki' => '//upload.wikimedia.org/wikipedia/commons/thumb/0/02/Wikimania_2008_logo.svg/135px-Wikimania_2008_logo.svg.png', // bug 48382
	'wikimania2009wiki' => '//upload.wikimedia.org/wikipedia/commons/thumb/2/28/Wikimania_2009_logo.svg/135px-Wikimania_2009_logo.svg.png', // bug 48382
	'wikimania2010wiki' => '//upload.wikimedia.org/wikipedia/commons/thumb/9/9f/Wikimania_2010_logo.svg/135px-Wikimania_2010_logo.svg.png', // bug 48382
	'wikimania2011wiki' => '//upload.wikimedia.org/wikipedia/commons/thumb/a/a3/Wikimania_2011_logo.svg/135px-Wikimania_2011_logo.svg.png', // bug 48382
	'wikimania2012wiki' => '//upload.wikimedia.org/wikipedia/commons/thumb/f/fc/Wikimania_2012_logo.svg/135px-Wikimania_2012_logo.svg.png', // bug 48382
	'wikimania2013wiki' => '//upload.wikimedia.org/wikipedia/commons/thumb/5/52/Wikimania_2013_logo.svg/135px-Wikimania_2013_logo.svg.png', // bug 48382
	'wikimania2014wiki' => '//upload.wikimedia.org/wikipedia/commons/thumb/0/06/Wikimania_2014_Shard_logo_v3_with_logotype_and_date_%28small%29.svg/135px-Wikimania_2014_Shard_logo_v3_with_logotype_and_date_%28small%29.svg.png', // bug 56398
	'wikimania2015wiki' => '//upload.wikimedia.org/wikipedia/commons/thumb/f/fc/Wikimania_2015_logo.svg/135px-Wikimania_2015_logo.svg.png', // bug 48382
	'wikimaniateamwiki' => '//upload.wikimedia.org/wikipedia/commons/thumb/0/07/Wikimania_team_logo.svg/135px-Wikimania_team_logo.svg.png', // bug 48376
),
# @} end of wgLogo

# wgEnableUploads @{
// Wikis which have uploading disabled
// If you list a wiki as false here, make sure to make an entry for $wgUploadNavigationUrl as well
'wgEnableUploads' => array(
	// Projects
	'default' => true,
	'commonsuploads' => true, // Soft-disabling
	'wikidata' => false,

	// Wikinews
	'wikinews' => false,
	'arwikinews' => true,
	'cswikinews' => true,
	'dewikinews' => true,
	'enwikinews' => true,
	'fawikinews' => true, // bug 26565
	'hewikinews' => true,
	'itwikinews' => true,
	'kowikinews' => true, // bug 24877
	'nowikinews' => true,
	'plwikinews' => true,
	'trwikinews' => true, // bug 20215

	// Other individual wikis
	'enwikiquote' => false, // http://en.wikiquote.org/wiki/Wikiquote_talk:Image_use_policy
	'eswiki' => false, // bug 6408
	'eswikibooks' => false, // bug 18865
	'eswikiquote' => false, // bug 9728
	'eswikivoyage' => false, // bug 42933
	'euwiki' => false, // bug 28609
	'fawikivoyage' => false, // bug 71382
	'itwikiquote' => false, // bug 12012
	'jawikisource' => false, // bug 3572
	'jawiktionary' => false, // bug 11775
	'loginwiki' => false,
	'mswiktionary' => false, // bug 67152
	'nlwikisource' => false, // bug 71403
	'nlwikivoyage' => false, // bug 71403
	'nlwiktionary' => false, // bug 71403
	'ndswiki' => false, // http://mail.wikipedia.org/pipermail/wikitech-l/2005-October/032136.html
	'outreachwiki' => false,
	'plwikiquote' => false,
	'ptwikivoyage' => false, // bug 42933
	'ptwiktionary' => false, // bug 14193
	'ruwikiquote' => false,
	'specieswiki' => false,
	'svwiki' => false, // bug 11954
	'svwikiversity' => false, // bug 26037
	'viwikivoyage' => false, // bug 52034
	'vowiki' => false, // bug 13740
	'xmfwiki' => false,
),
# @} end of wgEnableUploads

// Wikis which allow async uploads via the job queue if uploads are enabled
'wgEnableAsyncUploads' => array(
	'default' => false,
	'commonswiki' => true,
	'testwiki' => true,
	'test2wiki' => true,
),

# wgUploadNavigationUrl @{
'wgUploadNavigationUrl' => array(
	// Projects
	'default' => false,
	'commonsuploads' => '//commons.wikimedia.org/wiki/Special:UploadWizard',
	'wikinews' => '//commons.wikimedia.org/wiki/Special:UploadWizard',

	// Individual wikis
	// NOTE: Use relative paths for same-wiki links so the SSL converter can tweak them correctly
	'aswiki' => '/wiki/ৱিকিপিডিয়া:ফাইল_আপল’ড_বিশেষজ্ঞ',
	'bgwiki' => '/wiki/MediaWiki:Uploadtext', // bug 14836
	'bnwiki' => '/wiki/উইকিপিডিয়া:আপলোড',
	'bswiki' => '/wiki/Wikipedia:Upload', // bug 12044
	'ckbwiki' => '//commons.wikimedia.org/wiki/Special:UploadWizard?uselang=ckb',
	'cswiki' => '//commons.wikimedia.org/wiki/Special:UploadWizard?uselang=cs',
	'cswikibooks' => '//commons.wikimedia.org/wiki/Special:UploadWizard?uselang=cs',
	'cswikinews' => '//commons.wikimedia.org/wiki/Special:UploadWizard?uselang=cs',
	'cswikiquote' => '//commons.wikimedia.org/wiki/Special:UploadWizard?uselang=cs',
	'cswikisource' => '//commons.wikimedia.org/wiki/Special:UploadWizard?uselang=cs',
	'cswikiversity' => '//commons.wikimedia.org/wiki/Special:UploadWizard?uselang=cs',
	'cswiktionary' => '//commons.wikimedia.org/wiki/Special:UploadWizard?uselang=cs',
	'dawiki' => '//commons.wikimedia.org/wiki/Special:UploadWizard?uselang=da&campaign=dk', // bug 37662
	'dewikisource' => '//commons.wikimedia.org/wiki/Special:UploadWizard?uselang=de',
	'enwiki' => '/wiki/Wikipedia:File_Upload_Wizard', // bug 42263
	'enwikinews' => false,
	'enwikiquote' => '//commons.wikimedia.org/wiki/Special:UploadWizard',
	'enwikivoyage' => '//en.wikivoyage.org/wiki/Wikivoyage:Upload_file',
	'eowiki' => '//commons.wikimedia.org/wiki/Special:UploadWizard?uselang=eo', // bug 69055
	'eswiki' => '//commons.wikimedia.org/wiki/Special:UploadWizard?uselang=es',
	'eswikibooks' => '//commons.wikimedia.org/wiki/Special:UploadWizard?uselang=es',
	'eswikivoyage' => '//commons.wikimedia.org/wiki/Special:UploadWizard?uselang=es', // bug 42933
	'eswiktionary' => '//commons.wikimedia.org/wiki/Special:UploadWizard?uselang=es', // bug 7152
	'euwiki' => '//commons.wikimedia.org/wiki/Special:UploadWizard?uselang=eu',
	'fawiki' => '/wiki/ویکی‌پدیا:بارگذاری',
	'fawikivoyage' => '//commons.wikimedia.org/wiki/Special:UploadWizard?uselang=fa', // bug 71382
	'frwiki' => '/wiki/Aide:Importer_un_fichier',
	'guwiki' => false,
	'hewikinews' => false,
	'hiwiki' => '/wiki/विकिपीडिया:अपलोड',
	'hrwiki' => '/wiki/Wikipedija:Upload',
	'huwiktionary' => '//commons.wikimedia.org/wiki/Special:UploadWizard?uselang=hu',
	'incubatorwiki' => '/wiki/Special:MyLanguage/Incubator:Upload',
	'iswiktionary' => '/wiki/Wikior%C3%B0ab%C3%B3k:Hla%C3%B0a_inn_skr%C3%A1', // bug 11187
	'jawiki' => '/wiki/Wikipedia:%E3%83%95%E3%82%A1%E3%82%A4%E3%83%AB%E3%81%AE%E3%82%A2%E3%83%83%E3%83%97%E3%83%AD%E3%83%BC%E3%83%89',
	'jawikisource' => '//commons.wikimedia.org/wiki/Special:UploadWizard?uselang=ja',
	'kowiki' => '/wiki/위키백과:파일_올리기', // bug 52076
	'lawiki' => '//commons.wikimedia.org/wiki/Special:UploadWizard?uselang=la', // bug 13190
	'metawiki' => false, // bug 50287
	'mlwiki' => '/wiki/വിക്കിപീഡിയ:അപ്‌ലോഡ്',
	'mswiktionary' => '//commons.wikimedia.org/wiki/Special:UploadWizard?uselang=ms', // bug 67152
	'ndswiki' => '//commons.wikimedia.org/wiki/Special:UploadWizard?uselang=nds',
	'nlwiki' => '//commons.wikimedia.org/wiki/Special:UploadWizard?uselang=nl',
	'nlwikisource' => '//commons.wikimedia.org/wiki/Special:UploadWizard?uselang=nl',
	'nlwikiquote' => '//commons.wikimedia.org/wiki/Special:UploadWizard?uselang=nl',
	'nlwikivoyage' => '//commons.wikimedia.org/wiki/Special:UploadWizard?uselang=nl', // bug 71403
	'nlwiktionary' => '//commons.wikimedia.org/wiki/Special:UploadWizard?uselang=nl',
	'plwiki' => '//pl.wikipedia.org/wiki/Wikipedia:Prześlij_plik', // bug 42579
	'plwikinews' => false,
	'plwikiquote' => '//commons.wikimedia.org/wiki/Special:UploadWizard?uselang=pl',
	'plwikisource' => '//commons.wikimedia.org/wiki/Special:UploadWizard?uselang=pl', // bug 68191
	'ptwiki' => '/wiki/Wikipedia:Carregar_ficheiro',
	'ptwikibooks' => '//commons.wikimedia.org/wiki/Special:UploadWizard?uselang=pt',
	'ptwikivoyage' => '//commons.wikimedia.org/wiki/Special:UploadWizard?uselang=pt', // bug 42934
	'rowiki' => '/wiki/Wikipedia:Trimite_fi%C5%9Fier',
	'ruwiki' => false, // bug 12334
	'ruwikinews' => '//commons.wikimedia.org/wiki/Special:UploadWizard?uselang=ru',
	'sewikimedia' => false, // bug 61947
	'skwikisource' => '//commons.wikimedia.org/wiki/Special:UploadWizard?uselang=sk',
	'svwikisource' => false,
	'svwiktionary' => false,
	'specieswiki' => '//commons.wikimedia.org/wiki/Special:UploadWizard',
	'tewiki' => '/wiki/వికీపీడియా:ఫైల్_ఎక్కింపు_విజర్డు', // bug 57042
	'thwiki' => '/wiki/%E0%B8%A7%E0%B8%B4%E0%B8%81%E0%B8%B4%E0%B8%9E%E0%B8%B5%E0%B9%80%E0%B8%94%E0%B8%B5%E0%B8%A2:%E0%B8%AD%E0%B8%B1%E0%B8%9B%E0%B9%82%E0%B8%AB%E0%B8%A5%E0%B8%94',
	'zhwiki' => '/wiki/Project:%E4%B8%8A%E4%BC%A0',
	'zhwikinews' => '//commons.wikimedia.org/wiki/Special:UploadWizard?uselang=zh-hans',
	'zh_yuewiki' => '/wiki/Project:%E4%B8%8A%E8%BC%89',
),
# @} end of wgUploadNavigationUrl

'wgMiserMode' => array(
	'default' => true, // Slaves aren't fast enough to generate all special pages all the time.
),

'wgQueryCacheLimit' => array(
	'default' => 5000,
	'enwiki' => 3000, // safe to raise?
	'dewiki' => 4000, // safe to raise?
),

'wgArticlePath' => array(
	'default' => '/wiki/$1',
),

# wgServer @{
'wgServer' => array(
	// Projects
	'default' => '//$lang.wikipedia.org',
	'wikibooks' => '//$lang.wikibooks.org',
	'wikimedia' => '//$lang.wikimedia.org',
	'wikinews' => '//$lang.wikinews.org',
	'wikiquote' => '//$lang.wikiquote.org',
	'wikisource' => '//$lang.wikisource.org',
	'wikiversity' => '//$lang.wikiversity.org',
	'wikivoyage' => '//$lang.wikivoyage.org',
	'wiktionary' => '//$lang.wiktionary.org',

	// Individual wikis
	'advisorywiki' => '//advisory.wikimedia.org',
	'arbcom_dewiki' => '//arbcom-de.wikipedia.org',
	'arbcom_enwiki' => '//arbcom-en.wikipedia.org',
	'arbcom_fiwiki' => '//arbcom-fi.wikipedia.org',
	'arbcom_nlwiki' => '//arbcom-nl.wikipedia.org',
	'arwikimedia' => '//ar.wikimedia.org',
	'auditcomwiki' => '//auditcom.wikimedia.org',
	'boardgovcomwiki' => '//boardgovcom.wikimedia.org',
	'boardwiki' => '//board.wikimedia.org',
	'brwikimedia' => '//br.wikimedia.org',
	'chairwiki' => '//chair.wikimedia.org',
	'chapcomwiki' => '//chapcom.wikimedia.org',
	'checkuserwiki' => '//checkuser.wikimedia.org',
	'collabwiki' => '//collab.wikimedia.org',
	'commonswiki' => '//commons.wikimedia.org',
	'donatewiki' => '//donate.wikimedia.org',
	'execwiki' => '//exec.wikimedia.org',
	'fdcwiki' => '//fdc.wikimedia.org',
	'foundationwiki' => '//wikimediafoundation.org',
	'grantswiki' => '//grants.wikimedia.org',
	'iegcomwiki' => '//iegcom.wikimedia.org',
	'incubatorwiki' => '//incubator.wikimedia.org',
	'internalwiki' => '//internal.wikimedia.org',
	'labswiki' => "https://wikitech.wikimedia.org",
	'legalteamwiki' => '//legalteam.wikimedia.org',
	'loginwiki' => '//login.wikimedia.org',
	'mediawikiwiki' => '//www.mediawiki.org',
	'metawiki' => '//meta.wikimedia.org',
	'movementroleswiki' => '//movementroles.wikimedia.org',
	'mxwikimedia' => '//mx.wikimedia.org',
	'noboard_chapterswikimedia' => '//noboard-chapters.wikimedia.org',
	'nycwikimedia' => '//nyc.wikimedia.org', // bug 29273
	'officewiki' => '//office.wikimedia.org',
	'ombudsmenwiki' => '//ombudsmen.wikimedia.org',
	'otrs_wikiwiki' => '//otrs-wiki.wikimedia.org',
	'outreachwiki' => '//outreach.wikimedia.org',
	'pa_uswikimedia' => '//pa-us.wikimedia.org',
	'qualitywiki' => '//quality.wikimedia.org',
	'searchcomwiki' => '//searchcom.wikimedia.org',
	'sourceswiki' => '//wikisource.org',
	'spcomwiki' => '//spcom.wikimedia.org',
	'specieswiki' => '//species.wikimedia.org',
	'stewardwiki' => '//steward.wikimedia.org',
	'strategywiki' => '//strategy.wikimedia.org',
	'transitionteamwiki' => '//transitionteam.wikimedia.org',
	'tenwiki' => '//ten.wikipedia.org',
	'testwiki' => '//test.wikipedia.org',
	'testwikidatawiki' => '//test.wikidata.org',
	'usabilitywiki' => '//usability.wikimedia.org',
	'votewiki' => '//vote.wikimedia.org',
	'vewikimedia' => '//ve.wikimedia.org',
	'wg_enwiki' => '//wg-en.wikipedia.org',
	'wikidatawiki' => '//www.wikidata.org',
	'wikimania2005wiki' => '//wikimania2005.wikimedia.org',
	'wikimania2006wiki' => '//wikimania2006.wikimedia.org',
	'wikimania2007wiki' => '//wikimania2007.wikimedia.org',
	'wikimania2008wiki' => '//wikimania2008.wikimedia.org',
	'wikimania2009wiki' => '//wikimania2009.wikimedia.org',
	'wikimania2010wiki' => '//wikimania2010.wikimedia.org',
	'wikimania2011wiki' => '//wikimania2011.wikimedia.org',
	'wikimania2012wiki' => '//wikimania2012.wikimedia.org',
	'wikimania2013wiki' => '//wikimania2013.wikimedia.org',
	'wikimania2014wiki' => '//wikimania2014.wikimedia.org',
	'wikimania2015wiki' => '//wikimania2015.wikimedia.org',
	'wikimaniateamwiki' => '//wikimaniateam.wikimedia.org',
	'zerowiki' => '//zero.wikimedia.org'
),
# @} end of wgServer

// This is the same as wgServer but with a protocol, so if wgServer is //foo.com this must be http://foo.com
# wgCanonicalServer @{
'wgCanonicalServer' => array(
	// Projects
	'default' => 'http://$lang.wikipedia.org',
	'wikibooks' => 'http://$lang.wikibooks.org',
	'wikimedia' => 'http://$lang.wikimedia.org',
	'wikinews' => 'http://$lang.wikinews.org',
	'wikiquote' => 'http://$lang.wikiquote.org',
	'wikisource' => 'http://$lang.wikisource.org',
	'wikiversity' => 'http://$lang.wikiversity.org',
	'wikivoyage' => 'http://$lang.wikivoyage.org',
	'wiktionary' => 'http://$lang.wiktionary.org',

	// Individual wikis
	'advisorywiki' => 'http://advisory.wikimedia.org',
	'arbcom_dewiki' => 'http://arbcom-de.wikipedia.org',
	'arbcom_enwiki' => 'http://arbcom-en.wikipedia.org',
	'arbcom_fiwiki' => 'http://arbcom-fi.wikipedia.org',
	'arbcom_nlwiki' => 'http://arbcom-nl.wikipedia.org',
	'arwikimedia' => 'http://ar.wikimedia.org',
	'auditcomwiki' => 'https://auditcom.wikimedia.org',
	'boardgovcomwiki' => 'https://boardgovcom.wikimedia.org',
	'boardwiki' => 'https://board.wikimedia.org',
	'brwikimedia' => 'http://br.wikimedia.org',
	'chairwiki' => 'https://chair.wikimedia.org',
	'chapcomwiki' => 'https://chapcom.wikimedia.org',
	'checkuserwiki' => 'https://checkuser.wikimedia.org',
	'collabwiki' => 'https://collab.wikimedia.org',
	'commonswiki' => 'http://commons.wikimedia.org',
	'donatewiki' => 'https://donate.wikimedia.org',
	'execwiki' => 'https://exec.wikimedia.org',
	'fdcwiki' => 'https://fdc.wikimedia.org',
	'foundationwiki' => 'http://wikimediafoundation.org',
	'grantswiki' => 'https://grants.wikimedia.org',
	'iegcomwiki' => 'http://iegcom.wikimedia.org',
	'incubatorwiki' => 'http://incubator.wikimedia.org',
	'internalwiki' => 'https://internal.wikimedia.org',
	'labswiki' => 'https://wikitech.wikimedia.org',
	'legalteamwiki' => 'https://legalteam.wikimedia.org',
	'loginwiki' => 'http://login.wikimedia.org',
	'mediawikiwiki' => 'http://www.mediawiki.org',
	'metawiki' => 'http://meta.wikimedia.org',
	'movementroleswiki' => 'https://movementroles.wikimedia.org',
	'mxwikimedia' => 'http://mx.wikimedia.org',
	'noboard_chapterswikimedia' => 'http://noboard-chapters.wikimedia.org',
	'nycwikimedia' => 'http://nyc.wikimedia.org', // bug 29273
	'officewiki' => 'https://office.wikimedia.org',
	'ombudsmenwiki' => 'https://ombudsmen.wikimedia.org',
	'otrs_wikiwiki' => 'https://otrs-wiki.wikimedia.org',
	'outreachwiki' => 'http://outreach.wikimedia.org',
	'pa_uswikimedia' => 'http://pa-us.wikimedia.org',
	'qualitywiki' => 'http://quality.wikimedia.org',
	'searchcomwiki' => 'https://searchcom.wikimedia.org',
	'sourceswiki' => 'http://wikisource.org',
	'spcomwiki' => 'https://spcom.wikimedia.org',
	'specieswiki' => 'http://species.wikimedia.org',
	'stewardwiki' => 'https://steward.wikimedia.org',
	'strategywiki' => 'http://strategy.wikimedia.org',
	'tenwiki' => 'http://ten.wikipedia.org',
	'testwiki' => 'http://test.wikipedia.org',
	'testwikidatawiki' => 'http://test.wikidata.org',
	'transitionteamwiki' => 'https://transitionteam.wikimedia.org',
	'usabilitywiki' => 'http://usability.wikimedia.org',
	'uzwiki' => 'https://uz.wikipedia.org', // bug 43466
	'votewiki' => 'https://vote.wikimedia.org',
	'vewikimedia' => 'http://ve.wikimedia.org',
	'wg_enwiki' => 'http://wg-en.wikipedia.org',
	'wikidatawiki' => 'http://www.wikidata.org',
	'wikimania2005wiki' => 'http://wikimania2005.wikimedia.org',
	'wikimania2006wiki' => 'http://wikimania2006.wikimedia.org',
	'wikimania2007wiki' => 'http://wikimania2007.wikimedia.org',
	'wikimania2008wiki' => 'http://wikimania2008.wikimedia.org',
	'wikimania2009wiki' => 'http://wikimania2009.wikimedia.org',
	'wikimania2010wiki' => 'http://wikimania2010.wikimedia.org',
	'wikimania2011wiki' => 'http://wikimania2011.wikimedia.org',
	'wikimania2012wiki' => 'http://wikimania2012.wikimedia.org',
	'wikimania2013wiki' => 'http://wikimania2013.wikimedia.org',
	'wikimania2014wiki' => 'http://wikimania2014.wikimedia.org',
	'wikimania2015wiki' => 'http://wikimania2015.wikimedia.org',
	'wikimaniateamwiki' => 'https://wikimaniateam.wikimedia.org',
	'zerowiki' => 'https://zero.wikimedia.org',
),
# @} end of wgCanonicalServer

'wgEnableCanonicalServerLink' => array(
	'default' => true, // bug 48402
),

# wgSitename @{
'wgSitename' => array(
	// Projects
	'default' => 'Wikipedia',
	'wikibooks' => 'Wikibooks',
	'wikidata' => 'Wikidata',
	'wikimania' => 'Wikimania',
	'wikimedia' => 'Wikimedia',
	'wikinews' => 'Wikinews',
	'wikiquote' => 'Wikiquote',
	'wikisource' => 'Wikisource',
	'wikiversity' => 'Wikiversity',
	'wikivoyage' => 'Wikivoyage',
	'wiktionary' => 'Wiktionary',

	// Individual wikis, alphabetically by DB name
	'abwiki' => 'Авикипедиа',
	'advisorywiki' => 'Advisory Board',
	'angwiki' => 'Wikipǣdia', // bug 56634
	'angwikisource' => 'Wicifruma',
	'angwiktionary' => 'Wikiwordbōc', // bug 56634
	'amwiki' => 'ውክፔዲያ',
	'arbcom_dewiki' => 'Arbitration Committee',
	'arbcom_enwiki' => 'Arbitration Committee',
	'arbcom_fiwiki' => 'Arbitration Committee',
	'arbcom_nlwiki' => 'Arbitration Committee',
	'arcwiki' => 'ܘܝܩܝܦܕܝܐ',
	'arwiki' => 'ويكيبيديا',
	'arwikibooks' => 'ويكي_الكتب',
	'arwikimedia' => 'Wikimedia Argentina',
	'arwikinews' => 'ويكي_الأخبار',
	'arwikiquote' => 'ويكي_الاقتباس',
	'arwikisource' => 'ويكي_مصدر',
	'arwikiversity' => 'ويكي الجامعة',
	'arwiktionary' => 'ويكاموس',
	'arzwiki' => 'ويكيبيديا',
	'astwiki' => 'Uiquipedia',
	'astwiktionary' => 'Uiccionariu',
	'aswiki' => 'অসমীয়া ৱিকিপিডিয়া',
	'aswikisource' => 'ৱিকিউৎস', // bug 43129
	'auditcomwiki' => 'Audit Committee',
	'azwiki' => 'Vikipediya',
	'azwikibooks' => 'Vikikitab', // bug 31068
	'azwikiquote' => 'Vikisitat',
	'azwikisource' => 'VikiMənbə',
	'bawiki' => 'Википедия', // bug 41167
	'bdwikimedia' => 'উইকিমিডিয়া বাংলাদেশ',
	'be_x_oldwiki' => 'Вікіпэдыя',
	'bewiki' => 'Вікіпедыя',
	'bewikimedia' => 'Wikimedia Belgium',
	'bewikisource' => 'Вікікрыніцы',
	'bewiktionary' => 'Вікіслоўнік',
	'bgwiki' => 'Уикипедия',
	'bgwikibooks' => 'Уикикниги',
	'bgwikinews' => 'Уикиновини',
	'bgwikiquote' => 'Уикицитат',
	'bgwikisource' => 'Уикиизточник',
	'bgwiktionary' => 'Уикиречник',
	'bhwiki' => 'विकिपीडिया',
	'bjnwiki' => 'Wikipidia',
	'bnwiki' => 'উইকিপিডিয়া',
	'bnwikibooks' => 'উইকিবই',
	'bnwikisource' => 'উইকিসংকলন',
	'bnwiktionary' => 'উইকিঅভিধান',
	'boardgovcomwiki' => 'Board Governance Committee',
	'boardwiki' => 'Board',
	'bpywiki' => 'উইকিপিডিয়া',
	'brwikimedia' => 'Wikimedia Brasil',
	'brwikiquote' => 'Wikiarroud',
	'brwikisource' => 'Wikimammenn',
	'brwiktionary' => 'Wikeriadur',
	'bswikibooks' => 'Wikiknjige',
	'bswikinews' => 'Wikivijesti',
	'bswikiquote' => 'Wikicitati',
	'bswikisource' => 'Wikizvor',
	'bswiktionary' => 'Vikirječnik',
	'cawiki' => "Viquip\xc3\xa8dia",
	'cawikibooks' => 'Viquillibres',
	'cawikimedia' => 'Wikimedia Canada',
	'cawikinews' => 'Viquinotícies',
	'cawikiquote' => 'Viquidites',
	'cawikisource' => 'Viquitexts',
	'cawiktionary' => 'Viccionari',
	'ckbwiki' => 'ویکیپیدیا',
	'cewiki' => 'Википеди', // bug 47574
	'chairwiki' => 'Wikimedia Board Chair',
	'chapcomwiki' => 'Chapcom',
	'checkuserwiki' => 'CheckUser Wiki',
	'chywiki' => 'Tsétsêhéstâhese Wikipedia',
	'collabwiki' => 'Collab',
	'commonswiki' => 'Wikimedia Commons',
	'cowikimedia' => 'Wikimedia Colombia',
	'crhwiki' => 'Vikipediya',
	'cswiki' => 'Wikipedie',
	'cswikibooks' => 'Wikiknihy',
	'cswikinews' => 'Wikizprávy',
	'cswikiquote' => 'Wikicitáty',
	'cswikisource' => 'Wikizdroje',
	'cswiktionary' => 'Wikislovník',
	'cswikiversity' => 'Wikiverzita',
	'cuwiki' => 'Википєдїꙗ',
	'cvwiki' => 'Википеди',
	'cywiki' => 'Wicipedia',
	'cywikibooks' => 'Wicilyfrau',
	'cywikisource' => 'Wicidestun',
	'cywiktionary' => 'Wiciadur',
	'dkwikimedia' => 'Wikimedia Danmark',
	'donatewiki' => 'Donate',
	'dsbwiki' => 'Wikipedija',
	'dvwiki' => 'ވިކިޕީޑިއާ', // bug 48075
	'dvwiktionary' => 'ވިކިރަދީފު',
	'elwiki' => 'Βικιπαίδεια',
	'elwikibooks' => 'Βικιβιβλία',
	'elwikinews' => 'Βικινέα',
	'elwikiquote' => 'Βικιφθέγματα',
	'elwikisource' => 'Βικιθήκη',
	'elwikiversity' => 'Βικιεπιστήμιο',
	'elwikivoyage' => 'Βικιταξίδια',
	'elwiktionary' => 'Βικιλεξικό',
	'eowiki' => 'Vikipedio',
	'eowikibooks' => 'Vikilibroj',
	'eowikinews' => 'Vikinovaĵoj',
	'eowikiquote' => 'Vikicitaro',
	'eowikisource' => 'Vikifontaro',
	'eowiktionary' => 'Vikivortaro',
	'eswikibooks' => 'Wikilibros',
	'eswikinews' => 'Wikinoticias',
	'eswikiversity' => 'Wikiversidad',
	'eswikivoyage' => 'Wikiviajes', // bug 42933
	'eswiktionary' => 'Wikcionario',
	'etwiki' => 'Vikipeedia',
	'etwikibooks' => 'Vikiõpikud',
	'etwikimedia' => 'Wikimedia Eesti',
	'etwikisource' => 'Vikitekstid',
	'etwikiquote' => 'Vikitsitaadid',
	'etwiktionary' => 'Vikisõnastik',
	'execwiki' => 'Wikimedia Executive',
	'extwiki' => 'Güiquipeya',
	'fawiki' => 'ویکی‌پدیا',
	'fawikibooks' => 'ویکی‌کتاب', // bug 58655
	'fawikinews' => 'ویکی‌خبر',
	'fawikiquote' => 'ویکی‌گفتاورد',
	'fawikisource' => 'ویکی‌نبشته',
	'fawikivoyage' => 'ویکی‌سفر', // bug 71382
	'fawiktionary' => 'ویکی‌واژه',
	'fdcwiki' => 'Wikimedia FDC',
	'fiwikibooks' => 'Wikikirjasto',
	'fiwikimedia' => 'Wikimedia Suomi',
	'fiwikinews' => 'Wikiuutiset',
	'fiwikiquote' => 'Wikisitaatit',
	'fiwikisource' => 'Wikiaineisto',
	'fiwikiversity' => 'Wikiopisto',
	'fiwiktionary' => 'Wikisanakirja',
	'foundationwiki' => 'Wikimedia Foundation',
	'fowikisource' => 'Wikiheimild',
	'frpwiki' => 'Vouiquipèdia',
	'frwiki' => 'Wikipédia',
	'frwikibooks' => 'Wikilivres', // bug 49612
	'frwikiversity' => 'Wikiversité',
	'frwiktionary' => 'Wiktionnaire',
	'furwiki' => 'Vichipedie',
	'fywiki' => 'Wikipedy',
	'ganwiki' => '維基百科',
	'gawiki' => 'Vicipéid',
	'gagwiki'  => 'Vikipediya',
	'gawikibooks' => 'Vicíleabhair',
	'gawikiquote' => 'Vicísliocht',
	'gawiktionary' => 'Vicífhoclóir',
	'gdwiki'  => 'Uicipeid',
	'gnwiki' => 'Vikipetã',
	'grantswiki' => 'Wikimedia Foundation Grants Discussion',
	'guwiki' => 'વિકિપીડિયા',
	'guwikisource' => 'વિકિસ્રોત',
	'guwiktionary' => 'વિક્શનરી', // bug 40776
	'hewiki' => 'ויקיפדיה',
	'hewikibooks' => 'ויקיספר',
	'hewikinews' => 'ויקיחדשות',
	'hewikiquote' => 'ויקיציטוט',
	'hewikisource' => 'ויקיטקסט',
	'hewikivoyage' => 'ויקימסע',
	'hewiktionary' => 'ויקימילון',
	'hiwiki' => 'विकिपीडिया',
	'hiwiktionary' => 'विक्षनरी',
	'hrwiki' => 'Wikipedija',
	'hrwikiquote' => 'Wikicitat',
	'hrwikisource' => 'Wikizvor',
	'hsbwiki' => 'Wikipedija',
	'hsbwiktionary' => 'Wikisłownik', // bug 41328
	'htwiki' => 'Wikipedya',
	'htwikisource' => 'Wikisòrs',
	'huwiki' => 'Wikipédia',
	'huwikibooks' => 'Wikikönyvek',
	'huwikinews' => 'Wikihírek',
	'huwikiquote' => 'Wikidézet',
	'huwikisource' => 'Wikiforrás',
	'huwiktionary' => 'Wikiszótár',
	'hywiki' => 'Վիքիպեդիա',
	'hywikibooks' => 'Վիքիգրքեր',
	'hywikiquote' => 'Վիքիքաղվածք',
	'hywikisource' => 'Վիքիդարան',
	'hywiktionary' => 'Վիքիբառարան',
	'iawiktionary' => 'Wiktionario',
	'iegcomwiki' => 'Individual Engagement Grants Committee Wiki',
	'idwikibooks' => 'Wikibuku',
	'ilwikimedia' => 'ויקימדיה',
	'incubatorwiki' => 'Wikimedia Incubator',
	'internalwiki' => 'Internal',
	'iowiki' => 'Wikipedio',
	'iowiktionary' => 'Wikivortaro',
	'iswikibooks' => 'Wikibækur',
	'iswikiquote' => 'Wikivitnun',
	'iswikisource' => 'Wikiheimild',
	'iswiktionary' => 'Wikiorðabók',
	'itwikinews' => 'Wikinotizie',
	'itwikiversity' => 'Wikiversità',
	'itwiktionary' => 'Wikizionario',
	'iuwiki' => 'ᐅᐃᑭᐱᑎᐊ',
	'jawikinews' => 'ウィキニュース',
	'jawikiversity' => 'ウィキバーシティ',
	'kawiki' => 'ვიკიპედია',
	'kawikibooks' => 'ვიკიწიგნები',
	'kawikiquote' => 'ვიკიციტატა',
	'kawiktionary' => 'ვიქსიკონი',
	'kbdwiki' => 'Уикипедиэ',
	'kkwiki' => 'Уикипедия',
	'kkwikibooks' => 'Уикикітап',
	'kkwikiquote' => 'Уикидәйек',
	'kkwiktionary' => 'Уикисөздік',
	'kmwiki' => 'វិគីភីឌា',
	'knwiki' => 'ವಿಕಿಪೀಡಿಯ',
	'knwiktionary' => 'ವಿಕ್ಷನರಿ',
	'koiwiki' => 'Википедия',
	'kowiki' => '위키백과',
	'kowikinews' => '위키뉴스',
	'kowikibooks' => '위키책',
	'kowikiquote' => '위키인용집',
	'kowikisource' => '위키문헌',
	'kowikiversity' => '위키배움터',
	'kowiktionary' => '위키낱말사전',
	'krcwiki'  => 'Википедия',
	'kuwiki' => 'Wîkîpediya',
	'labswiki' => 'Wikitech',
	'lawiki' => 'Vicipaedia',
	'lawikibooks' => 'Vicilibri',
	'lawikiquote' => 'Vicicitatio',
	'lawiktionary' => 'Victionarium',
	'ladwiki' => 'Vikipedya',
	'lbwiktionary' => 'Wiktionnaire',
	'lbewiki' => 'Википедия',
	'legalteamwiki' => 'Legal Team Wiki',
	'lezwiki' => 'Википедия',
	'liwikibooks' => 'Wikibeuk',
	'liwikisource' => 'Wikibrónne',
	'loginwiki' => 'Wikimedia Login Wiki',
	'lowiki' => 'ວິກິພີເດຍ',
	'ltgwiki' => 'Vikipedeja',
	'ltwiki' => 'Vikipedija',
	'ltwikisource' => 'Vikišaltiniai',
	'ltwiktionary' => 'Vikižodynas',
	'lvwiki' => 'Vikipēdija',
	'mdfwiki' => 'Википедиесь',
	'mediawikiwiki' => 'MediaWiki',
	'metawiki' => 'Meta',
	'mhrwiki' => 'Википедий',
	'mkwiki' => 'Википедија',
	'mkwikimedia' => 'Викимедија Македонија',
	'mlwiki' => 'വിക്കിപീഡിയ',
	'mlwikibooks' => 'വിക്കിപാഠശാല',
	'mlwikiquote' => 'വിക്കിചൊല്ലുകൾ',
	'mlwikisource' => 'വിക്കിഗ്രന്ഥശാല',
	'mlwiktionary' => 'വിക്കിനിഘണ്ടു',
	'movementroleswiki' => 'Movement Roles',
	'mnwiki' => 'Википедиа',
	'mrjwiki' => 'Википеди',
	'mrwiki' => 'विकिपीडिया',
	'mrwikisource' => 'विकिस्रोत',
	'mtwiki' => 'Wikipedija',
	'mtwiktionary' => 'Wikizzjunarju',
	'mwlwiki' => 'Biquipédia',
	'mxwikimedia' => 'Wikimedia México',
	'myvwiki' => 'Википедиясь',
	'mznwiki' => 'ویکی‌پدیا',
	'nahwiki' => 'Huiquipedia',
	'nds_nlwiki' => 'Wikipedie',
	'newiki' => 'विकिपीडिया',
	'nlwiktionary' => 'WikiWoordenboek',
	'noboard_chapterswikimedia' => 'Wikimedia Norway Internal Board',
	'nowikibooks' => 'Wikibøker',
	'nowikimedia' => 'Wikimedia Norge',
	'nowikinews' => 'Wikinytt',
	'nowikisource' => 'Wikikilden',
	'nycwikimedia' => 'Wikimedia New York City', // bug 29273
	'ocwiki' => 'Wikipèdia', // bug 7123
	'ocwikibooks' => 'Wikilibres',
	'ocwiktionary' => 'Wikiccionari',
	'officewiki' => 'Wikimedia Office',
	'ombudsmenwiki' => 'Ombudsmen Wiki',
	'orwiki' => 'ଉଇକିପିଡ଼ିଆ',
	'oswiki' => 'Википеди',
	'otrs_wikiwiki' => 'OTRS Wiki',
	'outreachwiki' => 'Outreach Wiki',
	'pa_uswikimedia' => 'Wikimedia Pennsylvania',
	'pawiki' => 'ਵਿਕੀਪੀਡੀਆ',
	'plwikiquote' => 'Wikicytaty',
	'plwikisource' => 'Wikiźródła',
	'plwikivoyage' => 'Wikipodróże',
	'plwiktionary' => 'Wikisłownik',
	'pnbwiktionary' => 'وکشنری',
	'pntwiki' => 'Βικιπαίδεια',
	'pswiki' => 'ويکيپېډيا' ,
	'pswikibooks' => 'ويکيتابونه' ,
	'pswiktionary' => 'ويکيسيند' ,
	'ptwiki' => 'Wikipédia',
	'ptwikibooks' => 'Wikilivros',
	'ptwikinews' => 'Wikinotícias',
	'ptwikiversity' => 'Wikiversidade',
	'ptwiktionary' => 'Wikcionário',
	'qualitywiki' => 'Wikimedia Quality',
	'rmywiki' => 'Vikipidiya',
	'rowikibooks' => 'Wikimanuale',
	'rowikinews' => 'Wikiștiri',
	'rowikiquote' => 'Wikicitat',
	'rowiktionary' => 'Wikționar',
	'rswikimedia' => 'Викимедија',
	'ruewiki' => 'Вікіпедія',
	'ruwiki' => 'Википедия',
	'ruwikibooks' => 'Викиучебник',
	'ruwikimedia' => 'Викимедиа',
	'ruwikinews' => 'Викиновости',
	'ruwikiquote' => 'Викицитатник',
	'ruwikisource' => 'Викитека',
	'ruwikiversity' => 'Викиверситет',
	'ruwiktionary' => 'Викисловарь',
	'sawiki' => 'विकिपीडिया',
	'sawikiquote' => 'विकिसूक्तिः',
	'sahwiki' => 'Бикипиэдьийэ',
	'sahwikisource' => 'Бикитиэкэ',
	'scnwiktionary' => 'Wikizziunariu',
	'searchcomwiki' => 'Search Committee',
	'siwiki' => 'විකිපීඩියා, නිදහස් විශ්වකෝෂය',
	'skwiki' => 'Wikipédia',
	'skwikibooks' => 'Wikiknihy',
	'skwikiquote' => 'Wikicitáty',
	'skwikisource' => 'Wikizdroje',
	'skwiktionary' => 'Wikislovník',
	'slwiki' => 'Wikipedija',
	'slwikibooks' => 'Wikiknjige',
	'slwikiquote' => 'Wikinavedek',
	'slwikisource' => 'Wikivir',
	'slwiktionary' => 'Wikislovar',
	'slwikiversity' => 'Wikiverza',
	'sourceswiki' => 'Wikisource',
	'spcomwiki' => 'Spcom',
	'specieswiki' => 'Wikispecies',
	'sqwikinews' => 'Wikilajme',
	'srwiki' => 'Википедија',
	'srwikibooks' => 'Викикњиге',
	'srwikinews' => 'Викивести',
	'srwikisource' => 'Викизворник',
	'strategywiki' => 'Strategic Planning',
	'stewardwiki' => 'Steward Wiki',
	'tawiki' => 'விக்கிப்பீடியா',
	'tawikibooks' => 'விக்கிநூல்கள்',
	'tawikinews' => 'விக்கிசெய்தி',
	'tawiktionary' => 'விக்சனரி',
	'tawikiquote' => 'விக்கிமேற்கோள்',
	'tawikisource' => 'விக்கிமூலம்',
	'tewiki' => 'వికీపీడియా',
	'tewikisource' => 'వికీసోర్స్', // bug 50357
	'tewiktionary' => 'విక్షనరీ',
	'tenwiki' => 'Wikipedia 10',
	'tgwiki' => 'Википедиа',
	'thwiki' => 'วิกิพีเดีย',
	'thwikibooks' => 'วิกิตำรา', // bug 46153
	'thwikiquote' => 'วิกิคำคม',
	'thwikisource' => 'วิกิซอร์ซ',
	'tkwiki' => 'Wikipediýa',
	'tkwiktionary' => 'Wikisözlük',
	'transitionteamwiki' => 'Transition Team Wiki',
	'trwiki' => 'Vikipedi',
	'trwikibooks' => 'Vikikitap',
	'trwikimedia' => 'Wikimedia Türkiye',
	'trwikinews' => 'Vikihaber',
	'trwikiquote' => 'Vikisöz',
	'trwikisource' => 'Vikikaynak', // bug 42721
	'trwiktionary' => 'Vikisözlük',
	'tyvwiki' => 'Википедия', // bug 49328
	'uawikimedia' => 'Вікімедіа_Україна',
	'udmwiki' => 'Википедия', // bug 47820
	'ukwiki' => 'Вікіпедія',
	'ukwikibooks' => 'Вікіпідручник',
	'ukwikimedia' => 'Wikimedia UK', // Andrew 2009-04-27 Private request of current board member
	'ukwikinews' => 'Вікіновини', // bug 48843
	'ukwikiquote' => 'Вікіцитати',
	'ukwikisource' => 'Вікіджерела',
	'ukwikivoyage' => 'Вікімандри',
	'ukwiktionary' => 'Вікісловник',
	'urwiki' => 'ویکیپیڈیا', // bug 42155
	'urwikibooks' => 'وکی کتب',
	'urwikiquote' => 'وکی اقتباسات',
	'urwiktionary' => 'وکی لغت',
	'usabilitywiki' => 'Wikimedia Usability Initiative',
	'uzwiki' => 'Vikipediya',
	'uzwikibooks' => 'Vikikitob',
	'uzwikiquote' => 'Vikiiqtibos',
	'uzwiktionary' => 'Vikilug‘at',
	'vecwiktionary' => 'Wikisionario',
	'vepwiki' => 'Vikipedii',
	'vewikimedia' => 'Wikimedia Venezuela',
	'votewiki' => 'Wikimedia Vote Wiki', // bug 51264
	'vowiki' => 'Vükiped',
	'vowikibooks' => 'Vükibuks',
	'vowiktionary' => 'Vükivödabuk',
	'wg_enwiki' => 'Wikipedia Working Group',
	'wikimaniateamwiki' => 'WikimaniaTeam',
	'xmfwiki' => 'ვიკიპედია',
	'yiwiki' => 'װיקיפּעדיע',
	'yiwikisource' => 'װיקיביבליאָטעק',
	'yiwiktionary' => 'װיקיװערטערבוך',
	'zh-min-nanwikisource' => 'Wiki Tô·-su-kóan',
	'zh_classicalwiki' => '維基大典',
	'zhwikivoyage'  => '维基导游', // bug 59077
	'zh_yuewiki' => '維基百科',
),
# @} end of wgSitename

'wgMaxNameChars' => array(
	'default' => 64,
),

'wgSiteSupportPage' => array(
	'default' => '//wikimediafoundation.org/fundraising',
	'dewiki' => '//wikimediafoundation.org/wiki/Spenden',
	'frwiki' => '//wikimediafoundation.org/wiki/Faites_un_don',
	'frwikibooks' => '//wikimediafoundation.org/wiki/Faites_un_don',
	'frwiktionary' => '//wikimediafoundation.org/wiki/Faites_un_don',
),

'wgUploadPath' => array(
	'default' => '//upload.wikimedia.org/$site/$lang',
	'private' => '/w/img_auth.php',
	'commonswiki' => '//upload.wikimedia.org/wikipedia/commons',
	'labswiki' => '//wikitech.wikimedia.org/w/images',
	'metawiki' => '//upload.wikimedia.org/wikipedia/meta',
	'testwiki' => '//upload.wikimedia.org/wikipedia/test',
),

'wgUploadDirectory' => array(
	# Using upload7 since Oct 2012
	 'default' => '/mnt/upload7/$site/$lang',
	 'private' => '/mnt/upload7/private/$lang',

	 'wikimania2005wiki' => '/mnt/upload7/wikipedia/wikimania', // back compat
	 'otrs_wikiwiki' => '/mnt/upload7/private/otrs_wiki',
	 'execwiki' => '/mnt/upload7/private/execwiki',
	 'transitionteamwiki' => '/mnt/upload7/private/transitionteamwiki',
	 'iegcomwiki' => '/mnt/upload7/private/iegcomwiki',
	 'labswiki' => '/usr/local/apache/images',
),

'wgImgAuthUrlPathMap' => array(
	'default' => array(),
	'private' => array(
		'/timeline/' => 'mwstore://local-multiwrite/timeline-render/'
	)
),

# wgMetaNamespace @{
'wgMetaNamespace' => array(
	// Defaults
	'default'       => 'Wikipedia',
	'wikibooks'	=> 'Wikibooks',
	'wikidata'      => 'Wikidata',
	'wikimania'     => 'Wikimania',
	'wikimedia'     => 'Wikimedia', // chapters
	'wikinews'      => 'Wikinews',
	'wikiquote'     => 'Wikiquote',
	'wikisource'    => 'Wikisource',
	'wikiversity'   => 'Wikiversity',
	'wikivoyage'    => 'Wikivoyage',
	'wiktionary'    => 'Wiktionary',

	// Wikis (alphabetical by DB name)
	'abwiki'	=> 'Авикипедиа',
	'advisorywiki'  => 'Project',
	'amwiki'	=> 'ውክፔዲያ',
	'angwiki'	=> 'Wikipǣdia', // bug 56634
	'angwikisource' => 'Wicifruma',
	'angwiktionary' => 'Wikiwordbōc', // bug 56634
	'arbcom_dewiki' => 'Project',
	'arbcom_enwiki' => 'Project',
	'arbcom_fiwiki' => 'Project',
	'arbcom_nlwiki' => 'Project',
	'arcwiki'	=> 'ܘܝܩܝܦܕܝܐ',
	'arwiki'	=> 'ويكيبيديا', # bug 4672
	'arwikibooks'   => 'ويكي_الكتب',
	'arwikinews'    => 'ويكي_الأخبار',
	'arwikiquote'   => 'ويكي_الاقتباس',
	'arwikisource'  => 'ويكي_مصدر',
	'arwikiversity' => 'ويكي_الجامعة',
	'arwiktionary'  => 'ويكاموس',
	'arzwiki'	=> 'ويكيبيديا',
	'astwiki'       => 'Uiquipedia',
	'astwiktionary' => 'Uiccionariu',
	'aswiki'	=> 'ৱিকিপিডিয়া',
	'aswikisource'	=> 'ৱিকিউৎস', // Bug 43129
	'auditcomwiki'  => 'Project',
	'aywiki'	=> 'Wikipidiya',
	'azwiki'	=> 'Vikipediya',
	'azwikibooks'	=> 'Vikikitab', // bug 31068
	'azwikisource'  => 'VikiMənbə',
	'azwikiquote'   => 'Vikisitat',
	'bawiki'        => 'Википедия', // Bug 41167
	'bat_smgwiki'	=> 'Vikipedėjė',
	'bdwikimedia'   => 'উইকিমিডিয়া_বাংলাদেশ',
	'be_x_oldwiki'  => 'Вікіпэдыя',
	'bewiki'	=> 'Вікіпедыя',
	'bewikisource'  => 'Вікікрыніцы',
	'bgwiki'	=> 'Уикипедия',
	'bgwikibooks'   => 'Уикикниги',
	'bgwikinews'    => 'Уикиновини',
	'bgwikiquote'   => 'Уикицитат',
	'bgwikisource'  => 'Уикиизточник',
	'bgwiktionary'  => 'Уикиречник',
	'bhwiki'	=> 'विकिपीडिया',
	'bjnwiki'	=> 'Wikipidia',
	'bnwiki'	=> 'উইকিপিডিয়া',
	'bnwikibooks'   => 'উইকিবই',
	'bnwikisource'  => 'উইকিসংকলন',
	'bnwiktionary'  => 'উইকিঅভিধান',
	'boardwiki'     => 'Project',
	'bpywiki'       => 'উইকিপিডিয়া',
	'brwikiquote'   => 'Wikiarroud',
	'brwikisource'  => 'Wikimammenn',
	'brwiktionary'  => 'Wikeriadur',
	'bswikibooks'   => 'Wikiknjige',
	'bswikinews'    => 'Wikivijesti', // pre-emptive
	'bswikiquote'   => 'Wikicitati',
	'bswikisource'  => 'Wikizvor',
	'bswiktionary'  => 'Vikirječnik',
	'bxrwiki'	=> 'Википеэди', // Bug 41877
	'cawiki'	=> "Viquip\xc3\xa8dia",
	'cawikibooks'   => 'Viquillibres',
	'cawikimedia'   => 'Project',
	'cawikinews'    => 'Viquinotícies',
	'cawikiquote'   => 'Viquidites',
	'cawikisource'  => 'Viquitexts',
	'cawiktionary'  => 'Viccionari',
	'cewiki'	=> 'Википеди', // Bug 47574
	'chairwiki'     => 'Project',
	'chapcomwiki'   => 'Chapcom',
	'checkuserwiki' => 'Project', // Bug 28781
	'ckbwiki'       => 'ویکیپیدیا',
	'collabwiki'    => 'Project',
	'commonswiki'   => 'Commons',
	'crhwiki'	=> 'Vikipediya',
	'csbwiki'       => 'Wiki',
	'cswiki'	=> 'Wikipedie',
	'cswikibooks'   => 'Wikiknihy',
	'cswikinews'    => 'Wikizprávy',
	'cswikiquote'   => 'Wikicitáty',
	'cswikiversity' => 'Wikiverzita',
	'cswikisource'  => 'Wikizdroje',
	'cswiktionary'  => 'Wikislovník',
	'cuwiki'	=> 'Википєдїꙗ',
	'cvwiki'	=> 'Википеди',
	'cywiki'	=> 'Wicipedia',
	'cywikibooks'   => 'Wicilyfrau',
	'cywikisource'  => 'Wicidestun',
	'cywiktionary'  => 'Wiciadur',
	'donatewiki'    => 'Donate',
	'dsbwiki'       => 'Wikipedija',
	'dvwiki'	=> 'ވިކިޕީޑިއާ', // bug 48075
	'dvwiktionary'	=> 'ވިކިރަދީފު', // Bug 46846
	'elwiki'	=> 'Βικιπαίδεια',
	'elwikibooks'   => 'Βικιβιβλία',
	'elwikinews'    => 'Βικινέα',
	'elwikiquote'   => 'Βικιφθέγματα',
	'elwikisource'  => 'Βικιθήκη',
	'elwikiversity' => 'Βικιεπιστήμιο',
	'elwikivoyage'	=> 'Βικιταξίδια',
	'elwiktionary'  => 'Βικιλεξικό',
	'eowiki'	=> 'Vikipedio',
	'eowikibooks'   => 'Vikilibroj',
	'eowikinews'    => 'Vikinovaĵoj',
	'eowikiquote'   => 'Vikicitaro',
	'eowikisource'  => 'Vikifontaro',
	'eowiktionary'  => 'Vikivortaro',
	'eswikibooks'   => 'Wikilibros',
	'eswikinews'    => 'Wikinoticias',
	'eswikiversity' => 'Wikiversidad',
	'eswikivoyage'	=> 'Wikiviajes', // Bug 42933
	'eswiktionary'  => 'Wikcionario',
	'etwiki'	=> 'Vikipeedia',
	'etwikibooks'   => 'Vikiõpikud',
	'etwikisource'  => 'Vikitekstid',
	'etwikiquote'   => 'Vikitsitaadid',
	'etwiktionary'  => 'Vikisõnastik',
	'execwiki'      => 'Project',
	'extwiki'       => 'Güiquipeya',
	'fawiki'	=> 'ویکی‌پدیا',
	'fawikibooks'   => 'ویکی‌کتاب', // Bug 58655
	'fawikinews'	=> 'ویکی‌خبر',
	'fawikiquote'   => 'ویکی‌گفتاورد',
	'fawikisource'  => 'ویکی‌نبشته',
	'fawikivoyage'  => 'ویکی‌سفر', // bug 71382
	'fawiktionary'  => 'ویکی‌واژه',
	'fiwikibooks'   => 'Wikikirjasto',
	'fiwikinews'    => 'Wikiuutiset',
	'fiwikiquote'   => 'Wikisitaatit',
	'fiwikisource'  => 'Wikiaineisto',
	'fiwikiversity' => 'Wikiopisto',
	'fiwiktionary'  => 'Wikisanakirja',
	'foundationwiki' => 'Wikimedia',
	'fowikisource'  => 'Wikiheimild',
	'frpwiki'	=> 'Vouiquipèdia',
	'frwiki'	=> 'Wikipédia',
	'frwikibooks'   => 'Wikilivres',
	'frwikiversity' => 'Wikiversité',
	'frwiktionary'  => 'Wiktionnaire',
	'furwiki'       => 'Vichipedie',
	'fywiki'	=> 'Wikipedy',
	'gawiki'	=> 'Vicipéid',
	'gagwiki'	=> 'Vikipediya',
	'gawikibooks'   => 'Vicíleabhair',
	'gawikiquote'   => 'Vicísliocht',
	'gawiktionary'  => 'Vicífhoclóir',
	'gdwiki'	=> 'Uicipeid',
	'gnwiki'	=> 'Vikipetã',
	'grantswiki'    => 'Project',
	'guwiki'	=> 'વિકિપીડિયા',
	'guwikisource'  => 'વિકિસ્રોત',
	'guwiktionary'  => 'વિક્શનરી', // Bug 40776
	'hewiki'	=> 'ויקיפדיה',
	'hewikibooks'   => 'ויקיספר',
	'hewikinews'    => 'ויקיחדשות',
	'hewikiquote'   => 'ויקיציטוט',
	'hewikisource'  => 'ויקיטקסט',
	'hewikivoyage'  => 'ויקימסע',
	'hewiktionary'  => 'ויקימילון',
	'hiwiki'	=> 'विकिपीडिया',
	'hiwiktionary'  => 'विक्षनरी',
	'hrwiki'	=> 'Wikipedija',
	'hrwikibooks'   => 'Wikiknjige',
	'hrwikiquote'   => 'Wikicitat',
	'hrwikisource'  => 'Wikizvor',
	'hrwiktionary'  => 'Wječnik',
	'hsbwiki'       => 'Wikipedija',
	'hsbwiktionary' => 'Wikisłownik', // Bug 41328
	'htwiki'	=> 'Wikipedya',
	'htwikisource'  => 'Wikisòrs',
	'huwiki'	=> 'Wikipédia',
	'huwikibooks'   => 'Wikikönyvek',
	'huwikinews'    => 'Wikihírek',
	'huwikiquote'   => 'Wikidézet',
	'huwikisource'  => 'Wikiforrás',
	'huwiktionary'  => 'Wikiszótár',
	'hywiki'	=> 'Վիքիպեդիա',
	'hywikibooks'   => 'Վիքիգրքեր',
	'hywikiquote'   => 'Վիքիքաղվածք',
	'hywikisource'	=> 'Վիքիդարան',
	'hywiktionary'  => 'Վիքիբառարան',
	'iawiktionary'	=> 'Wiktionario',
	'idwikibooks'   => 'Wikibuku',
	'iegcomwiki'    => 'Project',
	'ilwikimedia'   => 'ויקימדיה',
	'incubatorwiki' => 'Incubator',
	'internalwiki'  => 'Project',
	'iowiki'	=> 'Wikipedio',
	'iowiktionary'  => 'Wikivortaro',
	'iswikibooks'   => 'Wikibækur',
	'iswikiquote'   => 'Wikivitnun',
	'iswikisource'  => 'Wikiheimild',
	'iswiktionary'  => 'Wikiorðabók',
	'itwikinews'    => 'Wikinotizie',
	'itwikiversity' => 'Wikiversità',
	'itwiktionary'  => 'Wikizionario',
	'iuwiki'        => 'ᐅᐃᑭᐱᑎᐊ',
	'jawikinews'    => 'ウィキニュース',
	'kawiki'	=> 'ვიკიპედია',
	'kawikibooks'   => 'ვიკიწიგნები',
	'kawikiquote'   => 'ვიკიციტატა',
	'kawiktionary'  => 'ვიქსიკონი',
	'kbdwiki'	=> 'Уикипедиэ',
	'kkwiki'	=> 'Уикипедия',
	'kkwikibooks'   => 'Уикикітап',
	//'kkwikinews'  => 'Уикихабар',
	'kkwikiquote'   => 'Уикидәйек',
	//'kkwikisource' => 'Уикиқайнар',
	'kkwiktionary'  => 'Уикисөздік',
	'kmwiki'	=> 'វិគីភីឌា',
	'knwiki'	=> 'ವಿಕಿಪೀಡಿಯ',
	'koiwiki'	=> 'Википедия',
	'kowiki'	=> '위키백과',
	'kowikinews'	=> '위키뉴스',
	'kowikibooks'	=> '위키책',
	'kowikiquote'	=> '위키인용집',
	'kowikisource'  => '위키문헌',
	'kowiktionary'  => '위키낱말사전',
	'kowikiversity'	=> '위키배움터', // Bug 44899
	'krcwiki'	=> 'Википедия',
	'kuwiki'	=> 'Wîkîpediya',
	'kuwikibooks'   => 'Wîkîpirtûk',
	'kuwikiquote'   => 'Wîkîgotin',
	'kuwiktionary'  => 'Wîkîferheng',
	'kvwiki'	=> 'Википедия',
	'labswiki'	=> 'Wikitech',
	'lawiki'	=> 'Vicipaedia',
	'lawikibooks'   => 'Vicilibri',
	'lawikiquote'   => 'Vicicitatio',
	'lawikisource'  => 'Vicifons',
	'lawiktionary'  => 'Victionarium',
	'ladwiki'	=> 'Vikipedya',
	'lbwiktionary'  => 'Wiktionnaire',
	'lbewiki'       => 'Википедия',
	'legalteamwiki' => 'Project',
	'lezwiki'	=> 'Википедия',
	'liwikibooks'   => 'Wikibeuk',
	'liwikisource'  => 'Wikibrónne',
	'loginwiki'	=> 'Project',
	'lowiki'	=> 'ວິກິພີເດຍ',
	'ltgwiki'	=> 'Vikipedeja',
	'ltwiki'	=> 'Vikipedija',
	'ltwikisource'  => 'Vikišaltiniai',
	'ltwiktionary'	=> 'Vikižodynas',
	'lvwiki'	=> 'Vikipēdija',
	'mdfwiki'       => 'Википедиесь',
	'mediawikiwiki' => 'Project',
	'metawiki'      => 'Meta',
	'mhrwiki'       => 'Википедий',
	'mkwiki'	=> 'Википедија',
	'mkwikimedia'   => 'Викимедија',
	'mlwiki'	=> 'വിക്കിപീഡിയ',
	'mlwikibooks'   => 'വിക്കിപാഠശാല',
	'mlwikiquote'   => 'വിക്കിചൊല്ലുകൾ',
	'mlwikisource'	=> 'വിക്കിഗ്രന്ഥശാല',
	'mlwiktionary'  => 'വിക്കിനിഘണ്ടു',
	'mrjwiki'	=> 'Википеди',
	'mrwiki'	=> 'विकिपीडिया',
	'mrwikisource'  => 'विकिस्रोत',
	'mrwiktionary'  => 'विक्शनरी',
	'mtwiki'	=> 'Wikipedija',
	'mtwiktionary'  => 'Wikizzjunarju',
	'mwlwiki'	=> 'Biquipédia',
	'myvwiki'       => 'Википедиясь',
	'mznwiki'	=> 'ویکی‌پدیا',
	'nahwiki'       => 'Huiquipedia',
	'nds_nlwiki'    => 'Wikipedie',
	'newiki'	=> 'विकिपीडिया',
	'newwiki'       => 'विकिपिडिया',
	'nlwiktionary'  => 'WikiWoordenboek',
	'nowikibooks'   => 'Wikibøker',
	'nowikinews'    => 'Wikinytt',
	'nowikisource'  => 'Wikikilden',
	'nvwiki'	=> 'Wikiibíídiiya',
	'nycwikimedia'  => 'Wikimedia', // http://bugzilla.wikimedia.org/show_bug.cgi?id=29273
	'ocwiki'	=> 'Wikipèdia', # http://bugzilla.wikimedia.org/show_bug.cgi?id=7123
	'ocwikibooks'   => 'Wikilibres',
	'ocwiktionary'  => 'Wikiccionari',
	'officewiki'    => 'OfficeWiki', // bug 64976
	'ombudsmenwiki' => 'Project',
	'orwiki'        => 'ଉଇକିପିଡ଼ିଆ',
	'oswiki'	=> 'Википеди',
	'otrs_wikiwiki' => 'Project',
	'outreachwiki'  => 'Wikimedia',
	'pa_uswikimedia' => 'Project',
	'pawiki'	=> 'ਵਿਕੀਪੀਡੀਆ',
	'plwikiquote'   => 'Wikicytaty',
	'plwikisource'  => 'Wikiźródła',
	'plwikivoyage'  => 'Wikipodróże',
	'plwiktionary'  => 'Wikisłownik',
	'pnbwiktionary' => 'وکشنری',
	'pntwiki'       => 'Βικιπαίδεια',
	'pswiki'	=> 'ويکيپېډيا' ,
	'pswikibooks'	=> 'ويکيتابونه' ,
	//'pswikiquote'	=> 'ويکيوراشه' ,
	'pswiktionary'	=> 'ويکيسيند' ,
	'ptwiki'        => 'Wikipédia',
	'ptwikibooks'   => 'Wikilivros',
	'ptwikinews'    => 'Wikinotícias',
	'ptwikiversity' => 'Wikiversidade',
	'ptwiktionary'  => 'Wikcionário',
	'qualitywiki'   => 'Project',
	'rmywiki'       => 'Vikipidiya',
	'rowikibooks'	=> 'Wikimanuale',
	'rowikinews'    => 'Wikiștiri',
	'rowikiquote'   => 'Wikicitat',
	'rowiktionary'  => 'Wikționar',
	'rswikimedia'   => 'Викимедија',
	'ruewiki'	=> 'Вікіпедія',
	'ruwiki'	=> 'Википедия',
	'ruwikibooks'   => 'Викиучебник',
	'ruwikimedia'   => 'Викимедиа',
	'ruwikinews'    => 'Викиновости',
	'ruwikiquote'   => 'Викицитатник',
	'ruwikisource'  => 'Викитека',
	'ruwikiversity' => 'Викиверситет',
	'ruwiktionary'  => 'Викисловарь',
	'sawiki'	=> 'विकिपीडिया',
	'sawikiquote'   => 'विकिसूक्तिः',
	'sahwiki'       => 'Бикипиэдьийэ',
	'sahwikisource' => 'Бикитиэкэ',
	'scnwiktionary' => 'Wikizziunariu',
	'searchcomwiki' => 'SearchCom',
	'siwiki'	=> 'විකිපීඩියා',
	'siwikibooks'	=> 'විකිපොත්',
	'siwiktionary'	=> 'වික්ෂනරි',
	'skwiki'	=> 'Wikipédia',
	'skwikibooks'   => 'Wikiknihy',
	'skwikiquote'   => 'Wikicitáty',
	'skwikisource'  => 'Wikizdroje',
	'skwiktionary'  => 'Wikislovník',
	'slwiki'	=> 'Wikipedija',
	'slwikibooks'   => 'Wikiknjige',
	'slwikiquote'   => 'Wikinavedek',
	'slwikisource'  => 'Wikivir',
	'slwiktionary'  => 'Wikislovar',
	'slwikiversity' => 'Wikiverza',
	'sourceswiki'   => 'Wikisource',
	'spcomwiki'     => 'Spcom',
	'specieswiki'   => 'Wikispecies',
	'sqwikinews'	=> 'Wikilajme',
	'srwiki'	=> 'Википедија',
	'srwikibooks'   => 'Викикњиге',
	'srwikinews'    => 'Викивести',
	'srwikisource'  => 'Викизворник',
	'srwiktionary'  => 'Викиречник',
	'stewardwiki'   => 'Project',
	'strategywiki'  => 'Strategic_Planning',
	'szlwiki'       => 'Wikipedyjo',
	'tawiki'	=> 'விக்கிப்பீடியா',
	'tawikibooks'	=> 'விக்கிநூல்கள்',
	'tawikinews'	=> 'விக்கிசெய்தி',
	'tawikisource'  => 'விக்கிமூலம்',
	'tawiktionary'	=> 'விக்சனரி',
	'tawikiquote'   => 'விக்கிமேற்கோள்',
	'tewiki'	=> 'వికీపీడియా',
	'tewikisource'  => 'వికీసోర్స్',
	'tewiktionary'  => 'విక్షనరీ',
	'tgwiki'	=> 'Википедиа',
	'thwiki'	=> 'วิกิพีเดีย',
	'thwikibooks'   => 'วิกิตำรา',
	'thwiktionary'  => 'วิกิพจนานุกรม',
	'thwikinews'    => 'วิกิข่าว',
	'thwikiquote'   => 'วิกิคำคม',
	'thwikisource'  => 'วิกิซอร์ซ',
	'tkwiki'	=> 'Wikipediýa',
	'tkwiktionary'	=> 'Wikisözlük',
	'transitionteamwiki' => 'Project',
	'trwiki'	=> 'Vikipedi',
	'trwikibooks'   => 'Vikikitap',
	'trwikinews'    => 'Vikihaber',
	'trwikiquote'   => 'Vikisöz',
	'trwikisource'  => 'Vikikaynak', // Bug 42721
	'trwiktionary'  => 'Vikisözlük',
	'ttwiki'	=> 'Википедия',
	'tyvwiki'	=> 'Википедия', // bug 49328
	'uawikimedia'   => 'Вікімедіа',
	'udmwiki'	=> 'Википедия', // Bug 47820
	'ukwiki'	=> 'Вікіпедія',
	'ukwikibooks'	=> 'Вікіпідручник',
	'ukwikinews'	=> 'Вікіновини', // bug 48843
	'ukwikiquote'   => 'Вікіцитати',
	'ukwikisource'	=> 'Вікіджерела', // bug 48308
	'ukwikivoyage'  => 'Вікімандри',
	'ukwiktionary'  => 'Вікісловник',
	'urwiki'	=> 'ویکیپیڈیا',
	'urwikibooks'   => 'وکی_کتب',
	'urwikiquote'   => 'وکی_اقتباسات',
	'urwiktionary'  => 'وکی_لغت',
	'uzwiki'	=> 'Vikipediya',
	'uzwikibooks'	=> 'Vikikitob',
	'uzwikiquote'   => 'Vikiiqtibos',
	//'uzwikisource' => 'Vikimanba',
	'uzwiktionary'	=> 'Vikilug‘at',
	'vecwiktionary' => 'Wikisionario',
	'vepwiki'       => 'Vikipedii',
	'vowiki'	=> 'Vükiped',
	'vowikibooks'	=> 'Vükibuks',
	'vowiktionary'	=> 'Vükivödabuk',
	'wikimaniateamwiki' => 'WikimaniaTeam',
	'xmfwiki'	=> 'ვიკიპედია',
	'yiwiki'	=> 'װיקיפּעדיע',
	'yiwikisource'  => 'װיקיביבליאָטעק',
	'yiwiktionary'  => 'װיקיװערטערבוך',
	'zerowiki'      => 'Project',
	'zh-min-nanwikisource' => 'Wiki_Tô·-su-kóan',
	'zh_classicalwiki' => '維基大典',
),
# @} end of wgMetaNamespace

# wgMetaNamespaceTalk @{
'wgMetaNamespaceTalk' => array(
	'angwiki'       => 'Wikipǣdiamōtung', // bug 56634
	'angwiktionary' => 'Wikiwordbōcmōtung', // bug 56634
	'arwikiversity' => 'نقاش_ويكي_الجامعة',
	'aswiki' 	=> 'ৱিকিপিডিয়া_বাৰ্তা',
	'aswikisource'  => 'ৱিকিউ স_বাৰ্তা', // Bug 43129
	'aywiki' 	=> 'Wikipidiyan_Aruskipäwi',
	'bat_smgwiki' 	=> 'Vikipedėjės_aptarėms',
	'bbdwikimedia'  => 'উইকিমিডিয়া_বাংলাদেশ_আলোচনা',
	'bewikisource'  => 'Размовы_пра_Вікікрыніцы',
	'cuwiki' 	=> 'Википєдїѩ_бєсѣ́да',
	'elwikinews'    => 'Βικινέα_συζήτηση',
	'elwikiversity' => 'Συζήτηση_Βικιεπιστημίου',
	'elwiktionary'  => 'Συζήτηση_βικιλεξικού',
	'eowiki'       	=> 'Vikipedia_diskuto',
	'eowikinews'	=> 'Vikinovaĵoj_diskuto',
	'eowikisource'  => 'Vikifontaro_diskuto',
	'fawikinews' 	=> 'بحث_ویکی‌خبر',
	'fawikisource' 	=> 'بحث_ویکی‌نبشته',
	'fawikivoyage' 	=> 'بحث_ویکی‌سفر', // bug 71382
	'fiwikiversity' => 'Keskustelu_Wikiopistosta',
	'gagwiki'	=> 'Vikipediyanın_laflanması',
	'guwikisource' 	=> 'વિકિસ્રોત_ચર્ચા',
	'hrwikisource' 	=> 'Razgovor_o_Wikizvoru',
	'hsbwiktionary' => 'Diskusija_k_Wikisłownikej', // Bug 41328
	'huwikinews' 	=> 'Wikihírek-vita',
	'iswiktionary' 	=> 'Wikiorðabókarspjall',
	'kbdwiki'	=> 'Уикипедиэм_и_тепсэлъыхьыгъуэ',
	'kmwiki'	=> 'ការពិភាក្សាអំពីវិគីភីឌា',
	'koiwiki'	=> 'Баитам_Википедия_йылiсь',
	'kowikinews'	=> '위키뉴스토론',
	'kowikiquote'	=> '위키인용집토론',
	'kvwiki'	=> 'Википедия_донъялӧм',
	'lawikisource' 	=> 'Disputatio_Vicifontis',
	'lezwiki'	=> 'Википедия_веревирд_авун',
	'liwikibooks'	=> 'Euverlèk_Wikibeuk',
	'lowiki'	=> 'ສົນທະນາກ່ຽວກັບວິກິພີເດຍ',
	'ltgwiki'	=> 'Vikipedejis_sprīža',
	'ltwiki'	=> 'Vikipedijos_aptarimas',
	'ltwiktionary'  => 'Vikižodyno_aptarimas',
	'lvwiki'	=> 'Vikipēdijas_diskusija',
	'mrjwiki'	=> 'Википедим_кӓнгӓшӹмӓш',
	'mznwiki'       => 'ویکی_پدیا_گپ',
	'newiki'	=> 'विकिपीडिया_वार्ता',
	'newwiki' 	=> 'विकिपिडिया_खँलाबँला',
	'noboard_chapterswikimedia' => 'Wikimedia-diskusjon',
	'nsowiki'	=> 'Dipolelo_tša_Wikipedia',
	'pnbwiktionary' => 'گل_ات',
	'pntwiki'       => 'Βικιπαίδεια_καλάτσεμαν',
	'ruewiki'	=> 'Діскузія_ку_Вікіпедії',
	'ruwikibooks' 	=> 'Обсуждение_Викиучебника',
	'ruwikimedia' 	=> 'Обсуждение_Викимедиа',
	'ruwikiversity' => 'Обсуждение_Викиверситета',
	'sahwiki' 	=> 'Бикипиэдьийэ_ырытыыта',
	'sahwikisource' => 'Бикитиэкэ_Ырытыы',
	'siwiki'	=> 'විකිපීඩියා_සාකච්ඡාව',
	'siwikibooks'	=> 'විකිපොත්_සාකච්ඡාව',
	'siwiktionary'	=> 'වික්ෂනරි_සාකච්ඡාව',
	'skwikibooks' 	=> 'Diskusia_k_Wikiknihám',
	'skwikisource' 	=> 'Diskusia_k_Wikizdrojom',
	'slwikiversity' => 'Pogovor_o_Wikiverzi',
	'srwiki' 	=> 'Разговор_о_Википедији',
	'srwikibooks' 	=> 'Разговор_о_викикњигама',
	'srwikinews' 	=> 'Разговор_о_Викивестима',
	'srwikisource' 	=> 'Разговор_о_Викизворнику',
	'srwiktionary' 	=> 'Разговор_о_викиречнику',
	'svwikiversity' => 'Wikiversitydiskussion',
	'tawiki'	=> 'விக்கிப்பீடியா_பேச்சு',
	'tawikinews'	=> 'விக்கிசெய்தி_பேச்சு',
	'tawikisource'  => 'விக்கிமூலம்_பேச்சு',
	'tawiktionary'	=> 'விக்சனரி_பேச்சு',
	'thwikibooks'   => 'คุยเรื่องวิกิตำรา', // Bug 40717
	'thwikiquote'   => 'คุยเรื่องวิกิคำคม',
	'thwiktionary'  => 'คุยเรื่องวิกิพจนานุกรม', // Bug 40717
	'tyvwiki'	=> 'Википедия_дугайында_сүмелел', // bug 49328
	'uawikimedia'   => 'Обговорення_Вікімедіа',
	'ukwiktionary'  => 'Обговорення_Вікісловника',
	'ukwikinews'	=> 'Обговорення_Вікіновин', // bug 48843
	'vepwiki'      	=> 'Paginad_Vikipedii',
	'xmfwiki'	=> 'ვიკიპედია_სხუნუა',
),
# @} end of wgMetaNamespaceTalk

# wgNamespaceAliases @{
'wgNamespaceAliases' => array(
	// defaults to aid when things are switched
	'+wikibooks' => array( 'Wikibooks' => NS_PROJECT ),
	'+wikinews' => array( 'Wikinews' => NS_PROJECT ),
	'+wikiquote' => array( 'Wikiquote' => NS_PROJECT ),
	'+wikisource' => array( 'Wikisource' => NS_PROJECT ),
	'+wikiversity' => array( 'Wikiversity' => NS_PROJECT ),
	'+wikipedia' => array( 'Wikipedia' => NS_PROJECT ),
	'+wiktionary' => array( 'Wiktionary' => NS_PROJECT ),
	'+wikivoyage' => array(
		'Wikivoyage' => NS_PROJECT,
		'WV' => NS_PROJECT,
	),
	'+abwiki' => array(
		'Wikipedia' => NS_PROJECT,
	),
	'+angwiki' => array( // bug 56634, 58711
		'Wikipedia' => NS_PROJECT,
		'Wikipedia_talk' => NS_PROJECT_TALK,
		'Wikipaedia' => NS_PROJECT,
		'Wikipædiamotung' => NS_PROJECT_TALK,
		'Wikipaediamotung' => NS_PROJECT_TALK,
		'Wikipædia' => NS_PROJECT,
		'Wicipǣdia' => NS_PROJECT,
		'Wicipædia' => NS_PROJECT,
		'Wicipaedia' => NS_PROJECT,
		'Ƿikipǣdia' => NS_PROJECT,
		'Ƿikipædia' => NS_PROJECT,
		'Ƿikipaedia' => NS_PROJECT,
		'Ƿicipǣdia' => NS_PROJECT,
		'Ƿicipædia' => NS_PROJECT,
		'Ƿicipaedia' => NS_PROJECT,
		'Wicipǣdiamōtung' => NS_PROJECT_TALK,
		'Wicipædiamotung' => NS_PROJECT_TALK,
		'Wicipaediamotung' => NS_PROJECT_TALK,
		'Ƿikipǣdiamōtung' => NS_PROJECT_TALK,
		'Ƿikipædiamotung' => NS_PROJECT_TALK,
		'Ƿikipaediamotung' => NS_PROJECT_TALK,
		'Ƿicipǣdiamōtung' => NS_PROJECT_TALK,
		'Ƿicipædiamotung' => NS_PROJECT_TALK,
		'Ƿicipaediamotung' => NS_PROJECT_TALK,
	),
	'+angwiktionary' => array( // bug 56634, 58711
		'Wiktionary' => NS_PROJECT,
		'Wiktionary_talk' => NS_PROJECT_TALK,
		'Wikiwordboc' => NS_PROJECT,
		'Wikiwordbocmotung' => NS_PROJECT_TALK,
		'Wiciwordbōc' => NS_PROJECT,
		'Wiciwordboc' => NS_PROJECT,
		'Ƿikiƿordbōc' => NS_PROJECT,
		'Ƿikiƿordboc' => NS_PROJECT,
		'Ƿiciƿordbōc' => NS_PROJECT,
		'Ƿiciƿordboc' => NS_PROJECT,
		'Wiciwordbōcmōtung' => NS_PROJECT_TALK,
		'Wiciwordbocmotung' => NS_PROJECT_TALK,
		'Ƿikiƿordbōcmōtung' => NS_PROJECT_TALK,
		'Ƿikiƿordbocmotung' => NS_PROJECT_TALK,
		'Ƿiciƿordbōcmōtung' => NS_PROJECT_TALK,
		'Ƿiciƿordbocmotung' => NS_PROJECT_TALK,
		'Æteaca' => 100,
		'Æteacmotung' => 101,
		'Aeteaca' => 100,
		'Aeteacmotung' => 101,
	),
	'+arcwiki' => array(
		'Wikipedia' => NS_PROJECT,
	),
	'+arwiki' => array(
		'وب' => NS_PROJECT,
		'نو' => NS_PROJECT_TALK,
	),
	'+arwikinews' => array(
		'وخ' => NS_PROJECT,
		'نو' => NS_PROJECT_TALK,
	),
	'+arwikisource' => array(
		'Author' => 102,
		'Author_talk' => 103,
		'Page' => 104,
		'Page_talk' => 105,
		'وم' =>   NS_PROJECT,
		'نو' => NS_PROJECT_TALK,
	),
	'+arwikiversity' => array(
		'وج' => NS_PROJECT
	),
	'+arzwiki' => array(
		'Portal' => 100,
		'Portal_talk' => 101,
	),
	'+aswiki' => array(
		'Wikipedia' => NS_PROJECT,
		'Wikipedia_talk' => NS_PROJECT_TALK,
		'প্ৰকল্প' => NS_PROJECT,
		'প্ৰকল্প_আলোচনা' => NS_PROJECT_TALK,
		'Wikipedia_বার্তা' => NS_PROJECT_TALK,
		'WP' => NS_PROJECT,
		'CAT' => NS_CATEGORY,
		"বাটচ'ৰা" => 100,
		"বাটচ'ৰা_আলোচনা" => 101,
	),
	'+aswikisource' => array(
		'Author' => 102, // bug 70464
		'Author_talk' => 103, // bug 70464
		'লিখক' => 102, // bug 70464
		'লিখক_আলোচনা' => 103, // bug 70464
	),
	'+azwikibooks' => array(
		'Wikibooks_müzakirəsi' => NS_PROJECT_TALK, // bug 31068
		'Wikibooks_talk' => NS_PROJECT_TALK, // bug 31068
	),
	'+azwikiquote' => array(
		'Wikiquote_talk' => NS_PROJECT_TALK,
	),
	'+azwikisource' => array(
		'Portal' => 100,
		'Portal_talk' => 101,
	),
	'+bawiki' => array(
		'Wikipedia' => NS_PROJECT,                         // Bug 41167
		'Wikipedia_буйынса_фекерләшеү' => NS_PROJECT_TALK,
	),
	'+barwiki' => array(
		'Portal_Diskussion' => 101, // Bug 41962 - now "Portal Dischkrian"
	),
	'+betawikiversity' => array(
		'Aptarimas' => NS_TALK,
		'Naudotojas' => NS_USER,
		'Naudotojo_aptarimas' => NS_USER_TALK,
		'Vikiversitetas' => NS_PROJECT,
		'Vikiversiteto_aptarimas' => NS_PROJECT_TALK,
		'Vaizdas' => NS_FILE,
		'Vaizdo_aptarimas' => NS_FILE_TALK,
		'MediaWiki_aptarimas' => NS_MEDIAWIKI_TALK,
		'Šablonas' => NS_TEMPLATE,
		'Šablono_aptarimas' => NS_TEMPLATE_TALK,
		'Pagalba' => NS_HELP,
		'Pagalbos_aptarimas' => NS_HELP_TALK,
		'Kategorija' => NS_CATEGORY,
		'Kategorijos_aptarimas' => NS_CATEGORY_TALK,
	), // Bug 64080
	'+bewiki' => array(
		'Portal' => 100,
		'Portal_talk' => 101,
		'ВП' => NS_PROJECT,
	),
	'+be_x_oldwiki' => array(
		'ВП' => NS_PROJECT,
	),
	'+bewikisource' => array(
		'ВК' => NS_PROJECT,     // Bug 41322
		'Author' => 102,        // Bug 41322
		'Author_talk' => 103,
	),
	'+bgwikisource' => array(
		'Author' => 100,
		'Author_talk' => 101,
	),
	'+bjnwiki' => array(
		'Wikipidia_pamandiran' => NS_PROJECT_TALK,
	),
	'+bnwiki' => array(
		'Portal' => 100,
		'Portal_talk' => 101,
		'കവാടം' => 100,
		'കവാടത്തിന്റെ_സംവാദം' => 101,
		'Wikipedia' => NS_PROJECT,
		'WP' => NS_PROJECT,
		'WT' => NS_PROJECT_TALK,
		'വിഭാഗം' => NS_CATEGORY,
		'വിഭാഗത്തിന്റെ_സംവാദം' => NS_CATEGORY_TALK,
	),
	'+bnwikibooks' => array(
		'WB' => NS_PROJECT,
		'Wikijunior' => 100,
		'wikijunior_talk' => 101,
		'Subject' => 102,
		'Subject_talk' => 103,
	),
	'+bnwikisource' => array( // bug 57134
		'WS' => NS_PROJECT,
		'Author' => 100, // bug 59901
		'Author_talk' => 101, // bug 59901
		'Portal' => 106, // bug 59901
		'Portal_talk' => 107, // bug 59901
	),
	'+bpywiki' => array(
		'Portal' => 100,
		'Portal_talk' => 101,
	),
	'+brwiki' => array(
		'Discussion_Wikipedia' => NS_PROJECT_TALK,
	),
	'+brwikisource' => array(
		'Author' => 104,
		'Author_talk' => 105,
	),
	'+brwiktionary' => array(
		'Wiktionary_talk' => NS_PROJECT_TALK,
	),
	'+cawiki' => array(
		'Usuària' => NS_USER,
		'Usuària_discussió' => NS_USER_TALK,
	),
	'+bswiki' => array(
		'Portal_talk' => 101, // Bug 37226
	),
	'+cawikisource' => array(
		'Author' => 106,
		'Author_talk' => 107,
	),
	'+cewiki' => array( // Bug 47574
		'Википедийа' => NS_PROJECT,
		'Википедийа_дийцаре' => NS_PROJECT_TALK,
	),
	'+ckbwiki' => array(
		'وپ' => NS_PROJECT, // bug 51605
		'WP' => NS_PROJECT, //bug 69594
		'لو' => NS_PROJECT_TALK, //bug 69594
		'WT' => NS_PROJECT_TALK, //bug 69594
		'ب' => NS_USER, //bug 69594
		'U' => NS_USER, //bug 69594
		'لب' => NS_USER_TALK, //bug 69594
		'UT' => NS_USER_TALK, //bug 69594
		'پ' => NS_CATEGORY, //bug 69594
		'د' => NS_TEMPLATE, //bug 69594
		'T' => NS_TEMPLATE, //bug 69594
		'مو' => NS_MEDIAWIKI, //bug 69594
		'ی' => NS_HELP, //bug 69594
		'H' => NS_HELP, //bug 69594
		'وپر' => 102, // bug 52665
		'Wikiproject' => 102, // bug 52665
		'Wikiproject_talk' => 103, // bug 52665
		'Portal' => 100, //bug 69594
		'Portal_talk' => 101, //bug 69594
	),
	'+commonswiki' => array(
		'Museum' => 106,
		'Museum_talk' => 107,
		'COM' => NS_PROJECT, // bug 12600
	),
	'+cswiki' => array(
		'Uživatel' => NS_USER,
		'Wikipedistka' => NS_USER,
		'Diskuse_s_uživatelem' => NS_USER_TALK,
		'Diskuse_s_wikipedistkou' => NS_USER_TALK,
		'Wikipedista_diskuse' => NS_USER_TALK,
		'Wikipedistka_diskuse' => NS_USER_TALK,
		'WP'  => NS_PROJECT,
		'Portal' => 100,
		'Portal_talk' => 101,
		'Portál_diskuse' => 101,
		'Rejstřík_diskuse' => 103,
	),
	'+cswikibooks' => array(
		'WB' => NS_PROJECT,
		'WK' => NS_PROJECT,
		'Wikibooks_diskuse' => NS_PROJECT_TALK,
		'Wikibooks_talk' => NS_PROJECT_TALK,
	),
	'+cswikinews' => array(
		'Redaktorka' => NS_USER,
		'Uživatel' => NS_USER,
		'Diskuse_s_redaktorkou' => NS_USER_TALK,
		'Diskuse_s_uživatelem' => NS_USER_TALK,
		'Redaktor_diskuse' => NS_USER_TALK,
		'Redaktorka_diskuse' => NS_USER_TALK,
		'WN' => NS_PROJECT,
		'WZ' => NS_PROJECT,
		'Wikinews_diskuse' => NS_PROJECT_TALK,
		'Wikinews_talk' => NS_PROJECT_TALK,
	),
	'+cswikiquote' => array(
		'WC' => NS_PROJECT,
		'WQ' => NS_PROJECT,
		'Wikiquote_diskuse' => NS_PROJECT_TALK,
		'Wikiquote_talk' => NS_PROJECT_TALK,
		'Dílo_diskuse' => 101,
	),
	'+cswikisource' => array(
		'WS' => NS_PROJECT,
		'WZ' => NS_PROJECT,
		'Wikisource_diskuse' => NS_PROJECT_TALK,
		'Wikisource_talk' => NS_PROJECT_TALK,
		'Author' => 100,
		'Author_talk' => 101,
		'Autor_diskuse' => 101,
	),
	'+cswikiversity' => array(
		'WV' => NS_PROJECT,
		'Wikiversity_diskuse' => NS_PROJECT_TALK,
		'Wikiversity_talk' => NS_PROJECT_TALK,
		'Forum' => 100,
		'Forum_talk' => 101,
		'Fórum_diskuse' => 101,
	),
	'+cswiktionary' => array(
		'WS' => NS_PROJECT,
		'WT' => NS_PROJECT,
		'Wiktionary_diskuse' => NS_PROJECT_TALK,
		'Wiktionary_talk' => NS_PROJECT_TALK,
		'Příloha_diskuse' => 101,
	),
	'+cuwiki' => array(
		'Шаблон' => NS_TEMPLATE,
		'Категория' => NS_CATEGORY,
		'Участник' => NS_USER,
		'Википє́дїꙗ' => NS_PROJECT,
		'Википє́дїѩ_бєсѣ́да' => NS_PROJECT_TALK,
	),
	'+cywikisource' => array(
		'Wicitestun' => NS_PROJECT,
		'Sgwrs_Wicitestun' => NS_PROJECT_TALK,
	),
	'+dawiki' => array(
		'WP' => NS_PROJECT, // bug 27998
		'Portal_diskussion' => 101, // bug 7759
	),
	'+dawikisource' => array(
		'Author' => 102, // bug 7796
		'Author_talk' => 103,
	),
	'+dewiki' => array(
		'WP' => NS_PROJECT,
		'P' => 100,
		'PD' => 101,
		'WD' => NS_PROJECT_TALK,
		'BD' => NS_USER_TALK,
		'H' => NS_HELP,
		'HD' => NS_HELP_TALK,
	),
	'+dewikinews' => array(
		'Comments' => 102,
		'Comments_talk' => 103,
	),
	'+dewikiquote' => array(
		'WQ' => NS_PROJECT,
		'BD' => NS_USER_TALK,
	),
	'+dewikisource' => array(
		'WS' => NS_PROJECT,
	),
	'+dewikivoyage' => array( // bug 51794
		'WV' => NS_PROJECT,
		'WD' => NS_PROJECT_TALK,
		'BN' => NS_USER,
		'BD' => NS_USER_TALK,
		'H' => NS_HELP,
		'HD' => NS_HELP_TALK,
		'P' => 100, // Portal
		'PD' => 101, // Portal Diskussion
		'T' => 104, // Thema
		'TD' => 105, // Thema Diskussion
		'NR' => 106, // Nachrichten
		'ND' => 107, // Nachrichten Diskussion
		'News' => 106,
		'News_Diskussion' => 107,
	),
	'+dewiktionary' => array(
		'WT' => NS_PROJECT,
		'WikiSaurus' => 104,
		'WikiSaurus_Diskussion' => 105,
		'BD' => NS_USER_TALK,
	),
	'+dvwiki' => array(
		'Wikipedia_talk' => NS_PROJECT_TALK, // bug 48075
		'Portal' => 100,
		'Portal_talk' => 101,
	),
	'+dvwiktionary' => array(
		'Wiktionary_talk' => NS_PROJECT_TALK, // Bug 46846
	),
	'+enwiki' => array( // bug 6313
		'WP' => NS_PROJECT,
		'WT' => NS_PROJECT_TALK,
	),
	'+enwikibooks' => array(
		'WB' => NS_PROJECT,
		'WJ' => 110,
		'CAT' => NS_CATEGORY,
		'COOK' => 102,
		'SUB' => 112,
	),
	'+enwikinews' => array(
		'WN' => NS_PROJECT,
		'CAT' => NS_CATEGORY,
	),
	'+enwikisource' => array(
		'WS' => NS_PROJECT, // bug 42853
		'WT' => NS_PROJECT_TALK, // bug 42853
	),
	'+enwikiversity' => array(
		'WV' => NS_PROJECT,
	),
	'+enwiktionary' => array(
		'WS' => 110, // Wikisaurus
		'WT' => NS_PROJECT,
	),
	'+eowiki' => array(
		'VP' => NS_PROJECT,
	),
	'+eowiktionary' => array(
		'Vikipediisto' => NS_USER, // bug 22426
		'Vikipediista_diskuto' => NS_USER_TALK, // bug 22426
	),
	'+eswikisource' => array(
		'Auxtoro' => 102,
		'Auxtoro-Diskuto' => 103,
	),
	'+etwiki' => array(
		'Portal' => 100,
		'Portal_talk' => 101,
	),
	'+etwikisource' => array(
		'Author' => 106,
		'Author_talk' => 107,
	),
	'+fawiki' => array(
		'كاربر' => NS_USER,
		'بحث كاربر' => NS_USER_TALK,
		'وپ' => NS_PROJECT,
		'ویکی پدیا' => NS_PROJECT,
		'ويكي پديا' => NS_PROJECT,
		'ويکي‌پديا' => NS_PROJECT,
		'بحث ویکی پدیا' => NS_PROJECT_TALK,
		'بحث ويکي پديا' => NS_PROJECT_TALK,
		'بحث ويکي‌پديا' => NS_PROJECT_TALK,
		'Book' => 102,
		'Book_talk' => 103,
		'كتاب' => 102,
		'بحث_كتاب' => 103,
	),
	'+fawikibooks' => array(
		'وک' => NS_PROJECT,
	),
	'+fawikinews' => array(
		'وخ' => NS_PROJECT,
	),
	'+fawikisource' => array(
		'Portal' => 100,
		'Portal_talk' => 101,
		'Author' => 102,
		'Author_talk' => 103,
		'پدیدآورنده' => 102,
		'گفتگو_پدیدآورنده' => 103,
		'ون' => NS_PROJECT,
	),
	'+fawikivoyage' => array(
		'وس' => NS_PROJECT,
		'عب' => 106,
	), // bug 71668
	'+fawiktionary' => array(
		'وو' => NS_PROJECT,
	),
	'+fiwiki' => array(
		'WP' => NS_PROJECT,
	),
	'+frwiki' => array(
		'Wikipedia' => NS_PROJECT,
		'WP' => NS_PROJECT,
		'Discussion_Wikipedia' => NS_PROJECT_TALK,
		'Utilisatrice' => NS_USER,
		'Discussion_Utilisatrice' => NS_USER_TALK,
	),
	'+frwikibooks' => array(
		'WL' => NS_PROJECT, // bug 35977
		'WJ' => 102, // bug 35977
		'Wikijunior_talk' => 103, // bug 35977
	),
	'+frwikinews' => array(
		'WN' => NS_PROJECT,
	),
	'+frwikisource' => array(
		'Author' => 102,
		'Author_talk' => 103,
	),
	'+frwiktionary' => array(
		'WT' => NS_PROJECT,
	),
	'+gdwiki' => array(
		'Wikipedia' => NS_PROJECT,
		'Wikipedia_talk' => NS_PROJECT_TALK,
	),
	'+glwiki' => array(
		'Portal_talk' => 101, // Bug 41213 (old namespace name)
	),
	'+guwiktionary' => array(
		'વિક્શનરી' => NS_PROJECT // Bug 40776 (old namespace name)
	),
	'+hewikisource' => array(
		'Author' => 108,
		'Author_talk' => 109,
		'באור' => 106,
		'שיחת_באור' => 107,
	),
	'+hiwiki' => array(
		'वि' => NS_PROJECT,
		'विवा' => NS_PROJECT_TALK,
		'Wikipedia' => NS_PROJECT,
		'WP' => NS_PROJECT,
		'WPT' => NS_PROJECT_TALK,
		'U' => NS_USER,
		'UT' => NS_USER_TALK,
		'स' => NS_USER,
		'सवा' => NS_USER_TALK,
		'श्र' => NS_CATEGORY,
		'श्रवा' => NS_CATEGORY_TALK,
		'CT' => NS_CATEGORY_TALK,
		'सा' => NS_TEMPLATE,
		'सावा' => NS_TEMPLATE_TALK,
		'T' => NS_TEMPLATE,
		'मी' => NS_MEDIAWIKI,
		'मीवा' => NS_MEDIAWIKI_TALK,
		'P' => 100,
		'प्र' => 100,
		'प्रवा' => 101,
	),
	'+hrwikisource' => array(
		'Author' => 100,
		'Author_talk' => 101,
	),
	'+hsbwiktionary' => array(
		'Wiktionary diskusija' => NS_PROJECT_TALK,
	),
	'+htwiki' => array(
		'Wikipedia' => NS_PROJECT,
		'Wikipedia_talk' => NS_PROJECT_TALK,
	),
	'+huwiki' => array(
		'Portál_vita' => 101,
	),
	'+huwikinews' => array(
		'Wikihírek_vita' => NS_PROJECT_TALK,
		'Portál_vita' => 103,
	),
	'+huwikisource' => array(
		'Author' => 100,
		'Author_talk' => 101,
	),
	'+huwiktionary' => array(
		'Függelék_vita' => 101, // Bug 42505
		'Index_vita' => 103,
	),
	'+hywikibooks' => array( // bug 53162
		'Cookbook' => 102,
		'Cookbook_talk' => 103,
		'Wikijunior' => 110,
		'Wikijunior_talk' => 111,
	),
	'+hywikisource' => array(
		'Author' => 100,
		'Author_talk' => 101,
	),
	'+idwikibooks' => array(
		'Pembicaraan_Wikibooks' => NS_PROJECT_TALK, // bug 36156
	),
	'+idwikisource' => array(
		'Author' => 100,
		'Author_talk' => 101,
	),
	'+ilowiki' => array(
		'WP' => NS_PROJECT, // bug 38247
		'WT' => NS_PROJECT_TALK, // bug 38247
	),
	'+iowiki' => array(
		'Wikipedia' => NS_PROJECT,
		'Wikipedia_talk' => NS_PROJECT_TALK,
	),
	'+incubatorwiki' => array(
		'I' => NS_PROJECT,
	),
	'+iswikisource' => array(
		'Portal' => 100, // Bug 44164
		'Portal_talk' => 101, // Bug 44164
		'Author' => 102, // Bug 44164
		'Author_talk' => 103, // Bug 44164
	),
	'+iswiktionary' => array(
		'Wikiorðabókspjall' => NS_PROJECT_TALK, // bug 7754
		'Thesaurus' => 110,
		'Thesaurus_talk' => 111,
	),
	'+itwiki' => array(
		'WP' => NS_PROJECT, // 15116
	),
	'+itwikibooks' => array(
		'Portale' => 100,
		'Discussioni_portale' => 101,
		'Shelf' => 102,
		'Shelf_talk' => 103,
		'WB' => NS_PROJECT,
	),
	'+itwikisource' => array(
		'Author' => 102,
		'Author_talk' => 103,
	),
	'+itwiktionary' => array(
		'WZ' => NS_PROJECT,
	),
	'+iuwiki' => array(
		'Wikipedia' => NS_PROJECT,
		'Wikipedia_talk' => NS_PROJECT_TALK,
	),
	'+jawiki' => array(
		'トーク' => NS_TALK,
		'利用者・トーク' => NS_USER_TALK,
		'Wikipedia・トーク' => NS_PROJECT_TALK,
		'ファイル・トーク' => NS_IMAGE_TALK,
		'MediaWiki・トーク' => NS_MEDIAWIKI_TALK,
		'テンプレート' => NS_TEMPLATE,
		'テンプレート・トーク' => NS_TEMPLATE_TALK,
		'ヘルプ' => NS_HELP,
		'ヘルプ・トーク' => NS_HELP_TALK,
		'カテゴリ' => NS_CATEGORY,
		'カテゴリ・トーク' => NS_CATEGORY_TALK,
		"ポータル‐ノート" => 101,
		'Portal‐ノート' => 101,
		'Portal・トーク' => 101,
		'プロジェクト・トーク' => 103,
		'モジュール・トーク' => 829, // Bug 47933
	),
	'+jawikinews' => array(
		"ポータル‐ノート" => 101,
	),
	'+jawikiversity' => array(
		'Wikiversity_talk' => NS_PROJECT_TALK,
	),
	'+kawikiquote' => array(
		'Wikiquote_განხილვა' => NS_PROJECT_TALK,
	),
	'+kkwiki' => array(
		'Joba' => 102, // bug 40794
		'Joba_talqılawı' => 103,
		'جوبا' => 102,
		'جوبا_تالقىلاۋى' => 103,
	),
	'+knwiki' => array(
		'Wikipedia' => NS_PROJECT,
		'Wikipedia_talk' => NS_PROJECT_TALK,
	),
	'+knwikisource' => array( // Bug 37676
		'Portal' => 100,
		'Portal_talk' => 101,
		'Author' => 102,
		'Author_talk' => 103,
	),
	'+kowiki' => array(
		'백' => NS_PROJECT,
		'백토' => NS_PROJECT_TALK,
		'사' => NS_USER, // bug 55909
		'사토' => NS_USER_TALK, // bug 55342
		'Portal' => 100,
		'Portal_talk' => 101,
		'들' => 100,
		'들토' => 101,
		'프' => 102,
		'프토' => 103,
	),
	'+kowikinews' => array(
		'뉴'   =>  NS_PROJECT,
		'뉴토'  => NS_PROJECT_TALK,
	),
	'+kowikiquote' => array(
		'인' => NS_PROJECT,
	),
	'+kowikisource' => array(
		'Wikisource_talk' => NS_PROJECT_TALK,
		'글쓴이' => 100,
		'글쓴이토론' => 101,
		'Author' => 100,
		'Author_talk' => 101,
		'Portal' => 102, // Bug 69522
		'Portal_talk' => 103,
	),
	'+kowikiversity' => array(
		'Wikiversity토론' => NS_PROJECT_TALK, // Bug 44899
	),
	'+kowiktionary' => array(
		'Wikisaurus' => 110,
		'Wikisaurus_talk' => 111,
		'낱' => NS_PROJECT, // bug 56761
	),
	'+kuwiktionary' => array(
		'Wîkîferheng_gotûbêj' => NS_PROJECT_TALK, // Bug 37524 (old namespace name)
		'Pêvek_nîqas' => 101,   // Bug 37524 (old namespace name)
		'Nimînok_nîqas' => 103, // Bug 37524 (old namespace name)
		'Portal_nîqas' => 105,  // Bug 37524 (old namespace name)
	),
	'+kuwiki' => array(
		'Portal_nîqaş' => 101, // Bug 37521
	),
	'+kvwiki' => array(
		'Wikipedia' => NS_PROJECT,
		'Обсуждение_Wikipedia' => NS_PROJECT_TALK,
	),
	'+lawiki' => array(
		'Disputatio_Wikipedia' => NS_PROJECT_TALK,
	),
	'+lawikisource' => array(
		'Author' => 102,
		'Author_talk' => 103,
	),
	'+lbwiktionary' => array(
		'Wiktionary_Diskussioun' => NS_PROJECT_TALK,
	),
	'+ltwiki' => array(
		'Wikipedia' => NS_PROJECT,
		'Wikipedia_aptarimas' => NS_PROJECT_TALK,
	),
	'+lvwiki' => array(
		'Wikipedia' => NS_PROJECT,
	),
	'+metawiki' => array( // bug 29129
		'R' => 202,
	),
	'+mlwiki' => array(
		'വിക്കി' => NS_PROJECT,
		'വിക്കിസം' => NS_PROJECT_TALK,
		'Wikipedia' => NS_PROJECT,
		'WP' => NS_PROJECT,
		'Portal' => 100,
		'Portal_talk' => 101,
	),
	'+mlwikibooks' => array(
		'വിക്കി‌‌_പുസ്തകശാല' => NS_PROJECT,
		'വിക്കി‌‌_പുസ്തകശാല_സംവാദം' => NS_PROJECT_TALK,
		'Wikibooks_talk' => NS_PROJECT_TALK,
		'Cookbook' => 100,
		'Cookbook_talk' => 101,
		'Subject' => 102,
		'Subject_talk' => 103,
		'വി' => NS_PROJECT,
		'വിസം' => NS_PROJECT_TALK,
		'ഉ' => NS_USER,
		'ഉസം' => NS_USER_TALK,
		'പ്ര' => NS_IMAGE,
		'പ്രസം' => NS_IMAGE_TALK,
		'ഫ' => NS_TEMPLATE,
		'ഫസം' => NS_TEMPLATE_TALK,
		'വ' => NS_CATEGORY,
		'വസം' => NS_CATEGORY_TALK,
		'സ' => NS_HELP,
		'സസം' => NS_HELP_TALK,
	),
	'+mlwikiquote' => array(
		'വിക്കി_ചൊല്ലുകൾ' => NS_PROJECT, // bug 38111
		'വിക്കി_ചൊല്ലുകൾ_സംവാദം' => NS_PROJECT_TALK, // bug 38111
	),
	'+mlwikisource' => array(
		'Author' => 100,
		'Author_talk' => 101,
		'Portal' => 102,
		'Portal_talk' => 103,
		'WS' => NS_PROJECT,
		'H' => NS_HELP, // bug 35712
	),
	'+mlwiktionary' => array(
		'വിക്കി‌‌_നിഘണ്ടു' => NS_PROJECT,
		'വിക്കി‌‌_നിഘണ്ടു_സംവാദം' => NS_PROJECT_TALK,
	),
	'+mrwiki' => array(
		'Wikipedia' => NS_PROJECT,
		'विपी' => NS_PROJECT,
	),
	'+mrwikisource' => array(
		'Portal' => 100,
		'Portal_talk' => 101,
		'Author' => 102,
		'Author_talk' => 103,
	),
	'+mswiki' => array(
		'Portal_talk' => 101,
	),
	'+mwlwiki' => array(
		'Wikipedia' => NS_PROJECT,
		'Wikipedia_cumbersa' => NS_PROJECT_TALK,
	),
	'+mznwiki' => array(
		'وپ' => NS_PROJECT,
		'Portal' => 100,
		'Portal_talk' => 101,
		'Wikipedia' => NS_PROJECT,
		'Wikipedia_گپ' => NS_PROJECT_TALK,
	),
	'+nahwiki' => array(
		'Wikipedia' => NS_PROJECT,
		'Wikipedia_tēixnāmiquiliztli' => NS_PROJECT_TALK,
	),
	'+ndswiki' => array(
		'WP' => NS_PROJECT,
	),
	'+nds_nlwiki' => array(
		'Wikipedia' => NS_PROJECT,
	),
	'+newiki' => array(
		'Wikipedia' => NS_PROJECT,
	),
	'+nlwiki' => array(
		'WP' => NS_PROJECT,
		'H' => NS_HELP,
		'P' => 100,
	),
	'+nlwikisource' => array(
		'Author' => 102,
		'Author_talk' => 103,
	),
	'+nnwiki' => array(
		'WP' => NS_PROJECT,
	),
	'+nowiki' => array(
		'WP' => NS_PROJECT, // bug 41467
	),
	'+nowikimedia' => array(
		'Brukar' => NS_USER,
		'Brukardiskusjon' => NS_USER_TALK,
		'Fil' => NS_IMAGE,
		'Fildiskusjon' => NS_IMAGE_TALK,
		'Wikimedia_Noreg' => NS_PROJECT,
		'Wikimedia_Norga' => NS_PROJECT,
	),
	'+nowikisource' => array(
		'Author' => 102, // bug 7796
		'Author_talk' => 103,
	),
	'+nowiktionary' => array(
		'Appendix' => 100,
		'Appendix_talk' => 101,
	),
	'+officewiki' => array( // bug 64976
		'OW' => NS_PROJECT,
	),
	'+orwiki' => array(
		'Wikipedia' => NS_PROJECT,
		'Wikipedia_talk' => NS_PROJECT_TALK,
		'WP' => NS_PROJECT, // bug 28257
		'WT' => NS_PROJECT_TALK, // bug 28257
	),
	'+outreachwiki' => array(
		'Wikipedia' => NS_PROJECT,
		'Wikipedia_talk' => NS_PROJECT_TALK,
	),
	'+plwiki' => array( // bug 10064
		'Wikipedystka' => NS_USER,
		'Dyskusja_wikipedystki' => NS_USER_TALK,
		'WP' => NS_PROJECT,
	),
	'+plwikibooks' => array(
		'Wikipedystka' => NS_USER,
		'Dyskusja_wikipedystki' => NS_USER_TALK,
		'WB' => NS_PROJECT,
	),
	'+plwikisource' => array(
		'WS' => NS_PROJECT,
		'Author' => 104,
		'Author_talk' => 105,
	),
	'+plwiktionary' => array(
		'WS' => NS_PROJECT,
	),
	'+ptwiki' => array(
		'Utilizador' => NS_USER,  // bug 27495
		'Utilizador_Discussão' => NS_USER_TALK, // bug 27495
		'Discussão_Portal' => 101,
		'WP' => NS_PROJECT, // bug 27728
		'Wikipedia' => NS_PROJECT,
		'Wikipedia_Discussão' => NS_PROJECT_TALK,
	),
	'+ptwikibooks' => array(
		'Wikibooks_Talk' => NS_PROJECT_TALK,
		'Wikibooks_Discussão' => NS_PROJECT_TALK,
	),
	'+ptwikisource' => array(
		'Author' => 102,
		'Author_talk' => 103,
		'Em_tradução' => 108,
		'Discussão_Em_tradução' => 109,
		'Discussão_em_tradução' => 109,
	),
	'+rowiki' => array(
		'Discuţie_MediWiki' => NS_MEDIAWIKI_TALK,
		'Discuţie_Portal' => 101,
		'Discuţie_Proiect' => 103,
		'Book' => 110, // bug 66530
		'Discuţie_Book' => 111,
	),
	'+rowikibooks' => array(
		'Discuţie_Wikibooks' => NS_PROJECT_TALK,
	),
	'+rowikinews' => array(
		'Wikiştiri' => NS_PROJECT,
		'Wikinews' => NS_PROJECT,
		'Discuţie_Wikiştiri' => NS_PROJECT_TALK,
		'Discuţie_MediWiki' => NS_MEDIAWIKI_TALK,
	),
	'+rowikisource' => array(
		'Author' => 102,
		'Author_talk' => 103,
	),
	'+ruwiki' => array(
		'У' => NS_USER,           // Bug 42511
		'U' => NS_USER,           // Bug 67844
		'ОУ' => NS_USER_TALK,     // Bug 67844
		'UT' => NS_USER_TALK,     // Bug 67844
		'Ш' => NS_TEMPLATE,       // Bug 42511
		'T' => NS_TEMPLATE,       // Bug 42511
		'К' => NS_CATEGORY,       // Bug 42511
		'ВП' => NS_PROJECT,       // Bug 12320
		'И' => 102,
		'ПРО' => 104,             // Bug 34124
		'АК' => 106,              // Bug 34527

		'Участница' => NS_USER,                    // Bug 12320
		'Обсуждение_участницы' => NS_USER_TALK,
		'Incubator' => 102,
		'Incubator_talk' => 103,
		'Wikiproject' => 104,                      // Bug 34124
		'Wikiproject_talk' => 105,
		'Arbcom' => 106,                           // Bug 34527
	),
	'+ruwikibooks' => array(
		'ВУ' => NS_PROJECT,
	),
	'+ruwikinews' => array(
		'ВикиНовости' => NS_PROJECT,
		'ВН' => NS_PROJECT,
		'П' => 100,
		'Обсуждение_ВикиНовостей' => NS_PROJECT_TALK,
	),
	'ruwikiquote' => array(
		'ВЦ' => NS_PROJECT,
	),
	'+ruwiktionary' => array(
		'Appendix' => 100,
		'Appendix_talk' => 101,
		'Concordance' => 102,
		'Concordance_talk' => 103,
		'Index' => 104,
		'Index_talk' => 105,
		'Rhymes' => 106,
		'Rhymes_talk' => 107,
	),
	'+sawiki' => array(
		'WP' => NS_PROJECT,
		'WT' => NS_PROJECT_TALK,
		'Wikipedia' => NS_PROJECT,
		'Wikipedia_talk' => NS_PROJECT_TALK,
	),
	'+sewiki' => array(
		'WP' => NS_PROJECT, // bug 40436
		'Temasiidu' => 100, // bug 39206
		'Temasiidoságastallan' => 101, // bug 39206
	),
	'+simplewiki' => array(
		'WP' => NS_PROJECT,
	),
	'+simplewikiquote' => array(
		'WQ' => NS_PROJECT,
	),
	'+simplewiktionary' => array(
		'WT' => NS_PROJECT,
	),
	'+siwiki' => array(
		'Wikipedia' => NS_PROJECT,
		'Wikipedia_talk' => NS_PROJECT_TALK,
		'Portal' => 100,
		'Portal_talk' => 101,
	),
	'+siwikibooks' => array(
		'Wikibooks_talk' => NS_PROJECT_TALK,
	),
	'+siwiktionary' => array(
		'Wiktionary_talk' => NS_PROJECT_TALK,
	),
	'+skwikibooks' => array(
		'Wikibooks_talk' => NS_PROJECT_TALK,
	),
	'+skwikisource' => array(
		'Wikisource_talk' => NS_PROJECT_TALK,
	),
	'+sqwikinews' => array(
		'WL' => NS_PROJECT,
	),
	'+srwiki' => array(
		'Vikipedija' => NS_PROJECT,
	),
	'+svwiki' => array(
		'WP' => NS_PROJECT,
	),
	'+svwikinews' => array(
		'WN' => NS_PROJECT,
	),
	'+svwikisource' => array(
		'Author' => 106,
		'Author_talk' => 107,
	),
	'+svwiktionary' => array(
		'WT' => NS_PROJECT,
		'WT-diskussion' => NS_PROJECT_TALK,
	),
	'+swwiki' => array(
		'Portal' => 100,
		'Portal_talk' => 101,
	),
	'+tawiki' => array(
		'Wikipedia' => NS_PROJECT,
		'Wikipedia_talk' => NS_PROJECT_TALK,
	),
	'+testwiki' => array(
		'WP' => NS_PROJECT,
		'WT' => NS_PROJECT_TALK,
	),
	'+tewiki' => array(
		'Wikipedia' => NS_PROJECT,
		'Wikipedia_talk' => NS_PROJECT_TALK,
	),
	'+tewikisource' => array(
		'Author' => 102,
		'Author_talk' => 103,
		'పేజీ' => 104,
		'పేజీ_చర్చ' => 105,
	),
	'+tewiktionary' => array(
		'Wiktionary_చర్చ' => NS_PROJECT_TALK, // bug 36533
	),
	'+thwiki' => array(
		'Wikipedia' => NS_PROJECT,
		'WP' => NS_PROJECT,
		'H' => NS_HELP,
	), // Bug 68108
	'+thwikibooks' => array(
		'คุยเรื่องWikibooks' => NS_PROJECT_TALK,
		'Subject' => 102, // bug 46153
		'Subject_talk' => 103, // bug 46153
	),
	'+thwiktionary' => array(
		'คุยเรื่องWiktionary' => NS_PROJECT_TALK,
	),
	'+trwikibooks' => array(
		'VK' => NS_PROJECT,
		'VÇ' => 110,
		'KAT' => NS_CATEGORY,
		'KİT' => 112,
	),
	'+trwikisource' => array(
		'Author' => 100,
		'Author_talk' => 101,
		'VikiKaynak' => NS_PROJECT, // bug 42721
		'Oluşturuluyor VikiKaynak tartışma' => NS_PROJECT_TALK,
	),
	'+ttwiki' => array(
		'WP' => NS_PROJECT,
		'ВП' => NS_PROJECT,
		'Wikipedia' => NS_PROJECT,
		'Wikipedia_talk' => NS_PROJECT_TALK,
	),
	'+ukwiki' => array(
		'ВП' => NS_PROJECT,
	),
	'+ukwikibooks' => array(
		'ВП'  => NS_PROJECT,
	),
	'+ukwikiquote' => array(
		'ВЦ' => NS_PROJECT,
	),
	'+ukwikinews' => array(
		'ВікіНовини' => NS_PROJECT, // bug 48843
		'ВН' => NS_PROJECT, // bug 48843
		'Обговорення_ВікіНовини' => NS_PROJECT_TALK, // bug 48843
		'Д' => NS_HELP, // bug 48843
		'К' => NS_CATEGORY,
		'Comments' => 102, // bug 45333
		'Comments_talk' => 103,
		'Incubator' => 104,
		'І' => 104, // bug 48843
		'Incubator_talk' => 105,
	),
	'+ukwikisource' => array(
		'ВД' => NS_PROJECT,
		'Обговорення_Wikisource' => NS_PROJECT_TALK, // bug 48308
		'Author' => 102,  // bug 48308
		'Author_talk' => 103,
		'Translation' => 114,  // bug 50561
		'Translation_talk' => 115,
	),
	'+ukwikivoyage' => array(
		'Portal' => 100,
		'Portal_talk' => 101,
		'ВМ' => NS_PROJECT,
		'К' => NS_CATEGORY,
		'П' => 100,
		'Д' =>  NS_HELP,
	),
	'+ukwiktionary' => array(
		'ВС' => NS_PROJECT,
	),
	'+urwiki' => array(
		'Portal' => 100, // bug 19569
		'Portal_talk' => 101, // bug 19569
	),
	'+uzwiki' => array(
		'VP' => NS_PROJECT, // bug 46534
		'VM' => NS_PROJECT_TALK, // bug 46534
	),
	'+vecwikisource' => array(
		'Author' => 100,
		'Author_talk' => 101,
	),
	'+wikidata' => array(
		'WD' => NS_PROJECT, // bug 41834
		'WT' => NS_PROJECT_TALK,
		'P' => 120, // bug 45079
	),
	'+yiwiki' => array(
		'וויקיפעדיע' => NS_PROJECT,
		'וויקיפעדיע_רעדן' => NS_PROJECT_TALK,
	),
	'+yiwikisource' => array(
		'וויקיביבליאטעק' => NS_PROJECT,
		'וויקיביבליאטעק_רעדן' => NS_PROJECT_TALK
	),
	'+yiwiktionary' => array(
		'וויקיווערטערבוך' => NS_PROJECT,
		'וויקיווערטערבוך_רעדן' => NS_PROJECT_TALK
	),
	'+yiwikinews' => array(
		'וויקינייעס' => NS_PROJECT,
		'וויקינייעס_רעדן' => NS_PROJECT_TALK
	),
	'+yowiki' => array(
		'Portal' => 100,
		'Portal_talk' => 101,
		'Book' => 108,
		'Book_talk' => 109,
	),
	'+vecwiki' => array(
		'WP' => NS_PROJECT,
		'Immagine' => NS_IMAGE,
	),
	'+viwikibooks' => array(
		'Subject' => 102,
		'Subject_talk' => 103,
		'Wikijunior' => 104,
		'Wikijunior_talk' => 105,
		'Cookbook' => 106,
		'Cookbook_talk' => 107,
	),
	'+viwikisource' => array(
		'Portal' => 100,
		'Portal_talk' => 101,
		'Author' => 102,
		'Author_talk' => 103,
	),
	'+vowiki' => array(
		'Wikipedia' => NS_PROJECT,
		'Wikipedia_talk' => NS_PROJECT_TALK,
	),
	'+vowiktionary' => array(
		'Wiktionary_talk' => NS_PROJECT_TALK,
	),
	'+zh_classicalwiki' => array(
		'Wikipedia' => NS_PROJECT,
		'Wikipedia_talk' => NS_PROJECT,
	),
	'+zhwiki' => array(
		'维基百科' => NS_PROJECT,
		'維基百科' => NS_PROJECT,
		'WP' => NS_PROJECT,
		'维基百科讨论' => NS_PROJECT_TALK,
		'维基百科对话' => NS_PROJECT_TALK,
		'維基百科討論' => NS_PROJECT_TALK,
		'維基百科對話' => NS_PROJECT_TALK,
		'T' => NS_TEMPLATE,
		'WT' => NS_PROJECT_TALK,
		'CAT' => NS_CATEGORY,
		'H' => NS_HELP,
		'P' => 100,
	),
	'+zhwikibooks' => array(
		'维基教科书' => NS_PROJECT,
		'維基教科書' => NS_PROJECT,
		'WB' => NS_PROJECT,
		'CAT' => NS_CATEGORY, // Bug 44308
		'維基兒童' => 110, // Bug 44308
		'维基儿童' => 110, // Bug 44308
		'WJ' => 110, // Bug 44308, Wikijunior
		'書架' => 112, // Bug 44308
		'书架' => 112, // Bug 44308
		'SB' => 112, // Bug 44308, Subject
	),
	'+zhwikisource' => array(
		'作者' => 102, // Author
		'作者讨论' => 103, // Author_talk
		'作者討論' => 103,
		'翻譯' => 114, // bug 64127
		'翻译' => 114, // bug 64127
		'翻譯討論' => 115, // bug 64127
		'翻译讨论' => 115, // bug 64127
	),
	'+zhwikivoyage' => array( // bug 60122
		'维基导游' => NS_PROJECT,
		'維基導遊' => NS_PROJECT,
	),
	'+zh_yuewiki' => array(
		'WP' => NS_PROJECT,
		'WT' => NS_PROJECT_TALK,
		'T' => NS_TEMPLATE,
		'H' => NS_HELP,
		'P' => 100,
		# 'PT' => 101,
		'Wikipedia_talk' => NS_PROJECT_TALK,
		'MediaWiki_talk' => NS_MEDIAWIKI_TALK,
		# Aliases for MediaWiki core "yue" namespace names.
		'媒體' => NS_MEDIA,
		'特別' => NS_SPECIAL,
		'傾偈' => NS_TALK,
		'用戶' => NS_USER,
		'用戶傾偈' => NS_USER_TALK,
		'$1_傾偈' => NS_PROJECT_TALK,
		'文件' => NS_FILE,
		'文件傾偈' => NS_FILE_TALK,
		'MediaWiki_傾偈' => NS_MEDIAWIKI_TALK,
		'模' => NS_TEMPLATE,
		'模傾偈' => NS_TEMPLATE_TALK,
		'幫手' => NS_HELP,
		'幫手傾偈' => NS_HELP_TALK,
		'分類' => NS_CATEGORY,
		'分類傾偈' => NS_CATEGORY_TALK,
	),
),
# @} end of wgNamespaceAliases

# wgNamespacesWithSubpages @{
'wgNamespacesWithSubpages' => array(
	'default' => array(
		NS_TALK			/* 1 */  => true,
		NS_USER			/* 2 */  => true,
		NS_USER_TALK		/* 3 */  => true,
		NS_PROJECT		/* 4 */  => true,
		NS_PROJECT_TALK		/* 5 */  => true,
		NS_FILE_TALK		/* 7 */  => true,
		NS_MEDIAWIKI		/* 8 */  => true,
		NS_MEDIAWIKI_TALK	/* 9 */  => true,
		NS_TEMPLATE		/* 10 */ => true,
		NS_TEMPLATE_TALK	/* 11 */ => true,
		NS_HELP			/* 12 */ => true,
		NS_HELP_TALK		/* 13 */ => true,
		NS_CATEGORY_TALK	/* 15 */ => true,
		// extra namespaces usually want subpages
		100               => true,
		101               => true,
		102               => true,
		103               => true,
		104               => true,
		105               => true,
		106               => true,
		107               => true,
		108               => true,
		109               => true,
		110               => true,
		111               => true,
	),

	// Wikipedia @{
	'+cswiki' => array( 6 => 0, 14 => 1 ),
	'+dewiki' => array( 6 => 0, 8 => 0, 10 => 0 ),
	'+enwiki' => array( 6 => 0, 8 => 0 ),
	'+eowiki' => array( 6 => 0, 8 => 0 ), // 0 => 1 removed per bug 55563
	'+eswiki' => array( 6 => 0, 8 => 0 ),
	'+frwiki' => array( 6 => 0, 8 => 0 ),
	'+guwiki' => array( 6 => 0, 8 => 0, 14 => 1 ),
	'+huwiki' => array( 6 => 0, 8 => 0, 14 => 1 ),
	'+idwiki' => array( 6 => 0, 8 => 0 ),
	'+itwiki' => array( 6 => 0, 8 => 0, 14 => 0 ),
	'+kkwiki' => array( 6 => 0, 8 => 0, 12 => 0 ),
	'+ltwiki' => array( 6 => 0, 8 => 0 ),
	'+plwiki' => array( 6 => 0, 8 => 0, 14 => 1 ),
	'+rmwiki' => array( 0 => 1 ),
	'+slwiki' => array( 6 => 0, 8 => 0, 14 => 1 ),
	'+tenwiki' => array( 0 => 1 ),
	'+zh_yuewiki' => array( 6 => 0, 8 => 0, 14 => 1 ),
	'+zh_min_nanwiki' => array( 6 => 0, 8 => 0, 10 => 0 ),
	// @}

	// Specials wiki @{
	'+arbcom_enwiki' => array( 0 => 1, 6 => 0, 8 => 0, 10 => 0 ),
	'+auditcomwiki' => array( 0 => 1, 6 => 0, 8 => 0, 10 => 0 ),
	'+bewikimedia' => array( 0 => 1 ),
	'+boardwiki' => array( 0 => 1, 6 => 0, 8 => 0, 10 => 0 ),
	'+brwikimedia' => array( 0 => 1 ),
	'+chairwiki' => array( 0 => 1, 6 => 0, 8 => 0, 10 => 0 ),
	'+chapcomwiki' => array( 0 => 1, 6 => 0, 8 => 0, 10 => 0 ),
	'+checkuserwiki' => array( 0 => 1 ),
	'+collabwiki' => array( 0 => 1 ),
	'+commonswiki' => array( 6 => 0, 8 => 0 ),
	'+execwiki' => array( 0 => 1, 6 => 0, 8 => 0, 10 => 0 ),
	'+fdcwiki' => array( 0 => 1 ),
	'+foundationwiki' => array( 0 => 1, 6 => 0, 8 => 0 ),
	'+grantswiki' => array( 0 => 1, 6 => 0, 8 => 0, 10 => 0 ),
	'+incubatorwiki' => array( 0 => 1, 6 => 0, 14 => 1 ),
	'+internalwiki' => array( 0 => 1, 6 => 0, 8 => 0, 10 => 0 ),
	'+labswiki' => array( 0 => 1, 110 => 1, 112 => 1, 113 => 1, 498 => 1 ),
	'+legalteamwiki' => array( 0 => 1 ),
	'+mediawikiwiki' => array( 0 => 1, 6 => 0, 8 => 0, 14 => 1 ),
	'+metawiki' => array( 0 => 1, 6 => 0, 8 => 0, 200 => 1, 201 => 1, 202 => 1, 203 => 1, 208 => 1, 209 => 1 ),
	'+movementroleswiki' => array( 0 => 1 ),
	'+nlwikimedia' => array( 0 => 1 ),
	'+nostalgiawiki' => array( 0 => 1, 6 => 0, 8 => 0, 10 => 0 ),
	'+nowikimedia' => array( 0 => 1 ),
	'+officewiki' => array( 0 => 1, 6 => 0, 8 => 0, 10 => 0 ),
	'+ombudsmenwiki' => array( 0 => 1 ),
	'+otrs_wikiwiki' => array( 0 => 1 ),
	'+outreachwiki' => array( 0 => 1 ),
	'+plwikimedia' => array( 0 => 1, 6 => 0, 8 => 0, 10 => 0, 14 => 1 ),
	'+rswikimedia' => array( 0 => 1, 6 => 0, 8 => 0, 10 => 0 ),
	'+ruwikimedia' => array( 0 => 1,  6 => 1, 7 => 0, 9 => 0, 14 => 1, 15 => 0 ),
	'+sewikimedia' => array( 0 => 1 ),
	'+stewardwiki' => array( 0 => 1, 6 => 1, 14 => 1 ),
	'+strategywiki' => array( 0 => 1 ),
	'+ukwikimedia' => array( 0 => 1, 6 => 0, 8 => 0, 10 => 0 ),
	'+usabilitywiki' => array( 0 => 1 ),
	'+wikimaniateamwiki' => array( 0 => 1, 6 => 0, 8 => 0, 10 => 0 ),

	'+wikimania' => array( 0 => 1, 6 => 0, 8 => 0, ),
	'+wikimania2006wiki' => array( 10 => 0 ),
	'+wikimania2007wiki' => array( 10 => 0 ),
	'+wikimania2008wiki' => array( 10 => 0 ),
	'+wikimania2009wiki' => array( 10 => 0 ),
	'+wikimania2010wiki' => array( 10 => 0 ),
	// @}

	// Wikibooks @{
	'+wikibooks' => array( 0 => 1, 6 => 0, 8 => 0 ),
	'+cswikibooks' => array( 0 => 1, 6 => 0, 14 => 1 ),
	'+enwikibooks' => array( 0 => 1, 6 => 0, 8 => 0, 14 => 1 ),
	'+eswikibooks' => array( 0 => 1, 6 => 0, 8 => 0 ),
	'+idwikibooks' => array( 0 => 1, 6 => 0, 8 => 0 ),
	'+itwikibooks' => array( 0 => 1, 6 => 0, 8 => 0 ),
	'+plwikibooks' => array( 0 => 1, 6 => 0, 8 => 0, 14 => 1 ),
	'+ptwikibooks' => array( 0 => 1, 6 => 0, 8 => 0, 14 => 1 ),
	'+siwikibooks' => array( 112 => 1, 113 => 1, 114 => 1, 115 => 1 ),
	'+ukwikibooks' => array( 0 => 1, 6 => 0, 8 => 0, 14 => 1 ),
	// @}

	// Wikisource @{
	'+wikisource' => array( 0 => 1, 6 => 0, 8 => 0 ),
	'+cswikisource' => array( 14 => 1 ),
	'+enwikisource' => array( 114 => 1, 115 => 1 ), // bug 50007
	'+huwikisource' => array( 10 => 0 ),
	'+nowikisource' => array( 10 => 0 ),
	'+ruwikisource' => array( 10 => 0 ),
	'+trwikisource' => array( 10 => 0 ),
	'+ukwikisource' => array( 114 => 1, 115 => 1 ), // bug 50561
	'+viwikisource' => array( 10 => 0 ),
	'+zhwikisource' => array( 10 => 0, 114 => 1, 115 => 1 ), // bug 64127
	// @}

	// Wikiversity @{
	'+arwikiversity' => array( 0 => 1, 6 => 1, 10 => 0 ),
	'+betawikiversity' => array( 0 => 1, 10 => 0 ),
	'+cswikiversity' => array( 0 => 1, 6 => 0, 14 => 1 ),
	'+dewikiversity' => array( 0 => 1, 6 => 0, 8 => 0, 10 => 0 ),
	'+enwikiversity' => array( 0 => 1, 6 => 0, 8 => 0, 10 => 0 ),
	'+fiwikiversity' => array( 0 => 1, 6 => 0, 8 => 0, 10 => 0 ),
	'+frwikiversity' => array( 0 => 1, 6 => 0, 8 => 0, 112 => 1, 113 => 1 ),
	'+itwikiversity' => array( 0 => 1, 6 => 0, 8 => 0, 14 => 0 ),
	'+ptwikiversity' => array( 0 => 1, 10 => 0 ),
	'+ruwikiversity' => array( 0 => 1, 6 => 1, 14 => 1 ),
	'+svwikiversity' => array( 0 => 1 ),
	// @}

	// Wikiquote
	'+cswikiquote' => array( 0 => 1, 6 => 0, 14 => 1 ),
	'+plwikiquote' => array( 6 => 0, 8 => 0, 14 => 1 ),

	// Wikinews
	'+cswikinews' => array( 0 => 1, 6 => 0, 14 => 1 ),
	'+plwikinews' => array( 6 => 0, 8 => 0, 14 => 1 ),

	// Wiktionary
	'+cswiktionary' => array( 0 => 1, 6 => 0, 14 => 1 ),
	'+iswiktionary' => array( 0 => 1, 6 => 0, 8 => 0, 14 => 1 ),
	'+ltwiktionary' => array( 6 => 0, 8 => 0, 14 => 1 ),
	'+plwiktionary' => array( 6 => 0, 8 => 0, 14 => 1 ),

	// Wikivoyage
	'+dewikivoyage' => array( 0 => 1, 100 => 0, 104 => 0 ),
	'+itwikivoyage' => array( 0 => 1, 100 => 0, 104 => 0 ),
),
# @} end of wgNamespacesWithSubpages

# wgProofreadPageNamespaceIds @{
'wgProofreadPageNamespaceIds' => array(
	'test2wiki' => array(
		'page' => 104,
		'index' => 106
	),
	'sourceswiki' => array(
		'page' => 104,
		'index' => 106,
	),
	'enwikisource' => array(
		'page' => 104,
		'index' => 106,
	),
	'arwikisource' => array(
		'page' => 104,
		'index' => 106,
	),
	'aswikisource' => array( // Bug 43129
		'page' => 104,
		'index' => 106,
	),
	'bewikisource' => array(
		'page' => 104,
		'index' => 106,
	),
	'bnwikisource' => array(
		'page' => 104,
		'index' => 102,
	),
	'brwikisource' => array(
		'page' => 102,
		'index' => 100,
	),
	'cawikisource' => array(
		'page' => 102,
		'index' => 104,
	),
	'dawikisource' => array(
		'page' => 104,
		'index' => 106,
	),
	'dewikisource' => array(
		'page' => 102,
		'index' => 104,
	),
	'elwikisource' => array(
		'page' => 100,
		'index' => 102,
	),
	'eowikisource' => array(
		'page' => 104,
		'index' => 106,
	),
	'eswikisource' => array(
		'page' => 102,
		'index' => 104,
	),
	'etwikisource' => array(
		'page' => 102,
		'index' => 104,
	),
	'fawikisource' => array(
		'page' => 104,
		'index' => 106,
	),
	'frwikisource' => array(
		'page' => 104,
		'index' => 112,
	),
	'frrwiki' => array(
		'page' => 102,
		'index' => 104
	),
	'guwikisource' => array(
		'page' => 104,
		'index' => 106
	),
	'hewikisource' => array(
		'page' => 104,
		'index' => 112,
	),
	'hrwikisource' => array(
		'page' => 102,
		'index' => 104,
	),
	'huwikisource' => array(
		'page' => 104,
		'index' => 106,
	),
	'hywikisource' => array(
		'page' => 104,
		'index' => 106,
	),
	'idwikisource' => array(
		'page' => 104,
		'index' => 102,
	),
	'itwikisource' => array(
		'page' => 108,
		'index' => 110,
	),
	'knwikisource' => array(
		'page' => 104,
		'index' => 106,
	),
	'lawikisource' => array(
		'page' => 104,
		'index' => 106,
	),
	'mlwikisource' => array(
		'page' => 106,
		'index' => 104,
	),
	'mrwikisource' => array(
		'page' => 104,
		'index' => 106,
	),
	'nlwikisource' => array(
		'page' => 104,
		'index' => 106
	),
	'nowikisource' => array(
		'page' => 104,
		'index' => 106
	),
	'plwikisource' => array(
		'page' => 100,
		'index' => 102,
	),
	'ptwikisource' => array(
		'page' => 106,
		'index' => 104,
	),
	'rowikisource' => array(
		'page' => 104,
		'index' => 106,
	),
	'ruwikisource' => array(
		'page' => 104,
		'index' => 106,
	),
	'sawikisource' => array(
		'page' => 104,
		'index' => 106,
	),
	'slwikisource' => array(
		'page' => 100,
		'index' => 104,
	),

	'svwikisource' => array(
		'page' => 104,
		'index' => 108,
	),
	'tewikisource' => array(
		'page' => 104,
		'index' => 106,
	),
	'vecwikisource' => array(
		'page' => 102,
		'index' => 104,
	),
	'viwikisource' => array(
		'page' => 104,
		'index' => 106,
	),
	'zhwikisource' => array(
		'page' => 104,
		'index' => 106,
	),
),
# @} end of wgProofreadPageNamespaceIds

'wgRawHtml' => array(
	'default' => false,
	'donatewiki' => true,
	'foundationwiki' => true,
	'internalwiki' => true,
	'collabwiki' => true, // bug 29269
	'zerowiki' => true,
),

# wgWhitelistRead @{
'wgWhitelistRead' => array(
	'private' => array( 'Main Page', 'Special:UserLogin', 'Special:UserLogout' ),
	'grantswiki' => array( 'Main Page', 'Special:UserLogin', 'Special:UserLogout' ),
	'+zerowiki' => array( 'Special:ZeroPortal' ),
),
# @} end of wgWhitelistRead

'wgAutoConfirmAge' => array(
	'default' => 4 * 3600 * 24, // 4 days to pass isNewbie()
	'fishbowl' => 0, // No need

	# http://de.wikibooks.org/wiki/Wikibooks:Meinungsbilder/_Verschiebefunktion_f%C3%BCr_neue_Nutzer
	# TS 2007-02-06
	'dewikibooks' => 7 * 86400,
	'nowiki' => 7 * 86400, // bug 69302
	'tenwiki' => 0, // bug 26554
	'zhwiki' => 7 * 3600 * 24, // bug 14624
),

// Turn this on so UserMailer::send() will be able to send both text and html email
'wgAllowHTMLEmail' => array(
	'default' => true,
),

'wgAutoConfirmCount' => array(
	'default' => 0,
	'arwiki' => 50, // Bug 12123
	'ckbwiki' => 10, // Bug 51537
	'enwiki' => 10, // Bug 14191
	'eswiki' => 50, // Bug 13261
	'eswikivoyage' => 25, // bug 44285
	'fawiki' => 10, // Bug 43630
	'fawikivoyage' => 10, // Bug 71709
	'itwiki' => 10, //Bug 70128
	'itwiktionary' => 10, // Bug 22274
	'jawiki' => 10, // Bug 40270
	'kowiki' => 10,// Bug 44894
	'nowiki' => 20, // bug 69302
	'plwiki' => 10,
	'ptwiki' => 10, // Bug 27954
	'ruwiki' => 15, // Bug 41831
	'simplewiki' => 10,
	'wikidata' => 50, // Bug 46461
	'zhwiki' => 50, // Bug 14624
	'zh_yuewiki' => 10, // Bug 30538
),

# wgRestrictionLevels @{
// Don't use '+foowiki' syntax, as that results in bad ordering in the
// protection form (bug 69640).
'wgRestrictionLevels' => array(
	'default' => array(
		'',
		'autoconfirmed', // semi-protection level on
		'sysop',
		'superprotect', // per request by Erik Möller
	),
	'arwiki' => array( '', 'autoconfirmed', 'autoreview', 'sysop', 'superprotect' ), // bug 52109
	'ckbwiki' => array( '', 'autoconfirmed', 'autopatrol', 'sysop', 'superprotect' ), // bug 52533
	'enwiki' => array( '', 'autoconfirmed', 'templateeditor', 'sysop', 'superprotect' ), // bug 55432
	'hewiki' => array( '', 'autoconfirmed', 'autopatrol', 'sysop', 'superprotect' ), //bug 58207
	'plwiki' => array( '', 'autoconfirmed', 'editor', 'sysop', 'superprotect' ), // bug 46990
	'ptwiki' => array( '', 'autoconfirmed', 'autoreviewer', 'sysop', 'superprotect' ), // bug 39652
	'rowiki' => array( '', 'autoconfirmed', 'templateeditor', 'sysop', 'superprotect' ), // bug 61172
	'testwiki' => array( '', 'autoconfirmed', 'templateeditor', 'sysop', 'superprotect' ), // bug 59084
),
# @} end of wgRestrictionLevels

'wgCascadingRestrictionLevels' => array(
	'default' => array( 'sysop' ),
	'plwiki' => array( 'editor', 'sysop' ), // Bug 48374
),

'wgSiteNotice' => array(
	'default' => '',
),

'wmgPrivateWiki' => array(
	'default' => false,
	'private' => true // make files private and such
),

'wmgUseDismissableSiteNotice' => array(
	'default' => true,
),

'wmgUseCentralNotice' => array(
	'default' => true,
	'advisorywiki' => false, // Per Bug # 25519
	'fishbowl' => false, // Per bug 17718 Disable CentralNotice on private/fishbowl wikis
	'fiwikimedia' => false, // bug 17718
	'private' => false, // :D
	'qualitywiki' => false,
	'ukwikimedia' => false,  // Per bug 17718 Disable CentralNotice on private/fishbowl wikis
),

'wmgCentralNoticeLoader' => array(
	'default' => true, // *gulp* -- bv 2008-11-03
),

// For CentralNotice project pickers
'wmgNoticeProject' => array(
	'advisorywiki' => 'wikimedia',
	'default' => '$site',
	'commonswiki' => 'commons',
	'foundationwiki' => 'wikimedia',
	'incubatorwiki' => 'wikimedia',
	'mediawikiwiki' => 'wikimedia',
	'metawiki' => 'meta',
	'outreachwiki' => 'wikimedia',
	'usabilitywiki' => 'wikimedia',
	'strategywiki' => 'wikimedia',
	'sourceswiki' => 'wikisource',
	'specieswiki' => 'wikispecies',
	'testwiki' => 'test',
	'wikimania' => 'wikimedia',
	'wikidata' => 'wikidata',
	'wikivoyage' => 'wikivoyage',
),

'wgReadOnly' => array(
	'default' => null,
),

'wgReadOnlyFile' => array(
	'default' => false,
),

# wgTranslateNumerals @{
'wgTranslateNumerals' => array(
	'default' => true,

	'arwiki' => false,
	'arwikibooks' => false, // bug 3442 -ævar
	'arwikiquote' => false,
	'arwiktionary' => false, // bug 33758
	'arwikisource' => false,
	'arwikiversity' => false,
	'arwikinews' => false,
	'aswiki' => false, // bug 31371
	'hiwiki' => false, // bug 29279
	'tewiki' => false, // by request -- maybe remove from file
	'mlwiki' => false, // 2005-01-03, by dubious request on Ts's talk page -ævar
	'tewikibooks' => false,
	'tewikiquote' => false,
	'tewiktionary' => false,
),
# @} end of wgTranslateNumerals

'wgDebugLogFile' => array(
	'default' => '',
	'testwiki' => "udp://$wmfUdp2logDest/testwiki",
	'test2wiki' => "udp://$wmfUdp2logDest/test2wiki",
),

# wgDebugLogGroups @{
'wgDebugLogGroups' => array(
	'default' => array(
		'cite' => "udp://$wmfUdp2logDest/cite", // to see how it's used;) -ævar
		'thumbnail' => "udp://$wmfUdp2logDest/thumbnail",
		'jobqueue' => "udp://$wmfUdp2logDest/jobqueue/web",
		'slow-parse' => "udp://$wmfUdp2logDest/slow-parse",
		'exception' => "udp://$wmfUdp2logDest/exception",
		'exception-json' => "udp://$wmfUdp2logDest/exception-json",
		'session' => "udp://$wmfUdp2logDest/session",
		'logging' => "udp://$wmfUdp2logDest/logging",
		'SimpleAntiSpam' => "udp://$wmfUdp2logDest/spam",
		'AntiBot' => "udp://$wmfUdp2logDest/spam",
		'SpamBlacklistHit' => "udp://$wmfUdp2logDest/spam",
		'SpamRegex' => "udp://$wmfUdp2logDest/spam",
		'OutputBuffer' => "udp://$wmfUdp2logDest/buffer",
		'exec' => "udp://$wmfUdp2logDest/exec",
		'ratelimit' => "udp://$wmfUdp2logDest/limiter",
		'runJobs' => "udp://$wmfUdp2logDest/runJobs",
		'JobQueueRedis' => "udp://$wmfUdp2logDest/redis-jobqueue",
		'es-hit' => "udp://$wmfUdp2logDest/es-hit",
		'poolcounter' => "udp://$wmfUdp2logDest/poolcounter",
		'lc-recache' => "udp://$wmfUdp2logDest/lc-recache",
		'generated-pp-node-count' => "udp://$wmfUdp2logDest/generated-pp-node-count",
		'api' => "udp://$wmfUdp2logDest/api",
		'api-feature-usage' => "udp://$wmfUdp2logDest/api-feature-usage",
		'SQLBagOStuff' => "udp://$wmfUdp2logDest/sql-bagostuff",
		'FileOperation' => "udp://$wmfUdp2logDest/filebackend-ops",
		'SwiftBackend' => "udp://$wmfUdp2logDest/swift-backend", // -aaron 5/15/12
		'updateTranstagOnNullRevisions' => "udp://$wmfUdp2logDest/updateTranstagOnNullRevisions",
		'redis' => "udp://$wmfUdp2logDest/redis", // -asher 2012/10/12
		'memcached-serious' => "udp://$wmfUdp2logDest/memcached-serious", // -aaron 2012/10/24
		'404' => "udp://$wmfUdp2logDest/four-oh-four",
		'resourceloader' => "udp://$wmfUdp2logDest/resourceloader",
		'wikibase-debug' => "udp://$wmfUdp2logDest/wikibase-debug",
		'oai' => "udp://$wmfUdp2logDest/oai",
		'captcha' => "udp://$wmfUdp2logDest/captcha",
		'ExternalStoreDB' => "udp://$wmfUdp2logDest/external",
		'query' => "udp://$wmfUdp2logDest/botquery",
		'antispoof' => "udp://$wmfUdp2logDest/antispoof",
		'badpass' => "udp://$wmfUdp2logDest/badpass",
		'ts_badpass' => "udp://$wmfUdp2logDest/ts_badpass",
		'EventLogging'  => "udp://$wmfUdp2logDest/eventlogging",
		'torblock'  => "udp://$wmfUdp2logDest/torblock",
		'mobile'  => "udp://$wmfUdp2logDest/mobile",
		'mwsearch' => "udp://$wmfUdp2logDest/mwsearch",
		'MessageCache' => "udp://$wmfUdp2logDest/messagecache",
		'temp-debug' => "udp://$wmfUdp2logDest/temp-debug", // generic admin debug log
		'CentralAuth' => "udp://$wmfUdp2logDest/centralauth", // -pgehres 2013/05/09, tmp for SUL finalization
		'CentralAuth-Bug39996' => "udp://$wmfUdp2logDest/centralauth-bug39996", // -legoktm 2014-07-14 for bug 39996
		'CentralAuthRename' => "udp://$wmfUdp2logDest/centralauthrename", // -legoktm 2014-07-14 for bug 67875
		'GettingStarted' => "udp://$wmfUdp2logDest/gettingstarted",
		'zero' => "udp://$wmfUdp2logDest/zero", // zero-rated debug log
		'DBPerformance' => "udp://$wmfUdp2logDest/dbperformance",
		'CirrusSearch' => "udp://$wmfUdp2logDest/CirrusSearch",
		'CirrusSearchChangeFailed' => "udp://$wmfUdp2logDest/CirrusSearch-failed",
		'CirrusSearchRequests' => "udp://$wmfUdp2logDest/CirrusSearch-all",
		'CirrusSearchSlowRequests' => "udp://$wmfUdp2logDest/CirrusSearch-slow",
		'texvc' => "udp://$wmfUdp2logDest/texvc",
		'Bug54847' => "udp://$wmfUdp2logDest/Bug54847",
		'recursion-guard' => "udp://$wmfUdp2logDest/recursion-guard",
		'MassMessage' => "udp://$wmfUdp2logDest/MassMessage", // for bug 57464 -legoktm 2013/12/15
		'Bug58676' => "udp://$wmfUdp2logDest/Bug58676", # Invalid message parameter
		'Flow' => "udp://$wmfUdp2logDest/Flow", // -erikb 2014/03/08
		'upload' => "udp://$wmfUdp2logDest/upload",
		'Wikibase\UpdateRepoOnMoveJob' => "udp://$wmfUdp2logDest/updateRepoOnMove",
		'BounceHandler' => "udp://$wmfUdp2logDest/bouncehandler",
		'Echo' => "udp://$wmfUdp2logDest/echo",
	),

	'+enwiki' => array(
		'bug46577' => "udp://$wmfUdp2logDest/bug46577", // Education Program debugging
	),

	'+private' => array(
		'slow-parse' => "udp://$wmfUdp2logDest/privatewiki-slow-parse",
	),

	// To measure the # of articles on enwiki during the <million => >million transition
	'+testwiki' => array(
		'articles' => "udp://$wmfUdp2logDest/articles/testwiki",
		'imagemove' => "udp://$wmfUdp2logDest/imagemove",
	),
),
# @} end of wgDebugLogGroup

'wgOverrideSiteFeed' => array(
	'testwiki' => array(
		'rss' => 'http://www.example.org/feedstuff.rss',
	),
	'enwikinews' => array(
		'atom' => 'http://en.wikinews.org/w/index.php?title=Special:NewsFeed&feed=atom&categories='
			. 'Published&notcategories=No%20publish%7CArchived%7CAutoArchived%7Cdisputed&namespace=0&count=30&hourcount=124&ordermethod=categoryadd&stablepages=only',
	),
	'fawikinews' => array(
		'atom' => 'http://fa.wikinews.org/w/index.php?title=Special:NewsFeed&feed=atom&categories='
			. '%D9%85%D9%86%D8%AA%D8%B4%D8%B1%D8%B4%D8%AF%D9%87&notcategories=%D9%85%D8%B1%D9%88%D8%B1|%D9%85%D8%B1%D9%88%D8%B1_%D9%81%D9%88%D8%B1%DB%8C|%D8%B5%D9%81%D8%AD%D9%87%E2%80%8C%D9%87%D8%A7%DB%8C_%D9%86%D8%A7%D9%85%D8%B2%D8%AF_%D8%AD%D8%B0%D9%81_%D8%B3%D8%B1%DB%8C%D8%B9'
			. '&namespace=0&count=30&hourcount=124&ordermethod=categoryadd&stablepages=only',
		'rss' => 'http://fa.wikinews.org/w/index.php?title=Special:NewsFeed&feed=rss&categories='
			. '%D9%85%D9%86%D8%AA%D8%B4%D8%B1%D8%B4%D8%AF%D9%87&notcategories=%D9%85%D8%B1%D9%88%D8%B1|%D9%85%D8%B1%D9%88%D8%B1_%D9%81%D9%88%D8%B1%DB%8C|%D8%B5%D9%81%D8%AD%D9%87%E2%80%8C%D9%87%D8%A7%DB%8C_%D9%86%D8%A7%D9%85%D8%B2%D8%AF_%D8%AD%D8%B0%D9%81_%D8%B3%D8%B1%DB%8C%D8%B9'
			. '&namespace=0&count=30&hourcount=124&ordermethod=categoryadd&stablepages=only'
	),
),

# wgExtraNamespaces @{
	// Recommended namespace numbers:
	//    100 Portal
	//    102 WikiProject
	//    104 Reference
	// Wikis are sorted by family (type), and then alphabetically

'wgExtraNamespaces' => array(
	// Meta wiki @{
	'metawiki' => array(
		200 => 'Grants',    // Bug 22810
		201 => 'Grants_talk',
		202 => 'Research',  // Bug 28742
		203 => 'Research_talk',
		204 => 'Participation',
		205 => 'Participation_talk',
		206 => 'Iberocoop', // Bug 38398
		207 => 'Iberocoop_talk',
		208 => 'Programs', // bug 49312
		209 => 'Programs_talk',
	),
	// @}

	# Wikimania wikis @{
	'wikimania2005wiki' => array(
		100 => 'Internal',
		101 => 'Internal_talk',
	),
	'wikimania' => array(
		100 => 'Proceedings',
		101 => 'Proceedings_talk',
	),
	# @}

	# special wikis @{
	'arbcom_enwiki' => array(
		100 => 'Case',
		101 => 'Case_talk',
		102 => 'Wpuser',
		103 => 'Wpuser_talk',
	),
	'arbcom_dewiki' => array(
		100 => 'Anfrage',
		101 => 'Anfrage_Diskussion',
	),
	'boardwiki' => array(
		100 => 'Resolution',
		101 => 'Resolution_talk',
	),
	'commonswiki' => array(
		100 => 'Creator',
		101 => 'Creator_talk',
		102 => 'TimedText', # For video subtitles -- BV 2009-11-08
		103 => 'TimedText_talk',
		104 => 'Sequence',
		105 => 'Sequence_talk',
		106 => 'Institution',
		107 => 'Institution_talk',
	),
	'chapcomwiki' => array(
		100 => 'Draft', // bug 64123
		101 => 'Draft_talk',
		102 => 'Affiliate', // bug 69549
		103 => 'Affiliate_talk',
	),
	'labswiki' => array(
		110 => 'Obsolete',
		111 => 'Obsolete_talk',
		112 => 'Ops',
		113 => 'Ops_talk',
	),
	'mediawikiwiki' => array(
		100 => 'Manual',
		101 => 'Manual_talk',
		102 => 'Extension',
		103 => 'Extension_talk',
		104 => 'API',
		105 => 'API_talk',
		106 => 'Skin',
		107 => 'Skin_talk',
	),
	'nlwikimedia' => array(
		100 => 'De_Wikiaan',
		101 => 'Overleg_De_Wikiaan',
	),
	'officewiki' => array(
		100 => 'Report',
		101 => 'Report_talk',
		110 => 'Outreach',
		111 => 'Outreach_talk',
		112 => 'Archive',
		113 => 'Archive_talk',
	),
	'otrs_wikiwiki' => array(
		100 => 'Response',
		101 => 'Response_talk'
	),
	'sewikimedia' => array(
		100 => 'Projekt',
		101 => 'Projektdiskussion',
	),
	'stewardwiki' => array( // http://bugzilla.wikimedia.org/show_bug.cgi?id=28773
		100 => 'Case',
		101 => 'Case_talk',
		102 => 'Archive',
		103 => 'Archive_talk',
		104 => 'Proposal',
		105 => 'Proposal_talk',
	),
	'strategywiki' => array(
		106 => "Proposal",
		107 => "Proposal_talk",
	),
	'testwiki' => array(
		100 => 'Test_namespace_1',
		101 => 'Test_namespace_1_talk',
		102 => 'Test_namespace_2',
		103 => 'Test_namespace_2_talk',
	),
	'test2wiki' => array(
		100 => 'Portal',
		101 => 'Portal_talk',
		102 => 'Author',
		103 => 'Author_talk',
		104 => 'Page',
		105 => 'Page_talk',
		106 => 'Index',
		107 => 'Index_talk',
	),
	'usabilitywiki' => array(
		100 => 'Multimedia',
		101 => 'Multimedia_talk',
	),
	'vewikimedia' => array(
		100 => 'WLM',
		101 => 'WML_discusión',
		102 => 'Wikiviajes',
		103 => 'Wikiviajes_discusión',
	),
	# @} end of special wikis

	// Wikipedia @{
	'afwiki' => array(
		100 => 'Portaal',
		101 => 'Portaalbespreking',
	),
	'alswiki' => array(
		100 => 'Portal',
		101 => 'Portal_Diskussion',
		102 => 'Buech',
		103 => 'Buech_Diskussion',
		104 => 'Wort',
		105 => 'Wort_Diskussion',
		106 => 'Text',
		107 => 'Text_Diskussion',
		108 => 'Spruch',
		109 => 'Spruch_Diskussion',
		110 => 'Nochricht',
		111 => 'Nochricht_Diskussion',
	),
	'amwiki' => array(
		100 => 'በር',  # 28727
		101 => 'በር_ውይይት',
	),
	'anwiki' => array(
		100 => 'Portal',
		101 => 'Descusión_Portal',
	),
	'arwiki' => array(
	100 => 'بوابة',
	101 => 'نقاش_البوابة',
	104 => 'ملحق',
	105 => 'نقاش_الملحق',
	),
	'arzwiki' => array(
		100 => 'بوابة',
		101 => 'مناقشة_بوابة',
	),
	'aswiki' => array(
			100 => "ৱিকিচ'ৰা", // Portal
			101 => "ৱিকিচ'ৰা_আলোচনা",// Portal talk
	),
	'azwiki' => array(
		100 => 'Portal',
		101 => 'Portal_müzakirəsi',
	),
	'bawiki' => array(
		100 => 'Портал',                     // Bug 42077 - Portal
		101 => 'Портал_буйынса_фекерләшеү',
		102 => 'Проект',                     // Bug 42077 - Project
		103 => 'Проект_буйынса_фекерләшеү',
	),
	'barwiki' => array(
		100 => 'Portal',
		101 => 'Portal_Dischkrian',     // Bug 41962 comment #7
		102 => 'Buach',                 // Bug 41962 - Wikibooks alt.
		103 => 'Buach_Dischkrian',
		104 => 'Woat',                  // Bug 41962 - Wiktionary alt.
		105 => 'Woat_Dischkrian',
		106 => 'Text',                  // Bug 41962 - Wikisource alt.
		107 => 'Text_Dischkrian',
		108 => 'Spruch',                // Bug 41962 - Wikiquote alt.
		109 => 'Spruch_Dischkrian',
		110 => 'Nochricht',             // Bug 41962 - Wikinews alt.
		111 => 'Nochricht_Dischkrian',
	),
	'bewiki' => array(
		100 => 'Партал', // Portal
		101 => 'Размовы_пра_партал', // Portal talk
	),
	'be_x_oldwiki' => array(
		100 => 'Партал',
		101 => 'Абмеркаваньне_парталу',
	),
	'bgwiki' => array(
		100 => 'Портал',
		101 => 'Портал_беседа',
	),
	'bnwiki' => array(
		100 => 'প্রবেশদ্বার',
		101 => 'প্রবেশদ্বার_আলোচনা',
	),
	'bpywiki' => array(
		100 => 'হমিলদুৱার', // Portal
		101 => 'হমিলদুৱার_য়্যারী', // Portal_talk
	),
	'bswiki' => array(
		100 => 'Portal', // Bug 37226
		101 => 'Razgovor_o_portalu', // Bug 37226
	),
	'cawiki' => array(
		100 => 'Portal', 101 => 'Portal_Discussió',
		102 => 'Viquiprojecte', 103 => 'Viquiprojecte_Discussió',
	),
	'cewiki' => array(
		NS_PROJECT_TALK => 'Википедин_дийцаре', // Bug 47574
		100 => 'Ков',
		101 => 'Ков_дийцаре',
	),
	'ckbwiki' => array(
		100 => 'دەروازە',
		101 => 'لێدوانی_دەروازە',
		102 => 'ویکیپرۆژە', // bug 52665
		103 => 'لێدوانی_ویکیپرۆژە', // bug 52665
	),
	'cswiki' => array(
		NS_USER			=> 'Wikipedista',    # language default set back in wgNamespaceAliases
		NS_USER_TALK	=> 'Diskuse_s_wikipedistou', # language default set back in wgNamespaceAliases
		100		=> 'Portál',
		101		=> 'Diskuse_k_portálu',
		102		=> 'Rejstřík',
		103		=> 'Diskuse_k_rejstříku',
	),
	'cywiki' => array(
		100     => 'Porth', # 27684
		101     => 'Sgwrs_Porth', # 27684
	),
	'dawiki' => array(
		NS_PROJECT_TALK   => 'Wikipedia-diskussion', # bug 27902
		NS_MEDIAWIKI_TALK => 'MediaWiki-diskussion', # bug 27902
		NS_HELP_TALK      => 'Hjælp-diskussion',     # bug 27902
		100 => 'Portal',
		101 => 'Portaldiskussion',
		102 => 'Artikeldata',
		103 => 'Artikeldatadiskussion'
	),
	'dewiki' => array(
		100 => 'Portal',
		101 => 'Portal_Diskussion'
	),
	'dvwiki' => array(
		NS_PROJECT_TALK => 'ވިކިޕީޑިއާ_ޚިޔާލު', // bug 48075
		100 => 'ނެރު',
		101 => 'ނެރު_ޚިޔާލު',
	),
	'elwiki' => array(
		100 => 'Πύλη',
		101 => 'Συζήτηση_πύλης'
	),
	'enwiki' => array(
		100 => 'Portal',
		101 => 'Portal_talk',
		# 106 => 'Table',
		# 107 => 'Table_talk',
		108 => 'Book',
		109 => 'Book_talk',
		118 => 'Draft', // bug 57569
		119 => 'Draft_talk',
	),
	'eowiki' => array(
		100 => 'Portalo',
		101 => 'Portala_diskuto',
		102 => 'Projekto',
		103 => 'Projekta_diskuto',
	),
	'eswiki' => array(
		100 => 'Portal',
		101 => 'Portal_Discusión',
		102 => 'Wikiproyecto',
		103 => 'Wikiproyecto_Discusión',
		104 => 'Anexo', # http://bugzilla.wikimedia.org/show_bug.cgi?id=9304
		105 => 'Anexo_Discusión',
	),
	'etwiki' => array(
		100 => 'Portaal',
		101 => 'Portaali_arutelu',
	),
	'euwiki' => array(
		100 => 'Atari', // portal
		101 => 'Atari_eztabaida',
		102 => 'Wikiproiektu',
		103 => 'Wikiproiektu_eztabaida',
	),
	'fawiki' => array(
		100 => 'درگاه',
		101 => 'بحث_درگاه',
		102 => 'کتاب',
		103 => 'بحث_کتاب',
	),
	'fiwiki' => array(
		100 => 'Teemasivu',
		101 => 'Keskustelu_teemasivusta',
		102 => 'Metasivu',
		103 => 'Keskustelu_metasivusta',
		104 => 'Kirja',
		105 => 'Keskustelu_kirjasta',
	),
	'frrwiki' => array( // Per bug 38023
		102 => 'Seite',
		103 => 'Seite_Diskussion',
		104 => 'Index',
		105 => 'Index_Diskussion',
		106 => 'Text',
		107 => 'Text_Diskussion',
	),
	'frwiki' => array(
		100 => 'Portail',
		101 => 'Discussion_Portail',
		102 => 'Projet',
		103 => 'Discussion_Projet',
		104 => 'Référence',
		105 => 'Discussion_Référence',
	),
	'glwiki' => array(
		100 => 'Portal',
		101 => 'Conversa_portal', // Bug 41213
		102 => 'Libro',
		103 => 'Conversa_libro',
	),
	'hewiki' => array(
		100 => 'פורטל',
		101 => 'שיחת_פורטל',
		108 => 'ספר', // Book
		109 => 'שיחת_ספר', // Book talk
	),
	'hiwiki' => array(
		100 => 'प्रवेशद्वार',
		101 => 'प्रवेशद्वार_वार्ता',
	),
	'hrwiki' => array(
		100 => 'Portal',
		101 => 'Razgovor_o_portalu',
		102 => 'Dodatak',
		103 => 'Razgovor_o_dodatku'
	),
	'huwiki' => array(
		100 => 'Portál',
		101 => 'Portálvita',
	),
	'hywiki' => array(
		100 => 'Պորտալ',
		101 => 'Պորտալի_քննարկում',
	),
	'iawiki' => array(
		100 => 'Portal',
		101 => 'Discussion_Portal',
		102 => 'Appendice',
		103 => 'Discussion_Appendice',
	),
	'idwiki' => array(
		100 => 'Portal',
		101 => 'Pembicaraan_Portal'
	),
	'iswiki' => array(
		100 => 'Gátt',
		101 => 'Gáttaspjall'
	),
	'itwiki' => array(
		100 => 'Portale',
		101 => 'Discussioni_portale',
		102 => 'Progetto',
		103 => 'Discussioni_progetto',
	),
	'jawiki' => array(
		NS_TALK => "ノート",
		NS_USER_TALK => "利用者‐会話",
		NS_PROJECT_TALK => "Wikipedia‐ノート",
		NS_FILE_TALK => "ファイル‐ノート",
		NS_MEDIAWIKI_TALK => "MediaWiki‐ノート",
		NS_TEMPLATE => "Template",
		NS_TEMPLATE_TALK => "Template‐ノート",
		NS_HELP => "Help",
		NS_HELP_TALK => "Help‐ノート",
		NS_CATEGORY => "Category",
		NS_CATEGORY_TALK => "Category‐ノート",
		100 => 'Portal',
		101 => 'Portal‐ノート',
		102 => 'プロジェクト',
		103 => 'プロジェクト‐ノート',
		829 => 'モジュール‐ノート', // Bug 47933
	),
	'kawiki' => array(
		100 => 'პორტალი',
		101 => 'პორტალი_განხილვა',
	),
	'kkwiki' => array(
		100 => 'Портал',   // Portal
		101 => 'Портал_талқылауы',
		102 => 'Жоба',              // Bug 40794 - WikiProject
		103 => 'Жоба_талқылауы',
	),
	'kowiki' => array(
		100 => '들머리',
		101 => '들머리토론',
		102 => '위키프로젝트', # 27651
		103 => '위키프로젝트토론', # 27651
	),
	'kuwiki' => array(
		100 => 'Portal',
		101 => 'Gotûbêja_portalê', // Bug 37521
		NS_PROJECT_TALK => 'Gotûbêja_Wîkîpediyayê', // Bug 37521
	),
	'kwwiki' => array(
		100 => 'Porth',
		101 => 'Keskows_Porth',
	),
	'lawiki' => array(
		100 => 'Porta',
		101 => 'Disputatio_Portae',
	),
	'liwiki' => array(
		100 => 'Portaol',
		101 => 'Euverlèk_portaol',
	),
	'lmowiki' => array(
		100 => 'Portal',
		101 => 'Descüssiú_Portal',
		102 => 'Purtaal',
		103 => 'Descüssiun_Purtaal',
	),
	'ltwiki' => array(
		100 => 'Vikisritis',
		101 => 'Vikisrities_aptarimas',
		102 => 'Vikiprojektas',
		103 => 'Vikiprojekto_aptarimas',
		104 => 'Sąrašas',
		105 => 'Sąrašo_aptarimas' ,
	),
	'lvwiki' => array(
		100 => 'Portāls',
		101 => 'Portāla_diskusija',
		102 => 'Vikiprojekts',
		103 => 'Vikiprojekta_diskusija',
	),
	'mkwiki' => array(
		100 => 'Портал',
		101 => 'Разговор_за_Портал',
	),
	'mlwiki' => array(
		100 => 'കവാടം',
		101 => 'കവാടത്തിന്റെ_സംവാദം'
	),
	'minwiki' => array(
		100 => 'Portal', // Portal
		101 => 'Diskusi_Portal', // Portal talk
	),
	'mrwiki' => array(
		100 => 'दालन',
		101 => 'दालन_चर्चा',
	),
	'mtwiki' => array(
		100 => 'Portal',
		101 => 'Diskussjoni_portal',
	),
	'mswiki' => array(
		100 => 'Portal',
		101 => 'Perbualan_Portal',
	),
	'mznwiki' => array(
		100 => 'پورتال', # Portal
		101 => 'پورتال_گپ', # Portal talk
	),

	'ndswiki' => array(
		100 => 'Portal',
		101 => 'Portal_Diskuschoon'
	),
	'newwiki' => array(
		100 => 'दबू',
		101 => 'दबू_खँलाबँला',
	),
	'nlwiki' => array(
		100 => 'Portaal',
		101 => 'Overleg_portaal'
	),
	'nnwiki' => array(
		100 => 'Tema',
		101 => 'Temadiskusjon',
	),
	'nowiki' => array(
		100 => 'Portal',
		101 => 'Portaldiskusjon',
	),
	'ocwiki' => array(
		100 => 'Portal',
		101 => 'Discussion_Portal',
		102 => 'Projècte',
		103 => 'Discussion_Projècte',
	),
	'orwiki' => array( // bug 58453
		100 => 'ପୋର୍ଟାଲ',
		101 => 'ପୋର୍ଟାଲ_ଆଲୋଚନା',
	),
	'pflwiki' => array(
		100 => 'Portal', // Bug 42990
		101 => 'Portal_Diskussion',
		102 => 'Buch', // 102-111: bug 52671
		103 => 'Buch_Dischbediere',
		104 => 'Wort',
		105 => 'Wort_Dischbediere',
		106 => 'Text',
		107 => 'Text_Dischbediere',
		108 => 'Spruch',
		109 => 'Spruch_Dischbediere',
		110 => 'Nochricht',
		111 => 'Nochricht_Dischbediere',
	),
	'plwiki' => array(
		NS_PROJECT_TALK => 'Dyskusja_Wikipedii',
		NS_USER => 'Wikipedysta',
		# Lower case w in wikipedysty as per bug #10064
		NS_USER_TALK => 'Dyskusja_wikipedysty',
		100 => 'Portal',
		101 => 'Dyskusja_portalu',
		102 => 'Wikiprojekt',
		103 => 'Dyskusja_wikiprojektu',
	),
	'ptwiki' => array(
		NS_USER => 'Usuário(a)', // bug 27495
		NS_USER_TALK => 'Usuário(a)_Discussão',
		100 => 'Portal',
		101 => 'Portal_Discussão',
		102 => 'Anexo',
		103 => 'Anexo_Discussão',
		104 => 'Livro',
		105 => 'Livro_Discussão',
	),
	'roa_tarawiki' => array(
		100 => 'Portale',
		101 => "'Ngazzaminde_d'u_Portale",
	),
	'rowiki' => array(
		100 => 'Portal',
		101 => 'Discuție_Portal',
		102 => 'Proiect',
		103 => 'Discuție_Proiect',
		108 => 'Cod', // Bug 42690 - Code
		109 => 'Discuție_Cod',
		110 => 'Carte', // bug 66530
		111 => 'Discuție_Carte',
	),
	'ruwiki' => array(
		100 => 'Портал',
		101 => 'Обсуждение_портала',
		102 => 'Инкубатор', // Incubator
		103 => 'Обсуждение_Инкубатора', // Incubator talk
		104 => 'Проект', // Bug 34124 - Project
		105 => 'Обсуждение_проекта', // Bug 34124 - Project talk
		106 => 'Арбитраж', // Bug 34527 - Arbcom
		107 => 'Обсуждение_арбитража',
	),
	'scnwiki' => array(
		100 => 'Purtali',
		101 => 'Discussioni_purtali',
		102 => 'Pruggettu',
		103 => 'Discussioni_pruggettu',
	),
	'scowiki' => array(
		100 => 'Portal', // Bug 66107
		101 => 'Portal_talk',
	),
	'sewiki' => array(
		100 => 'Portála',              //Bug 39206
		101 => 'Portálaságastallan',   //Bug 39206
	),
	'shwiki' => array( 100 => 'Portal', 101 => 'Razgovor_o_portalu' ), # bug 30928
	'siwiki' => array( 100 => 'ද්වාරය', 101 => 'ද්වාරය_සාකච්ඡාව' ), # bug 6435, 24936
	'skwiki' => array( 100 => 'Portál', 101 => 'Diskusia_k_portálu' ),
	'slwiki' => array( 100 => 'Portal', 101 => 'Pogovor_o_portalu' ),
	'sowiki' => array( 100 => 'Portal', 101 => 'Portal_talk' ), // bug 49600
	'sqwiki' => array( 100 => 'Portal', 101 => 'Portal_diskutim' ),
	'srwiki' => array(
		100 => 'Портал',
		101 => 'Разговор_о_порталу',
	),
	'suwiki' => array( 100 => 'Portal', 101 => 'Obrolan_portal' ), # bug 8156
	'svwiki' => array( 100 => 'Portal', 101 => 'Portaldiskussion' ),
	'swwiki' => array(
		100 => 'Lango',
		101 => 'Majadiliano_ya_lango',
	),
	'tawiki' => array( 100 => 'வலைவாசல்', 101 => 'வலைவாசல்_பேச்சு', ),
	'tewiki' => array( 100 => 'వేదిక', 101 => 'వేదిక_చర్చ', ),
	'tgwiki' => array(
		100 => 'Портал',
		101 => 'Баҳси_портал',
	),
	'thwiki' => array(
		100 => 'สถานีย่อย',
		101 => 'คุยเรื่องสถานีย่อย',
	),
	'tlwiki' => array(
		100 => 'Portada', // Portal
		101 => 'Usapang_Portada', // Portal talk
	),
	'trwiki' => array(
		100 => 'Portal',
		101 => 'Portal_tartışma'
	),
	'ttwiki' => array(
		100 => 'Портал',
		101 => 'Портал_бәхәсе',
	),
	'udmwiki' => array(
		NS_PROJECT_TALK => 'Википедия_сярысь_вераськон', // Bug 47820
	),
	'ukwiki' => array( 100 => 'Портал', 101 => 'Обговорення_порталу' ),
	'urwiki' => array(
		100 => 'باب', // Portal - bug 19569
		101 => 'تبادلۂ_خیال_باب', // Portal talk - bug 19569
	),
	'uzwiki' => array (
		100 => 'Portal',                     //Bug 38840 (Portal)
		101 => 'Portal_munozarasi',          //Bug 38840
		102 => 'Loyiha',                     //Bug 38840 (Project)
		103 => 'Loyiha_munozarasi',          //Bug 38840
	),
	'vecwiki' => array(
		100 => 'Portałe',
		101 => 'Discussion_portałe',
		102 => 'Projeto',
		103 => 'Discussion_projeto',
	),
	'viwiki' => array( 100 => 'Chủ_đề', 101 => 'Thảo_luận_Chủ_đề' ),
	'wuuwiki' => array(
		100 => 'Transwiki',
		101 => 'Transwiki_talk',
	),
	'yiwiki' => array(
		100 => 'פארטאל',
		101 => 'פארטאל_רעדן',
	),
	'yowiki' => array(
		100 => 'Èbúté',
		101 => 'Ọ̀rọ̀_èbúté',
		108 => 'Ìwé',
		109 => 'Ọ̀rọ̀_ìwé',
	),
	'zhwiki' => array( 100 => 'Portal', 101 => 'Portal_talk' ),
	'zh_classicalwiki' => array( 100 => '門', 101 => '議' ),
	'zh_min_nanwiki' => array( 100 => 'Portal', 101 => 'Portal_talk' ),
	'zh_yuewiki' => array(
		# Override MediaWiki default namespace names for "yue".
		NS_MEDIA		=> 'Media',
		NS_SPECIAL		=> 'Special',
		NS_TALK			=> 'Talk',
		NS_USER			=> 'User',
		NS_USER_TALK	=> 'User_talk',
		NS_PROJECT_TALK	=> '$1_talk',
		NS_FILE			=> 'File',
		NS_FILE_TALK	=> 'File_talk',
		NS_MEDIAWIKI_TALK	=> 'MediaWiki_talk',
		NS_TEMPLATE			=> 'Template',
		NS_TEMPLATE_TALK	=> 'Template_talk',
		NS_HELP				=> 'Help',
		NS_HELP_TALK		=> 'Help_talk',
		NS_CATEGORY			=> 'Category',
		NS_CATEGORY_TALK	=> 'Category_talk',
		# Additional namespaces.
		100 => 'Portal',
		101 => 'Portal_talk',
	),
	// @} end of Wikipedia

	// Wikisource wikis @{
	// Please reserve NS 114 for 'Translation', thanks!

	'sourceswiki' => array(
		104 => 'Page',
		105 => 'Page_talk',
		106 => 'Index',
		107 => 'Index_talk',
		108 => 'Author',
		109 => 'Author_talk',
	),
	'azwikisource' => array(
		100 => 'Portal',
		101 => 'Portal_müzakirəsi',
		102 => 'Müəllif', // Author
		103 => 'Müəllif_müzakirəsi', // Author talk
	),
	'arwikisource' => array(
		100 => 'بوابة',
		101 => 'نقاش_البوابة',
		102 => 'مؤلف',
		103 => 'نقاش_المؤلف',
		104 => 'صفحة',
		105 => 'نقاش_الصفحة',
		106 => 'فهرس',
		107 => 'نقاش_الفهرس',
	),
	'aswikisource' => array(
		102 => 'লেখক',       // Bug 70464 - Author
		103 => 'লেখক_আলোচনা',
		104 => 'পৃষ্ঠা',       // Bug 43129 - Page
		105 => 'পৃষ্ঠা_আলোচনা',
		106 => 'সূচী',       // Bug 43129 - Index
		107 => 'সূচী_আলোচনা',
	),
	'bewikisource' => array(
		102 => 'Аўтар', // Author
		103 => 'Размовы_пра_аўтара',
		104 => 'Старонка', // Page
		105 => 'Размовы_пра_старонку',
		106 => 'Індэкс', // Index
		107 => 'Размовы_пра_індэкс',
	),
	'bgwikisource' => array(
		100 => 'Автор',
		101 => 'Автор_беседа',
	),
	'bnwikisource' => array(
		100 => 'লেখক', // Author
		101 => 'লেখক_আলাপ', // Author talk
		102 => 'নির্ঘণ্ট', // Index
		103 => 'নির্ঘণ্ট_আলাপ',
		104 => 'পাতা', // Page
		105 => 'পাতা_আলাপ',
		106 => 'প্রবেশদ্বার', // Portal
		107 => 'প্রবেশদ্বার_আলাপ',
	),
	'brwikisource' => array(
		100 => 'Meneger',
		101 => 'Kaozeadenn_meneger',
		102 => 'Pajenn',
		103 => 'Kaozeadenn_pajenn',
		104 => 'Oberour',
		105 => 'Kaozeadenn_oberour',
	),
	'cawikisource' => array(
		# 100, 101 reserved for Portal
		102 => 'Pàgina', // http://bugzilla.wikimedia.org/show_bug.cgi?id=15784
		103 => 'Pàgina_Discussió',
		104 => 'Llibre',
		105 => 'Llibre_Discussió',
		106 => 'Autor', # 27898
		107 => 'Autor_Discussió',  # 27898
	),
	'cswikisource' => array(
		100		=> 'Autor',
		101		=> 'Diskuse_k_autorovi',
	),
	'cywikisource' => array(
		104 => 'Tudalen',          //Bug 39264 (Page)
		105 => 'Sgwrs_Tudalen',    //Bug 39264
		106 => 'Indecs',           //Bug 39264 (Index)
		107 => 'Sgwrs_Indecs',     //Bug 39264
	),
	'dawikisource' => array(
		102 => 'Forfatter', // http://bugzilla.wikimedia.org/show_bug.cgi?id=7796
		103 => 'Forfatterdiskussion',
		104 => 'Side', // bug 24440
		105 => 'Sidediskussion',
		106 => 'Indeks',
		107 => 'Indeksdiskussion',
	),
	'dewikisource' => array(
		102 => 'Seite', // http://bugzilla.wikimedia.org/show_bug.cgi?id=11101
		103 => 'Seite_Diskussion',
		104 => 'Index', // http://bugzilla.wikimedia.org/show_bug.cgi?id=11101
		105 => 'Index_Diskussion',
	),
	'elwikisource' => array(
		100 => 'Σελίδα',
		101 => 'Συζήτηση_σελίδας',
		102 => 'Βιβλίο',
		103 => 'Συζήτηση_βιβλίου',
	),
	'enwikisource' => array(
		100 => 'Portal',
		101 => 'Portal_talk',
		102 => 'Author',
		103 => 'Author_talk',
		104 => 'Page', // http://fr.wikisource.org/wiki/Wikisource:Scriptorium#Page:_Namespace
		105 => 'Page_talk',
		106 => 'Index',
		107 => 'Index_talk',
		114 => 'Translation', // bug 50007
		115 => 'Translation_talk', // bug 50007
	),
	'eowikisource' => array(
		102 => 'Aŭtoro', // Author
		103 => 'Aŭtoro-Diskuto', // Author talk
		104 => 'Paĝo',
		105 => 'Paĝo-Diskuto',
		106 => 'Indekso',
		107 => 'Indekso-Diskuto',
	),
	'eswikisource' => array(
		102 => 'Página', // http://bugzilla.wikimedia.org/show_bug.cgi?id=15775
		103 => 'Página_Discusión',
		104 => 'Índice',
		105 => 'Índice_Discusión',
	),
	'etwikisource' => array(
		102 => 'Lehekülg',
		103 => 'Lehekülje_arutelu',
		104 => 'Register',
		105 => 'Registri_arutelu',
		106 => 'Autor',
		107 => 'Autori_arutelu',
	),
	'fawikisource' => array(
		100 => 'درگاه', // Portal
		101 => 'بحث_درگاه', // Portal talk
		102 => 'پدیدآورنده', // Author
		103 => 'گفتگو_پدیدآورنده', // Author talk
		104 => 'برگه', // Page
		105 => 'گفتگوی_برگه', // Page talk
		106 => 'فهرست', // Index
		107 => 'گفتگوی_فهرست', // Index talk
	),
	'frwikisource' => array(
		100 => 'Transwiki',
		101 => 'Discussion_Transwiki',
		102 => 'Auteur',
		103 => 'Discussion_Auteur',
		104 => 'Page', // http://fr.wikisource.org/wiki/Wikisource:Scriptorium#Page:_Namespace
		105 => 'Discussion_Page',
		106 => 'Portail',
		107 => 'Discussion_Portail',
		112 => 'Livre',
		113 => 'Discussion_Livre',
	),
	'guwikisource' => array(
		104 => 'પૃષ્ઠ', // Page
		105 => 'પૃષ્ઠ_ચર્ચા',
		106 => 'સૂચિ', // Index "list"
		107 => 'સૂચિ_ચર્ચા',
		108 => 'સર્જક', // Author
		109 => 'સર્જક_ચર્ચા',
	),
	'hewikisource' => array(
		100 => 'קטע',
		101 => 'שיחת_קטע',
		104 => 'עמוד',
		105 => 'שיחת_עמוד',
		106 => 'ביאור',
		107 => 'שיחת_ביאור',
		108 => 'מחבר',
		109 => 'שיחת_מחבר',
		110 => 'תרגום',
		111 => 'שיחת_תרגום',
		112 => 'מפתח',
		113 => 'שיחת_מפתח',
		116 => 'מקור', // bug 64353
		117 => 'שיחת_מקור', // bug 64353
	),
	'hrwikisource' => array(
		100 => 'Autor',
		101 => 'Razgovor_o_autoru',
		102 => 'Stranica',
		103 => 'Razgovor_o_stranici',
		104 => 'Sadržaj',
		105 => 'Razgovor_o_sadržaju',
	),
	'huwikisource' => array(
		100 => 'Szerző',
		101 => 'Szerző_vita',
		104 => 'Oldal',
		105 => 'Oldal_vita',
		106 => 'Index',
		107 => 'Index_vita',
	),
	'hywikisource' => array(
		100 => 'Հեղինակ',
		101 => 'Հեղինակի_քննարկում',
		102 => 'Պորտալ',
		103 => 'Պորտալի_քննարկում',
		104 => 'Էջ',
		105 => 'Էջի_քննարկում',
		106 => 'Ինդեքս',
		107 => 'Ինդեքսի_քննարկում',
	),
	'idwikisource' => array(
		100 => 'Pengarang',
		101 => 'Pembicaraan_Pengarang',
		102 => 'Indeks',
		103 => 'Pembicaraan_Indeks',
		104 => 'Halaman',
		105 => 'Pembicaraan_Halaman',
		106 => 'Portal',
		107 => 'Pembicaraan_Portal',
	),
	'iswikisource' => array(
		100 => 'Gátt', // Bug 44164
		101 => 'Gáttarspjall', // Bug 44164
		102 => 'Höfundur', // Bug 44164
		103 => 'Höfundarspjall', // Bug 44164
	),
	'itwikisource' => array(
		102 => 'Autore',
		103 => 'Discussioni_autore',
		104 => 'Progetto',
		105 => 'Discussioni_progetto',
		106 => 'Portale',
		107 => 'Discussioni_portale',
		108 => 'Pagina',
		109 => 'Discussioni_pagina',
		110 => 'Indice',
		111 => 'Discussioni_indice',
	),
	'knwikisource' => array( // Bug 37676
		100 => 'ಸಂಪುಟ',         // Portal
		101 => 'ಸಂಪುಟ_ಚರ್ಚೆ',
		102 => 'ಕರ್ತೃ',         // Author
		103 => 'ಕರ್ತೃ_ಚರ್ಚೆ',
		104 => 'ಪುಟ',         // Page
		105 => 'ಪುಟ_ಚರ್ಚೆ',
		106 => 'ಪರಿವಿಡಿ',         // Index
		107 => 'ಪರಿವಿಡಿ_ಚರ್ಚೆ',
	),
	'kowikisource' => array(
		100 => '저자',
		101 => '저자토론',
		102 => '포털', // Bug 69522
		103 => '포털토론',
	),
	'lawikisource' => array(
		102 => 'Scriptor',
		103 => 'Disputatio_Scriptoris',
		104 => 'Pagina',
		105 => 'Disputatio_Paginae',
		106 => 'Liber',
		107 => 'Disputatio_Libri',
	),
	'mkwikisource' => array(
		102 => 'Автор',
		103 => 'Разговор_за_автор',
	),
	'mlwikisource' => array(
		100 => 'രചയിതാവ്',
		101 => 'രചയിതാവിന്റെ_സംവാദം',
		102 => 'കവാടം',
		103 => 'കവാടത്തിന്റെ_സംവാദം',
		104 => 'സൂചിക',
		105 => 'സൂചികയുടെ_സംവാദം',
		106 => 'താൾ',
		107 => 'താളിന്റെ_സംവാദം',
	),
	'mrwikisource' => array(
		100 => 'दालन', // Portal
		101 => 'दालन_चर्चा', // Portal talk
		102 => 'साहित्यिक', // Author
		103 => 'साहित्यिक_चर्चा', // Author talk
		104 => 'पान', // Page
		105 => 'पान_चर्चा', // Page talk
		106 => 'अनुक्रमणिका', // Index
		107 => 'अनुक्रमणिका_चर्चा', // Index talk
	),
	'nlwikisource' => array(
		100 => 'Hoofdportaal',
		101 => 'Overleg_hoofdportaal',
		102 => 'Auteur',
		103 => 'Overleg_auteur',
		104 => 'Pagina',         // Bug 37482
		105 => 'Overleg_pagina', // Bug 37482
		106 => 'Index',          // Bug 37482
		107 => 'Overleg_index',  // Bug 37482
	),
	'nowikisource' => array(
		102 => 'Forfatter',
		103 => 'Forfatterdiskusjon',
		104 => 'Side',
		105 => 'Sidediskusjon',
		106 => 'Indeks',
		107 => 'Indeksdiskusjon',
	),
	'plwikisource' => array(
		NS_USER => 'Wikiskryba',
		NS_USER_TALK => 'Dyskusja_wikiskryby',
		NS_PROJECT_TALK => 'Dyskusja_Wikiźródeł',
		100 => 'Strona',
		101 => 'Dyskusja_strony',
		102 => 'Indeks',
		103 => 'Dyskusja_indeksu',
		104 => 'Autor',
		105 => 'Dyskusja_autora',
	),
	'ptwikisource' => array(
		100 => 'Portal',
		101 => 'Portal_Discussão',
		102 => 'Autor',
		103 => 'Autor_Discussão',
		104 => 'Galeria',
		105 => 'Galeria_Discussão',
		106 => 'Página',
		107 => 'Página_Discussão',
		108 => 'Em_Tradução',
		109 => 'Discussão_Em_Tradução',
		110 => 'Anexo',
		111 => 'Anexo_Discussão',
	),
	'rowikisource' => array(
		102 => 'Autor',
		103 => 'Discuție_Autor',
		104 => 'Pagină',
		105 => 'Discuție_Pagină',
		106 => 'Index',
		107 => 'Discuție_Index',
	),
	'ruwikisource' => array(
		104 => 'Страница',
		105 => 'Обсуждение_страницы',
		106 => 'Индекс',
		107 => 'Обсуждение_индекса',
	),
	'sawikisource' => array(
		104 => 'पुटम्', // Page
		105 => 'पुटसंवाद', // Page talk
		106 => 'अनुक्रमणिका', // Index
		107 => 'अनुक्रमणिकासंवाद', // Index talk
	),
	'slwikisource' => array(
		100 => 'Stran',
		101 => 'Pogovor_o_strani',
		104 => 'Kazalo',
		105 => 'Pogovor_o_kazalu',
	),
	'srwikisource' => array(
		100 => 'Аутор',
		101 => 'Разговор_о_аутору',
		102 => 'Додатак', // Bug 37742
		103 => 'Разговор_о_додатку', // Bug 37742
	),
	'svwikisource' => array(
		104 => 'Sida',
		105 => 'Siddiskussion',
		106 => 'Författare',
		107 => 'Författardiskussion',
		108 => 'Index',
		109 => 'Indexdiskussion',
	),
	'tewikisource' => array(
		100 => 'ద్వారము', // Portal
		101 => 'ద్వారము_చర్చ',
		102 => 'రచయిత', // Author
		103 => 'రచయిత_చర్చ',
		104 => 'పుట', // Page
		105 => 'పుట_చర్చ', // Page_talk
		106 => 'సూచిక', // Index
		107 => 'సూచిక_చర్చ',
	),
	'trwikisource' => array(
		100 => 'Kişi',
		101 => 'Kişi_tartışma',
	),
	'ukwikisource' => array( // bug 48308
		NS_PROJECT_TALK => 'Обговорення_Вікіджерел',
		102 => 'Автор', // Author
		103 => 'Обговорення_автора',
		114 => 'Переклад', // bug 50561
		115 => 'Обговорення_перекладу', // bug 50561
	),
	'vecwikisource' => array(
		100 => 'Autor',
		101 => 'Discussion_autor',
		102 => 'Pagina',
		103 => 'Discussion_pagina',
		104 => 'Indice',
		105 => 'Discussion_indice',
	),
	'viwikisource' => array(
		100 => 'Chủ_đề',
		101 => 'Thảo_luận_Chủ_đề',
		102 => 'Tác_gia',
		103 => 'Thảo_luận_Tác_gia',
		104 => 'Trang',
		105 => 'Thảo_luận_Trang',
		106 => 'Mục_lục',
		107 => 'Thảo_luận_Mục_lục'
	),
	'zhwikisource' => array(  // Added on 2009-03-19 per bug 15722
		102 => 'Author',
		103 => 'Author_talk',
		104 => 'Page',
		105 => 'Page_talk',
		106 => 'Index',
		107 => 'Index_talk',
		108 => 'Transwiki', # Bug 40474
		109 => 'Transwiki_talk',
		114 => 'Translation', // bug 64127
		115 => 'Translation_talk', // bug 64127
	),
	# @} end of wikisource wikis

	// Wikivoyage @{
	'fawikivoyage' => array( // Bug 71382
		106 => 'عبارت‌نامه', // Phrasebook
		107 => 'بحث_عبارت‌نامه', // Phrasebook talk
	),
	// @} end of wikivoyage wikis

	// Wiktionary @{
	'angwiktionary' => array( // bug 56634
		100 => 'Ætēaca',
		101 => 'Ætēacmōtung',
	),
	'bgwiktionary' => array(
		100 => 'Словоформи',
		101 => 'Словоформи_беседа'
	),
	'brwiktionary' => array(
		100 => 'Stagadenn', // Appendix
		101 => 'Kaozeadenn_Stagadenn', // Appendix talk
	),
	'bnwiktionary' => array(
		100 => 'উইকিসরাস',
		101 => 'উইকিসরাস_আলোচনা',
	),
	'bswiktionary' => array(
		100 => 'Portal',
		101 => 'Razgovor_o_Portalu',
		102 => 'Indeks',
		103 => 'Razgovor_o_Indeksu',
		104 => 'Dodatak',
		105 => 'Razgovor_o_Dodatku',
	),
	'cswiktionary' => array(
		100 => 'Příloha',
		101 => 'Diskuse_k_příloze',
	),
	'cywiktionary' => array(
		100 => 'Atodiad',
		101 => 'Sgwrs_Atodiad',
		102 => 'Odliadur',
		103 => 'Sgwrs_Odliadur',
		104 => 'WiciSawrws',
		105 => 'Sgwrs_WiciSawrws',
	),
	'dewiktionary' => array(
		102 => 'Verzeichnis',
		103 => 'Verzeichnis_Diskussion',
		104 => 'Thesaurus',
		105 => 'Thesaurus_Diskussion',
		106 => 'Reim', // Bug 43830
		107 => 'Reim_Diskussion',
	),
	'dvwiktionary' => array(
		NS_PROJECT_TALK => 'ވިކިރަދީފު ޚިޔާ', // Bug 46846
	),
	'elwiktionary' => array(
		100 => 'Παράρτημα',
		101 => 'Συζήτηση_παραρτήματος',
	),
	'enwiktionary' => array(
		100 => 'Appendix',
		101 => 'Appendix_talk',
		102 => 'Concordance',
		103 => 'Concordance_talk',
		104 => 'Index',
		105 => 'Index_talk',
		106 => 'Rhymes',
		107 => 'Rhymes_talk',
		108 => 'Transwiki',
		109 => 'Transwiki_talk',
		110 => 'Wikisaurus',
		111 => 'Wikisaurus_talk',
		# 112 => 'WT', # Removed these in favor of aliases --catrope 1/18/2010
		# 113 => 'WT_talk',
		114 => 'Citations',
		115 => 'Citations_talk',
		116 => 'Sign_gloss',
		117 => 'Sign_gloss_talk',
	),
	'eowiktionary' => array(
		NS_USER => 'Uzanto',	# bug 22426
		NS_USER_TALK => 'Uzanta_diskuto',
	),
	'eswiktionary' => array(
		100 => 'Apéndice',
		101 => 'Apéndice_Discusión',
	),
	'fawiktionary' => array(
		100 => "پیوست",
		101 => "بحث_پیوست",
	),
	'fiwiktionary' => array(
		100 => 'Liite', // http://bugzilla.wikimedia.org/show_bug.cgi?id=11672
		101 => 'Keskustelu_liitteestä',
	),
	'frwiktionary' => array(
		100 => 'Annexe',
		101 => 'Discussion_Annexe',
		102 => 'Transwiki',
		103 => 'Discussion_Transwiki',
		104 => 'Portail',
		105 => 'Discussion_Portail',
		106 => 'Thésaurus',
		107 => 'Discussion_Thésaurus',
		108 => 'Projet',
		109 => 'Discussion_Projet',
	),
	'gawiktionary' => array(
		100 => 'Aguisín',
		101 => 'Plé_aguisín',
	),
	'glwiktionary' => array(
		100 => 'Apéndice',
		101 => 'Conversa_apéndice',
	),
	'hewiktionary' => array(
		100 => 'נספח',
		101 => 'שיחת_נספח'
	),
	'huwiktionary' => array(
		100 => 'Függelék',       // Bug 42505 - Appendix
		101 => 'Függelékvita',
		102 => 'Index',          // Bug 42505
		103 => 'Indexvita',
	),
	'iawiktionary' => array(
		102 => 'Appendice',
		103 => 'Discussion_Appendice',
	),
	'idwiktionary' => array(
		100 => 'Indeks',
		101 => 'Pembicaraan_Indeks',
	),
	'iswiktionary' => array(
		106 => 'Viðauki',
		107 => 'Viðaukaspjall',
		110 => 'Samheitasafn',
		111 => 'Samheitasafnsspjall',
	),
	'itwiktionary' => array(
		100 => 'Appendice',
		101 => 'Discussioni_appendice',
	),
	'jawiktionary' => array(
		100 => '付録', // Appendix
		101 => '付録・トーク', // Appendix talk
	),
	'kowiktionary' => array(
		100 => '부록',
		101 => '부록_토론',
		110 => '미주알고주알',
		111 => '미주알고주알_토론',
	),
	'kuwiktionary' => array(
		NS_PROJECT_TALK => 'Gotûbêja_Wîkîferhengê', // Bug 37524
		100 => 'Pêvek', // Bug 28398
		101 => 'Gotûbêja_pêvekê', // Bug 37524
		102 => 'Nimînok', // Bug 28398
		103 => 'Gotûbêja_nimînokê', // Bug 37524
		104 => 'Portal', //Bug 28398
		105 => 'Gotûbêja_portalê', // Bug 37524
	),
	'lbwiktionary' => array(
		100 => 'Annexen',
		101 => 'Annexen_Diskussioun',
	),
	'ltwiktionary' => array(
		100 => 'Sąrašas',
		101 => 'Sąrašo_aptarimas',
		102 => 'Priedas',
		103 => 'Priedo_aptarimas',
	),
	'lvwiktionary' => array(
		100 => 'Pielikums',
		101 => 'Pielikuma_diskusija',
	),
	'mgwiktionary' => array(
		100 => 'Rakibolana', # Portal
		101 => "Dinika_amin'ny_rakibolana",
	),
	'mrwiktionary' => array(
		104 => 'सूची',
		105 => 'सूची_चर्चा',
	),
	'nowiktionary' => array(
		100 => 'Tillegg',
		101 => 'Tilleggdiskusjon',
	),
	'ocwiktionary' => array(
		100 => 'Annèxa',
		101 => 'Discussion_Annèxa',
	),
	'plwiktionary' => array(
		NS_PROJECT_TALK => 'Wikidyskusja',
		NS_USER => 'Wikipedysta',
		NS_USER_TALK => 'Dyskusja_wikipedysty',
		100 => 'Aneks',
		101 => 'Dyskusja_aneksu',
		102 => 'Indeks',
		103 => 'Dyskusja_indeksu',
		104 => 'Portal',
		105 => 'Dyskusja_portalu',
	),
	'ptwiktionary' => array(
		100 => 'Apêndice',
		101 => 'Apêndice_Discussão',
		102 => 'Vocabulário',
		103 => 'Vocabulário_Discussão',
		104 => 'Rimas',
		105 => 'Rimas_Discussão',
		106 => 'Portal',
		107 => 'Portal_Discussão',
		108 => 'Citações',
		109 => 'Citações_Discussão',
	),
	'rowiktionary' => array(
		100 => 'Portal',
		101 => 'Discuție_Portal',
		102 => 'Apendice',
		103 => 'Discuție_Apendice',
	),
	'ruwiktionary' => array(
		100 => 'Приложение',
		101 => 'Обсуждение_приложения',
		102 => 'Конкорданс',
		103 => 'Обсуждение_конкорданса',
		104 => 'Индекс',
		105 => 'Обсуждение_индекса',
		106 => 'Рифмы',
		107 => 'Обсуждение_рифм',
	),
	'srwiktionary' => array(
		100 => 'Портал',
		101 => 'Разговор_о_порталу'
	),
	'svwiktionary' => array(    # http://bugzilla.wikimedia.org/show_bug.cgi?id=7933
		102 => 'Appendix',
		103 => 'Appendixdiskussion',
		104 => 'Rimord',
		105 => 'Rimordsdiskussion',
		106 => 'Transwiki',
		107 => 'Transwikidiskussion',
	),
	'trwiktionary' => array(
		100 => 'Portal',
		101 => 'Portal_tartışma',
	),
	'ukwiktionary' => array(
		// bug 13791
		100 => 'Додаток', // appendix
		101 => 'Обговорення_додатка', // appendix talk
		102 => 'Індекс', // index
		103 => 'Обговорення_індексу', // index talk
	),
	'zhwiktionary' => array(
		100 => '附录', // bug 29641 - appendix
		101 => '附录讨论', // bug 29641 - appendix talk
		102 => 'Transwiki', # Bug 40474
		103 => 'Transwiki_talk',
	),
	// @} end of Wiktionary

	// Wikibooks @{
	'azwikibooks' => array(
		102 => 'Resept', // Recipe
		103 => 'Resept_müzakirəsi', // Recipe talk
		110 => 'Vikiuşaq', // Wikijunior, bug 31067
		111 => 'Vikiuşaq_müzakirəsi',
	),
	'bnwikibooks' => array(
		100 => 'উইকিশৈশব',
		101 => 'উইকিশৈশব_আলাপ',
		102 => 'বিষয়',
		103 => 'বিষয়_আলাপ',
	),
	'cawikibooks' => array(
		102 => 'Viquiprojecte',
		103 => 'Viquiprojecte_Discussió'
	),
	'cywikibooks' => array(
		102 => 'Silff_lyfrau',
		103 => 'Sgwrs_Silff_lyfrau'
	),
	'dewikibooks' => array(
		102 => 'Regal',
		103 => 'Regal_Diskussion'
	),
	'enwikibooks' => array(
		102 => 'Cookbook',
		103 => 'Cookbook_talk',
		108 => 'Transwiki',
		109 => 'Transwiki_talk',
		110 => 'Wikijunior',
		111 => 'Wikijunior_talk',
		112 => 'Subject',
		113 => 'Subject_talk',
	),
	/*
	'eswikibooks' => array(
		//102 => 'Wikiversidad',            // Bug 40838 (ns removed)
		//103 => 'Wikiversidad_Discusión',
	),
	*/
	'frwikibooks' => array(
		100 => 'Transwiki',
		101 => 'Discussion_Transwiki',
		102 => 'Wikijunior', # bug 35977
		103 => 'Discussion_Wikijunior', # bug 35977
	),
	'hewikibooks' => array(
		100 => 'שער', # portal
		101 => 'שיחת_שער', # portal talk
		// Skip 102 and 103, reserved for wikiproject
		104 => 'מדף', # bookshelf
		105 => 'שיחת_מדף', # bookshelf talk
	),
	'hywikibooks' => array( // bug 53162
		102 => 'Եփութուխ', // cookbook
		103 => 'Եփութուխի_քննարկում', // cookbook talk
		110 => 'Վիքիփոքրիկ', // wikijunior
		111 => 'Վիքիփոքրիկի_քննարկում', // wikijunior talk
	),
	'idwikibooks' => array(
		100 => 'Resep', # http://bugzilla.wikimedia.org/show_bug.cgi?id=7124
		101 => 'Pembicaraan_Resep',
		102 => 'Wisata',
		103 => 'Pembicaraan_Wisata',
	),
	'itwikibooks' => array(
		100 => 'Progetto', # http://bugzilla.wikimedia.org/show_bug.cgi?id=8408
		101 => 'Discussioni_progetto', # http://bugzilla.wikimedia.org/show_bug.cgi?id=11938
		102 => 'Ripiano', # http://bugzilla.wikimedia.org/show_bug.cgi?id=11937
		103 => 'Discussioni_ripiano',
		# Wikiversità deleted, http://bugzilla.wikimedia.org/show_bug.cgi?id=10287
		# 102 => 'Wikiversità', # http://bugzilla.wikimedia.org/show_bug.cgi?id=7354
		# 103 => 'Discussioni_Wikiversità',
	),
	'jawikibooks' => array(
		100 => 'Transwiki',
		101 => 'Transwiki‐ノート',
	),
	'kawikibooks' => array(
		104 => 'თარო', # bookshelf
		105 => 'თარო_განხილვა', # bookshelf talk
	),
	'kuwikibooks' => array(
		NS_PROJECT_TALK => 'Gotûbêja_Wîkîpirtûkê', // Bug 37522
	),
	'mlwikibooks' => array(
		100 => 'പാചകപുസ്തകം',		// Cookbook
		101 => 'പാചകപുസ്തകസം‌വാദം',
		102 => 'വിഷയം',				// Subject
		103 => 'വിഷയസം‌വാദം',
	),
	'mswikibooks' => array(
		100 => 'Resipi',
		101 => 'Perbualan_Resipi',
	),
	'nlwikibooks' => array(
		102 => 'Transwiki',
		103 => 'Overleg_transwiki',
		104 => 'Wikijunior',
		105 => 'Overleg_Wikijunior',
	),
	'plwikibooks' => array(
		NS_PROJECT_TALK => 'Dyskusja_Wikibooks',
		NS_USER => 'Wikipedysta',
		NS_USER_TALK => 'Dyskusja_wikipedysty',
		104 => 'Wikijunior',
		105 => 'Dyskusja_Wikijuniora',
	),
	'rowikibooks' => array(
		100 => 'Raft',
		101 => 'Discuţie_Raft',
		102 => 'Wikijunior',
		103 => 'Discuţie_Wikijunior',
		104 => 'Carte_de_bucate',
		105 => 'Discuţie_Carte_de_bucate',
	),
	'ruwikibooks' => array(
		100 => 'Полка',
		101 => 'Обсуждение_полки',
		102 => 'Импортировано',
		103 => 'Обсуждение_импортированного',
		104 => 'Рецепт',
		105 => 'Обсуждение_рецепта',
		106 => 'Задача',
		107 => 'Обсуждение_задачи',
	),
	'siwikibooks' => array(
		112 => 'විෂයය',
		113 => 'විෂයය_සාකච්ඡාව',
		114 => 'කණිෂ්ඨ_විකි',
		115 => 'කණිෂ්ඨ_විකි_සාකච්ඡාව',
	),
	'srwikibooks' => array(
		102 => 'Кувар',
		103 => 'Разговор_о_кувару'
	),
	'thwikibooks' => array(
		102 => 'หัวเรื่อง', // Bug 46153
		103 => 'คุยเรื่องหัวเรื่อง', // Bug 46153
	),
	'tlwikibooks' => array(
		100 => 'Pagluluto',
		101 => 'Usapang_pagluluto',
	),
	'trwikibooks' => array(
		100 => 'Yemek',
		101 => 'Yemek_tartışma',
		110 => 'Vikiçocuk',
		111 => 'Vikiçocuk_tartışma',
		112 => 'Kitaplık',
		113 => 'Kitaplık_tartışma',
	),
	'ukwikibooks' => array(
		100 => 'Полиця',
		101 => 'Обговорення_полиці',
		102 => 'Рецепт',
		103 => 'Обговорення_рецепта',
	),
	'viwikibooks' => array(
		102 => 'Chủ_đề', // Subject
		103 => 'Thảo_luận_Chủ_đề',
		104 => 'Trẻ_em', // Wikijunior
		105 => 'Thảo_luận_Trẻ_em', // Wikijunior talk
		106 => 'Nấu_ăn', // Cookbook
		107 => 'Thảo_luận_Nấu_ăn', // Cookbook talk
	),
	'zhwikibooks' => array(
		100 => 'Transwiki', // Bug 40474
		101 => 'Transwiki_talk', // Bug 40474
		110 => 'Wikijunior', // Bug 44308
		111 => 'Wikijunior_talk', // Bug 44308
		112 => 'Subject', // Bug 44308
		113 => 'Subject_talk', // Bug 44308
	),
	// @} end of Wikibooks

	// Wikinews @{
	'arwikinews' => array(
		100 => 'بوابة',
		101 => 'نقاش_البوابة',
		102 => 'تعليقات',
		103 => 'نقاش_التعليقات',
	),
	'bgwikinews' => array(
		102 => 'Мнения',
		103 => 'Мнения_беседа',
	),
	'cawikinews' => array(
		100 => 'Transwiki',
		101 => 'Transwiki_talk',
		102 => 'Secció',
		103 => 'Secció_Discussió',
	),
	'cswikinews' => array(
		NS_USER      => 'Redaktor',       # language default set back in wgNamespaceAliases
		NS_USER_TALK => 'Diskuse_s_redaktorem',   # language default set back in wgNamespaceAliases
	),
	'dewikinews' => array(
		100 => 'Portal',
		101 => 'Portal_Diskussion',
		102 => 'Meinungen',
		103 => 'Meinungen_Diskussion'
	),
	'elwikinews' => array(
		102 => 'Σχόλια', // Comments
		103 => 'Συζήτηση_σχολίων', // Comment talk
	),
	'enwikinews' => array(
		100 => 'Portal',
		101 => 'Portal_talk',
		102 => 'Comments',
		103 => 'Comments_talk'
	),
	'eswikinews' => array(
		100 => 'Comentarios',
		101 => 'Comentarios_Discusión',
	),
	'fawikinews' => array(
		100 => 'درگاه',
		101 => 'بحث_درگاه',
		102 => 'نظرها',
		103 => 'بحث_نظرها',
	),
	'frwikinews' => array(
		102 => 'Transwiki',
		103 => 'Discussion_Transwiki',
		104 => 'Page',
		105 => 'Discussion_Page',
		106 => 'Dossier',
		107 => 'Discussion_Dossier',
	),
	'hewikinews' => array(
		100 => 'פורטל',
		101 => 'שיחת_פורטל',
	),
	'huwikinews' => array(
		102 => 'Portál',
		103 => 'Portálvita',
	),
	'itwikinews' => array(
		100 => 'Portale',
		101 => 'Discussioni_portale',
	),
	'jawikinews' => array(
		100 => "ポータル",
		101 => "ポータル・トーク",
		108 => '短信',
		109 => '短信‐ノート',
	),
	'nowikinews' => array(
		100 => 'Kommentarer',
		101 => 'Kommentarer-diskusjon',
		106 => 'Portal',
		107 => 'Portal-diskusjon',
	),
	'ptwikinews' => array(
		100 => 'Portal',
		101 => 'Portal_Discussão',
		102 => 'Efeméride',
		103 => 'Efeméride_Discussão',
		104 => 'Transwiki',
		105 => 'Transwiki_Discussão',
	),
	'plwikinews' => array(
		NS_PROJECT_TALK => 'Dyskusja_Wikinews',
		NS_USER => 'Wikireporter',
		NS_USER_TALK => 'Dyskusja_wikireportera',
		100 => 'Portal',
		101 => 'Dyskusja_portalu'
	),
	'ruwikinews' => array(
		100 => 'Портал',
		101 => 'Обсуждение_портала',
		102 => 'Комментарии',
		103 => 'Обсуждение_комментариев',
	),
	'sqwikinews' => array(
		100 => 'Portal',
		101 => 'Portal_diskutim',
		102 => 'Komentet',
		103 => 'Komentet_diskutim',
	),
	'srwikinews' => array(
		102 => 'Коментар',
		103 => 'Разговор_о_коментару',
	),
	'svwikinews' => array(
		100 => 'Portal',
		101 => 'Portaldiskussion',
	),
	'tawikinews' => array(
		100 => 'வலைவாசல்', // PPortal
		101 => 'வலைவாசல்_பேச்சு',
	),
	'trwikinews' => array(
		100 => 'Portal',
		101 => 'Portal_tartışma',
		106 => 'Yorum',
		107 => 'Yorum_tartışma',
	),
	'ukwikinews' => array(
		102 => 'Коментарі',                // Bug 45333 - Comments
		103 => 'Обговорення_коментарів',
		104 => 'Інкубатор',                // Bug 45333 - Incubator
		105 => 'Обговорення_інкубатора',
	),
	'zhwikinews' => array(
		100 => '频道',
		101 => '频道_talk'
	),
	// @} end of Wikinews

	// Wikiquote @{
	'cswikiquote' => array(
		100		=> 'Dílo',
		101		=> 'Diskuse_k_dílu',
	),
	'dewikiquote' => array(
		100 => 'Portal',
		101 => 'Portal_Diskussion',
	),
	'frwikiquote' => array(
		100 => 'Portail',
		101 => 'Discussion_Portail',
		102 => 'Projet',
		103 => 'Discussion_Projet',
		104 => 'Référence',
		105 => 'Discussion_Référence',
		108 => 'Transwiki',
		109 => 'Discussion_Transwiki',
	),
	'hewikiquote' => array(
		100 => 'פורטל',
		101 => 'שיחת_פורטל'
	),
	'kuwikiquote' => array(
		NS_PROJECT_TALK => 'Gotûbêja_Wîkîgotinê', // Bug 37523
	),
	'liwikiquote' => array(	// bug 12240
		100 => 'Portaol',
		101 => 'Euverlèk_portaol'
	),
	'plwikiquote' => array(
		NS_PROJECT_TALK => 'Dyskusja_Wikicytatów',
	),
	'skwikiquote' => array(
		100 => 'Deň',             // Bug 44052
		101 => 'Diskusia_ku_dňu',
	),
	'zhwikiquote' => array( // bug 40474
		100 => 'Transwiki',
		101 => 'Transwiki_talk',
	),
	// @} end of Wikiquote

	// Wikiversity @{
	'arwikiversity' => array(
		100 => 'مدرسة',
		101 => 'نقاش_المدرسة',
		102 => 'بوابة',
		103 => 'نقاش_البوابة',
		104 => 'موضوع',
		105 => 'نقاش_الموضوع',
		106 => 'مجموعة',
		107 => 'نقاش_المجموعة',
	),
	'cswikiversity' => array(
		100 => 'Fórum',
		101 => 'Diskuse_k_fóru',
	),
	'dewikiversity' => array(
		106 => 'Kurs',
		107 => 'Kurs_Diskussion',
		108 => 'Projekt',
		109 => 'Projekt_Diskussion',
	),
	'elwikiversity' => array(
		100 => 'Σχολή',
		101 => 'Συζήτηση_Σχολής',
		102 => 'Τμήμα',
		103 => 'Συζήτηση_Τμήματος',
	),
	'enwikiversity' => array(
		100 => 'School',
		101 => 'School_talk',
		102 => 'Portal',
		103 => 'Portal_talk',
		104 => 'Topic',
		105 => 'Topic_talk',
		106 => 'Collection',
		107 => 'Collection_talk',
	),
	'frwikiversity' => array(
		102 => 'Projet',
		103 => 'Discussion_Projet',
		104 => 'Recherche', // bug 29015
		105 => 'Discussion_Recherche',
		106 => 'Faculté',
		107 => 'Discussion_Faculté',
		108 => 'Département',
		109 => 'Discussion_Département',
		110 => 'Transwiki',
		111 => 'Discussion_Transwiki',
	),
	'itwikiversity' => array(
		100 => 'Facoltà',
		101 => 'Discussioni_facoltà',
		102 => 'Corso',
		103 => 'Discussioni_corso',
		104 => 'Materia',
		105 => 'Discussioni_materia',
		106 => 'Dipartimento',
		107 => 'Discussioni_dipartimento',
	),
	'jawikiversity' => array(
		100 => 'School',
		101 => 'School‐ノート',
		102 => 'Portal',
		103 => 'Portal‐ノート',
		104 => 'Topic',
		105 => 'Topic‐ノート',
		110 => 'Transwiki',
		111 => 'Transwiki‐ノート',
	),
	'kowikiversity' => array(
		NS_PROJECT_TALK => '위키배움터토론', // Bug 44899
		102 => '포털', // Bug 44899
		103 => '포털토론', // Bug 44899
	),
	'svwikiversity' => array (
		100 => 'Portal',
		101 => 'Portaldiskussion',
	),
	// @} end of Wikiversity

	// Wikivoyage @{
	'dewikivoyage' => array(
		100 => 'Portal',
		101 => 'Portal_Diskussion',
		102 => 'Wahl',
		103 => 'Wahl_Diskussion',
		104 => 'Thema',
		105 => 'Thema_Diskussion',
		106 => 'Nachrichten',
		107 => 'Nachrichten_Diskussion',
	),
	'hewikivoyage' => array(
		108 => 'ספר', // Book
		109 => 'שיחת_ספר', // Book talk
	),
	'itwikivoyage' => array(
		100 => 'Portale',
		101 => 'Discussioni_portale',
		//102 and 103 (Elezione) deleted per bug 45636
		104 => 'Tematica',
		105 => 'Discussioni_tematica',
		//106 and 107 (Notizie) deleted per bug 45636
	),
	'plwikivoyage' => array(
		NS_PROJECT_TALK => 'Dyskusja_Wikipodróży',
	),
	'ukwikivoyage' => array(
		100 => 'Портал', // Portal
		101 => 'Обговорення_порталу', // Portal talk
	),
	// @} end of Wikivoyage

),
# @} end of wgExtraNamespaces

'wgAccountCreationThrottle' => array(
	'default' => 6, // previously 10
	'private' => 0, // disable for wikis with sysop-only account creation
	'fishbowl' => 0,

	'hewiki' => 4,
	'hewikibooks' => 4,
	'hewikinews' => 4,
	'hewikiquote' => 4,
	'hewikisource' => 4,
	'hewiktionary' => 4,
	'idwiki' => 0,
),

'wgDefaultSkin' => array(
	'default' => 'vector',
	'nostalgiawiki' => 'nostalgia',
),

# wgForceUIMsgAsContentMsg @{
'wgForceUIMsgAsContentMsg' => array(
	'default' => array(),
	'arwiki' => array(
		'licenses',
		'uploadtext',
	),
	'bewikimedia' => array(
		'sitenotice',
		'anonnotice',
	),
	'commonswiki' => array(
		// Sidebar
		'mainpage',
		'portal-url',
		'sitesupport-url',
		'village pump-url',
		'welcome-url',
		// Other
		'contact-url',
		'aboutpage',
		'disclaimerpage',
		'copyright',
		'licenses',
		'upload-url',
		'helppage', // bug 5925
		'license-header',
		'filedesc',
		'filestatus',
		'filesource',
	),
	'enwiki' => array(
		'licenses', // for upload form variants hack, 2007-02-22
	),
	'enwikiversity' => array(
		'licenses',
		'uploadtext',
	),
	'incubatorwiki' => array(
		'sidebar-mainpage-url',
		'sidebar-help-url',
		'sidebar-sitesupport-url',
	),
	'mediawikiwiki' => array( // Requested by ialex on IRC
		'mw-mainpage-url',
		'mw-cat-browser-url',
		'mw-portal-url',
		'mw-help-url',
		'mw-manual-url',
		'mw-faq-url',
		'mw-download-url',
		'mw-extensions-url',
		'mw-bugzilla-url',
		'mw-downloadfromsvn-url',
		'mw-irc-url',
		'mw-mailing lists-url',
	),
	'metawiki' => array(
		'mainpage', // bug 16701
	),
	'mlwiki' => array(
		'licenses', // bug 11538
	),
	'nowikimedia' => array(
		'mainpage', // bug 16729
	),
	'specieswiki' => array(
		'mainpage',
	),
	'tenwiki' => array(
		'mainpage',
		'organize-url',
		'share-url',
		'design-url',
		'ideas-url',
		'faq-url',
	),
	'viwiki' => array(
		'licenses',
	),
	'wikidata' => array(
		'mainpage',
		'portal-url',
		'villagepump-url',
		'helppage',
		'sitesupport-url', // bug 45696
	),
	'wikimania2005wiki' => array( 'currentevents-url', 'portal-url' ),
	'wikimania2006wiki' => array( 'currentevents-url', 'portal-url' ),
	'wikimania2007wiki' => array( 'currentevents-url', 'portal-url' ),
	'wikimania2008wiki' => array( 'currentevents-url', 'portal-url' ),
	'wikimania2009wiki' => array(
		'registration-url',
		'schedule-url',
		'volunteers-url',
		'press-url',
		'sponsors-url',
		'FAQ-url',
		'IRC-url',
		'contact-url',
		'Site Map-url',
		'index-url',
		'cfp-url',
		'local-url',
	),
	'wikimania2010wiki' => array(
		'pagetitle',
		'pagetitle-view-mainpage',
		'Volunteers-url',
		'Attendees-url',
		'Press-url',
		'Sponsors-url',
		'Questions-url',
		'FAQ-url',
		'Site Map-url',
		'Registration-url',
		'Schedule-url',
		'IRC-url',
		'Contact-url',
	),
	'wikimania2011wiki' => array(
		'pagetitle',
		'pagetitle-view-mainpage',
		'Volunteers-url',
		'Attendees-url',
		'Press-url',
		'Sponsors-url',
		'Questions-url',
		'FAQ-url',
		'Site Map-url',
		'Registration-url',
		'Schedule-url',
		'IRC-url',
		'Contact-url',
		'Accommodation-url',
		'Venue-url',
		'LocalInformation-url',
		'Mainpage-url',
		'Program-url',
	),
	'wikimania2012wiki' => array(
		'pagetitle',
		'pagetitle-view-mainpage',
		'Volunteers-url',
		'Attendees-url',
		'Press-url',
		'Sponsors-url',
		'Questions-url',
		'FAQ-url',
		'Site Map-url',
		'Registration-url',
		'Schedule-url',
		'IRC-url',
		'Contact-url',
	),
	'wikimania2013wiki' => array(
		'pagetitle',
		'pagetitle-view-mainpage',
		'Volunteers-url',
		'Attendees-url',
		'Press-url',
		'Sponsors-url',
		'Questions-url',
		'FAQ-url',
		'Site Map-url',
		'Registration-url',
		'Schedule-url',
		'IRC-url',
		'Contact-url',
	),
	'wikimania2014wiki' => array(
		'pagetitle',
		'pagetitle-view-mainpage',
		'Volunteers-url',
		'Attendees-url',
		'Press-url',
		'Sponsors-url',
		'Questions-url',
		'FAQ-url',
		'Site Map-url',
		'Registration-url',
		'Schedule-url',
		'IRC-url',
		'Contact-url',
	),
	'wikimania2015wiki' => array(
		'pagetitle',
		'pagetitle-view-mainpage',
		'Volunteers-url',
		'Attendees-url',
		'Press-url',
		'Sponsors-url',
		'Questions-url',
		'FAQ-url',
		'Site Map-url',
		'Registration-url',
		'Schedule-url',
		'IRC-url',
		'Contact-url',
	),
	'zhwiki' => array(
		'pagetitle-view-mainpage',
	),
	'zhwikivoyage' => array( // bug 64816
		'pagetitle-view-mainpage',
	),
),
# @}

# wgUseRCPatrol @{
'wgUseRCPatrol' => array(
	'default' => false, # See [[Wikipedia:Village pump (news)]], 09:47, Jan 6, 2005

	// Projects
	'wikidata' => true, // bug 41907
	'wikivoyage' => true, // requested by Erik

	// Individual wikis
	'alswiki' => true, // bug 4543
	'arwikisource' => true,
	'bgwiki' => true,
	'bnwiki' => true, // bug 11042
	'brwikimedia' => true, // bug 63345
	'cawiki' => true,
	'commonswiki' => true, // bug 22834
	'dawiki' => true, // wegge asked in #wikimedia-tech 2006-03-01
	'dawikiquote' => true, // bug 13246
	'dewikibooks' => true, // bug 7041
	'dewikiquote' => true, // bug 10290
	'dewikiversity' => true,
	'dewiktionary' => true, // bug 4542
	'enwikisource' => true, // bug 5475
	'enwikivoyage' => true, // bug 43908
	'enwiktionary' => true, // bug 7248
	'eswiktionary' => true, // bug 7953
	'fawiki' => true, // bug 54596
	'fawikinews' => true,
	'frwiki' => true, // bug 7269
	'frwikibooks' => true, // bug 21517
	'frwikisource' => true, // yannf asked in irc, 2006-07-25
	'frwikiversity' => true,
	'frwiktionary' => true, // bug 21517
	'fywiki' => true, // bug 10584
	'hewiki' => true, // bug 5232
	'hewikibooks' => true, // Bug 27918
	'hewikiquote' => true,
	'hiwiki' => true,
	'hrwiki' => true, // by request of stemd from #wikipedia-hr 2007-05-15 -jeronim
	'idwiki' => true, // bug 6042
	'itwiki' => true,
	'itwikinews' => true,
	'itwikiversity' => true,
	'itwikibooks' => true, // bug 9159
	'itwikiquote' => true, // bug 12826
	'itwiktionary' => true, // bug 11424
        'jawiktionary' => true, // bug 61366
	'kshwiki' => true, // bug 8798
	'lvwiki' => true, //Bug 70441
	'mediawikiwiki' => true, // bug 56104
	'metawiki' => true, // bug 4747
	'mlwiki' => true,
	'ndswiki' => true,
	'ndswiktionary' => true, // bug 4437
	'nlwiki' => true,
	'nlwikibooks' => true, // bug 7443
	'nlwikiquote' => true, // bug 12005
	'nnwiki' => true,
	'nowiki' => true, // bug 5549
	'nowikibooks' => true, // bug 10486
	'plwikiquote' => true, // bug 4697
	'ptwiki' => true, // bug 4500
	'ptwikibooks' => true, // bug 30136
	'rowiki' => true, // bug 28192
	'ruwikiversity' => true,
	'sawiki' => true, // bug 33200
	'sawikisource' => true, // bug 34769
	'shwiki' => true, // bug 60818
	'siwiki' => true,
	'srwiki' => true, // req by dungodung in #wikimedia-tech, 2008-02-25
	'srwikisource' => true, // #25963
	'viwiki' => true, // bug 5060
	'testwiki' => true,
	'test2wiki' => true, // request by Krinkle for testing
	'zhwiktionary' => true, // bug 5596
),
# @}

'wgUseNPPatrol' => array(
	'default' => true, // brion 2007-11-16
	'huwiki' => false, // bug 19241
	'ruwiki' => false, // bug 31650
	'sqwiki' => false, // bug 25822
	'ukwiki' => false, // bug 33273
),

# wgNoFollow... @{
'wgNoFollowLinks' => array(
	'default' => true,
	'fishbowl' => false, // not a spam measure here... bug 14105
),

'wgNoFollowNsExceptions' => array(
	'default' => array(),
),

'wgNoFollowDomainExceptions' => array(
	'default' => array(
		# Original list 20111110 - bug 32309
		'mediawiki.org',
		'wikibooks.org',
		'wikimediafoundation.org',
		'wikimedia.org',
		'wikinews.org',
		'wikipedia.org',
		'wikiquote.org',
		'wikisource.org',
		'wikiversity.org',
		'wiktionary.org',
		'wikivoyage.org',
		'wikidata.org',
		'tools.wmflabs.org',
		'etherpad.wmflabs.org',
	),
),
# @}

'wgEnableDnsBlacklist' => array(
	'default' => false,
	'enwikinews' => true,
	'thwiki' => true,
	'thwiktionary' => true,
	'thwikiquote' => true,
	'thwikibooks' => true,
	'thwikisource' => true,
),

'wgCountCategorizedImagesAsUsed' => array(
	'default' => false,
	'commonswiki' => true,
),

'wgExternalStores' => array(
	'default' => array( 'DB' ),
),

'wmgUseRC2UDP' => array(
	'default' => true,
	'private' => false,
),

'wmgRC2UDPAddress' => array(
	'default' => '208.80.154.160', // eqiad: argon
),

'wmgRC2UDPPort' => array(
	'default' => 9390,
),

'wmgRC2UDPPrefix' => array(
	// Do NOT add any more wikis here; this is a list of legacy exceptions
	'default' => false,
	'advisorywiki' => "#advisory.wikipedia\t",
	'arbcom_dewiki' => "#arbcom-de.wikipedia\t",
	'arbcom_enwiki' => "#arbcom-en.wikipedia\t",
	'arbcom_fiwiki' => "#arbcom-fi.wikipedia\t",
	'arbcom_nlwiki' => "#arbcom-nl.wikipedia\t",
	'auditcomwiki' => "#auditcom.wikipedia\t",
	'boardgovcomwiki' => "#boardgovcom.wikipedia\t",
	'boardwiki' => "#board.wikipedia\t",
	'chairwiki' => "#chair.wikipedia\t",
	'chapcomwiki' => "#chapcom.wikipedia\t",
	'checkuserwiki' => "#checkuser.wikipedia\t",
	'collabwiki' => "#collab.wikipedia\t",
	'donatewiki' => "#donate.wikimedia.org\t",
	'execwiki' => "#exec.wikipedia\t",
	'fdcwiki' => "#fdc.wikipedia\t",
	'foundationwiki' => "#wikimediafoundation.org\t",
	'iegcomwiki' => "#iegcom.wikipedia\t",
	'internalwiki' => "#internal.wikipedia\t",
	'legalteamwiki' => "#legalteam.wikipedia\t",
	'loginwiki' => "#login.wikipedia\t",
	'mediawikiwiki' => "#mediawiki.wikipedia\t",
	'movementroleswiki' => "#movementroles.wikipedia\t",
	'noboard_chapterswikimedia' => "#noboard-chapters.wikimedia\t",
	'officewiki' => "#office.wikipedia\t",
	'ombudsmenwiki' => "#ombudsmen.wikipedia\t",
	'otrs_wikiwiki' => "#otrs-wiki.wikipedia\t",
	'outreachwiki' => "#outreach.wikipedia\t",
	'qualitywiki' => "#quality.wikipedia\t",
	'searchcomwiki' => "#searchcom.wikipedia\t",
	'spcomwiki' => "#spcom.wikipedia\t",
	'stewardwiki' => "#steward.wikipedia\t",
	'testwikidatawiki' => "#testwikidata.wikipedia\t",
	'transitionteamwiki' => "#transitionteam.wikipedia\t",
	'votewiki' => "#vote.wikipedia\t",
	'wg_enwiki' => "#wg-en.wikipedia\t",
	'wikidatawiki' => "#wikidata.wikipedia\t",
	'wikimania2005wiki' => "#wikimania.wikimedia\t",
	'wikimania2010wiki' => "#wikimania2010.wikipedia\t",
	'wikimania2011wiki' => "#wikimania2011.wikipedia\t",
	'wikimania2012wiki' => "#wikimania2012.wikipedia\t",
	'wikimania2013wiki' => "#wikimania2013.wikipedia\t",
	'wikimania2014wiki' => "#wikimania2014.wikipedia\t",
	'wikimaniateamwiki' => "#wikimaniateam.wikipedia\t",
	// Do NOT add any more wikis here; this is a list of legacy exceptions
),

# wgNamespacesToBeSearchedDefault @{
'wgNamespacesToBeSearchedDefault' => array(
	'default' => array( 0 => 1, 1 => 0,  2 => 0, 3 => 0, 4 => 0, 5 => 0, 6 => 0, 7 => 0, 8 => 0, 9 => 0, 10 => 0, 11 => 0, 12 => 0, 13 => 0 ),
	'+arwikisource' => array( 102 => 1 ),
	'+aswikisource' => array( 104 => 1, 106 => 1 ), // bug 43129
	'+bgwiki' => array( 100 => 1, 101 => 0 ),
	'+bgwikisource' => array( 100 => 1 ),
	'+brwikisource' => array( 100 => 1, 104 => 1 ),
	'+cawikisource' => array( 104 => 1, 106 => 1 ),
	'+cswiki' => array( 100 => 1, 101 => 0, 102 => 1 ),
	'+commonswiki' => array( 6 => 1, 12 => 1, 14 => 1, 100 => 1, 106 => 1 ),
	'+cswikinews' => array( 14 => 0, 15 => 0 ),
	'+cswikiquote' => array( 14 => 0, 15 => 0, 100 => 1, 101 => 0 ),
	'+cswikisource' => array( 100 => 1, 101 => 0 ),
	'+cswikiversity' => array( 14 => 0, 15 => 0, 100 => 0, 101 => 0 ),
	'+dawikisource' => array( 102 => 1, 106 => 1 ),
	'+dewikisource' => array( 102 => 1, 104 => 1 ),
	'+dewikiversity' => array( 106 => 1, 108 => 1 ),
	'+dewikivoyage' => array( 6 => 1, 14 => 1, 100 => 1, 104 => 1, 106 => 1 ),
	'+elwikisource' => array( 102 => 1 ),
	'+enwikibooks' => array( 4 => 1, 112 => 1 ),
	'+enwikinews' => array( 100 => 1, 101 => 0 ),
	'+enwikisource' => array( 102 => 1, 106 => 1, 114 => 1 ), // bug 50007
	'+eswiki' => array( 100 => 1, 104 => 1 ),
	'+eswikisource' => array( 104 => 1 ),
	'+etwikisource' => array( 104 => 1, 106 => 1 ),
	'+fawikisource' => array( 102 => 1 ),
	'+frrwiki' => array( 102 => 1, 104 => 1, 106 => 1 ), // bug 38023
	'+frwikisource' => array( 102 => 1, 112 => 1 ),
	'+frwikiversity' => array( 104 => 1, 106 => 1, 108 => 1 ),
	'+hewikisource' => array( 108 => 1, 112 => 1 ),
	'+hewiktionary' => array( 14 => 1 ),
	'+hrwikisource' => array( 100 => 1, 104 => 1 ),
	'+huwikisource' => array( 100 => 1, 106 => 1 ),
	'+hywikisource' => array( 100 => 1, 106 => 1 ),
	'+idwikibooks' => array( 100 => 1, 102 => 1 ),
	'+idwikisource' => array( 100 => 1, 102 => 1 ),
	'+iswikisource' => array( 100 => 1, 102 => 1 ), // Bug 44164
	'+itwikisource' => array( 102 => 1, 110 => 1 ),
	'+itwikivoyage' => array( 100 => 1, 104 => 1, 106 => 1 ),
	'+kowikisource' => array( 100 => 1 ),
	'+lawikisource' => array( 102 => 1, 106 => 1 ),
	'+labswiki' => array( 12 => 1, 112 => 1 ),
	'+ltwiki' => array( 100 => 1 ),
	'+mediawikiwiki' => array( 12 => 1, 100 => 1, 102 => 1 ),
	'+metawiki' => array( 12 => 1, 200 => 1, 202 => 1 ),
	'+mlwikisource' => array( 100 => 1, 104 => 1 ),
	'+nlwikisource' => array( 102 => 1 ),
	'+nlwikivoyage' => array( 6 => 1, 14 => 1, 100 => 1, 104 => 1, 106 => 1 ),
	'+nowikisource' => array( 102 => 1, 106 => 1 ),
	'+plwiktionary' => array( 100 => 1, 102 => 1 ),
	'+plwikisource' => array( 102 => 1, 104 => 1 ),
	'+ptwiki' => array( 102 => 1 ),
	'+ptwikisource' => array( 102 => 1, 104 => 1 ),
	'+rowikisource' => array( 102 => 1, 106 => 1 ), // bug 29190
	'+ruwiki' => array( 104 => 0, 105 => 0, 106 => 0, 107 => 0 ),
	'+ruwikisource' => array( 106 => 1 ),
	'+ruwikivoyage' => array( 6 => 1, 14 => 1, 100 => 1, 104 => 1, 106 => 1 ),
	'+sewikimedia' => array( 100 => 1 ), // bug 46882
	'+slwikisource' => array( 104 => 1 ),
	'+sourceswiki' => array( 106 => 1 ),
	'+svwikisource' => array( 106 => 1, 108 => 1 ),
	'+svwikivoyage' => array( 6 => 1, 14 => 1, 100 => 1, 104 => 1, 106 => 1 ),
	'+strategywiki' => array( 106 => 1, 107 => 1 ), // bug 20514
	'+tewikisource' => array( 102 => 1, 106 => 1 ),
	'+tlwikibooks' => array( 100 => 1, 101 => 0 ),
	'+trwikisource' => array( 100 => 1 ),
	'+ukwikinews' => array( 14 => 1 ), // bug 49335
	'+ukwikisource' => array( 102 => 1, 114 => 1, 252 => 1 ), // bug 50561, 51684
	'+vecwikisource' => array( 100 => 1, 104 => 1 ),
	'+viwikibooks' => array( 102 => 1, 104 => 1, 106 => 1 ),
	'+viwikisource' => array( 102 => 1, 106 => 1 ),
	'+zhwikisource' => array( 102 => 1, 106 => 1, 114 => 1 ), // bug 64127
),
# @} end of wgNamespacesToBeSearchedDefault

# ############### User throttling, groups, and rights ###############

# wgRateLimits @{
'wgRateLimits' => array(
	'default' => array(
		'move' => array(
			'newbie' => array( 2, 120 ),
			# To limit high-rate move page attacks on smaller wikis
			# Newbie limit was trivially avoided by a patient vandal
			'user' => array( 8, 60 ),
		),
		'edit' => array(
			// 8 ed./min per each non-autoconfirmed, or group thereof from same IP
			'ip' => array( 8, 60 ),
			'newbie' => array( 8, 60 ),
		),
		'mailpassword' => array(
			// 5 password reminders per hour per IP
			'ip' => array( 5, 3600 ),
		),
		'emailuser' => array(
			'ip' => array( 5, 86400 ), // 5 per day per ip (logged-out and new users)
			'newbie' => array( 5, 86400 ), // 5 per day for non-autoconfirmed
			'user' => array( 20, 86400 ), // 20 per day for users
		),
		// For expanded rollback permissions...
		'rollback' => array(
			'user' => array( 10, 60 ), // was array( 5, 60 ), -- brion 2008-05-15
			'newbie' => array( 5, 120 ),
			// practicality has won out over paranoia on enwiki, raising from 20 to 100 -- TS 2008-05-21
			'rollbacker' => array( 100, 60 ),
		),
		'linkpurge' => array(
			// 30 backlink purges per minute
			'ip'   => array( 30, 60 ),
			'user' => array( 30, 60 ),
		),
		'renderfile' => array(
			// 1400 new thumbnails per minute
			'ip'   => array( 700, 30 ),
			'user' => array( 700, 30 ),
		),
		'renderfile-nonstandard' => array(
			// 140 new thumbnails per minute
			'ip'   => array( 70, 30 ),
			'user' => array( 70, 30 ),
		),
	),
	'+dewiki' => array( // bug 57820
		'rollback' => array(
			'editor' => array( 100, 60 ),
		),
	),
),
# @} end of wgRateLimits

'wgRateLimitLog' => array(
	'default' => null,  # We use $wgDebugLogGroups['ratelimit']
),

'wgRateLimitsExcludedIPs' => array(
	// see also wmf-config/throttle.php
	// exemptions for outreach events should go in that file
	// note that account creation is not the only bottleneck
	'default' => array(),
),

'wgEmailAuthentication' => array(
	'default' => true,
	'private' => false, // disable for wikis with account approval
	'fishbowl' => false,
),

'wgBlockAllowsUTEdit' => array(
	'default' => true, // bug 28288
	'itwiki' => false, // requested by Brownout on #wikimedia-tech and bug 9073
),

'wgBlockDisablesLogin' => array(
	'default' => false,
	'private' => true, // bug 53871
),

# groupOverrides @{
'groupOverrides' => array(
	// Note: don't change the default setting here, because it won't take
	// effect for the wikis which have overrides below. Instead change the
	// default in groupOverrides2
	// IMPORTANT: don't forget to use a '+' sign in front of the wiki name
	// when needed, such as for wikis that are tagged (private/fishbowl/closed...)
	'default' => array(),

	'commonsuploads' => array(
		'user' => array(
			'upload' => false,
			'reupload' => false,
			'reupload-own' => false,
			'reupload-shared' => false,
		),
		'autoconfirmed' => array( // Not set in core
			'upload' => false,
			'reupload' => false,
			'reupload-own' => false,
			'reupload-shared' => false,
		),
		'sysop' => array(
			// Implicit, in core defaults: 'upload' => true,
			'reupload' => true,
			'reupload-own' => true,
			'reupload-shared' => true,
		),
	),

	// Whitelist read wikis
	'private' => array(
		'*' => array(
			'read' => false,
			'edit' => false,
			'createaccount' => false
		),
		'user' => array(
			'move' => true,
			'upload' => true,
			'autoconfirmed' => true,
			'editsemiprotected' => true,
			'reupload' => true,
			'skipcaptcha' => true,
			'collectionsaveascommunitypage' => true,
			'collectionsaveasuserpage' => true,
		),
		'inactive' => array(
			// for show only
		),
	),
	'wikimania2014wiki' => array(
		'*' => array( 'createpage' => false ),
	),
	'wikimania2015wiki' => array(
		'*' => array( 'createpage' => false ),
	),

	// Fishbowls
	'fishbowl' => array(
		'*' => array(
			'edit' => false,
			'createaccount' => false
		),
		'user' => array(
		'move' => true,
			'upload' => true,
			'autoconfirmed' => true,
			'editsemiprotected' => true,
			'reupload' => true,
			'skipcaptcha' => true,
			'collectionsaveascommunitypage' => true,
			'collectionsaveasuserpage' => true,
	),
	'inactive' => array(
			// for show only
		),
	),

	// Read-only (except stewards)
	'closed' => array(
		'*' => array(
			'edit' => false,
			'createaccount' => false,
		),
		'user' => array(
			'edit' => false,
			'move' => false,
			'move-rootuserpages' => false,
			'move-subpages' => false,
			'upload' => false,
		),
		'autoconfirmed' => array(
			'upload' => false,
			'move' => false,
		),
		'sysop' => array(
			'block' => false,
			'delete' => false,
			'undelete' => false,
			'import' => false,
			'move' => false,
			'move-subpages' => false,
			'move-rootuserpages' => false,
			'patrol' => false,
			'protect' => false,
			'editprotected' => false,
			'rollback' => false,
			'trackback' => false,
			'upload' => false,
			'movefile' => false,
		),
		'steward' => array(
			'edit' => true,
			'move' => true,
			'delete' => true,
			'upload' => true,
		),
	),

	// Account creation required
	'nlwikimedia' => array( '*' => array(
		'edit' => false,
	) ),
	'fiwikimedia' => array( '*' => array(
		'edit' => false,
	) ),
	'trwikimedia' => array( '*' => array(
		'edit' => false,
	) ),

	// Miscellaneous
	'+arbcom_enwiki' => array(
		'bureaucrat' => array( 'disableaccount' => true ),
	),
	'arwiki' => array(
		'autoconfirmed' => array( 'patrol' => true ),
		'rollbacker' => array( 'rollback' => true ),
	),
	'+arwikisource' => array(
		'autopatrolled' => array( 'autopatrol' => true ),
		'patroller' => array( 'patrol' => true ),
	),
	'bnwiki' => array(
		'user' => array( 'patrol' => false ),
		'autoconfirmed' => array( 'patrol' => false ),
		'sysop' => array( 'patrol' => true ),
		'autopatrolled' => array( 'autopatrol' => true ), // bug 28717
		'rollbacker' => array( 'rollback' => true ), // bug 28717
		'reviewer' => array( 'patrol' => true ), // bug 28717
		'flood' => array( 'bot' => true ), // bug 28717
		'filemover' => array( 'movefile' => true ), // bug 56103
	),
	'+bgwiki' => array(
		'autopatrolled' => array( 'autopatrol' => true, ),
		'patroller' => array( 'patrol' => true, 'autopatrol' => true, 'rollback' => true, ),
		'sysop' => array( 'autopatrol' => false, ),
	),
	'brwikimedia' => array( // bug 63345
		'autopatrolled' => array( 'autopatrol' => true, ),
	),
	'bswiki' => array(
		'patroller' => array( 'patrol' => true ),
		'autopatrolled' => array( 'autopatrol' => true ),
		'rollbacker' => array( 'rollback' => true ),
		'flood' => array( 'bot' => true ), // bug 50425
	),
	'cawiki' => array(
		'user' => array( 'patrol' => false ),
		'autoconfirmed' => array( 'patrol' => true ),
		'autopatrolled' => array( 'autopatrol' => true ),
		'sysop' => array( 'patrol' => true ),
		'rollbacker' => array( 'rollback' => true ),
	),
	'+checkuserwiki'  => array( // http://bugzilla.wikimedia.org/show_bug.cgi?id=28781
		'autoconfirmed' => array(
			'autoconfirmed' => false,
			'editsemiprotected' => false,
			'reupload' => false,
			'upload' => false,
			'move' => false,
			'collectionsaveasuserpage' => false,
			'collectionsaveascommunitypage' => false,
			'skipcaptcha' => false,
		),
		'accountcreator' => array( 'noratelimit' => false, ),
		'bureaucrat' => array( 'createaccount' => true, ),
		'sysop' => array( 'createaccount' => false, ),
	),
	'+ckbwiki' => array(
		'*' => array( 'createpage' => false ), //bug 23592
		'autopatrolled' => array( 'autopatrol' => true ), // bug 51328
		'rollbacker' => array( 'rollback' => true ), // bug 51312
		'autoconfirmed' => array( 'patrolmarks' => true ), // bug 54118
		'sysop' => array( 'importupload' => true ), // bug 52633
		'uploader' => array(
			'upload' => true,
			'reupload' => true,
			'reupload-own' => true, // bug 52725
			'movefile' => true,
		), // bug 51232
		'interface_editor' => array(
			'editinterface' => true, // bug 52866
			'editusercss' => true, // bug 52866
			'edituserjs' => true, // bug 52866
			'apihighlimits' => true, // bug 65348
			'noratelimit' => true, // bug 65348
		),
		'flood' => array( 'bot' => true ), // bug 51803
		'botadmin' => array(
			'protect' => true,
			'editprotected' => true,
			'delete' => true,
			'bigdelete' => true,
			'undelete' => true,
			'block' => true,
			'ipblock-exempt' => true,
			'rollback' => true, // bug 65348
		), // bug 52578
		'suppressredirect' => array( 'suppressredirect' => true ), // bug 67278
	),
	'+cswiki' => array(
		'autopatrolled' => array( 'autopatrol' => true, ),
		'bot' => array( 'ipblock-exempt' => true, ), // Bug 42720
		'arbcom' => array( // bug 61418
			'browsearchive' => true,
			'deletedhistory' => true,
			'deletedtext' => true,
			'abusefilter-log-detail' => true,
		),
	),
	'+cswikinews' => array(
		'autopatrolled' => array( 'autopatrol' => true, ),
	),
	'+cswikiquote' => array(
		'autopatrolled' => array( 'autopatrol' => true, ),
	),
	'+cswikisource' => array(
		'autopatrolled' => array( 'autopatrol' => true, ),
	),
	'+cswiktionary' => array(
		'autopatrolled' => array( 'autopatrol' => true, ),
	),
	'commonswiki' => array(
		'user' => array(
			'move' => false, // requested by Bdka on #wikimedia-tech, 2006-05-04
			'upload' => true, // exception for https://bugzilla.wikimedia.org/show_bug.cgi?id=12556
		),
		'rollbacker' => array( 'rollback' => true ),
		'patroller' => array( 'autopatrol' => true, 'patrol' => true, 'abusefilter-log-detail' => true ),
		'autopatrolled' => array ( 'autopatrol' => true ),
		'filemover' => array( 'movefile' => true ),
		'OTRS-member' => array( 'autopatrol' => true ),
		'Image-reviewer' => array( 'autopatrol' => true, 'upload_by_url' => true ),
		'sysop' => array( 'upload_by_url' => true ),
	),
	'dawiki' => array(
		'patroller'		=> array( 'patrol' => true, 'autopatrol' => true, 'rollback' => true, ),
		'autopatrolled'	=> array( 'autopatrol' => true, ),
	),
	'dewiki' => array(
		'user' => array(
			'move' => false, // Report by sansculotte on #mediawiki, TS 2004-10-15
			'upload' => false, // http://bugzilla.wikimedia.org/show_bug.cgi?id=12391
		),
		'autoconfirmed' => array(
			'upload' => true, // http://bugzilla.wikimedia.org/show_bug.cgi?id=12391
		),
		'editor' => array(
			'rollback' => true, // per DaBPunkt's request, 2008-05-07
		),
		'noratelimit' => array( // bug 57819
			'autoreview' => true,
			'noratelimit' => true,
		),
	),
	'dewikibooks' => array(
		'user' => array( 'move' => false ), // Request by DaBPunkt on #wikimedia-tech, JF 2007-01-27
	),
	'+dewikiquote' => array(
		'sysop' => array( 'importupload' => true, ),
	),
	'+dewikiversity' => array(
		'user'			=> array( 'patrol' => false, ),
		'autoconfirmed'	=> array( 'patrol' => false, ),
		'sysop'			=> array( 'patrol' => true, ),
	),
	'+dewikivoyage' => array(
		'autopatrolled' => array( 'autopatrol' => true, ), // Bug 65495
	),
	'+dewiktionary' => array(
		'sysop' => array( 'importupload' => true, ),
	),
	'+donatewiki' => array(
		'user' => array( 'editinterface' => true ),
		'flood' => array( 'bot' => true ),
	),
	'+elwiktionary' => array(
		'interface_editor' => array( 'editinterface' => true ),
		'autopatrolled' => array( 'autopatrol' => true ), // http://bugzilla.wikimedia.org/show_bug.cgi?id=28612
	),
	'enwiki' => array(
		'*' => array( 'createpage' => false ),
		'user' => array(
			'move' => false, // autoconfirmed only
			'collectionsaveasuserpage' => true, // Bug 46944
		),
		'autoconfirmed' => array( 'patrol' => true ), // http://bugzilla.wikimedia.org/show_bug.cgi?id=12007
		'founder' => array( 'userrights' => true ),
		'rollbacker' => array( 'rollback' => true ),
		'accountcreator' => array(
			'override-antispoof' => true,
			'tboverride' => true,
			// also in some exemption lists'
		),
		'autoreviewer' => array( 'autopatrol' => true ),
		'researcher' => array( 'browsearchive' => true, 'deletedhistory' => true, 'apihighlimits' => true ),
		'reviewer' => array( 'patrol' => true ),
		'filemover' => array( 'movefile' => true ), // bug 27927
		'bot' => array( 'ipblock-exempt' => true ), // bug 28914
		'oversight' => array( 'browsearchive' => true, 'deletedhistory' => true, 'deletedtext' => true ), // bug 28465
		'checkuser' => array( 'browsearchive' => true, 'deletedhistory' => true, 'deletedtext' => true ), // bug 28465
		'bureaucrat' => array( 'move-subpages' => true, 'suppressredirect' => true, 'tboverride' => true, ),
		'templateeditor' => array( 'templateeditor' => true, 'tboverride' => true, ), // bug 55432
		'sysop' => array( 'templateeditor' => true ), // bug 55432
		'massmessage-sender' => array( // bug 58962
			'massmessage' => true,
		),
		'OTRS-member' => array( 'read' => true ), // bug 70386
	),
	'+enwikibooks' => array(
		// 'rollbacker' 	=> array( 'rollback' => true ),
		// 'patroller'		=> array( 'patrol' => true, 'autopatrol' => true ),
		'flood' 		=> array( 'bot' => true ),
		'uploader'      => array( 'upload' => true, 'reupload' => true ),
	),
	'enwikinews' => array(
		'flood' => array( 'bot' => true ),
	),
	'enwikiquote' => array(
		'user' => array( 'move' => false ), // autoconfirmed only, per request due to wow 2007-05-08
	),
	'enwikisource' => array(
		'autoconfirmed' => array( 'patrol' => true ), // http://bugzilla.wikimedia.org/show_bug.cgi?id=12355
		'autopatrolled' => array( 'autopatrol' => true ), # Bug 18307
		'flood' => array( 'bot' => true ), // https://bugzilla.wikimedia.org/show_bug.cgi?id=36863
	),
	'enwikiversity' => array(
		'user' => array( 'move' => false ), // autoconfirmed only
	),
	'enwikivoyage' => array(
		'autopatrolled' => array( 'autopatrol' => true ),
		'patroller' => array( 'patrol' => true, 'rollback' => true ),
	),
	// http://bugzilla.wikimedia.org/show_bug.cgi?id=5033
	'+enwiktionary' => array(
		'user' => array(
			'move' => false, // requested in beer parlour, 13 june 2006
		),
		'autopatrolled' => array( 'autopatrol' => true ),
		'flood' => array( 'bot' => true ),
		'patroller' => array( 'patrol' => true ),
		'rollbacker' => array( 'rollback' => true )
	),
	'eswiki' => array(
		'rollbacker' => array(
			'rollback' => true,
			'abusefilter-log-detail' => true, // Bug 68319
		),
		'*' => array( 'patrolmarks' => true ),
		'autopatrolled' => array( 'autopatrol' => true ),
		'patroller' => array(
			'patrol' => true,
			'autopatrol' => true,
			'abusefilter-log-detail' => true, // Bug 68319
		),
		'flood' => array( 'bot' => true ), // Bug 48682
	),
	'eswikibooks' => array(
		'*'     => array( 'createpage' => false, 'createtalk' => false, ),
		'flood' => array( 'bot' => true ),
		'rollbacker' => array( 'rollback' => true ),
	),
	'eswikinews' => array(
		'bot' => array( 'editprotected' => true ),
		'editprotected' => array( 'editprotected' => true, 'editsemiprotected' => true ),
		'flood' => array( 'bot' => true ),
	),
	'eswikiquote' => array( // bug 62911
		'rollbacker' => array(
			'rollback' => true,
		),
		'autopatrolled' => array(
			'autopatrol' => true,
		),
		'patroller' => array(
			'patrol' => true,
			'autopatrol' => true,
		),
	),
	'+eswikisource' => array(
		'autopatrolled' => array( 'autopatrol' => true ), // bug 67557
	),
	'eswikivoyage' => array(
		'rollbacker' => array(
			'rollback' => true, // Bug 44285
			'autopatrol' => true, // Bug 47325
		),
		'patroller' => array(
			'patrol' => true, // Bug 44285
			'autopatrol' => true, // Bug 47325
		),
		'autopatrolled' => array(
			'autopatrol' => true, // bug 55665
		),
	),
	'+eswiktionary' => array(
		'patroller' => array( 'patrol' => true ),
		'rollbacker' => array( 'rollback' => true ),
		'autopatrolled' => array( 'autopatrol' => true ),
	),
	'+fawiki' => array(
		'*' => array( 'createpage' => false ), // bug 27195
		'user' => array( 'move-categorypages' => false ), // bug 65728
		'bot' => array( 'move-categorypages' => true ), //bug 65728
		'patroller' => array( 'patrol' => true, 'move-categorypages' => true ), // bug 65728
		'rollbacker' => array( 'rollback' => true ), // bug 23233
		'autopatrol' => array( 'autopatrol' => true, 'move-categorypages' => true ), // bug 29007 and 65728
		'Image-reviewer' => array( 'movefile' => true, 'delete' => true ), // bug 64532 and 71229
		'uploader' => array( 'upload' => true, 'reupload' => true, 'reupload-own' => true ), // bug 69171
		'botadmin' => array(
			'block' => true,
			'delete' => true,
			'editprotected' => true,
			'ipblock-exempt' => true,
			'mergehistory' => true,
			'protect' => true,
			'undelete' => true,
		), // bug 69411
		'OTRS-member' => array( 'read' => true ), // bug 54368
	),
	'+fawikinews' => array(
		'rollbacker' => array( 'rollback' => true ),
		'patroller' => array( 'patrol' => true ),
	),
	'+fawikivoyage' => array(
		'autopatrolled' => array( 'autopatrol' => true ), // bug 71760
		'flood' => array( 'bot' => true ), // bug 71760
		'patroller' => array( 'patrol' => true ), // bug 71760
		'rollbacker' => array( 'rollback' => true ), // bug 71760
		'sysop' => array( 'importupload' => true ), // bug 71681
	),
	'fiwiki' => array(
		'patroller' => array( 'patrol' => true ),
		'rollbacker' => array( 'rollback' => true ),
		// https://bugzilla.wikimedia.org/show_bug.cgi?id=19561:
		'arbcom' => array( 'deletedhistory' => true, 'deletedtext' => true, 'undelete' => true ),
	),
	'+foundationwiki' => array(
		'user' => array( 'editinterface' => true ),
		'flood' => array( 'bot' => true ),
	),
	'frwiki' => array(
		'user' => array( 'move' => false ), // requested by hashar
		'autopatrolled' => array( 'patrol' => true, 'autopatrol' => true ), // bug 8904,21078
		'checkuser' => array( 'browsearchive' => true, 'deletedhistory' => true, 'deletedtext' => true ), // bug 21044
	),
	'+frwikibooks' => array(
		'patroller' => array( 'patrol' => true, 'autopatrol' => true ),
	),
	'frwikinews' => array(
		'flood' => array( 'bot' => true ),
	),
	'frwikisource' => array(
		'patroller' => array( 'patrol' => true, 'autopatrol' => true, 'rollback' => true, ),
		'autopatrolled' => array( 'autopatrol' => true ),
	),
	'+frwikiversity' => array(
		'patroller' => array( 'patrol' => true, 'autopatrol' => true ),
	),
	'frwikivoyage' => array(
		'patroller' => array( 'patrol' => true, 'autopatrol' => true ),
	),
	'+frwiktionary' => array(
		'patroller' => array( 'patrol' => true, 'autopatrol' => true, 'rollback' => true, ),
		'autopatrolled' => array( 'autopatrol' => true ),
		'botadmin' => array( 'autopatrol' => true, 'autoconfirmed' => true, 'editsemiprotected' => true, 'suppressredirect' => true, 'nominornewtalk' => true, 'noratelimit' => true, 'skipcaptcha' => true, 'apihighlimits' => true, 'writeapi' => true,
'bot' => true, 'createaccount' => true, 'import' => true, 'patrol' => true, 'protect' => true, 'editprotected' => true, 'editusercss' => true, 'edituserjs' => true, 'editinterface' => true, 'browsearchive' => true, 'movefile' => true, 'move' => true,
'move-rootuserpages' => true, 'undelete' => true, 'rollback' => true, 'delete' => true, 'deleterevision' => true, 'reupload' => true
			),
	),
	'+gawiki' => array(
		'rollbacker' => array( 'rollback' => true ),
	),
	'hewiki' => array(
		'user' => array( 'move' => false, 'upload' => true, 'move-rootuserpages' => false, ),
		'sysop' => array( 'deleterevision' => true, 'abusefilter-modify-restricted' => true, ),
		'patroller' => array( 'patrol' => true, 'autopatrol' => true, 'unwatchedpages' => true, 'rollback' => true, 'move-rootuserpages' => true,),
		'autopatrolled' => array( 'autopatrol' => true, 'unwatchedpages' => true, ),
		'editinterface' => array( 'abusefilter-hidden-log' => true, 'abusefilter-hide-log' => true, 'abusefilter-log' => true, 'abusefilter-log-detail' => true,
			'abusefilter-modify'  => true, 'abusefilter-modify-restricted' => true, 'abusefilter-revert' => true, 'abusefilter-view' => true,
			'abusefilter-view-private' => true, 'editinterface' => true, 'editusercssjs' => true, 'import' => true, 'tboverride' => true
		),
		'checkuser' => array( 'deletedhistory' => true, 'deletedtext' => true, 'abusefilter-log-detail' => true ),
	),
	'hewikibooks' => array(
		'patroller' => array(
			'patrol' => true, // bug 27918
			'patrolmarks' => true, // bug 27918
			'autopatrol' => true, // bug 60305
			'rollback' => true, // bug 60305
			'unwatchedpages' => true, // bug 71193
			),
		'autopatrolled' => array( 'autopatrol' => true ), // bug 27918
	),
	'hewikiquote' => array(
		'autopatrolled' => array( 'autopatrol' => true ),
	),
	'hewikivoyage' => array(
		'autopatrolled' => array( 'autopatrol' => true ), // bug 50377
		'sysop' => array( 'importupload' => true ), // bug 59601
	),
	'hiwiki' => array(
		'rollbacker' => array( 'rollback' => true ), // bug 54589
		'filemover' => array( 'movefile' => true ), // bug 54589
		'reviewer' => array ( 'patrol' => true, 'autopatrol' => true ),
		'autopatrolled' => array( 'autopatrol' => true ),
		'sysop' => array( 'validate' => true ),
	),
	'hrwiki' => array(
		'patroller' => array( 'patrol' => true, 'autopatrol' => true, 'rollback' => true ),
		'autopatrolled' => array( 'autopatrol' => true ),
	),
	'huwiki' => array(
		'editor' => array( 'noratelimit' => true ),
		'sysop' => array( 'deleterevision' => true ),
		'user' => array( 'upload' => true ), // bug 28576
	),
	'idwiki' => array(
		'*' => array( 'createpage' => false ),
		'rollbacker' => array( 'rollback' => true ), // bug 33508
	),
	'+incubatorwiki' => array(
		'bureaucrat' => array( 'upload' => true ),
		'sysop' => array( 'upload' => false ),
		'test-sysop' => array(
			'delete' => true,
			'undelete' => true,
			'deletedhistory' => true,
			'block' => true,
			'blockemail' => true,
			'rollback' => true,
		),
		'translator' => array( 'editinterface' => true, ),
	),
	// http://bugzilla.wikimedia.org/show_bug.cgi?id=5836
	// http://bugzilla.wikimedia.org/show_bug.cgi?id=11326
	'itwiki' => array(
		'user'	=> array( 'upload' => false, 'move' => false ),
		'autoconfirmed' => array( 'patrol' => true, 'upload' => true ),
		'flood' => array( 'bot' => true, ),
		'rollbacker' => array( 'rollback' => true, 'autopatrol' => true, ),
		'autopatrolled' => array( 'autopatrol' => true ),
		'filemover' => array( 'movefile' => true ), // Bug 53913
	),
	'+itwikisource' => array(
		'flood' => array( 'bot' => true ), // http://bugzilla.wikimedia.org/show_bug.cgi?id=36600
	),
	'+itwikiversity' => array( 'autoconfirmed' => array( 'patrol' => true ) ),
	'itwikibooks' => array(
		'user' => array( 'patrol' => false, 'move' => false ),
		'autoconfirmed' => array( 'move' => true, 'patrol' => true ),
		'autopatrolled' => array( 'autopatrol' => true, ),
		'patroller' => array( 'autopatrol' => true, 'rollback' => true, ),
		'flooder' => array( 'bot' => true, ), // Bug 39569
	),
	'+itwikinews' => array( 'autoconfirmed' => array( 'patrol' => true ) ),
	'itwikiquote' => array(
		'autoconfirmed' => array( 'patrol' => true ),
		'autopatrolled' => array( 'autopatrol' => true ),
		'sysop' => array( 'autopatrol' => true ),
	),
	'+itwikivoyage' => array(
		'autopatrolled' => array(
			'autopatrol' => true, // Bug 43327, 43524
		),
		'patroller' => array( 'patrol' => true, 'autopatrol' => true, 'rollback' => true ), // Bug 45638
	),
	'+itwiktionary' => array(
		'autoconfirmed' => array( 'patrol' => true ),
		'patroller' => array( 'patrol' => true, 'autopatrol' => true, 'rollback' => true ),
		'autopatrolled' => array( 'autopatrol' => true ),
		'import' => array( 'suppressredirect' => true, ),
		'transwiki' => array( 'suppressredirect' => true, ),
		'flood' => array( 'bot' => true, ), // Bug 39306
	),
	'jawiki' => array(
		'autoconfirmed' => array( 'patrol' => true ), // Requested by bug 13055
		'rollbacker' => array(
			'autopatrol' => true,
			'ipblock-exempt' => true,
			'markbotedits' => true,
			'noratelimit' => true,
			'rollback' => true,
			'unwatchedpages' => true,
		),
		'eliminator' => array(
			'browsearchive' => true,
			'delete' => true,
			'deletedhistory' => true,
			'deletedtext' => true,
			'deletelogentry' => true, // Bug 40521
			'deleterevision' => true,
			'ipblock-exempt' => true,
			'movefile' => true, // Bug 70007
			'noratelimit' => true,
			'nuke' => true,
			'suppressredirect' => true,
			'undelete' => true,
			'unwatchedpages' => true,
		),
		'interface_editor' => array(
			'delete' => true,
			'editinterface' => true,
			'editprotected' => true,
			'editsemiprotected' => true,
			'edituserjs' => true,
			'editusercss' => true,
			'ipblock-exempt' => true,
			'suppressredirect' => true,
		),
	),
	'jawikinews' => array(
		'user' => array( 'move' => false ), // autoconfirmed only, per request by britty 2007-05-16
	),
	'jawiktionary' => array(
		'autopatrolled' => array( 'autopatrol' => true, 'patrol' => true ), // bug 61366
	),
	'kawiki' => array(
		'editor' => array( 'rollback' => true ),
	),
	'kowiki' => array(
		'rollbacker' => array( 'rollback' => true ),
	),
	'labswiki' => array(
		'*' => array(
			'edit' => false,
			'createaccount' => true,
		),
		'contentadmin' => array(
			'protect' => true,
			'editprotected' => true,
			'bigdelete' => true,
			'delete' => true,
			'undelete' => true,
			'block' => true,
			'blockemail' => true,
			'patrol' => true,
			'autopatrol' => true,
			'import' => true,
			'importupload' => true,
			'upload_by_url' => true,
			'movefile' => true,
			'suppressredirect' => true,
			'rollback' => true,
			'browsearchive' => true,
			'deletedhistory' => true,
			'deletedtext' => true,
			'autoconfirmed' => true,
		),
		'bots' => array('skipcaptcha' => true ),
		'cloudadmin' => array(
			'listall' => true,
			'manageproject' => true,
			'userrights' => true,
			'managednsdomain' => true,
			'manageglobalpuppet' => true,
			'accessrestrictedregions' => true,
		),
		'shell' => array('loginviashell' => true ),
		'shellmanagers' => array('userrights' => false ),
	),
	'+legalteamwiki' => array( // bug 61222
		'accountcreator' => array( 'noratelimit' => false ),
		'bureaucrat' => array( 'createaccount' => true ),
		'sysop' => array( 'createaccount' => false ),
	),
	'lvwiki' => array(
		'autopatrolled' => array( 'autopatrol' => true ), //Bug 70441
		'patroller' => array( 'autopatrol' => true, 'patrol' => true ), //Bug 70441
	),
	'mediawikiwiki' => array(
		'user' => array( 'move' => false ),
		// Kept 'autoreview' as substitute for 'autopatrolled' user group
		// because previously MediaWiki.org did not have one and it would be
		// tedious to rename everyone's userrights.
		'autoreview' => array( 'autopatrol' => true ),
		'coder' => array( 'autopatrol' => true ),
	),

	'+metawiki' => array(
		'autopatrolled' => array( 'autopatrol' => true ),
		'centralnoticeadmin' => array( //adding to allow CN access without local sysop JRA 2013-02-21
			'centralnotice-admin' => true,
			'editinterface' => true,
		),
		'flood' => array( 'bot' => true ),
		'global-renamer' => array( 'centralauth-rename' => true ), // bug 69651
		'massmessage-sender' => array( 'massmessage' => true ), // bug 57611
		'steward' => array( 'userrights-interwiki' => true ), // new steward stuff, yay 2007-12-27
		'uploader' => array( // bug 50287
			'upload' => true,
			'reupload' => true,
			'reupload-own' => true,
		),
	),
	'mkwiki' => array(
		'autopatrolled' => array( 'autopatrol' => true ),
		'patroller' => array( 'patrol' => true, 'autopatrol' => true, 'rollback' => true ),
		'autoreviewed' => array( 'autoreview' => true ),
	),
	'mlwiki' => array(
		'autopatrolled' => array( 'autopatrol' => true ),
		'patroller' => array( 'patrol' => true ),
		'rollbacker' => array( 'rollback' => true ),
		'botadmin' => array(
			'blockemail' => true, 'block' => true, 'ipblock-exempt' => true, 'proxyunbannable' => true, 'protect' => true, 'editprotected' => true, 'createaccount' => true, 'deleterevision' => true, 'delete' => true, 'globalblock-whitelist' => true, 'editusercss' => true, 'edituserjs' => true,
			'autoconfirmed' => true, 'editsemiprotected' => true, 'editinterface' => true, 'autopatrol' => true, 'import' => true, 'patrol' => true, 'markbotedits' => true, 'nuke' => true, 'abusefilter-modify' => true, 'movefile' => true, 'move' => true, 'move-subpages' => true,
			'move-rootuserpages' => true, 'noratelimit' => true, 'suppressredirect' => true, 'reupload-shared' => true, 'override-antispoof' => true, 'tboverride' => true, 'reupload' => true, 'skipcaptcha' => true, 'rollback' => true, 'browsearchive' => true, 'unblockself' => true,
			'undelete' => true, 'upload' => true, 'upload_by_url' => true, 'apihighlimits' => true, 'unwatchedpages' => true, 'deletedhistory' => true, 'deletedtext' => true, 'abusefilter-log-detail' => true,
		),
	),
	'+mlwikisource' => array(
		'patroller' => array( 'patrol' => true ),
		'autopatrolled' => array( 'autopatrol' => true ),
		'botadmin' => array(
			'blockemail' => true, 'block' => true, 'ipblock-exempt' => true, 'proxyunbannable' => true, 'protect' => true, 'editprotected' => true, 'createaccount' => true, 'deleterevision' => true, 'delete' => true, 'globalblock-whitelist' => true, 'editusercss' => true, 'edituserjs' => true,
			'autoconfirmed' => true, 'editsemiprotected' => true, 'editinterface' => true, 'autopatrol' => true, 'import' => true, 'patrol' => true, 'markbotedits' => true, 'nuke' => true, 'abusefilter-modify' => true, 'movefile' => true, 'move' => true, 'move-subpages' => true,
			'move-rootuserpages' => true, 'noratelimit' => true, 'suppressredirect' => true, 'reupload-shared' => true, 'override-antispoof' => true, 'tboverride' => true, 'reupload' => true, 'skipcaptcha' => true, 'rollback' => true, 'browsearchive' => true, 'unblockself' => true,
			'undelete' => true, 'upload' => true, 'upload_by_url' => true, 'apihighlimits' => true, 'unwatchedpages' => true, 'deletedhistory' => true, 'deletedtext' => true, 'abusefilter-log-detail' => true,
		),
	),
	'+mlwiktionary' => array(
		'botadmin' => array(
			'blockemail' => true, 'block' => true, 'ipblock-exempt' => true, 'proxyunbannable' => true, 'protect' => true, 'editprotected' => true, 'createaccount' => true, 'deleterevision' => true, 'delete' => true, 'globalblock-whitelist' => true, 'editusercss' => true, 'edituserjs' => true,
			'autoconfirmed' => true, 'editsemiprotected' => true, 'editinterface' => true, 'autopatrol' => true, 'import' => true, 'patrol' => true, 'markbotedits' => true, 'nuke' => true, 'abusefilter-modify' => true, 'movefile' => true, 'move' => true, 'move-subpages' => true,
			'move-rootuserpages' => true, 'noratelimit' => true, 'suppressredirect' => true, 'reupload-shared' => true, 'override-antispoof' => true, 'tboverride' => true, 'reupload' => true, 'skipcaptcha' => true, 'rollback' => true, 'browsearchive' => true, 'unblockself' => true,
			'undelete' => true, 'upload' => true, 'upload_by_url' => true, 'apihighlimits' => true, 'unwatchedpages' => true, 'deletedhistory' => true, 'deletedtext' => true, 'abusefilter-log-detail' => true,
		),
	),
	'nlwiki' => array(
		'autoconfirmed' => array( 'patrol' => true  ),
		'checkuser' => array( 'deletedhistory' => true, 'deletedtext' => true, 'browsearchive' => true ),
		'arbcom' => array( 'deletedhistory' => true, 'deletedtext' => true, 'browsearchive' => true ),
		'rollbacker' => array( 'rollback' => true ),
	),
	'+nlwiktionary' => array( 'user' => array( 'patrol' => true ) ),
	'+nlwikivoyage' => array(
		'autopatrolled' => array(
			'autopatrol' => true, // bug 44082
			'patrol' => true, // bug 44082
		),
	),
	'+nlwikibooks' => array( 'user' => array( 'patrol' => true ) ),
	// 'nlwikinews' => array( 'user' => array( 'patrol' => true ) ),
	'+nnwiki' => array(
		'autopatrolled' => array( 'autopatrol' => true ),
		'patroller' => array( 'autopatrol' => true, 'patrol' => true, 'rollback' => true ),
	),
	'nowiki' => array(
		'patroller' => array( 'patrol' => true, 'autopatrol' => true, 'rollback' => true, 'unwatchedpages' => true, 'suppressredirect' => true, ),
		'autopatrolled' => array( 'autopatrol' => true, 'unwatchedpages' => true ),
	),
	'+nowikibooks' => array(
		'user' => array( 'patrol' => false ),
		'autoconfirmed' => array( 'patrol' => false ),
		'sysop' => array( 'patrol' => true ),
		'patroller' => array( 'patrol' => true, 'autopatrol' => true, 'rollback' => true, 'markbotedits' => true ),
		'autopatrolled' => array( 'autopatrol' => true ),
	),
	'nowikimedia' => array( '*' => array(
		'edit' => false,
	) ),

	'+officewiki' => array(
		'communityapps' => array( 'view-community-applications' => true ),
		'user' => array( 'massmessage' => true, ), // bug 64978
	),
	'+ombudsmenwiki'  => array(
		'autoconfirmed' => array(
			'autoconfirmed' => false,
			'editsemiprotected' => false,
			'reupload' => false,
			'upload' => false,
			'move' => false,
			'collectionsaveasuserpage' => false,
			'collectionsaveascommunitypage' => false,
			'skipcaptcha' => false,
		),
		'accountcreator' => array( 'noratelimit' => false, ),
		'bureaucrat' => array( 'createaccount' => true, ),
		'sysop' => array( 'createaccount' => false, ),
	),
	'+orwiki' => array(
		'rollbacker' => array( 'rollback' => true ),
		'sysop' => array( 'import' => true ),
	),
	// http://bugzilla.wikimedia.org/show_bug.cgi?id=6303
	'plwiki' => array(
		'user' => array( 'upload' => false ),
		'autoconfirmed' => array( 'upload' => true ),
		'editor' => array( 'rollback' => true, 'patrolmarks' => true, 'editor' => true ), // bug 20154 and 46990
		'flood' => array( 'bot' => true ), // bug 20155
		'sysop' => array( 'deleterevision' => true, 'editor' => true ), // bug 46990
		'bot' => array( 'editor' => true ), // bug 46990
	),
	'plwikiquote' =>  array(
		'patroller' => array( 'patrol' => true, 'autopatrol' => true, ), // http://bugzilla.wikimedia.org/show_bug.cgi?id=28479
	),
	'plwikisource' => array(
		'editor' => array( 'autopatrol' => true, 'patrol' => true ), //Bug 70459
	),
	'plwiktionary' => array(
		'editor' => array( 'patrolmarks' => true ),
	),
	// http://bugzilla.wikimedia.org/show_bug.cgi?id=9024 , 10362
	'ptwiki' => array(
		'autoconfirmed' => array( 'patrol' => true, 'abusefilter-log-detail' => true ),
		'bot' => array( 'autoreviewer' => true, ),
		'autoreviewer' => array( 'autopatrol' => true, 'autoreviewer' => true ),
		'eliminator' => array(
			'browsearchive' => true,
			'delete' => true,
			'nuke' => true,
			'undelete' => true,
			'deletedhistory' => true,
			'deletedtext' => true,
			'autopatrol' => true,
			'suppressredirect' => true,
			'autoreviewer' => true
		),
		'rollbacker' => array(
			'rollback' => true,
			'unwatchedpages' => true,
			'block' => true, // https://bugzilla.wikimedia.org/show_bug.cgi?id=35261
		), // https://bugzilla.wikimedia.org/show_bug.cgi?id=27563
		'user' => array(
			'move' => false,
			'move-rootuserpages' => false,
		),
		'sysop' => array( 'autoreviewer' => true ),
		'bureaucrat' => array(
			'move-rootuserpages' => true,
			'autopatrol' => true,
			'autoreviewer' => true
		),
		'interface_editor' => array( // Bug 39905
			'editinterface' => true,
			'edituserjs' => true,
			'editusercss' => true,
		),
	),
	'+quwiki' => array(
		'rollbacker' => array( 'rollback' => true ),
	),
	'rowiki' => array(
		'sysop' => array(
			'autopatrol' => true,
			'patrol' => true,
			'templateeditor' => true, // bug 61172
		),
		'patroller' => array( 'patrol' => true, 'upwizcampaigns' => true, ), // bug 59242
		'autopatrolled' => array( 'autopatrol' => true, ),
		'templateeditor' => array( // bug 61172
			'templateeditor' => true,
			'editinterface' => true,
		),
	),
	'+ruwiki' => array(
		'*' => array( 'patrolmarks' => true, ),
		'rollbacker' => array( 'rollback' => true ),
		'uploader' => array( // bug 12334
			'upload' => true,
			'reupload-own' => true,
			'reupload' => true,
		),
		'user' => array( // bug 66871
			'move-categorypages' => false,
		),
		'closer' => array(
			'move-categorypages' => true, // bug 66871
			'delete' => true,
			'suppressredirect' => true,
			'upload' => true,
			'reupload-own' => true,
			'reupload' => true,
		),
		'filemover' => array( // bug 30984
			'movefile' => true,
			'suppressredirect' => true,
			'upload' => true,
			'reupload-own' => true,
			'reupload' => true,
			'move-categorypages' => true, // bug 66871
		),
		'suppressredirect' => array( // bug 38408, 66871
			'suppressredirect' => true,
			'move-categorypages' => true,
		),
		'arbcom' => array( // bug 49334
			'browsearchive' => true,
			'deletedhistory' => true,
			'deletedtext' => true,
			'abusefilter-log-detail' => true,
		),
	),
	'ruwikiquote' => array(
		'autoeditor' => array( 'autoreview' => true, 'autoconfirmed' => true, 'editsemiprotected' => true ),
	),
	'ruwikisource' => array(
		'autoeditor' => array( 'autoreview' => true, 'autoconfirmed' => true, 'editsemiprotected' => true ),
		'rollbacker' => array( 'rollback' => true, 'suppressredirect' => true ),
		'flood' => array( 'bot' => true ),
	),
	'ruwikiversity' => array(
		'patroller' => array( 'patrol' => true, 'autopatrol' => true ),
	),
	'ruwikivoyage' => array(
		'autopatrolled' => array( 'autopatrol' => true ), // bug 46915
	),
	'+sawiki' => array(
		'autopatrolled' => array( 'autopatrol' => true ),
	),
	'+sawikisource' => array(
		'autopatrolled' => array( 'autopatrol' => true ),
	),
	'+scowiki' => array(
		'rollbacker' => array( 'rollback' => true ),
		'autopatrolled' => array( 'autopatrol' => true, ),
	),
	'+sewikimedia' => array(
		'*' => array(
			'edit' => false,
			'editallpages' => false,
		),
		'user' => array(
			'editallpages' => true, // Bug 39671
		),
		'sysop' => array( // bug 61947
			'editallpages' => true,
		),
		'medlem' => array(
			'move' => true,
			'move-subpages' => true,
			'read' => true,
			'edit' => true,
			'createpage' => true,
			'createtalk' => true,
			'minoredit' => true,
			'purge' => true,
			'editallpages' => true,
		),
	),
	'+simplewiki' => array(
		'flood' => array( 'bot' => true ),
		'rollbacker' => array( 'rollback' => true, ),
		# bug 27875 (see comment 4)
		'patroller' => array( 'patrol' => true, 'autopatrol' => true ),
	),
	'+simplewiktionary' => array(
		'rollbacker' => array( 'rollback' => true, ),
		'autopatrolled' => array( 'patrol' => true, 'autopatrol' => true ),
	),
	'shwiki' => array( // bug 50802
		'patroller' => array( 'patrol' => true ),
		'autopatrolled' => array(
			'autopatrol' => true,
			'patrolmarks' => true, // bug 60818
		),
		'rollbacker' => array(
			'rollback' => true,
			'markbotedits' => true, // bug 62462
		),
		'filemover' => array( 'movefile' => true, 'suppressredirect' => true ),
		'flood' => array( 'bot' => true ),
	),
	'+shwiktionary' => array(
		'autopatrolled' => array( 'autopatrol' => true ),
	),
	'siwiki' => array(
		'rollbacker'    => array( 'rollback' => true ),
		'autopatrolled' => array( 'autopatrol' => true ),
	),
	'+skwiki' => array(
		'rollbacker' => array( 'rollback' => true ),
	),
	'srwiki' => array(
		'user' => array( 'upload' => false ),
		'autoconfirmed' => array( 'upload' => true ),
		'patroller' => array( 'patrol' => true ),
		'autopatrolled' => array( 'autopatrol' => true ),
		'rollbacker' => array( 'rollback' => true ),
		'flood' => array( 'bot' => true ),
	),
	'+srwikisource' => array(
		'patroller' => array( 'patrol' => true ),
		'autopatrolled' => array( 'autopatrol' => true ),
	),
	'+stewardwiki' => array(
		'bureaucrat' => array( 'userrights' => true ), // http://bugzilla.wikimedia.org/show_bug.cgi?id=28773
	),
	'svwiki' => array(
		'autoconfirmed' => array( 'patrol' => true ),
		'rollbacker'	=> array( 'rollback' => true, 'autopatrol' => true ),
	),
	'+svwikisource' => array( // Bug 28614 & 36895
		'autopatrolled' => array( 'autopatrol' => true, 'suppressredirect' => true, 'upload' => true, 'reupload' => true ),
	),
	'tawiki' => array(
		'nocreate' => array( 'createpage' => false, ),
	),
	'testwiki' => array(
		'accountcreator' => array( 'override-antispoof' => true, 'tboverride' => true ),
		'filemover' => array( 'movefile' => true ), // bug 30121
		'user' => array(
			'upload_by_url' => true, // For wider testing
			'upload' => true, // Exception to bug 12556, used for testing of upload tools
		),
		'templateeditor' => array( 'templateeditor' => true, 'tboverride' => true, ), //bug 59084
		'sysop' => array(
			'deleterevision' => true,
			'templateeditor' => true,
			'securepoll-create-poll' => true,
		),
		'reviewer' => array(
			'stablesettings' => true,
		),
		'researcher' => array( 'browsearchive' => true, 'deletedhistory' => true, 'apihighlimits' => true ),
		'rollbacker' => array( 'rollback' => true ),
		'centralnoticeadmin' => array( 'centralnotice-admin' => true, 'editinterface' => true ), //adding to allow CN access without local sysop JRA 2013-02-21
	),
	'test2wiki' => array(
		'user' => array(
			'upload_by_url' => true, // For testing of Flickr uploading via UploadWizard
			'upload' => true,
		),
		'qa_automation' => array( // For browser tests, bug 58375 and bug 61799
			'block' => true,
			'flow-delete' => true,
			'flow-suppress' => true,
		),
	),
	'thwiki' => array(
		'autoconfirmed' => array(
			'patrol' => true, // Bug 46154
		),
	),
	'trwiki' => array(
		'autoreview' => array(
			'autopatrol' => true, // Bug 38690
		),
		'checkuser' => array(
			'browsearchive' => true, // Bug 38690
			'deletedhistory' => true, // Bug 38690
			'deletedtext' => true, // Bug 38690
		),
		'oversight' => array(
			'browsearchive' => true, // Bug 38690
			'deletedhistory' => true, // Bug 38690
			'deletedtext' => true, // Bug 38690
		),
		'patroller' => array(
			'autoconfirmed' => true, // Bug 38690
			'editsemiprotected' => true,
			'autopatrol' => true, // Bug 38690
			'autoreview' => true, // Bug 38690
			'patrol' => true,
			'review' => true, // Bug 38690
			'rollback' => true, // Bug 38690
			'unreviewedpages' => true, // Bug 38690
			'movefile' => true, // Bug 44587
		),
		'sysop' => array(
			'review' => true, // Bug 38690
			'unreviewedpages' => true, // Bug 38690
		),
		'technician' => array(
			'abusefilter-log-detail' => true, // Bug 38690
			'abusefilter-modify' => true, // Bug 38690
			'apihighlimits' => true, // Bug 38690
			'editinterface' => true, // Bug 38690
			'editusercss' => true, // Bug 38690
			'edituserjs' => true, // Bug 38690
			'noratelimit' => true, // Bug 38690
		),
	),
	'ukwiki' => array(
		'patroller' => array( 'patrol' => true, 'autopatrol' => true, ),
		'rollbacker' => array( 'rollback' => true ),
	),
	'+ukwikivoyage' => array(
		'autopatrolled' => array( 'autopatrol' => true ), // bug 54299
		'rollbacker' => array( 'rollback' => true ),
		'uploader' => array( 'upload' => true, 'reupload' => true ),
	),
	'+ukwiktionary' => array(
		'autoeditor' => array( 'autoreview' => true ),
	),
	'urwiki' => array(
		'rollbacker' => array( 'rollback' => true ), // bug 45642
	),
	'vecwiki' => array(
		'flood' => array( 'bot' => true ),
	),
	'viwiki' => array(
		'eliminator' => array( // bug 68612
			'autopatrol' => true,
			'delete' => true,
			'deletedhistory' => true,
			'deletedtext' => true,
			'deleterevision' => true,
			'patrol' => true,
			'protect' => true,
			'rollback' => true,
			'undelete' => true
		),
		'flood' => array( 'bot' => true ),
		'rollbacker' => array( 'rollback' => true ),
		'patroller' => array( 'patrol' => true ), // bug 46828
		'autopatrolled' => array( 'autopatrol' => true ), // bug 46828
	),
	'wikidata' => array(
		'autoconfirmed' => array(
			'patrol' => true, // bug 56203
			'autopatrol' => true, // bug 56203
		),
		'rollbacker' => array(
			'rollback' => true, // bug 45165
			'autopatrol' => true, // bug 55495
			'patrol' => true, // bug 55495
			'editsemiprotected' => true, // bug 55495
			'move' => true, // bug 55495
			'autoconfirmed' => true, // bug 55495
			'skipcaptcha' => true, // bug 55495
			'abusefilter-log-detail' => true, // bug 55495
			'suppressredirect' => true, // bug 56203
		),
		'propertycreator' => array(
			'property-create' => true, // bug 46953
			'autopatrol' => true, // bug 55495
			'patrol' => true, // bug 55495
			'editsemiprotected' => true, // bug 55495
			'move' => true, // bug 55495
			'autoconfirmed' => true, // bug 55495
			'skipcaptcha' => true, // bug 55495
			'abusefilter-log-detail' => true, // bug 55495
		),
		'sysop' => array( 'property-create' => true ), // bug 46953
		'flood' => array( 'bot' => true ), // bug 48013
	),
	// due to mass vandalism complaint, 2006-04-11
	'zhwiki' => array(
		// '*' => array( 'createpage' => false ),  # re-enabled createpage priv according to bug 25142, then redisabled *sigh*, then reenabled \o/
		'rollbacker' => array( 'rollback' => true, 'abusefilter-log-private' => true ), # Bugs 16988 & 37679
		'patroller' => array( 'patrol' => true, 'autopatrol' => true ),
		'autoreviewer' => array( 'autopatrol' => true ),
		'flood' => array( 'bot' => true ),
	),

	'zhwikinews' => array(
		'rollbacker' => array( 'rollback' => true ), # 27268
		'flood' => array( 'bot' => true ), // bug 52546
	),
	'zhwikivoyage' => array( // bug 60328
		'autopatrolled' => array( 'autopatrol' => true ),
		'patroller' => array( 'patrol' => true, 'rollback' => true ),
	),
	'+zhwiktionary' => array( // bug 5836
		'bot' => array( 'patrol' => true ),
	),
	'zh_yuewiki' => array(
		'autoconfirmed' => array( 'patrol' => true ),
		'rollbacker' => array( 'rollback' => true ),
		'autoreviewer' => array( 'autopatrol' => true ),
	),

	'+strategywiki' => array( 'flood' => array( 'bot' => true ) ),
),
# @} end of groupOverrides

# groupOverrides2 @{
'groupOverrides2' => array(
	// IMPORTANT: don't forget to use a '+' sign in front of any group name
	// after 'default' or it will replace the defaults completely.
	'default' => array(
		'sysop' => array(
			'importupload' => false,
			'suppressredirect' => true, // http://meta.wikimedia.org/w/index.php?title=Wikimedia_Forum&oldid=1371655#Gives_sysops_to_.22suppressredirect.22_right
			'noratelimit' => true,
			'deleterevision' => true,
			'deletelogentry' => true,
		),
		'bot' => array(
			'noratelimit' => true,
		),
		'accountcreator' => array(
			'noratelimit' => true,
		),
		'bureaucrat' => array(
			'noratelimit' => true,
		),
		'steward' => array(
			'noratelimit' => true,
		),
		// 'rollback' => array( 'rollback' => true, ),
		'import' => array( 'importupload' => true, 'import' => true ),
		'transwiki' => array( 'import' => true ),
		'user' => array(
			'reupload-shared' => false,
			'reupload' => false,
			'upload' => false, // https://bugzilla.wikimedia.org/show_bug.cgi?id=12556
			'reupload-own' => true,
			'move' => false, // http://bugzilla.wikimedia.org/show_bug.cgi?id=12071
			'move-subpages' => false, // for now...
			'movefile' => false, // r93871 CR
		),
		'autoconfirmed' => array(
			'reupload' => true,
			'upload' => true, // https://bugzilla.wikimedia.org/show_bug.cgi?id=12556
			'move' => true,
			'collectionsaveasuserpage' => true,
			'collectionsaveascommunitypage' => true,
		),
		// Deployed to all wikis by Andrew, 2009-04-28
		'ipblock-exempt' => array(
			'ipblock-exempt' => true,
			'torunblocked' => true,
		),

		# So that I can rename users with more than 6800 edits -- TS
		# Removed as obsolete -- 2009-03-05 BV
		# 'developer' => array( 'siteadmin' => true ),

		# To allow for inline log suppression -- 2009-01-29 -- BV
		'oversight' => array(
			'deleterevision' => true,
			'deletelogentry' => true,
			'hideuser' => true, // was forgotten. added 2009-03-05 -- BV
			'suppressrevision' => true,
			'suppressionlog' => true,
			'abusefilter-hide-log' => true, // Andrew, 2010-08-28
			'abusefilter-hidden-log' => true, // Andrew, 2010-08-28
		),
	),
),
# @} end of wgGroupOverrides2

# wgAddGroups @{
'wgAddGroups' => array(
	// The '+' in front of the DB name means 'add to the default'. It saves us duplicating
	// changes to the default across all overrides --Andrew 2009-04-28
	'default' => array(
		'bureaucrat' => array( 'sysop', 'bureaucrat', 'bot' ),
		'sysop' => array( 'ipblock-exempt' ),
	),
	'+testwiki' => array(
		'bureaucrat' => array( 'researcher', 'centralnoticeadmin', 'translationadmin' ),
		'sysop' => array( 'filemover', 'rollbacker', 'accountcreator', 'confirmed', 'templateeditor' ),
		# 'user' => array( 'editor', 'reviewer' ),
	),
	'+test2wiki' => array(
		'qa_automation' => array( 'qa_automation' ), // For browser tests, bug 58375
	),
	// ******************************************************************
	'+arwiki' => array(
		'bureaucrat' => array( 'import', 'reviewer', 'abusefilter' ),
		'sysop' => array( 'uploader', 'reviewer', 'confirmed', 'rollbacker', 'abusefilter', ),
	),
	'+arwikisource' => array(
		'sysop' => array( 'patroller', 'autopatrolled', ),
	),
	'+bewiki' => array(
		'sysop' => array( 'autoeditor' ),
	),
	'+bewikimedia' => array(
		'bureaucrat' => array( 'translationadmin' ),
	),
	'+be_x_oldwiki' => array(
		'sysop' => array( 'abusefilter' ),
	),
	'+bgwiki' => array(
		'bureaucrat' => array( 'patroller' ),
		'sysop' => array( 'autopatrolled' ),
	),
	'+bnwiki' => array(
		'sysop' => array( 'autopatrolled', 'filemover', 'flood', 'rollbacker' ),
		'bureaucrat' => array( 'import' ),
	),
	'+brwikimedia' => array(
		'sysop' => array( 'translationadmin', 'autopatrolled', 'confirmed' ), // bug 58123, 63345
	),
	'+bswiki' => array(
		'sysop' => array( 'flood' ), // bug 50425
		'bureaucrat' => array( 'patroller', 'autopatrolled', 'rollbacker' ),
	),
	'+cawiki' => array(
		'sysop' => array( 'rollbacker', 'autopatrolled', 'abusefilter', 'accountcreator' ), // bug 56570
	),
	'+checkuserwiki' => array(
		'bureaucrat' => array( 'accountcreator', 'import', 'transwiki', 'user', 'autoconfirmed', 'ipblock-exempt', ),
	),
	'+ckbwiki' => array(
		'sysop' => array(
			'rollbacker', // bug 51312
			'autopatrolled', // bug 51328
			'uploader', // bug 51232
			'confirmed', // bug 51715
			'flood', // bug 51803
			'suppressredirect', // bug 67278
		),
		'bureaucrat' => array(
			'botadmin', // Bug 52578
			'import', // bug 52633
			'transwiki', // bug 52633
			'interface_editor', // bug 52866
			'accountcreator', // bug 69394
		),
	),
	'+collabwiki' => array(
		'bureaucrat' => array( 'translationadmin' ),
	),
	'+cswiki' => array(
		'bureaucrat' => array( 'arbcom', 'autopatrolled' ), // bug 61418
	),
	'+cswikinews' => array(
		'bureaucrat' => array( 'autopatrolled' ),
	),
	'+cswikiquote' => array(
		'bureaucrat' => array( 'autopatrolled' ),
	),
	'+cswikisource' => array(
		'bureaucrat' => array( 'autopatrolled' ),
	),
	'+cswiktionary' => array(
		'bureaucrat' => array( 'autopatrolled' ),
	),
	'+commonswiki' => array(
		'bureaucrat' => array( 'gwtoolset', 'ipblock-exempt', 'OTRS-member', 'translationadmin' ), // bug 63124
		'checkuser'  => array( 'ipblock-exempt' ),
		'sysop' => array( 'rollbacker', 'confirmed', 'patroller', 'autopatrolled', 'filemover', 'Image-reviewer' ),
		'steward' => array( 'OTRS-member' ),
		'Image-reviewer' => array( 'Image-reviewer' ),
	),
	'+dawiki' => array(
		'sysop' => array( 'patroller', 'autopatrolled' ),
	),
	'+dewiki' => array(
		'bureaucrat' => array( 'noratelimit' ), // bug 57819
	),
	'+dewikivoyage' => array(
		'sysop' => array( 'autopatrolled' ), // Bug 65495
	),
	'+donatewiki' => array(
		'sysop' => array( 'inactive', 'flood' ),
		'bureaucrat' => array( 'import', 'transwiki', 'inactive' ),
	),
	'+elwiki' => array(
		'bureaucrat' => array( 'accountcreator' ), // bug 59997
	),
	'+elwiktionary' => array(
		'bureaucrat' => array( 'interface_editors' ),
		'sysop' => array( 'autopatrolled' ),
	),
	'+enwiki' => array(
		'bureaucrat' => array( 'accountcreator' ),
		'sysop' => array( 'abusefilter', 'accountcreator', 'autoreviewer', 'confirmed', 'filemover', 'reviewer', 'rollbacker', 'templateeditor', 'massmessage-sender', 'OTRS-member' ),
	),
	'+enwikibooks' => array(
		'sysop' => array( 'transwiki', 'uploader' ),
		'bureaucrat' => array( 'flood' ),
	),
	'+enwikinews' => array(
		'bureaucrat' => array ( 'flood' ),
		'sysop' => array ( 'flood' ),
	),
	'+enwikivoyage' => array(
		'sysop' => array( 'autopatrolled' ),
		'bureaucrat' => array( 'patroller' ),
	),
	'+eswiki' => array(
		'bureaucrat' => array( 'rollbacker', 'confirmed' ),
		'sysop' => array( 'rollbacker', 'autopatrolled', 'patroller' ),
	),
	'+eswikibooks' => array(
		'bureaucrat' => array( 'flood' ),
		'sysop' => array( 'flood', 'rollbacker' ),
	),
	'+eswikinews' => array(
		'bureaucrat' => array( 'editprotected', 'flood', ),
	),
	'+eswikiquote' => array(
		'sysop' => array( 'autopatrolled', 'confirmed', 'patroller', 'rollbacker' ), // bug 62911
	),
	'+eswikisource' => array(
		'sysop' => array( 'autopatrolled' ), // bug 67557
	),
	'+eswikivoyage' => array(
		'bureaucrat' => array( 'confirmed', ), // Bug 47325
		'sysop' => array( 'rollbacker', 'patroller', 'autopatrolled', ), // Bug 44285, 55665
	),
	'+eswiktionary' => array(
		'bureaucrat' => array( 'autopatrolled', 'patroller', 'rollbacker' ),
	),
	'+enwikisource' => array(
		'bureaucrat' => array( 'autopatrolled', 'flood' ), # https://bugzilla.wikimedia.org/show_bug.cgi?id=36863
		'sysop' => array( 'abusefilter', 'autopatrolled' ),
	),
	'+enwiktionary' => array(
		'sysop' => array( 'autopatrolled', 'flood', 'patroller', 'rollbacker' ),
	),
	'+fawiki' => array(
		'bureaucrat' => array( 'patroller', 'Image-reviewer', 'botadmin', 'OTRS-member' ), // bug 64532, 69411 and 54368
		'sysop' => array( 'rollbacker', 'autopatrol', 'uploader' ), // bug 23233, 29007 and 69171
		'botadmin' => array( 'patroller', 'Image-reviewer', 'rollbacker', 'autopatrol', 'uploader' ), // bug 69411
	),
	'+fawikinews' => array(
		'sysop' => array( 'rollbacker', 'patroller' ),
	),
	'+fawikivoyage' => array(
		'sysop' => array(
			'autopatrolled', // bug 71760
			'confirmed', // bug 71760
			'flood', // bug 71760
			'patroller', // bug 71760
			'rollbacker', // bug 71760
			'transwiki', // bug 71681
		),
	),
	'+fiwiki' => array(
		'bureaucrat' => array( 'arbcom' ),
		'sysop' => array( 'rollbacker' ),
	),
	'+foundationwiki' => array(
		'sysop' => array( 'inactive', 'flood' ),
		'bureaucrat' => array( 'import', 'transwiki', 'inactive', 'petitiondata' ),
	),
	'+frwiki' => array(
		'bureaucrat' => array( 'abusefilter', 'accountcreator' ),
	),
	'+frwikibooks' => array(
		'bureaucrat' => array( 'abusefilter' ),
		'sysop' => array( 'patroller' ),
	),
	'+frwikisource' => array(
		'sysop' => array( 'patroller', 'autopatrolled' ),
	),
	'+frwikiversity' => array(
		'sysop' => array( 'patroller' ),
	),
	'+frwikivoyage' => array(
		'sysop' => array( 'patroller' ),
	),
	'+frwiktionary' => array(
		'bureaucrat' => array( 'accountcreator', 'patroller', 'transwiki', 'autopatrolled', 'confirmed', 'abusefilter', 'botadmin' ),
	),
	'+gawiki' => array(
		'sysop' => array( 'rollbacker' ),
	),
	'+hewiki' => array(
		'sysop' => array( 'patroller', 'autopatrolled', 'accountcreator' ),
		'bureaucrat' => array( 'editinterface' ),
	),
	'+hewikibooks' => array(
		'sysop' => array( 'patroller', 'autopatrolled' ),
	),
	'+hewikiquote' => array(
		'sysop' => array( 'autopatrolled' ),
	),
	'+hewikivoyage' => array(
		'sysop' => array( 'autopatrolled' ), // bug 50377
	),
	'+hiwiki' => array(
		'sysop' => array( 'abusefilter', 'autopatrolled', 'reviewer', 'rollbacker', 'filemover' ),
	),
	'+hrwiki' => array(
		'bureaucrat' => array( 'patroller', 'autopatrolled' ),
		'sysop' => array( 'patroller', 'autopatrolled' ),
	),
	'+idwiki' => array(
		'sysop' => array( 'rollbacker' ),
		'bureaucrat' => array( 'rollbacker' ),
	),
	'+incubatorwiki' => array(
		'bureaucrat' => array( 'test-sysop', 'translator', 'import', 'translationadmin' ),
	),
	'+itwiki' => array(
		'bureaucrat' => array( 'rollbacker' ),
		'sysop' => array( 'accountcreator', 'autopatrolled', 'flood', 'filemover' ), // bug 53913, 61109
	),
	'+itwikibooks' => array(
		'sysop' => array( 'autopatrolled', 'patroller' ),
	),
	'+itwikiquote' => array(
		'sysop' => array( 'autopatrolled' ),
	),
	'+itwikivoyage' => array(
		'sysop' => array( 'autopatrolled', 'patroller' ),          // Bug 43327 and 45638
	),
	'+itwiktionary' => array(
		'sysop' => array( 'patroller', 'autopatrolled' ),
	),
	'+jawiki' => array(
		'sysop' => array( 'abusefilter' ),
		'bureaucrat' => array( 'rollbacker', 'eliminator', 'interface_editor' ),
	),
	'+jawiktionary' => array(
		'sysop' => array( 'autopatrolled' ), // bug 61366
	),
	'+kawiki' => array(
		'sysop' => array( 'trusted' ),
	),
	'+kowiki' => array(
		'sysop' => array( 'rollbacker', 'confirmed' ),
	),
	'+labswiki' => array('shellmanagers' => array( 'shell')),
	'+legalteamwiki' => array( // bug 61222
		'bureaucrat' => array( 'accountcreator', 'import', 'transwiki', 'ipblock-exempt', 'translationadmin' ),
	),
	'+ltwiki' => array(
		'sysop' => array ( 'abusefilter' ),
	),
	'+ltwiktionary' => array(
		'sysop' => array( 'abusefilter' ),
	),
	'+lvwiki' => array(
		'sysop' => array( 'autopatrolled', 'patroller' ), //Bug 70441
	),
	'+mediawikiwiki' => array(
		'sysop' => array( 'autoreview' ),
		'bureaucrat' => array( 'autoreview', 'transwiki', 'coder', 'import', 'svnadmins', 'translationadmin' ),
		'coder' => array( 'coder' ),
	),
	'+metawiki' => array(
		'bureaucrat' => array( 'ipblock-exempt', 'centralnoticeadmin', 'flood', 'uploader', 'translationadmin' ), // bug 46639
		'checkuser'  => array( 'ipblock-exempt' ),
		'sysop'      => array( 'autopatrolled', 'massmessage-sender' ), // bug 57611
	),
	'+mkwiki' => array(
		'bureaucrat' => array( 'patroller', 'autopatrolled', 'autoreviewed' ),
	),
	'+mlwiki' => array(
		'sysop' => array( 'patroller', 'autopatrolled', 'rollbacker' ),
		'bureaucrat' => array( 'botadmin' ),
	),
	'+mlwikisource' => array(
		'sysop' => array( 'patroller', 'autopatrolled' ),
		'bureaucrat' => array( 'botadmin' ),
	),
	'+mlwiktionary' => array(
		'bureaucrat' => array( 'botadmin' ),
	),
	'+nlwiki' => array(
		'bureaucrat' => array( 'abusefilter', 'arbcom', 'rollbacker' ),
	),
	'+nlwikibooks' => array(
		'sysop' => array( 'abusefilter' ),
	),
	'+nnwiki' => array(
		'bureaucrat' => array( 'autopatrolled', 'patroller' ),
		'sysop' => array( 'autopatrolled', 'patroller' ),
	),
	'+nlwikivoyage' => array(
		'bureaucrat' => array( 'autopatrolled' ), // bug 44082
	),
	'+noboard_chapterswikimedia' => array(
		'bureaucrat' => array( 'import', 'transwiki' ),
	),
	'+nowiki' => array(
		'bureaucrat' => array( 'patroller', 'autopatrolled', 'accountcreator' ),
		'sysop' => array( 'patroller', 'autopatrolled', 'abusefilter', 'transwiki' ),
	),
	'+nowikibooks' => array(
		'bureaucrat' => array( 'sysop', 'bureaucrat', 'bot', 'patroller', 'autopatrolled' ),
		'sysop' => array( 'autopatrolled', 'patroller' ),
	),
	'+officewiki' => array(
		'bureaucrat' => array( 'import', 'transwiki', 'communityapps' ),
	),
	'+ombudsmenwiki' => array(
		'bureaucrat' => array( 'accountcreator', 'import', 'transwiki', 'user', 'autoconfirmed', 'ipblock-exempt', ),
	),
	'+orwiki' => array(
		'sysop' => array( 'rollbacker' ),
	),
	'+otrs_wikiwiki' => array(
		'bureaucrat' => array( 'import', 'transwiki', 'translationadmin' ), // bug 61297
	),
	'+outreachwiki' => array(
		'bureaucrat' => array( 'translationadmin' ),
	),
	'+plwiki' => array(
		'bureaucrat' => array( 'abusefilter', 'flood' ),
	),
	'+plwikiquote' => array(
		'sysop' => array( 'patroller' ), // http://bugzilla.wikimedia.org/show_bug.cgi?id=28479
	),
	'+ptwikinews' => array(
		'sysop' => array( 'reviewer' ),
	),
	'+private' => array( // Cary made me do it! --Andrew 2009-05-01
		'bureaucrat' => array( 'inactive' ),
	),
	'+ptwiki' => array(
		'bureaucrat' => array( 'eliminator', 'confirmed', 'autoreviewer', 'interface_editor', 'accountcreator' ), // bug 39905, 63750
		'sysop' => array( 'rollbacker', 'autoreviewer', 'confirmed', 'accountcreator' ), // bug 63750
	),
	'+ptwikivoyage' => array(
		'sysop' => array( 'bot' ), // Bug 45233
	),
	'+quwiki' => array(
		'sysop' => array( 'rollbacker' ),
	),
	'+rowiki' => array(
		'sysop' => array( 'autopatrolled', 'templateeditor' ), // bug 61172
		'bureaucrat' => array( 'abusefilter', 'patroller' ), // bug 26634
	),
	'+ruwiki' => array(
		'sysop' => array( 'rollbacker', 'autoeditor', 'uploader', 'closer', 'filemover', 'suppressredirect' ),
		'bureaucrat' => array( 'arbcom' ), // bug 49334
	),
	'+ruwikiquote' => array(
		'sysop' => array( 'autoeditor' )
	),
	'+ruwikisource' => array(
		'bureaucrat' => array( 'autoeditor', 'rollbacker' ),
		'sysop' => array( 'autoeditor', 'rollbacker', 'abusefilter', 'flood' ),
	),
	'+ruwikivoyage' => array(
		'sysop' => array( 'autopatrolled' ), // bug 46915
	),
	'+sawiki' => array(
		'sysop' => array( 'autopatrolled' ),
	),
	'+sawikisource' => array(
		'sysop' => array( 'autopatrolled' ),
	),
	'+scowiki' => array(
		'sysop' => array( 'rollbacker', 'autopatrolled', )
	),
	'+sewikimedia' => array(
		'bureaucrat' => array( 'medlem' ),
		'sysop' => array( 'medlem' ),
	),
	'+simplewiki' => array(
		'bureaucrat' => array( 'rollbacker', 'transwiki', 'patroller' ),
		'sysop' => array( 'rollbacker', 'flood', 'patroller' ),
	),
	'+shwiki' => array(
		'bureaucrat' => array(
			'autopatrolled', 'filemover', 'patroller', 'rollbacker', // bug 50802
			'flood', // bug 52273
		),
		'sysop' => array(
			'autopatrolled', 'filemover', 'patroller', 'rollbacker', // bug 50802
			'flood', // bug 52273
		),
	),
	'+shwiktionary' => array(
		'sysop' => array( 'autopatrolled' ),
		'bureaucrat' => array( 'autopatrolled' ),
	),
	'+siwiki' => array(
		'sysop' => array( 'rollbacker', 'accountcreator', 'abusefilter', 'autopatrolled', 'confirmed', 'reviewer' ),
	),
	'+simplewiktionary' => array(
		'sysop' => array( 'rollbacker', 'autopatrolled' ),
	),
	'+skwiki' => array(
		'sysop' => array( 'rollbacker' ),
	),
	'+sqwiki' => array(
		'bureaucrat' => array( 'editor' ),
		'sysop' => array( 'reviewer' ),
	),
	'+srwiki' => array(
		'bureaucrat' => array( 'patroller', 'autopatrolled', 'rollbacker', 'flood' ),
		'sysop' => array( 'rollbacker' ),
	),
	'+srwikisource' => array(
		'bureaucrat' => array( 'patroller', 'autopatrolled', ),
	),
	'+stewardwiki' => array(
		'bureaucrat' => array( 'import', 'transwiki', 'user', 'autoconfirmed', 'ipblock-exempt' ),
	),
	'+svwiki' => array(
		'bureaucrat' => array( 'accountcreator' ), // bug 54922
		'sysop' => array( 'rollbacker' ),
	),
	'+svwikisource' => array(
		'sysop' => array( 'autopatrolled', ),
	),
	'+tawiki' => array(
		'bureaucrat' => array( 'nocreate' ),
	),
	'+trwiki' => array(
		'sysop' => array( 'patroller' ), // bureaucrat -> sysop, Bug 38690
		'bureaucrat' => array( 'technician' ), // Bug 39690
	),
	'+ukwiki' => array(
		'sysop' => array( 'patroller', 'rollbacker' ),
	),
	'+ukwikivoyage' => array(
		'sysop' => array( 'rollbacker', 'uploader', 'autopatrolled' ), // bug 54229
	),
	'+ukwiktionary' => array(
		'bureaucrat' => array( 'autoeditor' ),
		'sysop' => array( 'autoeditor' ),
	),
	'+urwiki' => array(
		'bureaucrat' => array( 'import', 'confirmed', 'abusefilter', 'rollbacker' ), // Bug 42737 and 45643
		'sysop' => array( 'confirmed', 'abusefilter', 'rollbacker' ), // Bug 42737 and 45643
	),
	'+viwiki' => array(
		'sysop' => array(
			'rollbacker',
			'flood',
			'patroller', // bug 46828
			'autopatrolled' // bug 46828
		),
		'bureaucrat' => array(
			'eliminator', // bug 68612
			'flood'
		),
	),
	'+vecwiki' => array(
		'sysop' => array( 'flood' ),
	),
	'+wikidata' => array(
		'sysop' => array(
			'rollbacker', // bug 45165
			'confirmed', // bug 45124
			'propertycreator', // bug 46953
		),
		'bureaucrat' => array(
			'flood', // bug 48013
			'translationadmin',
		),
	),
	'+wikimania2013wiki' => array(
		'bureaucrat' => array( 'translationadmin' ),
	),
	'+wikimania2014wiki' => array(
		'bureaucrat' => array( 'translationadmin', 'confirmed' ),
		'sysop' => array( 'confirmed' ),
	),
	'+wikimania2015wiki' => array(
		'bureaucrat' => array( 'translationadmin' ),
	),
	'zerowiki' => array(
		'sysop' => true,
	),
	'+zhwiki' => array(
		'bureaucrat' => array( 'flood' ),
		'sysop' => array( 'patroller', 'rollbacker', 'autoreviewer', 'confirmed' ),
	),
	'+zhwikinews' => array(
		'sysop' => array(
			'rollbacker',
			'flood', // bug 52546
		),
	),
	'+zhwikivoyage' => array(
		'sysop' => array( 'autopatrolled', 'confirmed', 'patroller', 'transwiki' ), // bug 60085, 60328
	),
	'+zh_yuewiki' => array(
		'sysop' => array( 'abusefilter', 'rollbacker', 'autoreviewer', 'confirmed' ),
	),
),
# @} end of wgAddGroups

# wgRemoveGroups @{
'wgRemoveGroups' => array(
	// The '+' in front of the DB name means 'add to the default'. It saves us duplicating
	// changes to the default across all overrides --Andrew 2009-04-28
	'default' => array(
		'bureaucrat' => array( 'bot' ),
		'sysop' => array( 'ipblock-exempt' ),
	),
	'+testwiki' => array(
		'bureaucrat' => array( 'sysop', 'researcher', 'translationadmin', 'centralnoticeadmin' ),
		'sysop' => array( 'filemover', 'rollbacker', 'accountcreator', 'confirmed', 'templateeditor' ),
		# 'user' => array( 'editor', 'reviewer' ),
	),
	// ******************************************************************
	'+arbcom_enwiki' => array(
		'bureaucrat' => array( 'sysop', 'bureaucrat' ),
	),
	'+arbcom_fiwiki' => array(
		'bureaucrat' => array( 'sysop', 'bureaucrat' ),
	),
	'+arwiki' => array(
		'bureaucrat' => array( 'import', 'reviewer', 'abusefilter' ),
		'sysop' => array( 'uploader', 'reviewer', 'confirmed', 'rollbacker', 'abusefilter', 'patroller', 'autopatrolled', ),
	),
	'+arwikisource' => array(
		'sysop' => array( 'patroller', 'autopatrolled', ),
	),
	'+bawiki' => array(
		'bureaucrat' => array( 'sysop' ),
	),
	'+bewiki' => array(
		'sysop' => array( 'autoeditor' ),
	),
	'+bewikimedia' => array(
		'bureaucrat' => array( 'translationadmin' ),
	),
	'+be_x_oldwiki' => array(
		'sysop' => array( 'abusefilter' ),
	),
	'+bgwiki' => array(
		'bureaucrat' => array( 'patroller' ),
		'sysop' => array( 'autopatrolled' ),
	),
	'+bnwiki' => array(
		'sysop' => array( 'autopatrolled', 'filemover', 'flood', 'rollbacker' ),
		'bureaucrat' => array( 'import' ),
	),
	'+brwikimedia' => array(
		'sysop' => array( 'translationadmin', 'autopatrolled', 'confirmed' ), // bug 5812, 63345
		'bureaucrat' => array( 'sysop', 'bureaucrat' ), // bug 63345
	),
	'+bswiki' => array(
		'sysop' => array( 'flood' ), // bug 50425
		'bureaucrat' => array( 'patroller', 'autopatrolled', 'rollbacker' ),
	),
	'+cawiki' => array(
		'sysop' => array( 'rollbacker', 'autopatrolled', 'abusefilter', 'accountcreator' ), // bug 56570
	),
	'+checkuserwiki' => array(
		'bureaucrat' => array( 'sysop', 'accountcreator', 'import', 'transwiki', 'user', 'autoconfirmed', 'ipblock-exempt',  'bureaucrat', ),
	),
	'+ckbwiki' => array(
		'sysop' => array(
			'rollbacker', // bug 51312
			'autopatrolled', // bug 51328
			'uploader', // bug 51232
			'confirmed', // bug 51715
			'flood', // bug 51803
			'suppressredirect', // bug 67278
		),
		'bureaucrat' => array(
			'botadmin', // bug 52578
			'import', // bug 52633
			'transwiki', // bug 52633
			'interface_editor', // bug 52866
			'accountcreator', // bug 69394
		),
	),
	'+collabwiki' => array(
		'bureaucrat' => array( 'translationadmin' ),
	),
	'+commonswiki' => array(
		'bureaucrat' => array( 'gwtoolset', 'ipblock-exempt', 'OTRS-member', 'translationadmin' ), // bug 48620, 63124
		'checkuser' => array( 'ipblock-exempt' ),
		'sysop' => array( 'rollbacker', 'confirmed', 'patroller', 'autopatrolled', 'filemover', 'Image-reviewer' ),
		'steward' => array( 'OTRS-member' ),
	),
	'+cswiki' => array(
		'bureaucrat' => array( 'arbcom', 'autopatrolled' ), // bug 61418
	),
	'+cswikinews' => array(
		'bureaucrat' => array( 'autopatrolled' ),
	),
	'+cswikiquote' => array(
		'bureaucrat' => array( 'autopatrolled' ),
	),
	'+cswikisource' => array(
		'bureaucrat' => array( 'autopatrolled' ),
	),
	'+cswiktionary' => array(
		'bureaucrat' => array( 'autopatrolled' ),
	),
	'+dawiki' => array(
		'sysop' => array( 'patroller', 'autopatrolled' ),
	),
	'+dewiki' => array(
		'bureaucrat' => array( 'noratelimit' ), // bug 57819
	),
	'+dewikivoyage' => array(
		'sysop' => array( 'autopatrolled' ), // Bug 65495
	),
	'+donatewiki' => array(
		'sysop' => array( 'inactive', 'confirmed', 'flood' ),
		'bureaucrat' => array( 'sysop', 'bureaucrat', 'import', 'transwiki', 'inactive', 'confirmed' ),
	),
	'+elwiki' => array(
		'bureaucrat' => array( 'accountcreator' ), // bug 59997
	),
	'+elwiktionary' => array(
		'bureaucrat' => array( 'interface_editors' ),
		'sysop' => array( 'autopatrolled' ),
	),
	'+enwiki' => array(
		'bureaucrat' => array( 'ipblock-exempt', 'accountcreator', 'sysop' ),
		'sysop' => array( 'rollbacker', 'accountcreator', 'abusefilter', 'autoreviewer', 'confirmed', 'reviewer', 'filemover', 'templateeditor', 'massmessage-sender', 'OTRS-member' ),
	),
	'+enwikibooks' => array(
		'sysop' => array( 'transwiki', 'uploader', ),
		'bureaucrat' => array( 'flood' ),
	),
	'+enwikinews' => array(
		'bureaucrat' => array ( 'flood', 'sysop' ),
		'sysop' => array ( 'flood' ),
	),
	'+enwikivoyage' => array(
		'sysop' => array( 'autopatrolled' ),
		'bureaucrat' => array( 'sysop', 'patroller' ),
	),
	'+enwikisource' => array(
		'bureaucrat' => array( 'autopatrolled', 'flood' ), # https://bugzilla.wikimedia.org/show_bug.cgi?id=36863
		'sysop' => array( 'abusefilter', 'autopatrolled', ),
	),
	'+eswiki' => array(
		'bureaucrat' => array( 'rollbacker', 'confirmed' ),
		'sysop' => array( 'rollbacker', 'autopatrolled', 'patroller'  ),
	),
	'+eswikibooks' => array(
		'bureaucrat' => array( 'flood' ),
		'sysop' => array( 'flood', 'rollbacker' ),
	),
	'+eswikinews' => array(
		'bureaucrat' => array( 'editprotected', 'flood', ),
	),
	'+eswikiquote' => array(
		'sysop' => array( 'autopatrolled', 'confirmed', 'patroller', 'rollbacker' ), // bug 62911
	),
	'+eswikisource' => array(
		'sysop' => array( 'autopatrolled' ), // bug 67557
	),
	'+eswikivoyage' => array(
		'bureaucrat' => array( 'confirmed', ), // Bug 47325
		'sysop' => array( 'rollbacker', 'patroller', 'autopatrolled', ), // Bug 44285, 55665
	),
	'+eswiktionary' => array(
		'bureaucrat' => array( 'autopatrolled', 'patroller', 'rollbacker' ),
	),
	'+enwiktionary' => array(
		'bureaucrat' => array( 'sysop' ), // bureaucrat removed per bug 42113
		'sysop' => array( 'autopatrolled', 'patroller', 'rollbacker', 'flood' ),
	),
	'+fawiki' => array(
		'bureaucrat' => array( 'patroller', 'Image-reviewer', 'botadmin', 'OTRS-member' ), // bug 64532, 69411 and 54368
		'sysop' => array( 'rollbacker', 'autopatrol', 'uploader' ), // bug 23233, 29007 and 69171
		'botadmin' => array( 'patroller', 'Image-reviewer', 'rollbacker', 'autopatrol', 'uploader' ), // bug 69411
	),
	'+fawikinews' => array(
		'sysop' => array( 'rollbacker', 'patroller', ),
	),
	'+fawikivoyage' => array(
		'sysop' => array(
			'autopatrolled', // bug 71760
			'confirmed', // bug 71760
			'flood', // bug 71760
			'patroller', // bug 71760
			'rollbacker', // bug 71760
			'transwiki', // bug 71681
		),
	),
	'+fiwiki' => array(
		'bureaucrat' => array( 'sysop', 'bureaucrat', 'arbcom' ),
		'sysop' => array( 'rollbacker', ),
	),
	'+fiwikimedia' => array(
		'bureaucrat' => array( 'sysop', 'bureaucrat' ),
	),
	'+foundationwiki' => array(
		'sysop' => array( 'inactive', 'confirmed', 'flood' ),
		'bureaucrat' => array( 'sysop', 'bureaucrat', 'import', 'transwiki', 'inactive', 'confirmed', 'petitiondata' ),
	),
	'+frwiki' => array(
		'bureaucrat' => array( 'abusefilter', 'sysop', 'accountcreator' ),
	),
	'+frwikibooks' => array(
		'bureaucrat' => array( 'abusefilter' ),
		'sysop' => array( 'patroller' ),
	),
	'+frwikisource' => array(
		'sysop' => array( 'patroller', 'autopatrolled' ),
	),
	'+frwikiversity' => array(
		'sysop' => array( 'patroller' ),
	),
	'+frwikivoyage' => array(
		'sysop' => array( 'patroller' ),
	),
	'+frwiktionary' => array(
		'bureaucrat' => array( 'accountcreator', 'patroller', 'transwiki', 'autopatrolled', 'confirmed', 'abusefilter', 'botadmin' ),
	),
	'+gawiki' => array(
		'sysop' => array( 'rollbacker' ),
	),
	'+hewiki' => array(
		'sysop' => array( 'patroller', 'autopatrolled', 'accountcreator' ),
		'bureaucrat' => array( 'editinterface' ),
	),
	'+hewikibooks' => array(
		'sysop' => array( 'patroller', 'autopatrolled' ),
	),
	'+hewikiquote' => array(
		'sysop' => array( 'autopatrolled' ),
	),
	'+hewikivoyage' => array(
		'sysop' => array( 'autopatrolled' ), // bug 50377
	),
	'+hiwiki' => array(
		'sysop' => array( 'abusefilter', 'autopatrolled', 'reviewer', 'rollbacker', 'filemover' ),
	),
	'+hiwiktionary' => array(
			'bureaucrat' => array( 'sysop', ),
	),
	'+hrwiki' => array(
		'bureaucrat' => array( 'patroller', 'autopatrolled' ),
		'sysop' => array( 'patroller', 'autopatrolled' ),
	),
	'+huwiki' => array(
		'bureaucrat' => array( 'confirmed' ),
	),
	'+idwiki' => array(
		'sysop' => array( 'rollbacker' ),
		'bureaucrat' => array( 'rollbacker' ),
	),
	'+incubatorwiki' => array(
		'bureaucrat' => array( 'test-sysop', 'translator', 'import', 'translationadmin' ),
	),
	'+itwiki' => array(
		'bureaucrat' => array( 'rollbacker', 'autopatrolled', 'filemover' ), // bug 53913
		'sysop' => array( 'accountcreator', 'flood', ), // bug 61109
	),
	'+itwikibooks' => array(
		'sysop' => array( 'autopatrolled', 'patroller', 'flooder' ), // Flooder added per bug 39569
	),
	'+itwikiquote' => array(
		'bureaucrat' => array( 'autopatrolled' ),
	),
	'+itwikisource' => array(
		'bureaucrat' => array( 'flood' ), // Bug 36600
	),
	'+itwikivoyage' => array(
		'sysop' => array ( 'autopatrolled', 'patroller' ),    // Bug 43327 and 45638
	),
	'+itwiktionary' => array(
		'sysop' => array( 'patroller', 'autopatrolled', 'flood' ), // Flood added per bug 39306
	),
	'+jawiki' => array(
		'sysop' => array( 'abusefilter' ),
		'bureaucrat' => array( 'rollbacker', 'eliminator', 'interface_editor' ),
	),
	'+jawiktionary' => array(
		'sysop' => array( 'autopatrolled' ), // bug 61366
	),
	'+kawiki' => array(
		'sysop' => array( 'trusted' ),
	),
	'+kowiki' => array(
		'sysop' => array( 'rollbacker', 'confirmed' ),
	),
	'+legalteamwiki' => array( // bug 61222
		'bureaucrat' => array( 'sysop', 'accountcreator', 'import', 'transwiki', 'ipblock-exempt', 'bureaucrat', 'translationadmin' ),
	),
	'+ltwiki' => array(
		'sysop' => array ( 'abusefilter' ),
	),
	'+ltwiktionary' => array(
		'sysop' => array( 'abusefilter' ),
	),
	'+lvwiki' => array(
		'sysop' => array( 'autopatrolled', 'patroller' ), //Bug 70441
	),
	'+mediawikiwiki' => array(
		'sysop' => array( 'autoreview' ),
		'bureaucrat' => array( 'autoreview', 'transwiki', 'import', 'coder', 'svnadmins', 'translationadmin' ),
	),
	'+metawiki' => array(
		'bureaucrat' => array( 'sysop', 'bureaucrat', 'ipblock-exempt', 'flood', 'translationadmin', 'centralnoticeadmin', 'uploader' ), // bug 37198, 50287
		'checkuser'  => array( 'ipblock-exempt' ),
		'sysop'      => array( 'autopatrolled', 'massmessage-sender' ), // bug 57611
	),
	'+mkwiki' => array(
		'bureaucrat' => array( 'patroller', 'autopatrolled', 'autoreviewed' ),
	),
	'+mlwiki' => array(
		'sysop' => array( 'patroller', 'autopatrolled', 'rollbacker' ),
		'bureaucrat' => array( 'botadmin' ),
	),
	'+mlwikisource' => array(
		'sysop' => array( 'patroller', 'autopatrolled' ),
		'bureaucrat' => array( 'botadmin' ),
	),
	'+mlwiktionary' => array(
		'bureaucrat' => array( 'botadmin' ),
	),
	'+nlwiki' => array(
		'bureaucrat' => array( 'abusefilter', 'arbcom', 'rollbacker' ),
	),
	'+nlwikibooks' => array(
		'sysop' => array( 'abusefilter' ),
	),
	'+nlwikivoyage' => array(
		'bureaucrat' => array( 'autopatrolled' ), // bug 44082
	),
	'+nnwiki' => array(
		'bureaucrat' => array( 'autopatrolled', 'patroller' ),
		'sysop' => array( 'autopatrolled' ),
	),
	'+noboard_chapterswikimedia' => array(
		'bureaucrat' => array( 'sysop', 'bureaucrat', 'import', 'transwiki' ),
	),
	'+nowiki' => array(
		'bureaucrat' => array( 'patroller', 'autopatrolled', 'transwiki', 'accountcreator' ),
		'sysop' => array( 'autopatrolled', 'abusefilter' ),
	),
	'+nowikibooks' => array(
		'bureaucrat' => array( 'bot', 'patroller', 'autopatrolled' ),
		'sysop' => array( 'autopatrolled', 'patroller' ),
	),
	'+officewiki' => array(
		'bureaucrat' => array( 'sysop', 'bureaucrat', 'import', 'transwiki', 'communityapps' ),
	),
	'+ombudsmenwiki' => array(
		'bureaucrat' => array( 'sysop', 'accountcreator', 'import', 'transwiki', 'user', 'autoconfirmed', 'ipblock-exempt',  'bureaucrat', ),
	),
	'+orwiki' => array(
		'sysop' => array( 'rollbacker' ),
	),
	'+otrs_wikiwiki' => array(
		'bureaucrat' => array( 'sysop', 'bureaucrat', 'import', 'transwiki', 'translationadmin' ), // bug 61297
	),
	'+outreachwiki' => array(
		'bureaucrat' => array(
			'sysop', 'bureaucrat', 'autopatrolled', 'import',
			'translationadmin', // bug 54207
		),
	),
	'+ptwiki' => array(
		'bureaucrat' => array( 'eliminator', 'confirmed', 'autoreviewer', 'interface_editor', 'accountcreator' ), // bug 39905, 63750
		'sysop' => array( 'rollbacker', 'autoreviewer', 'confirmed', 'accountcreator' ), // bug 63750
	),
	'+ptwikinews' => array(
		'sysop' => array( 'reviewer' ),
	),
	'+ptwikivoyage' => array(
		'sysop' => array( 'bot' ), // Bug 45233
	),
	'+quwiki' => array(
		'sysop' => array( 'rollbacker' ),
	),
	'+rowiki' => array(
		'bureaucrat' => array( 'abusefilter', 'patroller' ), // bug 26634
		'sysop' => array( 'autopatrolled', 'templateeditor' ), // bug 61172
	),
	'+ruwiki' => array(
		'bureaucrat' => array( 'sysop', 'arbcom' ), // bug 49334
		'sysop' => array( 'rollbacker', 'autoeditor', 'uploader', 'closer', 'filemover', 'suppressredirect' ),
	),
	'+ruwikiquote' => array(
		'sysop' => array( 'autoeditor' )
	),
	'+ruwikisource' => array(
		'bureaucrat' => array( 'sysop', 'bureaucrat', 'autoeditor', 'rollbacker' ),
		'sysop' => array( 'autoeditor', 'rollbacker', 'abusefilter', 'flood' ),
	),
	'+ruwikivoyage' => array(
		'sysop' => array( 'autopatrolled' ), // bug 46915
	),
	'+sawiki' => array(
		'sysop' => array( 'autopatrolled' ),
	),
	'+sawikisource' => array(
		'sysop' => array( 'autopatrolled' ),
	),
	'+scowiki' => array(
		'sysop' => array( 'rollbacker', 'autopatrolled', )
	),
	'+sewikimedia' => array(
		'bureaucrat' => array( 'sysop', 'bureaucrat', 'medlem' ),
	),
	'+shwiki' => array(
		'bureaucrat' => array(
			'autopatrolled', 'filemover', 'patroller', 'rollbacker', // bug 50802
			'flood', // bug 52273
		),
		'sysop' => array(
			'filemover', 'patroller', 'rollbacker', // bug 50802
			'flood', // bug 52273
		),
	),
	'+shwiktionary' => array(
		'sysop' => array( 'autopatrolled' ),
		'bureaucrat' => array( 'autopatrolled' ),
	),
	'+siwiki' => array(
		'sysop' => array( 'rollbacker', 'accountcreator', 'abusefilter', 'autopatrolled', 'confirmed', 'reviewer', ),
	),
	'+simplewiki' => array(
		'bureaucrat' => array( 'flood', 'rollbacker', 'sysop', 'import', 'transwiki', 'patroller' ),
		'sysop' => array( 'rollbacker', 'flood', 'patroller' ),
	),
	'+simplewiktionary' => array(
		'bureaucrat' => array( 'sysop' ),
		'sysop' => array( 'rollbacker', 'autopatrolled' ),
	),
	'+skwiki' => array(
		'sysop' => array( 'rollbacker' ),
	),
	'+stewardwiki' => array(
		'bureaucrat' => array( 'bureaucrat', 'sysop', 'import', 'transwiki', 'user', 'ipblock-exempt' ),
	),
	'+sqwiki' => array(
		'bureaucrat' => array( 'editor' ),
		'sysop' => array( 'reviewer' ),
	),
	'+srwiki' => array(
		'bureaucrat' => array( 'patroller', 'rollbacker', 'autopatrolled', 'flood' ),
		'sysop' => array( 'rollbacker', ),
	),
	'+srwikisource' => array(
		'bureaucrat' => array( 'patroller', 'autopatrolled' ),
	),
	'+strategywiki' => array(
		'bureaucrat' => array( 'flood' ),
	),
	'+svwiki' => array(
		'bureaucrat' => array( 'accountcreator' ), // bug 54922
		'sysop' => array( 'rollbacker', ),
	),
	'+svwikisource' => array(
		'sysop' => array( 'autopatrolled', ),
	),
	'+tawiki' => array(
		'bureaucrat' => array( 'nocreate' ),
	),
	'+trwiki' => array(
		'sysop' => array( 'patroller' ), // bureaucrat -> sysop, Bug 38690
		'bureaucrat' => array( 'technician' ), // Bug 39690
	),
	'+ukwiki' => array(
		'sysop' => array( 'patroller', 'rollbacker' ),
	),
	'+ukwikimedia' => array(
		'bureaucrat' => array( 'sysop' ),
	),
	'+ukwikivoyage' => array(
		'sysop' => array( 'rollbacker', 'uploader', 'autopatrolled' ), // bug 54229
	),
	'+ukwiktionary' => array(
		'bureaucrat' => array( 'autoeditor' ),
		'sysop' => array( 'autoeditor' ),
	),
	'+urwiki' => array(
		'bureaucrat' => array( 'import', 'confirmed', 'abusefilter', 'rollbacker' ), // Bug 42737 and 45643
		'sysop' => array( 'confirmed' ), // Bug 42737
	),
	'+viwiki' => array(
		'sysop' => array(
			'rollbacker',
			'flood',
			'patroller', // bug 46828
			'autopatrolled' // bug 46828
		),
		'bureaucrat' => array(
			'eliminator', // bug 68612
			'flood'
		),
	),
	'+vecwiki' => array(
		'sysop' => array( 'flood' ),
	),
	'+vewikimedia' => array(
		'bureaucrat' => array( 'sysop', 'bureaucrat' ),
	),
	'+wikidata' => array(
		'sysop' => array(
			'rollbacker', // bug 45165
			'confirmed', // bug 45124
			'propertycreator', // bug 46953
		),
		'bureaucrat' => array(
			'translationadmin', // bug 44395
			'flood', // bug 48013
		),
	),
	'+wikimania2013wiki' => array(
		'bureaucrat' => array( 'translationadmin' )
	),
	'+wikimania2014wiki' => array(
		'bureaucrat' => array( 'sysop', 'bureaucrat', 'translationadmin' ), // bug 55480
	),
	'+wikimania2015wiki' => array(
		'bureaucrat' => array( 'translationadmin' ),
	),
	'+wikimaniateamwiki' => array(
		'bureaucrat' => array( 'sysop', 'bureaucrat', 'autopatrolled', 'import' ),
	),
	'zerowiki' => array(
		'sysop' => true,
	),
	'+zhwiki' => array(
		'bureaucrat' => array( 'flood' ),
		'sysop' => array( 'patroller', 'rollbacker', 'autoreviewer', 'confirmed', 'flood' ),
	),
	'+zhwikinews' => array(
		'sysop' => array(
			'rollbacker',
			'flood', // bug 52546
		),
	),
	'+zhwikivoyage' => array(
		'sysop' => array( 'autopatrolled', 'confirmed', 'patroller', 'transwiki' ), // bug 60085, 60328
	),
	'+zh_yuewiki' => array(
		'sysop' => array( 'abusefilter', 'rollbacker', 'autoreviewer', 'confirmed' ),
	),
	'+plwiki' => array(
		'bureaucrat' => array( 'abusefilter', 'flood' ),
	),
	'+plwikiquote' => array(
	'sysop' => array( 'patroller' ), // http://bugzilla.wikimedia.org/show_bug.cgi?id=28479
	),
	'+private' => array(	// Cary	made me	do it! --Andrew	2009-05-01
		'bureaucrat' =>	array( 'inactive' ),
	),

),
# @} end of wgRemoveGroups

# wgImportSources @{
'wgImportSources' => array(
	// Generic project entries

	// Note: When adding a specific wiki you have to duplicate these generic sources
	// otherwise they would be overwritten by the specific wiki entry
	'wikisource' => array( 'meta', 'commons' ),
	'wikiversity' => array( 'meta', 'b', 'incubator' ),

	// Specific wikis

	// chapter wikis
	'bewikimedia' => array( 'meta' ),
	'brwikimedia' => array( 'wikipedia:pt', 'meta', 'wiktionary:pt', 'wikisource:pt', 'wikinews:pt', 'wikiquote:pt', 'wikibooks:pt', 'wikiversity:pt', 'commons' ),
	'cowikimedia' => array( 'meta', 'wikipedia:es', 'wikibooks:es', 'wikiversity:es' ),
	'etwikimedia' => array( 'wikipedia:et', 'meta' ),
	'fiwikimedia' => array( 'wikipedia:fi', 'meta' ),
	'mkwikimedia' => array( 'meta', 'wikipedia:mk'  ),
	'mxwikimedia' => array( 'meta', 'wikipedia:es', 'wikibooks:es', 'wikiversity:es', 'wikipedia:en', ),
	'nowikimedia' => array( 'meta', 'wikipedia:no', 'wikipedia:nn', 'wikipedia:se' ),
	'nycwikimedia' => array( 'wikipedia:en', 'meta' ),
	'plwikimedia' => array( 'b', 'n', 'q', 's', 'voy', 'w', 'wikt', ), // bug 65908
	'ruwikimedia' => array( 'meta', 'foundation', 'wikipedia:ru', ),
	'sewikimedia' => array( 'wikipedia:sv' ),
	'trwikimedia' => array( 'wikipedia:tr', 'meta' ),
	'ukwikimedia' => array( 'meta' ),

	// content wikis
	'alswiki'   => array( 'de', 'wikt', 'b', 'q', 'en', 'fr', 'it', 'b:de' ),
	'alswikibooks' => array( 'b:de', 'w' ),
	'arbcom_enwiki' => array( 'meta', 'w' ),
	'arbcom_dewiki' => array( 'w', 'w:de', ),
	'arwiki' => array( 'meta' ),
	'arwikibooks' => array( 'w' ),
	'arwikinews' => array( 'w' ),
	'arwikisource' => array( 'w' ),
	'arwikiversity' => array( 'w', 'b', 'n', 'q', 's', 'wikt' ),
	'arzwiki' => array( 'incubator', 'en', 'ar', 'es', 'fr', ),
	'betawikiversity' => array( 'meta', 'b', 'en', 'incubator', 'de', 'wikipedia:lt' ),
	'bhwiki' => array( 'commons', 'meta', 'species', 'de', 'en', 'wikibooks:en', 'wikiquote:en', 'wikinews:en', 'wikisource:en', 'wikiversity:en', 'es', 'fa', 'fr', 'hi', 'ml', 'ne', 'nl', 'ro', 'ru', 'pl', 'pt', 'simple', 'ta', 'ur' ),
	'bnwiki' => array( 'en' ), # Bug 34791
	'bnwikisource' => array( 'OldWikisource', 'w', 'en' ),
	'cawikibooks' => array( 'w', 's', ),
	'cawikinews' => array( 'w', 'wikt', 'q', 'b', 's', 'v', 'fr', 'en', 'de', 'es', 'pt', 'it', 'commons', 'meta', 'eo' ),
	'cawikiquote' =>  array( 'w' ),
	'cawikisource' => array( 'w', 'b', ),
	'cawiktionary' => array( 'w', ),
	'chywiki' => array( 'en', 'fr', ),
	'ckbwiki' => array( 'fa', 'ar', 'ku', 'en', 'de', 'fr', 'it', 'es', 'ru', 'pt', ), // bug 52633
	'commonswiki' => array( 'meta', 'w:en', 'w:de', 'w:fr', 'w:pl', 'w:ja', 'w:es', 'w:nl', 'w:ru', 'w:sv', 'w:ja', 'w:it', 'w:pt', 'w:zh', 'wikibooks:en', 'mediawikiwiki', 'foundation', 'wikidata'), // bug 54001
	'crhwiki' => array( 'incubator' ),
	'crwiki' => array( 'en', 'fr'  ),
	'cswiki' => array( 'b', 'meta', 'n', 'q', 's', 'v', 'wikt' ),
	'cswikibooks'    => array( 'n', 'q', 's', 'v', 'w', 'wikt' ),
	'cswikinews'     => array( 'b', 'q', 's', 'v', 'w', 'wikt', 'incubator' ),
	'cswikiquote'    => array( 'b', 'n', 's', 'v', 'w', 'wikt' ),
	'cswikisource'   => array( 'b', 'n', 'q', 'v', 'w', 'wikt', 'oldwikisource' ),
	'cswikiversity'  => array( 'b', 'n', 'q', 's', 'w', 'wikt', 'betawikiversity' ),
	'cswiktionary'   => array( 'b', 'n', 'q', 's', 'v', 'w' ),
	'donatewiki' => array( 'meta', 'foundation' ),
	'dewiki' => array( 'w', 'wikt', 'da', 'el', 'en', 'es', 'fr', 'hu', 'it', 'ja', 'nl', 'no', 'pl', 'pt', 'ru', 'sv', 'tr', 'uk', 'zh' ),
	'dewikibooks' => array( 'w', 'wikipedia', 'en', 'v' ),
	'dewikiquote' => array( 'w', 'wikt', 's', 'b', 'v', 'en', 'la', ),
	'dewikisource' => array( 'b', 'commons', 'en', 'fr', 'la', 'meta', 'oldwikisource', 'q', 'v', 'w', 'wikt' ), // bug 56384
	'dewikiversity' => array( 'w', 'meta', 'b', 'incubator' ), // bug 38159
	'dewiktionary' => array( 'w', 'en' ),
	'dewikivoyage' => array( 'w', 'en', 'meta' ),
	'dsbwiki' => array( 'incubator', ),
	'elwiki' => array( 'en', 'de', 'v', 's', 'wikt', 'b', 'q', 'fr', 'meta', 'commons', 'it',  ),
	'elwikibooks' => array( 'en', 'w:en', 'w', 'v', 'q', 's', 'meta', 'wikt' ),
	'elwikisource' => array( 'w', 'v' ),
	'elwikiversity' => array( 'w', 'wikt', 'b', 'q', 's', 'betawikiversity', 'en', 'fr', 'de', 'es', 'it', 'w:fr', 'w:de', 'fi', 'commons', 'w:en' ),
	'elwiktionary' => array( 'w', 'en', 'fr' ),
	'enwiki' => array( 'meta', 'nost', 'de', 'es', 'fr', 'it', 'pl', 'outreachwiki', 'test2wiki' ),
	'enwiktionary' => array(
		'w', 'b', 's', 'q', 'v', 'n', 'commons', 'aa', 'ab', 'af', 'ak', 'als', 'am', 'an', 'ang', 'ar', 'as', 'ast', 'av', 'ay', 'az', 'ba', 'be', 'bg', 'bh', 'bi', 'bm', 'bn', 'bo', 'br', 'bs',
		'ca', 'ch', 'chr', 'co', 'cr', 'cs', 'csb', 'cy', 'da', 'de', 'dv', 'dz', 'el', 'eo', 'es', 'et', 'eu', 'fa', 'fi', 'fj', 'fo', 'fr', 'fy', 'ga', 'gd', 'gl', 'gn', 'gu', 'gv', 'ha', 'he',
		'hi', 'hr', 'hsb', 'hu', 'hy', 'ia', 'id', 'ie', 'ik', 'io', 'is', 'it', 'iu', 'ja', 'jbo', 'jv', 'ka', 'kk', 'kl', 'km', 'kn', 'ko', 'ks', 'ku', 'kw', 'ky', 'la', 'lb', 'li', 'ln', 'lo', 'lt', 'lv',
		'mg', 'mh', 'mi', 'mk', 'ml', 'mn', 'mo', 'mr', 'ms', 'mt', 'my', 'na', 'nah', 'nds', 'ne', 'nl', 'nn', 'no', 'oc', 'om', 'or', 'pa', 'pi', 'pl', 'ps', 'pt', 'qu', 'rm', 'rn', 'ro',
		'roa-rup', 'ru', 'rw', 'sa', 'sc', 'scn', 'sd', 'sg', 'sh', 'si', 'simple', 'sk', 'sl', 'sm', 'sn', 'so', 'sq', 'sr', 'ss', 'st', 'su', 'sv', 'sw', 'ta', 'te', 'tg', 'th', 'ti', 'tk', 'tl', 'tn', 'to',
		'tpi', 'tr', 'ts', 'tt', 'tw', 'ug', 'uk', 'ur', 'uz', 'vi', 'vo', 'wa', 'wo', 'xh', 'yi', 'yo', 'za', 'zh', 'zh-min-nan', 'zu'
	),
	'enwikisource' => array( 'w', 'OldWikisource', 'b', 'commons', 'q', ),
	'enwikibooks' => array( 'w', 's', 'q', 'v', 'wikt', 'n', 'meta', 'simple', 'species' ),
	'enwikiversity' => array( 'betawikiversity', 'w', 'b', 'q', 's' ),
	'enwikivoyage' => array( 'b', 'meta', 'w' ), // Bug 63095
	'eowikisource' => array( 'meta', 'commons', 'b:eo' ), // Bug 43659
	'eswiki' => array( 'b', 'q', 'v', 'wikt', 'n', 's', 'en' ),
	'eswikibooks' => array( 'w', 'w:en', 'en', 'meta' ),
	'eswikinews' => array( 'w' ), // Bug 70414
	'eswikiquote' => array( 'en', 'b', 'm', 'mw', 'n', 's', 'v', 'voy', 'w', 'wikt' ), // bug 62912
	'eswikiversity' => array( 'w:es', 'b', 'meta' ),
	'eswikivoyage' => array( 'w', 'meta', 'commons', 'en', 'de', 'fr', 'it', 'nl', 'pt', 'ru', 'sv' ), // Bug 43863
	'eswiktionary' => array( 'w', 'w:en', 'w:fr', 'w:de', 'en', 'fr', 'de', ), # Bug 8202
	'etwiki' => array( 'b', 'q', 's', 'wikt' ),
	'etwikisource' => array( 'w' ),
	'etwiktionary' => array( 'w' ),
	'extwiki' => array( 'incubator' ),
	'fawikivoyage' => array( 'w', 'w:en', 'en' ), // Bug 71681
	'fdcwiki' => array( 'meta' ),
	'fiwikisource' => array( 'OldWikisource', 'w', 'b' ),
	'fiwikiversity' => array( 'b', 'q', 'n', 's', 'wikt', 'w', 'betawikiversity' ),
	'foundationwiki' => array( 'meta' ),
	'frrwiki' => array( 'en', 'de', 'nds', 's:de', 'oldwikisource' ), # s:de and oldwikisource per bug 38023
	'frwiki' => array(
		'meta', 'commons', 'species', 'q', 'af', 'ak', 'ar', 'ang', 'ast', 'gn', 'id', 'zhminnan', 'bg', 'br', 'ca', 'cs', 'co', 'da', 'de', 'et', 'el', 'en', 'es', 'eo', 'fa', 'fy', 'ga', 'gl', 'gu', 'hy',
		'hi', 'he', 'hsb', 'hr', 'io', 'ia', 'ie', 'is', 'it', 'kk', 'csb', 'sw', 'ko', 'ku', 'la', 'lt', 'li', 'lo', 'hu', 'ml', 'nl', 'ja', 'no', 'oc', 'nds', 'pl', 'pt', 'ro', 'ru', 'scn', 'simple', 'sk',
		'sl', 'sq', 'st', 'sr', 'fi', 'sv', 'ta', 'te', 'vi', 'th', 'tt', 'tr', 'uk', 'ur', 'vo', 'zh', 'w', 'n', 's', 'wikt', 'v',
	), # Bug 28024 and bug 22663 --pdhanda
	'frwikisource' => array(
		'meta', 'commons', 'species', 'q', 'b', 'af', 'ak', 'ar', 'ang', 'ast', 'gn', 'id', 'zhminnan', 'bg', 'br', 'ca', 'cs', 'co', 'da', 'de', 'et', 'el', 'en', 'es', 'eo', 'fa', 'fy', 'ga', 'gl', 'gu', 'hy', 'hi',
		'he', 'hsb', 'hr', 'io', 'ia', 'ie', 'is', 'it', 'kk', 'csb', 'sw', 'ko', 'ku', 'la', 'lt', 'li', 'lo', 'hu', 'ml', 'nl', 'ja', 'no', 'oc', 'nds', 'pl', 'pt', 'ro', 'ru', 'scn', 'simple', 'sk', 'sl', 'sq',
		'st', 'sr', 'fi', 'sv', 'ta', 'te', 'vi', 'th', 'tt', 'tr', 'uk', 'ur', 'vo', 'zh', 'w', 'n', 's', 'wikt', 'v',
	), # Bug 28024 and bug 22663 --pdhanda
	'frwikibooks' => array(
		'meta', 'commons', 'species', 'q', 'af', 'ak', 'ar', 'ang', 'ast', 'gn', 'id', 'zhminnan', 'bg', 'br', 'ca', 'cs', 'co', 'da', 'de', 'et', 'el', 'en', 'es', 'eo', 'fa', 'fy', 'ga', 'gl', 'gu',
		'hy', 'hi', 'he', 'hsb', 'hr', 'io', 'ia', 'ie', 'is', 'it', 'kk', 'csb', 'sw', 'ko', 'ku', 'la', 'lt', 'li', 'lo', 'hu', 'ml', 'nl', 'ja', 'no', 'oc', 'nds', 'pl', 'pt', 'ro', 'ru', 'scn', 'simple',
		'sk', 'sl', 'sq', 'st', 'sr', 'fi', 'sv', 'ta', 'te', 'vi', 'th', 'tt', 'tr', 'uk', 'ur', 'vo', 'zh', 'w', 'n', 's', 'wikt', 'v',
	),  # Bug 28024 and bug 22663 --pdhanda
	'frwikinews' => array( 'w', 'en', 'de', 'es', 'it', 'b', 'wikt', 'v', 's', 'q', 'ca', 'pt', 'species', 'commons', 'meta', 'w:pl', 'pl' ),
	'frwikiquote' => array( 'w', 'wikt', 's', 'b', 'n', 'v', 'meta', 'en' ),
	'frwikiversity' => array(
		'meta', 'commons', 'species', 'q', 'af', 'ak', 'ar', 'ang', 'ast', 'gn', 'id', 'zhminnan', 'bg', 'br', 'ca', 'cs', 'co', 'da', 'de', 'et', 'el', 'en', 'es', 'eo', 'fa', 'fy', 'ga', 'gl', 'gu', 'hy',
		'hi', 'he', 'hsb', 'hr', 'io', 'ia', 'ie', 'is', 'it', 'kk', 'csb', 'sw', 'ko', 'ku', 'la', 'lt', 'li', 'lo', 'hu', 'ml', 'nl', 'ja', 'no', 'oc', 'nds', 'pl', 'pt', 'ro', 'ru', 'scn', 'simple', 'sk',
		'sl', 'sq', 'st', 'sr', 'fi', 'sv', 'ta', 'te', 'vi', 'th', 'tt', 'tr', 'uk', 'ur', 'vo', 'zh', 'w', 'n', 's', 'wikt', 'b',
	),  # Bug 28024 and bug 22663 --pdhanda
	'frwikivoyage' => array( 'w', 'meta', 'de', 'el', 'en', 'es', 'he', 'it', 'nl', 'pl', 'pt', 'ro', 'ru', 'sv', 'uk', 'vi' ), // bug 55745
	'frwiktionary' => array(
		'meta', 'commons', 'species', 'q', 'af', 'ak', 'ar', 'ang', 'ast', 'gn', 'id', 'zhminnan', 'bg', 'br', 'ca', 'cs', 'co', 'da', 'de', 'et', 'el', 'en', 'es', 'eo', 'fa', 'fy', 'ga', 'gl', 'gu', 'hy', 'hi',
		'he', 'hsb', 'hr', 'io', 'ia', 'ie', 'is', 'it', 'kk', 'csb', 'sw', 'ko', 'ku', 'la', 'lt', 'li', 'lo', 'hu', 'ml', 'nl', 'ja', 'no', 'oc', 'nds', 'pl', 'pt', 'ro', 'ru', 'scn', 'simple', 'sk', 'sl', 'sq',
		'st', 'sr', 'fi', 'sv', 'ta', 'te', 'vi', 'th', 'tt', 'tr', 'uk', 'ur', 'vo', 'zh', 'w', 'n', 's', 'b', 'v',
	),  # Bug 28024 and bug 22663 --pdhanda
	'ganwiki' => array( 'incubator' ),
	'gdwiki' => array( 'en', 'de', 'ga', 'gv' ),
	'glwiktionary' => array( 'w', 's', 'q', 'b' ),
	'glwikibooks' => array( 'w', 'wikt', 's', 'q' ),
	'glwikisource' => array( 'w', 'wikt', 'q', 'b' ),
	'glwikiquote' => array( 'w', 'wikt', 's', 'b' ),
	'glwiki' => array( 'wikt', 's', 'q', 'b' ),
	'guwiki' => array( 'en' ), // Bug 37511
	'hakwiki' => array( 'incubator' ),
	'hewiki' => array( 'wikt', 'q', 'b', 's', 'n', 'commons' ),
	'hewikibooks' => array( 'w', 'wikt', 'q', 's', 'n' ),
	'hewikinews' => array( 'w', 'wikt', 'q', 'b', 's' ),
	'hewikiquote' => array( 'w', 'wikt', 'b', 's', 'n' ),
	'hewiktionary' => array( 'w', 'q', 'b', 's', 'n' ),
	'hewikisource' => array( 'w', 'wikt', 'q', 'b', 'n' ),
	'hewikivoyage' => array( 'w', 'wikt', 'b', 'n', 'q', 's', 'commons', 'en', 'de', 'el', 'fr', 'it', 'nl', 'pl', 'pt', 'ro', 'ru', 'sv', 'uk', 'vi' ), // bug 58527, 59601
	'hiwiki' => array( 'wikt', 'commons', 'meta', 'species', 'de', 'en', 'en:b', 'en:q', 'en:n', 'en:s', 'en:v', 'es', 'fr', 'ml', 'ne', 'nl', 'ro', 'ru', 'pl', 'pt', 'simple', 'ta' ), // bug 41757
	'hifwiki' => array( 'incubator' ),
	'hsbwiktionary' => array( 'incubator', 'w' ),
	'huwikinews' => array( 'incubator' ),
	'idwiki' => array( 'ms' ), // bug 16033
	'idwikibooks' => array( 'w' ),
	'idwikiquote' => array( 'w' ),
	'idwikisource' => array( 'w' ),
	'idwiktionary' => array( 'w' ),
	'incubatorwiki' => array( 'meta', 'commons', 'w', 'w:de', 'w:fr', 'w:es', 'w:pt', 'w:nl', 'w:ru', 'wikt:en', 'b:en',  ),
	'iswiki' => array( 'en', 'da', 'no', 'de' ),
	'iswiktionary' => array( 'w' ),
	'itwiki' => array( 'b', 'q', 's', 'wikt', 'n', 'v', 'de', 'es', 'en', 'fr', 'meta' ),
	'itwikibooks' => array( 'w', 'wikt', 's', 'q', 'n', 'v', 'en' ),
	'itwikinews' => array( 'w', 'wikt', 'b', 's', 'q', 'v', 'w:en', 'commons', 'en' ),
	'itwikiquote' => array( 'w', 'wikt', 's', 'b', 'n', 'v' ),
	'itwikisource' => array( 'w', 'b', 'wikt', 'q', 'n', 'v' ),
	'itwikiversity' => array( 'w', 'b', 'wikt', 's', 'q', 'n' ),
	'itwikivoyage' => array ( 'w', 'q', 's', 'n', 'wikt', 'b', 'v', 'species',
		'commons', 'd', 'mw', 'meta', 'foundation', 'w:ca',
		'w:de', 'w:en', 'w:es', 'w:fr', 'w:he', 'w:hu',
		'w:nl', 'w:pl', 'w:pt', 'w:ru', 's:fr', 'n:en',
		'wikt:en', 'de', 'en', 'es', 'fr', 'nl', 'ru', 'sv', 'el'
	), // Bug 43310
	'itwiktionary' => array( 'w', 'b', 's', 'q', 'n', 'v', 'en', 'fr', 'sc' ),
	'jawikibooks' => array( 'w', 'wikt', 'q', 's', 'v', 'en' ),
	'jawikiversity' => array( 'betawikiversity', 'w', 'wikt', 'en', 'b', 'q', 's', 'n' ),
	'jawiktionary' => array( 'w' ),
	'kaawiki' => array( 'incubator' ),
	//'khmwiktionary' => array( 'en', 'fr', 'lm', 'th' ),
	'kmwiki' => array( 'en', 'be', 'simple' ),
	'knwiki' => array( 'en' ),
	'kowikiquote' => array( 'w' ),
	'labswiki' => array( 'mw' ),
	'lawikibooks' => array( 'w' ),
	'lawikisource' => array( 'ca', 'de', 'el', 'en', 'es', 'fr', 'it', 'pt', 'ro', 'w', 'b', 'oldwikisource' ),
	'lbwiktionary' => array( 'w:fr', 'fr', 'w:en', 'en', 'w', 'meta' ),
	'legalteamwiki' => array( 'meta' ),
	'liwikinews' => array( 'incubator' ),
	'lmowiki' => array( 'ca', 'en', 'fr' ), # bug 8319
	'mdfwiki' => array( 'incubator' ),
	'mediawikiwiki' => array( 'meta', 'w:en', 'usability' ),
	'metawiki' => array( 'commons', 'foundation', 'w', 'cs', 'fr', 'strategy' ),
	'mgwiktionary' => array( 'fr', 'io', 'en', 'w', ),
	'mlwiki' => array( 'en' ),
	'mlwikibooks' => array( 'w', 'en' ), // bug 50156
	'mlwikisource' => array( 'w', 'en', 'w:en', ),
	'mlwikiquote' => array( 'en', 'w:en', 'w' ),
	'mswiki' => array( 'id' ), # bug 16033
	'mswiktionary' => array( 'w' ),
	'myvwiki' => array( 'incubator' ),
	'ndswiki' => array( 'en', 'de', 'nl', 'nds-nl', 'wikt'  ),
	'nlwikibooks' => array( 'w' ),
	'nlwikisource' => array( 'w', 'wikt', 'q', 'b', 'n', 'nl', 'de', 'en' ),
	'nlwiktionary' => array( 'w', 'en', 'fr' ),
	'nowiki' => array( 's', 'q', 'nn', 'da', 'sv', 'nl', 'en', 'de' ),
	'nowikibooks' => array( 'sv', 'da', 'en', 'w', 'w:nn', 'w:sv', 'w:da', 'w:en' ),
	'nowikinews' => array( 'sv' ),
	'nowikiquote' => array( 'w', 'en', 'nn' ),
	'nowikisource' => array( 'w' ),
	'nowiktionary' => array( 'w' ),
	'orwiki' => array( 'en', 'commons' ),
	'otrs_wikiwiki' => array( 'meta' ),
	'outreachwiki'  => array( 'w:en', 'w:de', 'w:fr', 'w:pl', 'w:it', 'w:ja', 'w:es', 'w:nl', 'w:pt', 'w:ru', 'w:sv', 'commons', 'foundation', 'm', ),
	'pflwiki' => array( 'de', 'fr', 'als', 'pdc', 'en' ),
	'ptwikisource' => array( 'w', 'b' ),
	'plwiki' => array( 's', 'b', 'q', 'n', 'wikt' ),
	'plwikibooks' => array( 'w', 's' ), # bug 8546
	'plwikisource' => array( 'w', 'b', 'q', 'n', 'wikt', 'oldwikisource' ),
	'plwiktionary' => array( 'w' ),
	'pntwiki'   => array( 'en', 'el', 'elwikiversity', 'incubator' ),
	'ptwikibooks' => array( 'w', 'wikt', 's', 'q', 'n', 'v', 'en', 'es', 'fr', 'it', 'de', 'ru', 'w:en' ),
	'ptwikinews' => array( 'w', 'wikt', 's', 'v', 'b', 'q', 'meta', 'commons', 'it', 'fr', 'ca', 'en', 'es', 'de', ),
	'ptwikiversity' => array( 'incubator', 'w', 'b', ),
	'rowikibooks' => array( 'w', 's' ),
	'ruwikibooks' => array( 'w', 's', ),
	'ruwikiversity' => array( 'w', 'wikt', 'q', 'b', 's', 'n', 'betawikiversity' ),
	'sahwiki' => array( 'incubator' ),
	'sawiki' => array( 'en' ),
	'sawikisource' => array( 'oldwikisource' ),
	'sawiktionary' => array( 'en' ),
	'scnwiki' => array( 'it', 'en', 'fr' ),
	'scnwiktionary' => array( 'w', 'it', 'en', 'fr' ),
	'scowiki' => array( 'en', 'simple' ),
	'sewiki' => array( 'en', 'fi', 'no', 'nn', 'sv' ), // Bug 43411
	'simplewiki' => array( 'en', 'wikt', 'b', 'q' ),
	'simplewiktionary' => array( 'en', 'w', 'b', 'q' ),
	'simplewikiquote' => array( 'en', 'w', 'wikt', 'b' ),
	'skwiki' => array( 'b', 'meta', 'q', 's', 'wikt' ),
	'sourceswiki' => array(
		'ang', 'ar', 'az', 'bg', 'bn', 'bs', 'ca', 'cs', 'cy',
		'da', 'de', 'el', 'en', 'es', 'et', 'fa', 'fi', 'fo',
		'fr', 'gl', 'he', 'hr', 'ht', 'hu', 'hy', 'id', 'is',
		'it', 'ja', 'kn', 'ko', 'la', 'lt', 'mk', 'ml', 'nl',
		'no', 'pl', 'pt', 'ro', 'ru', 'sa', 'sk', 'sl', 'sr',
		'sv', 'ta', 'te', 'th', 'tr', 'uk', 'vi', 'yi', 'zh',
		'meta', 'commons',
	),
	'srnwiki' => array( 'incubator' ),
	'srwiki' => array( 'wikt', 'meta' ), // bug 62533
	'srwiktionary' => array( 'w' ),
	'srwikinews' => array( 'no' ),
	'srwikisource' => array( 'w' ),
	'sswiki' => array( 've', 'st', 'zu', 'xh', 'af', 'en', 'es' ),
	'sswiktionary' => array( 'w', 'en', 'af' ),
	'stqwiki' => array( 'incubator' ),
	'svwikibooks' => array( 'w', 's', 'betawikiversity' ),
	'svwikisource' => array( 'w' ),
	'svwikiversity' => array( 'w', 'b', 's', 'n', 'en', 'betawikiversity' ),
	'svwiktionary' => array( 'w', 'meta' ),
	'szlwiki' => array( 'incubator' ),
	'tawikisource' => array( 'oldwikisource', 'w', 'b' ),
	'tewiki' => array( 'en', 'commons' ), // Bug 41880
	'testwiki' => array( 'de', 'en', 'es', 'fr', 'ja', 'commons', 'meta', 'incubator', 'strategy' ),
	'test2wiki' => array( 'en', 'cs' ),
	'tetwiki' => array( 'en', 'de', 'pt' ),
	'tewikisource' => array( 'w', 'b' ),
	'tnwiki' => array( 'en' ), // bug 51327
	'tpiwiki' => array( 'en', 'simple', 'wikt:en', 'commons' ),

	# vi languages: bug 7854
	'vecwiki'      => array( 'it' ),
	'vecwiktionary' => array( 'w', 'en', 'fr', 'it' ), // bug 49575
	'viwiki'       => array( 'wikt', 'b', 's', 'q' ),
	'viwiktionary' => array( 'w', 'b', 's', 'q' ),
	'viwikibooks'  => array( 'en', 'w', 'wikt', 's', 'q', 'fr', 'it' ), # fr and it: bug 37457
	'viwikisource' => array( 'w', 'wikt', 'b', 'q' ),
	'viwikiquote'  => array( 'w', 'wikt', 'b', 's' ),

	'wikidata' => array( 'meta', 'commons', 'en', 'de', 'fr', 'es' ),
	'testwikidatawiki' => array( 'meta', 'commons', 'en', 'de', 'fr', 'es' ),
	'wikimania2012wiki' => array( 'en', 'meta', 'wm2011' ),
	'wikimania2013wiki' => array( 'en', 'meta', 'wm2011', 'wm2012' ),
	'wikimania2014wiki' => array( 'en', 'meta', 'wm2011', 'wm2012', 'wm2013' ),
	'wikimania2015wiki' => array( 'en', 'meta', 'wm2011', 'wm2012', 'wm2013', 'wm2014' ),
	'wuuwiki' => array( 'en', 'th', 'fr', 'zh', ),
	'xhwiki' => array( 'en' ), // bug 51327
	'zhwikiquote' => array( 'w', 'b', 'wikt', 's', 'meta', 'commons' ),
	'zhwikivoyage' => array( 'w', 'b', 'q', 's', 'en', 'wikt', 'meta', 'commons' ), //bug 60248
	'zhwiktionary' => array( 'w', 'b', 'q', 's', 'meta', 'commons' ),
	'zhwikibooks' => array( 'w', 'wikt', 'q', 's', 'meta', 'commons' ),
	'zhwikisource' => array( 'w', 'b', 'q', 'wikt', 'meta', 'commons' ),
	'zuwiki' => array( 'en' ), // bug 51327
),
# @} end of wgImportSources

'wgImportTargetNamespace' => array(
	'default' => null,
	'enwiktionary' => 108,
	'enwikibooks' => 108,
	'frwiktionary' => 102,
	'frwikisource' => 100,
	'frwikibooks' => 100, // Transwiki
	'nlwikibooks' => 102,
	'frwikinews' => 102, // Transwiki
	'frwikiversity' => 110, // Transwiki
	'frwikiquote' => 108, // transwiki
	// Added zh wikis per bug 40474
	'zhwiktionary' => 102, // Transwiki
	'zhwikibooks' => 100, // Transwiki
	'zhwikiquote' => 100, // Transwiki
	'zhwikisource' => 108, // Transwiki
),

# SVG related @{
'wgSVGConverter' => array(
	'default' => 'rsvg-secure',
),
'wgSVGConverterPath' => array(
	'default' => '/usr/bin',
),
'wgSVGMaxSize' => array(
	'default' => 4096, // 1024's a bit low?
),
# @} end of SVG related

'wgFeedCacheTimeout' => array(
	'default' => 60,
	'enwiki' => 15,
),

'wgExportAllowHistory' => array(
	'default' => true
),

'wgExportMaxHistory' => array(
	'default' => 1000, # changed from 100 -- brion 2008-07-10
),

'wgExportFromNamespaces' => array( // bug 59947
	'default' => false,
	'mediawikiwiki' => true,
),

'wgParserCacheExpireTime' => array(
	'default' => 86400 * 30,
),

# Captcha ...
# Cleaned up old commented out wikis. -- hashar 20110930
# @{
'wmgEnableCaptcha' => array(
	'default' => true,

	// private wikis don't need it
	'private' => false,
	'fishbowl' => false,
),

'wmgEmergencyCaptcha' => array(
	'default' => false,
),
# @} end of Captcha

'wgWantedPagesThreshold' => array(
	'default' => 2,
),

# Cleaned up old commented wikis -- hashar 20110830
'wgEnotifUserTalk' => array(
	'default' => true,
),

'wgEnotifWatchlist' => array(
	'default' => true,
),

'wgEnotifMinorEdits' => array(
	'default' => false,
	'hiwiki' => true,
	'metawiki' => true, // bug 51108
	'ptwikibooks' => true,
	'sourceswiki' => true,
),

'wgJobRunRate' => array(
	'default' => 0,
),

'wgMaxArticleSize' => array(
	# Increased from 1024 to 2000 to alleviate problems with template expansion
	# limits in AfD archives -- TS
	'default' => 2000,
),

'wgEnableSidebarCache' => array(
	'default' => true,
),

'wgAllowTitlesInSVG' => array(
	'default' => true,
),

'wgIgnoreImageErrors' => array(
	'default' => true, // keeps temporary errors from messing the cached output
),

'wgThumbnailScriptPath' => array(
	'default' => false,
	'private' => '/w/thumb.php',
),

'wgGenerateThumbnailOnParse' => array(
	'default' => false,
),

'wgUnwatchedPageThreshold' => array(
	'default' => 30, // Default value of https://toolserver.org/~mzmcbride/watcher/
),

# ROBOT @{
'wgNamespaceRobotPolicies' => array(
	'ckbwiki' => array(
		NS_TALK => 'noindex,follow',
		NS_USER => 'noindex,follow',
		NS_USER_TALK => 'noindex,follow',
		NS_PROJECT_TALK => 'noindex,follow',
		NS_IMAGE_TALK => 'noindex,follow',
		NS_MEDIAWIKI_TALK => 'noindex,follow',
		NS_TEMPLATE_TALK => 'noindex,follow',
		NS_HELP_TALK => 'noindex,follow',
		NS_CATEGORY_TALK => 'noindex,follow',
		101 => 'noindex,follow', // portal talk
		103 => 'noindex,follow', // wikiproject talk
		829 => 'noindex,follow', // module talk
	), // bug 71663
	'dewiki' => array(
		NS_TALK => 'noindex,follow',
		NS_USER => 'noindex,follow', // Bug 36181
		NS_USER_TALK => 'noindex,follow',
		NS_PROJECT_TALK => 'noindex,follow',
		NS_IMAGE_TALK => 'noindex,follow',
		NS_MEDIAWIKI_TALK => 'noindex,follow',
		NS_TEMPLATE_TALK => 'noindex,follow',
		NS_HELP_TALK => 'noindex,follow',
		NS_CATEGORY_TALK => 'noindex,follow',
		101 => 'noindex,follow', // portal talk
		829 => 'noindex,follow', // module talk
	),
	'dawiki' => array(
		NS_USER => 'noindex,follow',
		NS_USER_TALK => 'noindex,follow',
		NS_SPECIAL => 'noindex,follow',
	),
	'enwiki' => array(
		NS_USER_TALK => 'noindex,follow',
		118 => 'noindex,nofollow', // draft
		119 => 'noindex,nofollow', // draft talk
	),
	'frwiki' => array(
		NS_USER => 'noindex,follow',
		NS_USER_TALK => 'noindex,follow',
	),
	'hewiki' => array(
		NS_USER => 'noindex,follow', // bug 16247
	),
	'ruwiki' => array(
		102 => 'noindex,follow',
		103 => 'noindex,follow',
		104 => 'noindex,follow',
		105 => 'noindex,follow',
		106 => 'noindex,follow',
		107 => 'noindex,follow',
	),
	'thwiki' => array(
		NS_TALK => 'noindex,follow',
		NS_USER => 'noindex,follow',
		NS_USER_TALK => 'noindex,follow',
		NS_PROJECT_TALK => 'noindex,follow',
		NS_FILE => 'noindex,follow',
		NS_FILE_TALK => 'noindex,follow',
		NS_MEDIAWIKI_TALK => 'noindex,follow',
		NS_TEMPLATE_TALK => 'noindex,follow',
		NS_HELP_TALK => 'noindex,follow',
		NS_CATEGORY_TALK => 'noindex,follow',
		100 => 'noindex,follow',
		101 => 'noindex,follow',
	),
	'thwikibooks' => array(
		NS_TALK => 'noindex,follow',
		NS_USER => 'noindex,follow',
		NS_USER_TALK => 'noindex,follow',
		NS_PROJECT_TALK => 'noindex,follow',
		NS_FILE => 'noindex,follow',
		NS_FILE_TALK => 'noindex,follow',
		NS_MEDIAWIKI_TALK => 'noindex,follow',
		NS_TEMPLATE_TALK => 'noindex,follow',
		NS_HELP_TALK => 'noindex,follow',
		NS_CATEGORY_TALK => 'noindex,follow',
	),
	'thwiktionary' => array(
		NS_TALK => 'noindex,follow',
		NS_USER => 'noindex,follow',
		NS_USER_TALK => 'noindex,follow',
		NS_PROJECT_TALK => 'noindex,follow',
		NS_FILE => 'noindex,follow',
		NS_FILE_TALK => 'noindex,follow',
		NS_MEDIAWIKI_TALK => 'noindex,follow',
		NS_TEMPLATE_TALK => 'noindex,follow',
		NS_HELP_TALK => 'noindex,follow',
		NS_CATEGORY_TALK => 'noindex,follow',
	),
	'thwikiquote' => array(
		NS_TALK => 'noindex,follow',
		NS_USER => 'noindex,follow',
		NS_USER_TALK => 'noindex,follow',
		NS_PROJECT_TALK => 'noindex,follow',
		NS_FILE => 'noindex,follow',
		NS_FILE_TALK => 'noindex,follow',
		NS_MEDIAWIKI_TALK => 'noindex,follow',
		NS_TEMPLATE_TALK => 'noindex,follow',
		NS_HELP_TALK => 'noindex,follow',
		NS_CATEGORY_TALK => 'noindex,follow',
	),
	'thwikisource' => array(
		NS_TALK => 'noindex,follow',
		NS_USER => 'noindex,follow',
		NS_USER_TALK => 'noindex,follow',
		NS_PROJECT_TALK => 'noindex,follow',
		NS_FILE => 'noindex,follow',
		NS_FILE_TALK => 'noindex,follow',
		NS_MEDIAWIKI_TALK => 'noindex,follow',
		NS_TEMPLATE_TALK => 'noindex,follow',
		NS_HELP_TALK => 'noindex,follow',
		NS_CATEGORY_TALK => 'noindex,follow',
	),
),
# @} end of ROBOT

'wgLoginLanguageSelector' => array(
	'default' => true,
	'enwiki' => false,
),

'wgSpamRegex' => array(
	'default' => array(
		'/overflow\s*:\s*auto\s*;\s*height\s*:|<div[^>]*font-size[^>]*font-color:\s*transparent[^>]*>/i',
		'/avril\.on\.nimp\.org/i', // http://en.wikipedia.org/wiki/Special:Contributions/Hochitup
		'/\.on\.nimp\.org/i', // per MrZ-man 2008-11-02 -- brion
		// bug 15063, these won't last:
		'/<TR>(<TD BGCOLOR=["\']?#......["\']?>(\.|We|are|Anonymous|)+<\/TD>){20,}<\/TR>/i',
		'/<table>.+?(<td bgcolor.+?){400,}.+?<\/table>/i',
		// Weird thingy http://en.wikipedia.org/w/index.php?title=Hellboy:_Sword_of_Storms&oldid=245477898&diff=prev
		'/<span onmouseover="_tipon/',
		// Reported on id.wikipedia.org 2008-12-17 Tim
		'/FIELD_MESSAGE_/',
		// Plaintext link spam https://bugzilla.wikimedia.org/show_bug.cgi?id=16597
		'/[wｗ]{3}[\.．][aＡａ][nｎ][oｏ]ｎ[tＴ][aａ][lｌ][kｋ][\.．][cｃ][oｏ][mｍ]/ui',
	),
	# Multiple requests on IRC -- TS 2006-07-11
	'commonswiki' => '/overflow\s*:\s*auto\s*;\s*height\s*:|kryptonazi|freizeit-diktator/i',
),


# DJVU @{
'wgDjvuDump' => array(
	'default' => '/usr/bin/djvudump',
),

'wgDjvuRenderer' => array(
	'default' => '/usr/bin/ddjvu',
),

'wgDjvuTxt' => array(
	'default' => '/usr/bin/djvutxt',
),
# @}

'wgRestrictDisplayTitle' => array(
	'default' => true,

	// Projects
	'wikimania' => false,

	// Individual wikis
	'aswiki' => false,
	'bewikimedia' => false,
	'bnwiki' => false,
	'bnwiktionary' => false,
	'bnwikisource' => false,
	'bnwikibooks' => false,
	'bdwikimedia' => false,
	'bpywiki' => false,
	'cswiktionary' => false,
	'donatewiki' => false,
	'enwikibooks' => false,
	'foundationwiki' => false,
	'rmwiki' => false,
	'zhwiki' => false,
),

'wmgPrivateWikiUploads' => array(
	'default' => false,
	'private' => true,
	'donatewiki' => true, // whee restricted site
	'foundationwiki' => true, // whee restricted site
	'sewikimedia' => true, // chapter site, only sysops can upload, bug 61947
),

// Note that changing this for wikis with CirrusSearch will remove pages in the
// the affected namespace from search results until a full reindex is completed.
'wgContentNamespaces' => array(
	'default' => array( NS_MAIN ),
	'+arwiki' => array( 104 ), // bug 20623
	'+arwikisource' => array( 102, 104 ),
	'+aswikisource' => array( 102, 104, 106 ), // Bug 43129, 70464
	'+bgwikisource' => array( 100 ),
	'+bnwikisource' => array( 100 ),
	'+brwikisource' => array( 100, 102, 104 ),
	'+cawikisource' => array( 102, 104, 106 ),
	'+cswikiquote' => array( 100 ),
	'+cswikisource' => array( 100 ),
	'+dawikisource' => array( 102, 104, 106 ),
	'+dewikisource' => array( 102, 104 ),
	'+elwikisource' => array( 100, 102 ),
	'+enwikibooks' => array( 102, 110 ),
	'+enwikisource' => array( 102, 104, 106, 114 ), // bug 50007
	'+eswiki' => array( 104 ), // Bug 39866
	'+eswikisource' => array( 102, 104 ),
	'+etwikisource' => array( 102, 104, 106 ),
	'+fawikisource' => array( 102, 104 ),
	'+frrwiki' => array( 102, 104, 106 ), // bug 38023
	'+frwikisource' => array( 102, 104, 112 ),
	'+hewikisource' => array( 104, 108, 112 ),
	'+hrwiki' => array( 102 ), // Bug 40732
	'+hrwikisource' => array( 100, 102, 104 ),
	'+huwikisource' => array( 100, 104, 106 ),
	'+hywikisource' => array( 100, 104, 106 ),
	'+idwikibooks' => array( 100, 102 ), // Bug 2282
	'+idwikisource' => array( 100, 102, 104 ),
	'+itwikisource' => array( 102, 108, 110 ),
	'+itwikivoyage' => array( 100, 104 ), // bug 55620
	'+kowikisource' => array( 100 ),
	'+labswiki' => array( 112 ),
	'+lawikisource' => array( 102, 104, 106 ),
	'+mediawikiwiki' => array( 100, 102 ), // Manuals & extensions
	'+metawiki' => array( NS_HELP ), // Bug 43687
	'+mlwikisource' => array( 100, 104, 106 ),
	'+nlwikisource' => array( 102 ),
	'+nowikisource' => array( 102, 104, 106 ),
	'+plwikisource' => array( 100, 102, 104 ),
	'+ptwiki' => array( 102 ),
	'+ptwikisource' => array( 102, 104, 106 ),
	'+rowikisource' => array( 102, 104, 106 ), // Follow-up for bug 29190
	'+ruwikisource' => array( 104, 106 ),
	'+slwikisource' => array( 100, 104 ),
	'+sourceswiki' => array( 104, 106 ),
	'+srwikibooks' => array( 102, ), // Bug 15282
	'+srwikisource' => array( 100 ),
	'+svwikisource' => array( 104, 106, 108 ),
	'+tewikisource' => array( 102, 104, 106 ),
	'+trwikibooks' => array( 100, 110, ),
	'+trwikisource' => array( 100 ),
	'+ukwikisource' => array( 102, 114, 250, 252 ), // bug 50561, 51684
	'+vecwikisource' => array( 100, 102, 104 ),
	'+viwikibooks' => array( 104, 106 ),
	'+viwikisource' => array( 102, 104, 106 ),
	'+zhwikisource' => array( 102, 104, 106, 114 ), // bug 64127
	'+dewikivoyage' => array( 104 ),
),

'wgExtraSignatureNamespaces' => array(
	// Namespaces not listed in $wgContentNamespaces are not necessary here
	// for core, but reinforcing defalt config doesn't harm.
	'default' => array( NS_PROJECT, NS_HELP ),
	'+wikimedia' => array( NS_MAIN ),
	'+special' => array( NS_MAIN ),
),

'wmgExemptFromUserRobotsControlExtra' => array(
	'default' => array(),
	'enwiki' => array( 118, 119 ), // draft and draft talk
),

'wgRevisionCacheExpiry' => array(
	'default' => 86400 * 7,  // set back to 0 if this breaks
	'testwiki' => 3600,
),

'wgShowExceptionDetails' => array(
	'default' => false,
	'testwiki' => true,
	'test2wiki' => true,
),


# below seems to be for extensions

# EXTENSIONS @{
'wmgUseCategoryTree' => array(
	'default' => true,
	'loginwiki' => false,
	'votewiki' => false,
),

// CT_MODE_CATEGORIES = 0
// CT_MODE_PAGES = 10
// CT_MODE_ALL = 20
'wmgCategoryTreeCategoryPageMode' => array(
	'default' => 0,
	'hewiki' => 10,
),

'wmgCategoryTreeCategoryPageOptions' => array(
	'default' => array( 'mode' => null, 'showcount' => true ),
	'hewiki' => array( 'mode' => 10 /*CT_MODE_PAGES*/ ), # bug 11776
),

'wmgMathFileBackend' => array(
	'default' => 'global-multiwrite'
),

'wmgMathPath' => array(
	'default' => '//upload.wikimedia.org/math',
),

'wmgUseFundraisingTranslateWorkflow' => array(
	'default' => false,
	'metawiki' => true,
),

'wmgUseScore' => array(
	'default' => true,
	'labswiki' => false,
	'loginwiki' => false,
	'votewiki' => false,
),

'wmgScoreFileBackend' => array(
	'default' => 'global-multiwrite'
),

'wmgScorePath' => array(
	'default' => '//upload.wikimedia.org/score'
),

'wmgUseProofreadPage' => array(
	'default' => false,
	'wikisource' => true,
	'sourceswiki' => true, // FIXME: Why isn't this part of wikisource?
	'test2wiki' => true,
	'frrwiki' => true, // bug 38023
),

'wmgUseDPL' => array(
	// DynamicPageList extension
	'default' => false,

	'wikibooks' => true,
	'wikimania' => true,
	'wikinews' => true,
	'wikiquote' => true,
	'wikisource' => true, // Bugs 8563 and 12423
	'wikiversity' => true,

	'bswiki' => true, # 8240
	'dewiktionary' => true,
	'enwiktionary' => true,
	'eswiktionary' => true, # 7952
	'frrwiki' => true, # 38023
	'incubatorwiki' => true,
	'iswiktionary' => true, # 7952
	'legalteamwiki' => true, // bug 62610
	'mediawikiwiki' => true, // bug 69974
	'metawiki' => true,
	'ptwiki' => true, # bug 35308
	'otrs_wikiwiki' => true,
	'outreachwiki' => true, // Bug 56245
	'srwiki' => true,
	'srwiktionary' => true, // bug 68346
	'strategywiki' => true,
	'viwiktionary' => true, # bug 8886
),

'wmgUseFloatedToc' => array(
	'default' => true,
),

'wmgUseGWToolset' => array(
	'default' => false,
	'commonswiki' => true,
),

'wmgUseSpecialNuke' => array(
	'default' => true,
	'loginwiki' => false,
	'votewiki' => false,
),

'wmgUseLabeledSectionTransclusion' => array(
	'default' => true,
	'loginwiki' => false,
	'votewiki' => false,
),

'wmgUseQuiz' => array(
	'default' => false,

	// Projects
	'wikinews' => true, // various wanting to play with it 2007-09
	'wikiversity' => true,

	// Individual wikis
	'dewikibooks' => true,
	'enwikibooks' => true,
	'enwikinews' => true,
	'frwiktionary' => true,
	'hiwiki' => true,
	'iswikibooks' => true,
	'itwikibooks' => true,
	'nlwikibooks' => true,
	'plwikibooks' => true,
	'ptwikibooks' => true,
	'svwiki' => true,
	'viwikibooks' => true, // bug 38361
	'zhwiki' => true,
),

'wmgUseGadgets' => array(
	'default' => true, // set 2007-12-17 by brion
	'loginwiki' => false,
	'votewiki' => false,
),

# @} end of EXTENSIONS

# wgVariantArticlePath @{
'wgVariantArticlePath' => array(
	'srwiki' => '/$2/$1',
	'srwiktionary' => '/$2/$1',
	'srwikibooks' => '/$2/$1',
	'srwikiquote' => '/$2/$1',
	//'srwikiversity' => '/$2/$1',
	'srwikinews' => '/$2/$1',
	'srwikisource' => '/$2/$1',
	'zhwiki' => '/$2/$1',
	'zhwiktionary' => '/$2/$1',
	'zhwikisource' => '/$2/$1',
	'zhwikibooks' => '/$2/$1',
	'zhwikiquote' => '/$2/$1',
	'zhwikinews' => '/$2/$1',
	'zhwikivoyage' => '/$2/$1',
	//'zhwikiversity' => '/$2/$1',
),
# @} end of wgVariantArticlePath

# Disable all query pages for closed wikis, allow normal functioning for others
'wgDisableQueryPages' => array(
	'default' => false,

	'closed' => true, // bug 42436
),

# Disable all the query pages that take more than about 15 minutes to update
# wgDisableQueryPageUpdate @{
'wgDisableQueryPageUpdate' => array(
	'default' => array(
		'Ancientpages',
		'Deadendpages',
		'Fewestrevisions',
		'Mostlinked',
		'Mostrevisions',
		'Wantedpages',
	),
	'small' => array(),

	// Individual wikis
	'+enwiki' => array(
		'Lonelypages',
		'Mostcategories',
		'Mostlinkedcategories',
		'Mostlinkedtemplates',
		'Uncategorizedcategories',
		'Wantedtemplates',
	),
	'+frwiki' => array(
		'Mostcategories',
	),
	'+wikidata' => array(
		'Lonelypages ',
		'Uncategorizedpages',
		'Unwatchedpages',
		'Withoutinterwiki',
	),
),
# @} end of wgDisableQueryPageUpdate

'wgShowHostnames' => array(
	'default' => true,
),

# wgNamespaceProtection @{
'wgNamespaceProtection' => array(
	'default' => array(
		NS_MEDIAWIKI => array( 'editinterface' ),
	),
	'+cswiki' => array(
		NS_FILE      => array( 'editinterface' ),
		NS_FILE_TALK => array( 'editinterface' ),
	),
	'+cswikibooks' => array(
		NS_FILE      => array( 'editinterface' ),
		NS_FILE_TALK => array( 'editinterface' ),
	),
	'+cswikinews' => array(
		NS_FILE      => array( 'editinterface' ),
		NS_FILE_TALK => array( 'editinterface' ),
	),
	'+cswikiquote' => array(
		NS_FILE      => array( 'editinterface' ),
		NS_FILE_TALK => array( 'editinterface' ),
	),
	'+cswikisource' => array(
		NS_FILE      => array( 'editinterface' ),
		NS_FILE_TALK => array( 'editinterface' ),
	),
	'+cswikiversity' => array(
		NS_FILE      => array( 'editinterface' ),
		NS_FILE_TALK => array( 'editinterface' ),
	),
	'+cswiktionary' => array(
		NS_FILE      => array( 'editinterface' ),
		NS_FILE_TALK => array( 'editinterface' ),
	),
	'+eswiki' => array(
		NS_IMAGE => array( 'editinterface' ),
		NS_IMAGE_TALK => array( 'editinterface' ),
		828 => array( 'autoconfirmed' ), // Bug 53558 - Module:
	),
	'+ptwiki' => array(
		NS_IMAGE => array( 'autoconfirmed' ),
	),
	'ruwiki' => array(
		106 => array( 'autoconfirmed' ),
	),
	'sewikimedia' => array(
		NS_MAIN => array( 'editallpages' ),
		NS_TALK => array( 'editallpages' ),
		NS_USER => array( 'editallpages' ),
		NS_USER_TALK => array( 'editallpages' ),
		NS_PROJECT => array( 'editallpages' ),
		NS_PROJECT_TALK => array( 'editallpages' ),
		NS_IMAGE => array( 'editallpages' ),
		NS_IMAGE_TALK => array( 'editallpages' ),
		NS_MEDIAWIKI => array( 'editallpages' ),
		NS_MEDIAWIKI_TALK => array( 'editallpages' ),
		NS_TEMPLATE => array( 'editallpages' ),
		NS_TEMPLATE_TALK => array( 'editallpages' ),
		NS_HELP => array( 'editallpages' ),
		NS_HELP_TALK => array( 'editallpages' ),
		NS_CATEGORY => array( 'editallpages' ),
		NS_CATEGORY_TALK => array( 'editallpages' ),
		100 => array( 'editallpages' ),
		101 => array( 'editallpages' ),
	),
	'ukwikimedia' => array(
		NS_MAIN => array( 'editallpages' ),   // rt 5203: read-only except for user_talk
		NS_TALK => array( 'editallpages' ),
		NS_USER => array( 'editallpages' ),
		NS_PROJECT => array( 'editallpages' ),
		NS_PROJECT_TALK => array( 'editallpages' ),
		NS_IMAGE => array( 'editallpages' ),
		NS_IMAGE_TALK => array( 'editallpages' ),
		NS_MEDIAWIKI => array( 'editallpages' ),
		NS_MEDIAWIKI_TALK => array( 'editallpages' ),
		NS_TEMPLATE => array( 'editallpages' ),
		NS_TEMPLATE_TALK => array( 'editallpages' ),
		NS_HELP => array( 'editallpages' ),
		NS_HELP_TALK => array( 'editallpages' ),
		NS_CATEGORY => array( 'editallpages' ),
		NS_CATEGORY_TALK => array( 'editallpages' ),
		828 => array( 'editallpages' ),
		829 => array( 'editallpages' ),
	),
	'+wikidatawiki' => array(
		122 => array( 'query-update' ),  // Query namespace per bug 49001
	),
),
# @} end of wgNamespaceProtection

'wgParserConf' => array(
	// libxml stuff seems to have iffy memory allocation
	'default' => defined( 'HHVM_VERSION' )
		? array( 'class' => 'Parser', 'preprocessorClass' => 'Preprocessor_Hash' )
		: array( 'class' => 'Parser', 'preprocessorClass' => 'Preprocessor_DOM' ),
	// Workaround for the issue discussed at https://oc.wikipedia.org/wiki/Discussion_Utilizaire:Midom -- TS
	'ocwiki' => array( 'class' => 'Parser', 'preprocessorClass' => 'Preprocessor_Hash' ),
),

# wgFavicon @{
'wgFavicon' => array(
	# Projects
	'default' => '//bits.wikimedia.org/favicon/wmf.ico', // bug 48479
	'wiki' => '//bits.wikimedia.org/favicon/wikipedia.ico', // bug 48479
	'wikibooks' => '//bits.wikimedia.org/favicon/wikibooks.ico',
	'wikimania' => '//bits.wikimedia.org/favicon/wikimania.ico',
	'wikinews' => '//bits.wikimedia.org/favicon/wikinews.ico',
	'wikiquote' => '//bits.wikimedia.org/favicon/wikiquote.ico',
	'wikisource' => '//bits.wikimedia.org/favicon/wikisource.ico',
	'wikiversity' => '//bits.wikimedia.org/favicon/wikiversity.ico',
	'wikivoyage' => '//bits.wikimedia.org/favicon/wikivoyage.ico',
	'wiktionary' => '//bits.wikimedia.org/favicon/piece.ico',

	# Wiktionaries
	'angwiktionary' => '//bits.wikimedia.org/favicon/wiktionary/en.ico', // bug 57496
	'cswiktionary' => '//bits.wikimedia.org/favicon/wiktionary/en.ico', // bug 45113
	'enwiktionary' => '//bits.wikimedia.org/favicon/wiktionary/en.ico', // bug 44843
	'iswiktionary' => '//bits.wikimedia.org/favicon/wiktionary/en.ico', // bug 46712
	'siwiktionary' => '//bits.wikimedia.org/favicon/wiktionary/si.ico', // bug 38036

	# Special wikis
	'advisorywiki' => '//bits.wikimedia.org/favicon/wmf.ico',
	'chapcomwiki' => '//bits.wikimedia.org/favicon/chapcom.ico',
	'checkuserwiki' => '//bits.wikimedia.org/favicon/community.ico',
	'commonswiki' => '//bits.wikimedia.org/favicon/commons.ico',
	'donatewiki' => '//bits.wikimedia.org/favicon/wmf.ico',
	'fdcwiki' => '//bits.wikimedia.org/favicon/wmf.ico', // bug 48404
	'foundationwiki' => '//bits.wikimedia.org/favicon/wmf.ico',
	'grantswiki' => '//bits.wikimedia.org/favicon/wmf.ico',
	'iegcomwiki' => '//bits.wikimedia.org/favicon/wmf.ico',
	'incubatorwiki' => '//bits.wikimedia.org/favicon/incubator.ico',
	'internalwiki' => '//bits.wikimedia.org/favicon/internal.ico',
	'labswiki' => '//bits.wikimedia.org/favicon/wikitech.ico',
	'legalteamwiki' => '//bits.wikimedia.org/favicon/wmf.ico',
	'loginwiki' => '//bits.wikimedia.org/favicon/wmf.ico',
	'mediawikiwiki' => '//bits.wikimedia.org/favicon/mediawiki.ico',
	'metawiki' => '//bits.wikimedia.org/favicon/community.ico',
	'officewiki' => '//bits.wikimedia.org/favicon/office.ico',
	'ombudsmenwiki' => '//bits.wikimedia.org/favicon/wmf.ico', // bug 48404
	'otrs_wikiwiki' => '//bits.wikimedia.org/favicon/wmf.ico',
	'outreachwiki' => '//bits.wikimedia.org/favicon/community.ico',
	'searchcomwiki' => '//bits.wikimedia.org/favicon/wmf.ico',
	'sourceswiki' => '//bits.wikimedia.org/favicon/wikisource.ico',
	'spcomwiki' => '//bits.wikimedia.org/favicon/spcom.ico',
	'specieswiki' => '//bits.wikimedia.org/favicon/wikispecies.ico',
	'stewardwiki' => '//bits.wikimedia.org/favicon/community.ico',
	'strategywiki' => '//bits.wikimedia.org/favicon/community.ico',
	'testwiki' => '//bits.wikimedia.org/favicon/black-globe.ico',
	'testwikidatawiki' => '//bits.wikimedia.org/favicon/testwikidata.ico',
	'transitionteamwiki' => '//bits.wikimedia.org/favicon/wmf.ico',
	'usabilitywiki' => '//bits.wikimedia.org/favicon/usability.ico',
	'votewiki' => '//bits.wikimedia.org/favicon/wmf.ico',
	'wikidatawiki' => '//bits.wikimedia.org/favicon/wikidata.ico',
	'wikimaniateamwiki' => '//bits.wikimedia.org/favicon/wikimania.ico',
	'zerowiki' => '//bits.wikimedia.org/favicon/wmf.ico',
),
# @} end of wgFavicon

# wmgAutopromoteExtraGroups @{
'wmgAutopromoteExtraGroups' => array(
	'default' => false,
	'testwiki' => array(
		'patroller' => array( '&',
				array( APCOND_EDITCOUNT, 10 ),
				array( APCOND_AGE, 100 * 86400 ), // 100 days * seconds in a day
		),
	),
	'fiwiki' => array(
		'patroller' => array( '&',
				array( APCOND_EDITCOUNT, 1000 ),
				array( APCOND_AGE, 100 * 86400 ),
		),
	),
	'frwiki' => array(
		'autopatrolled' => array( '&',
			array( APCOND_EDITCOUNT, 500 ),
			array( APCOND_AGE, 90 * 86400 ),
		),
	),
	'ruwikiversity' => array(
		'patroller' => array( '&',
			array( APCOND_EDITCOUNT, 1000 ),
		),
	),
),
# @} end of wmgAutopromoteExtraGroups

'wmgAutopromoteOnceonEdit' => array(
	'default' => array(),
	'dewikivoyage' => array(
		'autopatrolled' => array(
			'&',
			array( APCOND_EDITCOUNT, 200 ),
		),
	), // Bug 65495
	'trwiki' => array(
		'autoreview' => array(
			'&', // AND
			array( APCOND_AGE, 7*86400 ),
			array( APCOND_EDITCOUNT, 30, 2*86400 ),
			array( 70821 /*APCOND_FR_EDITSUMMARYCOUNT*/, 5 ),
			array( 70823 /*APCOND_FR_UNIQUEPAGECOUNT*/, 5 ),
			array( 70827 /*APCOND_FR_EDITSPACING*/, 7, 7 ),
			array( 70824 /*APCOND_FR_CONTENTEDITCOUNT*/, 20, 2*86400 ),
			array( 70822 /*APCOND_FR_NEVERBOCKED*/ ),
			array( 70829 /*APCOND_FR_MAXREVERTEDEDITRATIO*/, .03 ),
			array( '!', array( APCOND_INGROUPS, array( 'sysop' ) ) ),
			array( '!', array( APCOND_INGROUPS, array( 'bureaucrat' ) ) ),
			array( '!', array( APCOND_INGROUPS, array( 'bot' ) ) ),
			array( '!', array( APCOND_INGROUPS, array( 'patroller' ) ) ),
		),
		'patroller' => array(
			'&', // AND
			array( APCOND_AGE, 15*86400 ),
			array( APCOND_EDITCOUNT, 150, 1*86400 ),
			array( 70821 /*APCOND_FR_EDITSUMMARYCOUNT*/, 25 ),
			array( 70823 /*APCOND_FR_UNIQUEPAGECOUNT*/, 10 ),
			array( 70827 /*APCOND_FR_EDITSPACING*/, 7, 15 ),
			array( 70824 /*APCOND_FR_CONTENTEDITCOUNT*/, 100, 1*86400 ),
			array( 70822 /*APCOND_FR_NEVERBOCKED*/ ),
			array( 70829 /*APCOND_FR_MAXREVERTEDEDITRATIO*/, .03 ),
			array( '!', array( APCOND_INGROUPS, array( 'sysop' ) ) ),
			array( '!', array( APCOND_INGROUPS, array( 'bureaucrat' ) ) ),
			array( '!', array( APCOND_INGROUPS, array( 'bot' ) ) ),
		),
	),
),

'wmgAutopromoteOnceonView' => array(
	'default' => array(),
	'ruwiki' => array(
		'uploader' => array( '&',
			array( APCOND_EDITCOUNT, 20 ),
			array( APCOND_AGE, 14 * 86400 ),
		),
	),
	'fawiki' => array(
		'uploader' => array( '&',
			array( APCOND_EDITCOUNT, 10 ),
			array( APCOND_AGE, 4 * 86400 ),
			array( '!', array( APCOND_INGROUPS, array( 'sysop' ) ) ),
			array( '!', array( APCOND_INGROUPS, array( 'bureaucrat' ) ) ),
		),
	), // bug 69171
),

'wgAutopromoteOnceLogInRC' => array(
	'default' => true,
	'ruwiki' => false,
	'fawiki' => false, // bug 69171
),

'wmgExtraImplicitGroups' => array(
	'default' => false,
	'frwiki' => array( 'autopatrolled' ),
),

'wgDeleteRevisionsLimit' => array(
	'default' => 5000,
),

'wgAppleTouchIcon' => array(
	'default' => false, // iOS searches for icons in docroot by default

	'commonswiki' => '//bits.wikimedia.org/apple-touch/commons.png',
	'mediawikiwiki' => '//bits.wikimedia.org/apple-touch/mediawiki.png',
	'usabilitywiki' => '//bits.wikimedia.org/apple-touch/usability.png',
	'wikinews' => '//bits.wikimedia.org/apple-touch/wikinews.png',
	'wiki' => '//bits.wikimedia.org/apple-touch/wikipedia.png',
	'wiktionary' => '//bits.wikimedia.org/apple-touch/wiktionary.png',
	'wikidatawiki' => '//bits.wikimedia.org/apple-touch/wikidata.png', // bug 70996
	'enwiktionary' => '//bits.wikimedia.org/apple-touch/wiktionary/en.png', // bug 46431
	'labswiki' => '/Wikitech-apple-touch-icon.png',
),

'wgUserEmailUseReplyTo' => array(
	'default' => false, // bug 12655
),

'wgStatsMethod' => array(
	'default' => 'udp',
),

'wmgUseTitleKey' => array(
	'default' => true, // enable/disable TitleKey prefix search case-insensitivity ext
),

'wgUseLocalMessageCache' => array(
	'default' => true,
),

# CENTRAL AUTH @{
'wmgUseCentralAuth' => array(
	'default' => true,
	'testwiki' => true,
	'private' => false,
	'fishbowl' => false,
),

'wmgCentralAuthLoginIcon' => array(
	'default' => false,
	'wiki' => '/srv/mediawiki/images/sul/wikipedia.png',
	'wikibooks' => '/srv/mediawiki/images/sul/wikibooks.png',
	'wikinews' => '/srv/mediawiki/images/sul/wikinews.png',
	'wikiquote' => '/srv/mediawiki/images/sul/wikiquote.png',
	'wikisource' => '/srv/mediawiki/images/sul/wikisource.png',
	'sourceswiki' => '/srv/mediawiki/images/sul/wikisource.png',
	'wikiversity' => '/srv/mediawiki/images/sul/wikiversity.png',
	'wiktionary' => '/srv/mediawiki/images/sul/wiktionary.png',
	'metawiki' => '/srv/mediawiki/images/sul/meta.png',
	'commonswiki' => '/srv/mediawiki/images/sul/commons.png',
	'mediawikiwiki' => '/srv/mediawiki/images/sul/mediawiki.png',
	'wikidatawiki' => '/srv/mediawiki/images/sul/wikidata.png',
	'specieswiki' => '/srv/mediawiki/images/sul/wikispecies.png',
	'incubatorwiki' => '/srv/mediawiki/images/sul/incubatorwiki.png',
	'wikivoyage' => '/srv/mediawiki/images/sul/wikivoyage.png',
	'wikimania2014wiki' => '/srv/mediawiki/images/sul/wikimania.png',
	'loginwiki' => '/srv/mediawiki/images/sul/foundation.png',

	'brwikimedia' => '/srv/mediawiki/images/sul/foundation.png',
),

'wmgCentralAuthAutoLoginWikis' => array(
	'default' => array(
		'.wikipedia.org' => 'enwiki',
		'meta.wikimedia.org' => 'metawiki',
		'.wiktionary.org' => 'enwiktionary',
		'.wikibooks.org' => 'enwikibooks',
		'.wikiquote.org' => 'enwikiquote',
		'.wikisource.org' => 'enwikisource',
		'commons.wikimedia.org' => 'commonswiki',
		'.wikinews.org' => 'enwikinews',
		'.wikiversity.org' => 'enwikiversity',
		'.mediawiki.org' => 'mediawikiwiki',
		'.wikidata.org' => 'wikidatawiki',
		'species.wikimedia.org' => 'specieswiki',
		'incubator.wikimedia.org' => 'incubatorwiki',
		'.wikivoyage.org' => 'enwikivoyage',
	),
	'+ptwiki' => array( 'br.wikimedia.org' => 'brwikimedia' ),
	'+ptwikibooks' => array( 'br.wikimedia.org' => 'brwikimedia' ),
	'+ptwikinews' => array( 'br.wikimedia.org' => 'brwikimedia' ),
	'+ptwikiquote' => array( 'br.wikimedia.org' => 'brwikimedia' ),
	'+ptwikisource' => array( 'br.wikimedia.org' => 'brwikimedia' ),
	'+ptwikiversity' => array( 'br.wikimedia.org' => 'brwikimedia' ),
	'+ptwikivoyage' => array( 'br.wikimedia.org' => 'brwikimedia' ),

),

'wmgCentralAuthLoginWiki' => array(
	'default' => 'loginwiki',
),

'wmgCentralAuthSilentLogin' => array(
	'default' => true,
),

'wmgCentralAuthUseEventLogging' => array(
	'default' => true,
),

// This is also guarded by $wmgUseCentralAuth
'wmgUseGlobalCssJs' => array(
	'default' => true,
	'loginwiki' => false,
	'private' => false,
	'fishbowl' => false,
),

'wmgUseOAuth' => array(
	'default' => true,
	'private' => false,
	'fishbowl' => false,
),

# @}

'wgEnableMWSuggest' => array(
	'default' => true,
	'private' => false,
),

'wgCookieHttpOnly' => array(
	'default' => true,
),

'wmgUseDualLicense' => array(
	'default' => false,
	'wikidata' => true,
	'wikivoyage' => true,
	// Add new wikis  for dual-license here...
	'acewiki' => true,
	'arbcom_dewiki'    =>  true,
	'arbcom_nlwiki'    =>  true,
	'arbcom_fiwiki'    => true,
	'arwikimedia'	=> true,
	'arwikiversity'	=> true,
	'arzwiki' => true,
	'bewikimedia' => true,
	'bewikisource' => true,
	'bjnwiki' => true,
	'boardgovcomwiki' => true,
	'brwikimedia' => true,
	'brwikisource' => true,
	'cawikimedia' => true,
	'checkuserwiki' => true,
	'ckbwiki' => true,
	'cswikinews' => true,
	'cswikiversity' => true,
	'cowikimedia' => true,
	'dkwikimedia' => true,
	'donatewiki' => true,
	'elwikinews' => true,
	'eowikinews' => true,
	'eowikisource' => true,
	'etwikimedia' => true,
	'extwiki' => true,
	'fawikinews' => true,
	'fiwikimedia' => true,
	'frrwiki' => true,
	'gagwiki' => true,
	'ganwiki' => true,
	'guwikisource' => true,
	'huwikinews' => true,
	'iegcomwiki' => true,
	'jawikiversity' => true,
	'hifwiki' => true,
	'kaawiki' => true,
	'kbdwiki' => true,
	'koiwiki' => true,
	'kowikiversity' => true,
	'legalteamwiki' => true,
	'lezwiki' => true,
	'liwikibooks' => true,
	'liwikisource' => true,
	'loginwiki' => true,
	'ltgwiki' => true,
	'mdfwiki' => true,
	'mhrwiki' => true,
	'minwiki' => true,
	'movementroleswiki' => true,
	'mrjwiki' => true,
	'mwlwiki' => true,
	'mxwikimedia' => true,
	'myvwiki' => true,
	'noboard_chapterswikimedia' => true,
	'nsowiki' => true,
	'nycwikimedia' => true,
	'ombudsmenwiki' => true,
	'pcdwiki' => true,
	'pflwiki' => true,
	'pnbwiki' => true,
	'ptwikiversity' => true,
	'ruewiki'		=> true,
	'nowikimedia'   =>  true,
	'ruwikimedia' => true,
	'ruwikiversity' => true,
	'sawikiquote' => true,
	'sahwiki' => true,
	'sahwikisource' => true,
	'sawikisource' => true,
	'sewikimedia' => true,
	'slwikiversity' => true,
	'sqwikinews' => true,
	'stewardwiki' => true,
	'strategywiki' => true,
	'svwikiversity' => true,
	'szlwiki' => true,
	'srnwiki' => true,
	'tenwiki' => true,
	'transitionteamwiki' => true,
	'trwikimedia' => true,
	'trwikinews' => true,
	'tyvwiki'    => true, // bug 49328
	'uawikimedia'   => true,
	'ukwikimedia'   => true,
	'usabilitywiki' =>  true,
	'vecwiktionary' => true,
	'vewikimedia' => true,
	'viwikivoyage' => true, // bug 52034
	'wikimania2009wiki' => true,
	'wikimania2010wiki' => true,
	'wikimania2011wiki' => true,
	'wikimania2012wiki' => true,
	'wikimania2013wiki' => true,
	'wikimania2014wiki' => true,
	'wikimania2015wiki' => true,
	'xmfwiki' => true,
),

'wgEnableWriteAPI' => array(
	'default' => true,
),

'wgAPIMaxResultSize' => array(
	'default' => 12582912, // 12 MB; temporary while I figure out what the deal with those overlarge revisions is --Roan
),

'wmgUseCollection' => array(
	// PDF generation / [[:mw:OCG]] stuff
	'default' => false,
	'testwiki' => true,
	'test2wiki' => true,
	'alswiki' => true, # Bug 18517
	'arwiki' => true, # bug 33828
	'bawiki' => true, // Bug 40879
	'bpywiki' => true, # Bug 18517
	'cawiki' => true, # Bug 21174
	'chapcomwiki' => true, # Bug 52833
	'cswiki' => true, # Bug 20436
	'cswikiversity' => true, # Bug 21077
	'bnwiki' => true, # https://bugzilla.wikimedia.org/show_bug.cgi?id=20338
	'dawiki' => true, # 22444
	'dewiki' => true, # live test on german - 2009-01-26
	'dewikiversity' => true, # Bug 37898
	'dsbwiki' => true,
	'elwiki' => true, # bug 22924
	'enwiki' => true, # 2009-02-26 bv whee :D
	'enwikiversity' => true,
	'eowiki' => true, # 23434
	'eswiki' => true, # 2009-02-18
	'etwiki' => true,
	'euwiki' => true, # bug 28292
	'fawiki' => true, # bug 26319
	'fiwiki' => true,
	'frrwiki' => true, # Bug 38023
	'frwiki' => true, # 2009-02-18
	'frwikiversity' => true, # Bug 16178
	'foundationwiki' => true,
	'gdwiki' => true,
	'glwiki' => true,
	'hewiki' => true,
	'hewiktionary' => true,
	'hewikivoyage' => true,
	'hiwiki' => true,
	'hrwiki' => true, # Bug 19013
	'hsbwiki' => true,
	'huwiki' => true, # Bug 21005
	'idwiki' => true, # 18430
	'iswiki' => true, // Bug 43760
	'itwiki' => true,
	'kawiki' => true,
	'kkwiki' => true,
	'kmwiki' => true, // bug 30680
	'kowiki' => true,
	'lbwiki' => true, // bug 47469
	'mediawikiwiki' => true, # Bug 29228
	'metawiki' => true, // Bug 18058 on 2009-03-19
	'mkwiki' => true, # bug 37345
	'mswiki' => true, # Bug 20402
	'nlwiki' => true, # 2009-02-18
	'nnwiki' => true, # 2009-05-05
	'nowiki' => true, # 2009-05-05
	'outreachwiki' => true, # 28495
	'plwiki' => true, # 2009-02-18
	'ptwiki' => true, # 2009-02-18
	'ptwikiversity' => true, # 18367
	'rmwiki' => true,
	'rowiki' => true, # 28347
	'ruwiki' => true, # 22330
	'ruwikiversity' => true,
	'sewikimedia' => true, # Bug 38988
	'simplewiki' => true, # 2009-02-18
	'shwiki' => true, # Bug 47166
	'skwiki' => true, # bug 22038
	'slwiki' => true,
	'sourceswiki' => true,
	'sqwiki' => true, # bug 26074
	'srwiki' => true, # Per Brion on 2009-04-03
	'strategywiki' => true, # 2009-11-07, Bug 21361
	'svwiki'    => true, # 2009-03-24 Bug 18023
	'svwikiversity' => true, // bug 64994
	'tawiki' => true,
	'tewiki' => true,
	'thwiki'    => true,
	'trwiki'	=> true, # Bug 22791
	'ukwiki'    => true, # 23437
	'urwiki' => true, # Bug 41563
	'viwiki' => true, # 2009-12-28 bug 21566
	'wikibooks' => true, # on for all wikibooks! 2008-10-23
	'wikisource' => true, # 2009-02-24
	'wikimania' => true,
	'wikinews' => true,
	'wikivoyage' => true,
),

'wmgCollectionPortletForLoggedInUsersOnly' => array(
	'default' => false,
),

'wmgCollectionArticleNamespaces' => array(
	'default' => array(
		NS_MAIN, NS_TALK, NS_USER, NS_USER_TALK, NS_PROJECT, NS_PROJECT_TALK, NS_MEDIAWIKI, NS_MEDIAWIKI_TALK,
		NS_HELP, NS_HELP_TALK, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111
	),
	'+enwikisource' => array( 114 ), // bug 56899
	'+metawiki' => array( 200 ),
),

'wmgCollectionHierarchyDelimiter' => array(
	'default'  => false, // false == don't overwrite the extension's default settings
	'wikibooks' => '/',
),

'wmgCollectionPortletFormats' => array(
	'default' => array( 'rdf2latex' ),
	// The old PDF renderer choked on Indic languages.  The
	// new renderer should render these fine (and the ODF
	// renderer is in a data center which is being shut down).
	// This array used to contain overrides for
	// ta/gu/ml/ne/ur (bug 37154, 37384, 37672, 37374, 41714).
),

'wmgUseSpamBlacklist' => array(
	'default' => true,
	'private' => false,
	'fishbowl' => false, // not needed, private editing...
),

'wgAllowImageMoving' => array(
	'default' => true, // brion 2009-09-21
	'testwiki' => true,
	'usabilitywiki' => true,
),

'wmgUseNewUserMessage' => array(
	'default' => false,
	'arwiki' => true,
	'arwikisource' => true,
	'ckbwiki' => true, // Bug 52678
	'commonswiki' => true,
	'dewikiversity' => true, // Bug 49449
	'enwikinews' => true,
	'fawiki' => true, // Bug 53981
	'guwiki' => true, // Bug 40872
	'guwikisource' => true, // Bug 40872
	'hiwiki' => true,
	'incubatorwiki' => true,
	'kowiki' => true,
	'ladwiki' => true, // https://bugzilla.wikimedia.org/show_bug.cgi?id=30221
	'lvwiki' => true,
	'metawiki' => true,
	'mlwiki' => true, // bug 36595
	'mrwiki' => true,
	'mrwikisource' => true,
	'ndswiki' => true,
	'ptwiktionary' => true, // bug 44412
	'rowiki' => true,
	'rowikinews' => true,
	'rowikisource' => true, // http://bugzilla.wikimedia.org/show_bug.cgi?id=28307
	'ruwikiversity' => true,
	'strategywiki' => true,
	'thwiki' => true, // http://bugzilla.wikimedia.org/show_bug.cgi?id=28689
	'thwiktionary' => true, // bug 31600
	'thwikisource' => true, // bug 31600
	'thwikibooks' => true, // bug 31600
	'thwikiquote' => true, // bug 31600
	'ukwiki' => true, // bug 65125
	'urwiki' => true, // bug 62398
	'zhwiki' => true, // bug 30362
),

'wmgNewUserMessageOnAutoCreate' => array(
	'default' => false,
	'arwiki' => true,
	'arwikisource' => true,
	'commonswiki' => true,
	'enwikinews' => true,
	'guwiki' => true, // Bug 40872
	'guwikisource' => true, // Bug 40872
	'hiwiki' => true,
	'incubatorwiki' => true,
	'lvwiki' => true,
	'metawiki' => true,
	'mlwiki' => true,
	'ndswiki' => true,
	'rowiki' => true,
	'thwiki' => true,
	'thwiktionary' => true, // bug 31600
	'thwikisource' => true, // bug 31600
	'thwikibooks' => true, // bug 31600
	'thwikiquote' => true, // bug 31600
	'ukwiki' => true, // bug 65125
),

'wmgNewUserSuppressRC' => array(
	'default' => true,
),

'wmgNewUserMinorEdit' => array(
	'default' => true,
	'arwiki' => false,
	'fawiki' => false,
	'incubatorwiki' => false,
),

'wmgApplyGlobalBlocks' => array(
	'default' => true,
	'private' => false,
	'fishbowl' => false,
	'metawiki' => false,
),

'wmgUseFlaggedRevs' => array(
	'default' => false,
	# To update this dblist:
	#   * ADD THE TABLES TO THE DATABASE
	#       mwscript sql.php --wiki=ruwikinews extensions/FlaggedRevs/backend/schema/mysql/FlaggedRevs.sql
	#   * edit flaggedrevs.dblist (or the corresponding file for the current realm)
	#   * touch InitialiseSettings.php to invalidate the cache
	#   * sync-common-all
	#   * press enter
	'flaggedrevs' => true,
),

'wgMaximumMovedPages' => array(
	'default' => 100,
	'enwikibooks' => 500,
	'frwikisource' => 500,
	'incubatorwiki' => 500,
),

'wgGroupsAddToSelf' => array(
	'commonswiki' => array( 'sysop' => array( 'translationadmin' ) ), // Bug 54732
	'metawiki' => array( 'sysop' => array( 'flood', 'translationadmin' ) ), // Bug 37198
	'otrs_wikiwiki' => array( 'sysop' => array( 'translationadmin' ) ), // bug 61297
	'enwikibooks' => array( 'sysop' => array( 'flood' ) ),
	'enwikinews' => array( 'sysop' => array( 'flood' ) ),
	'enwikisource' => array( 'sysop' => array( 'flood' ) ), //Bug 36863
	'eswiki' => array( 'sysop' => array( 'flood' ) ), // Bug  48682
	'frwikinews' => array( 'sysop' => array( 'flood' ) ),
	'itwikibooks' => array( 'sysop' => array( 'flooder' ) ), // Bug 39569
	'itwikisource' => array( 'sysop' => array( 'flood' ) ), // Bug 36600
	'itwiktionary' => array( 'sysop' => array( 'flood' ) ), // Bug 39306
	'simplewiki' => array( 'sysop' => array( 'flood' ) ),
	'srwiki' => array( 'sysop' => array( 'flood' ) ),
	'plwiki' => array( 'sysop' => array( 'flood' ) ), // Bug 20155
	'strategywiki' => array( 'sysop' => array( 'flood' ) ),
	'wikidata' => array( 'sysop' => array( 'flood', 'translationadmin' ) ), // Bug 48013, Bug 46856
	'zhwiki' => array( 'sysop' => array( 'flood' ) ),
),
'wgGroupsRemoveFromSelf' => array(
	'commonswiki' => array( 'sysop' => array( 'translationadmin' ) ), // Bug 54732
	'metawiki' => array( 'sysop' => array( 'flood', 'translationadmin' ) ), // Bug 37198
	'otrs_wikiwiki' => array( 'sysop' => array( 'translationadmin' ) ), // Bug 61297
	'ckbwiki' => array(
		'flood' => array( 'flood' ), // Bug 51803
		'botadmin' => array( 'botadmin' ), // Bug 51803
	),
	'enwikibooks' => array( 'sysop' => array( 'flood' ) ),
	'enwikinews' => array( 'sysop' => array( 'flood' ) ),
	'enwikisource' => array( 'sysop' => array( 'flood' ) ), // Bug 36863
	'eswiki' => array( 'sysop' => array( 'flood' ) ), // Bug  48682
	'frwikinews' => array( 'sysop' => array( 'flood' ) ),
	'frwiktionary' => array( 'botadmin' => array( 'botadmin' ) ),
	'itwikisource' => array( 'sysop' => array( 'flood' ) ), // Bug 36600
	'mlwiki' => array( 'botadmin' => array( 'botadmin' ) ),
	'mlwikisource' => array( 'botadmin' => array( 'botadmin' ) ), // Bug 44335
	'mlwiktionary' => array( 'botadmin' => array( 'botadmin' ) ),
	'simplewiki' => array( 'sysop' => array( 'flood' ) ),
	'plwiki' => array( 'flood' => array( 'flood' ) ), // Bug 20155 , bug 21238
	'strategywiki' => array( 'sysop' => array( 'flood' ) ),
	'srwiki' => array( 'sysop' => array( 'flood' ) ),
	'wikidata' => array(
		'sysop' => array( 'flood', 'translationadmin' ), // Bug 48013, Bug 46856
		'flood' => array( 'flood' ), // Bug 48013
	),
	'zhwiki' => array( 'sysop' => array( 'flood' ) ),
	'zhwikinews' => array( 'flood' => array( 'flood' ) ), // bug 52546
),

'wgEnableAPI' => array(
	'default' => true,
),

'wmgUseCodeReview' => array(
	'default' => false,
	'mediawikiwiki' => true,
),

'wgSquidMaxage' => array(
	'default' => 2678400, // 31 days seems about right
	'foundationwiki' => 3600, // template links may be funky
),

# abuse filter @{
'wmgUseAbuseFilter' => array(
	'default' => true,
),

'wmgAbuseFilterCentralDB' => array(
	'default' => 'metawiki',
),

// emergency disable: shut off filters tagging >5% of posts on a total of at least 25 posts per day
'wmgAbuseFilterEmergencyDisableThreshold' => array(
	'default' => array(
		'default' => 0.05,
	),
),
'wmgAbuseFilterEmergencyDisableCount' => array(
	'default' => array(
		'default' => 2,
	),
	'enwiki' => array(
		'default' => 25,
	),
),
'wmgAbuseFilterEmergencyDisableAge' => array(
	'default' => array(
		'default' => 86400,
	),
),
# @}

'wgThumbLimits' => array(
	'default' => array( 120, 150, 180, 200, 220, 250, 300 ),
	'+itwikiquote' => array( 360 ),
	'svwiki' => array( 120, 200, 250, 300, 360 ),
),
'wmgThumbsizeIndex' => array(
	'default' => 4,
	'svwiki' => 2, // bug 16739
),

'wgTorTagChanges' => array(
	'default' => false, // pending discussion
	'testwiki' => true,
),

'wmgUseContactPage' => array(
	'default' => false,
	'foundationwiki' => true,
	'nlwiki' => true,
	'testwiki' => true,
),
'wmgContactPageConf' => array(
	'default' => array(),
	// bug 15624
	'nlwiki' => array(
		'RecipientUser' => 'WikiAdmin',
		'SenderName' => 'Contactformulier op nl-Wikipedia',
		'IncludeIP' => true,
	),
),

'wgCopyUploadProxy' => array(
	'default' => 'url-downloader.wikimedia.org:8080',
),
'wgAllowCopyUploads' => array(
	'default' => false,
	'testwiki' => true,
	'test2wiki' => true,
	'commonswiki' => true,
),
'wgCopyUploadsFromSpecialUpload' => array(
	'default' => false,
),
// For Flickr uploads via UploadWizard - 2012-11-20
'wgCopyUploadsDomains' => array(
	'default' => array( '*.flickr.com', '*.staticflickr.com', ),
	'+testwiki' => array( 'upload.wikimedia.org' ),
	'+commonswiki' => array(
		'am.adlibhosting.com',              // Amsterdam Museum
		'*.collectie.legermuseum.nl',       // Legermuseum
		'*.europeana1914-1918.eu',          // Europeana 1914-1918
		'*.gahetna.nl',                     // Nationaal Archief Nederland
		'*.hu-berlin.de',                   // Humboldt-Universität zu Berlin
		'*.kb.nl',                          // Koninklijke Bibliotheek, Nationale Bibliotheek van Nederland
		'*.lndb.lv',                        // Latvijas Nacionālā Bibliotēka
		'*.memorix.nl',                     // Archief Eemland
		'*.openbeelden.nl',                 // Open Beelden
		'*.panoramio.com',                  // Panoramio by Google
		'*.raa.se',                         // Swedish National Heritage Board
		'*.rbge.org.uk',                    // Royal Botanic Garden Edinburgh
		'*.rijksmuseum.nl',                 // Rijksmuseum
		'*.llgc.org.uk',                    // National Library of Wales
		'*.tounoki.org',                    // Musées de la Haute-Saône (test) - bug 63449
		'musees.cg70.fr',                   // Musées de la Haute-Saône (prod) - bug 63449
		'*.musees.cg70.fr',                 // Musées de la Haute-Saône (prod) - bug 63449
		'*.wikimedia.ch',                   // Wikimedia CH
		'link.nypl.org',                    // New York Public Library
		'*.peacepalacelibrary.nl',          // Peace Palace Library, The Hague - bug 64372
		'lcweb2.loc.gov',                   // Library of Congress
		'deriv.nls.uk',                     // National Library of Scotland
		'*.nb.admin.ch',                    // Swiss National Library
		'*.bar.admin.ch',                   // Swiss Federal Archives
		'*.unine.ch',                       // University of Neuchâtel
		'*.mindat.org',                     // Mineral and locality database
		'*.culture.gouv.fr',                // French Ministry for Culture - bug 65905
		'memory.loc.gov',                   // Library of Congress - bug 66945
		'*.ihs.nl',                         // IHS at Erasmus University - bug 67120
		'*.eur.nl',                         // Erasmus University Rotterdam - bug 67355
		'mochila_images.s3.amazonaws.com',  // temporary for GWT upload - bug 67344
		'mochila_images2.s3.amazonaws.com', // temporary for GWT upload - bug 67344
		'*.universiteitsmuseum.nl',         // Universiteits Museum Utrecht
		'data.kb.se',                       // National Library of Sweden Open Data - bug 69439
		'www.veikkos-archiv.com',           // Veikkos-archiv - bug 69777
		'*.scienceimage.csiro.au',          // CSIRO - bug 70771
		'*.beeldbank.cultureelerfgoed.nl',  // Cultureel Erfgoed - bug 70840
		'*.metilli.com',                    // Mart Museum - bug 71460
		'*.nijmegen.nl',                    // Nijmegen - bug 71191
	),
),

'wgMaxUploadSize' => array(
	// Affects URL uploads and chunked uploads (experimental).
	// Limit on other web uploads is enforced by PHP.
	'default' => 1024 * 1024 * 1000, // 1000 MB
	'ptwiki'  => 1024 * 500, // 500 KB - https://bugzilla.wikimedia.org/23186
),

'wmgUsePdfHandler' => array (
	'default' => true, // brion -- 2009-08-25
	'loginwiki' => false,
	'votewiki' => false,
),

'wmgUseFooterContactLink' => array(
	// Make sure 'MediaWiki:Contact' and 'MediaWiki:Contact-url' are defined.
	'default' => false,
	'enwiki' => true,  // Bug 46392
),

'wmgUserDailyContribs' => array(
	// Actively used by researchers and analysts.
	// Contact person: Dario Taraborelli <dtaraborelli@wikimedia.org>
	'default'	=> true,
),

'wgMaxMsgCacheEntrySize' => array(
	'default' => 1024,
),

'wmgUseLocalisationUpdate' => array(
	'default' => true,
),

'wmgUseLiquidThreads' => array(
//
//  !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
//  Needs schema changes before it can be enabled. Ask Andrew for details
//  Better, don't add wikis here unless you are Andrew or he knows what you are doing.
//  !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
//
	'default' => false,
	'testwiki' => true, // Expanding out to testwiki -- Andrew 2009-10-13
	'enwikinews' => true, // Per bug 21956 -- Andrew 2009-02-09
	'enwiktionary' => true, // Bug 23417 -- ariel 2010-16-05
	'fiwikimedia' => true, // Bug 37778
	'huwiki' => true, // Bug 22909 -- Andrew 2010-09-06
	'mediawikiwiki' => true,
	'officewiki' => true, // Erik requested, by mail.
	'ptwikibooks' => true, // Bug 24143 -- Andrew 2010-08-16
	'strategywiki' => true, // Philippe says it's cool -- Andrew 2009-10-13
	'sewikimedia' => true, // Bug 24377 -- Andrew 2010-08-28
	'svwikisource' => true, // Bug 23220 -- Andrew 2010-08-28
	'test2wiki' => true,
	'wikimania2010wiki' => true, // Erik requested, by mail
),

'wmgLiquidThreadsOptIn' => array(
	'default' => true, // New wikis by default are opt-in per-page LiquidThreads
	// ---------
	'strategywiki' => false,
	'sewikimedia' => false, // Bug 46182
	'ptwikibooks' => false, // Bug 48578
),

'wmgLQTUserControlNamespaces' => array(
	'default' => null,
	'enwikinews' => array( 102 ), // Comments namespace
),

'wmgDonationInterface' => array(
	'default' => false,
	'testwiki' => true,
	'foundationwiki' => true,
	'donatewiki' => true,
),

'wmgUseGlobalUsage' => array(
	'default' => true, # Enabled on all PUBLIC wikis
	'closed' => false,
	'private' => false,
	'labswiki' => false,
),

'wgDisabledVariants' => array(
	'default' => array(),
	'zhwiki' => array( 'zh-my' ),
	'zhwikibooks' => array( 'zh-mo', 'zh-my' ),
	'zhwikinews' => array( 'zh-mo', 'zh-my' ),
	'zhwikiquote' => array( 'zh-mo', 'zh-my' ),
	'zhwikisource' => array( 'zh-cn', 'zh-hk', 'zh-mo', 'zh-my', 'zh-sg', 'zh-tw' ),
	'zhwiktionary' => array( 'zh-cn', 'zh-hk', 'zh-mo', 'zh-my', 'zh-sg', 'zh-tw' ),
),

'wmgUseWikimediaLicenseTexts' => array(
	'default' => false,
	'commonswiki' => true,
),

'wmgUseAPIRequestLog' => array(
	'default' => false,
),

'wgSearchSuggestCacheExpiry' => array(
	'default' => 10800,
),

'wgDisableHardRedirects' => array(
	'default' => true,
	'donatewiki' => false,
	'foundationwiki' => false,
),

'wmgUseLivePreview' => array(
	'default' => false,
	'testwiki' => true,
),

'wgRevokePermissions' => array(
	'tawiki' => array(
		'nocreate' => array( 'createpage' => true ),
	),
),

'wgArticleCountMethod' => array(
	'default' => 'link',
	'cswikinews' => 'any',        // Bug 43525
	'enwikibooks' => 'comma',     // Bug 27256
	'ptwikibooks' => 'comma',     // Bug 27256
	'guwikisource' => 'any',      // Bug 40173
),

'wgUseContributionTracking' => array(
	'default' => false,
	'donatewiki' => true,
	'foundationwiki' => true,
	'testwiki' => true,
),

'wmgUseMassMessage' => array(
	'default' => true,
	'loginwiki' => false,
	'votewiki' => false,
),

'wmgNamespacesToPostIn' => array(
	# Implicitly true for odd-numbered namespaces
	'default' => array( NS_PROJECT ),
	'+metawiki' => array( NS_MAIN )
),

'wmgAllowGlobalMessaging' => array(
	'default' => false,
	'metawiki' => true,
),

'wmgUseUploadWizard' => array(
	'default' => false,
	'rowiki' => true, // bug 59242
	'testwiki' => true,
	'test2wiki' => true,
	'commonswiki' => true,
	'donatewiki' => true,
	'foundationwiki' => true,
),


'wmgApiFrameOptions' => array(
	'default' => 'DENY',
	'enwiki' => 'SAMEORIGIN', // Bug 39877
),

'wmgAltUploadForm' => array( // bug 33513
	'default' => 'Special:Upload',
	'test2wiki' => 'Wikipedia:Upload',

	'commonswiki' => array(
		'default' => 'Commons:Upload',
		'ast' => 'Commons:Upload/ast',
		'be-tarask' => 'Commons:Upload/be-tarask',
		'bg' => 'Commons:Upload/bg',
		'bn' => 'Commons:Upload/bn',
		'ca' => 'Commons:Upload/ca',
		'cs' => 'Commons:Upload/cs',
		'da' => 'Commons:Upload/da',
		'de' => 'Commons:Hochladen',
		'el' => 'Commons:Upload/el',
		'en' => 'Commons:Upload',
		'eo' => 'Commons:Upload/eo',
		'es' => 'Commons:Upload/es',
		'et' => 'Commons:Upload/et',
		'eu' => 'Commons:Upload/eu',
		'ext' => 'Commons:Upload/ext',
		'fa' => 'Commons:Upload/fa',
		'fi' => 'Commons:Tallenna',
		'fo' => 'Commons:Upload/fo',
		'fr' => 'Commons:Téléverser',
		'fy' => 'Commons:Upload/fy',
		'gl' => 'Commons:Upload/gl',
		'he' => 'Commons:Upload/he',
		'hr' => 'Commons:Upload/hr',
		'hu' => 'Commons:Upload/hu',
		'hy' => 'Commons:Upload/hy',
		'is' => 'Commons:Upload/is',
		'it' => 'Commons:Upload/it',
		'ja' => 'Commons:Upload/ja',
		'ka' => 'Commons:Upload/ka',
		'km' => 'Commons:Upload/km',
		'ko' => 'Commons:Upload/ko',
		'ksh' => 'Commons:Upload/ksh',
		'ln' => 'Commons:Upload/ln',
		'lt' => 'Commons:Upload/lt',
		'mk' => 'Commons:Upload/mk',
		'ml' => 'Commons:Upload/ml',
		'mr' => 'Commons:Upload/mr',
		'nl' => 'Commons:Upload/nl',
		'no' => 'Commons:Upload/no',
		'pl' => 'Commons:Upload/pl',
		'pt' => 'Commons:Upload/pt',
		'pt-br' => 'Commons:Upload/pt-br',
		'ro' => 'Commons:Upload/ro',
		'ru' => 'Commons:Upload/ru',
		'sk' => 'Commons:Upload/sk',
		'sl' => 'Commons:Upload/sl',
		'sr' => 'Commons:Upload/sr',
		'sv' => 'Commons:Upload/sv',
		'th' => 'Commons:Upload/th',
		'tr' => 'Commons:Upload/tr',
		'uk' => 'Commons:Upload/uk',
		'vi' => 'Commons:Upload/vi',
		'yue' => 'Commons:Upload/yue',
		'zh' => 'Commons:Upload/zh-hans',
		'zh-hant' => 'Commons:Upload/zh-hant',
	),
),

'wmgUseMwEmbedSupport' => array(
	'default' => true,
	'labswiki' => false,
	'loginwiki' => false,
	'votewiki' => false,
),

// NOTE: TMH *requires* MwEmbedSupport to function
'wmgUseTimedMediaHandler' => array(
	'default' => true,
	'labswiki' => false,
	'loginwiki' => false,
	'votewiki' => false,
),

'wmgEnableLocalTimedText' => array(
	'default' => false,
	'commonswiki' => true,
	'enwiki' => true,
	'ptwiki' => true, // bug 58984
	'test2wiki' => true,
	'testwiki' => true,
	'foundationwiki' => true,
),

'wmgMinimumVideoPlayerSize' => array(
	'default' => 800,
),

// ----------- BetaFeatures start ----------
// Move things out of this when they're no longer in beta!

'wmgUseBetaFeatures' => array(
	'default' => true,
	'nonbetafeatures' => false,
	'labswiki' => false,
),

// Whitelist enablement of individual Beta Features for production; per-wiki
// configuration should happen below this. Next to each entry, please note the
// date 6 months after the last major change, which is the automatic cut-off.
//
// DO NOT add entries here without OK from Greg Grossmeier or James Forrester.
'wmgBetaFeaturesWhitelist' => array(
	'default' => array(
		'visualeditor-enable',                      // VisualEditor – on-going (special permission)
		'cirrussearch-default',                     // 2014-06-09 – New Seach
		'uls-compact-links',                        // 2014-09-06 – Compact language links
		'popups',                                   // 2014-09-18 – Hovercards
		'betafeatures-vector-compact-personal-bar', // 2014-11-01 – Compact personal bar
		'visualeditor-enable-language',             // 2014-11-01 — VE language editor
		'wikibase-otherprojects',                   // 2015-02-27 — Other projects sidebar (wikidata)
		'HHVM',                                     // 2015-03-18 - HHVM opt-in
	),
),

'wmgUseCommonsMetadata' => array(
	'default' => true,
	'nonbetafeatures' => false,
	'labswiki' => false,
),

'wmgCommonsMetadataSetTrackingCategories' => array(
	'default' => true,
),

// NOTE: Extension:Popups has a hard dependency on TextExtracts and PageImages.
// @todo The pattern "everywhere but loginwiki and votewiki" repeats 32 times in this file.
'wmgUsePopups' => array(
	'default' => true,
	'nonbetafeatures' => false,
),

'wmgUseVectorBeta' => array(
	'default' => true,
	'nonbetafeatures' => false,
),

'wmgVectorBetaPersonalBar' => array(
	'default' => true,
	'nonbetafeatures' => false,
),

'wmgULSCompactLinks' => array(
	'default' => true,
	'nonbetafeatures' => false,
),

// ------------ BetaFeatures end -----------

// -------------- Media Viewer configs --------------
'wmgUseMultimediaViewer' => array(
	'default' => true,
	'loginwiki' => false,
	'votewiki' => false,
	'private' => false,
),

'wmgMediaViewerEnableByDefault' => array(
	'default' => true,
	'commonswiki' => false, // bug 69363
),

'wmgMediaViewerEnableByDefaultForAnonymous' => array(
	'default' => true,
),

'wmgMediaViewerUseThumbnailGuessing' => array(
	'default' => true,
),

'wmgNetworkPerformanceSamplingFactor' => array(
	'default' => 10, // beta feature users do not generate enough data with 1:1000
	'mediaviewer' => 1000,
),

'wmgMediaViewerDurationLoggingSamplingFactor' => array(
	'default' => 10,
	'mediaviewer' => 1000,
),

'wmgMediaViewerAttributionLoggingSamplingFactor' => array(
	'default' => 1000,
),

'wmgMediaViewerDimensionLoggingSamplingFactor' => array(
	'default' => 1000,
),

'wmgMediaViewerActionLoggingSamplingFactorMap' => array(
	'default' => array( 'default' => 1 ),
	'mediaviewer' => array( 'default' => 1 ),
	'arwiki' => array(
		'default' => 1,
		'history-navigation' => 4,
		'image-view' => 19,
		'next-image' => 6,
		'prev-image' => 5,
		'thumbnail' => 6,
	),
	'bgwiki' => array(
		'default' => 1,
		'close' => 5,
		'history-navigation' => 3,
		'image-view' => 13,
		'next-image' => 4,
		'prev-image' => 2,
		'thumbnail' => 5,
	),
	'cawiki' => array(
		'default' => 1,
		'close' => 10,
		'history-navigation' => 6,
		'image-view' => 30,
		'next-image' => 9,
		'prev-image' => 4,
		'thumbnail' => 10,
	),
	'commonswiki' => array(
		'default' => 1,
		'close' => 250,
		'defullscreen' => 3,
		'file-description-page' => 2,
		'fullscreen' => 6,
		'hash-load'  => 15,
		'history-navigation' => 200,
		'image-view' => 1200,
		'metadata-close' => 3,
		'metadata-open' => 3,
		'next-image' => 600,
		'prev-image' => 150,
		'thumbnail' => 250,
		'use-this-file-open' => 3,
	),
	'cswiki' => array(
		'default' => 1,
		'close' => 100,
		'fullscreen' => 3,
		'history-navigation' => 50,
		'image-view' => 250,
		'next-image' => 80,
		'prev-image' => 25,
		'thumbnail' => 90,
	),
	'dawiki' => array(
		'default' => 1,
		'close' => 2,
		'image-view' => 4,
		'thumbnail' => 2,
	),
	'dewiki' => array(
		'default' => 1,
		'close' => 1200,
		'defullscreen' => 16,
		'enlarge' => 30,
		'fullscreen' => 25,
		'hash-load' => 30,
		'history-navigation' => 600,
		'image-view' => 3600,
		'metadata-close' => 12,
		'metadata-open' => 12,
		'next-image' => 1200,
		'prev-image' => 450,
		'terms-open' => 4,
		'thumbnail' => 1300,
		'use-this-file-open' => 4,
	),
	'elwiki' => array(
		'default' => 1,
		'close' => 3,
		'history-navigation' => 2,
		'image-view' => 8,
		'next-image' => 3,
		'thumbnail' => 3,
	),
	'enwiki' => array(
		'default' => 10,
		'close' => 4000,
		'defullscreen' => 45,
		'enlarge' => 40,
		'fullscreen' => 80,
		'hash-load' => 100,
		'history-navigation' => 1600,
		'image-view' => 10000,
		'metadata-close' => 80,
		'metadata-open' => 70,
		'next-image' => 2500,
		'prev-image' => 1000,
		'thumbnail' => 5000,
	),
	'eswiki' => array(
		'default' => 1,
		'close' => 600,
		'defullscreen' => 10,
		'enlarge' => 10,
		'fullscreen' => 20,
		'hash-load' => 15,
		'history-navigation' => 400,
		'image-view' => 1500,
		'metadata-close' => 30,
		'metadata-open' => 25,
		'next-image' => 600,
		'prev-image' => 250,
		'terms-open' => 2,
		'thumbnail' => 600,
		'use-this-file-open' => 2,
	),
	'etwiki' => array(
		'default' => 1,
		'close' => 4,
		'history-navigation' => 2,
		'image-view' => 7,
		'thumbnail' => 3,
	),
	'fawiki' => array(
		'default' => 1,
		'history-navigation' => 3,
		'image-view' => 13,
		'next-image' => 3,
		'prev-image' => 4,
		'thumbnail' => 5,
	),
	'fiwiki' => array(
		'default' => 1,
		'close' => 35,
		'history-navigation' => 10,
		'image-view' => 70,
		'next-image' => 10,
		'prev-image' => 6,
		'thumbnail' => 40,
	),
	'frwiki' => array(
		'default' => 1,
		'close' => 600,
		'defullscreen' => 9,
		'enlarge' => 8,
		'fullscreen' => 10,
		'hash-load' => 10,
		'history-navigation' => 350,
		'image-view' => 1000,
		'metadata-close' => 8,
		'metadata-open' => 8,
		'next-image' => 600,
		'prev-image' => 250,
		'thumbnail' => 500,
		'use-this-file-open' => 2,
	),
	'hewiki' => array(
		'default' => 1,
		'close' => 30,
		'history-navigation' => 10,
		'image-view' => 60,
		'next-image' => 12,
		'prev-image' => 10,
		'thumbnail' => 30,
	),
	'hiwiki' => array(
		'default' => 1,
		'close' => 2,
		'history-navigation' => 2,
		'image-view' => 6,
		'next-image' => 3,
		'thumbnail' => 2,
	),
	'hrwiki' => array(
		'default' => 1,
		'close' => 3,
		'history-navigation' => 2,
		'image-view' => 6,
		'next-image' => 2,
		'thumbnail' => 3,
	),
	'huwiki' => array(
		'default' => 1,
		'close' => 60,
		'fullscreen' => 2,
		'history-navigation' => 40,
		'image-view' => 200,
		'next-image' => 80,
		'prev-image' => 25,
		'thumbnail' => 60,
	),
	'idwiki' => array(
		'default' => 1,
		'close' => 7,
		'history-navigation' => 4,
		'image-view' => 17,
		'next-image' => 6,
		'prev-image' => 3,
		'thumbnail' => 8,
	),
	'itwiki' => array(
		'default' => 1,
		'close' => 300,
		'defullscreen' => 4,
		'enlarge' => 4,
		'fullscreen' => 8,
		'hash-load' => 8,
		'history-navigation' => 200,
		'image-view' => 1000,
		'metadata-close' => 4,
		'metadata-open' => 4,
		'next-image' => 400,
		'prev-image' => 120,
		'thumbnail' => 300,
	),
	'jawiki' => array(
		'default' => 1,
		'close' => 400,
		'defullscreen' => 4,
		'enlarge' => 4,
		'fullscreen' => 8,
		'hash-load' => 8,
		'history-navigation' => 200,
		'image-view' => 800,
		'metadata-close' => 2,
		'metadata-open' => 2,
		'next-image' => 200,
		'prev-image' => 80,
		'thumbnail' => 400,
	),
	'kawiki' => array(
		'default' => 1,
		'image-view' => 3,
	),
	'kowiki' => array(
		'default' => 1,
		'close' => 9,
		'history-navigation' => 2,
		'image-view' => 25,
		'next-image' => 5,
		'prev-image' => 2,
		'thumbnail' => 15,
	),
	'ltwiki' => array(
		'default' => 1,
		'close' => 2,
		'image-view' => 5,
		'thumbnail' => 2,
	),
	'nowiki' => array(
		'default' => 1,
		'close' => 3,
		'image-view' => 5,
		'thumbnail' => 3,
	),
	'nlwiki' => array(
		'default' => 1,
		'close' => 100,
		'defullscreen' => 2,
		'enlarge' => 2,
		'fullscreen' => 3,
		'hash-load' => 3,
		'history-navigation' => 70,
		'image-view' => 400,
		'metadata-close' => 2,
		'next-image' => 100,
		'prev-image' => 50,
		'thumbnail' => 100,
	),
	'plwiki' => array(
		'default' => 1,
		'close' => 300,
		'defullscreen' => 5,
		'enlarge' => 2,
		'fullscreen' => 9,
		'hash-load' => 6,
		'history-navigation' => 150,
		'image-view' => 800,
		'metadata-close' => 4,
		'metadata-open' => 4,
		'next-image' => 250,
		'prev-image' => 80,
		'thumbnail' => 300,
	),
	'ptwiki' => array(
		'default' => 1,
		'close' => 150,
		'defullscreen' => 3,
		'enlarge' => 2,
		'fullscreen' => 5,
		'hash-load' => 4,
		'history-navigation' => 100,
		'image-view' => 500,
		'metadata-close' => 5,
		'metadata-open' => 5,
		'next-image' => 150,
		'prev-image' => 70,
		'thumbnail' => 150,
	),
	'ruwiki' => array(
		'default' => 1,
		'close' => 1000,
		'defullscreen' => 10,
		'enlarge' => 6,
		'fullscreen' => 20,
		'hash-load' => 10,
		'history-navigation' => 200,
		'image-view' => 2000,
		'metadata-close' => 6,
		'metadata-open' => 6,
		'next-image' => 800,
		'prev-image' => 200,
		'thumbnail' => 1000,
	),
	'rowiki' => array(
		'default' => 1,
		'close' => 50,
		'hash-load' => 2,
		'history-navigation' => 40,
		'image-view' => 150,
		'next-image' => 60,
		'prev-image' => 20,
		'thumbnail' => 50,
	),
	'simplewiki' => array(
		'default' => 1,
		'image-view' => 3,
	),
	'skwiki' => array(
		'default' => 1,
		'close' => 20,
		'history-navigation' => 10,
		'image-view' => 40,
		'next-image' => 20,
		'prev-image' => 5,
		'thumbnail' => 20,
	),
	'srwiki' => array(
		'default' => 1,
		'close' => 5,
		'history-navigation' => 3,
		'image-view' => 14,
		'next-image' => 6,
		'prev-image' => 2,
		'thumbnail' => 4,
	),
	'svwiki' => array(
		'default' => 1,
		'close' => 40,
		'history-navigation' => 20,
		'image-view' => 90,
		'next-image' => 20,
		'prev-image' => 10,
		'thumbnail' => 40,
	),
	'thwiki' => array(
		'default' => 1,
		'close' => 30,
		'history-navigation' => 15,
		'image-view' => 50,
		'next-image' => 12,
		'prev-image' => 4,
		'thumbnail' => 25,
	),
	'trwiki' => array(
		'default' => 1,
		'close' => 10,
		'history-navigation' => 5,
		'image-view' => 25,
		'next-image' => 9,
		'prev-image' => 3,
		'thumbnail' => 11,
	),
	'ukwiki' => array(
		'default' => 1,
		'close' => 5,
		'history-navigation' => 3,
		'image-view' => 15,
		'next-image' => 6,
		'prev-image' => 2,
		'thumbnail' => 6,
	),
	'viwiki' => array(
		'default' => 1,
		'close' => 20,
		'history-navigation' => 20,
		'image-view' => 80,
		'next-image' => 25,
		'prev-image' => 10,
		'thumbnail' => 20,
	),
	'zhwiki' => array(
		'default' => 1,
		'close' => 64,
		'defullscreen' => 2,
		'fullscreen' => 3,
		'hash-load' => 2,
		'history-navigation' => 16,
		'image-view' => 140,
		'next-image' => 42,
		'prev-image' => 14,
		'thumbnail' => 80,
	),
),

// ----------------- ImageMetrics -----------------

'wmgUseImageMetrics' => array(
	'default' => false,
),

'wmgImageMetricsSamplingFactor' => array(
	'default' => 1000,
),

// -------------- VisualEditor start --------------

'wmgUseParsoid' => array(
	'default' => true,
	'labswiki' => false,
),

'wmgUseVisualEditor' => array(
	'default' => false,
	'visualeditor' => true,
),

// Namespaces for VisualEditor to be active in, as well as wgContentNamespaces
// NS_VISUALEDITOR is added in CommonSettings.php if wmgUseVisualEditorNamespace is true
'wmgVisualEditorNamespaces' => array(
	'default' => array( NS_USER, NS_FILE, NS_HELP, NS_CATEGORY ),
	// Test wikis
	'+mediawikiwiki' => array( NS_PROJECT, 100 /* Manual */, 102 /* Extension */, 104 /* API */, 106 /* Skin */ ), // Bug 48430
	// Special wikis
	'+commonswiki' => array( 100 /* Creator */, 106 /* Institution */ ), // Bug 65067
	'+metawiki' => array( 200 /* Grants */, 202 /* Research */, 204 /* Participation */, 206, 208 /* Programs */ ),
	// Wikipedias
	'+cawiki' => array( 100 /* Portal */, 102 /* Viquiprojecte */ ), // Bug 56000
	'+enwiki' => array( 100 /* Portal */, 108 /* Book */, 118 /* Draft */ ), // Bug 56001
	// Wiktionaries
	'svwiktionary' => array( NS_USER ), // Bug 57356
	// Wikiversities
	'+frwikiversity' => array( 104 ), // Bug 61874
	// Wikimedia wikis
	'+sewikimedia' => array( 100 /* Projekt */ ), // bug 60882
	// Private wikis
	'+officewiki' => array( 100 /* Report */ ),
),

// Whether to add $wgContentNamespaces to $wmgVisualEditorNamespaces above
'wmgVisualEditorInContentNamespaces' => array(
	'default' => true,
	'svwiktionary' => false,
),

// Should a namespace in which VisualEditor is enabled by default for all users (including anons)
'wmgUseVisualEditorNamespace' => array(
	'default' => false,
	'testwiki' => true,
	'mediawikiwiki' => true,
),

// Should VisualEditor be enabled for all users by default ('beta' mode)
'wmgVisualEditorDefault' => array(
	'default' => false,
	'visualeditor-default' => true,
),

// Should VisualEditor's "experimental" code be enabled for testing
'wmgVisualEditorExperimental' => array(
	'default' => false,
	'test2wiki' => true,
	'mediawikiwiki' => true,
),

'wmgUseTemplateData' => array(
	'default' => true,
	'labswiki' => false,
),

'wmgTemplateDataUseGUI' => array(
	'default' => false,
	'mediawikiwiki' => true,
	'arwiki' => true, // Bug 70217
	'bgwiki' => true, // Bug 70217
	'cawiki' => true, // Bug 65785
	'cebwiki' => true, // Bug 70217
	'cswiki' => true, // Bug 70217
	'dawiki' => true, // Bug 70217
	'dewiki' => true, // Bug 70217
	'enwiki' => true, // Bug 67376
	'eowiki' => true, // Bug 70217
	'eswiki' => true, // Bug 70217
	'euwiki' => true, // Bug 70217
	'fawiki' => true, // Bug 70217
	'fiwiki' => true, // Bug 68184
	'frwiki' => true, // Bug 67376
	'hewiki' => true, // Bug 66538
	'hrwiki' => true, // Bug 70217
	'huwiki' => true, // Bug 70217
	'idwiki' => true, // Bug 70217
	'itwiki' => true, // Bug 67376
	'jawiki' => true, // Bug 70217
	'kkwiki' => true, // Bug 70217
	'kowiki' => true, // Bug 70217
	'ltwiki' => true, // Bug 70217
	'minwiki' => true, // Bug 70217
	'mswiki' => true, // Bug 70217
	'nlwiki' => true, // Bug 68795
	'nowiki' => true, // Bug 70216
	'plwiki' => true, // Bug 70217
	'ptwiki' => true, // Bug 66255
	'rowiki' => true, // Bug 70217
	'ruwiki' => true, // Bug 67704
	'shwiki' => true, // Bug 70217
	'skwiki' => true, // Bug 70217
	'srwiki' => true, // Bug 70217
	'svwiki' => true, // Bug 70217
	'trwiki' => true, // Bug 70217
	'ukwiki' => true, // Bug 70217
	'viwiki' => true, // Bug 70217
	'warwiki' => true, // Bug 70217
	'zhwiki' => true, // Bug 70217
),

// Bug 50000 - Disable for logged-out users if wmgVisualEditorDefault is true
// This is a temporary variable for roll-out, to be removed once complete.
// If a wiki was previously enabled by default for all users but then disabled,
// this will need to be set true for 30 days (anon cache epoch).
'wmgVisualEditorDisableForAnons' => array(
	'default' => false,
),

// Should VisualEditor's "beta welcome" be shown
'wmgVisualEditorShowBetaWelcome' => array(
	'default' => true,
),

// Should VisualEditor's tab and section link come second behind those for wikitext?
'wmgVisualEditorSecondaryTabs' => array(
	'default' => false,
	'enwiki' => true,
	'eswiki' => true, // bug 60188
	'hewiki' => true, // bug 52552
),

// Should VisualEditor's tab and section link have a "beta" superscript note?
'wmgVisualEditorBetaInTab' => array(
	'default' => false,
	'enwiki' => true,
),

// Should VisualEditor forward users' Cookie: headers to Parsoid (for private wikis)
'wmgVisualEditorParsoidForwardCookies' => array(
	'default' => false,
	'private' => true,
),

// Should VisualEditor display a live version of the Table of Contents as you edit
'wmgVisualEditorEnableTocWidget' => array(
	'default' => false,
),

// --------------- VisualEditor end ---------------

'wmgUseRSSExtension' => array(
	'default' => false,
	'foundationwiki' => true,
	'mediawikiwiki' => true,
	'uawikimedia' => true,
),
'wmgRSSUrlWhitelist' => array(
	'default' => array(),  // as of Ext:RSS v2, this means no URLs are allowed.
	'uawikimedia' => array( 'http://wikimediaukraine.wordpress.com/feed/' ),
	'foundationwiki' => array(
		'http://blog.wikimedia.org/feed/',
		'http://blog.wikimedia.org/c/our-wikis/wikimediacommons/feed/',
		'http://blog.wikimedia.org/c/communications/picture-of-the-day/feed/',
	),
	'mediawikiwiki' => array(
		'http://blog.wikimedia.org/feed/',
		'https://git.wikimedia.org/feed/mediawiki/extensions/Translate.git',
		'https://mingle.corp.wikimedia.org/projects/analytics/feeds/8z8k6vUfniLmWc2qGe6GMQsxBujvKRKuybLd8mdTbMFHwGfLH3oxK*MU0E8zM6go.atom',
		'https://bugzilla.wikimedia.org/buglist.cgi?bug_status=UNCONFIRMED&bug_status=NEW&bug_status=ASSIGNED&bug_status=PATCH_TO_REVIEW'
			. '&bug_status=REOPENED&bug_status=VERIFIED&f1=keywords&list_id=288958&o1=substring&order=changeddate%20DESC%2Cbug_status%2Cpriority%2Cassigned_to%2Cbug_id'
			. '&query_based_on=&query_format=advanced&title=Bug%20List&v1=hhvm&ctype=atom',
	),
),

'wmgUseDoubleWiki' => array(
	'default' => false,
	'wikisource' => true,
	'sourceswiki' => true,
	'frwiktionary' => true,
	'frwikiversity' => true,
	'fawiki' => true,
	'testwiki' => true,
),

'wgCategoryCollation' => array(
	'default' => 'uppercase',
	// Multilingual wikis
	'mediawikiwiki' => 'uca-default',
	// Single-language wikis
	'be_x_oldwiki' => 'uca-be-tarask', // bug 46005
	'bewiki' => 'uca-be', // bug 46004
	'bewikisource' => 'uca-be', // bug 46004
	'ckbwiki' => 'xx-uca-ckb', // bug 55630
	'cswiki' => 'uca-cs', // bug 64885
	'cywiki' => 'uca-cy', // bug 59800
	'cywikibooks' => 'uca-cy', // bug 59800
	'cywikiquote' => 'uca-cy', // bug 59800
	'cywikisource' => 'uca-cy', // bug 59800
	'cywiktionary' => 'uca-cy', // bug 59800
	'etwiki' => 'xx-uca-et', // bug 54168
	'etwikibooks' => 'xx-uca-et', // bug 54168
	'etwikimedia' => 'xx-uca-et', // bug 54168
	'etwikiquote' => 'xx-uca-et', // bug 54168
	'etwikisource' => 'xx-uca-et', // bug 54168
	'etwiktionary' => 'xx-uca-et', // bug 54168
	'fawiki' => 'uca-fa', //bug 50311
	'fawikisource' => 'uca-fa', //bug 50311
	'fawiktionary' => 'uca-fa', //bug 50311
	'fawikibooks' => 'uca-fa', //bug 50311
	'fawikinews' => 'uca-fa', //bug 50311
	'fawikiquote' => 'uca-fa', //bug 50311
	'fiwiki' => 'uca-fi', // bug 46330
	'fiwikibooks' => 'uca-fi', // bug 46330
	'fiwikimedia' => 'uca-fi', // bug 46330
	'fiwikinews' => 'uca-fi', // bug 46330
	'fiwikiquote' => 'uca-fi', // bug 46330
	'fiwikisource' => 'uca-fi', // bug 46330
	'fiwikiversity' => 'uca-fi', // bug 46330
	'frwiki' => 'uca-fr', // bug 54680
	'frwikinews' => 'uca-fr', // bug 66165
	'frwikiversity' => 'uca-fr', // bug 69782
	'huwiki' => 'uca-hu', // bug 45596
	'iswiki' => 'uca-is', // bug 56859
	'iswiktionary' => 'identity', // bug 30722
	'lvwiki' => 'uca-lv', // bug 65003
	'plwiki' => 'uca-pl', // bug 42413
	'plwikivoyage' => 'uca-pl', // bug 45968
	'plwiktionary' => 'uca-default', // bug 46081
	'ptwiki' => 'uca-pt', // bug 45911
	'ptwikibooks' => 'uca-pt', // bug 45911
	'ruwiki' => 'uca-ru', // bug 52997
	'ruwikibooks' => 'uca-ru', // bug 52997
	'ruwikinews' => 'uca-ru', // bug 52997
	'ruwikiquote' => 'uca-ru', // bug 52997
	'ruwikisource' => 'uca-ru', // bug 52997
	'ruwikiversity' => 'uca-ru', // bug 52997
	'ruwikivoyage' => 'uca-ru', // bug 52997
	'ruwiktionary' => 'uca-ru', // bug 52997
	'shwiki' => 'uca-hr', // bug 67287
	'skwiki' => 'uca-sk', // [[w:sk:Special:PermaLink/5785371]]
	'svwiki' => 'uca-sv', // bug 45446
	'svwikisource' => 'uca-sv@collation=standard', // bug 46058
	'thwikibooks' => 'uca-default', // bug 48097
	'thwikinews' => 'uca-default', // bug 48097
	'thwiki' => 'uca-default', // bug 48097
	'thwikiquote' => 'uca-default', // bug 48097
	'thwikisource' => 'uca-default', // bug 48097
	'thwiktionary' => 'uca-default', // bug 48097
	'uawikimedia' => 'uca-uk', // bug 45776
	'ukwiki' => 'uca-uk', // bug 45444
	'ukwikibooks' => 'uca-uk', // bug 45776
	'ukwikinews' => 'uca-uk', // bug 45776
	'ukwikiquote' => 'uca-uk', // bug 45776
	'ukwikisource' => 'uca-uk', // bug 45776
	'ukwikivoyage' => 'uca-uk', // bug 46417
	'ukwiktionary' => 'uca-uk', // bug 45776
	'viwiki' => 'uca-vi', // bug 45979
	'viwikibooks' => 'uca-vi', // bug 45979
	'viwikiquote' => 'uca-vi', // bug 45979
	'viwikisource' => 'uca-vi', // bug 45979
	'viwikivoyage' => 'uca-vi', // bug 53616
	'viwiktionary' => 'uca-vi', // bug 45979
),

'wmgUsePoolCounter' => array(
	'default' => true,
),

'wmgUseGoogleNewsSitemap' => array(
	'default' => false,
	'wikinews' => true,
	'testwiki' => true,
),
'wmgGNSMfallbackCategory' => array(
	'default' => 'Published',
	'elwikinews' => 'Δημοσιευμένα',
	'fawikinews' => 'منتشرشده',
),
'wmgGNSMcommentNamespace' => array(
	'default' => true,
	'elwikinews' => true,
	'fawikinews' => 102,
),

'wmgUseCLDR' => array(
	'default' => true,
	'testwiki' => true,
),

'wgParserCacheType' => array(
	'default' => 'mysql-multiwrite',
	'labswiki' => 'memcached-pecl',
),

'wgLanguageConverterCacheType' => array(
	'default' => CACHE_ACCEL,
),

'wmgPFEnableStringFunctions' => array(
	'default' => false,
	'donatewiki' => true,
),

'wgUploadMissingFileUrl' => array(
	'default' => false,
	'enwiki' => '//en.wikipedia.org/wiki/Special:Upload',
	'incubatorwiki' => '//commons.wikimedia.org/wiki/Special:Upload',
	'nlwiki' => '//commons.wikimedia.org/wiki/Special:Upload?uselang=nl',
	'nlwikisource' => '//commons.wikimedia.org/wiki/Special:Upload?uselang=nl',
	'nlwikiquote' => '//commons.wikimedia.org/wiki/Special:Upload?uselang=nl',
	'nlwiktionary' => '//commons.wikimedia.org/wiki/Special:Upload?uselang=nl',
	'ptwikibooks' => '//commons.wikimedia.org/wiki/Special:Upload/pt?uselang=pt',
),

// DO NOT DISABLE WITHOUT CONTACTING PHILIPPE / LEGAL!
// Installed by Andrew, 2011-04-26
'wmgUseDisableAccount' => array(
	'default' => false,
	'arbcom_enwiki' => true,
	'checkuserwiki' => true,
	'legalteamwiki' => true,
	'ombudsmenwiki' => true,
	'stewardwiki' => true,
),

'wmgCheckUserForceSummary' => array(
	'default' => false,
	'enwiki' => true,
),

'wmgUseIncubator' => array(
	'default' => false,
	'incubatorwiki' => true,
),

'wmgUseWikiLove' => array(
	'default' => false,
	'arwiki' => true,
	'commonswiki' => true,
	'enwiki' => true,
	'enwikivoyage' => true, // bug 50063
	'fawiki' => true, // bug 33541
	'fawiktionary' => true, // bug 33541
	'hewiki' => true,
	'hiwiki' => true,
	'huwiki' => true, // bug 30417
	'incubatorwiki' => true, // bug 31209
	'iswiki' => true, // Bug 43760
	'itwikiquote' => true, // bug 40628
	'itwikivoyage' => true, // bug 43274
	'jawiki' => true, // bug 32312
	'kowiki' => true, // bug 55914
	'mediawikiwiki' => true,
	'mkwiki' => true, // bug 31831
	'mlwiki' => true, // bug 30500
	'nowiki' => true, // bug 30794
	'officewiki' => true,
	'orwiki' => true, // bug 31172
	'ptwiki' => true, // bug 31178
	'sewikimedia' => true, // bug 30491
	'siwiki' => true, // bug 33485
	'srwiki' => true, // bug 35913
	'svwiki' => true, // bug 30756
	'svwikinews' => true, // bug 31754
	'testwiki' => true,
	'trwiki' => true, // bug 38227
	'urwiki' => true, // bug 40848
	'viwiki' => true, // bug 48878
	'labswiki' => true,
	'zhwiki' => true, // bug 30362
),
'wmgWikiLoveDefault' => array(
	'default' => true,
),

'wmgUseMath' => array(
	'default' => true, // moved from MW core
	'loginwiki' => false,
	'labswiki' => false,
),

'wmgUseMarkAsHelpful' => array(
	'default' => false,
	'testwiki' => true,
	# 'incubatorwiki' => true,
	# 'nlwiki' => true,
	# 'sewikimedia' => true,
),

'wmgUseMoodBar' => array(
	'default' => false,
	'testwiki' => true,
	'frwikisource' => true, // bug 34618
	'incubatorwiki' => true, // bug 32417
	'nlwiki' => true, // bug 32202
	'sewikimedia' => true, // bug 32757
//	'tawiki' => true, // bug 34560 // Disable due to bug 34615
),
'wmgMoodBarInfoUrl' => array(
	'default' => '//www.mediawiki.org/wiki/MoodBar',
	'frwikisource' => '//fr.wikisource.org/wiki/Wikisource:MoodBar',
	'itwikivoyage' => '//it.wikivoyage.org/wiki/Wikivoyage:MoodBar',
	'nlwiki' => '//nl.wikipedia.org/wiki/Help:Feedback',
),
'wmgMoodBarCutoffTime' => array(
	'default' => '20110725221004',
	'frwikisource' => '20110304202000',
),
'wmgMoodBarEnableTooltip' => array(
	'default' => true,
	'testwiki' => false,
	'test2wiki' => false,
),
'wmgUseMobileApp' => array(
	'default' => true,
	'labswiki' => false,
),
'wmgMobileFrontend' => array(
	'default' => true,
	'labswiki' => false,
	'wikidata' => false, // Disabled due to lack of mobile domain setup
),
'wmgEnableTextExtracts' => array(
	'default' => true,
),
'wmgExtractsRemoveClasses' => array(
	'default' => array(
		// This is a good thing to remove in any case
		'.metadata',
		// b/c rules, @todo: consider just whacking class="noexcerpt" on these
		'span.coordinates', 'span.geo-multi-punct', 'span.geo-nondefault', '#coordinates',
	),
),

'wmgZeroBanner' => array(
	'default' => false,
	'wiki' => true,
	'wikidatawiki' => false, // safety
	'metawiki' => false,
	'zerowiki' => false,
),

'wmgZeroPortal' => array(
	'default' => false,
	'metawiki' => true,
	'zerowiki' => true,
),

'wmgUseGraph' => array(
	'default' => false,
	'collabwiki' => true,
	'labswiki' => true,
	'mediawikiwiki' => true,
	'metawiki' => true,
	'outreachwiki' => true,
	'zerowiki' => true,
),

'wmgUseSubPageList3' => array(
	'default' => false,
	'testwiki' => true,
	'wikiversity' => true,
	'cswiktionary' => true, // bug 38903
),

'wmgShowHiddenCats' => array(
	'default' => false,
	'commonswiki' => true,
),

'wmgMobileFrontendLogo' => array(
	'default' => '/images/mobile/wikimedia.png',
	'wiki' => '/images/mobile/W.png',
	'wikinews' => '/images/mobile/wikinews.png',
	'wiktionary' => '/images/mobile/wiktionary.png',
	'wikibooks' => '/images/mobile/wikibooks.png',
	'wikiversity' => '/images/mobile/wikiversity.png',
	'specieswiki' => '/images/mobile/wikispecies.png',
	'commonswiki' => '/images/mobile/commons.png',
	'wikiquote' => '/images/mobile/wikiquote.png',
	'metawiki' => '/images/mobile/meta.png',
	'wikisource' => '/images/mobile/wikisource.png',
),
'wmgMobileUrlTemplate' => array(
	'default' => '%h0.m.%h1.%h2',
	'foundationwiki' => 'm.%h0.%h1',
	'mediawikiwiki' => 'm.%h1.%h2',
	'sourceswiki' => 'm.%h0.%h1', // bug 36002
),

'wmgMFCustomLogos' => array(
	'default' => array(),
	'enwiki' => array(
		'copyright' => '{wgExtensionAssetsPath}/MobileFrontend/images/logo-copyright-en.png'
	),
	'testwiki' => array(
		'copyright' => '{wgExtensionAssetsPath}/MobileFrontend/images/logo-copyright-en.png'
	),
),
'wmgMFEnableDesktopResources' => array(
	'default' => true,
),
'wmgMFPhotoUploadEndpoint' => array(
	'default' => '//commons.m.wikimedia.org/w/api.php',
	'commonswiki' => '', # bug 45256
	'test2wiki' => '',
	'private' => '',
	'fishbowl' => '',
),
'wmgMFContentNamespace' => array(
	'default' => NS_MAIN,
	'commonswiki' => NS_FILE,
),
'wmgMFUseCentralAuthToken' => array(
	'default' => true,
),
'wmgMFNearby' => array(
	'default' => true, // Does not gets enabled on wikis w/o GeoData anyway
),
'wmgMFPhotoUploadWiki' => array(
	'default' => 'commonswiki',
	'test2wiki' => '',
),
'wmgMFPhotoUploadAppendToDesc' => array(
	'default' => "{{Uploaded from Mobile|platform=Web|version=}}\n{{subst:unc}}",
),
'wmgMFEnableXAnalyticsLogging' => array(
	'default' => true,
),
'wmgMFEnableSiteNotice' => array(
	'default' => false,
),
'wmgMFAppPackageId' => array(
	'default' => false,
	'wiki' => 'org.wikipedia',
),

# trademark status
'wmgMFTrademarkSitename' => array(
	'default' => true,
	'metawiki' => false, // bug 41141
),
'wmgMFNoMobileCategory' => array(
	'default' => false,
	'foundationwiki' => 'Desktop-only_pages',
),
'wmgMFNoMobilePages' => array(
	'default' => array(),
	'foundationwiki' => array( 'Special:FundraiserStatistics' ),
),
'wmgMFCollapseSectionsByDefault' => array(
	'default' => true,
	'wiktionary' => false,
),
'wmgMFRemovePageActions' => array(
	'default' => array( 'upload' ),
	'wikisource' => array( 'upload' ), # https://bugzilla.wikimedia.org/show_bug.cgi?id=66958
),
'wmgMFUploadMinEdits' => array(
	'default' => 10,
	'commonswiki' => 75, // https://bugzilla.wikimedia.org/show_bug.cgi?id=62598
),
'wmgMFEnableWikiGrok' => array(
	'default' => false,
	'testwiki' => true,
	'enwiki' => true, // prototype version is for en.wiki only
),

'wgExtraGenderNamespaces' => array(
	'default' => array(),
	'cswiki' => array(
		NS_USER => array( 'male' => 'Wikipedista', 'female' => 'Wikipedistka' ),
		NS_USER_TALK => array( 'male' => 'Diskuse_s_wikipedistou', 'female' => 'Diskuse_s_wikipedistkou' ),
	),
	'plwiki' => array(
		NS_USER => array( 'male' => 'Wikipedysta', 'female' => 'Wikipedystka' ),
		NS_USER_TALK => array( 'male' => 'Dyskusja_wikipedysty', 'female' => 'Dyskusja_wikipedystki' )
	),
	'plwikinews' => array(
		NS_USER => array( 'male' => 'Wikireporter', 'female' => 'Wikireporterka' ),
		NS_USER_TALK => array( 'male' => 'Dyskusja_wikireportera', 'female' => 'Dyskusja_wikireporterki' ),
	),
	'plwiktionary' => array(
		NS_USER => array( 'male' => 'Wikipedysta', 'female' => 'Wikipedystka' ),
		NS_USER_TALK => array( 'male' => 'Dyskusja_wikipedysty', 'female' => 'Dyskusja_wikipedystki' ),
	),
	'ptwiki' => array(
		NS_USER => array( 'male' => 'Usuário', 'female' => 'Usuária' ),
		NS_USER_TALK => array( 'male' => 'Usuário_Discussão', 'female' => 'Usuária_Discussão' ),
	),
	'test2wiki' => array( NS_USER => array( 'male' => 'Male_user', 'female' => 'Female_user' ) ),
),

'wmgUseBabel' => array(
	'default' => true,
	'loginwiki' => false,
	'votewiki' => false,
),
'wmgBabelCategoryNames' => array(
	'default' => array(
		'0' => false,
		'1' => false,
		'2' => false,
		'3' => false,
		'4' => false,
		'5' => false,
		'N' => false,
	),
	'betawikiversity' => array( // bug 64168
		'0' => 'User %code%-0',
		'1' => 'User %code%-1',
		'2' => 'User %code%-2',
		'3' => 'User %code%-3',
		'4' => 'User %code%-4',
		'5' => 'User %code%-5',
		'N' => 'User %code%-N',
	),
	'cawiki' => array(
		'0' => false,
		'1' => 'Usuaris %code%-1',
		'2' => 'Usuaris %code%-2',
		'3' => 'Usuaris %code%-3',
		'4' => 'Usuaris %code%-4',
		'5' => false,
		'N' => 'Usuaris %code%-N',
	),
	'cawiktionary' => array( // bug 47287
		'0' => false,
		'1' => 'Usuaris %code%-1',
		'2' => 'Usuaris %code%-2',
		'3' => 'Usuaris %code%-3',
		'4' => 'Usuaris %code%-4',
		'5' => false,
		'N' => 'Usuaris %code%-N',
	),
	'commonswiki' => array(
		'0' => 'User %code%-0',
		'1' => 'User %code%-1',
		'2' => 'User %code%-2',
		'3' => 'User %code%-3',
		'4' => 'User %code%-4',
		'5' => false,
		'N' => 'User %code%-N',
	),
	'dewiki' => array(
		'0' => false,
		'1' => 'User %code%-1',
		'2' => 'User %code%-2',
		'3' => 'User %code%-3',
		'4' => 'User %code%-4',
		'5' => false,
		'N' => 'User %code%-M',
	),
	'enwiki' => array(
		'0' => false,
		'1' => 'User %code%-1',
		'2' => 'User %code%-2',
		'3' => 'User %code%-3',
		'4' => 'User %code%-4',
		'5' => 'User %code%-5',
		'N' => 'User %code%-N',
	),
	'enwiktionary' => array(
		'0' => false,
		'1' => 'User %code%-1',
		'2' => 'User %code%-2',
		'3' => 'User %code%-3',
		'4' => 'User %code%-4',
		'5' => false,
		'N' => 'User %code%-N',
	),
	'enwikiquote' => array(
		'0' => false,
		'1' => 'User %code%-1',
		'2' => 'User %code%-2',
		'3' => 'User %code%-3',
		'4' => 'User %code%-4',
		'5' => 'User %code%-5',
		'N' => 'User %code%-N',
	),
	'enwikisource' => array(
		'0' => false,
		'1' => 'User %code%-1',
		'2' => 'User %code%-2',
		'3' => 'User %code%-3',
		'4' => 'User %code%-4',
		'5' => false,
		'N' => 'User %code%-N',
	),
	'enwikinews' => array(
		'0' => false,
		'1' => 'User %code%-1',
		'2' => 'User %code%-2',
		'3' => 'User %code%-3',
		'4' => 'User %code%-4',
		'5' => false,
		'N' => 'User %code%-N',
	),
	'enwikiversity' => array(
		'0' => 'User %code%-0',
		'1' => 'User %code%-1',
		'2' => 'User %code%-2',
		'3' => 'User %code%-3',
		'4' => 'User %code%-4',
		'5' => false,
		'N' => 'User %code%-N',
	),
	'eowiktionary' => array( // bug 61116
		'0' => 'Vikivortaristo %code%-0',
		'1' => 'Vikivortaristo %code%-1',
		'2' => 'Vikivortaristo %code%-2',
		'3' => 'Vikivortaristo %code%-3',
		'4' => 'Vikivortaristo %code%-4',
		'5' => false,
		'N' => 'Vikivortaristo %code%-D',
	),
	'eswiki' => array(
		'0' => false,
		'1' => 'Wikipedia:Wikipedistas con nivel básico de %wikiname%',
		'2' => 'Wikipedia:Wikipedistas con nivel intermedio de %wikiname%',
		'3' => 'Wikipedia:Wikipedistas con nivel avanzado de %wikiname%',
		'4' => 'Wikipedia:Wikipedistas con nivel experto de %wikiname%',
		'5' => 'Wikipedia:Wikipedistas con nivel profesional de %wikiname%',
		'N' => 'Wikipedia:Wikipedistas con nivel nativo de %wikiname%',
	),
	'eswikibooks' => array(
		'0' => false,
		'1' => false,
		'2' => false,
		'3' => false,
		'4' => false,
		'5' => false,
		'N' => false,
	),
	'eswikinews' => array(
		'0' => 'Usuario %code%-0',
		'1' => 'Usuario %code%-1',
		'2' => 'Usuario %code%-2',
		'3' => 'Usuario %code%-3',
		'4' => 'Usuario %code%-4',
		'5' => false,
		'N' => 'Usuario %code%-N',
	),
	'eswikivoyage' => array( // bug 52309
		'0' => 'Usuario %code%-0',
		'1' => 'Usuario %code%-1',
		'2' => 'Usuario %code%-2',
		'3' => 'Usuario %code%-3',
		'4' => 'Usuario %code%-4',
		'5' => 'Usuario %code%-5',
		'N' => 'Usuario %code%-N',
	),
	'fiwiki' => array(
		'0' => false,
		'1' => 'User %code%-1',
		'2' => 'User %code%-2',
		'3' => 'User %code%-3',
		'4' => 'User %code%-4',
		'5' => false,
		'N' => 'User %code%-N',
	),
	'fowiki' => array(
		'0' => false,
		'1' => 'Brúkari %code%-1',
		'2' => 'Brúkari %code%-2',
		'3' => 'Brúkari %code%-3',
		'4' => 'Brúkari %code%-4',
		'5' => 'Brúkari %code%-5',
		'N' => 'Brúkari %code%-N',
	), // Bug 37401
	'frwiki' => array(
		'0' => 'Utilisateur %code%-0',
		'1' => 'Utilisateur %code%-1',
		'2' => 'Utilisateur %code%-2',
		'3' => 'Utilisateur %code%-3',
		'4' => 'Utilisateur %code%-4',
		'5' => false,
		'N' => 'Utilisateur %code%-M',
	),
	'frwikiquote' => array( // Bug 39472
		'0' => 'Utilisateur %code%-0',
		'1' => 'Utilisateur %code%-1',
		'2' => 'Utilisateur %code%-2',
		'3' => 'Utilisateur %code%-3',
		'4' => 'Utilisateur %code%-4',
		'5' => 'Utilisateur %code%-5',
		'N' => 'Utilisateur %code%-M',
	),
	'frwikisource' => array(
		'0' => 'Utilisateurs %code%-0',
		'1' => 'Utilisateurs %code%-1',
		'2' => 'Utilisateurs %code%-2',
		'3' => 'Utilisateurs %code%-3',
		'4' => 'Utilisateurs %code%-4',
		'5' => false,
		'N' => 'Utilisateurs %code%-M',
	),
	'frwiktionary' => array(
		'0' => 'Utilisateurs %code%-0',
		'1' => 'Utilisateurs %code%-1',
		'2' => 'Utilisateurs %code%-2',
		'3' => 'Utilisateurs %code%-3',
		'4' => 'Utilisateurs %code%-4',
		'5' => false,
		'N' => 'Utilisateurs %code%-M',
	),
	'ilowiki' => array( // Bug 37981
		'0' => false,
		'1' => 'Agar-aramat %code%-1',
		'2' => 'Agar-aramat %code%-2',
		'3' => 'Agar-aramat %code%-3',
		'4' => 'Agar-aramat %code%-4',
		'5' => 'Agar-aramat %code%-5',
		'N' => 'Agar-aramat %code%-N',
	),
	'incubatorwiki' => array(
		'0' => 'Users:By language:%code%-0',
		'1' => 'Users:By language:%code%-1',
		'2' => 'Users:By language:%code%-2',
		'3' => 'Users:By language:%code%-3',
		'4' => 'Users:By language:%code%-4',
		'5' => 'Users:By language:%code%-5',
		'N' => 'Users:By language:%code%-N',
	),
	'iswiki' => array(
		'0' => 'Notandi %code%-0',
		'1' => 'Notandi %code%-1',
		'2' => 'Notandi %code%-2',
		'3' => 'Notandi %code%-3',
		'4' => 'Notandi %code%-4',
		'5' => 'Notandi %code%-5',
		'N' => 'Notandi %code%-M',
	),
	'itwiki' => array(
		'0' => 'Utenti %code%-0',
		'1' => 'Utenti %code%-1',
		'2' => 'Utenti %code%-2',
		'3' => 'Utenti %code%-3',
		'4' => 'Utenti %code%-4',
		'5' => false,
		'N' => 'Utenti %code%-M',
	),
	'itwiktionary' => array(
		'0' => 'Utenti %code%-0',
		'1' => 'Utenti %code%-1',
		'2' => 'Utenti %code%-2',
		'3' => 'Utenti %code%-3',
		'4' => 'Utenti %code%-4',
		'5' => false,
		'N' => 'Utenti %code%-M',
	),
	'itwikibooks' => array(
		'0' => 'Utenti %code%-0',
		'1' => 'Utenti %code%-1',
		'2' => 'Utenti %code%-2',
		'3' => 'Utenti %code%-3',
		'4' => 'Utenti %code%-4',
		'5' => false,
		'N' => 'Utenti %code%-M',
	),
	'itwikinews' => array(
		'0' => 'Utenti %code%-0',
		'1' => 'Utenti %code%-1',
		'2' => 'Utenti %code%-2',
		'3' => 'Utenti %code%-3',
		'4' => 'Utenti %code%-4',
		'5' => false,
		'N' => 'Utenti %code%-M',
	),
	'itwikiquote' => array(
		'0' => 'Utenti %code%-0',
		'1' => 'Utenti %code%-1',
		'2' => 'Utenti %code%-2',
		'3' => 'Utenti %code%-3',
		'4' => 'Utenti %code%-4',
		'5' => false,
		'N' => 'Utenti %code%-M',
	),
	'itwikisource' => array(
		'0' => 'Utenti %code%-0',
		'1' => 'Utenti %code%-1',
		'2' => 'Utenti %code%-2',
		'3' => 'Utenti %code%-3',
		'4' => 'Utenti %code%-4',
		'5' => false,
		'N' => 'Utenti %code%-M',
	),
	'itwikiversity' => array(
		'0' => 'Utenti %code%-0',
		'1' => 'Utenti %code%-1',
		'2' => 'Utenti %code%-2',
		'3' => 'Utenti %code%-3',
		'4' => 'Utenti %code%-4',
		'5' => false,
		'N' => 'Utenti %code%-M',
	),
	'itwikivoyage' => array(
		'0' => 'Utenti %code%-0',
		'1' => 'Utenti %code%-1',
		'2' => 'Utenti %code%-2',
		'3' => 'Utenti %code%-3',
		'4' => 'Utenti %code%-4',
		'5' => false,
		'N' => 'Utenti %code%-M',
	),
	'jawiki' => array(
		'0' => false,
		'1' => 'User %code%-1',
		'2' => 'User %code%-2',
		'3' => 'User %code%-3',
		'4' => 'User %code%-4',
		'5' => false,
		'N' => 'User %code%-N',
	),
	'lawiki' => array(
		'0' => false,
		'1' => 'Usores %code%-1',
		'2' => 'Usores %code%-2',
		'3' => 'Usores %code%-3',
		'4' => 'Usores %code%-4',
		'5' => false,
		'N' => 'Usores %code%-N',
	),
	'minwiki' => array(
		'0' => 'Pengguna %code%-0',
		'1' => 'Pengguna %code%-1',
		'2' => 'Pengguna %code%-2',
		'3' => 'Pengguna %code%-3',
		'4' => 'Pengguna %code%-4',
		'5' => 'Pengguna %code%-5',
		'N' => 'Pengguna %code%-M',
	),
	'nlwiki' => array(
		'0' => false,
		'1' => 'Wikipedia:Gebruiker %code%-1',
		'2' => 'Wikipedia:Gebruiker %code%-2',
		'3' => 'Wikipedia:Gebruiker %code%-3',
		'4' => 'Wikipedia:Gebruiker %code%-4',
		'5' => false,
		'N' => 'Wikipedia:Gebruiker %code%-M',
	),
	'nowiki' => array(
		'0' => 'Bruker %code%-0',
		'1' => 'Bruker %code%-1',
		'2' => 'Bruker %code%-2',
		'3' => 'Bruker %code%-3',
		'4' => 'Bruker %code%-4',
		'5' => false,
		'N' => 'Bruker %code%-N',
	),
	'oswiki' => array(
		'0' => 'Архайджытæ %code%-0',
		'1' => 'Архайджытæ %code%-1',
		'2' => 'Архайджытæ %code%-2',
		'3' => 'Архайджытæ %code%-3',
		'4' => 'Архайджытæ %code%-4',
		'5' => 'Архайджытæ %code%-5',
		'N' => 'Архайджытæ %code%-N',
	),
	'plwiki' => array(
		'0' => false,
		'1' => 'User %code%-1',
		'2' => 'User %code%-2',
		'3' => 'User %code%-3',
		'4' => 'User %code%-4',
		'5' => false,
		'N' => 'User %code%-N',
	),
	'plwikisource' => array( // Bug 39225
		'0' => false,
		'1' => 'User %code%-1',
		'2' => 'User %code%-2',
		'3' => 'User %code%-3',
		'4' => 'User %code%-4',
		'5' => false,
		'N' => 'User %code%-N',
	),
	'ptwiki' => array(
		'0' => false,
		'1' => 'Usuário %code%-1',
		'2' => 'Usuário %code%-2',
		'3' => 'Usuário %code%-3',
		'4' => false,
		'5' => false,
		'N' => 'Usuário %code%',
	),
	'ptwiktionary' => array(
		'0' => '!Usuário %code%-0',
		'1' => '!Usuário %code%-1',
		'2' => '!Usuário %code%-2',
		'3' => '!Usuário %code%-3',
		'4' => '!Usuário %code%-4',
		'5' => '!Usuário %code%-5',
		'N' => '!Usuário %code%-M',
	),
	'ruwiki' => array(
		'0' => 'User %code%-0',
		'1' => 'User %code%-1',
		'2' => 'User %code%-2',
		'3' => 'User %code%-3',
		'4' => 'User %code%-4',
		'5' => 'User %code%-5',
		'N' => 'User %code%-N',
	),
	'ruwikinews' => array( // Bug 52679
		'0' => 'User %code%-0',
		'1' => 'User %code%-1',
		'2' => 'User %code%-2',
		'3' => 'User %code%-3',
		'4' => 'User %code%-4',
		'5' => 'User %code%-5',
		'N' => 'User %code%-N',
	),
	'simplewiktionary' => array(
		'0' => 'User %code%-0',
		'1' => 'User %code%-1',
		'2' => 'User %code%-2',
		'3' => 'User %code%-3',
		'4' => 'User %code%-4',
		'5' => 'User %code%-5',
		'N' => 'User %code%-N',
	),
	'specieswiki' => array(
		'0' => false,
		'1' => 'User %code%-1',
		'2' => 'User %code%-2',
		'3' => 'User %code%-3',
		'4' => 'User %code%-4',
		'5' => false,
		'N' => 'User %code%-N',
	),
	'svwiki' => array(
		'0' => 'Användare %code%-0',
		'1' => 'Användare %code%-1',
		'2' => 'Användare %code%-2',
		'3' => 'Användare %code%-3',
		'4' => 'Användare %code%-4',
		'5' => false,
		'N' => 'Användare %code%-N',
	),
	'svwiktionary' => array( // Bug 42288
		'0' => 'Wiktionary:Användare %code%-0',
		'1' => 'Wiktionary:Användare %code%-1',
		'2' => 'Wiktionary:Användare %code%-2',
		'3' => 'Wiktionary:Användare %code%-3',
		'4' => 'Wiktionary:Användare %code%-4',
		'5' => false,
		'N' => 'Wiktionary:Användare %code%-N',
	),
	'thwiki' => array( // Bug 47418
		'0' => 'User %code%-0',
		'1' => 'User %code%-1',
		'2' => 'User %code%-2',
		'3' => 'User %code%-3',
		'4' => 'User %code%-4',
		'5' => 'User %code%-5',
		'N' => 'User %code%-N',
	),
	'tlwiki' => array(
		'0' => false,
		'1' => 'User %code%-1',
		'2' => 'User %code%-2',
		'3' => 'User %code%-3',
		'4' => 'User %code%-4',
		'5' => 'User %code%-5',
		'N' => 'User %code%-N',
	),
	'udmwiki' => array( // bug 47749
		'0' => 'User %code%-0',
		'1' => 'User %code%-1',
		'2' => 'User %code%-2',
		'3' => 'User %code%-3',
		'4' => 'User %code%-4',
		'5' => 'User %code%-5',
		'N' => 'User %code%-N',
	),
	'ukwiki' => array(
		'0' => 'User %code%-0',
		'1' => 'User %code%-1',
		'2' => 'User %code%-2',
		'3' => 'User %code%-3',
		'4' => 'User %code%-4',
		'5' => false,
		'N' => 'User %code%-N',
	),
	'ukwikinews' => array( // bug 46489
		'0' => 'User %code%-0',
		'1' => 'User %code%-1',
		'2' => 'User %code%-2',
		'3' => 'User %code%-3',
		'4' => 'User %code%-4',
		'5' => 'User %code%-5',
		'N' => 'User %code%-N',
	),
	'ukwikisource' => array( // bug 51608
		'0' => 'Користувачі %code%-0',
		'1' => 'Користувачі %code%-1',
		'2' => 'Користувачі %code%-2',
		'3' => 'Користувачі %code%-3',
		'4' => 'Користувачі %code%-4',
		'5' => 'Користувачі %code%-5',
		'N' => 'Користувачі %code%-N',
	),
	'vowiktionary' => array(
		'0' => 'Geban %code%-0',
		'1' => 'Geban %code%-1',
		'2' => 'Geban %code%-2',
		'3' => 'Geban %code%-3',
		'4' => 'Geban %code%-4',
		'5' => 'Geban %code%-5',
		'N' => 'Geban %code%-N',
	),
	'wikidatawiki' => array( // bug 52145
		'0' => 'User %code%-0',
		'1' => 'User %code%-1',
		'2' => 'User %code%-2',
		'3' => 'User %code%-3',
		'4' => 'User %code%-4',
		'5' => 'User %code%-5',
		'N' => 'User %code%-N',
	),
	'zhwiktionary' => array(
		'0' => false,
		'1' => '%wikiname%(初级)使用者',
		'2' => '%wikiname%(中级)使用者',
		'3' => '%wikiname%(高级)使用者',
		'4' => '%wikiname%(近母语)使用者',
		'5' => false,
		'N' => '%wikiname%(母语)使用者',
	),
	'zhwiki' => array(
		'0' => '%code%-0_使用者',
		'1' => '%code%-1_使用者',
		'2' => '%code%-2_使用者',
		'3' => '%code%-3_使用者',
		'4' => '%code%-4_使用者',
		'5' => false,
		'N' => '%code%_母语使用者',
	),
	'zhwikibooks' => array(
		'0' => '%code%-0_使用者',
		'1' => '%code%-1_使用者',
		'2' => '%code%-2_使用者',
		'3' => '%code%-3_使用者',
		'4' => '%code%-4_使用者',
		'5' => false,
		'N' => '%code%_母语使用者',
	),
	'zhwikinews' => array(
		'0' => '%code%-0_使用者',
		'1' => '%code%-1_使用者',
		'2' => '%code%-2_使用者',
		'3' => '%code%-3_使用者',
		'4' => '%code%-4_使用者',
		'5' => false,
		'N' => '%code%_母语使用者',
	),
	'zhwikiquote' => array(
		'0' => '%code%-0_使用者',
		'1' => '%code%-1_使用者',
		'2' => '%code%-2_使用者',
		'3' => '%code%-3_使用者',
		'4' => '%code%-4_使用者',
		'5' => false,
		'N' => '%code%_母语使用者',
	),
	'zhwikisource' => array(
		'0' => '%code%-0_使用者',
		'1' => '%code%-1_使用者',
		'2' => '%code%-2_使用者',
		'3' => '%code%-3_使用者',
		'4' => '%code%-4_使用者',
		'5' => false,
		'N' => '%code%_母语使用者',
	),
	'zhwikivoyage' => array( // bug 61819
		'0' => '%code%-0_使用者',
		'1' => '%code%-1_使用者',
		'2' => '%code%-2_使用者',
		'3' => '%code%-3_使用者',
		'4' => '%code%-4_使用者',
		'5' => false,
		'N' => '%code%_母语使用者',
	),

),
'wmgBabelMainCategory' => array(
	'default' => false,
	'betawikiversity' => 'User %code%', // bug 64168
	'cawiki' => 'Usuaris %code%',
	'cawiktionary' => 'Usuaris %code%', // Bug 47287
	'checkuserwiki' => 'User %code%',
	'commonswiki' => 'User %code%',
	'enwiki' => 'User %code%',
	'enwikibooks' => 'User %code%',
	'enwiktionary' => 'User %code%',
	'enwikiquote' => 'User %code%',
	'enwikisource' => 'User %code%',
	'enwikinews' => 'User %code%',
	'enwikiversity' => 'User %code%',
	'eowiktionary' => 'Vikivortaristo %code%', // bug 61116
	'eswiki' => 'Wikipedia:Wikipedistas con conocimientos de %wikiname%',
	'eswikinews' => 'Usuario %code%',
	'fiwiki' => 'User %code%',
	'fowiki' => 'Brúkari %code%', // Bug 37401
	'frwiki' => 'Utilisateur %code%',
	'frwikiquote' => 'Utilisateur %code%', // Bug 39472
	'frwikisource' => 'Utilisateurs %code%',
	'frwiktionary' => 'Utilisateurs %code%',
	'ilowiki' => 'Agar-aramat %code%', // Bug 37981
	'incubatorwiki' => 'Users:By language:%code%',
	'iswiki' => 'Notandi %code%',
	'itwiki' => 'Utenti %code%',
	'itwiktionary' => 'Utenti %code%',
	'itwikinews' => 'Utenti %code%',
	'itwikibooks' => 'Utenti %code%',
	'itwikiquote' => 'Utenti %code%',
	'itwikisource' => 'Utenti %code%',
	'itwikiversity' => 'Utenti %code%',
	'itwikivoyage' => 'Utenti %code%',
	'jawiki' => 'User %code%',
	'lawiki' => 'Usores %code%',
	'metawiki' => 'User %code%',
	'minwiki' => 'Pengguna %code%',
	'nowiki' => 'Bruker %code%',
	'oswiki' => 'Архайджытæ %code%',
	'otrs_wikiwiki' => 'User %code%',
	'plwiki' => 'User %code%',
	'plwikisource' => 'User %code%', // Bug 39225
	'ptwiki' => 'Usuários %code%',
	'ruwiki' => 'User %code%',
	'ruwikinews' => 'User %code%', // Bug 52679
	'simplewiktionary' => 'User %code%',
	'specieswiki' => 'User %code%',
	'svwiki' => 'Användare %code%',
	'svwiktionary' => 'Wiktionary:Användare %code%', // Bug 42288
	'thwiki' => 'User %code%', // Bug 47418
	'tlwiki' => 'User %code%',
	'udmwiki' => 'User %code%', // Bug 47749
	'ukwiki' => 'User %code%',
	'ukwikinews' => 'User %code%', // Bug 46489
	'ukwikisource' => 'Користувачі %code%', // bug 51608
	'wikidata' => 'User %code%',
	'zhwiktionary' => '%wikiname%使用者',
	'zhwiki' => '%code%_使用者',
	'zhwikibooks' => '%code%_使用者',
	'zhwikinews' => '%code%_使用者',
	'zhwikiquote' => '%code%_使用者',
	'zhwikisource' => '%code%_使用者',
	'zhwikivoyage' => '%code%_使用者', // bug 61819
),
'wmgBabelDefaultLevel' => array(
	'default' => 'N',
),
'wmgBabelUseUserLanguage' => array(
	'default' => false,
	'commonswiki' => true,
	'incubatorwiki' => true,
	'wikidata' => true,
),

'wmgUseTranslate' => array(
	'default' => false,
	'bewikimedia' => true, // bug 37391
	'brwikimedia' => true, // bug 44054
	'collabwiki' => true,
	'commonswiki' => true, // bug 48620
	'incubatorwiki' => true, // bug 34213
	'legalteamwiki' => true, // bug 62610
	'mediawikiwiki' => true,
	'metawiki' => true,
	'otrs_wikiwiki' => true, // bug 61297
	'outreachwiki' => true,
	'testwiki' => true,
	'wikidata' => true, // bug 41585
	'wikimania2012wiki' => true, // bug 34120
	'wikimania2013wiki' => true, // bug 36477
	'wikimania2014wiki' => true,
	'wikimania2015wiki' => true,
),
'wmgTranslateWorkflowStates' => array(
	'default' => false,
	'commonswiki' => array( // bug 48620
		'progress' => array( 'color' => 'E00' ),
		'proofreading' => array( 'color' => 'FFBF00' ),
		'ready' => array( 'color' => 'FF0' ),
		'state conditions' => array(
			array( 'ready', array( 'PROOFREAD' => 'MAX' ) ),
			array( 'proofreading', array( 'TRANSLATED' => 'MAX' ) ),
			array( 'progress', array( 'UNTRANSLATED' => 'NONZERO' ) ),
		),
	),
	'metawiki' => array(
		'progress' => array( 'color' => 'E00' ),
		'needs-updating' => array( 'color' => 'FFBF00' ),
		'proofreading' => array( 'color' => 'FFBF00' ),
		'ready' => array( 'color' => 'FF0' ),
		'published' => array( 'color' => 'AEA' ),
		'state conditions' => array(
			array( 'ready', array( 'PROOFREAD' => 'MAX' ) ),
			array( 'proofreading', array( 'TRANSLATED' => 'MAX' ) ),
			array( 'progress', array( 'UNTRANSLATED' => 'NONZERO' ) ),
		),
	),
	'otrs_wikiwiki' => array( // bug 61297
		'progress' => array( 'color' => 'E00' ),
		'proofreading' => array( 'color' => 'FFBF00' ),
		'ready' => array( 'color' => 'FF0' ),
		'state conditions' => array(
			array( 'ready', array( 'PROOFREAD' => 'MAX' ) ),
			array( 'proofreading', array( 'TRANSLATED' => 'MAX' ) ),
			array( 'progress', array( 'UNTRANSLATED' => 'NONZERO' ) ),
		),
	),
	'wikidata' => array(
		'progress' => array( 'color' => 'E00' ),
		'needs-updating' => array( 'color' => 'FFBF00' ),
		'updating' => array( 'color' => 'FFBF00' ),
		'proofreading' => array( 'color' => 'FFBF00' ),
		'ready' => array( 'color' => 'FF0' ),
		'published' => array( 'color' => 'AEA' ),
	),
),

'wmgTranslateRcFilterDefault' => array(
	'default' => 'filter',
	'wikidata' => 'noaction',
),

'wmgUseTranslationMemory' => array(
	'default' => true,
	'otrs_wikiwiki' => false, // bug 61297
),
'wmgUseTranslationNotifications' => array(
	'default' => false,
	'testwiki' => true,
	'brwikimedia' => true, // Bug 44054
	'incubatorwiki' => true,
	'mediawikiwiki' => true,
	'metawiki' => true,
	'wikidata' => true, // bug 41585
	'wikimania2012wiki' => true,
	'wikimania2013wiki' => true,
	'wikimania2014wiki' => true,
	'wikimania2015wiki' => true,
),
'wmgUseCleanChanges' => array(
	'default' => false,
//	'metawiki' => true, // bug 53541
),
'wmgUseVips' => array(
	'default' => true,
	'labswiki' => false,
	'loginwiki' => false,
	'votewiki' => false,
),

'wmgUseApiSandbox' => array(
	'default' => true,
	'loginwiki' => false,
	'votewiki' => false,
),

'wmgUseShortUrl' => array(
	'default' => false,
	'hiwiki' => true,
	'orwiki' => true,
	'tawiki' => true,
	'tawikibooks' => true,
	'tawikinews' => true,
	'tawikiquote' => true,
	'tawikisource' => true,
	'tawiktionary' => true,
#	'testwiki' => true,
	'test2wiki' => true,
),

'wmgUseFeaturedFeeds' => array(
	'default' => true,
	'loginwiki' => false,
	'votewiki' => false,
	'labswiki' => false,
),
'wmgFeaturedFeedsDefaults' => array(
	'default' => array(
		'limit' => 10,
		'inUserLanguage' => false,
	),
	'frwikisource' => array( // Bug 39919
		'limit' => 70,
		'inUserLanguage' => false,
	),
	'metawiki' => array( // bug 63596
		'limit' => 10,
		'inUserLanguage' => true,
	),
),
'wmgDisplayFeedsInSidebar' => array(
	'default' => false,
	'testwiki' => true,
),
'wmgFeaturedFeedsOverrides' => array(
	'default' => array(),
	'fawiki' => array ( // Bug 55884
		'dyk' => array(
			'frequency' => 'weekly',
		),
		'featured' => array(
			'frequency' => 'weekly',
		),
	),
	'frwikisource' => array( // Bug 39919
		'featuredtexts' => array(
			'frequency' => 'weekly',
		),
	),
	'lawiki' => array ( // bug 33978
		'featured' => array(
			'limit' => 180,
		),
	),
	'metawiki' => array( // bug 63596
		'technews' => array(
			'frequency' => 'weekly',
		),
	),
),
'wmgReduceStartupExpiry' => array(
	'default' => false,
),

'wmgMemoryLimit' => array(
	'default' => 300 * 1024 * 1024, // 300MB
),
'wgMaxGeneratedPPNodeCount' => array(
	'default' => 1500000,
),

'wgEnableJavaScriptTest' => array(
	'default' => false,
	'test2wiki' => true,
),

'wgIncludejQueryMigrate' => array(
	'default' => true,
	'test2wiki' => false,
),

'wmgEnablePageTriage' => array(
	'default' => false,
	'testwiki' => true,
	'test2wiki' => true,
	'enwiki' => true,
),
'wmgPageTriageEnableCurationToolbar' => array(
	'default' => false,
	'testwiki' => true,
	'test2wiki' => true,
	'enwiki' => true,
),

'wmgEnableInterwiki' => array(
	'default' => true,
),

'wmgEnableRandomRootPage' => array(
	'default' => true,
	'wiki' => false,
),
'wmgUseGettingStarted' => array(
	'default' => false,
	'testwiki' => true,
	'test2wiki' => true,
	'astwiki' => true,
	'bswiki' => true,
	'cawiki' => true,
	'dawiki' => true,
	'dewiki' => true,
	'elwiki' => true,
	'enwiki' => true,
	'eswiki' => true,
	'fawiki' => true,
	'frwiki' => true,
	'fowiki' => true,
	'glwiki' => true,
	'hewiki' => true,
	'huwiki' => true,
	'iswiki' => true,
	'itwiki' => true,
	'jawiki' => true,
	'kowiki' => true,
	'lbwiki' => true,
	'mkwiki' => true,
	'mlwiki' => true,
	'nlwiki' => true,
	'plwiki' => true,
	'ptwiki' => true,
	'ruwiki' => true,
	'simplewiki' => true,
	'svwiki' => true,
	'viwiki' => true,
	'ukwiki' => true,
	'zhwiki' => true,
),
'wmgGettingStartedCategoriesForTaskTypes' => array(
	'default' => array(),
	'cawiki' => array(
		'copyedit' => 'Categoria:Articles amb ortografia per millorar',
	),
	'enwiki' => array(
		'copyedit' => 'Category:All articles needing copy edit',
		'clarify' => 'Category:All Wikipedia articles needing clarification',
		'addlinks' => 'Category:All articles with too few wikilinks',
	),
	'eswiki' => array(
		'copyedit' => 'Categoría:Wikipedia:Copyedit',
	),
	'simplewiki' => array(
		'copyedit' => 'Category:Pages in need of copyedit',
	),
	'svwiki' => array(
		'copyedit' => 'Kategori:Wikipedia:Språkvård-samtliga',
	),
	'ukwiki' => array(
		'copyedit' => 'Категорія:Статті, що потребують вичитки',
	),
	'zhwiki' => array(
		'copyedit' => 'Category:需要校對的頁面',
	),
	'fawiki' => array(
		'clarify' => 'رده:همه مقاله‌های نیازمند شفاف‌سازی ویکی‌پدیا',
		'addlinks' => 'رده:همه مقاله‌هایی که ویکی‌پیوند بسیار کمی دارند',
	),
	'ruwiki' => array(
		'clarify' => 'Категория:Статьи, требующие внесения ясности',
	),
),
'wmgGettingStartedExcludedCategories' => array(
	'default' => array(),
	'astwiki' => array( 'Categoría:Persones vives' ),
	'bswiki' => array( 'Kategorija:Živi ljudi' ),
	'cawiki' => array( 'Categoria:Persones vives' ),
	'dawiki' => array( 'Kategori:Levende personer' ),
	'enwiki' => array( 'Category:Living people' ),
	'eswiki' => array( 'Categoría:Personas vivas' ),
	'fawiki' => array( 'رده:افراد زنده' ),
	'itwiki' => array( 'Categoria:Persone viventi' ),
	'kowiki' => array( '분류:살아있는 사람' ),
	'mkwiki' => array( 'Категорија:Живи луѓе' ),
	'mlwiki' => array( 'വർഗ്ഗം:ജീവിച്ചിരിക്കുന്ന പ്രമുഖർ' ),
	'ptwiki' => array( 'Categoria:Pessoas vivas' ),
	'ruwiki' => array( 'Категория:Ныне живущие' ),
	'simplewiki' => array( 'Category:Living people' ),
	'svwiki' => array( 'Kategori:Levande personer' ),
	'ukwiki' => array( 'Категорія:Нині живуть' ),
	'viwiki' => array( 'Thể loại:Nhân vật còn sống' ),
	'zhwiki' => array( 'Category:在世人物' ),
),
'wmgGettingStartedRunTest' => array(
	'default' => false,
	'enwiki' => true,
	'dewiki' => true,
	'eswiki' => true,
	'fawiki' => true,
	'frwiki' => true,
	'hewiki' => true,
	'itwiki' => true,
	'nlwiki' => true,
	'ruwiki' => true,
	'svwiki' => true,
	'ukwiki' => true,
	'zhwiki' => true,
),
'wmgUseGuidedTour' => array(
	'default' => false,
	'testwiki' => true,
	'test2wiki' => true,
	'testwikidatawiki' => true,
	'arwiki' => true,
	'astwiki' => true,
	'be_x_oldwiki' => true,
	'bewiki' => true,
	'bnwiki' => true,
	'bswiki' => true,
	'cawiki' => true,
	'commonswiki' => true,
	'cswiki' => true, // bug 60270
	'dewiki' => true,
	'elwiki' => true,
	'enwiki' => true,
	'eswiki' => true,
	'fawiki' => true,
	'frwiki' => true,
	'glwiki' => true,
	'hewiki' => true,
	'huwiki' => true,
	'itwiki' => true,
	'jawiki' => true,
	'kowiki' => true,
	'mediawikiwiki' => true,
	'mkwiki' => true,
	'mlwiki' => true,
	'mswiki' => true,
	'mwlwiki' => true,
	'nlwiki' => true,
	'nowiki' => true,
	'outreachwiki' => true,
	'plwiki' => true,
	'ptwiki' => true,
	'ptwikibooks' => true, // bug 48778
	'ruwiki' => true,
	'sewikimedia' => true, // bug 61192
	'svwiki' => true,
	'tewiki' => true,
	'ukwiki' => true,
	'viwiki' => true,
	'wikidatawiki' => true,
),
'wmgUseEducationProgram' => array(
	'default' => false,
	'arwiki' => true, // bug 57729
	'cawiki' => true, // bug 71381
	'cswiki' => true, // bug 54223
	'dewikiversity' => true,
	'elwiki' => true, // bug 56771
	'enwiki' => true,
	'enwikinews' => true, // bug 53984
	'eswiki' => true, // bug 54826
	'fawiki' => true,
	'hewiki' => true, // bug 48848
	'legalteamwiki' => true, // bug 62610
	'mkwiki' => true,
	'nlwiki' => true, // bug 50574
	'ptwiki' => true, // bug 52870
	'svwiki' => true, // bug 49009
	'test2wiki' => true,
	'ukwiki' => true, // bug 64143
),

'wmgEducationProgramDYKCat' => array(
	'default' => 'MyCourses Did You Know',
	'cswiki' => 'Moje kurzy - Víte že?', // bug 54223
	'eswiki' => 'Mis cursos ¿sabías que?', // bug 54826
	'fawiki' => 'نکته روز ویکی‌پدیا',
	'ptwiki' => '!Você Sabia sobre cursos', // bug 52870
),

'wmgUseWikimediaShopLink' => array(
	'default' => false,
	'testwiki' => true,
	'test2wiki' => true,
	'enwiki' => true,
),

# *** DO NOT disable this extension if it causes an overload via API ***
# or you will break a lot of pages where its parser function is used. Instead,
# disable its API modules in CommonSettings.php or below
'wmgEnableGeoData' => array(
	'default' => false,
	'wiki' => true,
	'wikivoyage' => true,
	'wikidatawiki' => false,
	'testwikidatawiki' => false,
),
'wmgEnableGeoSearch' => array(
	'default' => true,
	'labswiki' => false,
	'loginwiki' => false,
	'votewiki' => false,
),
'wmgMaxGeoSearchRadius' => array(
	'default' => 10000,
	'wikivoyage' => 20000,
),
'wmgGeoDataDebug' => array(
	'default' => false,
	'testwiki' => true,
),

'wmgUseEcho' => array(
	'default' => false,
	'echowikis' => true,
),
'wmgEchoEnableEmailBatch' => array(
	'default' => true,
),
'wmgEchoEmailFooterAddress' => array(
	'default' => 'Wikimedia Foundation, 149 New Montgomery St., 3rd Fl., San Francisco, CA 94105, USA',
),
'wmgEchoHelpPage' => array(
	'default' => '//www.mediawiki.org/wiki/Special:MyLanguage/Help:Notifications',
	'enwiki' => '//en.wikipedia.org/wiki/Wikipedia:Notifications/FAQ',
	'metawiki' => '//meta.wikimedia.org/wiki/Help:Notifications',
	'dewiki' => '//de.wikipedia.org/wiki/Hilfe:Echo',
	'frwiki' => '//fr.wikipedia.org/wiki/Aide:Notifications',
	'huwiki' => '//hu.wikipedia.org/wiki/Wikip%C3%A9dia:%C3%89rtes%C3%ADt%C3%A9sek',
	'plwiki' => '//pl.wikipedia.org/wiki/Wikipedia:Powiadomienia/FAQ',
	'ptwiki' => '//www.mediawiki.org/wiki/Help:Notifications/pt-br',
	'svwiki' => '//sv.wikipedia.org/wiki/Wikipedia:Meddelanden',
	'bswiki' => '//bs.wikipedia.org/wiki/Pomo%C4%87:Obavje%C5%A1tenja',
	'nlwiki' => '//nl.wikipedia.org/wiki/Wikipedia:Notificaties',
	'etwiki' => '//www.mediawiki.org/wiki/Help:Notifications/et',
	'fawiki' => '//fa.wikipedia.org/wiki/Project:%D8%A2%DA%AF%D8%A7%D9%87%E2%80%8C%D8%B3%D8%A7%D8%B2%DB%8C',
	'hewiki' => '//www.mediawiki.org/wiki/Help:Notifications/he',
	'rowiki' => '//www.mediawiki.org/wiki/Help:Notifications/ro',
	'eswiki' => '//es.wikipedia.org/wiki/Wikipedia:Notificaciones/FAQ',
	'enwikivoyage' => '//www.mediawiki.org/wiki/Help:Notifications',
	'simplewiki' => '//www.mediawiki.org/wiki/Help:Notifications/Simple',
	'cawiki' => '//www.mediawiki.org/wiki/Help:Notifications/ca',
	'jawiki' => '//www.mediawiki.org/wiki/Help:Notifications/ja',
	'knwiki' => '//www.mediawiki.org/wiki/Help:Notifications/kn',
	'kowiki' => '//www.mediawiki.org/wiki/Help:Notifications/ko',
	'nowiki' => '//www.mediawiki.org/wiki/Help:Notifications/no',
	'tewiki' => '//www.mediawiki.org/wiki/Help:Notifications/te',
	'ukwiki' => '//www.mediawiki.org/wiki/Help:Notifications/uk',
	'viwiki' => '//www.mediawiki.org/wiki/Help:Notifications/vi',
	'zhwiki' => '//zh.wikipedia.org/wiki/Wikipedia:%E9%80%9A%E7%9F%A5/FAQ',
	'fiwiki' => '//www.mediawiki.org/wiki/Help:Notifications/fi',
	'slwiki' => '//www.mediawiki.org/wiki/Help:Notifications/sl',
	'ckbwiki' => '//ckb.wikipedia.org/wiki/%DB%8C%D8%A7%D8%B1%D9%85%DB%95%D8%AA%DB%8C:%D8%A6%D8%A7%DA%AF%D8%A7%D8%AF%D8%A7%D8%B1%DB%8C',
),
'wmgEchoSiteNotificationIconUrl' => array(
	'default' => false, // Placeholder icon
	'enwiki' => '//upload.wikimedia.org/wikipedia/commons/f/ff/Wikipedia_Echo_notification_icon.png', // https://commons.wikimedia.org/wiki/File:Wikipedia_Echo_notification_icon.png
),
# from and reply to address when Echo sends email notifications
'wmgNotificationSender' => array(
	'default' => 'wiki@wikimedia.org',
	'enwiki' => 'no-reply-notifications@wikipedia.org',
),

// The time interval in seconds between each bundle-able email notification
// Set to 0 to disable email bundling
'wmgEchoBundleEmailInterval' => array(
	'default' => 14400,
	'test2wiki' => 300,
	'officewiki' => 0,
),

// Use extension1 db for all wikis
'wmgEchoCluster' => array(
	'default' => 'extension1',
	// The following wikis should be using extension1 db but started with
	// the application main database, stick with the current setting
	'labswiki' => false,
	'mediawikiwiki' => false,
	'metawiki' => false,
	'officewiki' => false,
),

// Cohort study time, empty array to disable Cohort study
'wmgEchoCohortInterval' => array(
	'default' => array(),
	'testwiki' => array( 20130611182949, 20130611184549, 20130611185949 ),
	'enwiki' => array( 20130611200000, 20130618200000, 20130701200000 ),
),

// Whether to use job queue to process web and email notifications
'wmgEchoUseJobQueue' => array(
	'default' => false,
	'testwiki' => true,
	'test2wiki' => true,
	'mediawikiwiki' => true,
),

// Thanks should be enabled for wikis with Echo
'wmgUseThanks' => array(
	'default' => false,
	'echowikis' => true,
),

'wmgUseFlow' => array(
	'default' => false,
	'testwiki' => true,
	'test2wiki' => true,
	'mediawikiwiki' => true,
	'metawiki' => true,
	'enwiki' => true,
	'frwiki' => true,
	'hewiki' => true,
),
'wmgFlowEditorList' => array(
	// Disable VE inside flow, leaving only the wikitext editor
	'default' => array( 'none' ),
),
'wmgFlowOccupyPages' => array(
	'default' => array(),
	# Extension:Flow's browsertests use Talk:Flow_QA.
	'testwiki' => array( 'Talk:Flow QA', 'Talk:Sandbox' ),
	'test2wiki' => array( 'Talk:Flow QA', 'Talk:Sandbox' ),
	'metawiki' => array( 'Talk:Flow/Developer test page' ),
	'mediawikiwiki' => array(
		'Talk:Flow QA',
		'Talk:Sandbox',
		'Talk:Flow',
		'Talk:Winter', // talk page for design refresh
		'User talk:Jorm (WMF)',
		'Talk:Beta Features/Hovercards',
		'Talk:Compact Personal Bar',
		'Talk:Beta Features/Nearby Pages',
		'Talk:VisualEditor/Beta Features/Language',
		'Talk:Content translation',
		'Talk:Wikibase/Beta Features/Other projects sidebar',
		'Talk:Design',
		'Talk:Phabricator/Help',
		'Talk:Search',
		'Talk:Cite-from-id',
		'Talk:Sparrow (sandbox for testing at Wikimania)',
		'Talk:MediaWiki 1.25',
		'User talk:Jdforrester (WMF)',
		'Talk:HHVM/About',
		'Talk:MediaWiki UI',
	),
	'enwiki' => array( // Bug 60178
		'Wikipedia talk:WikiProject Breakfast',
		'Wikipedia talk:WikiProject Hampshire',
		'Wikipedia talk:Flow/Developer test page',
		'Wikipedia:Co-op/Mentorship match',
	),
	'frwiki' => array(
		'Wikipédia:Forum des nouveaux/Flow',
		'Discussion Wikipédia:Flow',
	),
	'hewiki' => array(
		'שיחת ויקיפדיה:זרימה',
	),
),
// Use separate database on extension1 cluster for all non-private wikis.
'wmgFlowDefaultWikiDb' => array(
	'default' => 'flowdb',
	'private' => false,
),
'wmgFlowCluster' => array(
	'default' => 'extension1',
	'private' => false,
),
'wmgFlowMaintenanceMode' => array(
	'default' => false,
),
'wmgUseDisambiguator' => array(
	'default' => true,
),

'wmgUseCodeEditorForCore' => array(
	'default' => true,
),

'wmgUseScribunto' => array(
	'default' => true,
	'loginwiki' => false,
	'votewiki' => false,
),

'wmgUseSubpageSortkey' => array(
	'default' => false,
	'enwikibooks' => true,
	'ptwikibooks' => true,
),
'wmgSubpageSortkeyByNamespace' => array(
	'default' => array(),
	'enwikibooks' => array( // Bug 22911
		NS_MAIN => '1..',
		102 => '1..', // Cookbook
		110 => '1..', // Wikijunior
	),
	'ptwikibooks' => array( // Bug 22911
		NS_MAIN => '1..',
	),
),

'wmgUseCORS' => array(
	'default' => true,
	'private' => false,
),

'wmgDisableUnmergedEdits' => array(
	'default' => false,
	'wikivoyage' => false,
),

'wmgUseGeoCrumbs' => array(
	'default' => false,
	'incubatorwiki' => true, // bug 44725
	'wikivoyage' => true,
),

'wmgUseCalendar' => array(
	'default' => false,
	'wikivoyage' => true,
),

'wmgUseMapSources' => array(
	'default' => false,
	'wikivoyage' => true,
),

'wmgUseSlippyMap' => array(
	'default' => false,
	'wikivoyage' => false,
),

'wmgUseCreditsSource' => array(
	'default' => false,
	'wikivoyage' => true,
),

'wgMaxCredits' => array(
	'default' => 0,
	'wikivoyage' => 10,
),

'wmgUseListings' => array(
	'default' => false,
	'wikivoyage' => true,
),

'wmgUseTocTree' => array(
	'default' => false,
	'wikivoyage' => true,
),

'wmgUseInsider' => array(
	'default' => false,
	'wikivoyage' => true,
),

'wmgUseRelatedArticles' => array(
	'default' => false,
	'wikivoyage' => true,
),

'wmgUseRelatedSites' => array(
	'default' => false,
	'wikivoyage' => true,
),

'wmgUseUserMerge' => array(
	'default' => true,
	'private' => false,
	'fishbowl' => false,
),

'wmgUseEventLogging' => array(
	'default' => true,
),

'wmgUseNavigationTiming' => array(
	'default' => true,
	'labswiki' => false,
),

'wmgRelatedSitesPrefixes' => array(
	'default' => array(),
	'wikivoyage' => array( 'wikipedia', 'dmoz', 'citizendium', 'commons' ),
),

'wgExtraInterlanguageLinkPrefixes' => array(
	'default' => array(),
	'wikisource' => array( 'mul' ),
	'wikiversity' => array( 'mul' ),
	'wikivoyage' => array( 'wikipedia', 'dmoz', 'citizendium', 'commons' ),
),

'wmgExtraLanguageNames' => array(
	'default' => array(),
	// Further languages for (test)wikidata not (yet) supported by MediaWiki (bug 59905)
	'wikidatawiki' => array(
		'rwr' => 'मारवाड़ी',
		'ota' => 'Ottoman Turkish',
	),
	'testwikidatawiki' => array(
		'rwr' => 'मारवाड़ी',
		'ota' => 'Ottoman Turkish',
	),
),

'wgContentHandlerUseDB' => array(
	'default' => false,
	'wikidata' => true,
	'mediawikiwiki' => true,
	'testwiki' => true,
	'test2wiki' => true,
),

'wmgUseUniversalLanguageSelector' => array(
	'default' => true,
),

'wmgULSPosition' => array(
	'default' => 'interlanguage',
	'special' => 'personal',
	'wikimedia' => 'personal',
	'betawikiversity' => 'personal',
),

// Whether ime is enabled *by default*
'wmgULSIMEEnabled' => array(
	'default' => true,
	'enwiki' => false,
),

// Whether web fonts are enabled *by default*
'wmgULSWebfontsEnabled' => array(
	'default' => false,
	'enwikisource' => true, // bug 69655
	'dvwiki' => true,       // bug 69860
	'dvwiktionary' => true, // bug 69860
	'hewikisource' => true, // bug 60939
),

'wmgULSEventLogging' => array(
	'default' => true,
),

'wmgWikibaseCachePrefix' => array(
	'default' => 'wikidatawiki',
	'testwikidatawiki' => 'testwikidatawiki0',
	'test2wiki' => 'testwikidatawiki0',
	'testwiki' => 'testwikidatawiki0'
),

'wmgWikibaseEnableData' => array(
	'default' => true,
	'wikinews' => false,
	'commonswiki' => false,
),

'wmgUseWikibaseRepo' => array(
	'default' => false,
	'wikidata' => true,
),

'wmgUseWikibasePropertySuggester' => array(
	'default' => false,
	'wikidata' => true,
),

'wmgUseWikibaseClient' => array(
	'default' => false,
	'wikidataclient' => true,
),

'wmgWikibaseSiteGroup' => array(
	'default' => 'wikipedia',
	'wikinews' => 'wikinews',
	'wikiquote' => 'wikiquote',
	'wikivoyage' => 'wikivoyage',
	'wikisource' => 'wikisource',
	'commonswiki' => 'commons',
	'wikidatawiki' => 'wikidata',
	'testwikidatawiki' => 'testwikidata'
),

'wmgWikibaseClientSettings' => array(
	// @note because of unconventional way of doing wikibase settings, the default setting
	// here does not work the same way. Instead, put defaults in CommonSettings.php
	'default' => array(
	),
	'testwiki' => array(
		'siteGlobalID' => 'enwiki',
		'propagateChangesToRepo' => false,
	),
	'test2wiki' => array(
		'siteGlobalID' => 'enwiki'
	),
	'be_x_oldwiki' => array(
		'sort' => 'alphabetic',
	),
	// bug 53993
	'ckbwiki' => array(
		'sortPrepend' => array( 'ku', 'diq' ),
	),
	'enwiki' => array(
		'sort' => 'alphabetic',
	),
	'etwiki' => array(
		'sort' => 'alphabetic_revised',
	),
	'fiwiki' => array(
		'sort' => 'alphabetic_revised',
	),
	'fiu_vrowiki' => array(
		'sort' => 'alphabetic_revised',
	),
	'frwikisource' => array(
		'otherProjectsLinksByDefault' => true,
	),
	'fywiki' => array(
		'sort' => 'alphabetic_fy',
	),
	'hewiki' => array(
		'sortPrepend' => array( 'en' ),
	),
	'hewikivoyage' => array(
		'sortPrepend' => array( 'en' ),
	),
	'huwiki' => array(
		'sortPrepend' => array( 'en' ),
	),
	'ilowiki' => array(
		'sort' => 'alphabetic',
	),
	'itwikisource' => array(
		'otherProjectsLinksByDefault' => true,
	),
	'itwikivoyage' => array(
		'otherProjectsLinksByDefault' => true, // bug 71464
	),
	'kowiki' => array(
		'otherProjectsLinksByDefault' => true,
	),
	'lbwiki' => array(
		'sort' => 'alphabetic',
	),
	'mkwiki' => array(
		'sort' => 'alphabetic',
	),
	'mswiki' => array(
		'sort' => 'alphabetic_revised',
	),
	'ndswiki' => array(
		'sortPrepend' => array( 'nds-nl' ),
	),
	'nds_nlwiki' => array(
		'sortPrepend' => array( 'nds' ),
	),
	'nnwiki' => array(
		'sort' => 'alphabetic',
		'sortPrepend' => array( 'no', 'sv', 'da' ),
	),
	'nowiki' => array(
		'sort' => 'alphabetic',
	),
	'nvwiki' => array(
		'sort' => 'alphabetic',
		'sortPrepend' => array( 'en', 'es' ),
	),
	'pdcwiki' => array(
		'sortPrepend' => array( 'de', 'en' ),
	),
	'plwiki' => array(
		'sort' => 'alphabetic',
	),
	'ruwiki' => array(
		'otherProjectsLinksByDefault' => true,
	),
	'simplewiki' => array(
		'sort' => 'alphabetic',
	),
	'srwiki' => array(
		'sort' => 'alphabetic_sr',
	),
	'svwiki' => array(
		'sort' => 'alphabetic',
	),
	'tewiki' => array(
		'sortPrepend' => array( 'en', 'hi', 'kn', 'ta', 'ml' ),
	),
	'urwiki' => array(
		'sort' => 'alphabetic',
		'sortPrepend' => array( 'ar', 'fa', 'en' ),
	),
	'viwiki' => array(
		'sort' => 'alphabetic_revised',
	),
	'yiwiki' => array(
		'sortPrepend' => array( 'en', 'he', 'de' ),
	)
),

'wmgUseTemplateSandbox' => array(
	'default' => true,
	'loginwiki' => false,
	'votewiki' => false,
),

'wmgUsePageImages' => array(
	'default' => true,
	'wikibooks' => false, # bug 66455
	'wikisource' => false, # bug 66455
	'labswiki' => false,
	'loginwiki' => false,
	'votewiki' => false,
),
'wmgPageImagesExpandOpenSearchXml' => array(
	'default' => true,
),
'wmgPageImagesUseGalleries' => array(
	'default' => false,
	'commonswiki' => true,
),

'wmgUseTorBlock' => array(
	'default' => true,
	'private' => false,
	'labswiki' => false,
),

'wmgUseSearchExtraNS' => array(
	'default' => false,
	'commonswiki' => true,
),
'wmgSearchExtraNamespaces' => array(
	'default' => false,
	'commonswiki' => array( NS_CATEGORY ),
),

'wmgUseSecurePoll' => array(
	'default' => true,
	'labswiki' => false,
	'loginwiki' => false,
),

'wmgUseGlobalAbuseFilters' => array(
	'default' => false,
	'small' => true,
	'private' => false,
	'fishbowl' => false,

	'metawiki' => true,
	'testwiki' => true,
	'test2wiki' => true,
	'mediawikiwiki' => true,
	'specieswiki' => true,
	'incubatorwiki' => true,
),

'wmgUseCampaigns' => array(
	'default' => true,
	'labswiki' => false,
),

'wmgUseCirrus' => array(
	'default' => true,
	'dewiki' => false,
	'enwiki' => false,
	'frwiki' => false,
	'zhwiki' => false,
),

'wmgUseCirrusAsAlternative' => array(
	'default' => true,
),

'wmgCirrusSearchPreferRecentDefaultDecayPortion' => array(
	'default' => 0,
	'wikinews' => .6,
),

'wmgCirrusSearchBoostLinks' => array(
	'default' => true,
	'commonswiki' => false,
),

'wmgCirrusSearchWeightsOverrides' => array(
	'default' => array(),
	'commonswiki' => array(
		'title' => 25.0,
	),
),

'wmgCirrusSearchPowerSpecialRandom' => array(
	'default' => false,
),

// Shard each wiki to be under 2gb per shard if possible.  Changing this for a wiki
// requires an in place reindex.  Last full review 2014-07-01.  See
// https://wikitech.wikimedia.org/wiki/Search/New#Estimating_the_number_of_shards_required
// for estimation of new wikis.  At this point I'm declaring we should have no more than
// 5 shards per content index and 10 per general index.  5 because that assigns one
// replica to most nodes and should be the most efficient for querying.  10 is somewhat
// arbitrary but reflects that we care less about search performance for the general
// index then we do for the content indexes.
'wmgCirrusSearchShardCount' => array(
	// Most wikis are too small to be worth sharding
	'default' => array( 'content' => 1, 'general' => 1 ),
	'arwiki' => array( 'content' => 3, 'general' => 4 ),
	'arwikisource' => array( 'content' => 2, 'general' => 1 ),
	'bgwiki' => array( 'content' => 2, 'general' => 1 ),
	'cawiki' => array( 'content' => 5, 'general' => 1 ),
	'cebwiki' => array( 'content' => 2, 'general' => 1 ),
	'cswiki' => array( 'content' => 2, 'general' => 1 ),
	// Commons is special and has a 'file' index in addition to the regular ones.
	// We're sharding 'file' like it is a content index because searching it is
	// very very common.
	'commonswiki' => array( 'content' => 1, 'general' => 10, 'file' => 5 ),
	'dawiki' => array( 'content' => 2, 'general' => 1 ),
	'dewiki' => array( 'content' => 5, 'general' => 10 ),
	'dewikisource' => array( 'content' => 3, 'general' => 1 ),
	'elwiki' => array( 'content' => 2, 'general' => 1 ),
	// These shards are also signigicantly larger than the target 2GB.
	'enwiki' => array( 'content' => 5, 'general' => 10 ),
	'enwikinews' => array( 'content' => 1, 'general' => 4 ),
	'enwikisource' => array( 'content' => 5, 'general' => 1 ),
	'enwiktionary' => array( 'content' => 4, 'general' => 2 ),
	'eswiki' => array( 'content' => 5, 'general' => 6 ),
	'eswikisource' => array( 'content' => 2, 'general' => 1 ),
	'fawiki' => array( 'content' => 4, 'general' => 2 ),
	'fiwiki' => array( 'content' => 2, 'general' => 10 ),
	'frwiki' => array( 'content' => 5, 'general' => 10 ),
	'frwikisource' => array( 'content' => 5, 'general' => 1 ),
	'frwiktionary' => array( 'content' => 2, 'general' => 1 ),
	'hewiki' => array( 'content' => 2, 'general' => 2 ),
	'huwiki' => array( 'content' => 4, 'general' => 2 ),
	'idwiki' => array( 'content' => 2, 'general' => 2 ),
	'incubatorwiki' => array( 'content' => 1, 'general' => 2 ),
	'itwiki' => array( 'content' => 5, 'general' => 9 ),
	'jawiki' => array( 'content' => 5, 'general' => 6 ),
	'kkwiki' => array( 'content' => 2, 'general' => 1 ),
	'kowiki' => array( 'content' => 3, 'general' => 1 ),
	'ltwiktionary' => array( 'content' => 2, 'general' => 1 ),
	'mswiki' => array( 'content' => 2, 'general' => 1 ),
	'metawiki' => array( 'content' => 1, 'general' => 10 ),
	'mgwiktionary' => array( 'content' => 2, 'general' => 1 ),
	'nowiki' => array( 'content' => 1, 'general' => 2 ),
	'nlwiki' => array( 'content' => 5, 'general' => 4 ),
	'plwiki' => array( 'content' => 5, 'general' => 3 ),
	'ptwiki' => array( 'content' => 5, 'general' => 5 ),
	'rowiki' => array( 'content' => 3, 'general' => 2 ),
	'ruwiki' => array( 'content' => 5, 'general' => 10 ),
	'ruwikisource' => array( 'content' => 3, 'general' => 1),
	'ruwiktionary' => array( 'content' => 3, 'general' => 1 ),
	'thwiki' => array( 'content' => 2, 'general' => 1 ),
	'trwiki' => array( 'content' => 2, 'general' => 2 ),
	'srwiki' => array( 'content' => 3, 'general' => 1 ),
	'shwiki' => array( 'content' => 2, 'general' => 1 ),
	'svwiki' => array( 'content' => 5, 'general' => 2 ),
	'ukwiki' => array( 'content' => 5, 'general' => 2 ),
	'viwiki' => array( 'content' => 3, 'general' => 2 ),
	'wikidatawiki' => array( 'content' => 5, 'general' => 1 ),
	'warwiki' => array( 'content' => 2, 'general' => 1 ),
	'zhwiki' => array( 'content' => 5, 'general' => 5 ),
	'zhwikisource' => array( 'content' => 3, 'general' => 1 ),
),

'wmgCirrusSearchMaxShardsPerNode' => array(
	'default' => array(),
	'commonswiki' => array( 'file' => 1, 'general' => 2 ),
	'dewiki' => array( 'content' => 1 ),
	'enwiktionary' => array( 'content' => 1, 'general' => 1 ),
	'enwiki' => array( 'content' => 1, 'general' => 2 ),
	'eswiki' => array( 'content' => 1 ),
	'frwiki' => array( 'content' => 1 ),
	'nlwiki' => array( 'content' => 1 ),
	'ptwiki' => array( 'content' => 1 ),
	'ruwiki' => array( 'content' => 1 ),
	'zhwiki' => array( 'content' => 1 ),
),

'wmgCirrusSearchAllFields' => array(
	'default' => array( 'build' => true, 'use' => true ),
),

'wmgCirrusSearchNamespaceWeightOverrides' => array(
	'default' => array(),
	'wikisource' => array(
		'author' => 1,
	),
),

'wmgUseCite' => array(
	'default' => true,
	'loginwiki' => false,
	'votewiki' => false,
),

'wmgUseCiteThisPage' => array(
	'default' => false,
	'loginwiki' => false,
	'votewiki' => false,
),

'wmgUsePoem' => array(
	'default' => true,
	'loginwiki' => false,
	'votewiki' => false,
	'labswiki' => false,
),

'wmgUseUnicodeConverter' => array(
	'default' => false,
	'testwiki' => true,
),

'wmgUseInputBox' => array(
	'default' => true,
	'loginwiki' => false,
	'votewiki' => false,
),

'wmgUseImageMap' => array(
	'default' => true,
	'loginwiki' => false,
	'votewiki' => false,
),

'wmgUseGeSHi' => array(
	'default' => true,
	'loginwiki' => false,
	'votewiki' => false,
),

'wmgUseTimeline' => array(
	'default' => true,
	'loginwiki' => false,
	'votewiki' => false,
),

'wmgUseWikiHiero' => array(
	'default' => true,
	'loginwiki' => false,
	'votewiki' => false,
),

'wmgUseGlobalBlocking' => array(
	'default' => true,
	'labswiki' => false,
	'private' => false,
),

// Only allow local 'crats to rename on non-CentralAuth wikis
'wmgAllowLocalRenameuser' => array(
	'default' => false,
	'private' => true,
	'fishbowl' => true,
),

### End (roughly) of general extensions ########################

// Apply blocks to IPs in XFF (bug 23343)
'wmgUseXFFBlocks' => array(
	'default' => true,
),

'wgUseTidy' => array(
	'default' => true,
	'foundationwiki' => false,
	'collabwiki' => false,
	'donatewiki' => false,
),

'wgResourceLoaderStorageEnabled' => array(
	'default' => true,
),

'wmgUseAccountAudit' => array(
	'default' => true,
	'labswiki' => false,
),

'wgAllowUserJs' => array(
	'default' => true,
	'loginwiki' => false,
	'votewiki' => false,
),

'wgAllowUserCss' => array(
	'default' => true,
	'loginwiki' => false,
	'votewiki' => false,
),

'wgUseSiteJs' => array(
	'default' => true,
	'loginwiki' => false,
	'votewiki' => false,
),

'wgUseSiteCss' => array(
	'default' => true,
	'loginwiki' => false,
	'votewiki' => false,
),

'wgLegacyJavaScriptGlobals' => array(
	'default' => true,
	'test2wiki' => false, // bug 65011
),

'wgSecureLogin' => array(
	'default' => true,
),

'wgRightsUrl' => array(
	'default' => '//creativecommons.org/licenses/by-sa/3.0/',
	'huwikinews' => '//creativecommons.org/licenses/by/3.0/',
	'wikinews' => '//creativecommons.org/licenses/by/2.5/',
),
'wgRightsText' => array(
	'default' => 'Creative Commons Attribution-Share Alike 3.0',
	'huwikinews' => 'Creative Commons Attribution 3.0',
	'wikinews' => 'Creative Commons Attribution 2.5',
),
'wgRightsIcon' => array(
	'default' => '//creativecommons.org/images/public/somerights20.png',
),

'wmgFileExtensions' => array(
	'default' => array(
		'xcf',
		'pdf',
		'mid',
		'ogg',
		'ogv',
		'svg',
		'djvu',
	),
	'+foundationwiki' => array(
		'otf',
		'ai',
	),
	'+incubatorwiki' => array(
		'xml'
	),
	'+outreachwiki' => array(
		'sla',
	),
),

'wgRedirectSources' => array(
    'default' => false,
    'donatewiki' => '!^https?://donate\.wikimedia\.org/!',
    'foundationwiki' => '!^https?://(www\.)?wikimediafoundation\.org/!',
),

'wmgHTTPSBlacklistCountries' => array(
	'default' => array(
		'IR', // Iran
	),
	'+wiki' => array(
		'CN', // China
	),
),

'wmgBug54847' => array(
	'default' => true,
	'private' => false,
),

'wmgUsePetition' => array(
	'default' => false,
	'testwiki' => true,
	'foundationwiki' => true,
),

'wmgUseClusterSession' => array(
	'default'  => true,
	'labswiki' => false,
),

'wmgUseClusterSquid' => array(
	'default'  => true,
	'labswiki' => false,
),

'wmgUseClusterFileBackend' => array(
	'default'  => true,
	'labswiki' => false,
),

'wmgUseClusterJobqueue' => array(
	'default'  => true,
	'labswiki' => false,
),

);


### WMF Labs override #####
if ( $wmfRealm == 'labs' ) {
	require( "$wmfConfigDir/InitialiseSettings-labs.php" );
	wmfLabsOverrideSettings();
}
