<?php
# This file was installed with MediaWiki 1.24.22. If you make manual
# changes, please keep track in case you need to recreate them later.
#
# See includes/DefaultSettings.php for all configurable settings
# and their default values, but don't forget to make changes in _this_
# file, not there.
#
# Further documentation for configuration settings may be found at:
# http://www.mediawiki.org/wiki/Manual:Configuration_settings

# Protect against web entry
if ( !defined( 'MEDIAWIKI' ) ) {
	exit;
}

## Uncomment this to disable output compression
# $wgDisableOutputCompression = true;

$wgSitename         = 'WP-MIRROR';
$wgMetaNamespace    = false;

## The URL base path to the directory containing the wiki;
## defaults for all runtime URL paths are based off of this.
## For more information on customizing the URLs
## (like /w/index.php/Page_title to /wiki/Page_title) please see:
## http://www.mediawiki.org/wiki/Manual:Short_URL
$wgScriptPath       = '/w';
$wgScriptExtension  = '.php';
$wgArticlePath      = '/wiki/$1';

## The protocol and server name to use in fully-qualified URLs
$wgServer           = '//localhost';
$wgCanonicalServer  = 'https://localhost';

## The relative URL path to the skins directory
$wgStylePath        = $wgScriptPath . '/skins';

## The relative URL path to the logo.  Make sure you change this from the default,
## or else you'll overwrite your logo when you upgrade!
$wgLogo             = $wgStylePath . '/common/images/wiki.png';

## UPO means: this is also a user preference option

$wgEnableEmail      = false;
$wgEnableUserEmail  = false; # UPO

$wgEmergencyContact = 'webmaster@localhost';
$wgPasswordSender   = 'webmaster@localhost';

$wgEnotifUserTalk      = false; # UPO
$wgEnotifWatchlist     = false; # UPO
$wgEmailAuthentication = false;

## Database settings
$wgDBtype           = 'mysql';
$wgDBserver         = 'localhost';
$wgDBname           = 'simplewiki';
$wgDBuser           = 'wikiuser'; # appended below
$wgDBpassword       = '********'; # appended below

# MySQL specific settings
$wgDBprefix         = "";

# MySQL table options to use during installation or update
$wgDBTableOptions   = "ENGINE=InnoDB, DEFAULT CHARSET=binary";

# Experimental charset support for MySQL 5.0.
$wgDBmysql5         = false;

## Shared memory settings
$wgMainCacheType    = CACHE_NONE;
$wgMemCachedServers = array();

## To enable image uploads, make sure the 'images' directory
## is writable, then set this to true:
$wgEnableUploads   = false;
#$wgUseImageMagick = true;
#$wgImageMagickConvertCommand = "/usr/bin/convert";

# InstantCommons allows wiki to use images from http://commons.wikimedia.org
$wgUseInstantCommons = false;

## If you use ImageMagick (or any other shell command) on a
## Linux server, this will need to be set to the name of an
## available UTF-8 locale
$wgShellLocale     = 'en_US.utf8';

## If you want to use image uploads under safe mode,
## create the directories images/archive, images/thumb and
## images/temp, and make them all writable. Then uncomment
## this, if it's not already uncommented:
#$wgHashedUploadDirectory = false;

## Set $wgCacheDirectory to a writable directory on the web server
## to make your wiki go slightly faster. The directory should not
## be publically accessible from the web.
#$wgCacheDirectory = "$IP/cache";
$wgInterwikiCache  = "$IP/cache/interwiki.cdb";

# Site language code, should be one of the list in ./languages/Names.php
$wgLanguageCode    = 'en';

$wgSecretKey       = '4e2b40a4b137cf831b18d93f2367c943bdc8da22177734be9f1db0c9617d8b3d';

# Site upgrade key. Must be set to a string (default provided) to turn on the
# web installer while LocalSettings.php is in place
$wgUpgradeKey      = 'eb1501882ead707c';

## Default skin: you can change the default skin. Use the internal symbolic
## names, ie 'cologneblue', 'monobook', 'vector':
$wgDefaultSkin     = 'vector';

## For attaching licensing metadata to pages, and displaying an
## appropriate copyright notice / icon. GNU Free Documentation
## License and Creative Commons licenses are supported so far.
$wgRightsPage      = ''; # Set to the title of a wiki page that describes your license/copyright
$wgRightsUrl       = '';
$wgRightsText      = '';
$wgRightsIcon      = '';

# Path to the GNU diff3 utility. Used for conflict resolution.
$wgDiff3           = '/usr/bin/diff3';

# End of automatically generated settings.
# Add more configuration options below.

# Enabled Skins.
# CologneBlue                  (see 'LocalSettings_wpmirror.php')
# Modern                       (see 'LocalSettings_wpmirror.php')
# MonoBook                     (see 'LocalSettings_wpmirror.php')
# Nostalgia                    (see 'LocalSettings_wpmirror.php')
# Vector                       (see 'LocalSettings_wpmirror.php')

# Enabled Extensions. 
# ApiSandbox                   (see 'LocalSettings_wpmirror.php')
# Babel                        (see 'LocalSettings_wpmirror.php')
# BetaFeatures                 (see 'LocalSettings_wpmirror.php')
# CategoryTree                 (see 'LocalSettings_wpmirror.php')
# CharInsert                   (see 'LocalSettings_wpmirror.php')
# CirrusSearch                 (see 'LocalSettings_wpmirror.php')
# Cite                         (see 'LocalSettings_wpmirror.php')
# SpecialCite                  (see 'LocalSettings_wpmirror.php')
# cldr                         (see 'LocalSettings_wpmirror.php')
# CodeEditor                   (see 'LocalSettings_wpmirror.php')
# Collection                   (see 'LocalSettings_wpmirror.php')
# CommonsMetadata              (see 'LocalSettings_wpmirror.php')
# CustomData                   (see 'LocalSettings_wpmirror.php')
# Disambiguator                (see 'LocalSettings_wpmirror.php')
# DoubleWiki                   (see 'LocalSettings_wpmirror.php')
# Elastica                     (see 'LocalSettings_wpmirror.php')
# Gadgets                      (see 'LocalSettings_wpmirror.php')
# GeoCrumbs                    (see 'LocalSettings_wpmirror.php')
# GeoData                      (see 'LocalSettings_wpmirror.php')
# ImageMap                     (see 'LocalSettings_wpmirror.php')
# InputBox                     (see 'LocalSettings_wpmirror.php')
# intersection/DynamicPageList (see 'LocalSettings_wpmirror.php')
# Interwiki                    (see 'LocalSettings_wpmirror.php')
# JsonConfig                   (see 'LocalSettings_wpmirror.php')
# LabeledSectionTransclusion   (see 'LocalSettings_wpmirror.php')
# LocalisationUpdate           (see 'LocalSettings_wpmirror.php')
# Mantle                       (see 'LocalSettings_wpmirror.php')
# MapSources                   (see 'LocalSettings_wpmirror.php')
# Math                         (see 'LocalSettings_wpmirror.php')
# MobileApp                    (see 'LocalSettings_wpmirror.php')
# MobileFrontend               (see 'LocalSettings_wpmirror.php')
# MultimediaViewer             (see 'LocalSettings_wpmirror.php')
# MwEmbedSupport               (see 'LocalSettings_wpmirror.php')
# OpenSearchXml                (see 'LocalSettings_wpmirror.php')
# PagedTiffHandler             (see 'LocalSettings_wpmirror.php')
# PageImages                   (see 'LocalSettings_wpmirror.php')
# ParserFunctions              (see 'LocalSettings_wpmirror.php')
# Parsoid                      (see 'LocalSettings_wpmirror.php')
# PdfHandler                   (see 'LocalSettings_wpmirror.php')
# Poem                         (see 'LocalSettings_wpmirror.php')
# Popups                       (see 'LocalSettings_wpmirror.php')
# ProofreadPage                (see 'LocalSettings_wpmirror.php')
# Quiz                         (see 'LocalSettings_wpmirror.php')
# RandomRootPage               (see 'LocalSettings_wpmirror.php')
# Score                        (see 'LocalSettings_wpmirror.php')
# Scribunto                    (see 'LocalSettings_wpmirror.php')
# Solarium                     (see 'LocalSettings_wpmirror.php')
# SyntaxHighlight_GeSHi        (see 'LocalSettings_wpmirror.php')
# TemplateData                 (see 'LocalSettings_wpmirror.php')
# TemplateSandbox              (see 'LocalSettings_wpmirror.php')
# TextExtracts                 (see 'LocalSettings_wpmirror.php')
# TimedMediaHandler            (see 'LocalSettings_wpmirror.php')
# Timeline                     (see 'LocalSettings_wpmirror.php')
# TitleKey                     (see 'LocalSettings_wpmirror.php')
# Translate                    (see 'LocalSettings_wpmirror.php')
# UniversalLanguageSelector    (see 'LocalSettings_wpmirror.php')
# VectorBeta                   (see 'LocalSettings_wpmirror.php')
# VipsScaler                   (see 'LocalSettings_wpmirror.php')
# VisualEditor                 (see 'LocalSettings_wpmirror.php')
# Wikidata                     (see 'LocalSettings_wpmirror.php')
# WikiEditor                   (see 'LocalSettings_wpmirror.php')
# wikihiero                    (see 'LocalSettings_wpmirror.php')
# ZeroBanner                   (see 'LocalSettings_wpmirror.php')
# ZeroPortal                   (see 'LocalSettings_wpmirror.php')

## Changes v1.23 --> v1.24.22
# 0) all
# 1) wikinews
#    add (DynamicPageList)
# 2) wikipedia
#    add (CommonsMetadata, MultimediaViewer, PageImages, Parsoid, Popups)
#    add (ZeroBanner, ZeroPortal)
#    del (ZeroRatedMobileAccess)
# 3) wikisource
#    add (DoubleWiki, ProofreadPage, RandomRootPage)
# 4) wikiversity
#    add (Quiz)
# 5) wikivoyage
#    add (CustomData, GeoCrumbs, MapSources)

## WP-MIRROR specific include:
$wmfConfigDir = '/etc/wp-mirror-mediawiki';

# database credentials
if (is_file( "$wmfConfigDir/LocalSettings_account.php" ) ) {
        include( "$wmfConfigDir/LocalSettings_account.php" );
}

# WP-MIRROR specific settings
if (is_file( "$wmfConfigDir/LocalSettings_wpmirror.php" ) ) {
        include( "$wmfConfigDir/LocalSettings_wpmirror.php" );
}
