<?php

# This file was generated during the installation of `wp-mirror'.  If
# you make manual changes, please add comments (e.g. your name and
# date) in case you need to revert them later.

## Helper functions
function url_org2site( $url ) {
        // convert 'foo://bar.org/baz' to 'foo://bar.site/baz'
	$replace = array (
		 'wikibooks.org'   => 'wikibooks.site',
		 'wikidata.org'    => 'wikidata.site',
		 'wikimedia.org'   => 'wikimedia.site',
		 'wikimediafoundation.org' => 'wikimediafoundation.site',
		 'wikinews.org'    => 'wikinews.site',
		 'wikipedia.org'   => 'wikipedia.site',
		 'wikiquote.org'   => 'wikiquote.site',
		 'wikisource.org'  => 'wikisource.site',
		 'wikiversity.org' => 'wikiversity.site',
		 'wikivoyage.org'  => 'wikivoyage.site',
		 'wiktionary.org'  => 'wiktionary.site',
	);
	return str_replace( array_keys($replace),array_values($replace), $url );
}

function servername2dbname( $conf ) {
        // convert 'simple.wikipedia.site' to 'simplewiki'
	// 0 - look for exact match like 'wikidatawiki' => '//www.wikidata.site'
        foreach ( $conf->settings['wgServer'] as $key => $value ) {
	        if ( '//' . $_SERVER['SERVER_NAME'] == url_org2site( $value ) ) {
		        return $key;
		}
	}
	// 1 - look for suffix match like 'wikibooks'
	foreach( $conf->suffixes as $key => $value ) {
                #var_dump( $value );
		if ( preg_match( '/^(.*)\.' . $value . '\.site$/',
		                 $_SERVER['SERVER_NAME'], $matches ) ) {
                        $lang = $matches[1];
			return $lang . $value;
		}
	}
	// 2 - look for default 'wikipedia' => 'wiki'
	foreach( $conf->suffixes as $key => $value ) {
                #var_dump( $key );
		if ( preg_match( '/^(.*)\.' . $key . '\.site$/',
		                 $_SERVER['SERVER_NAME'], $matches ) ) {
                        $lang = $matches[1];
			return $lang . $value;
		}
	}
}

##-bits-taken-from-CommonSettings.php-begin-----------------------------------+
## From <https://noc.wikimedia.org/conf/CommonSettings.php>
# Determine realm
$wmfRealm = 'production';
# Must be set before InitialiseSettings.php
$wmfUdp2logDest = '127.0.0.1:8420';

## Initialise wgConf
## (see <https://noc.wikimedia.org/conf/wgConf.php>)
## (see includes/SiteConfiguration.php)
$wgConf = new SiteConfiguration;

# Array of suffixes, for self::siteFromDB()
$wgConf->suffixes = array(
	// 'wikipedia',
	'wikipedia' => 'wiki',
	'wiktionary',
	'wikiquote',
	'wikibooks',
	'wikiquote',
	'wikinews',
	'wikisource',
	'wikiversity',
	'wikimedia',
	'wikivoyage',
);

# Array of domains that are local and can be handled by the same server
$wgConf->localVHosts = array(
	'wikipedia.site',
	'wiktionary.site',
	'wikiquote.site',
	'wikibooks.site',
	'wikiquote.site',
	'wikinews.site',
	'wikisource.site',
	'wikiversity.site',
	'wikivoyage.site',
	'wikimedia.site',
);

# Array of wikis, should be the same as $wgLocalDatabases
$wgConf->wikis = array_map( 'trim', file( "$wmfConfigDir/all.dblist" ) );
$wgLocalDatabases =& $wgConf->getLocalDatabases();

# Optional callback to load full configuration data
function wmfLoadInitialiseSettings( $conf ) {
	global $wmfConfigDir;
	require( "$wmfConfigDir/InitialiseSettings.php" );
}
$wgConf->fullLoadCallback = 'wmfLoadInitialiseSettings';
require( "$wmfConfigDir/InitialiseSettings.php" );
$wgDBname = servername2dbname( $wgConf );
#var_dump( '$wgDBname: ' . $wgDBname );

# Determine domain and language and the directories for this instance
list( $site, $lang ) = $wgConf->siteFromDB( $wgDBname );

# Get configuration from SiteConfiguration object
$wikiTags = array();
$dbSuffix = ( $site === 'wikipedia' ) ? 'wiki' : $site;
$globals  = $wgConf->getAll( $wgDBname, $dbSuffix,
        array(
	        'lang'    => $lang,
		'docRoot' => $_SERVER['DOCUMENT_ROOT'],
		'site'    => $site,
		'stdlogo' => "$wgServer/$site/$lang/b/bc/Wiki.png",
	), $wikiTags );
#var_dump( $globals );
extract( $globals );
##-bits-taken-from-CommonSettings.php-end-------------------------------------+

##-changes-to-InitialiseSettings.php-begin------------------------------------+
## Several globals extracted from InitialiseSettings.php contain
## o URLs with `.org' instead of `.site';
## o inappropriate directories or paths; or
## o other inappropriate values.
## These must be corrected for the mirror to function. In order of
## appearance, they are:

$wgLogo                 = "$wgScriptPath/wp-mirror.png";
$wgUploadNavigationUrl  = url_org2site( $wgUploadNavigationUrl  );
$wgServer               = url_org2site( $wgServer               );
$wgCanonicalServer      = url_org2site( $wgCanonicalServer      );
$wgSiteSupportPage      = url_org2site( $wgSiteSupportPage      );
$wgUploadPath           = "$wgScriptPath/images/$site/$lang";
$wgUploadDirectory      = "$IP/images/$site/$lang";
$wgImgAuthUrlPathMap    = array();
$wgOverrideSiteFeed     = url_org2site( $wgOverrideSiteFeed     );
$wgNoFollowDomainExceptions = url_org2site( $wgNoFollowDomainExceptions );
$wmgRC2UDPAddress       = '127.0.0.1';
$wgSVGConverter         = 'ImageMagick';
$wgSVGConverterPath     = '';
$wmgMathFileBackend     = false;
$wmgMathPath            = "$wgUploadPath/math";
$wmgScorePath           = "$wgUploadPath/lilypond";
$wmgScoreFileBackend    = false;
$wgFavicon              = "$wgScriptPath/favicon.ico";
$wgAppleTouchIcon       = false;
$wmgCentralAuthLoginIcon = $wgLogo;
#$wmgCentralAuthAutoLoginWikis = false; //Fix me
$wgCopyUploadProxy      = false;
$wgCopyUploadsDomains   = array();
$wmgUsePopups           = true;
$wmgUseVectorBeta       = true;
$wmgVectorBetaPersonalBar = true;
$wmgULSCompactLinks     = true;
$wmgUseVisualEditor     = true;
$wmgVisualEditorDefault = true;
$wmgRSSUrlWhitelist     = array();
$wgParserCacheType      = CACHE_NONE;
$wgLanguageConverterCacheType = CACHE_NONE;
$wgUploadMissingFileUrl = url_org2site( $wgUploadMissingFileUrl );
$wmgMoodBarInfoUrl      = url_org2site( $wmgMoodBarInfoUrl      );
$wmgMobileFrontendLogo  = $wgLogo;
$wmgMobileUrlTemplate   = array(
	'default' => '%h0.%h1.%h2',
	'foundationwiki' => '%h0.%h1',
	'mediawikiwiki' => '%h1.%h2',
	'sourceswiki' => '%h0.%h1', // bug 36002
);
$wmgMFCustomLogos       = array();
$wmgMFPhotoUploadEndpoint = url_org2site( $wmgMFPhotoUploadEndpoint );
$wmgMFAppPackageId      = url_org2site( $wmgMFAppPackageId      );
$wmgUseTranslate        = true; # force true for all, to cure `wikidata' error
$wmgEchoHelpPage        = url_org2site( $wmgEchoHelpPage        );
$wmgEchoSiteNotificationIconUrl = url_org2site( $wmgEchoSiteNotificationIconUrl );
$wmgNotificationSender  = url_org2site ( $wmgNotificationSender );
$wgRightsIcon           = "$wgScriptPath/resources/assets/licenses/somerights20.png";
$wgRedirectSources      = url_org2site ( $wgRedirectSources     );
#-extensions-disabled---------------------------------------------------------+
$wmgUseBetaFeatures     = false;
#$wmgUseCirrus           = false;
#$wmgUseCirrusAsAlternative = false;
##-changes-to-InitialiseSettings.php-end--------------------------------------+

## Database
$wgDBprefix             = '';

## Images
$wgFileExtensions       = array_merge( $wgFileExtensions, $wmgFileExtensions );
# local repository - /var/lib/wp-mirror-mediawiki/images/wikipedia/simple
$wgEnableUploads        = true;

# remote repository - /var/lib/wp-mirror-mediawiki/images/wikipedia/commons
$wgSharedUploadDBname   = 'commonswiki';
$wgSharedUploadDirectory= "$IP/images/wikipedia/commons";
$wgSharedUploadPath     = "$wgScriptPath/images/wikipedia/commons";
$wgForeignFileRepos[]   = array(
       'class'            => 'ForeignDBViaLBRepo',
       'name'             => $wgSharedUploadDBname,
       'url'              => $wgSharedUploadPath,
       'directory'        => $wgSharedUploadDirectory,
       'hashLevels'       => 2, // This must be the same for all wikis in family
       'dbType'           => $wgDBtype,
       'dbServer'         => $wgDBserver,
       'dbUser'           => $wgDBuser,
       'dbPassword'       => $wgDBpassword,
       'dbFlags'          => DBO_DEFAULT,
       'dbName'           => $wgSharedUploadDBname,
       'tablePrefix'      => '',
       'hasSharedCache'   => false,
       'descBaseUrl'      => '//commons.wikimedia.site/wiki/Image:',
       'fetchDescription' => false,
       'wiki'             => $wgSharedUploadDBname,
);

# thumb
$wgUseImageMagick       = true;
$wgImageMagickConvertCommand = '/usr/bin/convert';
$wgCustomConvertCommand = false;
$wgSVGConverter         = 'ImageMagick';
#$wgUseImageMagick       = false;
#$wgCustomConvertCommand = '/usr/bin/gm convert %s -resize %wx%h %d';
#$wgSVGConverter         = 'inkscape';

## Load balancer - preferred by `wikidata' and by `TimedMediaHandler'
$wgLBFactoryConf        = array(
       'class'            => 'LBFactoryMulti',
       'serverTemplate'   => array(
                            'dbname'       => $wgDBname,
                            'user'         => $wgDBuser,
                            'password'     => $wgDBpassword,
                            'type'         => 'mysql',
                            'flags'        => DBO_DEFAULT | DBO_DEBUG,
                            'max lag'      => 30,
                            'fakeSlaveLag' => 1,
                          ),
       'sectionLoads'     => array(
                            'DEFAULT'      => array( 'localhost'  => 1,
                                                     'local1'     => 1,
                                                   ),
                            'repo'         => array( 'local2'     => 1,
                                                     'local3'     => 1,
                                                   ),
                          ),
       'sectionsByDB'     => array(
                            $wgDBname      => 'DEFAULT',
                            'wikidatawiki' => 'repo',
			  ),
       'hostsByName'      => array(
                            'localhost'    => '127.0.0.1:3306',
                            'local1'       => '127.0.2.1',
                            'local2'       => '127.0.2.2',
                            'local3'       => '127.0.2.3',
			  ),
       'masterTemplateOverrides' => array ( 'fakeMaster' => true ),
);
$wgAllDBsAreLocalhost   = true;

## Extensions
$wgExtensionAssetsPath  = "$wgScriptPath/extensions";

#-ApiSandbox-begin------------------------------------------------------------+
# Taken from <https://noc.wikimedia.org/conf/CommonSettings.php>
if ( $wmgUseApiSandbox ) {
	require_once( "$IP/extensions/ApiSandbox/ApiSandbox.php" );
}
#-ApiSandbox-end--------------------------------------------------------------+

#-Babel-begin-----------------------------------------------------------------+
# Taken from <https://noc.wikimedia.org/conf/CommonSettings.php>
if ( $wmgUseBabel ) {
	require_once( "$IP/extensions/Babel/Babel.php" );
	$wgBabelCategoryNames = $wmgBabelCategoryNames;
	$wgBabelMainCategory = $wmgBabelMainCategory;
	$wgBabelDefaultLevel = $wmgBabelDefaultLevel;
	$wgBabelUseUserLanguage = $wmgBabelUseUserLanguage;
}
#-Babel-end-------------------------------------------------------------------+

#-BetaFeatures-begin----------------------------------------------------------+
# Taken from <https://noc.wikimedia.org/conf/CommonSettings.php>
if ( $wmgUseBetaFeatures ) {
	require_once( "$IP/extensions/BetaFeatures/BetaFeatures.php" );
	if ( $wmgBetaFeaturesWhitelist ) {
		$wgBetaFeaturesWhitelist = $wmgBetaFeaturesWhitelist;

		// Disabled until (at least) 30-Sept-2014; see bug 64415. -- ori & aude
		if ( $wgDBname === 'wikidatawiki' ) {
			$key = array_search( 'HHVM', $wgBetaFeaturesWhitelist );
			if ( $key !== false ) {
				unset( $wgBetaFeaturesWhitelist[$key] );
			}
			unset( $key );
		}
	}
}
#-BetaFeatures-end------------------------------------------------------------+

#-CategoryTree-begin----------------------------------------------------------+
# Based on <https://noc.wikimedia.org/conf/CommonSettings.php>
if ( $wmgUseCategoryTree ) {
	require_once( $IP . '/extensions/CategoryTree/CategoryTree.php' );
        $wgCategoryTreeDynamicTag = true;
        $wgCategoryTreeCategoryPageMode = $wmgCategoryTreeCategoryPageMode;
        $wgCategoryTreeCategoryPageOptions = $wmgCategoryTreeCategoryPageOptions;
}
#-CategoryTree-end------------------------------------------------------------+

#-CharInsert-begin------------------------------------------------------------+
# Taken from <https://noc.wikimedia.org/conf/CommonSettings.php>
include( $IP . '/extensions/CharInsert/CharInsert.php' );
#-CharInsert-end--------------------------------------------------------------+

#-CirrusSearch-begin----------------------------------------------------------+
# Based on <https://noc.wikimedia.org/conf/CommonSettings.php>
if ( $wmgUseCirrus || $wmgUseCirrusAsAlternative ) {
        require_once( "$IP/extensions/Elastica/Elastica.php" );
        require_once( "$IP/extensions/CirrusSearch/CirrusSearch.php" );
}
# Based on <https://noc.wikimedia.org/conf/CirrusSearch-common.php> begin
if ( $wmgUseCirrus ) {
        $wgSearchType = 'CirrusSearch';
        $wgSearchTypeAlternatives = array( 'LuceneSearch' );
        $wgEnableLucenePrefixSearch = false;
        $wgCirrusSearchShowNowUsing = true;
} else {
        $wgSearchTypeAlternatives = array( 'CirrusSearch' );
        $wgCirrusSearchEnablePref = true;
}
if ( $wmgUseClusterJobqueue ) {
        # The secondary update job has a delay of a few seconds to make sure
        # that Elasticsearch has completed a refresh cycle between when the
        # data that the job needs is added and when the job is run.
        $wgJobTypeConf['cirrusSearchIncomingLinkCount'] = array( 'checkDelay' => true ) +
                $wgJobTypeConf['default'];
}

# Turn off the more accurate but slower search mode.  It is most helpful when
# you have many small shards.  We don't do that in production and we could use
# the speed.
$wgCirrusSearchMoreAccurateScoringMode = false;

# Raise the refresh interval to save some CPU at the cost of being slightly
# less realtime.
$wgCirrusSearchRefreshInterval = 30;

# Set the backoff for Cirrus' job that reacts to template changes - slow and
# steady will help prevent spikes in Elasticsearch load.
$wgJobBackoffThrottling['cirrusSearchLinksUpdate'] = 0.75;
# Also engage a delay for the Cirrus job that counts incoming links to pages
# when pages are newly linked or unlinked.  Too many link count queries at
# once could flood Elasticsearch.
$wgJobBackoffThrottling['cirrusSearchIncomingLinkCount'] = 0.25;

# Ban the hebrew plugin, it is unstable
$wgCirrusSearchBannedPlugins[] = 'elasticsearch-analysis-hebrew';

# Enable the "experimental" highlighter on all wikis
$wgCirrusSearchUseExperimentalHighlighter = true;
$wgCirrusSearchOptimizeIndexForExperimentalHighlighter = true;

# Settings customized per index.
$wgCirrusSearchShardCount = $wmgCirrusSearchShardCount;
$wgCirrusSearchMaxShardsPerNode = $wmgCirrusSearchMaxShardsPerNode;
$wgCirrusSearchPreferRecentDefaultDecayPortion = $wmgCirrusSearchPreferRecentDefaultDecayPortion;
$wgCirrusSearchBoostLinks = $wmgCirrusSearchBoostLinks;
$wgCirrusSearchWeights = array_merge( $wgCirrusSearchWeights, $wmgCirrusSearchWeightsOverrides );
$wgCirrusSearchPowerSpecialRandom = $wmgCirrusSearchPowerSpecialRandom;
$wgCirrusSearchAllFields = $wmgCirrusSearchAllFields;
$wgCirrusSearchNamespaceWeights = array_merge( $wgCirrusSearchNamespaceWeights,
        $wmgCirrusSearchNamespaceWeightOverrides );

// Enable cache warming for wikis with more than one shard.  Cache warming is
// good for smoothing out I/O spikes caused by merges at the cost of
// potentially polluting the cache by adding things that won't be used.

// Wikis with more then one shard is a decent way of saying "wikis we expect
// will get some search traffic every few seconds".  In this commonet the term
// "cache" refers to all kinds of caches: the linux disk cache, Elasticsearch's
// filter cache, whatever.
$wgCirrusSearchMainPageCacheWarmer = ( $wgCirrusSearchShardCount['content'] > 1 );

// Commons is special
if ( $wgDBname == 'commonswiki' ) {
        $wgCirrusSearchNamespaceMappings[ NS_FILE ] = 'file';
        $wgCirrusSearchReplicaCount['file'] = 2;
// So is everyone else, for using commons
} else {
        $wgCirrusSearchExtraIndexes[ NS_FILE ] = array( 'commonswiki_file' );
}
# Based on <https://noc.wikimedia.org/conf/CirrusSearch-common.php> end

#$wgDisableSearchUpdate  = true;
$wgCirrusSearchServers  = array( 'darkstar-4', );

# Taken from <https://noc.wikimedia.org/conf/CirrusSearch-labs.php> begin
if ( $wgDBname == 'enwiki' ) {
        $wgCirrusSearchInterwikiSources = array(
                'wiktionary' => 'enwiktionary',
                'wikibooks' => 'enwikibooks',
                'wikinews' => 'enwikinews',
                'wikiquote' => 'enwikiquote',
                'wikisource' => 'enwikisource',
                'wikiversity' => 'enwikiversity',
        );
}

$wgSearchTypeAlternatives = array();
$wgCirrusSearchAllFields = array( 'build' => true, 'use' => true );
$wgCirrusSearchWikimediaExtraPlugin = array(
        'regex' => array(
                'build',
                'use',
        ),
);

# We don't have enough nodes to support these settings in beta so just turn
# them off.
$wgCirrusSearchMaxShardsPerNode = array();
# Taken from <https://noc.wikimedia.org/conf/CirrusSearch-labs.php> end
#-CirrusSearch-begin----------------------------------------------------------+

#-Cite-begin------------------------------------------------------------------+
# Taken from <https://noc.wikimedia.org/conf/CommonSettings.php>
if ( $wmgUseCite ) {
	require( $IP . '/extensions/Cite/Cite.php' );
}
if ( $wmgUseCite && !$wmgUseCiteThisPage ) {
	require( $IP . '/extensions/Cite/SpecialCite.php' );
}
if ( $wmgUseCiteThisPage ) {
	require( $IP . '/extensions/CiteThisPage/CiteThisPage.php' );
}
#-Cite-end--------------------------------------------------------------------+

#-CLDR-begin------------------------------------------------------------------+
# Taken from <https://noc.wikimedia.org/conf/CommonSettings.php>
if ( $wmgUseCLDR ) {
	require_once( "$IP/extensions/cldr/cldr.php" );
}
#-CLDR-end--------------------------------------------------------------------+

#-CodeEditor-begin------------------------------------------------------------+
# Taken from <https://noc.wikimedia.org/conf/CommonSettings.php>
if ( $wmgUseCodeEditorForCore || $wmgUseScribunto || $wmgZeroPortal ) {
	include_once( "$IP/extensions/CodeEditor/CodeEditor.php" );
	$wgCodeEditorEnableCore = $wmgUseCodeEditorForCore;
}
#-CodeEditor-end--------------------------------------------------------------+

#-Collection-begin------------------------------------------------------------+
if ( $wmgUseCollection ) {
	// PediaPress / PDF generation
	include "$IP/extensions/Collection/Collection.php";
	$wgCollectionMWServeURL = 'http://ocg.svc.eqiad.wmnet:8000';
	// Use pediapress server for POD function
	$wgCollectionCommandToServeURL = array(
		'zip_post' => 'http://tools.pediapress.com/mw-serve/',
	);
	// ...but disable pediapress for now
	// (until https://gerrit.wikimedia.org/r/165234 is deployed)
	$wgCollectionPODPartners = false;
	// MediaWiki namespace is not a good default
	$wgCommunityCollectionNamespace = NS_PROJECT;
	// Allow collecting Help pages
	$wgCollectionArticleNamespaces[] = NS_HELP;
	// Sidebar cache doesn't play nice with this
	$wgEnableSidebarCache = false;
	$wgCollectionFormats = array(
		'rdf2latex' => 'PDF',
		// The following formats used the old mwlib renderer
		// which was shut down Oct 3, 2014.
		// They may eventually be reinstated when new OCG backends
		// are written for them.
	//	'epub' => 'EPUB',
	//	'odf' => 'ODT',
	//	'zim' => 'openZIM',
	//	'rl' => 'mwlib PDF', // replaced by [[:mw:OCG]] 29 Sep 2014
	);
	$wgLicenseURL = "http://creativecommons.org/licenses/by-sa/3.0/";
	$wgCollectionPortletForLoggedInUsersOnly = $wmgCollectionPortletForLoggedInUsersOnly;
	$wgCollectionArticleNamespaces = $wmgCollectionArticleNamespaces;
	if ( $wmgCollectionHierarchyDelimiter ) {
		$wgCollectionHierarchyDelimiter = $wmgCollectionHierarchyDelimiter;
	}
	$wgCollectionPortletFormats = $wmgCollectionPortletFormats;
}
#-Collection-end--------------------------------------------------------------+

#-CommonsMetadata-begin-------------------------------------------------------+
# Taken from <https://noc.wikimedia.org/conf/CommonSettings.php>
if ( $wmgUseCommonsMetadata ) {
	require_once( "$IP/extensions/CommonsMetadata/CommonsMetadata.php" );
	$wgCommonsMetadataSetTrackingCategories = $wmgCommonsMetadataSetTrackingCategories;
}
#-CommonsMetadata-end---------------------------------------------------------+

#-CustomData-begin------------------------------------------------------------+
if ( $wmgUseGeoCrumbs || $wmgUseInsider || $wmgUseRelatedArticles || $wmgUseRelatedSites ) {
	require_once( "$IP/extensions/CustomData/CustomData.php" );
}
#-CustomData-end--------------------------------------------------------------+

#-Disambiguator-begin---------------------------------------------------------+
# Taken from <https://noc.wikimedia.org/conf/CommonSettings.php>
if ( $wmgUseDisambiguator ) {
	require_once( "$IP/extensions/Disambiguator/Disambiguator.php" );
}
#-Disambiguator-end-----------------------------------------------------------+

#-DoubleWiki-begin------------------------------------------------------------+
# Taken from <https://noc.wikimedia.org/conf/CommonSettings.php>
if ( $wmgUseDoubleWiki ) {
	include( $IP . '/extensions/DoubleWiki/DoubleWiki.php' );
}
#-DoubleWiki-end--------------------------------------------------------------+

#-DynamicPageList-begin-------------------------------------------------------+
# Taken from <https://noc.wikimedia.org/conf/CommonSettings.php>
if ( $wmgUseDPL ) {
	include( $IP . '/extensions/intersection/DynamicPageList.php' );
}
#-DynamicPageList-end---------------------------------------------------------+

# EasyTimeline (see Timeline below)

# Elastica (see CirrusSearch above)

#-Gadgets-begin---------------------------------------------------------------+
# Taken from <https://noc.wikimedia.org/conf/CommonSettings.php>
if ( $wmgUseGadgets ) {
	include( "$IP/extensions/Gadgets/Gadgets.php" );
}
#-Gadgets-end-----------------------------------------------------------------+

#-GeoCrumbs-begin-------------------------------------------------------------+
if ( $wmgUseGeoCrumbs ) {
	require_once( "$IP/extensions/GeoCrumbs/GeoCrumbs.php" );
}
#-GeoCrumbs-end---------------------------------------------------------------+

#-GeoData-begin---------------------------------------------------------------+
# Taken from <https://noc.wikimedia.org/conf/CommonSettings.php>
if ( $wmgEnableGeoData
	&& ( $wmgUseCirrus || $wmgUseCirrusAsAlternative ) )
{
	require_once( "$IP/extensions/GeoData/GeoData.php" );
	$wgGeoDataBackend = 'db';
#	$wgGeoDataBackend = 'elastic';
#       $wgGeoDataBackend = 'solr';

	# Data collection mode
	if ( !$wmgEnableGeoSearch ) {
		$wgAPIListModules['geosearch'] = 'ApiQueryDisabled';
	}

	$wgMaxCoordinatesPerPage = 2000;
	$wgMaxGeoSearchRadius = $wmgMaxGeoSearchRadius;
	$wgGeoDataDebug = $wmgGeoDataDebug;
}
#-GeoData-end-----------------------------------------------------------------+

#-ImageMap-begin--------------------------------------------------------------+
# Taken from <https://noc.wikimedia.org/conf/CommonSettings.php>
if ( $wmgUseImageMap ) {
	include( $IP . '/extensions/ImageMap/ImageMap.php' );
}
#-ImageMap-end----------------------------------------------------------------+

#-InputBox-begin--------------------------------------------------------------+
# Taken from <https://noc.wikimedia.org/conf/CommonSettings.php>
if ( $wmgUseInputBox ) {
	include( $IP . '/extensions/InputBox/InputBox.php' );
}
#-InputBox-end----------------------------------------------------------------+

#-Interwiki-begin-------------------------------------------------------------+
if ( file_exists( "$IP/cache/interwiki.cdb" ) ) {
	$wgInterwikiCache = "$IP/cache/interwiki.cdb";
}
if ( $wmgEnableInterwiki ) {
	require_once( "$IP/extensions/Interwiki/Interwiki.php" );
	$wgInterwikiViewOnly = true;
}
#-Interwiki-end---------------------------------------------------------------+

# JsonConfig (see ZeroPortal below)

#-LabeledSectionTransclusion-begin--------------------------------------------+
# Based on <https://noc.wikimedia.org/conf/CommonSettings.php>
if ( $wmgUseLabeledSectionTransclusion ) {
	include( $IP . '/extensions/LabeledSectionTransclusion/lst.php' );
        require_once( "$IP/extensions/LabeledSectionTransclusion/lsth.php" );
}
#-LabeledSectionTransclusion-end----------------------------------------------+

#-LocalisationUpdate-begin----------------------------------------------------+
# Based on <https://noc.wikimedia.org/conf/CommonSettings.php>
if ( $wmgUseLocalisationUpdate ) {
	require_once( "$IP/extensions/LocalisationUpdate/LocalisationUpdate.php" );
        $wgLocalisationUpdateDirectory = "$IP/cache";
}
#-LocalisationUpdate-end------------------------------------------------------+

#-Mantle-begin----------------------------------------------------------------+
# Taken from <https://noc.wikimedia.org/conf/CommonSettings.php>
if ( $wmgMobileFrontend || $wmgUseFlow ) {
	// Needed for Flow frontend-rewrite and MobileFrontend
	require_once( "$IP/extensions/Mantle/Mantle.php" );
}
#-Mantle-end------------------------------------------------------------------+

#-MapSources-begin------------------------------------------------------------+
if ( $wmgUseMapSources ) {
	require_once( "$IP/extensions/MapSources/MapSources.php" );
}
#-MapSources-end--------------------------------------------------------------+

#-Math-begin------------------------------------------------------------------+
# Based on <https://noc.wikimedia.org/conf/CommonSettings.php>
if ( $wmgUseMath ) {
	require_once( "$IP/extensions/Math/Math.php" );
	$wgTexvc = '/usr/bin/wp-mirror-texvc';
	$wgMathTexvcCheckExecutable = '/usr/bin/wp-mirror-texvccheck';
	if ( $wgDBname === 'hewiki' ) {
		$wgDefaultUserOptions['math'] = 0;
	}
	$wgMathFileBackend = $wmgMathFileBackend;
	$wgMathDirectory   = "$wgUploadDirectory/math"; // just for sanity
	$wgMathPath        = $wmgMathPath;
	$wgUseMathJax      = true;
        $wgDefaultUserOptions['mathJax'] = true;
	$wgMathDisableTexFilter = true; // severe performance regression; --Aaron
	// This variable points to non-WMF servers by default.
	// Prevent accidental use.
	$wgMathLaTeXMLUrl = null;
	$wgMathMathMLUrl = null;
}
#-Math-end--------------------------------------------------------------------+

# Misc
$wgUseTidy              = true;
$wgInterwikiMagic       = true;
$wgHideInterlanguageLinks = false;
#$wgLanguageCode         = $lang;

#-MobileApp-begin-------------------------------------------------------------+
# Taken from <https://noc.wikimedia.org/conf/CommonSettings.php>
if ( $wmgUseMobileApp ) {
	require_once( "$IP/extensions/MobileApp/MobileApp.php" );
}
#-MobileApp-end---------------------------------------------------------------+

#-MobileFrontend-begin--------------------------------------------------------+
# Taken from <https://noc.wikimedia.org/conf/CommonSettings.php>
# Taken from <https://noc.wikimedia.org/conf/mobile.php>
if ( $wmgMobileFrontend ) {
        require_once( "$IP/extensions/MobileFrontend/MobileFrontend.php" );
        $wgMFMobileHeader = 'X-Subdomain';
        $wgMFNoindexPages = false;
        $wgMFNearby = $wmgMFNearby && $wmgEnableGeoData;
        $wgMFPhotoUploadEndpoint = $wmgMFPhotoUploadEndpoint;
        $wgMFUseCentralAuthToken = $wmgMFUseCentralAuthToken;
        $wgMFEnableWikiGrok = $wmgMFEnableWikiGrok;
        $wgMFPhotoUploadWiki = $wmgMFPhotoUploadWiki;
        $wgMFContentNamespace = $wmgMFContentNamespace;
        // FIXME: Remove in a week when cache has cleared
        $wgMFNearbyNamespace = $wmgMFContentNamespace;
        $wgMFPhotoUploadAppendToDesc = $wmgMFPhotoUploadAppendToDesc;

        if ( $wmgMobileFrontendLogo ) {
                $wgMobileFrontendLogo = $wmgMobileFrontendLogo;
        }
        if ( $wmgMFCustomLogos ) {
                if ( isset( $wmgMFCustomLogos['copyright'] ) ) {
                        $wmgMFCustomLogos['copyright'] = str_replace( '{wgExtensionAssetsPath}', $wgExtensionAssetsPath, $wmgMFCustomLogos['copyright'] );
                }
                $wgMFCustomLogos = $wmgMFCustomLogos;
        }
        // If a URL template is set for MobileFrontend, use it.
        if ( $wmgMobileUrlTemplate ) {
                $wgMobileUrlTemplate = $wmgMobileUrlTemplate;
        }
        if ( $wmgZeroBanner && !$wmgZeroPortal ) {
                require_once( "$IP/extensions/JsonConfig/JsonConfig.php" );
                require_once( "$IP/extensions/ZeroBanner/ZeroBanner.php" );

#                $wgJsonConfigs['JsonZeroConfig']['remote'] = array(
#                        'url' => 'https://zero.wikimedia.org/w/api.php',
#                        'username' => $wmgZeroPortalApiUserName,
#                        'password' => $wmgZeroPortalApiPassword,
#                );
                // @TODO: which group(s) on all wikies should Zero allow to flush cache?
                $wgGroupPermissions['sysop']['jsonconfig-flush'] = true;
                // $wgZeroBannerFont = '/usr/share/fonts/truetype/ttf-dejavu/DejaVuSans.ttf';
                // $wgZeroBannerFontSize = '10';
        }
        // Enable loading of desktop-specific resources from MobileFrontend
        if ( $wmgMFEnableDesktopResources ) {
                $wgMFEnableDesktopResources = true;
        }
        // Enable appending of TM (text) / (R) (icon) on site name in footer.
        $wgMFTrademarkSitename = $wmgMFTrademarkSitename;
       // Enable X-Analytics logging
        $wgMFEnableXAnalyticsLogging = $wmgMFEnableXAnalyticsLogging;
        // Blacklist some pages
        $wgMFNoMobileCategory = $wmgMFNoMobileCategory;
        $wgMFNoMobilePages = $wmgMFNoMobilePages;
        // Hack to work around https://bugzilla.wikimedia.org/show_bug.cgi?id=35215
        $wgHooks['EnterMobileMode'][] = function() {
                global $wgCentralHost, $wgCentralPagePath, $wgCentralBannerDispatcher, $wgCentralBannerRecorder, $wgCentralAuthCookieDomain;

                $wgCentralHost = str_replace( 'meta.wikimedia.org', 'meta.m.wikimedia.org', $wgCentralHost );
                $wgCentralPagePath = str_replace( 'meta.wikimedia.org', 'meta.m.wikimedia.org', $wgCentralPagePath );
                $wgCentralBannerDispatcher = str_replace( 'meta.wikimedia.org', 'meta.m.wikimedia.org', $wgCentralBannerDispatcher );
                $wgCentralBannerRecorder = str_replace( 'meta.wikimedia.org', 'meta.m.wikimedia.org', $wgCentralBannerRecorder );

                // Hack for bug https://bugzilla.wikimedia.org/show_bug.cgi?id=47647
                if ( $wgCentralAuthCookieDomain == 'commons.wikimedia.org' ) {
                        $wgCentralAuthCookieDomain = 'commons.m.wikimedia.org';
                } elseif ( $wgCentralAuthCookieDomain == 'meta.wikimedia.org' ) {
                        $wgCentralAuthCookieDomain = 'meta.m.wikimedia.org';
                }

                return true;
        };

        $wgMFEnableSiteNotice = $wmgMFEnableSiteNotice;
        $wgMFCollapseSectionsByDefault = $wmgMFCollapseSectionsByDefault;
        $wgMFTidyMobileViewSections = false; // experimental
        // Link to help Google spider associate pages on wiki with our Android app.
        // They originally special-cased us but would like it done the normal way now. :)
        $wgMFAppPackageId = $wmgMFAppPackageId;
        $wgMFNearbyRange = $wmgMaxGeoSearchRadius;

        $wgMFPageActions = array_diff( $wgMFPageActions, $wmgMFRemovePageActions );
        // restrict access to mobile Uploads to users with minimum editcount https://bugzilla.wikimedia.org/show_bug.cgi?id=62598
        $wgMFUploadMinEdits = $wmgMFUploadMinEdits;
        // Disable mobile uploads per https://bugzilla.wikimedia.org/62598
        $wgGroupPermissions['autoconfirmed']['mf-uploadbutton'] = false;
        $wgGroupPermissions['sysop']['mf-uploadbutton'] = false;

        $wgMFEnableBeta = true;
}
#-MobileFrontend-end----------------------------------------------------------+

#-MultimediaViewer-begin------------------------------------------------------+
# Taken from <https://noc.wikimedia.org/conf/CommonSettings.php>
if ( $wmgUseMultimediaViewer ) {
	require_once( "$IP/extensions/MultimediaViewer/MultimediaViewer.php" );
	$wgNetworkPerformanceSamplingFactor = $wmgNetworkPerformanceSamplingFactor;
	$wgMediaViewerDurationLoggingSamplingFactor = $wmgMediaViewerDurationLoggingSamplingFactor;
	$wgMediaViewerAttributionLoggingSamplingFactor = $wmgMediaViewerAttributionLoggingSamplingFactor;
	$wgMediaViewerDimensionLoggingSamplingFactor = $wmgMediaViewerDimensionLoggingSamplingFactor;
	$wgMediaViewerActionLoggingSamplingFactorMap = $wmgMediaViewerActionLoggingSamplingFactorMap;
	if ( isset( $wmgMediaViewerEnableByDefault ) ) {
		$wgMediaViewerEnableByDefault = $wmgMediaViewerEnableByDefault;
	}
	if ( isset( $wmgMediaViewerEnableByDefaultForAnonymous ) ) {
		$wgMediaViewerEnableByDefaultForAnonymous = $wmgMediaViewerEnableByDefaultForAnonymous;
	}
	if ( $wmgMediaViewerUseThumbnailGuessing ) {
		$wgMediaViewerUseThumbnailGuessing = true;
	}
}
#-MultimediaViewer-end--------------------------------------------------------+

#-MWEmbedSupport-begin--------------------------------------------------------+
# Taken from <https://noc.wikimedia.org/conf/CommonSettings.php>
if ( $wmgUseMwEmbedSupport ) {
	require_once( "$IP/extensions/MwEmbedSupport/MwEmbedSupport.php" );
}
#-MWEmbedSupport-end----------------------------------------------------------+

#-OpenSearchXml-begin---------------------------------------------------------+
# Taken from <https://noc.wikimedia.org/conf/CommonSettings.php>
include( "$IP/extensions/OpenSearchXml/OpenSearchXml.php" );
$wgEnableOpenSearchSuggest = true;
#-OpenSearchXml-end-----------------------------------------------------------+

#-PagedTiffHandler-begin------------------------------------------------------+
# Based on <https://noc.wikimedia.org/conf/CommonSettings.php>
include( $IP . '/extensions/PagedTiffHandler/PagedTiffHandler.php' );
$wgTiffUseTiffinfo = true;
$wgTiffMaxMetaSize = 1048576;
$wgTiffUseExiv          = true;
$wgTiffExivCommand      = '/usr/bin/exiv2';
$wgTiffUseVips          = true;
$wgTiffVipsCommand      = '/usr/bin/vips';
#-PagedTiffHandler-end--------------------------------------------------------+

#-PageImages-begin------------------------------------------------------------+
# Taken from <https://noc.wikimedia.org/conf/CommonSettings.php>
if ( $wmgUsePageImages ) {
	require_once( "$IP/extensions/PageImages/PageImages.php" );
	$wgPageImagesExpandOpenSearchXml = $wmgPageImagesExpandOpenSearchXml;
	$wgPageImagesUseGalleries = $wmgPageImagesUseGalleries;
}
#-PageImages-end--------------------------------------------------------------+

#-ParserFunctions-begin-------------------------------------------------------+
# Taken from <https://noc.wikimedia.org/conf/CommonSettings.php>
include( $IP . '/extensions/ParserFunctions/ParserFunctions.php' );
$wgExpensiveParserFunctionLimit = 500;
#-ParserFunctions-end---------------------------------------------------------+

#-Parsoid-begin---------------------------------------------------------------+
# Based on <https://noc.wikimedia.org/conf/CommonSettings.php>
if ( $wmgUseParsoid ) {
	require_once( "$IP/extensions/Parsoid/Parsoid.php" );
	$wmgParsoidURL = 'http://127.0.0.1';
	// The wiki prefix to use
	$wgParsoidWikiPrefix = $wgDBname;
	// List the parsoid cache servers to keep up to date.
	//
	// We target the load balancer in front of the front-end caches, which
	// will then pick one front-end. This works as we disabled caching in
	// the front-ends. The main reason for doing it this way is that request
	// coalescing in the backends does not work with req.hash_always_miss =
	// true.
	$wgParsoidCacheServers = array( 'http://localhost' );
	// Load shedding knob, affects whether new Parsoid jobs are enqueued.
	// Set to something between 0 (process all updates) and 1 (skip all updates).
	$wgParsoidSkipRatio = 0;
	// Throttle rate of template updates by setting the number of tests per
	// job to something lowish, and limiting the maximum number of updates
	// to process per template edit
	$wgParsoidCacheUpdateTitlesPerJob = 12;
	$wgParsoidMaxBacklinksInvalidate = 500000;
}
#-Parsoid-end-----------------------------------------------------------------+

#-PdfHandler-begin------------------------------------------------------------+
# Taken from <https://noc.wikimedia.org/conf/CommonSettings.php>
if ( $wmgUsePdfHandler ) {
	include ( "$IP/extensions/PdfHandler/PdfHandler.php" );
}
#-PdfHandler-end--------------------------------------------------------------+

#-Poem-begin------------------------------------------------------------------+
# Taken from <https://noc.wikimedia.org/conf/CommonSettings.php>
if ( $wmgUsePoem ) {
	include( $IP . '/extensions/Poem/Poem.php' );
}
#-Poem-end--------------------------------------------------------------------+

#-Popups-begin----------------------------------------------------------------+
# Taken from <https://noc.wikimedia.org/conf/CommonSettings.php>
if ( $wmgUsePopups ) {
	require_once( "$IP/extensions/Popups/Popups.php" );
}
#-Popups-end------------------------------------------------------------------+

#-ProofreadPage-begin---------------------------------------------------------+
# Based on <https://noc.wikimedia.org/conf/CommonSettings.php>
if ( $wmgUseProofreadPage ) {
	include( $IP . '/extensions/ProofreadPage/ProofreadPage.php' );
# Taken from <https://noc.wikimedia.org/conf/proofreadpage.php>
        if ( $wgDBname == 'dewikisource' ) {
                $wgGroupPermissions['*']['pagequality'] = true; # 27516
        } elseif ( $wgDBname == 'enwikisource' || $wgDBname == 'svwikisource' ) {
                $wgDefaultUserOptions['proofreadpage-showheaders'] = 1;
        }
# Based on <https://www.mediawiki.org/wiki/Manual:How_to_use_DjVu_with_MediaWiki>
        $wgFileExtensions[]     = 'djvu';
	$wgDjvuToXML            = 'djvutoxml';
	$wgDjvuDump             = 'djvudump';
	$wgDjvuRenderer         = 'ddjvu';
	$wgDjvuTxt              = 'djvutxt';
        $wgDjvuOutputExtension  = 'jpg';
	// for better thumbnails quality (default 75)
        $wgDjvuPostProcessor    = '/usr/bin/ppmtojpeg --quality=100';
}
#-ProofreadPage-end-----------------------------------------------------------+

#-Quiz-begin------------------------------------------------------------------+
# Taken from <https://noc.wikimedia.org/conf/CommonSettings.php>
if ( $wmgUseQuiz ) {
	include( "$IP/extensions/Quiz/Quiz.php" );
}
#-Quiz-end--------------------------------------------------------------------+

#-RandomRootPage-begin--------------------------------------------------------+
# Taken from <https://noc.wikimedia.org/conf/CommonSettings.php>
if ( $wmgEnableRandomRootPage ) {
	require_once( "$IP/extensions/RandomRootPage/Randomrootpage.php" );
}
#-RandomRootPage-end----------------------------------------------------------+

#-Score-begin-----------------------------------------------------------------+
# Based on <https://noc.wikimedia.org/conf/CommonSettings.php>
if ( $wmgUseScore ) {
	include( "$IP/extensions/Score/Score.php" );
#	$wgScoreFileBackend = $wmgScoreFileBackend;
#	$wgScorePath = $wmgScorePath;
        $wgScoreLilyPond        = '/usr/bin/lilypond';
        $wgScoreAbc2Ly          = '/usr/bin/abc2ly';
        $wgScoreTimidity        = '/usr/bin/timidity';
        $wgScoreTrim            = true;
}
#-Score-end-------------------------------------------------------------------+

#-Scribunto-begin-------------------------------------------------------------+
# Based on <https://noc.wikimedia.org/conf/CommonSettings.php>
if ( $wmgUseScribunto ) {
	include( "$IP/extensions/Scribunto/Scribunto.php" );
	$wgScribuntoUseGeSHi = true;
	$wgScribuntoUseCodeEditor = true;
	$wgScribuntoDefaultEngine = 'luastandalone';
	$wgScribuntoEngineConf['luasandbox']['cpuLimit'] = 10;
        $wgScribuntoEngineConf['luastandalone']['errorFile'] = '/tmp/lua-error.log';
        $wgScribuntoEngineConf['luastandalone']['luaPath'] = '/usr/bin/lua5.1';
        $wgShowExceptionDetails = true;
}
#-Scribunto-end---------------------------------------------------------------+

#-Solarium-begin--------------------------------------------------------------+
if ( $wmgUseTranslate && $wmgUseTranslationMemory ) {
	require_once( "$IP/extensions/Solarium/Solarium.php" );
}
#-Solarium-end----------------------------------------------------------------+

#-SyntaxHighlight_GeSHi-begin-------------------------------------------------+
# Taken from <https://noc.wikimedia.org/conf/CommonSettings.php>
if ( $wmgUseGeSHi ) {
	include( $IP . '/extensions/SyntaxHighlight_GeSHi/SyntaxHighlight_GeSHi.php' );
}
#-SyntaxHighlight_GeSHi-end---------------------------------------------------+

#-TemplateData-begin----------------------------------------------------------+
# Taken from <https://noc.wikimedia.org/conf/CommonSettings.php>
if ( $wmgUseTemplateData ) {
	require_once( "$IP/extensions/TemplateData/TemplateData.php" );
}
if ( $wmgTemplateDataUseGUI ) {
	$wgTemplateDataUseGUI = true;
}
#-TemplateData-end------------------------------------------------------------+

#-TemplateSandbox-begin-------------------------------------------------------+
# Taken from <https://noc.wikimedia.org/conf/CommonSettings.php>
if ( $wmgUseTemplateSandbox ) {
	require_once( "$IP/extensions/TemplateSandbox/TemplateSandbox.php" );
	if( $wmgUseScribunto ) {
		$wgTemplateSandboxEditNamespaces[] = NS_MODULE;
	}
}
#-TemplateSandbox-end---------------------------------------------------------+

#-TextExtracts-begin----------------------------------------------------------+
# Taken from <https://noc.wikimedia.org/conf/CommonSettings.php>
# MUST be after MobileFrontend initialization
if ( $wmgEnableTextExtracts ) {
	require_once( "$IP/extensions/TextExtracts/TextExtracts.php" );
	$wgExtractsRemoveClasses = array_merge( $wgExtractsRemoveClasses, $wmgExtractsRemoveClasses );
}
#-TextExtracts-end------------------------------------------------------------+

#-TimedMediaHandler-begin-----------------------------------------------------+
ini_set( 'include_path',
	".:$IP:$IP/includes:$IP/languages:/usr/share/php" .
	PATH_SEPARATOR .
	ini_get( 'include_path' ) );
# Based on <https://noc.wikimedia.org/conf/CommonSettings.php>
if ( $wmgUseTimedMediaHandler ) {
	require_once( "$IP/extensions/TimedMediaHandler/TimedMediaHandler.php" );
	$wgTimedTextForeignNamespaces = array( 'commonswiki' => 102 );
	if ( $wgDBname == 'commonswiki' ) {
		$wgTimedTextNS = 102;
	}
	//overwrite enabling of local TimedText namespace
	$wgEnableLocalTimedText = $wmgEnableLocalTimedText;
	//enable transcoding on all wikis that allow uploads
	$wgEnableTranscode = $wgEnableUploads;
	$wgOggThumbLocation = false; // use ffmpeg for performance
	// $wgOggThumbLocation = '/usr/bin/oggThumb';
	//tmh1/2 have 12 cores and need lots of shared memory
	//for avconv / ffmpeg2theora
	$wgTranscodeBackgroundMemoryLimit = 2 * 1024 * 1024; // 2GB
	$wgFFmpegThreads = 2;
	// Minimum size for an embed video player
	$wgMinimumVideoPlayerSize = $wmgMinimumVideoPlayerSize;
	// Enable low-res Theora transcodes for fallback players on slow machines
	// Put them at the beginning of the array to keep ordering the way
	// the popup player expects, so we pick the right WebM size in most
	// cases.
	//
	// See https://bugzilla.wikimedia.org/61760
	//
	array_unshift( $wgEnabledTranscodeSet, WebVideoTranscode::ENC_OGV_360P );
	array_unshift( $wgEnabledTranscodeSet, WebVideoTranscode::ENC_OGV_160P );
}
#-TimedMediaHandler-end-------------------------------------------------------+

#-Timeline-begin--------------------------------------------------------------+
# Based on <https://noc.wikimedia.org/conf/CommonSettings.php>
if ( $wmgUseTimeline ) {
	include( $IP . '/extensions/timeline/Timeline.php' );
	if ( $wgDBname == 'testwiki' || $wgDBname == 'mlwiki' ) {
		// FreeSansWMF has been generated from FreeSans and FreeSerif by using this script with fontforge:
		// Open("FreeSans.ttf");
		// MergeFonts("FreeSerif.ttf");
		// SetFontNames("FreeSans-WMF", "FreeSans WMF", "FreeSans WMF Regular", "Regular", "");
		// Generate("FreeSansWMF.ttf", "", 4 );
		$wgTimelineSettings->fontFile = 'FreeSansWMF.ttf';
	} elseif ( $lang == 'zh' ) {
		$wgTimelineSettings->fontFile = 'unifont-5.1.20080907.ttf';
	}
	if ( file_exists( '/usr/bin/ploticus' ) ) {
		$wgTimelineSettings->ploticusCommand = '/usr/bin/ploticus';
	}
	$wgTimelineSettings->epochTimestamp = '20130101000000';
}
putenv("GDFONTPATH=/usr/share/fonts/truetype/freefont");
#-Timeline-end----------------------------------------------------------------+

#-TitleKey-begin--------------------------------------------------------------+
# Based on <https://noc.wikimedia.org/conf/CommonSettings.php>
// Case-insensitive title prefix search extension
// Load this _after_ Lucene so Lucene's prefix search can be used
// when available (for OpenSearch suggestions and AJAX search mode)
// But note we still need TitleKey for "go" exact matches and similar.
// CirrusSearch, on the other hand, has absorbed its functionality so
// for CirrusSearch wikis it is no longer required.
if ( $wmgUseTitleKey && !$wmgUseCirrus ) {
	include "$IP/extensions/TitleKey/TitleKey.php";
}
#-TitleKey-end----------------------------------------------------------------+

#-Translate-begin-------------------------------------------------------------+
# Based on <https://noc.wikimedia.org/conf/CommonSettings.php>
if ( $wmgUseTranslate ) {
	require_once( "$IP/extensions/Translate/Translate.php" );

	$wgGroupPermissions['*']['translate'] = true;
	$wgGroupPermissions['translationadmin']['pagetranslation'] = true;
	$wgGroupPermissions['translationadmin']['translate-manage'] = true;
	$wgGroupPermissions['translationadmin']['translate-import'] = true; // bug 40341
	$wgGroupPermissions['user']['translate-messagereview'] = true;
	$wgGroupPermissions['user']['translate-groupreview'] = true;

        $wgGroupPermissions['user']['translate']               = true;
        $wgGroupPermissions['user']['translate-import']        = true;
        $wgGroupPermissions['sysop']['pagetranslation']        = true;
        $wgGroupPermissions['sysop']['translate-manage']       = true;

	unset( $wgGroupPermissions['translate-proofr'] );
	unset( $wgAddGroups['translate-proofr'] );

	$wgTranslateDocumentationLanguageCode = 'qqq';
	$wgExtraLanguageNames['qqq']       = 'Message documentation'; # No linguistic content. Used for documenting messages

	$wgTranslateTranslationServices = array();

	$wgTranslateWorkflowStates = $wmgTranslateWorkflowStates;
	$wgTranslateRcFilterDefault = $wmgTranslateRcFilterDefault;

	unset( $wgTranslateTasks['export-as-file'] );
	unset( $wgTranslateTasks['optional'] );
	unset( $wgTranslateTasks['suggestions'] );

	$wgTranslateUsePreSaveTransform = true; # bug 37304

	$wgEnablePageTranslation = true;

	$wgTranslateBlacklist = array(
		'*' => array(
			'en' => 'English is the source language.',

			'gan-hans' => 'Translate in gan please.',
			'gan-hant' => 'Translate in gan please.',

			'ike-cans' => 'Translate in iu please.',
			'ike-latn' => 'Translate in iu please.',

			'kk-cyrl' => 'Translate in kk please.',
			'kk-latn' => 'Translate in kk please.',
			'kk-arab' => 'Translate in kk please.',
			'kk-kz'   => 'Translate in kk please.',
			'kk-tr'   => 'Translate in kk please.',
			'kk-cn'   => 'Translate in kk please.',

			'ku-latn' => 'Translate in ku please.',
			'ku-arab' => 'Translate in ku please.',

			'shi-tfng' => 'Translate in shi please.',
			'shi-latn' => 'Translate in shi please.',

			'sr-ec' => 'Translate in sr please.',
			'sr-el' => 'Translate in sr please.',

			'tg-latn' => 'Translate in tg please.',

			'zh-hans' => 'Translate in zh please.',
			'zh-hant' => 'Translate in zh please.',
			'zh-cn' => 'Translate in zh please.',
			'zh-hk' => 'Translate in zh please.',
			'zh-mo' => 'Translate in zh please.',
			'zh-my' => 'Translate in zh please.',
			'zh-sg' => 'Translate in zh please.',
			'zh-tw' => 'Translate in zh please.',
		),
	);

	$wgTranslateEC = array();

	if ( $wgDBname === 'wikimania2013wiki' ) {
		$wgHooks['TranslatePostInitGroups'][] = function ( &$cc ) {
			$id = 'wiki-sidebar';
			$mg = new WikiMessageGroup( $id, 'sidebar-messages' );
			$mg->setLabel( 'Sidebar' );
			$mg->setDescription( 'Messages used in the sidebar of this wiki' );
			$cc[$id] = $mg;
			return true;
		};
	}

	if ( $wgDBname === 'commonswiki' ) {
		$wgHooks['TranslatePostInitGroups'][] = function ( &$cc ) {
			$id = 'wiki-translatable';
			$mg = new WikiMessageGroup( $id, 'translatable-messages' );
			$mg->setLabel( 'Interface' );
			$mg->setDescription( 'Messages used in the custom interface of this wiki' );
			$cc[$id] = $mg;
			return true;
		};
	};

	unset( $wgSpecialPages['FirstSteps'] );
	unset( $wgSpecialPages['ManageMessageGroups'] );
	unset( $wgSpecialPages['TranslationStats'] );

	// Caused apache overload 2013-08-11 TS
	unset( $wgSpecialPages['SupportedLanguages'] );
}
#-Translate-begin-------------------------------------------------------------+

#-UniversalLanguageSelector-begin---------------------------------------------+
# Based on <https://noc.wikimedia.org/conf/CommonSettings.php>
if ( $wmgUseUniversalLanguageSelector ) {
	require_once( "$IP/extensions/UniversalLanguageSelector/UniversalLanguageSelector.php" );
	$wgULSGeoService = false;
        $wgULSEnable            = true;
	$wgULSAnonCanChangeLanguage = false;
	$wgULSPosition = $wmgULSPosition;
	$wgULSIMEEnabled = $wmgULSIMEEnabled;
	$wgULSWebfontsEnabled = $wmgULSWebfontsEnabled;
	if ( $wmgUseCodeEditorForCore || $wmgUseScribunto || $wmgZeroPortal ) {
		$wgULSNoImeSelectors[] = '.ace_editor textarea';
	}
	if ( $wmgUseTranslate && $wmgULSPosition === 'personal' ) {
		$wgTranslatePageTranslationULS = true;
	}
	$wgULSEventLogging = $wmgULSEventLogging;
	// Enable the compact language links Beta Feature
	if ( $wmgULSCompactLinks ) {
		$wgULSCompactLinks = true;
	}
}
#-UniversalLanguageSelector-begin---------------------------------------------+

#-VectorBeta-begin------------------------------------------------------------+
# Taken from <https://noc.wikimedia.org/conf/CommonSettings.php>
if ( $wmgUseVectorBeta ) {
	require_once( "$IP/extensions/VectorBeta/VectorBeta.php" );
	$wgVectorBetaPersonalBar = $wmgVectorBetaPersonalBar;
	$wgVectorBetaTypography  = true;
	$wgVectorBetaWinter      = true;
}
#-VectorBeta-end--------------------------------------------------------------+

#-VipsScaler-begin------------------------------------------------------------+
# Based on <https://noc.wikimedia.org/conf/CommonSettings.php>
if ( $wmgUseVips ) {
	include( "$IP/extensions/VipsScaler/VipsScaler.php" );
	include( "$IP/extensions/VipsScaler/VipsTest.php" );
        $wgVipsCommand          = '/usr/bin/vips';
	$wgVipsThumbnailerHost = '127.0.0.1';
	$wgVipsOptions = array(
		array(
			'conditions' => array(
				'mimeType' => 'image/png',
				'minArea' => 2e7,
			),
		),
		array(
			'conditions' => array(
				'mimeType' => 'image/tiff',
				'minShrinkFactor' => 1.2,
				'minArea' => 5e7,
			),
			'sharpen' => array( 'sigma' => 0.8 ),
		),
	);
}
#-VipsScaler-end--------------------------------------------------------------+

#-VisualEditor-begin----------------------------------------------------------+
# Based on <https://noc.wikimedia.org/conf/CommonSettings.php>
if ( $wmgUseVisualEditor ) {
	require_once( "$IP/extensions/VisualEditor/VisualEditor.php" );

	// Parsoid connection configuration
	$wgVisualEditorParsoidURL = $wmgParsoidURL;
	$wgVisualEditorParsoidPrefix = $wgParsoidWikiPrefix;
	$wgVisualEditorParsoidProblemReportURL = 'http://parsoid.wmflabs.org/_bugs/';
	if ( $wmgVisualEditorParsoidForwardCookies ) {
		$wgVisualEditorParsoidForwardCookies = true;
	}

	// Namespace configuration
	if ( !$wmgVisualEditorInContentNamespaces ) {
		$wgVisualEditorNamespaces = array(); // Wipe out default set by VisualEditor.php
	}

	$wgVisualEditorNamespaces = array_merge( $wgVisualEditorNamespaces, $wmgVisualEditorNamespaces );

	if ( $wmgUseVisualEditorNamespace ) {
		define( 'NS_VISUALEDITOR', 2500 );
		define( 'NS_VISUALEDITOR_TALK', 2501 );
		$wgExtraNamespaces[NS_VISUALEDITOR] = 'VisualEditor';
		$wgExtraNamespaces[NS_VISUALEDITOR_TALK] = 'VisualEditor_talk';
		$wgVisualEditorNamespaces[] = NS_VISUALEDITOR;
	}

	// User access configuration
	if ( $wmgVisualEditorDefault ) {
		$wgDefaultUserOptions['visualeditor-enable'] = 1;
		$wgHiddenPrefs[] = 'visualeditor-enable'; // Bug 48666
	} else {
		// Only show the beta-disable preference if the wiki is in 'beta'.
		$wgHiddenPrefs[] = 'visualeditor-betatempdisable';
	}
	// Bug 50000 - to remove once roll-out is complete.
	if ( $wmgVisualEditorDisableForAnons ) {
		$wgVisualEditorDisableForAnons = true;
	}

	// Tab configuration
	if ( $wmgVisualEditorSecondaryTabs ) {
		$wgVisualEditorTabPosition = 'after';
	}
	if ( $wmgVisualEditorBetaInTab ) {
		$wgVisualEditorTabMessages['editappendix'] =
			$wgVisualEditorTabMessages['createappendix'] =
			$wgVisualEditorTabMessages['editsectionappendix'] = 'visualeditor-beta-appendix';
	}

	// Welcome configuration
	if ( $wmgVisualEditorShowBetaWelcome ) {
		$wgVisualEditorShowBetaWelcome = true;
	}

	// Experimental code configuration
	if ( $wmgVisualEditorExperimental ) {
		$wgDefaultUserOptions['visualeditor-enable-experimental'] = 1;
	}
	if ( $wmgVisualEditorEnableTocWidget ) {
		$wgVisualEditorEnableTocWidget = true;
	}
}
#-VisualEditor-begin----------------------------------------------------------+

#-WikiData-begin--------------------------------------------------------------+
# Based on <https://noc.wikimedia.org/conf/CommonSettings.php>
# wikidata repo
putenv( "MW_INSTALL_PATH=$IP" );
#define( 'WB_EXPERIMENTAL_FEATURES', true );
$wgEnableWikibaseRepo   = true;
$wgEnableWikibaseClient = true;
$wmgUseWikibaseRepo     = true;
$wmgUseWikibaseClient   = true;
require_once( "$IP/extensions/Wikidata/Wikidata.php" );
#require_once( "$IP/extensions/Wikidata/extensions/Wikibase/repo/ExampleSettings.php" );
$wgContentHandlerUseDB  = true;
define( 'WB_NS_PROPERTY',      120 );
define( 'WB_NS_PROPERTY_TALK', 121 );
$wgNamespaceAliases['Item']               = NS_MAIN;
$wgNamespaceAliases['Item_talk']          = NS_TALK;
$wgNamespaceAliases['Wikidata']           = NS_PROJECT;
$wgNamespaceAliases['Wikidata_talk']      = NS_PROJECT_TALK;
$wgExtraNamespaces[WB_NS_PROPERTY]        = 'Property';
$wgExtraNamespaces[WB_NS_PROPERTY_TALK]   = 'Property_talk';
$wgNamespacesToBeSearchedDefault[WB_NS_PROPERTY] = true;
#$wgNamespaceContentModels[NS_MAIN]        = CONTENT_MODEL_WIKIBASE_ITEM;
$wgNamespaceContentModels[WB_NS_PROPERTY] = CONTENT_MODEL_WIKIBASE_PROPERTY;
#$wgWBRepoSettings['entityNamespaces'][CONTENT_MODEL_WIKIBASE_ITEM] = NS_MAIN;
$wgWBRepoSettings['entityNamespaces'][CONTENT_MODEL_WIKIBASE_PROPERTY] = WB_NS_PROPERTY;
$wgGroupPermissions['*']['item-term']       = true;
$wgGroupPermissions['*']['item-merge']      = true;
$wgGroupPermissions['*']['property-term']   = true;
$wgGroupPermissions['*']['property-create'] = true;

# wikidata client
$wgWBClientSettings['repoNamespaces']     = array(
        'wikibase-item'     => '',
        'wikibase-property' => 'Property',
);
$wgWBClientSettings['siteLocalID']        = $wgLanguageCode;
$wgWBClientSettings['repoUrl']            = '//www.wikidata.site';
$wgWBClientSettings['repoArticlePath']    = '/wiki/$1';
$wgWBClientSettings['repoScriptPath']     = '/w';
$wgWBClientSettings['repoDatabase']       = 'wikidatawiki';
$wgWBClientSettings['siteGlobalID']       = $wgDBname;
$wgWBClientSettings['repoSiteId']         = 'wikidatawiki';
$wgWBClientSettings['siteGroup']          = $site;

# wb_changes_dispatch - not really needed for a mirror
#$wgWBRepoSettings['clientDbList']         = array(
#				      'simplewiki',      'simplewiktionary',
#				      'zuwiki',          'zuwiktionary', );
#$wgWBRepoSettings['localClientDatabases'] = array(
#				      'simplewiki'       => 'simplewiki',
#				      'simplewiktionary' => 'simplewiktionary',
#				      'zuwiki'           => 'zuwiki',
#				      'zuwiktionary'     => 'zuwiktionary', );
$wgWBClientSettings['changesDatabase']    = 'wikidatawiki';
#-WikiData-begin--------------------------------------------------------------+

#-WikiEditor-begin------------------------------------------------------------+
# Based on <https://noc.wikimedia.org/conf/CommonSettings.php>
require( "$IP/extensions/WikiEditor/WikiEditor.php" );

// Disable experimental things
#$wgWikiEditorFeatures['preview'] =
#	$wgWikiEditorFeatures['previewDialog'] =
#	$wgWikiEditorFeatures['publish'] = array( 'global' => false, 'user' => true ); // Hidden from prefs view
#$wgHiddenPrefs[] = 'wikieditor-preview';
#$wgHiddenPrefs[] = 'wikieditor-previewDialog';
#$wgHiddenPrefs[] = 'wikieditor-publish';
# Enable experimental things
$wgDefaultUserOptions['usebetatoolbar']     = 1;
$wgDefaultUserOptions['usebetatoolbar-cgd'] = 1;
$wgDefaultUserOptions['wikieditor-preview'] = 1;
$wgDefaultUserOptions['wikieditor-publish'] = 1;
#-WikiEditor-end--------------------------------------------------------------+

#-WikiHiero-begin-------------------------------------------------------------+
# Taken from <https://noc.wikimedia.org/conf/CommonSettings.php>
if ( $wmgUseWikiHiero ) {
	include( $IP . '/extensions/wikihiero/wikihiero.php' );
}
#-WikiHiero-end---------------------------------------------------------------+

# ZeroBanner (see ZeroPortal below)

#-ZeroPortal-begin------------------------------------------------------------+
# Taken from <https://noc.wikimedia.org/conf/CommonSettings.php>
if ( $wmgZeroPortal ) {
	require_once( "$IP/extensions/JsonConfig/JsonConfig.php" );
	require_once( "$IP/extensions/ZeroBanner/ZeroBanner.php" );
	require_once( "$IP/extensions/ZeroPortal/ZeroPortal.php" );

	// zerowiki treats all logged-in users the same as anonymous, without giving them any extra rights
	// Only sysops and scripts get additional rights on zerowiki
	$zpUserRights = $wgGroupPermissions['user'];

	$wgGroupPermissions['*']['createtalk'] = false;
	$wgGroupPermissions['*']['createpage'] = false;
	$wgGroupPermissions['*']['writeapi'] = false;
	$wgGroupPermissions['user'] = $wgGroupPermissions['*'];

	// fixme: this should go into groupOverrides or groupOverrides2, with or without a '+'
	// 'sysop' => array( 'zero-edit', 'zero-script', 'zero-script-ips', 'jsonconfig-flush' ),
	// 'zeroscript' => array( 'zero-script', 'jsonconfig-flush' ),
	// 'zeroscriptips' => array( 'zero-script-ips', 'jsonconfig-flush' ),

	$wgGroupPermissions['sysop']['zero-edit'] = true;
	$wgGroupPermissions['sysop']['zero-script'] = true;
	$wgGroupPermissions['sysop']['zero-script-ips'] = true;
	$wgGroupPermissions['sysop']['jsonconfig-flush'] = true;
	$wgGroupPermissions['sysop'] = $wgGroupPermissions['sysop'] + $zpUserRights;

	$wgGroupPermissions['zeroscript']['zero-script'] = true;
	$wgGroupPermissions['zeroscript']['jsonconfig-flush'] = true;
	$wgGroupPermissions['zeroscript'] = $wgGroupPermissions['zeroscript'] + $zpUserRights;

	$wgGroupPermissions['zeroscriptips']['zero-script-ips'] = true;
	$wgGroupPermissions['zeroscriptips']['jsonconfig-flush'] = true;
	$wgGroupPermissions['zeroscriptips'] = $wgGroupPermissions['zeroscriptips'] + $zpUserRights;

	$wgZeroPortalImpersonateUser = 'Impersonator';

	unset( $zpUserRights );

	$wgUsersNotifiedOnAllChanges[] = 'ABaso(WMF)';
	$wgUsersNotifiedOnAllChanges[] = 'Dfoy';
	$wgUsersNotifiedOnAllChanges[] = 'Jhobs';
	$wgUsersNotifiedOnAllChanges[] = 'Yurik';
}
#-ZeroPortal-end--------------------------------------------------------------+

#-Skins-begin-----------------------------------------------------------------+
# Taken from <https://noc.wikimedia.org/conf/CommonSettings.php>
require_once "$IP/skins/Vector/Vector.php";
require_once "$IP/skins/MonoBook/MonoBook.php";
require_once "$IP/skins/Modern/Modern.php";
require_once "$IP/skins/CologneBlue/CologneBlue.php";
if ( $wgDBname == 'nostalgiawiki' ) {
	# Link back to current version from the archive funhouse
	if ( ( isset( $_REQUEST['title'] ) && ( $title = $_REQUEST['title'] ) )
		|| ( isset( $_SERVER['PATH_INFO'] )  && ( $title = substr( $_SERVER['PATH_INFO'], 1 ) ) ) ) {
		if ( preg_match( '/^(.*)\\/Talk$/', $title, $matches ) ) {
			$title = 'Talk:' . $matches[1];
		}
		$wgSiteNotice = "[//en.wikipedia.org/wiki/" .
			htmlspecialchars( urlencode( $title ) ) .
		' See the current version of this page on Wikipedia]';
	} else {
		$wgSiteNotice = "[//en.wikipedia.org/ See current Wikipedia]";
	}

	// Nostalgia skin
	require_once "$IP/skins/Nostalgia/Nostalgia.php";
}
#-Skins-end-------------------------------------------------------------------+

## System Messages
# Want MediaWiki:Wikimedia-copyright, not MediaWiki:Copyright
$wgHooks['SkinTemplateOutputPageBeforeExec']['copyright'] = 'wmfCopyrightFunc';
function wmfCopyrightFunc( $skin, &$template ) {
	if ( preg_match( '/^(.*)\.wikidata.site$/',
	        $_SERVER['SERVER_NAME'], $matches ) ) {
		$title = Title::newFromText( 'MediaWiki:Wikidata-copyright' );
	} else {
	        $title = Title::newFromText( 'MediaWiki:Wikimedia-copyright' );
	}
	if ( $title->isKnown() ) {
	        $rev   = Revision::newFromTitle( $title );
		$text  = $rev->getSerializedData();
		$template->set( 'copyright', $text );
	}
	return true;
}

## Caching
# For testing, set to false.  For production, comment out.
$wgEnableParserCache    = false;
$wgCachePages           = false;
# For MobileFrontend
$wgUseFileCache         = false;

## Debug
# SQL errors
$wgShowSQLErrors        = true;
$wgDebugComments        = true;
#$wgDebugLogFile         = '/tmp/wp-mirror-mediawiki.debug.log';
$wgShowDBErrorBacktrace = true;

# PHP errors
#error_reporting( E_ERROR | E_WARNING | E_PARSE );
error_reporting( E_ERROR | E_PARSE );
ini_set( 'display_errors', 1 );
