<?php

# This file was generated during the installation of `wp-mirror'.  If
# you make manual changes, please add comments (e.g. your name and
# date) in case you need to revert them later.

if       ( preg_match( '/^(.*)\.wpmirror.site$/',     $_SERVER['SERVER_NAME'], 
                                                      $matches ) ) {
     $langcode = $matches[1];
     $project  = 'wikipedia';
     $wiki     = $langcode . 'wiki';
} elseif ( preg_match( '/^(.*)\.wikibooks.site$/',    $_SERVER['SERVER_NAME'], 
                                                      $matches ) ) {
     $langcode = $matches[1];
     $project  = 'wikibooks';
     $wiki     = $langcode . $project;
} elseif ( preg_match( '/^(.*)\.wikimedia.site$/',    $_SERVER['SERVER_NAME'], 
                                                      $matches ) ) {
     $langcode = $matches[1];
     $project  = 'wikimedia';
     $wiki     = $langcode . $project;
} elseif ( preg_match( '/^(.*)\.wikinews.site$/',     $_SERVER['SERVER_NAME'], 
                                                      $matches ) ) {
     $langcode = $matches[1];
     $project  = 'wikinews';
     $wiki     = $langcode . $project;
} elseif ( preg_match( '/^(.*)\.wikipedia.site$/',    $_SERVER['SERVER_NAME'], 
                                                      $matches ) ) {
     $langcode = $matches[1];
     $project  = 'wikipedia';
     $wiki     = $langcode . 'wiki';
} elseif ( preg_match( '/^(.*)\.wikiquote.site$/',    $_SERVER['SERVER_NAME'], 
                                                      $matches ) ) {
     $langcode = $matches[1];
     $project  = 'wikiquote';
     $wiki     = $langcode . $project;
} elseif ( preg_match( '/^(.*)\.wikisource.site$/',   $_SERVER['SERVER_NAME'], 
                                                      $matches ) ) {
     $langcode = $matches[1];
     $project  = 'wikisource';
     $wiki     = $langcode . $project;
} elseif ( preg_match( '/^(.*)\.wikiversity.site$/',  $_SERVER['SERVER_NAME'], 
                                                      $matches ) ) {
     $langcode = $matches[1];
     $project  = 'wikiversity';
     $wiki     = $langcode . $project;
} elseif ( preg_match( '/^(.*)\.wikivoyage.site$/',   $_SERVER['SERVER_NAME'], 
                                                      $matches ) ) {
     $langcode = $matches[1];
     $project  = 'wikivoyage';
     $wiki     = $langcode . $project;
} elseif ( preg_match( '/^(.*)\.wiktionary.site$/',   $_SERVER['SERVER_NAME'], 
                                                      $matches ) ) {
     $langcode = $matches[1];
     $project  = 'wiktionary';
     $wiki     = $langcode . $project;
} elseif ( preg_match( '/^(.*)\.template.site$/',     $_SERVER['SERVER_NAME'], 
                                                      $matches ) ) {
     $langcode = $matches[1]; # this branch is for 'update_farm.php'
     $project  = 'wpmirror';
     $wiki     = $langcode;
} else {
     die( 'Invalid host name: ' . $_SERVER['SERVER_NAME'] 
                                . ' Cannot determine wiki name' );
}
 
if( $langcode == 'www' ) {
    $langcode  = 'simple';
    $project   = 'wikipedia';
    $wiki      = $langcode . 'wiki';
}
 
# beware site is `zh-classicalwiki', but database is `zh_classicalwiki'
$wgDBname   = str_replace("-", "_", $wiki);
$wgServer   = 'http://' . $langcode . '.' . $project . '.site';
$wgSitename = $wiki;

$wgDBprefix             = '';


## Images - local
$wgEnableUploads        = true;
$wgUploadDirectory      = $IP . '/images/' . $project . '/' . $langcode;
$wgUploadPath           = $wgScriptPath . '/images/' . $project . '/' . $langcode;

## Images - remote
$wgSharedUploadDirectory= $IP . '/images/wikipedia/commons';
$wgSharedUploadPath     = $wgScriptPath . '/images/wikipedia/commons';
$wgForeignFileRepos[] = array(
    'class' => 'ForeignDBRepo',
    'name' => 'commonswiki',
    'url' => $wgSharedUploadPath,
    'directory' => $wgSharedUploadDirectory,
    'hashLevels' => 2, // This must be the same for the other family member
    'dbType' => $wgDBtype,
    'dbServer' => 'localhost',
    'dbUser' => $wgDBuser,
    'dbPassword' => $wgDBpassword,
    'dbFlags' => DBO_DEFAULT,
    'dbName' => 'commonswiki',
    'tablePrefix' => '',
    'hasSharedCache' => false,
    'descBaseUrl' => 'http://commons.wikipedia.site/index.php/Image:',
    'fetchDescription' => false
);

## Images - thumb
$wgUseImageMagick       = false;
$wgCustomConvertCommand = '/usr/bin/gm convert %s -resize %wx%h %d';
$wgSVGConverter         = 'inkscape';

# Math
$wgMathPath             = "{$wgUploadPath}/math";
$wgMathDirectory        = "{$wgUploadDirectory}/math";
$wgTmpDirectory         = "{$wgUploadDirectory}/tmp";

# Misc
$wgUseTidy              = true;
$wgLocalInterwiki       = strtolower( $wgSitename );
#$wgLanguageCode         = $langcode;

$wgFavicon              = "$wgScriptPath/favicon.ico";
$wgLogo                 = "$wgScriptPath/wp-mirror.png";

# For testing, set to false.  For production, set to true.
$wgEnableParserCache    = false;
$wgCachePages           = false;
