#! /usr/bin/gawk --exec

#-----------------------------------------------------------------------------+
# GAWK source file. Converts interwiki links from .org to .site.              |
# Copyright (C) 2014 Dr. Kent L. Miller. All rights reserved.                 |
#-----------------------------------------------------------------------------+

function org2site()
{
    match($0, /(.+),([0-9]+):(.+)/, arr)
    sub(/org/,"site",arr[3])
    printf("%s,%d:%s\n", arr[1],arr[2]+1,arr[3])
    next
}

/__global:[^/]+[/]+commons[.]wikimedia[.]org[/]/ { org2site() }
/__global:[^/]+[/]+donate[.]wikimedia[.]org[/]/ { org2site() }
/__global:[^/]+[/]+wikimediafoundation[.]org[/]/ { org2site() }
/__global:[^/]+[/]+incubator[.]wikimedia[.]org[/]/ { org2site() }
/__global:[^/]+[/]+www[.]mediawiki[.]org[/]/ { org2site() }
/__global:[^/]+[/]+meta[.]wikimedia[.]org[/]/ { org2site() }
/__global:[^/]+[/]+nostalgia[.]wikipedia[.]org[/]/ { org2site() }
/__global:[^/]+[/]+wikisource[.]org[/]/ { org2site() }
/__global:[^/]+[/]+outreach[.]wikimedia[.]org[/]/ { org2site() }
/__global:[^/]+[/]+quality[.]wikimedia[.]org[/]/ { org2site() }
/__global:[^/]+[/]+spcom[.]wikimedia[.]org[/]/ { org2site() }
/__global:[^/]+[/]+species[.]wikimedia[.]org[/]/ { org2site() }
/__global:[^/]+[/]+strategy[.]wikimedia[.]org[/]/ { org2site() }
/__global:[^/]+[/]+ten[.]wikipedia[.]org[/]/ { org2site() }
/__global:[^/]+[/]+test[.]wikidata[.]org[/]/ { org2site() }
/__global:[^/]+[/]+test2[.]wikipedia[.]org[/]/ { org2site() }
/__global:[^/]+[/]+usability[.]wikimedia[.]org[/]/ { org2site() }
/__global:[^/]+[/]+wg[.]en[.]wikipedia[.]org[/]/ { org2site() }
/__global:[^/]+[/]+mx[.]wikimedia[.]org[/]/ { org2site() }
/__global:[^/]+[/]+nl[.]wikimedia[.]org[/]/ { org2site() }
/__global:[^/]+[/]+nyc[.]wikimedia[.]org[/]/ { org2site() }
/__global:[^/]+[/]+no[.]wikimedia[.]org[/]/ { org2site() }
/__global:[^/]+[/]+pa-us[.]wikimedia[.]org[/]/ { org2site() }
/__global:[^/]+[/]+pl[.]wikimedia[.]org[/]/ { org2site() }
/__global:[^/]+[/]+rs[.]wikimedia[.]org[/]/ { org2site() }
/__global:[^/]+[/]+ru[.]wikimedia[.]org[/]/ { org2site() }
/__global:[^/]+[/]+se[.]wikimedia[.]org[/]/ { org2site() }
/__global:[^/]+[/]+tr[.]wikimedia[.]org[/]/ { org2site() }
/__global:[^/]+[/]+ua[.]wikimedia[.]org[/]/ { org2site() }
/__global:[^/]+[/]+wikimania[0-9]*[.]wikimedia[.]org[/]/ { org2site() }
/__global:[^/]+[/]+wikimaniateam[.]wikimedia[.]org[/]/ { org2site() }
/_wiki:/ && /org/ { org2site() }
/_wiktionary:/ && /org/ { org2site() }
/_wikiquote:/ && /org/ { org2site() }
/_wikibooks:/ && /org/ { org2site() }
/_wikinews:/ && /org/ { org2site() }
/_wikisource:/ && /org/ { org2site() }
/_wikimedia:/ && /org/ { org2site() }
/_wikiversity:/ && /org/ { org2site() }
/_wikivoyage:/ && /org/ { org2site() }
/[0-9]+:[a-z]+/ && /org/ { org2site() }
{ print $0 }
