<?php
/**
 * Internationalisation file for magic words in the Disambiguator extension
 *
 * @file
 * @ingroup Extensions
 */

$magicWords = array();

/** English (English) */
$magicWords['en'] = array(
	'disambiguation' => array( '1', '__DISAMBIG__' ),
);

/** Arabic (العربية) */
$magicWords['ar'] = array(
	'disambiguation' => array( '__توضيح__' ),
);

/** Egyptian Spoken Arabic (مصرى) */
$magicWords['arz'] = array(
	'disambiguation' => array( '__توضيح__' ),
);

/** German (Deutsch) */
$magicWords['de'] = array(
	'disambiguation' => array( '__BEGRIFFSKLÄRUNG__' ),
);

/** Zazaki (Zazaki) */
$magicWords['diq'] = array(
	'disambiguation' => array( '_MANEYOBİN_' ),
);

/** Spanish (español) */
$magicWords['es'] = array(
	'disambiguation' => array( '__DISAMBIGUACIÓN__', '__DISAMBIGUACION__' ),
);

/** Estonian (eesti) */
$magicWords['et'] = array(
	'disambiguation' => array( '__TÄPSUSTUS__' ),
);

/** Persian (فارسی) */
$magicWords['fa'] = array(
	'disambiguation' => array( '__ابهام‌زدایی__' ),
);

/** French (français) */
$magicWords['fr'] = array(
	'disambiguation' => array( '__HOMONYMIE__' ),
);

/** Galician (galego) */
$magicWords['gl'] = array(
	'disambiguation' => array( '__HOMÓNIMOS__', '__HOMONIMOS__' ),
);

/** Hebrew (עברית) */
$magicWords['he'] = array(
	'disambiguation' => array( '__דף_פירושונים__', '__פירושונים__' ),
);

/** Hindi (हिन्दी) */
$magicWords['hi'] = array(
	'disambiguation' => array( '__बहुवि__' ),
);

/** Japanese (日本語) */
$magicWords['ja'] = array(
	'disambiguation' => array( '__曖昧さ回避__' ),
);

/** Korean (한국어) */
$magicWords['ko'] = array(
	'disambiguation' => array( '__동음이의__' ),
);

/** Luxembourgish (Lëtzebuergesch) */
$magicWords['lb'] = array(
	'disambiguation' => array( '__HOMONYMIE__' ),
);

/** Macedonian (македонски) */
$magicWords['mk'] = array(
	'disambiguation' => array( '__ПОЈАСНУВАЊЕ__' ),
);

/** Malayalam (മലയാളം) */
$magicWords['ml'] = array(
	'disambiguation' => array( '__വിവക്ഷ__' ),
);

/** Marathi (मराठी) */
$magicWords['mr'] = array(
	'disambiguation' => array( '__निःसंदिग्ध__' ),
);

/** Norwegian Nynorsk (norsk nynorsk) */
$magicWords['nn'] = array(
	'disambiguation' => array( '__FLEIRTYDING__' ),
);

/** Serbian (Cyrillic script) (српски (ћирилица)‎) */
$magicWords['sr-ec'] = array(
	'disambiguation' => array( '__ДИСАМБИГ__' ),
);

/** Urdu (اردو) */
$magicWords['ur'] = array(
	'disambiguation' => array( '__ضد_ابہام__' ),
);

/** Vietnamese (Tiếng Việt) */
$magicWords['vi'] = array(
	'disambiguation' => array( '__ĐỊNH_HƯỚNG__', '__ĐỊNHHƯỚNG__' ),
);

/** Simplified Chinese (中文（简体）‎) */
$magicWords['zh-hans'] = array(
	'disambiguation' => array( '__消歧义__', '__消除歧义__' ),
);