/*
 * This file is part of the MediaWiki extension MediaViewer.
 *
 * MediaViewer is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * MediaViewer is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with MediaViewer.  If not, see <http://www.gnu.org/licenses/>.
 */

( function( mw, $, oo ) {
	var TP;

	/**
	 * A tab in a mw.mmv.ui.Pane component
	 * @class mw.mmv.ui.reuse.Tab
	 * @extends mw.mmv.ui.Element
	 * @param {jQuery} $container
	 * @constructor
	 */
	function Tab( $container ) {
		Tab['super'].call( this, $container );

		/**
		 * Container for the tab.
		 * @property {jQuery}
		 */
		this.$pane = $( '<div>' ).addClass( 'mw-mmv-reuse-pane' );

	}
	oo.inheritClass( Tab, mw.mmv.ui.Element );
	TP = Tab.prototype;

	/**
	 * Shows the pane.
	 */
	TP.show = function () {
		this.$pane.addClass( 'active' );
	};

	/**
	 * Hides the pane.
	 */
	TP.hide = function () {
		this.$pane.removeClass( 'active' );
	};

	/**
	 * Makes the entire input/textarea selected when focused.
	 * Invoked with that input/textarea as context.
	 */
	TP.selectAllOnEvent = function () {
		try {
			this.select();
		} catch ( e ) {
			// IE doesn't like when select() is called during the onfocus handler
		}
	};

	/**
	 * Reduces the action of clicks to solely focusing the input/textarea.
	 * Essentialy disables clicking inside the text to select a portion of it.
	 * Invoked with that input/textarea as context.
	 */
	TP.onlyFocus = function ( e ) {
		this.focus();
		e.preventDefault();
		return false;
	};

	mw.mmv.ui.reuse.Tab = Tab;
}( mediaWiki, jQuery, OO ) );
