/*
 * This file is part of the MediaWiki extension MediaViewer.
 *
 * MediaViewer is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * MediaViewer is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with MediaViewer.  If not, see <http://www.gnu.org/licenses/>.
 */

( function( mw, $ ) {
	QUnit.module( 'mw.mmv.ui.Permission', QUnit.newMwEnvironment() );

	QUnit.test( 'Constructor sanity check', 1, function( assert ) {
		var $qf = $( '#qunit-fixture' ),
			permission = new mw.mmv.ui.Permission( $qf );

		assert.ok( permission, 'constructor does not throw error' );
	} );

	QUnit.test( 'set()', 5, function( assert ) {
		var $qf = $( '#qunit-fixture' ),
			permission = new mw.mmv.ui.Permission( $qf ),
			text = 'Nothing to see here.';

		permission.set( text );

		// FIXME get rid of "view more" - this is temporary
		assert.strictEqual( permission.$text.children().remove().end().text(),
			text, 'permission text is set' );
		assert.strictEqual( permission.$html.text(), text, 'permission html is set' );
		assert.ok( permission.$text.is( ':visible' ), 'permission text is visible' );
		assert.ok( !permission.$html.is( ':visible' ), 'permission html is not visible' );
		assert.ok( !permission.$close.is( ':visible' ), 'close button is not visible' );
	} );

	QUnit.test( 'set() with html', 2, function( assert ) {
		var $qf = $( '#qunit-fixture' ),
			permission = new mw.mmv.ui.Permission( $qf ),
			text = '<b>Nothing</b> to see here.';

		permission.set( text );

		assert.ok( !permission.$text.find( 'b' ).length, 'permission text has no html' );
		assert.ok( permission.$html.find( 'b' ), 'permission html has html' );
	} );

	QUnit.test( 'empty()', 3, function( assert ) {
		var $qf = $( '#qunit-fixture' ),
			permission = new mw.mmv.ui.Permission( $qf ),
			text = 'Nothing to see here.';

		permission.set( text );
		permission.empty();

		assert.ok( !permission.$text.is( ':visible' ), 'permission text is not visible' );
		assert.ok( !permission.$html.is( ':visible' ), 'permission html is not visible' );
		assert.ok( !permission.$close.is( ':visible' ), 'close button is not visible' );
	} );

	QUnit.test( 'grow()', 3, function( assert ) {
		var $qf = $( '#qunit-fixture' ),
			permission = new mw.mmv.ui.Permission( $qf ),
			text = 'Nothing to see here.',
			oldAnimate = $.fn.animate; // animation would keep running, conflict with other tests

		$.fn.animate = function () { return this; };

		permission.set( text );
		permission.grow();

		assert.ok( !permission.$text.is( ':visible' ), 'permission text is not visible' );
		assert.ok( permission.$html.is( ':visible' ), 'permission html is visible' );
		assert.ok( permission.$close.is( ':visible' ), 'close button is visible' );

		$.fn.animate = oldAnimate;
	} );

	QUnit.test( 'shrink()', 3, function( assert ) {
		var $qf = $( '#qunit-fixture' ),
			permission = new mw.mmv.ui.Permission( $qf ),
			text = 'Nothing to see here.',
			oldAnimate = $.fn.animate; // animation would keep running, conflict with other tests

		$.fn.animate = function () { return this; };

		permission.set( text );
		permission.grow();
		permission.shrink();

		assert.ok( permission.$text.is( ':visible' ), 'permission text is visible' );
		assert.ok( !permission.$html.is( ':visible' ), 'permission html is not visible' );
		assert.ok( !permission.$close.is( ':visible' ), 'close button is not visible' );

		$.fn.animate = oldAnimate;
	} );
}( mediaWiki, jQuery ) );
