( function ( $ ) {
	'use strict';

	var amTransliteration = {
		id: 'am-transliteration',
		name: 'Amharic Transliteration',
		description: 'Amharic Transliteration',
		date: '2012-09-09',
		URL: 'http://am.wikipedia.org/wiki/%E1%8A%A5%E1%88%AD%E1%8B%B3%E1%89%B3:%E1%8A%A2%E1%89%B5%E1%8B%AE%E1%8D%92%E1%8A%AD_%E1%88%B4%E1%88%AB',
		author: 'Elfalem [[User:Elfalem]])',
		license: 'GPLv3',
		version: '1.0',
		contextLength: 1,
		maxKeyLength: 2,
		patterns: [
			[ '\\\\([A-Za-z\\>\\<_~ ])', '\\\\', '$1' ], // include space also

			[ '፼0', '፲፼' ], // 10000 and 0 becomes 10 10000
			[ '፲፻0', '፼' ], // 10x100 and 0 becomes 10000
			[ '፻0', '፲፻' ], // NUM_100 and 0 becomes 10 100

			[ '፻0', '፲፻' ], // 1000

			[ '፳0', '፪፻' ], // 200
			[ '፴0', '፫፻' ], // 300
			[ '፵0', '፬፻' ], // 400
			[ '፶0', '፭፻' ], // 500
			[ '፷0', '፮፻' ], // 600
			[ '፸0', '፯፻' ], // 700
			[ '፹0', '፰፻' ], // 800
			[ '፺0', '፱፻' ], // 900

			[ '፩0', '፲' ], // 10
			[ '፪0', '፳' ], // 20
			[ '፫0', '፴' ], // 30
			[ '፬0', '፵' ], // 40
			[ '፭0', '፶' ], // 50
			[ '፮0', '፷' ], // 60
			[ '፯0', '፸' ], // 70
			[ '፰0', '፹' ], // 80
			[ '፱0', '፺' ], // 90
			[ '፲0', '፻' ], // 100

			[ '1', '፩' ],
			[ '2', '፪' ],
			[ '3', '፫' ],
			[ '4', '፬' ],
			[ '5', '፭' ],
			[ '6', '፮' ],
			[ '7', '፯' ],
			[ '8', '፰' ],
			[ '9', '፱' ],

			[ 'ህe', 'ሀ' ],
			[ 'ህu', 'ሁ' ],
			[ 'ህi', 'ሂ' ],
			[ 'ህa', 'ሃ' ],
			[ '(ሀe|ህE)', 'ሄ' ],
			[ 'ህo', 'ሆ' ],
			[ 'ህW', 'ኋ' ],

			[ 'ልe', 'ለ' ],
			[ 'ልu', 'ሉ' ],
			[ 'ልi', 'ሊ' ],
			[ 'ልa', 'ላ' ],
			[ '(ለe|ልE)', 'ሌ' ],
			[ 'ልo', 'ሎ' ],
			[ 'ልW', 'ሏ' ],

			[ 'ሕe', 'ሐ' ],
			[ 'ሕu', 'ሑ' ],
			[ 'ሕi', 'ሒ' ],
			[ 'ሕa', 'ሓ' ],
			[ '(ሐe|ሕE)', 'ሔ' ],
			[ 'ሕo', 'ሖ' ],
			[ 'ሕW', 'ሗ' ],

			[ 'ምe', 'መ' ],
			[ 'ምu', 'ሙ' ],
			[ 'ምi', 'ሚ' ],
			[ 'ምa', 'ማ' ],
			[ '(መe|ምE)', 'ሜ' ],
			[ 'ምo', 'ሞ' ],
			[ 'ምW', 'ሟ' ],

			[ 'ርe', 'ረ' ],
			[ 'ርu', 'ሩ' ],
			[ 'ርi', 'ሪ' ],
			[ 'ርa', 'ራ' ],
			[ '(ረe|ርE)', 'ሬ' ],
			[ 'ርo', 'ሮ' ],
			[ 'ርW', 'ሯ' ],

			[ 'ስe', 'ሰ' ],
			[ 'ስu', 'ሱ' ],
			[ 'ስi', 'ሲ' ],
			[ 'ስa', 'ሳ' ],
			[ '(ሰe|ስE)', 'ሴ' ],
			[ 'ስo', 'ሶ' ],
			[ 'ስW', 'ሷ' ],

			[ 'ሥe', 'ሠ' ],
			[ 'ሥu', 'ሡ' ],
			[ 'ሥi', 'ሢ' ],
			[ 'ሥa', 'ሣ' ],
			[ '(ሠe|ሥE)', 'ሤ' ],
			[ 'ሥo', 'ሦ' ],
			[ 'ሥW', 'ሧ' ],

			[ 'ሽe', 'ሸ' ],
			[ 'ሽu', 'ሹ' ],
			[ 'ሽi', 'ሺ' ],
			[ 'ሽa', 'ሻ' ],
			[ '(ሸe|ሽE)', 'ሼ' ],
			[ 'ሽo', 'ሾ' ],
			[ 'ሽW', 'ሿ' ],

			[ 'ቅe', 'ቀ' ],
			[ 'ቅu', 'ቁ' ],
			[ 'ቅi', 'ቂ' ],
			[ 'ቅa', 'ቃ' ],
			[ '(ቀe|ቅE)', 'ቄ' ],
			[ 'ቅo', 'ቆ' ],

			[ 'ቋe', 'ቈ' ],
			[ '(ቋu|ቋW)', 'ቍ' ],
			[ 'ቋi', 'ቊ' ],
			[ 'ቋa', 'ቋ' ],
			[ 'ቋo', 'ቌ' ],

			[ 'ቕe', 'ቐ' ],
			[ 'ቕu', 'ቑ' ],
			[ 'ቕi', 'ቒ' ],
			[ 'ቕa', 'ቓ' ],
			[ '(ቐe|ቕE)', 'ቔ' ],
			[ 'ቕo', 'ቖ' ],
			[ 'ቕW', 'ቛ' ],

			[ '(ቛe|ቛee)', 'ቜ' ], // the second pattern probably won't be invoked in any case
			[ 'ቛu', 'ቘ' ],
			[ 'ቛi', 'ቚ' ],
			[ 'ቛa', 'ቝ' ],

			[ 'ብe', 'በ' ],
			[ 'ብu', 'ቡ' ],
			[ 'ብi', 'ቢ' ],
			[ 'ብa', 'ባ' ],
			[ '(በe|ብE)', 'ቤ' ],
			[ 'ብo', 'ቦ' ],
			[ 'ብW', 'ቧ' ],

			[ 'ቭe', 'ቨ' ],
			[ 'ቭu', 'ቩ' ],
			[ 'ቭi', 'ቪ' ],
			[ 'ቭa', 'ቫ' ],
			[ '(ቨe|ቭE)', 'ቬ' ],
			[ 'ቭo', 'ቮ' ],
			[ 'ቭW', 'ቯ' ],

			[ 'ትe', 'ተ' ],
			[ 'ትu', 'ቱ' ],
			[ 'ትi', 'ቲ' ],
			[ 'ትa', 'ታ' ],
			[ '(ተe|ትE)', 'ቴ' ],
			[ 'ትo', 'ቶ' ],
			[ 'ትW', 'ቷ' ],

			[ 'ችe', 'ቸ' ],
			[ 'ችu', 'ቹ' ],
			[ 'ችi', 'ቺ' ],
			[ 'ችa', 'ቻ' ],
			[ '(ቸe|ችE)', 'ቼ' ],
			[ 'ችo', 'ቾ' ],
			[ 'ችW', 'ቿ' ],

			[ 'ንe', 'ነ' ],
			[ 'ንu', 'ኑ' ],
			[ 'ንi', 'ኒ' ],
			[ 'ንa', 'ና' ],
			[ '(ነe|ንE)', 'ኔ' ],
			[ 'ንo', 'ኖ' ],
			[ 'ንW', 'ኗ' ],

			[ 'ኝe', 'ኘ' ],
			[ 'ኝu', 'ኙ' ],
			[ 'ኝi', 'ኚ' ],
			[ 'ኝa', 'ኛ' ],
			[ '(ኘe|ኝE)', 'ኜ' ],
			[ 'ኝo', 'ኞ' ],
			[ 'ኝW', 'ኟ' ],

			[ 'ክe', 'ከ' ],
			[ 'ክu', 'ኩ' ],
			[ 'ክi', 'ኪ' ],
			[ 'ክa', 'ካ' ],
			[ '(ከe|ክE)', 'ኬ' ],
			[ 'ክo', 'ኮ' ],
			[ 'ክW', 'ኳ' ],

			[ 'ኳe', 'ኰ' ],
			[ '(ኳu|ኳ\')', 'ኵ' ],
			[ 'ኳi', 'ኲ' ],
			[ '(ኰe|ኳE)', 'ኴ' ],

			[ 'ኽe', 'ኸ' ],
			[ 'ኽu', 'ኹ' ],
			[ 'ኽi', 'ኺ' ],
			[ 'ኽa', 'ኻ' ],
			[ '(ኸe|ኽE)', 'ኼ' ],
			[ 'ኽo', 'ኾ' ],
			[ 'ኽW', 'ዃ' ],

			[ 'ዃe', 'ዀ' ],
			[ '(ዃu|ዃ\')', 'ዅ' ],
			[ 'ዃi', 'ዂ' ],
			[ 'ዃE', 'ዄ' ],

			[ 'ውe', 'ወ' ],
			[ 'ውu', 'ዉ' ],
			[ 'ውi', 'ዊ' ],
			[ 'ውa', 'ዋ' ],
			[ '(ወe|ውE)', 'ዌ' ],
			[ 'ውo', 'ዎ' ],

			[ 'ዝe', 'ዘ' ],
			[ 'ዝu', 'ዙ' ],
			[ 'ዝi', 'ዚ' ],
			[ 'ዝa', 'ዛ' ],
			[ '(ዘe|ዝE)', 'ዜ' ],
			[ 'ዝo', 'ዞ' ],
			[ 'ዝW', 'ዟ' ],

			[ 'ዥe', 'ዠ' ],
			[ 'ዥu', 'ዡ' ],
			[ 'ዥi', 'ዢ' ],
			[ 'ዥa', 'ዣ' ],
			[ '(ዠe|ዥE)', 'ዤ' ],
			[ 'ዥo', 'ዦ' ],
			[ 'ዥW', 'ዧ' ],

			[ 'ይe', 'የ' ],
			[ 'ይu', 'ዩ' ],
			[ 'ይi', 'ዪ' ],
			[ 'ይa', 'ያ' ],
			[ '(የe|ይE)', 'ዬ' ],
			[ 'ይo', 'ዮ' ],

			[ 'ድe', 'ደ' ],
			[ 'ድu', 'ዱ' ],
			[ 'ድi', 'ዲ' ],
			[ 'ድa', 'ዳ' ],
			[ '(ደe|ድE)', 'ዴ' ],
			[ 'ድo', 'ዶ' ],
			[ 'ድW', 'ዷ' ],

			[ 'ዽe', 'ዸ' ],
			[ 'ዽu', 'ዹ' ],
			[ 'ዽi', 'ዺ' ],
			[ 'ዽa', 'ዻ' ],
			[ '(ዸe|ዽE)', 'ዼ' ],
			[ 'ዽo', 'ዾ' ],
			[ 'ዽW', 'ዿ' ],

			[ 'ጅe', 'ጀ' ],
			[ 'ጅu', 'ጁ' ],
			[ 'ጅi', 'ጂ' ],
			[ 'ጅa', 'ጃ' ],
			[ '(ጀe|ጅE)', 'ጄ' ],
			[ 'ጅo', 'ጆ' ],
			[ 'ጅW', 'ጇ' ],

			[ 'ግe', 'ገ' ],
			[ 'ግu', 'ጉ' ],
			[ 'ግi', 'ጊ' ],
			[ 'ግa', 'ጋ' ],
			[ '(ገe|ግE)', 'ጌ' ],
			[ 'ግo', 'ጎ' ],

			[ 'ጓe', 'ጐ' ],
			[ '(ጓu|ጓ\')', 'ጕ' ],
			[ 'ጓi', 'ጒ' ],
			[ '(ጐe|ጓE)', 'ጔ' ],

			[ 'ጝe', 'ጘ' ],
			[ 'ጝu', 'ጙ' ],
			[ 'ጝi', 'ጚ' ],
			[ 'ጝa', 'ጛ' ],
			[ '(ጘe|ጝE)', 'ጜ' ],
			[ 'ጝo', 'ጞ' ],

			[ 'ጥe', 'ጠ' ],
			[ 'ጥu', 'ጡ' ],
			[ 'ጥi', 'ጢ' ],
			[ 'ጥa', 'ጣ' ],
			[ '(ጠe|ጥE)', 'ጤ' ],
			[ 'ጥo', 'ጦ' ],
			[ 'ጥW', 'ጧ' ],

			[ 'ጭe', 'ጨ' ],
			[ 'ጭu', 'ጩ' ],
			[ 'ጭi', 'ጪ' ],
			[ 'ጭa', 'ጫ' ],
			[ '(ጨe|ጭE)', 'ጬ' ],
			[ 'ጭo', 'ጮ' ],
			[ 'ጭW', 'ጯ' ],

			[ 'ጵe', 'ጰ' ],
			[ 'ጵu', 'ጱ' ],
			[ 'ጵi', 'ጲ' ],
			[ 'ጵa', 'ጳ' ],
			[ '(ጰe|ጵE)', 'ጴ' ],
			[ 'ጵo', 'ጶ' ],
			[ 'ጵW', 'ጷ' ],

			[ 'ጽe', 'ጸ' ],
			[ 'ጽu', 'ጹ' ],
			[ 'ጽi', 'ጺ' ],
			[ 'ጽa', 'ጻ' ],
			[ '(ጸe|ጽE)', 'ጼ' ],
			[ 'ጽo', 'ጾ' ],
			[ 'ጽW', 'ጿ' ],

			[ 'ፅe', 'ፀ' ],
			[ 'ፅu', 'ፁ' ],
			[ 'ፅi', 'ፂ' ],
			[ 'ፅa', 'ፃ' ],
			[ '(ፀe|ፅE)', 'ፄ' ],
			[ 'ፅo', 'ፆ' ],

			[ 'ፍe', 'ፈ' ],
			[ 'ፍu', 'ፉ' ],
			[ 'ፍi', 'ፊ' ],
			[ 'ፍa', 'ፋ' ],
			[ '(ፈe|ፍE)', 'ፌ' ],
			[ 'ፍo', 'ፎ' ],
			[ 'ፍW', 'ፏ' ],
			[ 'ፍY', 'ፚ' ],

			[ 'ፕe', 'ፐ' ],
			[ 'ፕu', 'ፑ' ],
			[ 'ፕi', 'ፒ' ],
			[ 'ፕa', 'ፓ' ],
			[ '(ፐe|ፕE)', 'ፔ' ],
			[ 'ፕo', 'ፖ' ],
			[ 'ፕW', 'ፗ' ],

			// the following mappings are not documented in Ethiopic sera
			[ 'ኅu', 'ኁ' ],
			[ 'ኅi', 'ኂ' ],
			[ 'ኅa', 'ኃ' ],
			[ 'ኅE', 'ኄ' ],
			[ 'ኅo', 'ኆ' ],
			[ 'ኅW', 'ኋ' ],
			//end

			[ 'ህh', 'ኅ' ],
			[ 'h', 'ህ' ],
			[ '(l|L)', 'ል' ],
			[ 'H', 'ሕ' ],
			[ '(m|M)', 'ም' ],
			[ '(r|R)', 'ር' ],
			[ 'ስs', 'ሥ' ],
			[ 's', 'ስ' ],
			[ '(x|X)', 'ሽ' ],
			[ 'q', 'ቅ' ],
			[ 'ቅW', 'ቋ' ],
			[ 'Q', 'ቕ' ],
			[ 'ቕW', 'ቛ' ],
			[ '(b|B)', 'ብ' ],
			[ '(v|V)', 'ቭ' ],
			[ 't', 'ት' ],
			[ 'c', 'ች' ],
			[ 'n', 'ን' ],
			[ 'N', 'ኝ' ],
			[ 'k', 'ክ' ],
			[ '(ክW|ኳa)', 'ኳ' ],
			[ 'K', 'ኽ' ],
			[ '(ኽW|ዃa)', 'ዃ' ],
			[ 'z', 'ዝ' ],
			[ 'Z', 'ዥ' ],
			[ '(y|Y)', 'ይ' ],
			[ 'd', 'ድ' ],
			[ 'D', 'ዽ' ],
			[ '(j|J)', 'ጅ' ],
			[ 'g', 'ግ' ],
			[ '(ግW|ጓa)', 'ጓ' ],
			[ 'G', 'ጝ' ],
			[ 'T', 'ጥ' ],
			[ 'C', 'ጭ' ],
			[ 'P', 'ጵ' ],
			[ 'ጽS', 'ፅ' ],
			[ 'S', 'ጽ' ],
			[ '(f|F)', 'ፍ' ],
			[ 'p', 'ፕ' ],
			[ '(w|W)', 'ው' ],

			// vowels
			// the following mappings are not documented in Ethiopic sera
			[ 'አa', 'ዓ' ],
			[ 'A', 'ኣ' ],
			[ 'አe', 'ዐ' ],
			[ 'ኡu', 'ዑ' ],
			[ 'ኢi', 'ዒ' ],
			[ 'ኤE', 'ዔ' ],
			[ 'እe', 'ዕ' ],
			[ 'ኦo', 'ዖ' ],
			//end undocumented

			[ 'እa', 'ኧ' ],
			[ 'e', 'እ' ],
			[ 'u', 'ኡ' ],
			[ 'i', 'ኢ' ],
			[ 'a', 'አ' ],
			[ 'E', 'ኤ' ],
			[ 'o', 'ኦ' ],
			//end vowels

			[ '\\<\\<', '«' ],
			[ '\\>\\>', '»' ],
			[ '\\?\\?', '፧' ],
			[ '\\*\\*', '፨' ],
			[ '\\;', '፤' ],
			[ '፡\\:', '።' ],
			[ ',', '፣' ],
			[ '፡-', '፦' ],
			[ '\\:', '፡' ]

		]
	};

	$.ime.register( amTransliteration );
}( jQuery ) );
