( function ( $ ) {
	'use strict';

	var ckbTransliterationLakbd = {
		id: 'ckb-transliteration-lakbd',
		name: 'لاتینی',
		description: 'Central Kurdish keyboard based on Latin keyboard',
		date: '2013-07-06',
		URL: 'http://github.com/wikimedia/jquery.ime',
		author: 'Çalak',
		license: 'GPLv3',
		version: '1.0',
		patterns: [
			['1', '١'],
			['2', '٢'],
			['3', '٣'],
			['4', '٤'],
			['5', '٥'],
			['6', '٦'],
			['7', '٧'],
			['8', '٨'],
			['9', '٩'],
			['0', '٠'],

			['q', 'ق'],
			['w', 'و'],
			['e', 'ە'],
			['r', 'ر'],
			['t', 'ت'],
			['y', 'ی'],
			['u', 'ئ'],
			['i', 'ح'],
			['o', 'ۆ'],
			['p', 'پ'],
			['\\[', ']'],
			['\\]', '['],

			['a', 'ا'],
			['s', 'س'],
			['d', 'د'],
			['f', 'ف'],
			['g', 'گ'],
			['h', 'ھ'],
			['j', 'ژ'],
			['k', 'ک'],
			['l', 'ل'],
			['\\;', '؛'],

			['z', 'ز'],
			['x', 'خ'],
			['c', 'ج'],
			['v', 'ڤ'],
			['b', 'ب'],
			['n', 'ن'],
			['m', 'م'],
			['\\,', '،'],
			['\\.', '.'],

			['\\%', '٪'],
			['\\(', ')'],
			['\\)', '('],

			['Q', 'ڎ'],
			['W', 'وو'],
			['E', 'ێ'],
			['R', 'ڕ'],
			['T', 'ط'],
			['Y', 'ي'],
			['U', 'ء'],
			['I', 'ع'],
			['O', 'ؤ'],
			['P', 'ث'],
			['\\{', '}'],
			['\\}', '{'],

			['A', 'آ'],
			['S', 'ش'],
			['D', 'ذ'],
			['F', 'إ'],
			['G', 'غ'],
			['H', 'ه'],
			['J', 'أ'],
			['K', 'ك'],
			['L', 'ڵ'],

			['Z', 'ض'],
			['X', 'ص'],
			['C', 'چ'],
			['V', 'ظ'],
			['B', 'ى'],
			['N', 'ة'],
			['M', 'ـ'],
			['\\<', '>'],
			['\\>', '<'],
			['\\?', '؟']
		]
	};

	$.ime.register( ckbTransliterationLakbd );
}( jQuery ) );
