( function ( $ ) {
	'use strict';

	var guPhonetic = {
		id: 'gu-phonetic',
		name: 'ફોનૅટિક',
		description: 'Phonetic keyboard for Gujarati script',
		date: '2013-11-15',
		author: 'Parag Nemade',
		license: 'GPLv3',
		version: '1.0',
		patterns: [
			['\\~', 'ઍ'],
			['\\`', 'ૅ'],
			['\\!', '!'],
			['1', '૧'],
			['\\@', '@'],
			['2', '૨'],
			['\\#', '#'],
			['3', '૩'],
			['\\$', '$'],
			['4', '૪'],
			['\\&', '૱'],
			['5', '૫'],
			['6', '૬'],
			['7', '૭'],
			['8', '૮'],
			['\\(', '('],
			['9', '૯'],
			['\\)', ')'],
			['0', '૦'],
			['\\_', '_'],
			['\\-', '-'],
			['\\+', '+'],
			['\\=', '='],
			['Q', 'ઔ'],
			['q', 'ઓ'],
			['W', 'ઠ'],
			['w', 'ટ'],
			['E', 'ૈ'],
			['e', 'ે'],
			['R', 'ૃ'],
			['r', 'ર'],
			['T', 'થ'],
			['t', 'ત'],
			['Y', 'ય઼'],
			['y', 'ય'],
			['U', 'ૂ'],
			['u', 'ુ'],
			['I', 'ી'],
			['i', 'િ'],
			['O', 'ૌ'],
			['o', 'ો'],
			['P', 'ફ'],
			['p', 'પ'],
			['\\{', 'ઢ'],
			['\\[', 'ડ'],
			['\\}', 'ર઼'],
			['\\]', 'ઋ'],
			['A', 'આ'],
			['a', 'ા'],
			['S', 'શ'],
			['s', 'સ'],
			['D', 'ધ'],
			['d', 'દ'],
			['F', 'અ'],
			['f', '્'],
			['G', 'ઘ'],
			['g', 'ગ'],
			['H', 'ઃ'],
			['h', 'હ'],
			['J', 'ઝ'],
			['j', 'જ'],
			['K', 'ખ'],
			['k', 'ક'],
			['L', 'ળ'],
			['l', 'લ'],
			[':', 'ઈ'],
			[';', 'ઇ'],
			['"', 'ઊ'],
			['\\\'', 'ઉ'],
			['\\|', 'ઑ'],
			['\\\\', 'ૉ'],
			['Z', 'ઁ'],
			['z', 'ઙ'],
			['x', 'ષ'],
			['C', 'છ'],
			['c', 'ચ'],
			['V', 'ઽ'],
			['v', 'વ'],
			['B', 'ભ'],
			['b', 'બ'],
			['N', 'ણ'],
			['n', 'ન'],
			['M', 'ં'],
			['m', 'મ'],
			['\\<', 'ૐ'],
			[',', ','],
			['\\>', '઼'],
			['\\.', '.'],
			['\\?', 'ઐ'],
			['/', 'એ'],
			['X', 'ક્ષ'],
			['\\%', 'જ્ઞ'],
			['\\^', 'ત્ર'],
			['\\*', 'શ્ર']]
	};

	$.ime.register( guPhonetic );
}( jQuery ) );
