/**
 * Eastern Armenian phonetic layout introduced by Microsoft in Windows 2000 and depreceated
 * in Windows 8.
 * Original layout was created in late 90-ies based on Unicode 3, and was never updated
 * since release, causing it to be incompatible with Unicode.
 *
 * This layout version complies with Unicode 6.1, including all valid Armenian punctuation signs,
 * mijaket (outside of main Armenian Unicode range) and Dram (AMD) sign under USD sign (Shift + 4).
 * Please, double-check with Unicode before making any changes here.
 *
 * Layout supports extended keys, with AltGr (Alt or Alt+Ctrl on some systems) + key,
 * producing digits and punctuation marks from standard US keyboard layout.
 */

( function ( $ ) {
	'use strict';

	var hyEmslegacy = {
		id: 'hy-emslegacy',
		name: 'ՄՍ Արևելահայերեն (հնացած)',
		description: 'Legacy keyboard layout for Eastern Armenian by Microsoft',
		date: '2013-02-11',
		URL: 'http://www.microsoft.com/resources/msdn/goglobal/keyboards/kbdarme.html',
		author: 'Parag Nemade, Aleksey Chalabyan',
		license: 'GPLv3',
		version: '1.1',
		patterns: [
			['1', '։'],
			['\\!', '1'],
			['2', 'ձ'],
			['\\@', 'Ձ'],
			['3', 'յ'],
			['\\#', 'Յ'],
			['4', '՛'],
			['\\$', '֏'],
			['5', ','],
			['\\%', '4'],
			['6', '-'],
			['\\^', '9'],
			['7', '․'],
			['\\&', 'և'],
			['8', '«'],
			['\\*', '('],
			['9', '»'],
			['\\(', ')'],
			['0', 'օ'],
			['\\)', 'Օ'],
			['\\-', 'ռ'],
			['\\_', 'Ռ'],
			['\\=', 'ժ'],
			['\\+', 'Ժ'],
			['\\`', '՝'],
			['\\~', '՜'],
			['q', 'խ'],
			['Q', 'Խ'],
			['w', 'ւ'],
			['W', 'Ւ'],
			['e', 'է'],
			['E', 'Է'],
			['r', 'ր'],
			['R', 'Ր'],
			['t', 'տ'],
			['T', 'Տ'],
			['y', 'ե'],
			['Y', 'Ե'],
			['u', 'ը'],
			['U', 'Ը'],
			['i', 'ի'],
			['I', 'Ի'],
			['o', 'ո'],
			['O', 'Ո'],
			['p', 'պ'],
			['P', 'Պ'],
			['\\[', 'չ'],
			['\\{', 'Չ'],
			['\\]', 'ջ'],
			['\\}', 'Ջ'],
			['\\\\', '\''],
			['\\|', '՞'],
			['a', 'ա'],
			['A', 'Ա'],
			['s', 'ս'],
			['S', 'Ս'],
			['d', 'դ'],
			['D', 'Դ'],
			['f', 'ֆ'],
			['F', 'Ֆ'],
			['g', 'ք'],
			['G', 'Ք'],
			['h', 'հ'],
			['H', 'Հ'],
			['j', 'ճ'],
			['J', 'Ճ'],
			['k', 'կ'],
			['K', 'Կ'],
			['l', 'լ'],
			['L', 'Լ'],
			[';', 'թ'],
			[':', 'Թ'],
			['\'', 'փ'],
			['\"', 'Փ'],
			['z', 'զ'],
			['Z', 'Զ'],
			['x', 'ց'],
			['X', 'Ց'],
			['c', 'գ'],
			['C', 'Գ'],
			['v', 'վ'],
			['V', 'Վ'],
			['b', 'բ'],
			['B', 'Բ'],
			['n', 'ն'],
			['N', 'Ն'],
			['m', 'մ'],
			['M', 'Մ'],
			[',', 'շ'],
			['\\<', 'Շ'],
			['\\.', 'ղ'],
			['\\>', 'Ղ'],
			['/', 'ծ'],
			['\\?', 'Ծ']
		],
		patterns_x: [
			['1', '1'],
			['\\!', '!'],
			['2', '2'],
			['\\@', '@'],
			['3', '3'],
			['\\#', '#'],
			['4', '4'],
			['\\$', '$'],
			['5', '5'],
			['\\%', '%'],
			['6', '6'],
			['\\^', '^'],
			['7', '7'],
			['\\&', '&'],
			['8', '8'],
			['\\*', '*'],
			['9', '9'],
			['\\(', '('],
			['0', '0'],
			['\\)', ')'],
			['\\-', '-'],
			['\\_', '_'],
			['\\=', '='],
			['\\+', '+'],
			['\\`', '`'],
			['\\~', '~'],
			['\\[', '['],
			['\\{', '{'],
			['\\]', ']'],
			['\\}', '}'],
			['\\\\', '\\'],
			['\\|', '|'],
			[';', ';'],
			['\\:', ':'],
			['\'', '\''],
			['\"', '\"'],
			['\\<', '<'],
			['\\.', '.'],
			['\\>', '>'],
			['/', '/'],
			['\\?', '?']
		]
	};

	$.ime.register( hyEmslegacy );
}( jQuery ) );
