<?php
$messages = array();
array_map( function ( $dir ) use ( &$messages ) {
	$files = glob( __DIR__ . "/../$dir/*.json" );
	foreach ( $files as $file ) {
		$langcode = substr( basename( $file ), 0, -5 );
		$data = json_decode( file_get_contents( $file ), /* $assoc = */ true );
		unset( $data['@metadata'] );
		$messages[$langcode] = isset( $messages[$langcode] ) ?
			array_merge( $messages[$langcode], $data ) :
			$data;
	}
}, array(
	'lib/oojs-ui/i18n',
	'modules/ve/i18n',
	'modules/ve-mw/i18n',
	'modules/ve-wmf/i18n'
) );

$output = <<<END
<?php
/**
 * DO NOT EDIT THIS FILE
 *
 * This file is GENERATED from the JSON blobs in the i18n directories, where the actual i18n
 * messages live.
 *
 * DO NOT EDIT THIS FILE
 *
 * Instead, make your changes in modules/.../i18n/en.json and qqq.json, then run
 * php bin/buildi18n-php.php to rebuild this file.
 *
 * NO SERIOUSLY, DO NOT DIRECTLY EDIT THIS FILE, EVER
 * @file
 */
\$messages = array();

END;
$firstcodes = array( 'en', 'qqq' );
$langcodes = array_merge( $firstcodes, array_diff( array_keys( $messages ), $firstcodes ) );
foreach ( $langcodes as $langcode ) {
	$output .= "\n\$messages['$langcode'] = " . var_export( $messages[$langcode], true ) . ";\n";
}

file_put_contents( __DIR__ . '/../VisualEditor.i18n.php', $output );
