<?php

namespace ZeroBanner;
use IContextSource;
use MinervaTemplate;
use MobileContext;
use OutputPage;

/**
 * Main class for ZeroBanner extension.
 *
 * This class only contains static members.
 * Static methods are used by the hooks and by the Special:ZeroBanner.
 * The state is based on the X-CS and other headers, and has an instance
 * of config object and and a few header-based cached values.
 *
 * @file
 * @ingroup Extensions
 */
class PageRenderingHooks {

	/**
	 * @param IContextSource $context
	 * @return PageRendering
	 */
	public static function getState( IContextSource $context = null ) {
		static $state = null;
		if ( $state === null ) {
			$state = new PageRendering( $context );
		}
		return $state;
	}

	/**
	 * @param $out
	 * @return bool
	 */
	public static function onBeforePageDisplay( &$out ) {
		return self::getState( $out )->onBeforePageDisplay( $out );
	}

	/**
	 * @param MobileContext $context
	 * @param \MobileFormatter $formatter
	 * @return bool
	 */
	public static function onMobileFrontendBeforeDOM( MobileContext $context, \MobileFormatter $formatter ) {
		return self::getState( $context )->onMobileFrontendBeforeDOM( $formatter );
	}

	/**
	 * @param MinervaTemplate $template
	 * @return bool
	 */
	public static function onMinervaPreRender( MinervaTemplate $template ) {
		return self::getState()->onMinervaPreRender( $template );
	}

	/**
	 * @param array $vars
	 * @param OutputPage $out
	 * @return bool
	 */
	public static function onMakeGlobalVariablesScript( &$vars, OutputPage $out ) {
		return self::getState( $out )->onMakeGlobalVariablesScript( $vars, $out );
	}

	/**
	 * @param $subdomainTokenReplacement
	 * @param \MobileContext $context
	 * @return bool
	 */
	public static function onGetMobileUrl( &$subdomainTokenReplacement, MobileContext $context ) {
		return self::getState( $context )->onGetMobileUrl( $subdomainTokenReplacement );
	}
}
