/* global mw */
( function( M ) {
    'use strict';
    var ZeroInfo = M.require( 'Overlay' ).extend( {
	    template: M.template.get( 'zeroinfo.hogan' ),
	    closeOnBack: true,
	    defaults: {
		    intro: mw.msg( 'zero-info-intro' ),
		    geek: mw.msg( 'zero-info-geek' ),
		    ok: mw.msg( 'ok' )
	    },
	    initialize: function ( options ) {

		    var conf = (window && (window.zeroGlobalConfig || (window.mw && window.mw.zeroConfig))) || false,
			    moreInfo, lst, details;

		    if ( conf.bannerUrl ) {
			    moreInfo = $( '<a>' )
				    .attr( 'href', conf.bannerUrl )
				    .text( mw.msg( 'zero-info-url' ) );
			    this.defaults.moreInfo = moreInfo[0].outerHTML + ' ' +
			    mw.msg( conf.bannerWarning ? 'zero-info-url-not-free' : 'zero-info-url-free' );
		    }

		    if ( conf.whitelistedLangs.length > 0 ) {
			    // TODO: Convert conf.whitelistedLangs code list into proper language names
//				    var lst=[];
//				    for (var i=0; i<conf.whitelistedLangs.length; i++) {
//					    lst.append(
//						    $( '<a>', { href: conf.whitelistedLangs, text: conf.whitelistedLangs } )[0];
//					    );
//				    }
			    lst = conf.whitelistedLangs;
			    this.defaults.langs =
				    mw.msg( 'zero-info-langs', lst.toString(), conf.whitelistedLangs.length );

		    } else {
			    this.defaults.langs = '';
		    }

		    details = $( '<ul>' );

		    if ( conf.https ) {
			    $( '<li>' ).text( mw.msg( 'zero-info-https' ) ).appendTo( details );
		    }
		    if ( conf.proxy ) {
			    $( '<li>' ).text( mw.msg( 'zero-info-proxy', conf.proxy ) ).appendTo( details );
		    }
		    if ( conf.ipset ) {
			    $( '<li>' ).text( 'ipset=' + conf.ipset ).appendTo( details );
		    }
		    this.defaults.geekDetails = details[0].outerHTML;

		    this._super( options );
	    }
    } );

    M.router.route( /^zeroinfo/, function() {
        new ZeroInfo().show();
    } );

    M.define( 'ZeroInfo', ZeroInfo );

}( mw.mobileFrontend ) );
