import netaddr
import utils

if __name__ == '__main__':

    confs = utils.getAllConfigs()
    sets = {}
    errors = False
    for id in confs:
        conf = confs[id]
        vals = netaddr.cidr_merge([netaddr.IPNetwork(v) for v in conf['ips']])
        newSet = netaddr.IPSet(vals)
        for sId, sVal in sets.items():
            if not newSet.isdisjoint(sVal):
                errors = True
                print("*** '%s' has IPs that are also in '%s':" % (id, sId))
                for v in netaddr.cidr_merge((newSet & sVal)):
                    print('   %s' % v)
        sets[id] = newSet
    if errors:
        exit(1)
