from netaddr import *
import re

def optimize(confs):
    res = {}
    for xcs, conf in confs.items():
        ips = conf['ips']
        res[xcs] = optimizeCidr(ips)
    return res

def optimizeCidr(ips):
    return list([str(i).replace('/32','') for i in cidr_merge([IPNetwork(ip) for ip in ips])])

def vclToCidrStrs(vals):
    return [s2 for s2 in [re.sub(r'[ \t;"\n]', '', s) for s in vals] if s2 != '']

def cidrToVclStrs(vals):
    res = []
    for ip in vals:
        s = str(ip)
        s = s.replace('/32','') if ':' not in s else s.replace('/128','')
        s = s.replace('/','"/')
        if '"' not in s: s = s + '"'
        res.append( '"' + s + ';' )
    return res

def printOptimization(confs):
    opt = optimize(confs)
    for xcs in confs:
        ips = confs[xcs]['ips']
        if ips != opt[xcs]:
            print()
            printDiff(ips, opt[xcs], xcs + ':   ')

def confToIps(confs):
    return dict([(xcs, IPSet(ips['ips'])) for xcs, ips in confs.items()])
    

def printConflicts(confs, extra = None):
    sets = confToIps(confs)
    if extra is not None:
        sets['extra'] = IPSet(extra)
    for xcs, ips in sets.items():
        for xcs2, ips2 in sets.items():
            if xcs == xcs2: continue
            conflcts = ips & ips2
            if conflcts.size == 0:
                continue
            print('{0} conflicts with {1}:'.format(xcs,xcs2))
            for ip in ips:
                if ip in conflcts:
                    print('{0}: {1}'.format(xcs, ip))
            for ip in ips2:
                if ip in conflcts:
                    print('{0}: {1}'.format(xcs2, ip))

def load(file):
    with open(file,'r') as f:
        return list(vclToCidrStrs(f))

def printAcl(ips):
    for ip in cidrToVclStrs(ips):
        print(ip)

def findIp(confs, ipaddr):
    sets = dict([(xcs, [IPNetwork(ip) for ip in ips['ips']]) for xcs, ips in confs.items()])
    result = []
    ip = IPAddress(ipaddr)
    found = 0
    for i in range(10):
        for xcs in sets:
            for ipn in sets[xcs]:
                n = IPNetwork(ipn)
                if n.prefixlen <= i: continue
                n.prefixlen -= i
                if ip in n:
                    result.append((xcs, ipn, i))
                    found += 1
        if found > 0:
            break
    return result
