# If you're on a Mac, you'll probably want to follow the instructions at
# https://iainhunter.wordpress.com/2012/11/08/howto-install-python3-pip3-tornado-on-mac/
# to install python3 and pip3. Don't install Tornado unless you need it, though.
# After that, you'll need to install some packages if you don't already have them:
# sudo pip install BeautifulSoup4; sudo pip install requests; sudo pip install netaddr
# Finally, after commenting the last line of this file you can run python3 test.py


from utils import *
from netaddr import *
from cidr import *

def orderIps(conf):
    for xcs, c in conf.items():
        c['ips'].sort()

def confCompare(src1 = TEST, src2 = META):
    conf1 = getAllConfigs(src1)
    conf2 = getAllConfigs(src2)
    orderIps(conf1)
    orderIps(conf2)
    if conf1 != conf2:
        for id in set(list(conf1)+list(conf2)):
            if id in conf1 and id in conf2 and conf1[id] == conf2[id]:
                del conf1[id]
                del conf2[id]
        printDiff(conf1, conf2)
    else:
        print('Configurations are identical')


def cleanBanner(html, lang):
    tag = html.find('button', class_='notify-close')
    del tag['title']

    tag = html.a
    tag['href'] = re.sub(r'title=.*&', 'title=(REMOVED)&', tag['href'])

def checkBanner(expected, xcs, conf, site = TEST, lang='en', title = 'Test1'):
    try:
        exp = Soup(translate(lang, expected))
        original = wikiZ(site, title, xcs, {'uselang':lang})
        rcvd = Soup(original)
        rcvd = rcvd.find('div', id='zero-rated-banner')

        origExp = exp.a.text
        origRcvd = rcvd.a.text

        cleanBanner(exp, lang)
        cleanBanner(rcvd, lang)

        if str(exp) != str(rcvd):
            e = ('Expected != Received:\n' +
                str(exp) + '\n' + str(rcvd) + '\n\n\n' + original)
            try:
                with open('linkdiff_exp.txt', 'a+', encoding='utf-8') as o:
                    o.write('{0} {1}\n{2}\n'.format(xcs,lang,origExp))
                with open('linkdiff_rcv.txt', 'a+', encoding='utf-8') as o:
                    o.write('{0} {1}\n{2}\n'.format(xcs,lang,origRcvd))
            except:
                print('*** Unable to compare links')
                pass
            raise Exception(e)

    except:
        xcs = xcs.replace('*','#')
        file = 'err_{0}_{1}.html'.format(xcs, lang)
        print('Error in ' + file)
        with open(file, "w", encoding='utf-8') as err:
            err.write('\n'.join([str(s) for s in sys.exc_info()[1].args]))

def checkProdBanners(configSite = TEST, title = 'A', site = PROD):
    confs = getAllConfigs(configSite)
    for xcs, conf in confs.items():
        expected = getZeroBannersFromConfig(xcs, configSite)
        langs = conf['whitelistedLangs']
        if len(langs) == 0:
            langs = set(list(conf['banner']) + list(conf['name']) + list(conf['showLangs']))
        for lang in langs:
            # unknown languages
            if lang in ['zh-hans', 'zh-hant', 'be-tarask']:
                continue
            #if lang not in ['si','cs','as']:
            #    continue
            checkBanner(expected, xcs, conf, site.format(lang), lang, title)

def getZeroBannersFromConfig(xcs, site = TEST):
    data = api(site, action='mobileview', sections=0, page='Zero:'+xcs)
    html = data['sections'][0]['text']
    soup = Soup(html)

    return dict([(v.parent.parent.th.text, str(v)) for v in soup.find_all('div', class_='mw-mf-banner')])


def checkIPs(site = TEST):
    confs = getAllConfigs(site)
    printConflicts(confs)
    print()
    printOptimization(confs)


def findIpsInConf(file, site = META):
    confs = getAllConfigs(site)
    with open(file,'r') as f:
        for s in f:
            res = findIp(confs, s.strip())
            if len(res) > 1:
                print('%s found in %d ranges:' % (ipaddr, len(res)))
                for r in res:
                    print('   %s / %s - %d' % (r[0], r[1], r[2]))
            elif len(res) == 1:
                r = res[0]
                print('%s found in %s / %s - %d' % (ipaddr, r[0], r[1], r[2]))
            else:
                print('%s not found' % (ipaddr))

# checkProdBanners()
