import sys
import utils
import json
import getpass
from pprint import pprint

if len(sys.argv) != 2:
    raise Exception('Expects user name as argument')

with open('zero.json') as ipsfile:
    ips = json.load(ipsfile)

utils.login(sys.argv[1], getpass.getpass(), utils.ZERO)
token = utils.edittoken(utils.ZERO)
confs = utils.getAllConfigs()

for id, conf in confs.items():

    try:
        if id in ips:
            conf['ips'] = ips[id]
        elif not id.startswith('-'):
            conf['ips'] = []

        if 'admins' in conf:
            del conf['admins']

        text = json.dumps(conf)

        res = utils.api(utils.ZERO,
            action='edit',
            title='Zero:' + id,
            summary='(bot) upload',
            text=text,
            token=token,
            contentmodel='JsonZeroConfig')
        print('Upload %s %s' % (id, res['result']))
    except:
        print('Failed upload %s' % (id))
        pprint(sys.exc_info())
