{-
Opts.hs

Xadrez - A p2p chess written in Haskell
Copyright (C) 2005 Marco Tulio Gontijo e Silva

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
-}

module Opts (Flag (Version, Help, Server, Port), doOpts) where

import Network
import Distribution.GetOpt
import System.Environment


data Flag = Version |
            Help |
            Server |
            Port PortID

options :: [OptDescr Flag]
options
    = [Option "h" ["help"] (NoArg Help) "Display a help message.",
       Option "v" ["version"] (NoArg Version)
       "Display information about this version.",
       Option "s" ["server"] (NoArg Server) "Start xadrez as server.",
       Option "p" ["port"]
       (ReqArg (Port . PortNumber . fromIntegral . (read :: String -> Int))
        "PORT") "Change the port used by xadrez."]

doOpts :: IO [Flag]
doOpts
    = do
      s <- getArgs
      let (fs, _, _) = getOpt RequireOrder options s
      return $ clean fs

clean :: [Flag] -> [Flag]
clean [] = []
clean (Help : _) = [Help]
clean (Version : _) = [Version]
clean (Port s : xs) = Port s : clean xs
clean (Server : xs) = clean xs ++ [Server]