{-
Piece.hs

Xadrez - A p2p chess written in Haskell
Copyright (C) 2004-2005 Marco Tulio Gontijo e Silva

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
-}
module Piece (Piece, empty, king, queen, rook, knight, bishop, pawn,
	      white, black, sameColor, isEmpty, isKing, isQueen, isRook,
	      isKnight, isBishop, isPawn, moved, firstMove, passant,
	      isPassantPawn) where

data Piece = Empty |
	     King Bool Bool | -- Color Player
	     Queen Bool | -- Color
	     Rook Bool Bool | -- Color Player
	     Knight Bool | -- Color
	     Bishop Bool | -- Color
	     Pawn Bool Bool -- Color Passant
	     deriving Eq

empty :: Piece
empty = Empty

king, queen, rook, knight, bishop, pawn :: Bool -> Piece
king = flip King False
queen = Queen
rook = flip Rook False
knight = Knight
bishop = Bishop
pawn = flip Pawn False

instance Show Piece where
    show Empty = "  "
    show (King True _) = "K'"
    show (Queen True) = "Q'"
    show (Rook True _) = "R'"
    show (Knight True) = "N'"
    show (Bishop True) = "B'"
    show (Pawn True _) = "P'"
    show (King False _) = "k "
    show (Queen False) = "q "
    show (Rook False _) = "r "
    show (Knight False) = "n "
    show (Bishop False) = "b "
    show (Pawn False _) = "p "

black, white :: Bool
black = False
white = True

sameColor :: Piece -> Bool -> Bool
sameColor Empty = (\_ -> False)
sameColor (King c _) = (== c)
sameColor (Queen c) = (== c)
sameColor (Rook c _) = (== c)
sameColor (Knight c) = (== c)
sameColor (Bishop c) = (== c)
sameColor (Pawn c _) = (== c)

isEmpty, isKing, isQueen, isRook, isKnight, isBishop, isPawn :: Piece -> Bool
isEmpty Empty = True
isEmpty _ = False
isKing (King _ _) = True
isKing _ = False
isQueen (Queen _) = True
isQueen _ = False
isRook (Rook _ _) = True
isRook _ = False
isKnight (Knight _) = True
isKnight _ = False
isBishop (Bishop _) = True
isBishop _ = False
isPawn (Pawn _ _) = True
isPawn _ = False

moved :: Piece -> Piece
moved (King c _) = King c True
moved (Rook c _) = Rook c True
moved (Pawn c _) = Pawn c False
moved p = p

firstMove :: Piece -> Bool
firstMove (King _ p) = (not p)
firstMove (Rook _ p) = (not p)
firstMove _ = True

passant :: Piece -> Piece
passant (Pawn c _) = Pawn c True
passant p = p

isPassantPawn :: Piece -> Bool
isPassantPawn (Pawn _ p) = p
isPassantPawn _ = True