{-
Connection.hs

Xadrez - A p2p chess written in Haskell
Copyright (C) 2004 Rafael Cunha Almeida
Copyright (C) 2004-2005 Marco Tulio Gontijo e Silva

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
-}
module Connection (client, server, send, read') where

import Network
import IO

client :: PortID -> HostName -> IO Handle
client port ip
    = do h <- connectTo ip port
         hSetBuffering h LineBuffering
	 return h

server :: PortID -> IO Handle
server port
    = do putStrLn "\nWaiting the connection..."
         serv <- listenOn port
	 (h, ip, _) <- accept serv
         putStrLn ("\nConnected! IP: " ++ show ip)
         hSetBuffering h LineBuffering
	 return h

send :: Handle -> String -> IO ()
send = hPutStrLn

read' :: Handle -> IO String
read' h
    = do putStrLn "\nWaiting the other player's move..."
         hGetLine h
