/* Copyright (C) 2002 Asfand Yar Qazi.

 This file is part of XBobble.

    XBobble is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    XBobble is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with XBobble; if not, write to the Free Software Foundation,
    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA */

/** @file Ambient_Effects_Manager.hh The Ambient_Effects_Manager! */

#ifndef XBOBBLE_AMBIENT_EFFECTS_MANAGER_HH
#define XBOBBLE_AMBIENT_EFFECTS_MANAGER_HH

#include <ayq/stdint.h>
#include "Video_Output_Manager.hh"
#include "Game_Element.hh"
#include "util.hh"

namespace XBobble
{

class Game;

/// Plays effects that have no interaction from the user, just to look
/// nice.  Sounds, animation, etc.
class Ambient_Effects_Manager : public Game_Element, public Video_Data
{
public:
	/// Init ambient_effects_manager
	Ambient_Effects_Manager(Game::Impl&);

private:
	void
	tock_handler(uint32_t tocks_passed);

	void
	tick_handler(uint32_t delta);

	void
	sync_tick_handler(uint32_t delta);

	/// Draws the ambient_effects_manager
	void
	draw_handler() const;

	/// Handle drawing on/off
	void
	enable_drawing_handler(bool);

	/// Enable/disable video_data according to tock_funcs state
	void
	enable_tock_funcs_handler(bool arg)
	{
		enable_drawing(arg);
	}

	class Impl;

	Impl* impl;

}; // class Ambient_Effects_Manager



} // namespace XBobble


#endif // #define XBOBBLE_AMBIENT_EFFECTS_MANAGER_HH
