/* Copyright (C) 2002 Asfand Yar Qazi.

 This file is part of XBobble.

    XBobble is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    XBobble is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with XBobble; if not, write to the Free Software Foundation,
    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA */

/** @file Ball.cc @see Ball.hh @see Ball_Trait.hh */

#include "Ball.hh"
#include "Ball_Trait.hh"
#include "Game_Manager.hh"
#include "Video_Output_Manager.hh"
#include <SDL_opengl.h>
#include <iostream>

namespace XBobble
{

Ball::Ball(std::size_t argtrait,
	   float pos_x, float pos_y,
	   float vel_x, float vel_y)
 : trait(argtrait),
   pos(pos_x, pos_y), vel(vel_x, vel_y)
{
}

Ball::Ball(std::size_t argtrait, const V2D& argpos, const V2D& argvel)
 : trait(argtrait), pos(argpos), vel(argvel)
{
}

} // namespace XBobble

